-- ============================================================================
-- Propiedad Expansion Rollback Script
-- ============================================================================
-- Purpose: Restore propiedad table to state before expansion
-- Author: Claude Code (Thoth's Algorithm)
-- Date: 2025-01-02
--
-- WARNING: This will DELETE all expanded rows and restore original state
--
-- Usage:
--   mysql -u root -p --socket=/lamp/mysql/mysql.sock quantix < 03_rollback_propiedad_expansion.sql
--
-- IMPORTANT: Only run this if expansion needs to be undone!
-- ============================================================================

-- Verify backup exists
SELECT COUNT(*) as backup_rows,
       'Backup exists - ready to rollback' as status
FROM propiedad_backup_20250102;

-- Step 1: Drop current propiedad table
DROP TABLE IF EXISTS propiedad;

-- Step 2: Recreate propiedad table structure (without expansion fields)
CREATE TABLE propiedad LIKE propiedad_backup_20250102;

-- Step 3: Restore data from backup
INSERT INTO propiedad SELECT * FROM propiedad_backup_20250102;

-- Step 4: Verify restoration
SELECT COUNT(*) as restored_rows,
       'Rollback complete - original 114 rows restored' as status
FROM propiedad;

-- Step 5: Show sample data to confirm
SELECT propiedad_id, nombre_propiedad, num_deptos
FROM propiedad
ORDER BY num_deptos DESC
LIMIT 10;

-- Optional: Keep backup for audit trail
-- To remove backup after verification:
-- DROP TABLE propiedad_backup_20250102;

SELECT '✅ Rollback complete!' as final_status;
SELECT 'Note: Backup table propiedad_backup_20250102 still exists for safety' as note;
SELECT 'To remove backup: DROP TABLE propiedad_backup_20250102;' as cleanup_command;
