//var informcion de fecha
const fechaNumero = document.getElementById('fechaNumero');
const fechaTexto = document.getElementById('fechaTexto');
const fechaMes = document.getElementById('fechaMes');
const fechaAño = document.getElementById('fechaAño');

//var tareas contenedor
const contenedorTareas = document.getElementById('contenedorTareas');

const setDate = () =>{
    const date = new Date();
    fechaNumero.textContent = date.toLocaleString('es',{day:'numeric'});
    fechaTexto.textContent = date.toLocaleString('es',{weekday:'long'});
    fechaMes.textContent = date.toLocaleString('es',{month:'short'});
    fechaAño.textContent = date.toLocaleString('es',{year:'numeric'});
};

const agregaNuevaTarea = event =>{
    event.preventDefault();
    const {value} = event.target.textoTarea;
    if(!value) return;
    const tarea = document.createElement('div');
    tarea.classList.add('tarea','bordeRedondo');
    tarea.addEventListener('click', changeTaskState)
    tarea.textContent = value;
    contenedorTareas.prepend(tarea);
    event.target.reset();
};

const changeTaskState = event => {
    event.target.classList.toggle('confirmado');
};
 
const order = () => {
    const confirmado = [];
    const toDo= [];
    contenedorTareas.childNodes.forEach( el =>{
        el.classList.contains('confirmado') ? confirmado.push(el) :toDo.push(el)
    });
    return[...toDo,...confirmado];
}

const renderizarTareasOrdenadas = () => {
    order().forEach(el => contenedorTareas.appendChild(el))
}

setDate();