<?php
/**
 * a phpinfo script with a simple summary & extra simple settings to review
 *
 * 2021-08-02
 */
/*
$p = ini_set('precision', 17);
echo "<li>" . (round(6.677321269973708, 2)) ; // change presicion to 17
ini_set('precision', $p);
*/

print_r($_REQUEST);

echo <<< SUMMARY_STYLES
    <style>
        .extra_info {line-height:1.8em;margin:1em 1em;padding:1em;display:table-cell;background-color:whitesmoke;
            border:2px white outset;
        }
        .extra_info ul {border:2px white inset; padding-right:0.5em}
        @media only screen and (min-width: 800px)  { 
            .extra_info {border:4px white outset; }        
            .extra_info ul {column-count: 2;column-gap: 2em; border:4px white inset}
        }
        .extra_info ul li {margin-bottom:0.5em;}
        .extra_info ul li a {background-color:transparent; text-decoration: underline}
        .extra_info ul li a:visited {background-color:transparent; text-decoration: underline}
        .extra_info_alert {color:red}
        SUMMARY {color:darkgreen;cursor:pointer}
        .borderInset1 {border:1px white inset;}
    </style>
SUMMARY_STYLES;

    clearstatcache(true, __DIR__ .'/../showErrors.vin');
    $isDevelopment = file_exists(__DIR__ .'/../showErrors.vin');
    phpIniSummary($isDevelopment);
    echo "<div id='phpinfo'><hr></div>";
    phpinfo();
    
function phpIniSummary(bool $isDevelopment) {
    echo "<div class='extra_info'><ul>";

    if(function_exists('phpversion'))
        try {
            echo "<li><b>php version: </b>" . phpversion() . "  <a href='#phpinfo'>Jump to PhpInfo</a></li>";
        } catch (Throwable $_) {}

    if(function_exists('get_current_user'))
        try {
            echo "<li><b>php's User:</b> " . get_current_user() . "</li>";
        } catch (Throwable $_) {
            echo "<li>>Php's User:  ?</li>";
        }

    if(function_exists('php_sapi_name'))
        try {
            echo "<li><b>sapi: </b>" . php_sapi_name() . "</li>";
        } catch (Throwable $_) {}

    if(function_exists('php_uname'))
        try {
            echo "<li><b>uname: </b>" . php_uname() . "</li>";
        } catch (Throwable $_) {}




    try {
        echo "<li><b>php.ini:</b> " . php_ini_loaded_file() . ' ' . php_ini_scanned_files() . "</li>";
    } catch (Throwable $_) {
        echo "<li>>php.ini: ?</li>";
    }

    echo phpIniAdvice($isDevelopment);


    try {
        echo "<li><b>temporary files:</b> " . sys_get_temp_dir(). "</li>";
    } catch(Throwable $_) {}
    try {
        echo "<li><b>document root:</b> " . $_SERVER['DOCUMENT_ROOT'] . "</li>";
    } catch(Throwable $_) {}

    echo phpIniShowSettings();


    try {
        echo "<li><b>realpath_cache:</b>" .
            " Size: " . ini_get('realpath_cache_size') . " defined" .
            " / " . realpath_cache_size() . " used" .
            ", Entries: " . number_format(count(realpath_cache_get()), 0, '', ',') .
            ", ttl: " . ini_get('realpath_cache_ttl') . " sec" .
            "</li>";
    } catch (Throwable $_) {echo "<li>realpath_cache:  ? </li>";}

    $requestOrder = ini_get('request_order');
    $variables_order = ini_get('variables_order');
    try {
        echo "<li><b>Variables order: </b>" .
            str_ireplace('E', '<span style="color:red">E</span>span>', $variables_order) .
            " <b>Request order: </b>" .
            (strcasecmp('GP', $requestOrder) ? "<span style='color:red'>$requestOrder</span>" : $requestOrder) .
            "</li>";
    } catch (Throwable $_) {
        echo "<li>Variables order &amp; Request order: ?</li>";
    }
    if (!empty($_ENV) || stripos($variables_order, 'e') !== false)
        try {
            echo "<li><details><summary>Enviroment variables</summary><pre class='borderInset1'>" . print_r($_ENV, true) . "</pre></details></li>";
        } catch (Throwable $_) {}

    // @TODO tiene Suhosin? o Snuffleupagus? mod_security
    // @TODO error reporting value not zero not E_NONE


    if(empty(ini_get('opcache.jit_buffer_size')))
        echo "<li><b>Jit: </b> <span class='extra_info_alert'>Disabled, opcache.jit_buffer_size = 0</span></li>";
    $jit = ini_get('opcache.jit');
    if(empty($jit) || strcasecmp($jit, 'disable') === 0 || strcasecmp($jit, 'off') === 0 )
        echo "<li><b>Jit: </b> <span class='extra_info_alert'>" .
            (empty($jit) ? "- not set -" : $jit) .
            "</span></li>";
    else
      echo "<li><b>Jit: </b> $jit, hot func = " . ini_get('opcache.jit_hot_func') .
          ", hot return = " .   ini_get('opcache.jit_hot_return') . "</li>";

    clearstatcache(__DIR__ . '/opcache.php');
    if (!extension_loaded('Zend OPcache'))
        echo "<li><b>OpCache: </b> <span class='extra_info_alert'>not loaded</span></li>";
    elseif(empty(ini_get('opcache.enable')))
        echo "<li><b>OpCache: </b> <span class='extra_info_alert'>Off</span></li>";
    elseif(file_exists(__DIR__ . '/opcache.php'))
        echo "<li><a href='opcache.php' target='_blank'>OpCache &amp; Jit Monitor</a></li>";
    else
        echo "<li><a href='https://github.com/amnuts/opcache-gui' target='_blank'>Get OpCache &amp; Jit Monitor</a>";
    echo "</ul></div>";
}

function phpIniAdvice(bool $isDevelopment) {

    $response = [];
    $shouldBeOff = [
        'auto_append_file',
        'auto_prepend_file',
        'allow_url_include',
        'allow_url_fopen',
        'enable_dl',
        'expose_php',


        'implicit_flush',

        'mysqli.reconnect',
        'mysqlnd.collect_statistics',

        'session.auto_start',
        'session.use_trans_sid',

    ];

    $shouldBeOn = [
        'auto_globals_jit',
        'enable_post_data_reading',
        'file_uploads',

        'engine',
        'ignore_repeated_errors',
        'log_errors',
        'report_memleaks',

        'cgi.force_redirect',

        'opcache.enable',
        'opcache.enable_cli',
        'opcache.use_cwd',
        'opcache.revalidate_path',
        'opcache.save_comments',


        'session.use_cookies',
        'session.use_only_cookies',

    ];

    if($isDevelopment) {
        $shouldBeOn[] = 'display_errors';
    } else {
        $shouldBeOff[] = 'display_errors';
    }
    foreach($shouldBeOff as $iniSetting) {
        if(!empty(ini_get($iniSetting)))
            $response[] = "<i>$iniSetting:</i> recommended Off";
    }
    foreach($shouldBeOn as $iniSetting) {
        if(empty(ini_get($iniSetting)))
            $response[] = "<i>$iniSetting:</i> recommended On";
    }

    $shouldBeValue = [
        'arg_separator.input' => '&',
        'default_charset' => "UTF-8",
    ];
    foreach($shouldBeValue as $iniSetting => $value)
        if(strcasecmp(ini_get($iniSetting), $value))
            $response[] = "<i>$iniSetting:</i> expecting '" .  htmlentities($value) .
                "' found: '" .
                htmlentities(ini_get($iniSetting)) ."'";

    if(empty($response))
        return '';
    return "<li><details><summary>php.ini review:</summary><div  class='borderInset1'><ol class='compact'><li>" .
        implode('<li>', $response) .
        "</ol></div></details>";
}

function phpIniShowSettings() {
    $response = [];
    $displayString = [
        'doc_root',
        'session.save_path',

        ' cgi.force_redirect',

        'error_log',
        'opcache.error_log',


        'open_basedir',
        'include_path',
        'upload_tmp_dir',



        'user_ini.cache_ttl',
        'user_ini.filename',

        'default_charset',
        'disable_functions',
        'disable_classes',

    ];
    foreach($displayString as $iniSetting)
        if(!empty(ini_get($iniSetting)))
            $response[] = "<li><b>$iniSetting: </b> " . htmlentities(ini_get($iniSetting)) . "</li>";
    return implode("", $response);
}

function opCacheReport() {
    // reporta solo situaciones: disabled, full, restart(ing),low memory, low keys
    $spanAlert = '<span style="color:red">';
    $spanAlertEnd = '</span>';

    $status = opcache_get_status(false);
    if(!$status["opcache_enabled"]) {
        return '<span style="color:red">' . "Disabled" . $spanAlertEnd;
    }

    $response = [];
    if($status["cache_full"])
        $response[] = '<span style="color:red">' . "Cache Full" . $spanAlertEnd;
    if($status["restart_pending"])
        $response[] = '<span style="color:red">' . "Restart Pending" . $spanAlertEnd;
    if($status["restart_in_progress"])
        $response[] = '<span style="color:red">' . "Restart in Progress" . $spanAlertEnd;

    $usedMemory =$status['memory_usage']["used_memory"];
    $freeMemory =$status['memory_usage']["free_memory"];


}

function humanize($bytes, $decimals = 2){
    $size=array('B','KB','MB','GB','TB','PB','EB','ZB','YB');
    $factor=floor((strlen($bytes)-1)/3);
    return sprintf("%.{$decimals}f",$bytes/pow(1024,$factor)).' '.$size[$factor];
}

/** number with byte units b, kb, mb, ... to number
 *
 * @param string|int|float $size ie '4Mb'
 * @return int|float
 */
function toNum($size) {
    static $powers = [
        'B' => 0,
        ''  => 0,
        'K' => 1,
        'KB' => 1,
        'M' => 2,
        'MB' => 2,
        'G' => 3,
        'GB' => 3,
        'T' => 4,
        'TB' => 4,
        'P' => 5,
        'PB' => 5,
        'E' => 6,
        'EB' => 6,
        'Z' => 7,
        'ZB' => 7,
        'Y' => 8,
        'YB' => 8,
    ];
    $units = '';
    foreach( str_split( substr(rtrim($size, " \n\r\t\v\0.,"), -2)) as $u )
        if(!is_numeric($u))
            $units .=  $u;
    $number = str_replace([',', $units], '', trim($size));
    return $number * pow(1024,   $powers[strtoupper($units)] ?? 0);
}
