<!doctype html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport"
          content="width=device-width, user-scalable=no, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>CompareDate</title>


</head>
<body>
<div style="background-color: white;padding:2em;display:flex;flex-direction: row;flex-wrap: wrap;gap:0.5em;align-items: center;justify-content: center;">

    <style>
        .compCard {
            width:fit-content;
            margin:0; padding:0.2em 0.5em;
            border: 1px solid teal;
            box-shadow: teal 4px 0 0 0;
            background-color: white; color:teal;
        }
        .compCardHeader {
            display: flex;
            justify-content: space-between;
            align-items: center;
            flex-wrap: wrap;
            gap: 0.5em;
            margin-bottom: 0.5em;
        }
        .compCardbuttons {
            display: flex;
            justify-content: space-between;
            align-items: center;
            flex-wrap: wrap;
            gap: 0.5em;
            background-color: white; color:teal;
        }
        .compBotton {
            border-radius: 0;
            color:teal;
            margin:0;
            cursor:pointer;
        }
        .compCardSelect {
            border:1px teal solid;
            border-radius: 0;
            color:teal;
        }
        .compCardBody {
            display: flex;
            justify-content: space-between;
            align-items: stretch;
            flex-wrap: wrap;
            gap: 0.5em;
            background-color: white; color:teal;
        }
    </style>

    <div class="compCard" id="tarjetaUno">
        <div class="compCardHeader">
            <div class="compCardbuttons">
                <button data-move="first" class="compBotton" title="First">⏮</button>
                <button data-move="previous" class="compBotton" title="Previous">◀</button>
                <span class="date-range">-</span>
                <button class="compBotton" title="Calendar">📅</button>
                <button data-move="next" class="compBotton" title="Next">▶</button>
                <button data-move="last" class="compBotton" title="Last">⏭</button>
            </div>
            <div class="filters">
                <select data-period class="compCardSelect">
                    <option value="daily">Diaria</option>
                    <option value="weekly" selected>Semanal</option>
                    <option value="monthly">Mensual</option>
                    <option value="yearly">Anual</option>
                </select>
                <select data-units class="compCardSelect">
                    <option value="rollos" selected>Rollos</option>
                    <option value="kilos">Kilos</option>
                    <option value="cost">Cost</option>
                </select>
            </div>
        </div>
        <div class="compCardBody" style="border-top:1px teal inset">
            <div class="valorActual">
                <div style="color:blue;font-weight:bold">-</div>
                <div style="font-weight:100;font-size:0.85em;white-space: nowrap">-</div>
            </div>
            <div class="semanaPrevia">
                <div style="color:green">-</div>
                <div style="font-weight:200;font-size:0.85em;color:blue">-</div>
                <div style="font-weight:100;font-size:0.95em;text-align: center;white-space: nowrap">-</div>
            </div>
            <div class="añoAnterior">
                <div style="color:red">-</div>
                <div style="font-weight:100;font-size:0.85em;color:blue">-</div>
                <div style="font-weight:100;font-size:0.95em;text-align: center;white-space: nowrap">-</div>
            </div>
        </div>
    </div>

    <script>
        class CompareDated {
            constructor(card) {
                this.card = card;
                this.currentDate = this.today();
                this.initEvents();
                this.updateCard();
            }

            today() {
                const d = new Date();
                return `${d.getFullYear()}-${String(d.getMonth()+1).padStart(2,'0')}-${String(d.getDate()).padStart(2,'0')}`;
            }

            ymdToDate(ymd) {
                const [y,m,d] = ymd.split('-').map(Number);
                return new Date(y,m-1,d);
            }

            dateToYmd(date) {
                return `${date.getFullYear()}-${String(date.getMonth()+1).padStart(2,'0')}-${String(date.getDate()).padStart(2,'0')}`;
            }

            addDays(ymd,days){
                const d = this.ymdToDate(ymd);
                d.setDate(d.getDate() + days);
                return this.dateToYmd(d);
            }

            addMonths(ymd,months){
                const d = this.ymdToDate(ymd);
                d.setMonth(d.getMonth() + months);
                return this.dateToYmd(d);
            }

            addYears(ymd,years){
                const d = this.ymdToDate(ymd);
                d.setFullYear(d.getFullYear() + years);
                return this.dateToYmd(d);
            }

            currentPeriod(){
                return this.card.querySelector('[data-period]').value;
            }

            currentDateMove(moveTo){
                const period = this.currentPeriod();
                if(moveTo==="previous") {
                    if(period==="daily") this.currentDate = this.addDays(this.currentDate,-1);
                    if(period==="weekly") this.currentDate = this.addDays(this.currentDate,-7);
                    if(period==="monthly") this.currentDate = this.addMonths(this.currentDate,-1);
                    if(period==="yearly") this.currentDate = this.addYears(this.currentDate,-1);
                }
                if(moveTo==="next") {
                    if(period==="daily") this.currentDate = this.addDays(this.currentDate,1);
                    if(period==="weekly") this.currentDate = this.addDays(this.currentDate,7);
                    if(period==="monthly") this.currentDate = this.addMonths(this.currentDate,1);
                    if(period==="yearly") this.currentDate = this.addYears(this.currentDate,1);
                }
                this.updateCard();
            }

            randomBetween(min, max) {
                return Math.floor(Math.random() * (max - min + 1) + min);
            }

            updateCard(){
                const dateRange = this.card.querySelector('.date-range');
                dateRange.textContent = `Desde ${this.currentDate}`;

                const valorActual = this.randomBetween(1000, 3000);
                const previa = this.randomBetween(1000, 3000);
                const anterior = this.randomBetween(1000, 3000);
                const deltaPrev = ((valorActual - previa) / previa * 100).toFixed(1);
                const deltaAnt = ((valorActual - anterior) / anterior * 100).toFixed(1);

                const body = this.card.querySelector('.compCardBody');

                body.querySelector('.valorActual').innerHTML = `
                    <div style="color:blue;font-weight:bold">${valorActual}</div>
                    <div style="font-weight:100;font-size:0.85em;white-space: nowrap">${this.currentDate}</div>
                `;

                body.querySelector('.semanaPrevia').innerHTML = `
                    <div style="color:${deltaPrev>=0?'green':'red'}">${deltaPrev>=0?'▲':'▼'} ${deltaPrev}%</div>
                    <div style="font-weight:200;font-size:0.85em;color:blue">${previa}</div>
                    <div style="font-weight:100;font-size:0.95em;text-align: center;white-space: nowrap">Semana Previa</div>
                `;

                body.querySelector('.añoAnterior').innerHTML = `
                    <div style="color:${deltaAnt>=0?'green':'red'}">${deltaAnt>=0?'▲':'▼'} ${deltaAnt}%</div>
                    <div style="font-weight:100;font-size:0.85em;color:blue">${anterior}</div>
                    <div style="font-weight:100;font-size:0.95em;text-align: center;white-space: nowrap">Año Ant.</div>
                `;
            }

            initEvents(){
                const buttons = this.card.querySelectorAll('[data-move]');
                buttons.forEach(btn=>{
                    btn.addEventListener('click', e=>{
                        const moveTo = e.target.getAttribute('data-move');
                        if(moveTo==="previous"||moveTo==="next")
                            this.currentDateMove(moveTo);
                    });
                });

                const selects = this.card.querySelectorAll('[data-period],[data-units]');
                selects.forEach(sel=>{
                    sel.addEventListener('change', ()=>{
                        this.updateCard();
                    });
                });
            }
        }

        const cardUno = new CompareDated(document.getElementById('tarjetaUno'));
    </script>
</div>


</body>
</html>