// eslint.config.mjs
/*
Abrir una consola de DOS o power shell.
En el directorio de tu usuario correr:

    npm install -g eslint
    npm install -g globals
    npm install -g eslint-plugin-jquery
    npm install eslint-plugin-metrics

* Se recomienda actualizar npm, node y los paquetes arriba mencionados
* Puede ser buena idea borrar el cache y reiniciar el phpStorm (File->Invalidate Caches: palomearlos todos y restart)
* O sin el -g para que no sean globales
*/

import globals from 'globals';
import jquery from 'eslint-plugin-jquery';
import metrics from 'eslint-plugin-metrics';

export default [
    {
        languageOptions: {
            ecmaVersion: 2022,
            sourceType: "module",
            globals: {
                ...globals.browser,
                ...globals.jquery,
                $: "readonly",
                jQuery: "readonly"
            }
        },
        plugins: {
            jquery: jquery,
            metrics: metrics
        },
    }
];
