// eslint_syntax_only.config.mjs
/*
Abrir una consola de DOS o power shell.
En el directorio de tu usuario correr:

    npm install -g eslint
    npm install -g globals
    npm install -g eslint-plugin-jquery
    npm install -g eslint-plugin-metrics

Correr:
cd /wamp/www/vitex
eslint --config eslint_syntax_only.config.mjs --stats js2

* Se recomienda actualizar npm, node y los paquetes arriba mencionados, asi como ajustar al gusto los _config.mjs
* O sin el -g para que no sean globales
*/

// import globals from 'globals';
// import jquery from 'eslint-plugin-jquery';


export default [
    {
        languageOptions: {
            ecmaVersion: 2022,
            sourceType: "module",
        },
        rules: {
            // Essential Syntax Rules
            semi: "off",
            quotes: 'off',
            'no-extra-semi': 'off',
            'no-unused-vars': 'off',
            'no-undef': 'off',
            'no-unreachable': 'off',
            'no-constant-condition': 'off',
            'no-cond-assign': 'off',
            'no-extra-parens': 'off',

            // Disable Style-Related Rules
            indent: 'off',
            'max-len': 'off',
            'comma-dangle': 'off',
        }
    }
];
