<?php

use Iac\inc\sql\IacSqlBuilder;

class Balance {
    protected string $usdHoy;
    protected string $pasivoNegativo;
    protected array $tc = [];

    /**
     * @param float|string|null $usdHoy
     * @param bool $pasivoNegativo
     */
    public function __construct(float|string|null $usdHoy = null, bool $pasivoNegativo = true) {
        $this->usdHoy = $usdHoy ?? ia_singleread("SELECT tc FROM tc_log WHERE exitoso = 1 ORDER BY alta_db DESC LIMIT 1",null);
        $this->pasivoNegativo = $pasivoNegativo ? "-" : "";
    }

    public function balanceHoy($cifReport = false): array {
        $existencia = $cifReport ? $this->bodegaHoyReporte() : $this->bodegaHoy();
        return [
            ...$this->bancosHoy(),
            ...$this->inversionesHoy(),
            ...$existencia,
            ...$this->enElMarHoy(),
            ...$this->fiduciariosHoy(),
            ...$this->chequesHoy(),
            ...$this->pagaresHoy(),
            ...$this->manualHoy(),
            ...$this->valesHoy(),
            ...$this->depositos_pendientes(),
        ];
    }

    public function chequesHoy():array {
        $method = __METHOD__;
        $sql = "
            SELECT /*$method */
                'ASSETS' AS 'Balance Sheet',
                'Accounts Receivable' AS level_2,
                'Cheques' AS level_3,
                IF(m.moneda_id=2, 'En USD', 'En PESOS') AS level_4,
                IFNULL(c.nombre, 'De Paso') as Details,
                m.Moneda, e.Empresa, t.clave AS Tienda, IFNULL(cat.categoria, '?') AS Categoria, IFNULL(c.nombre, 'De Paso') as Cliente,
                SUM(IF(doc.moneda_id=2, quantity - total_payments, CONVERT((quantity - total_payments)/$this->usdHoy , DECIMAL(16,2)))) AS 'Saldo_USD',
                SUM(IF(doc.moneda_id=1, quantity - total_payments, CONVERT((quantity - total_payments)*$this->usdHoy , DECIMAL(16,2)))) AS 'Saldo_PESOS',
                SUM(quantity - total_payments) AS 'PESOS_USD'
            FROM cheque doc
                     LEFT OUTER JOIN categoria cat ON doc.categoria_id = cat.categoria_id
                     LEFT OUTER JOIN cliente c ON doc.cliente_id = c.cliente_id
                     LEFT OUTER JOIN tienda t ON IFNULL(doc.tienda_id,1) = t.tienda_id
                     LEFT OUTER JOIN empresa e ON IFNULL(t.empresa_id,1) = e.empresa_id
                     LEFT OUTER JOIN moneda m ON m.moneda_id = doc.moneda_id
            WHERE doc.paid = 0 AND doc.atrasado = 0 AND doc.super_atrasado = 0
            GROUP BY 1, 2, 3, IF(m.moneda_id=2, 'En USD', 'En PESOS'), IFNULL(c.nombre, 'De Paso'),
                m.Moneda, e.Empresa, t.clave, IFNULL(cat.categoria, '?'), IFNULL(c.nombre, 'De Paso')";
        return $this->query($sql);
    }

    public function pagaresHoy():array {
        $method = __METHOD__;
        $sql = "
        SELECT /*$method */ 
            'ASSETS' AS 'Balance Sheet',
            'Accounts Receivable' AS level_2,
            'Pagares' AS level_3, 
            IF(m.moneda_id=2, 'En USD', 'En PESOS') AS level_4,
            IFNULL(c.nombre, 'De Paso') as Details,
            m.Moneda, e.Empresa, t.clave AS Tienda, IFNULL(cat.categoria, '?') AS Categoria,
            SUM(IF(doc.moneda_id=2, quantity - total_payments, CONVERT((quantity - total_payments)/$this->usdHoy , DECIMAL(16,2)))) AS 'Saldo_USD',
            SUM(IF(doc.moneda_id=1, quantity - total_payments, CONVERT((quantity - total_payments)*$this->usdHoy , DECIMAL(16,2)))) AS 'Saldo_PESOS',
            SUM(quantity - total_payments) AS 'PESOS_USD',
            IFNULL(c.nombre, 'De Paso') as Cliente
            
        FROM pagare doc
            LEFT OUTER JOIN categoria cat ON doc.categoria_id = cat.categoria_id
            LEFT OUTER JOIN cliente c ON doc.cliente_id = c.cliente_id
            LEFT OUTER JOIN tienda t ON IFNULL(doc.tienda_id,1) = t.tienda_id
            LEFT OUTER JOIN empresa e ON IFNULL(t.empresa_id,1) = e.empresa_id
            LEFT OUTER JOIN moneda m ON m.moneda_id = doc.moneda_id
        WHERE doc.paid = 0 AND doc.atrasado = 0 AND doc.super_atrasado = 0
        GROUP BY 1, 2, 3,IF(m.moneda_id=2, 'En USD', 'En PESOS'), 5, 6, 7, IFNULL(cat.categoria, '?'), 
                 IFNULL(c.nombre, 'De Paso'), IFNULL(c.nombre, 'De Paso')";
        return $this->query($sql);
    }

    public function valesHoy():array {
        $method = __METHOD__;
        $sql = "
        SELECT /*$method */ 
            'LIABILITIES' AS 'Balance Sheet',
            'Accounts Payable' AS level_2,
            'Vales' AS level_3, 
            IF(m.moneda_id=2, 'En USD', 'En PESOS') AS level_4, 
            IFNULL(c.nombre, 'De Paso') as Details,
            m.Moneda, e.Empresa, t.clave AS Tienda, IFNULL(cat.categoria, '?') AS Categoria,
            
          {$this->pasivoNegativo}SUM(IF(doc.moneda_id=2, quantity - total_payments, CONVERT((doc.quantity - doc.total_payments)/$this->usdHoy , DECIMAL(16,2)))) AS 'Saldo_USD',
          {$this->pasivoNegativo}SUM(IF(doc.moneda_id=1, quantity - total_payments, CONVERT((doc.quantity - doc.total_payments)*$this->usdHoy , DECIMAL(16,2)))) AS 'Saldo_PESOS',
          {$this->pasivoNegativo}SUM(doc.quantity - doc.total_payments) AS 'PESOS_USD',
            
            IFNULL(c.nombre, 'De Paso') as Cliente
        FROM vale doc
            LEFT OUTER JOIN categoria cat ON doc.categoria_id = cat.categoria_id
            LEFT OUTER JOIN cliente c ON doc.cliente_id = c.cliente_id
            LEFT OUTER JOIN tienda t ON IFNULL(doc.tienda_id,1) = t.tienda_id
            LEFT OUTER JOIN empresa e ON IFNULL(t.empresa_id,1) = e.empresa_id
            LEFT OUTER JOIN moneda m ON m.moneda_id = doc.moneda_id
        WHERE doc.aplicado = 0 AND doc.atrasado = 0 AND doc.super_atrasado = 0
        GROUP BY 1,2,3,
            IF(m.moneda_id=2, 'En USD', 'En PESOS'), 
            IFNULL(c.nombre, 'De Paso'),
            m.Moneda, e.Empresa, t.clave, IFNULL(cat.categoria, '?'),
        IFNULL(c.nombre, 'De Paso') ";
        return $this->query($sql);
    }

    public function bancosHoy():array {
        $method = __METHOD__;
        $sql = "
        SELECT /*$method */ 
            'ASSETS' AS 'Balance Sheet',
            'Cash' AS level_2,
            'Bancos' AS level_3,
            IF(bc.tipo_inversion_empresa_privada = 'privada', 'Cuentas Privadas', 
                IF(m.moneda_id=2, 'En USD', 'En PESOS')) AS level_4,
            bc.nombre AS Details,
            m.Moneda, e.Empresa, 'OFI' AS Tienda, 
            IF(bc.tipo_inversion_empresa_privada = 'privada', 'RONY', 'EMPRESA') AS Categoria,
            IF(bc.moneda_id=2, bcs.saldo_actual, CONVERT(bcs.saldo_actual/$this->usdHoy, DECIMAL(16,2) )) AS 'Saldo_USD',
            IF(bc.moneda_id=1, bcs.saldo_actual, CONVERT(bcs.saldo_actual*$this->usdHoy, DECIMAL(16,2) )) AS 'Saldo_PESOS',
            bcs.saldo_actual AS 'PESOS_USD',
            b.Banco, bc.nombre AS Cuenta
        FROM banco_cuenta bc
            LEFT OUTER JOIN banco_cuenta_saldos bcs ON bcs.banco_cuenta_id = bc.banco_cuenta_id
            LEFT OUTER JOIN banco b ON bc.banco_id = b.banco_id
            LEFT OUTER JOIN empresa e ON bc.empresa_id = e.empresa_id
            LEFT OUTER JOIN moneda m ON m.moneda_id = bc.moneda_id
        WHERE bc.vale = 'Active'";
        return $this->query($sql);
    }

    public function depositos_pendientes():array {
        $method = __METHOD__;
        global $gIAParametros;
        $sql =
          "SELECT /*$method*/
                'LIABILITIES' AS 'Balance Sheet',
                'Accounts Payable' AS level_2,
                'Depositos Pendientes' AS level_3,
                IF(bc.tipo_inversion_empresa_privada = 'privada', 'Cuentas Privadas', IF(m.moneda_id=2, 'En USD', 'En PESOS')) AS level_4,
                bc.nombre AS Details, m.Moneda, e.Empresa, IFNULL(bcm.cliente, 'N/A') as Cliente,
                IF(bc.tipo_inversion_empresa_privada = 'privada', 'RONY', 'EMPRESA') AS Categoria, b.Banco, bc.nombre AS Cuenta,
                -SUM(IF(bc.moneda_id=2, bcm.deposit, CONVERT(bcm.deposit/$this->usdHoy, DECIMAL(16,2) )  )) AS 'Saldo_USD',
                -SUM(IF(bc.moneda_id=1, bcm.deposit, CONVERT(bcm.deposit*$this->usdHoy, DECIMAL(16,2) )  )) AS 'Saldo_PESOS',
                -SUM(bcm.deposit) AS 'PESOS_USD'
          FROM banco_cuenta_mov bcm
            JOIN banco_cuenta bc ON bc.banco_cuenta_id = bcm.banco_cuenta_id
            JOIN banco b ON bc.banco_id = b.banco_id
            JOIN empresa e ON bc.empresa_id = e.empresa_id
            JOIN moneda m ON m.moneda_id = bc.moneda_id
        WHERE bcm.es = 'Deposito' AND bcm.link_vale = 'Q' AND bc.banco_cuenta_id NOT IN(0,$gIAParametros[banco_cuenta_poner_deposito_ND])
        GROUP BY 1,2,3,IF(bc.tipo_inversion_empresa_privada = 'privada', 'Cuentas Privadas', IF(m.moneda_id=2, 'En USD', 'En PESOS')),
                bc.nombre, m.Moneda, e.Empresa, IFNULL(bcm.cliente, 'N/A'),
                IF(bc.tipo_inversion_empresa_privada = 'privada', 'RONY', 'EMPRESA'),b.Banco, bc.nombre ";
        return $this->query($sql);
    }

    public function inversionesHoy():array {
        $method = __METHOD__;
        $sql = "
        SELECT /*$method  */ 
            'ASSETS' AS 'Balance Sheet',
            'Cash' AS level_2,
            'Investments' AS level_3,
            IF(bc.tipo_inversion_empresa_privada = 'privada', 'Cuentas Privadas', 
            IF(m.moneda_id=2, 'En USD', 'En PESOS')) AS level_4,
            bc.nombre AS Details,
            m.Moneda, e.Empresa, 'OFI' AS Tienda, 
            IF(bc.tipo_inversion_empresa_privada = 'privada', 'RONY', 'EMPRESA') AS Categoria,
            IF(bc.moneda_id=2, bcs.inversion_all, CONVERT(bcs.inversion_all/$this->usdHoy, DECIMAL(16,2))) AS 'Saldo_USD',
            IF(bc.moneda_id=1, bcs.inversion_all, CONVERT(bcs.inversion_all*$this->usdHoy, DECIMAL(16,2))) AS 'Saldo_PESOS',
            bcs.inversion_all as 'PESOS_USD', 
            b.Banco, bc.nombre as Cuenta
        FROM banco_cuenta bc
            LEFT OUTER JOIN banco_cuenta_saldos bcs ON bcs.banco_cuenta_id = bc.banco_cuenta_id
            LEFT OUTER JOIN banco b ON bc.banco_id = b.banco_id
            LEFT OUTER JOIN empresa e ON bc.empresa_id = e.empresa_id
            LEFT OUTER JOIN moneda m ON m.moneda_id = bc.moneda_id
        WHERE bc.vale = 'Active'";
        return $this->query($sql);
    }

    public function fiduciariosHoy():array {
        $method = __METHOD__;
        $sql =
          "
            SELECT /*$method*/
                'ASSETS' AS 'Balance Sheet',
                'Accounts Receivable' AS level_2,
                'Fiduciario' AS level_3,
                'En PESOS' AS level_4,
                 e.empresa AS 'Details',
                'PESOS' AS Moneda, 
                e.Empresa,
                'OFI' AS Tienda, 
                'EMPRESA' AS Categoria,
                SUM(CONVERT(saldo/$this->usdHoy, DECIMAL(16,2)))  AS 'Saldo_USD',
                SUM(saldo)  AS 'Saldo_PESOS',
                SUM(saldo) AS 'PESOS_USD'
            FROM fiduciario fid
                LEFT OUTER JOIN empresa e ON e.empresa_id = fid.empresa_id
            WHERE fid.terminado = 'No'
            GROUP BY 1, 2, 3, 4, 5, 6, 7, 8, 9";
        return $this->query($sql);
    }

    public function archiva() {
        $method = __METHOD__;
        $fiduciarioDate = ia_singleread("SELECT /*$method*/ MAX(fecha) FROM balance WHERE tema = 'fiduciario'", "2015-01-01");
        if(empty($fiduciarioDate))
            $fiduciarioDate = "2015-01-01";
        $this->fiduciarioArchiva($fiduciarioDate);
        bodega_x_dia_cache();
        $this->bodegaArchivaViejos();
    }

    protected function fiduciarioArchiva($min_fecha_retiro = '2000-01-01'): bool {
        global $gStrIt;
        $fiduciario = [];
        $intervalDaily = new DateInterval("P1D");
        $method  = __METHOD__;
        $sql =
          "
        SELECT /*$method*/ fid.fecha_retiro, fid.fecha_terminado, e.Empresa, monto_retiro AS 'Saldo_USD', monto_retiro AS 'Saldo_PESOS' , monto_retiro AS 'PESOS_USD'
        FROM fiduciario fid
            LEFT OUTER JOIN empresa e ON e.empresa_id = fid.empresa_id
        WHERE fid.fecha_retiro >= {$gStrIt($min_fecha_retiro)} OR fid.fecha_terminado IS NULL";
        $hoy = Date("Y-m-d 23:59:59");
        foreach(ia_sqlArrayIndx($sql) as $d) {
            $empresa = $d['Empresa'];
            $f = [
              'level_1' => 'ASSETS', 'level_2' => 'Accounts Receivable', 'level_3' => 'Fiduciario', 'level_4' => 'En PESOS', 'Details' => $empresa,
              'Empresa' => $empresa, 'Moneda' => 'PESOS', 'Tienda'=>'OFI', 'Categoria' => 'EMPRESA'
            ];
            $uq = md5(implode("\t", $f));
            $startDate = DateTimeImmutable::createFromFormat("Y-m-d H:i:s", "$d[fecha_retiro] 00:00:00");
            $fin = empty($d['fecha_terminado']) ? $hoy : "$d[fecha_terminado] 00:00:00";
            $endDate = DateTimeImmutable::createFromFormat("Y-m-d H:i:s", $fin);
            $datePeriod = new DatePeriod($startDate, $intervalDaily, $endDate, DatePeriod::INCLUDE_END_DATE);
            foreach($datePeriod as $date) {
                $fecha = $date->format("Y-m-d");
                $f['Saldo_USD'] = bcmul($d['Saldo_USD'], $this->getTc($fecha), 2);
                $f['Saldo_PESOS'] = $d['Saldo_PESOS'];
                $f['PESOS_USD'] = $d['PESOS_USD'];

                if(!array_key_exists($fecha, $fiduciario)) {
                    $fiduciario[$fecha][$uq] = $f;
                    continue;
                }
                if(!array_key_exists($uq, $fiduciario[$fecha])) {
                    $fiduciario[$fecha][$uq] = $f;
                    continue;
                }
                $fiduciario[$fecha][$uq]['Saldo_USD'] = bcadd($fiduciario[$fecha][$uq]['Saldo_USD'], $f['Saldo_USD'], 2);
                $fiduciario[$fecha][$uq]['Saldo_PESOS'] = bcadd($fiduciario[$fecha][$uq]['Saldo_PESOS'], $f['Saldo_PESOS'], 2);
                $fiduciario[$fecha][$uq]['PESOS_USD'] = bcadd($fiduciario[$fecha][$uq]['PESOS_USD'], $f['PESOS_USD'], 2);
            }
        }
        $ok = false;
        $builder = new IacSqlBuilder();
        foreach($fiduciario as $fecha => $arr)
            foreach($arr as $uq => $d)
                $ok |= ia_query( $builder->insert(
                  "balance",
                  ['fecha' => $fecha, 'uq' => $uq, 'tema' => 'fiduciario', 'renglon' => json_encode($d, JSON_OPTIONS_FOR_MYSQL)],
                    TRUE, comment: $method
                ));
        return $ok;
    }

    protected function bodegaHoy(): array {

        $method = __METHOD__;
        $sql = "
            SELECT /*$method */
                'ASSETS' AS 'Balance Sheet',
                'Inventory' AS level_2,
                'Bodega' AS level_3,
                'En USD' AS level_4,
                b.Bodega AS Details,
                'USD' AS Moneda, e.Empresa, 'OFI' AS Tienda, 'EMPRESA' AS Categoria,
                
                SUM(
                      IF(pg.cost_variant = 'Diferentes' AND pb.color_id = '54bf6469e2cc850b11ec1c8e8e9a60a2',
                        CONVERT(pb.existencia_quantity * pcif.cost_cif_blanco, DECIMAL(16,2)),
                        CONVERT(pb.existencia_quantity * pcif.cost_cif, DECIMAL(16,2))
                      )
                ) as 'Saldo_USD',
                
                SUM(
                    IF(pg.cost_variant = 'Diferentes' AND pb.color_id = '54bf6469e2cc850b11ec1c8e8e9a60a2',
                    CONVERT(pb.existencia_quantity * pcif.cost_cif_blanco * $this->usdHoy , DECIMAL(16,2)),
                    CONVERT(pb.existencia_quantity * pcif.cost_cif * $this->usdHoy , DECIMAL(16,2))
                    )
                ) as 'Saldo_PESOS',
                
                SUM(
                    IF(pg.cost_variant = 'Diferentes' AND pb.color_id = '54bf6469e2cc850b11ec1c8e8e9a60a2',
                    CONVERT(pb.existencia_quantity * pcif.cost_cif_blanco, DECIMAL(16,2)) ,
                    CONVERT(pb.existencia_quantity * pcif.cost_cif, DECIMAL(16,2)) 
                    )
                ) as 'PESOS_USD',
                
                b.Grupo AS 'Grupo Bodega', b.Bodega
            FROM producto_bodega pb
                JOIN producto_general pg ON pb.producto_general_id = pg.producto_general_id
                JOIN producto_costs_bodega pcif ON pb.producto_general_id = pcif.producto_general_id AND pcif.fecha_fin IS NULL
                JOIN bodega b ON pb.bodega_id = b.bodega_id
                JOIN empresa e ON b.empresa_id = e.empresa_id
            GROUP BY 1, 2, 3, 4 ,5, 6,7, 8, e.Empresa,b.Grupo, b.Bodega";
        return $this->query($sql);
    }

    protected function bodegaHoyReporte(): array {

        $method = __METHOD__;
        $sql = "
            SELECT /*$method */
                'ASSETS' AS 'Balance Sheet',
                'Inventory' AS level_2,
                'Bodega' AS level_3,
                'En USD' AS level_4,
                b.Bodega AS Details,
                'USD' AS Moneda, e.Empresa, 'OFI' AS Tienda, 'EMPRESA' AS Categoria,
                
                IF(pg.cost_variant = 'Diferentes' AND pb.color_id = '54bf6469e2cc850b11ec1c8e8e9a60a2',
                     SUM(CONVERT(pb.existencia_quantity * pcif.cost_cif_blanco, DECIMAL(16,2))),
                    SUM(CONVERT(pb.existencia_quantity * pcif.cost_cif, DECIMAL(16,2))) 
                ) 
                as 'Saldo_USD',
                
                -- IF(pg.cost_variant = 'Diferentes' AND pb.color_id = '54bf6469e2cc850b11ec1c8e8e9a60a2',
                --     SUM(CONVERT(pb.existencia_quantity * pcif.cost_cif_blanco * $this->usdHoy, DECIMAL(16,2))), 
                    SUM(CONVERT(pb.existencia_quantity * pcif.cost_cif * $this->usdHoy, DECIMAL(16,2))) 
                -- ) 
                as 'Saldo_PESOS',
                
                -- IF(pg.cost_variant = 'Diferentes' AND pb.color_id = '54bf6469e2cc850b11ec1c8e8e9a60a2',
                --     SUM(CONVERT(pb.existencia_quantity * pcif.cost_cif_blanco, DECIMAL(16,2)) ),
                    SUM(CONVERT(pb.existencia_quantity * pcif.cost_cif, DECIMAL(16,2)) )
                -- ) 
                as 'PESOS_USD',
                
                
                b.Grupo AS 'Grupo Bodega', b.Bodega
            FROM producto_bodega pb
                     JOIN producto_general pg ON pb.producto_general_id = pg.producto_general_id
                     JOIN producto_costs_bodega_report pcif ON pb.producto_general_id = pcif.producto_general_id AND pcif.fecha_fin IS NULL
                     JOIN bodega b ON pb.bodega_id = b.bodega_id
                     JOIN empresa e ON b.empresa_id = e.empresa_id
            GROUP BY 1, 2, 3, 4 ,5, 6,7, 8, e.Empresa,b.Grupo, b.Bodega";
        return $this->query($sql);
    }
    protected function bodegaArchivaCamposKv():bool {
        $ok = FALSE;
        $dateInterval = new DateInterval("P1D");
        $method = __METHOD__;
        $fechas = ia_sqlKeyValue("
            SELECT /*$method*/ MAX(c2.fecha) as fecha_del, c1.fecha as fecha_al
            FROM campos_kv c1
                JOIN campos_kv c2 ON c2.fecha < c1.fecha
            WHERE c1.concepto LIKE 'B\t%' AND c2.concepto LIKE 'B\t%'
            GROUP BY c1.fecha
        ");
        $lastAl = end($fechas);
        $fechas[$lastAl] = Date('Y-m-d');
        foreach($fechas as $del => $al) {
            $bodegas = ia_sqlArrayIndx(
              "SELECT /*$method*/ concepto, valor 
                    FROM campos_kv 
                    WHERE concepto LIKE 'B\t%' AND fecha = " . strit($del)
            );
            $startDate = DateTimeImmutable::createFromFormat("Y-m-d 00:00:00", "$del 00:00:00");
            $endDate = DateTimeImmutable::createFromFormat("Y-m-d 00:00:00", "$al 00:00:00");
            $datePeriod = new DatePeriod($startDate, $dateInterval, $endDate, DatePeriod::INCLUDE_END_DATE);
            foreach($datePeriod as $date) {
                $fecha = $date->format("Y-m-d");

            }
        }
        return $ok;
    }

    protected function bodegaCamposKv2row($concepto, $valor):array {
        $method = __METHOD__;
        $d = explode("\t", $concepto);
        $bodega = $d[1];
        $data = ia_singletonFull(
          "SELECT /*$method*/ e.empresa, b.grupo 
                FROM bodega b JOIN empresa e ON e.empresa_id = b.empresa_id
                WHERE b.bodega = " .strit($bodega),
        );
        return [
          'Balance Sheet' => 'ASSETS',
          'level_2' => 'Inventory' ,
          'level_3' => 'Bodega',
          'level_4' => 'En USD',
          'Details' => $bodega,
          'Moneda' => 'USD',
          'Empresa' => $data['empresa'],
          'Tienda' => 'OFI',
          'Categoria' => 'EMPRESA',
          'Grupo Bodega' => $data['grupo'],
          'Bodega' => $bodega,
        ];
    }

    public function bodegaArchivaViejos() {
        $ok = false;
        $builder = new IacSqlBuilder();
        $method = __METHOD__;
        $sql = "SELECT /*$method*/ bd.fecha, bd.bodega, bd.Existencia_CIF_Today, b.bodega, b.grupo, e.empresa 
                FROM bodega_x_dia bd
                    LEFT OUTER JOIN bodega b ON b.bodega = bd.bodega
                    LEFT OUTER JOIN empresa e ON b.empresa_id = e.empresa_id
                WHERE fecha < '2024-02-15' ";
        foreach(ia_sqlArrayIndx($sql) as $d) {
            $row =  [
                'Balance Sheet' => 'ASSETS',
                'level_2' => 'Inventory' ,
                'level_3' => 'Bodega',
                'level_4' => 'En USD',
                'Details' => $d['bodega'],
                'Moneda' => 'USD',
                'Empresa' => $d['empresa'],
                'Tienda' => 'OFI',
                'Categoria' => 'EMPRESA',
                'Grupo Bodega' => $d['grupo'],
                'Bodega' => $d['bodega'],
            ];
            $uq = md5(implode("\t", $row));
            $row['Saldo_USD'] = $d['Existencia_CIF_Today'];
            $row['Saldo_PESOS'] = bcmul( $d['Existencia_CIF_Today'], $this->getTc($d['fecha']), 2);
            $row['PESOS_USD'] = $d['Existencia_CIF_Today'];
            $ok |= ia_query( $builder->insert(
              "balance",
              ['fecha' => $d['fecha'], 'uq' => $uq, 'tema' => 'bodega', 'renglon' => json_encode($row, JSON_OPTIONS_FOR_MYSQL)],
              TRUE, comment: $method
            ));
        }
        return $ok;
    }


    public function bodegaCampos_kvDate():string {
        $method= __METHOD__;
        return ia_singleread(
          "SELECT /*$method*/ alta_db FROM campos_kv WHERE concepto LIKE 'B\t%' ORDER BY fecha DESC LIMIT 1");
    }

    public function bodegaCampos_kv($cifReport = false):array {
        $return = [];
        $method= __METHOD__;
        $cifCost = $cifReport ? 'BR' : 'B';
        $fecha = ia_singleread(
          "SELECT /*$method*/ fecha FROM campos_kv WHERE concepto LIKE '$cifCost\t%' ORDER BY fecha DESC LIMIT 1");

        $bodegas = ia_sqlKeyValue(
          "SELECT /*$method*/ concepto, valor 
                FROM campos_kv
                WHERE fecha = '$fecha' AND concepto LIKE '$cifCost\t%'",
        );
        if($bodegas === false)
            return [];
        foreach($bodegas as $concepto => $valor) {
            $nombre = explode("\t", $concepto);
            $return[] = [
              'Balance Sheet' => 'ASSETS',
              'level_2' => 'Inventory',
              'level_3' => 'Bodega',
              'level_4' => 'En USD',
              'Details' => $nombre[1],
              'Moneda' => 'USD',
              'Tienda' => 'OFI',
              'Categoria' => 'EMPRESA',
              'Saldo_USD' => $valor,
              'Saldo_PESOS' => bcmul("$valor", "$this->usdHoy" , 2),
              'PESOS_USD' => $valor,
              'Bodega' => $nombre[1],
              'Grupo Bodega' => $nombre[2],
            ];
        }
        return $return;
    }

    public function bodega2campos_kv(?bool $cifReport = null):bool {
        $queries = [];
        $builder = new IacSqlBuilder();
        $builder->dontOnUpdateFieldName = [];
        if($cifReport === null || $cifReport === false) {
            $bodega = $this->bodegaHoy();
            foreach($bodega as $b) {
                $data = [
                  "concepto" => "B\t$b[Details]\t" . $b['Grupo Bodega'],
                  "valor" => $b['PESOS_USD'],
                  "fecha" => date("Y-m-d"),
                  "alta_db" => "CURRENT_TIMESTAMP"
                ];
                $queries[] = $builder->insert('campos_kv', $data, TRUE, comment: __METHOD__);
            }
        }
        if($cifReport === null || $cifReport) {
            $bodega = $this->bodegaHoyReporte();
            foreach($bodega as $b) {
                $data = [
                  "concepto" => "BR\t$b[Details]\t" . $b['Grupo Bodega'],
                  "valor" => $b['PESOS_USD'],
                  "fecha" => date("Y-m-d"),
                  "alta_db" => "CURRENT_TIMESTAMP",
                ];
                $queries[] = $builder->insert('campos_kv', $data, TRUE, comment: __METHOD__);
            }
        }
        return !ia_transaction($queries, __METHOD__);
    }

    public function enElMarHoy():array {
        $method = __METHOD__;
        $enElMar = str_replace([",", "$"], "",
          trim(ia_singleread(
            "SELECT /*$method*/ valor FROM campos_kv WHERE concepto='EN EL MAR' ORDER BY fecha DESC LIMIT 1")));
        return [[
            'Balance Sheet' => 'ASSETS',
            'level_2' => 'Inventory',
            'level_3' => 'En el Mar',
            'level_4' => 'En USD',
            'Moneda' => 'USD',
            'Tienda' => 'OFI',
            'Categoria' => 'EMPRESA',
            'Saldo_USD' => $enElMar,
            'Saldo_PESOS' => bcmul("$enElMar", "$this->usdHoy", 2),
            'PESOS_USD' => $enElMar,
        ]];
    }

    public function manualHoy():array {
        $manual = [];
        $method = __METHOD__;
        $sql =
          "
          WITH  /*$method*/  hoy AS
            (SELECT concepto, MAX(fecha) AS 'fecha'
                FROM campos_kv
                WHERE concepto LIKE 'M\t%'
                GROUP BY 1
            )
            SELECT kv.concepto, kv.valor
            FROM campos_kv kv
                JOIN hoy ON kv.concepto = hoy.concepto AND kv.fecha = hoy.fecha
            WHERE kv.concepto LIKE 'M\t%';
          ";
        $movs = ia_sqlArrayIndx($sql);
        foreach($movs as $m) {
            $levels = explode("\t", $m['concepto']);
            $manual[] = [
              'Balance Sheet' => $levels[1],
              'level_2' => $levels[2],
              'level_3' => $levels[3],
              'level_4' =>  $levels[4],
              'Moneda' => 'USD',
              'Tienda' => 'OFI',
              'Categoria' => 'Manual',
              'Saldo_USD' => $m['valor'],
              'Saldo_PESOS' => bcmul($m['valor'], "$this->usdHoy", 2),
              'PESOS_USD' => $m['valor'],

            ];
        }
        return $manual;
    }

    public function saveNow():bool {
        $extras = $this->balanceHoy();
        $data = [
          'fecha' => Date('Y-m-d'),
          'concepto' => 'Balance Diario',
          'valor' => array_sum(array_column($extras, "Saldo_USD") ) ?? '',
          'extras' => json_encode($extras, JSON_OPTIONS_FOR_MYSQL),
          'alta_db' => 'NOW()'
        ];
        return !ia_query(ia_insert('campos_kv', $data, autoOnUpdate: true));
    }

    protected function query($sql):array {
        $ret = ia_sqlArrayIndx($sql);
        if(is_array($ret))
            return $ret;
        return [];
    }

    protected function getTc($fecha) {
        if(array_key_exists($fecha, $this->tc))
            return $this->tc[$fecha];
        $method = __METHOD__;
        if(empty($this->tc))
            $this->tc = ia_sqlKeyValue("SELECT /*$method*/ DATE(alta_db), tc FROM tc_log WHERE exitoso=1 ORDER BY 1");
        if(array_key_exists($fecha, $this->tc))
            return $this->tc[$fecha];
        $this->tc[$fecha] = ia_singleread("SELECT /*$method*/ tc FROM tc_log WHERE  DATE(alta_db) <= ". strit($fecha) ." AND exitoso=1 ORDER BY 1 DESC LIMIT 1", 0);
        return $this->tc[$fecha];
    }

}
