<?php
namespace ia\Date;


use DateTimeInterface;

/**
 * DateFormatter
 *
 * Formats dates with days and month names with the same options as php Date or DateTime->formatter
 *
 * @version 1.0.2
 * @author
 * @copyright
 */
class DateFormatter {

    /** @var array $names array of short and long day and month names indexed by php date format letter */
    protected static $names = [
        // 'D3' => ['Dom', 'Lun', 'Mar', 'Mié', 'Jue', 'Vie', 'Sáb'],
        // 'D2' => ['Do', 'Lu', 'Ma', 'Mi', 'Ju', 'Vi', 'Sá'],
        'D' => ['Do', 'Lu', 'Ma', 'Mi', 'Ju', 'Vi', 'Sá'],
        'l' => ['Domingo', 'Lunes', 'Martes', 'Miércoles', 'Jueves', 'Viernes', 'Sábado'],
        'F' => ['', 'enero', 'febrero', 'marzo', 'abril', 'mayo', 'junio', 'julio', 'agosto', 'septiembre', 'octubre', 'noviembre', 'diciembre'],
        'M' => ['', 'Ene', 'Feb', 'Mar', 'Abr', 'May', 'Jun', 'Jul', 'Ago', 'Sep', 'Oct', 'Nov', 'Dic'],
    ];

/*
    public static function setShortDay($array) {self::$names['D']=$array;}

    public static function setLongDay($array) {self::$names['l']=$array;}

    public static function setShortMonth($array) {self::$names['M']=$array;}

    public static function setLongMonth($array) {self::$names['F']=$array;}

    public static function set_names($array) {
        self::$names = $array;
    }

    public static function set_spanish() {
        self::$names = [
            // 'D3' => ['Dom', 'Lun', 'Mar', 'Mié', 'Jue', 'Vie', 'Sáb'],
            // 'D2' => ['Do', 'Lu', 'Ma', 'Mi', 'Ju', 'Vi', 'Sá'],
            'D' => ['Do', 'Lu', 'Ma', 'Mi', 'Ju', 'Vi', 'Sá'],
            'l' => ['Domingo', 'Lunes', 'Martes', 'Miércoles', 'Jueves', 'Viernes', 'Sábado'],
            'F' => ['', 'enero', 'febrero', 'marzo', 'abril', 'mayo', 'junio', 'julio', 'agosto', 'septiembre', 'octubre', 'noviembre', 'diciembre'],
            'M' => ['', 'Ene', 'Feb', 'Mar', 'Abr', 'May', 'Jun', 'Jul', 'Ago', 'Sep', 'Oct', 'Nov', 'Dic'],
        ];
    }

    public static function set_english() {
        self::$names = [
            // 'D3' => ['Sun', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat'],
            // 'D2' => ['Su', 'Mo', 'Tu', 'We', 'Th', 'Fr', 'Sa'],
            'D' => ['Su', 'Mo', 'Tu', 'We', 'Th', 'Fr', 'Sa'],
            'l' => ['Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday'],
            'F' => ['', 'January', 'February', 'March', 'April', 'May', 'June', 'July', 'August', 'Septiember', 'Octuber', 'Noviember', 'Dicember'],
            'M' => ['', 'Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'],
        ];
    }

*/
    /**
     * format a date as Y-m-d H:i:s eg: 2019-01-31 03:06:05
     *
     * @param mixed $anyDate A timestamp or DateTime or parsable by strtotime Default now, ie: time()
     * @return string The formatted date
     */
    public static function ymd_dateTime($anyDate = null) {
        // @codeCoverageIgnoreStart
        if($anyDate === null) {
            return date('Y-m-d H:i:s');
        }
        // @codeCoverageIgnoreEnd

        if(is_numeric($anyDate)) {
            return date('Y-m-d H:i:s',$anyDate);
        }
        if($anyDate instanceof DateTimeInterface) {
            return $anyDate->format('Y-m-d H:i:s');
        }
        return date('Y-m-d H:i:s', strtotime($anyDate));
    }

    /**
     * format a date as Y-m-d eg: 2019-01-31
     *
     * @param mixed $anyDate A timestamp or DateTime or parsable by strtotime Default now, ie: time()
     * @return string The formatted date
     */
    public static function ymd_date($anyDate = null) {
        // @codeCoverageIgnoreStart
        if($anyDate === null) {
            return date('Y-m-d');
        }
        // @codeCoverageIgnoreEnd

        if(is_numeric($anyDate)) {
            return date('Y-m-d',$anyDate);
        }
        if($anyDate instanceof DateTimeInterface) {
            return $anyDate->format('Y-m-d');
        }
        return date('Y-m-d', strtotime($anyDate));
    }

    /**
     * format a date as d/M/Y G:i eg: 31/Ene/2019 3:14
     *
     * @param mixed $anyDate A timestamp or DateTime or parsable by strtotime Default now, ie: time()
     * @return string The formatted date
     */
    public static function short_dateTime($anyDate = null) {
        // @codeCoverageIgnoreStart
        if($anyDate === null) {
            return date('d').'/'.self::$names['M'][date('n')].'/'.date('Y G:i');
        }
        // @codeCoverageIgnoreEnd

        if(is_numeric($anyDate)) {
            return date('d',$anyDate).'/'.self::$names['M'][date('n',$anyDate)].'/'.date('Y G:i',$anyDate);
        }
        if($anyDate instanceof DateTimeInterface) {
            return $anyDate->format('d').'/'.self::$names['M'][$anyDate->format('n')].'/'.$anyDate->format('Y G:i');
        }
        $anyDate = strtotime($anyDate);
        return date('d', $anyDate).'/'.self::$names['M'][date('n',$anyDate)].'/'.date('Y G:i',$anyDate);
    }

    /**
     * format a date as d/M/Y eg: 31/Ene/2019
     *
     * @param mixed $anyDate A timestamp or DateTime or parsable by strtotime Default now, ie: time()
     * @return string The formatted date
     */
    public static function short_date($anyDate = null) {
        // @codeCoverageIgnoreStart
        if($anyDate === null) {
            return date('d/').self::$names['M'][date('n')].date('/Y');
        }
        // @codeCoverageIgnoreEnd

        if(is_numeric($anyDate)) {
            return date('d',$anyDate).'/'.self::$names['M'][date('n',$anyDate)].'/'.date('Y',$anyDate);
        }
        if($anyDate instanceof DateTimeInterface) {
            return $anyDate->format('d').'/'.self::$names['M'][$anyDate->format('n')].'/'.$anyDate->format('Y');
        }
        $anyDate = strtotime($anyDate);
        return date('d', $anyDate).'/'.self::$names['M'][date('n',$anyDate)].'/'.date('Y',$anyDate);
    }

    /**
     * Format a date with local names for days and months with the same format string as php date & DateTime->format
     *
     * @param string $format The format string as per php date and DateTime->format, default 'd/M/Y'
     * @param mixed $anyDate A timestamp or DateTime or parsable by strtotime Default now, ie: time()
     * @return string The formatted date
     */
    public static function dateFormat($format = 'd/M/Y', $anyDate = null) {
        // @codeCoverageIgnoreStart
        if($anyDate === null)  {
            $anyDate = time();
        }
        // @codeCoverageIgnoreEnd
        
        if($anyDate instanceof DateTimeInterface) {
            $values = ['w' => $anyDate->format('w'),'n' => $anyDate->format('n')];
            for($i=0,$len=strlen($format); $i<$len; ++$i) {
                $values[$format[$i]] = $anyDate->format($format[$i]);
            }
            return self::formatter($format, $values);
        }

        if(!is_numeric($anyDate)) {
            $anyDate = strtotime($anyDate);
        }
        if(is_numeric($anyDate)) {
            $values = ['w'=>date('w', $anyDate),'n'=>date('n', $anyDate)];
            for($i=0,$len=strlen($format); $i<$len; ++$i) {
                $values[$format[$i]] = date($format[$i], $anyDate);
            }
            return  self::formatter($format, $values);
        }
        return "$anyDate";
    }

    /**
     * Creates the formated date time string from the received date values
     *
     * @param string $format The format string as per php date and DateTime->format
     * @param array $dateTimeValues
     * @return string The formatted date
     */
    protected static function formatter($format, $dateTimeValues) {

        /** @var array $namesIndex php date format letter */
        $namesIndex = [
            'D' => 'w',
            'l' => 'w',
            'F' => 'n',
            'M' => 'n',
        ];

        $ret = '';
        $len = strlen($format);
        $i = 0;
        while($i < $len) {
            $c = $format[$i++];
            if(array_key_exists($c, $namesIndex)) {
                $ret .= self::$names[$c][$dateTimeValues[$namesIndex[$c]] ];
                continue;
            }


            switch( $c ) {
                case '\\':
                    if($i < $len) {
                        $ret .= $format[$i++];
                    }
                    break;
                case 'S':
                    $ret .=  '°';
                    break;
                default:
                    if(array_key_exists($c, $dateTimeValues)) {
                        $ret .= $dateTimeValues[$c];
                    }
                    // @codeCoverageIgnoreStart
                    else {
                        $ret .=  $c;
                    }
                // @codeCoverageIgnoreEnd

            }
        }
        return $ret;
    }

}