<?php

use Iac\inc\sql\IacSqlBuilder;

class Balance {
    protected string $usdHoy;
    protected string $pasivoNegativo;

    /**
     * @param float|string|null $usdHoy
     * @param bool $pasivoNegativo
     */
    public function __construct(float|string|null $usdHoy = null, bool $pasivoNegativo = true) {
        $this->usdHoy = $usdHoy ?? ia_singleread("SELECT tc FROM tc_log WHERE exitoso = 1 ORDER BY alta_db DESC LIMIT 1",null);
        $this->pasivoNegativo = $pasivoNegativo ? "-" : "";
    }

    public function balanceHoy(): array {
        return [
            ...$this->bancosHoy(),
            ...$this->inversionesHoy(),
            ...$this->bodegaCampos_kv(),
            ...$this->enElMarHoy(),
            ...$this->fiduciariosHoy(),
            ...$this->chequesHoy(),
            ...$this->pagaresHoy(),
            ...$this->manualHoy(),
            ...$this->valesHoy(),
        ];
    }

    public function chequesHoy():array {
        $method = __METHOD__;
        $sql = "
            SELECT /*$method */
                'ASSETS' AS 'Balance Sheet',
                'Accounts Receivable' AS level_2,
                'Cheques' AS level_3,
                IF(m.moneda_id=2, 'En USD', 'En PESOS') AS level_4,
                IFNULL(c.nombre, 'De Paso') as Details,
                m.Moneda, e.Empresa, t.clave AS Tienda, IFNULL(cat.categoria, '?') AS Categoria,
                SUM(IF(doc.moneda_id=2, quantity - total_payments, 
                CONVERT((quantity - total_payments)/$this->usdHoy , DECIMAL(16,2)))) AS 'Saldo USD',
                SUM(quantity - total_payments) AS Saldo,
                IFNULL(c.nombre, 'De Paso') as Cliente
            FROM cheque doc
                     LEFT OUTER JOIN categoria cat ON doc.categoria_id = cat.categoria_id
                     LEFT OUTER JOIN cliente c ON doc.cliente_id = c.cliente_id
                     LEFT OUTER JOIN tienda t ON IFNULL(doc.tienda_id,1) = t.tienda_id
                     LEFT OUTER JOIN empresa e ON IFNULL(t.empresa_id,1) = e.empresa_id
                     LEFT OUTER JOIN moneda m ON m.moneda_id = doc.moneda_id
            WHERE doc.paid = 0 AND doc.atrasado = 0 AND doc.super_atrasado = 0
            GROUP BY 1, 2, 3,4, 5, 6, IFNULL(cat.categoria, '?'), IFNULL(c.nombre, 'De Paso'), 
                     IFNULL(c.nombre, 'De Paso')";
        return $this->query($sql);
    }

    public function pagaresHoy():array {
        $method = __METHOD__;
        $sql = "
        SELECT /*$method */ 
            'ASSETS' AS 'Balance Sheet',
            'Accounts Receivable' AS level_2,
            'Pagares' AS level_3, 
            IF(m.moneda_id=2, 'En USD', 'En PESOS') AS level_4,
            IFNULL(c.nombre, 'De Paso') as Details,
            m.Moneda, e.Empresa, t.clave AS Tienda, IFNULL(cat.categoria, '?') AS Categoria,
            SUM(IF(doc.moneda_id=2, quantity - total_payments, 
            CONVERT((quantity - total_payments)/$this->usdHoy , DECIMAL(16,2)))) AS 'Saldo USD',
            SUM(quantity - total_payments) AS Saldo,
            IFNULL(c.nombre, 'De Paso') as Cliente
            
        FROM pagare doc
            LEFT OUTER JOIN categoria cat ON doc.categoria_id = cat.categoria_id
            LEFT OUTER JOIN cliente c ON doc.cliente_id = c.cliente_id
            LEFT OUTER JOIN tienda t ON IFNULL(doc.tienda_id,1) = t.tienda_id
            LEFT OUTER JOIN empresa e ON IFNULL(t.empresa_id,1) = e.empresa_id
            LEFT OUTER JOIN moneda m ON m.moneda_id = doc.moneda_id
        WHERE doc.paid = 0 AND doc.atrasado = 0 AND doc.super_atrasado = 0
        GROUP BY 1, 2, 3,IF(m.moneda_id=2, 'En USD', 'En PESOS'), 5, 6, 7, IFNULL(cat.categoria, '?'), 
                 IFNULL(c.nombre, 'De Paso'), IFNULL(c.nombre, 'De Paso')";
        return $this->query($sql);
    }

    public function valesHoy():array {
        $method = __METHOD__;
        $sql = "
        SELECT /*$method */ 
            'LIABILITIES' AS 'Balance Sheet',
            'Accounts Payable' AS level_2,
            'Vales' AS level_3, 
            IF(m.moneda_id=2, 'En USD', 'En PESOS') AS level_4, 
            IFNULL(c.nombre, 'De Paso') as Details,
            m.Moneda, e.Empresa, t.clave AS Tienda, IFNULL(cat.categoria, '?') AS Categoria,
            
          {$this->pasivoNegativo}SUM(IF(doc.moneda_id=2, quantity - total_payments, 
          CONVERT((doc.quantity - doc.total_payments)/$this->usdHoy , DECIMAL(16,2)))) AS 'Saldo USD',
          {$this->pasivoNegativo}SUM(doc.quantity - doc.total_payments) AS 'Saldo',
            
            IFNULL(c.nombre, 'De Paso') as Cliente
        FROM vale doc
            LEFT OUTER JOIN categoria cat ON doc.categoria_id = cat.categoria_id
            LEFT OUTER JOIN cliente c ON doc.cliente_id = c.cliente_id
            LEFT OUTER JOIN tienda t ON IFNULL(doc.tienda_id,1) = t.tienda_id
            LEFT OUTER JOIN empresa e ON IFNULL(t.empresa_id,1) = e.empresa_id
            LEFT OUTER JOIN moneda m ON m.moneda_id = doc.moneda_id
        WHERE doc.aplicado = 0 AND doc.atrasado = 0 AND doc.super_atrasado = 0
        GROUP BY 1,2,3,
            IF(m.moneda_id=2, 'En USD', 'En PESOS'), 
            IFNULL(c.nombre, 'De Paso'),
            m.Moneda, e.Empresa, t.clave, IFNULL(cat.categoria, '?'),
        IFNULL(c.nombre, 'De Paso') ";
        return $this->query($sql);
    }

    public function bancosHoy():array {
        $method = __METHOD__;
        $sql = "
        SELECT /*$method */ 
            'ASSETS' AS 'Balance Sheet',
            'Cash' AS level_2,
            'Bancos' AS level_3,
            IF(bc.tipo_inversion_empresa_privada = 'privada', 'Cuentas Privadas', 
            IF(m.moneda_id=2, 'En USD', 'En PESOS')) AS level_4,
            bc.nombre AS Details,
            m.Moneda, e.Empresa, 'OFI' AS Tienda, 
            IF(bc.tipo_inversion_empresa_privada = 'privada', 'RONY', 'EMPRESA') AS Categoria,
            IF(bc.moneda_id=2, bcs.saldo_actual, 
            CONVERT(bcs.saldo_actual/$this->usdHoy, DECIMAL(16,2) )) AS 'Saldo USD',
            bcs.saldo_actual AS Saldo,
            b.Banco, bc.nombre AS Cuenta
        FROM banco_cuenta bc
            LEFT OUTER JOIN banco_cuenta_saldos bcs ON bcs.banco_cuenta_id = bc.banco_cuenta_id
            LEFT OUTER JOIN banco b ON bc.banco_id = b.banco_id
            LEFT OUTER JOIN empresa e ON bc.empresa_id = e.empresa_id
            LEFT OUTER JOIN moneda m ON m.moneda_id = bc.moneda_id
        WHERE bc.vale = 'Active' ";
        return $this->query($sql);
    }

    public function inversionesHoy():array {
        $method = __METHOD__;
        $sql = "
        SELECT /*$method  */ 
            'ASSETS' AS 'Balance Sheet',
            'Cash' AS level_2,
            'Investments' AS level_3,
            IF(bc.tipo_inversion_empresa_privada = 'privada', 'Cuentas Privadas', 
            IF(m.moneda_id=2, 'En USD', 'En PESOS')) AS level_4,
            bc.nombre AS Details,
            m.Moneda, e.Empresa, 'OFI' AS Tienda, 
            IF(bc.tipo_inversion_empresa_privada = 'privada', 'RONY', 'EMPRESA') AS Categoria,
            IF(bc.moneda_id=2, bcs.inversion_all, 
                CONVERT(bcs.inversion_all/$this->usdHoy, DECIMAL(16,2))) AS 'Saldo USD',
            bcs.inversion_all as Saldo, 
            b.Banco, bc.nombre as Cuenta
        FROM banco_cuenta bc
            LEFT OUTER JOIN banco_cuenta_saldos bcs ON bcs.banco_cuenta_id = bc.banco_cuenta_id
            LEFT OUTER JOIN banco b ON bc.banco_id = b.banco_id
            LEFT OUTER JOIN empresa e ON bc.empresa_id = e.empresa_id
            LEFT OUTER JOIN moneda m ON m.moneda_id = bc.moneda_id
        WHERE bc.vale = 'Active'";
        return $this->query($sql);
    }

    public function fiduciariosHoy():array {
        $method = __METHOD__;
        $sql =
          "
            SELECT /*$method*/
                'ASSETS' AS 'Balance Sheet',
                'Accounts Receivable' AS level_2,
                'Fiduciario' AS level_3,
                'En PESOS' AS level_4,
                e.empresa AS 'Details',
                'PESOS' AS Moneda, e.Empresa, 'OFI' AS Tienda, 'EMPRESA' AS Categoria,
                SUM(CONVERT(saldo/$this->usdHoy, DECIMAL(16,2)))  AS 'Saldo USD',
                SUM(saldo) AS 'Saldo'
            FROM fiduciario fid
                LEFT OUTER JOIN empresa e ON e.empresa_id = fid.empresa_id
            WHERE fid.terminado = 'No'
            GROUP BY 1, 2, 3, 4, 5, 6, 7, 8, 9";
        return $this->query($sql);
    }

    public function fiduciarioArchiva($del = '2000-01-01', $al = '2024-01-01'): bool {
        $fiduciario = [];
        $intervalDaily = new DateInterval("P1D");
        $method  = __METHOD__;
        $sql =
          "
        SELECT /*$method*/ fid.fecha_retiro, fid.fecha_terminado, e.Empresa, monto_retiro AS 'Saldo USD' , monto_retiro AS 'Saldo'
        FROM fiduciario fid
            LEFT OUTER JOIN empresa e ON e.empresa_id = fid.empresa_id
        WHERE fid.fecha_terminado IS NOT NULL";

        $raw = ia_sqlArrayIndx($sql);
        foreach($raw as $d) {
            $empresa = $d['Empresa'];
            $f = [
              'level_1' => 'ASSETS', 'level_2' => 'Accounts Receivable', 'level_3' => 'Fiduciario', 'level_4' => 'En PESOS', 'Details' => $empresa,
              'Empresa' => $empresa, 'Moneda' => 'PESOS', 'Tienda'=>'OFI', 'Categoria' => 'EMPRESA'
            ];
            $uq = md5(implode("\t", $f));
            $startDate = DateTimeImmutable::createFromFormat("Y-m-d H:i:s", "$d[fecha_retiro] 00:00:00");
            $endDate = DateTimeImmutable::createFromFormat("Y-m-d H:i:s", "$d[fecha_terminado] 00:00:00");
            $datePeriod = new DatePeriod($startDate, $intervalDaily, $endDate, DatePeriod::INCLUDE_END_DATE);
            foreach($datePeriod as $date) {
                $f['Saldo USD'] = $d['Saldo USD'];
                $f['Saldo'] = $d['Saldo'];
                $fecha = $date->format("Y-m-d");

                if(!array_key_exists($fecha, $fiduciario)) {
                    $fiduciario[$fecha][$uq] = $f;
                    continue;
                }
                if(!array_key_exists($uq, $fiduciario[$fecha])) {
                    $fiduciario[$fecha][$uq] = $f;
                    continue;
                }
                $fiduciario[$fecha][$uq]['Saldo USD'] += $d['Saldo USD'];
                $fiduciario[$fecha][$uq]['Saldo'] += $d['Saldo'];
            }
        }
        $ok = false;
        $builder = new IacSqlBuilder();
        foreach($fiduciario as $fecha => $arr)
            foreach($arr as $uq => $d)
                $ok |= ia_query( $builder->insert(
                  "balance",
                  ['fecha' => $fecha, 'uq' => $uq, 'renglon' => json_encode($d, JSON_OPTIONS_FOR_MYSQL)],
                    TRUE
                ));

        return $ok;
    }

    public function bodegaHoy(): array {
        $method = __METHOD__;
        $sql = "
            SELECT /*$method */
                'ASSETS' AS 'Balance Sheet',
                'Inventory' AS level_2,
                'Bodega' AS level_3,
                'En USD' AS level_4,
                b.Bodega AS Details,
                'USD' AS Moneda, e.Empresa, 'OFI' AS Tienda, 'EMPRESA' AS Categoria,
                SUM(CONVERT(pb.existencia_quantity * pcif.cost_cif, DECIMAL(16,2))) as 'Saldo USD',
                SUM(CONVERT(pb.existencia_quantity * pcif.cost_cif, DECIMAL(16,2)) ) as Saldo,
                
                b.Grupo AS 'Grupo Bodega', b.Bodega
            FROM producto_bodega pb
                     JOIN producto_costs_bodega pcif ON pb.producto_general_id = pcif.producto_general_id 
                                                            AND pcif.fecha_fin IS NULL
                     JOIN bodega b ON pb.bodega_id = b.bodega_id
                     JOIN empresa e ON b.empresa_id = e.empresa_id
            GROUP BY 1, 2, 3, 4 ,5, 6,7, 8, e.Empresa,b.Grupo, b.Bodega";
        return $this->query($sql);
    }

    public function bodegaCampos_kvDate():string {
        $method= __METHOD__;
        return ia_singleread(
          "SELECT /*$method*/ alta_db FROM campos_kv WHERE concepto LIKE 'B\t%' ORDER BY fecha DESC LIMIT 1");
    }

    public function bodegaCampos_kv():array {
        $return = [];
        $method= __METHOD__;
        $fecha = ia_singleread(
          "SELECT /*$method*/ fecha FROM campos_kv WHERE concepto LIKE 'B\t%' ORDER BY fecha DESC LIMIT 1");
        if(empty($fecha))
            return [];
        $bodegas = ia_sqlKeyValue(
          "SELECT /*$method*/ concepto, valor 
                FROM campos_kv
                WHERE fecha = '$fecha' AND concepto LIKE 'B\t%'",
        );
        if($bodegas === false)
            return [];
        foreach($bodegas as $concepto => $valor) {
            $nombre = explode("\t", $concepto);
            $return[] = [
              'Balance Sheet' => 'ASSETS',
              'level_2' => 'Inventory',
              'level_3' => 'Bodega',
              'level_4' => 'En USD',
              'Details' => $nombre[1],
              'Moneda' => 'USD',
              'Tienda' => 'OFI',
              'Categoria' => 'EMPRESA',
              'Saldo USD' => $valor,
              'Saldo' => $valor,
              'Bodega' => $nombre[1],
              'Grupo Bodega' => $nombre[2],
            ];
        }
        return $return;
    }

    public function bodega2campos_kv():bool {
        $queries = [];
        $builder = new IacSqlBuilder();
        $builder->dontOnUpdateFieldName = [];
        $bodega = $this->bodegaHoy();
        foreach($bodega as $b) {
            $data = [
              "concepto" => "B\t$b[Details]\t" . $b['Grupo Bodega'],
              "valor" => $b['Saldo'],
              "fecha" => date("Y-m-d"),
              "alta_db" => "CURRENT_TIMESTAMP"
            ];
            $queries[] = $builder->insert('campos_kv', $data, true, comment: __METHOD__);
        }
        return !ia_transaction($queries, __METHOD__);
    }

    public function enElMarHoy():array {
        $method = __METHOD__;
        $enElMar = str_replace([",", "$"], "",
          trim(ia_singleread(
            "SELECT /*$method*/ valor FROM campos_kv WHERE concepto='EN EL MAR' ORDER BY fecha DESC LIMIT 1")));
        return [[
            'Balance Sheet' => 'ASSETS',
            'level_2' => 'Inventory',
            'level_3' => 'En el Mar',
            'level_4' => 'En USD',
            'Moneda' => 'USD',
            'Tienda' => 'OFI',
            'Categoria' => 'EMPRESA',
            'Saldo USD' => $enElMar,
            'Saldo' => $enElMar,
        ]];
    }

    public function manualHoy():array {
        $manual = [];
        $method = __METHOD__;
        $sql =
          "
          WITH  /*$method*/  hoy AS
            (SELECT concepto, MAX(fecha) AS 'fecha'
                FROM campos_kv
                WHERE concepto LIKE 'M\t%'
                GROUP BY 1
            )
            SELECT kv.concepto, kv.valor
            FROM campos_kv kv
                JOIN hoy ON kv.concepto = hoy.concepto AND kv.fecha = hoy.fecha
            WHERE kv.concepto LIKE 'M\t%';
          ";
        $movs = ia_sqlArrayIndx($sql);
        foreach($movs as $m) {
            $levels = explode("\t", $m['concepto']);
            $manual[] = [
              'Balance Sheet' => $levels[1],
              'level_2' => $levels[2],
              'level_3' => $levels[3],
              'level_4' =>  $levels[4],
              'Moneda' => 'USD',
              'Tienda' => 'OFI',
              'Categoria' => 'Manual',
              'Saldo USD' => $m['valor'],
              'Saldo' => $m['valor'],
            ];
        }
        return $manual;
    }
    protected function query($sql):array {
        $ret = ia_sqlArrayIndx($sql);
        if(is_array($ret))
            return $ret;
        return [];
    }

}
