<?php
require_once(__DIR__ . '/iaErrorReporterDisplay.php');
/**
 * iaErrorReporter,
 *
 *
 * @example
 *  $errRep = new iaErrorReporter($db, $mailErrorsTo);
 *  $errRep->process(true); // at bottom of script, stores and emails new errors. true also displays, false no display
 *
 * @version 1.1.2
 *
 */
class iaErrorReporter {


    /** @var object db class */
    protected $db;
    /** @var array error logged */
    protected $logError = [];
    public $ReportErrorsHtml = "";
    public $ReportCount = 0;
    public $ReportTraceSql = array();

    /**
     * __construct()
     *
     * @param object $db
     * @return void
     */
    public function __construct($db) {
        $this->logError = [];
        $this->db = $db;
    }

    /**
     * Registers last errors, if any, emails new errors & optionally displays them
     *
     * @param bool $display on true echos error
     * @return void
     *
     * @see pageDisplayErrors pageDisplayErrors
     * @see emailSend emailSend
     */
    public function process($display=false) { 
        $this->errorPhp();
        $this->errorJson();
        $this->errorPreg();
        $this->errorXml();
        $this->errorSql();
        $count = array('newbug'=>0,'Fixed'=>0,'Bug'=>0,'Wont Fix'=>0,'?'=>0);
        $html = '';
        $username = isset($_SESSION['usuario']) ? $_SESSION['usuario'] : '¿?';
        $webRoot = str_replace("\\", '/', $_SERVER['DOCUMENT_ROOT']);
        foreach($this->logError as $error) {
            $error['file'] = str_replace($webRoot, '',  str_replace("\\", '/', $error['file']) );
            $icac_error_id = $error['error_type'] === 'Sql' || $error['error_type'] === 'json' || $error['error_type'] === 'pcre' ?
                md5($error['error_type'].$error['message']) : 
                md5($error['file'].$error['line'].$error['error_type'].$error['coded']);
            try {
                if($this->db != null) {
                    $sql = "SELECT /*".__METHOD__."*/ `status` FROM icac_error WHERE icac_error_id=".strit($icac_error_id);
                    $error_status = $this->db->single_read($sql,'newbug');
                } else {
                    $error_status='newbug';
                }
                if(empty($error_status)) {
                    $error_status='newbug';
                }
                if(array_key_exists($error_status,$count)) {
                    $count[$error_status]++;
                }
                $html .= "<li style='padding-bottom:0.4em;'>".ia_htmlentities($error['message']).
                    (!empty($error['Sql']) ? " <br />".ia_htmlentities($error['Sql']) : '' ).(!empty($error['retries']) ? " ".ia_htmlentities($error['retries']) : '' ).
                    "<br />".ia_htmlentities($error['file'])." Line: ".$error['line']." Type: ".ia_htmlentities($error['error_type']);
            // log error in db
                if($this->db != null) {
                    $sql = "INSERT /*".__METHOD__."*/ INTO icac_error(icac_error_id,usuario,file,line,error_type,coded,error_message,first_seen,last_seen,seen_times) VALUES("
                           .stritc($icac_error_id).stritc($username).stritc($error['file']).stritc($error['line']).stritc($error['error_type']).stritc($error['coded']).
                             stritc($error['message'].(empty($error['Sql']) ? '' : "\r\n".$error['Sql']  ))
                            ."NOW(),NOW(),1 )"
                            ." ON DUPLICATE KEY UPDATE file=VALUES(file), usuario=VALUES(usuario), last_seen=NOW(),seen_times=seen_times+1,"
                            ."error_message=VALUES(error_message), `status`=IF(`status`='Fixed','Bug',`status`)";
                  if(!$this->db->query($sql)) {
                   ; // echo "<pre style='top:40em;color:red'>register errors sql error: $sql</pre>";
                }
                }
            } catch(\Exception $err) {
                // DO NOTHING
            }
        }
        $this->ReportErrorsHtml = $html;
        $this->ReportCount = $count;        
        $this->ReportTraceSql = $this->dbtrace();
        $output = new iaErrorReporterDisplay();
        global $gConfig;
        $output->reportErrors($display, isset($gConfig['mailErrorsTo']) ? $gConfig['mailErrorsTo'] : null, $html, $count, $this->ReportTraceSql);
        $this->logError = []; // por si lo llaman varias veces
    }

    public function displayErrors() {
        if(!isset($this->ReportCount))
            return false;
        $output = new iaErrorReporterDisplay();    
        $output->reportErrors(true, null, $this->ReportErrorsHtml, $this->ReportCount, $this->ReportTraceSql);    
        return strlen($this->ReportErrorsHtml) > 0;
    }
//////////////////////
// Manually log an error
//////////////////////

    /**
     * Register an exception in the error log
     *
     * @param object $exception an exception
     * @param string $error_type
     * @return void
     */
    public function errorException($exception,$error_type='exception') {
        try {
            $this->logErrorAdd(array(
                'file' => $exception->getFile(),
                'line' => $exception->getLine(),
                'error_type' => $error_type,
                'coded'=>md5($exception->getFile().$exception->getLine().$error_type.$exception->getMessage()),
                'message' => $exception->getMessage(),
                )
            );
        } catch(\Exception $e) {
            // just in case, defensive programming
            $this->logErrorAdd(array(
                'file' => $_SERVER['SCRIPT_NAME'],
                'line' => 0,
                'error_type' => 'exception',
                'coded'=>'',
                'message' => "Registering exception trhough IacErrorReporter::errorException",
                )
            );
        }
    }


    /**
     * iaErrorReporter::errorManual()
     *
     * @param string $message
     * @param string $file
     * @param string $error_type
     * @param integer $line
     * @param string $md5
     * @return void
     */
    public function errorManual($message, $file, $error_type='Manual', $line=0, $md5='') {
        if(empty($file)) {
            $file = $_SERVER['SCRIPT_NAME'];
        }
        $this->logErrorAdd( array(
            'file' => $file,
            'line' => $line,
            'error_type' => $error_type,
            'coded' => empty($md5) ? md5($message.$file.$line.$error_type) : $md5,
            'message' => $message,
            )
        );
    }

//////////////////////
// Manually log an error
//////////////////////

    /**
     * report Sql trace
     *
     * @return
     */
    protected function dbtrace() {
        if($this->db === null) {
            return '';
        }
        $log = $this->db->trace_get();
        if(empty($log)) {
            return "";
        }
        return "<ol><li>" . implode("<li>",$log)."</ol>";
    }

    /**
     * Register Sql error log
     *
     * @return void
     */
    protected function errorSql() {
        if($this->db === null) {
            return;
        }
        foreach($this->db->errorLog_get() as $error) {
            $sqlNormalized = self::sqlNormalized($error['sql']);
            $this->logErrorAdd( array(
                'file' => empty($_SERVER['SCRIPT_NAME']) ? 'Sql' : $_SERVER['SCRIPT_NAME'],
                'line' => 1,
                'error_type' => 'Sql',
                'coded' => md5($sqlNormalized),
                'Sql' => $sqlNormalized,
                'sqlNormalized' => $sqlNormalized,
                'message' => (empty($error['errno']) ? '' : $error['errno'].': ').$error['error'],
                )
            );
        }
    }

    /**
     * Register last php error
     *
     * @return void
     */
    protected function errorPhp() {
        $error = error_get_last();
        if(empty($error)) {
            return;
        }
        $error['error_type'] = 'php';
        $error['coded'] = md5( $error['file'].$error['line'].$error['message'].'php');
        $this->logErrorAdd($error);
    }


    /**
     * Register last json error
     *
     * @return void
     */
    protected function errorJson() {
        if(!function_exists('json_last_error')) {
            return;
        }
        $error = json_last_error();
        if($error === JSON_ERROR_NONE) {
            return;
        }
        $message = function_exists('json_last_error_msg') ? json_last_error_msg() : self::constant2name('json',$error);
        $this->logErrorAdd( array(
            'file' => $_SERVER['SCRIPT_NAME'],
            'line' => 1,
            'error_type' => 'json',
            'coded' => md5($_SERVER['SCRIPT_NAME'].'json'.$message),
            'message' => $message
            )
        );
    }

    /**
     * Register last  regexp error
     *
     * @return void
     */
    protected function errorPreg() {
        if(!function_exists('preg_last_error') || ($error=preg_last_error()) === PREG_NO_ERROR ) {
            return null;
        }
        $this->logErrorAdd( array(
            'file' => $_SERVER['SCRIPT_NAME'],
            'line' => 1,
            'error_type' => 'pcre',
            'coded' => md5($_SERVER['SCRIPT_NAME'].$error.'pcre'),
            'message' => self::constant2name('pcre',$error)
            )
        );
    }

    /**
     * Register last xml error
     *
     * @return void
     */
    protected function errorXml() {
        if(!function_exists('libxml_get_last_error')) {
            return;
        }
        $error = libxml_get_last_error();
        if($error == false) {
            return;
        }
        $this->logErrorAdd( array(
            'file' =>  $_SERVER['SCRIPT_NAME'],
            'line' => 1,
            'error_type' => 'libxml',
            'coded' => md5($error->file."xml".$error->code),
            'message' => "Error code: ".$error->code.", Level: ".$error->level.' File: '.$error->file.", Line: ".$error->line.", Column: ".$error->column
            )
        );
    }

//////////////////////
// Auxiliares
//////////////////////
    /**
     * Store errors by hash key
     *
     * @param array $error
     * @return void
     */
    protected function logErrorAdd($error, $key = null) {
        $this->logError[ $key === null ? $error['file'].$error['line'].$error['error_type'].$error['coded'] : $key] = $error;
    }

    /**
     * Generalize an Sql statement changing "parameters" to ?
     *
     * @param string $sql
     * @return string
     */
    protected static function sqlNormalized($sql) {
        static $sqlKeyWords =["select "," from "," join "," left "," right "," outer "," inner "," straight "," exists "," with "," on "," where "," and "," or "," not "," null "," in "," is "," having "," limit "," order by "," group by ","update ","insert ","delete "," as "];
        static $sqlKeyWordsUpperCase = [];
        if(empty($sqlKeyWordsUpperCase)) {
            foreach($sqlKeyWords as $keyword) {
                $sqlKeyWordsUpperCase[] = strtoupper($keyword);
            }
        }
        $sql = str_replace(['=','>','>=','<','<=','<>',"\r","\n","\t"],[' = ',' > ',' >= ',' < ',' <= ',' <> ',' ',' ',' '], $sql);
        $sql = str_ireplace($sqlKeyWords,$sqlKeyWordsUpperCase,$sql);
        global $gDBName;
        $sql = preg_replace('/$gDBName\.aa_[a-z0-9_]+/mi', 'tempTable', $sql);
        return preg_replace("/('([^']|'')*'|\b[-+]?[0-9]*\.?[0-9]+\b)/uS", '?', str_replace(["\\'". '´', '"'], '', self::strim($sql)) );
    }

    /**
     * Returns the name of a php constant
     *
     * @param string $group
     * @param mixed $value string or number
     * @param string $tag
     * @return string
     */
    protected static function constant2name($group, $value, $tag='ERR') {
        static $constats;
        if(!isset($constants)) {
            $constants = get_defined_constants(true);
        }
        if(!isset($constants[$group])) {
            return "Unknown ($value)";
        }
        foreach($constants[$group] as $c=>$n) {
            if( (empty($tag) || stripos($c,$tag)!==FALSE) &&  $n===$value) {
                return "$c ($value)";
            }
        }
        return "Unknown ($value)";
    }

    /**
     * superTrim trim (including \s utf spaces), and change multiple spaces to one space
     *
     * @param string $str
     * @return string
     */
    protected static function strim($str) {
        $s1 = preg_replace('/[\pZ\pC]/muS',' ',$str);
        // @codeCoverageIgnoreStart
        if(preg_last_error()) {
            $s1 = preg_replace('/[\pZ\pC]/muS',' ',  iconv("UTF-8","UTF-8//IGNORE",$str));
            if(preg_last_error())   
                return trim(preg_replace('/ {2,}/mS',' ',$str));
        }
        // @codeCoverageIgnoreEnd
        return trim(preg_replace('/ {2,}/muS',' ',$s1));
    }
}
