<?php
/**
 *
 *
 * Display all errors and/or email new or thought fixed errors collected by iacErrorReporter
 *
 */
class iaErrorReporterDisplay {

    /**
     * report errors to screen
     *
     * @param bool $display
     * @param string $emailTo
     * @param string $html
     * @param array $count
     * @param string $info
     * @return void
     */
    public function reportErrors($display, $emailTo, $html, $count, $info) {
        if($display) {
            $this->pageDisplayErrors($html,$count['Bug'] + $count['newbug'] +$count['Fixed'] , $info);
            global $gDebugging;
            if($gDebugging || usuarioTipoRony()) {
                try {
                    if(file_exists("../uploads/fragmentLastModified.html")) {
                        echo file_get_contents("../uploads/fragmentLastModified.html");
                        echo file_get_contents("../uploads/last");
                        echo "</pre></div></details>";
                    }
                } catch(Throwable) {echo "err";}
                echo usedFilesTimes();
            }
        }
        if( !empty($emailTo) && ($count['newbug'] + $count['Fixed']) > 0) {
            $this->emailSend($emailTo, $html,$count);
        }

    }

    /**
     * Display errors in html
     *
     *
     * @codeCoverageIgnore
     *
     * @param string $html
     * @param int $count total number of errors
     * @param string $info additional html to output
     * @return void
     */
    protected function pageDisplayErrors($html,$count,$info) {
        global $gDebugging;
        if(!usuarioTipoRony() && !$gDebugging) $info='';
        $style = $count == 0 ? '' : ' style="color:red" ';
        echo "
<script>
function iacHtmlDetialsClick(e) {e.nextElementSibling.style.display=(e.nextElementSibling.style.display=='none' ? 'block':'none');e.firstElementChild.innerHTML=(e.nextElementSibling.style.display=='none' ? '&#8680;' : '&#8681;');}
</script>
<div class='iacDetailsSeparator np lazy-content'></div><div class='iacDetailsByDiv np' style='margin:1em'>
<span style='cursor:pointer;color:silver;background-color:white;' title='Click to view' onclick=\"iacHtmlDetialsClick(this);\">
<b>&#8680;</b> <span$style>Page Info ($count)</span>
</span>
<div style='display:none;border:1px silver solid;background-color:white;padding:0 1em 1em 1em;margin:0 1em auto 1em;'>
".$this->ramUsage().$this->timeUsage()."<ol style='color:red;'>$html</ol>$info
</div></div>
";
    }

    /**
     * Send email with errors
     *
     * @codeCoverageIgnore
     *
     * @param string $error
     * @param string $html
     * @param array $count
     * @return void
     */
    protected function emailSend($emailTo, $html, $count) {

       $subject = $_SERVER["HTTP_HOST"]." iac detected Errors.";
       if($count['Fixed']>0)
        $subject.=" $count[Fixed] Unfixed errors.";
       if($count['newbug']>0)
        $subject.=" $count[newbug] New errors.";

       @mail($emailTo,
            $subject,
            "<html><body><p>IacErrorReporter reporting:<p><ul><li>".$_SERVER["HTTP_HOST"]."<li>".PHP_VERSION."<li>".php_uname().
                "<li><ul style='color:red;'>".$html."</ul></ul>".$this->ramUsage().$this->timeUsage()."</body></html>"
        );
    }

    /**
     * Reports memory usage
     *
     * @return string a div with memory usage information
     */
    protected function ramUsage() {
        return "<div style='font-family:courier;margin-left:16px;'>"
            ."Used: ".self::bytes2units( memory_get_usage() )." Real: ".self::bytes2units( memory_get_usage(true) )
            ." / "
            ."Peak Used: ".self::bytes2units( memory_get_peak_usage() )." Real: ".self::bytes2units( memory_get_peak_usage(true) )
            ."</div>"
            ;
    }

    /**
     * Reports current timing from $_SERVER['REQUEST_TIME'] to current time
     *
     * @return string html code with timing information
     */
    protected function timeUsage() {
        if(!array_key_exists('REQUEST_TIME',$_SERVER)) {
            return '';
        }
        return "<div style='font-family:courier,serif;margin-left:16px;'>"."Total: ".self::milliSecondsFormat(abs( microtime(true) - $_SERVER['REQUEST_TIME'] ))."</div>";
    }


    /**
     * Format bytes into readable units Kb, Mb,..
     *
     * @param int $bytes
     * @return string
     */
    protected static function bytes2units($bytes) {
        if(empty($bytes) || !is_numeric($bytes))
            return $bytes;
        if($bytes < 0) {
            $signo = '-';
            $bytes *= -1;
        } else
            $signo = '';
        if($bytes < 1024) {
            $decs = 0;
            $punto = '';
        } else {
            $decs = 2;
            $punto = '.';
        }
        $unit =['b', 'Kb', 'Mb', 'Gb', 'Tb', 'Pb'];
        return $signo.number_format($bytes/pow(1024,($i=floor(log($bytes,1024)))),$decs,$punto,',').' '.$unit[$i];
    }

    /**
     * Formats milliseconds strings with time units
     *
     * @param number $t0 the number of milliseconds to format
     * @return string formatted lapsed time in milliseconds
     */
    protected static function milliSecondsFormat($t0) {
        $t0 =  (float)$t0;
        if(empty($t0) || !is_numeric($t0)) {
            $t0 = 0;
        }
        if($t0 < 0) {
            $t0 = -1 * $t0;
        }
        if($t0 >= 60*60*24) {
            return ">= 1 day not supported"; //@TODO milliSecondsFormat support 1 day adnd more
        }
        return trim( str_replace(
             array('0 h','00 min','00 sec',' 01',' 02',' 03',' 04',' 05',' 06',' 07',' 08',' 09')
             ,array('','',''               ,' 1',' 2',' 3',' 4',' 5',' 6',' 7',' 8',' 9')
            ,gmDate(' G \h i \m\i\n s \s\e\c '.(round($t0-floor($t0),3)*1000).' \m\s',floor($t0) )
        ));
    }
}

