<?php
require_once("xlsxwriter.class_2023_06_02.php");
/**
 * Ayuda al exportBuffer ($buffer) del configurador de reportes para el grid
 * Reporte de Vales
 */
class ExportBuffer {
    const VALE_PESOS = 'PESOS';
    const VALE_DOLARES = 'USD';
    const VALE_PESOS_TRANSFORMADOS_A_DOLARES = 'PESOS 
    TRANSFORMADOS A DOLARES';
    const COLOR_PESOS = '#0000FF';
    const COLOR_USD = '#02A702';

    public function reporteVale_xlsx(array $reporte_vale, array $decode):void {
        $dataCell = [
            'border'=>'left,right,top,bottom', 'border-style' => 'dotted',
            'font' => 'Calibri', "font-size" => 15, 'font-style'=>'bold',
        ];
        $dataCell2 = [
            'border'=>'left,right,top,bottom', 'border-style' => 'dotted','font-style'=>'bold',
        ];

        $header = [
            "string",
            "string",
            "string",
            "#0",

            "#,##0.00",
            "#,##0.00",
            "#,##0.00",
            "#,##0.00",
            "#,##0.00"
        ];

        $headerTitles = [
            "@",
            "string",
            "string",
            "@",

            "@",
            "@",
            "@",
            "@",
            "@"
        ];
        $headerOptions = [
            'font' => 'Calibri','font-style'=>'bold',

            'border'=>'left,right,top,bottom', 'border-style' => 'dotted',
            'height' => 22,
            'suppress_row'=>true,
            'widths'=>[14.33, 8.90, 24.60, 10.1, 16.6, 16.0, 16.6, 11.5, 16.6]
        ];

        $headerOptions2 = [
            'font' => 'Calibri','font-style'=>'bold',
            'border'=>'left,right,top,bottom', 'border-style' => 'dotted',
            'height' => 22,
            'suppress_row'=>true,
            'widths'=>[13.29, 8.57, 24.00, 10, 15.43, 11.3, 15.43, 11.3, 15.4]
        ];

        $iRow = 0;
        $mergeTitles = [];
        $addBlankLine = false;
        $writer = new XLSXWriter();
        $writer->writeSheetHeader('Vales', $header,$headerOptions);
        $writer->writeSheetHeader('Vales Foto', $header,$headerOptions2);
        foreach($reporte_vale['vales'] as $cual => $rows) {
            if(empty($rows))
                continue;

            $writer->writeSheetHeader('Vales', $headerTitles, $headerOptions);
            $writer->writeSheetHeader('Vales Foto', $headerTitles, $headerOptions2);
            if($addBlankLine) {
                $iRow++;
                $writer->writeSheetRow('Vales', ['', '', '', '', '', '']);
                $writer->writeSheetRow('Vales Foto', ['', '', '', '', '', '']);
            } else
                $addBlankLine = true;
            $mergeTitles[$iRow++] = $numCols = $cual === self::VALE_PESOS_TRANSFORMADOS_A_DOLARES ? 8 : 6;
            $color = $cual === self::VALE_PESOS ? self::COLOR_PESOS : self::COLOR_USD;
            $colorTitle = match ($cual) {
                self::VALE_DOLARES => self::COLOR_USD,
                self::VALE_PESOS_TRANSFORMADOS_A_DOLARES => self::COLOR_PESOS,
                default => "#000000",
            };

            $writer->writeSheetRow('Vales', ["VALES EN $cual"],
                [
                   ...array_fill(1,  $numCols, [
                       'border'=>'top,bottom', 'border-style' => 'dotted',
                       'color' => $colorTitle,  'fill'=>'#eee', 'halign'=>'center',
                       'font' => 'Calibri', 'font-size' => 18, 'font-style'=>'bold',
                       'wrap_text'=>true,
                       ]),
                    'height'  => $cual === self::VALE_PESOS_TRANSFORMADOS_A_DOLARES ? 58.5 : 23.6,
                ]);
            $writer->writeSheetRow('Vales', $reporte_vale['headers'][$cual],
                [
                    'font' => 'Calibri', 'font-style'=>'bold',
                    'fill'=>'#eee', 'halign'=>'center',
                    'border'=>'left,right,top,bottom', 'border-style' => 'dotted',
                    'wrap_text'=>true, 'format' => 'string']);
            $writer->writeSheetHeader('Vales', $header, $headerOptions);


            $writer->writeSheetRow('Vales Foto', ["VALES EN $cual"],
                [
                    ...array_fill(1,  $numCols, [
                        'border'=>'top,bottom', 'border-style' => 'dotted',
                        'font-size' => 18, 'color' => $colorTitle,  'fill'=>'#eee', 'halign'=>'center',
                        'font-style'=>'bold',
                        'wrap_text'=>true,
                    ]),
                    'height'  => $cual === self::VALE_PESOS_TRANSFORMADOS_A_DOLARES ? 58.5 : 23.6,
                ]);
            $writer->writeSheetRow('Vales Foto', $reporte_vale['headers'][$cual],
                ['font-style'=>'bold', 'fill'=>'#eee', 'halign'=>'center',
                    'border'=>'left,right,top,bottom', 'border-style' => 'dotted',
                    'wrap_text'=>true, 'format' => 'string']);
            $writer->writeSheetHeader('Vales Foto', $header, $headerOptions2);

            $iRow++;
            foreach($rows as $d) {
                $iRow++;
                $row = [
                    $this->formatDate($d['Alta Db']),
                    $d['Moneda'],
                    $d['Nombre del Cliente'],
                    $d['Numero'],
                    $d['Monto Neto'] ?? $d['Debe'] ?? $d['Saldo'],
                    $d['Usado'],
                    $d['Debe'],
                ];
                if($cual === self::VALE_PESOS_TRANSFORMADOS_A_DOLARES) {
                    $row[] = $d['Tipo Cambio'];
                    $row[] = bcmul($d['Tipo Cambio'], $d['Debe'], 2);
                }


                $writer->writeSheetRow('Vales', $row,
                    [   ['halign'=>'center','valign' => 'center', 'color'=>'#000000', ...$dataCell],
                        ['halign'=>'center','valign' => 'center', 'color'=>$color, ...$dataCell],
                        ['halign'=>'left', 'valign' => 'top', 'wrap_text'=>true, 'color'=>'#000000', ...$dataCell],
                        ['halign'=>'center','valign' => 'center',  'color'=>$color, ...$dataCell],
                        ['halign'=>'right','valign' => 'center',  'color'=>$color, ...$dataCell],
                        ['halign'=>'right','valign' => 'center',  'color'=>$color, ...$dataCell],
                        ['halign'=>'right','valign' => 'center',  'color'=>$color, ...$dataCell],
                        ['halign'=>'right','valign' => 'center', ...$dataCell],
                        ['halign'=>'right','valign' => 'center', ...$dataCell],
                        'height' => 40,
                    ]);

                $writer->writeSheetRow('Vales Foto', $row,
                    [   ['halign'=>'center','valign' => 'center', ...$dataCell2],
                        ['halign'=>'center','valign' => 'center', 'color'=>$color, ...$dataCell2],
                        ['halign'=>'left',
                            'valign' => strlen( $d['Nombre del Cliente'] ?? '') > 19 ? 'top' : 'center',
                            'wrap_text'=>true, ...$dataCell2],
                        ['halign'=>'center','valign' => 'center',  'color'=>$color, ...$dataCell2],
                        ['halign'=>'right','valign' => 'center',  'color'=>$color, ...$dataCell2],
                        ['halign'=>'right','valign' => 'center',  'color'=>$color, ...$dataCell2],
                        ['halign'=>'right','valign' => 'center',  'color'=>$color, ...$dataCell2],
                        ['halign'=>'right','valign' => 'center', ...$dataCell2],
                        ['halign'=>'right','valign' => 'center', ...$dataCell2],
                        'height' => 34,
                    ]);
            }

        }

        foreach($mergeTitles as $row => $end_col) {
            $writer->markMergedCell('Vales', $row, 0, $row, $end_col);
            $writer->markMergedCell('Vales Foto', $row, 0, $row, $end_col);
        }
        $fileName = "vales_" . Date('Y_m_d') . ".xlsx";
        header('Content-Disposition: attachment; filename="'. $fileName .'"');
        header("Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        header('Content-Transfer-Encoding: binary');
        header('Cache-Control: must-revalidate');
        header('Pragma: public');
        $writer->writeToStdOut();
        ia_errores_a_dime();
        die();
    }

    protected function formatDate($date):string {

        $meses = [
            'ENE'=>'01',
            'JAN'=>'01',
            'FEB'=>'02',
            'MAR'=>'03',
            'ABR'=>'04',
            'APR'=>'04',
            'MAY'=>'05',
            'JUN'=>'06',
            'JUL'=>'07',
            'AGO'=>'08',
            'AUg'=>'08',
            'SEP'=>'09',
            'OCT'=>'10',
            'NOV'=>'11',
            'DEC'=>'12',
            'DIC'=>'12',
        ];
        $parts = explode("-", $date);
        if(count($parts) !== 3)
            return $date;
        return "$parts[0]-" . ($meses[strtoupper($parts[1])] ?? $parts[1]) . "-" . substr($parts[2], -2);
    }

    public function reporteVale_table(array $reporte_vale, array $decode):string {
        $format = function($n) {
            return bcformat($n, 2);
        };
        $table = [];
        foreach($reporte_vale['vales'] as $cual => $row) {
            if(empty($row))
                continue;
            if(!empty($table))
                $table[] = "<tr><th colspan='7' class='txt_centered bold'><hr>";
            $table[] = "<tr><th colspan='7' class='txt_centered bold' style='text-decoration: underline;text-decoration-style: double;text-decoration-color:darkgrey; font-size:1.3em'>VALES EN $cual";
            $table[] = "<tr><th style='padding: 2px 3px; border-bottom:1px silver solid!important'>" . implode("<th style='padding: 2px 3px'>", $reporte_vale['headers'][$cual]);
            foreach($row as $d) {
                $moneda = "txt_color_$d[Moneda]";
                $tr = <<< HTML
                <tr><td class="txt_centered $moneda">{$d['Alta Db']}</td>
                <td class="txt_centered $moneda">{$d['Moneda']}</td>
                <td class="txt_centered $moneda">{$d['Nombre del Cliente']}</td>
                <td class="txt_centered $moneda">{$d['Numero']}</td>
                <td class="der bold $moneda">{$format($d['Monto Neto'])}</td>
                <td class="der bold $moneda">{$format($d['Usado'])}</td>
                <td class="der bold $moneda">{$format($d['Debe'])}</td>
HTML;
                if($cual === self::VALE_PESOS_TRANSFORMADOS_A_DOLARES) {
                    $ori = empty(floatval( $d['Debe'])) ? "0.00" :
                        bcmul( $d['Debe'] , $d['Tipo Cambio'], 2);
                    $tr .= <<< HTML
                    <td class="der bold $moneda">{$format($d['Tipo Cambio'])}</td>
                    <td class="der bold txt_color_PESOS">{$format($ori)}</td>
HTML;
                }
                $table[] = $tr;
            }
        }
        return '<table class="laTabla" style="width: 100%;  border-style: solid; border-width: 1px; padding: 4px 4px; border-color:grey" >' .
            implode("\r\n\t", $table) . "</table>";
    }

    public function reporteVale_Datos(array $decode):array {
        $vales = [self::VALE_PESOS => [], self::VALE_DOLARES => [], self::VALE_PESOS_TRANSFORMADOS_A_DOLARES => []];
        foreach($decode['rows'] as $d) {
            if($d['Moneda'] === 'PESOS') {
                $vales[self::VALE_PESOS][] = array_intersect_key($d,
                    ['Alta Db' => '', 'Moneda' => '', 'Nombre del Cliente' => '', 'Numero' => '',
                        'Monto Neto' => '', 'Usado' => '', 'Debe' => '']
                );
                continue;
            }
            $tc = trim($d['Tipo Cambio']);

            if(floatval($tc) !== 0.00) {
                $vales[self::VALE_PESOS_TRANSFORMADOS_A_DOLARES][] = $x = array_intersect_key($d,
                    ['Alta Db' => '', 'Moneda' => '', 'Nombre del Cliente' => '', 'Numero' => '',
                        'Monto Neto' => '', 'Usado' => '', 'Debe' => '', 'Tipo Cambio' => '', 'Monto Real recibido' => '']
                );

                continue;
            }
            $vales[self::VALE_DOLARES][] = array_intersect_key($d,
                ['Alta Db' => '', 'Moneda' => '', 'Nombre del Cliente' => '', 'Numero' => '',
                    'Monto Neto' => '',  'Usado' => '', 'Debe' => '']
            );
        }
        $headers = [
            self::VALE_PESOS => [
                'Alta Db' => 'Fecha', 'Moneda' => 'Moneda', 'Nombre del Cliente' => 'Nombre del Cliente', 'Numero' => 'Numero',
                'Monto Neto' => 'MONTO DEL VALE EN PESOS', 'Usado' => 'USADO EN PESOS', 'Debe' => 'SALDO NETO PESOS'
            ],
            self::VALE_DOLARES => [
                'Alta Db' => 'Fecha', 'Moneda' => 'Moneda', 'Nombre del Cliente' => 'Nombre del Cliente', 'Numero' => 'Numero',
                'Monto Neto' => 'MONTO DEL VALE EN DOLARES', 'Usado' => 'USADO EN DOLARES', 'Debe' => 'SALDO NETO DOLARES'
            ],
            self::VALE_PESOS_TRANSFORMADOS_A_DOLARES => [
                'Alta Db' => 'Fecha', 'Moneda' => 'Moneda', 'Nombre del Cliente' => 'Nombre del Cliente', 'Numero' => 'Numero',
                'Monto Neto' => 'MONTO DEL VALE EN DOLARES', 'Usado' => 'USADO EN DOLARES', 'Debe' => 'SALDO NETO DOLARES',
                'Tipo Cambio' => 'Tipo Cambio', 'Monto Real recibido' => 'Valor en PESOS'
            ]
        ];
        return ['headers' => $headers, 'vales' => $vales];
    }

    /**
     * @param array $buffer json_decode(param("exportBuffer"), true)
     * @return array
     */
    public function decode(array $buffer):array {
        $class = [];
        foreach(reset($buffer) as $c)
            $class[$c[1]] = $c[2];

        $fieldNames = array_keys($class);
        $rows = [];
        foreach($buffer as $index => $buff) {
            if($index === 0)
                continue;
            $row = [];
            foreach($fieldNames as $key => $fieldName)
                $row[$fieldName] = $buff[$key][1] ?? '';
            $rows[] = $row;
        }
        return ['label' =>  array_combine($fieldNames, $fieldNames), 'class' => $class, 'rows' => $rows];
    }
}