<?php
/** @noinspection PhpRedundantOptionalArgumentInspection */
/** @noinspection HtmlUnknownTarget */

use Iac\inc\sql\IacSqlBuilder;

class FilterIt {
    const PRODUCTO_BODEGA_ESTATUS = [
        'pedir' => 'Vale Pedir',
        'es_saldo' => 'Dead Stock',
        'en_remate' => 'Saldo',
        'super_lento' => 'Super Lento',
        'lento' => 'Lento',
      //  'oculto' => 'Ocultos',

       //  'con_existencia_quantity' => "∃ Quantity",
          //  'escondido' => 'Ver Escondidos, solo sin ∃',
        ];
    protected array $keyLabels = [
        'entrada_salida' => ['Entrada'=>'Entrada', 'Salida'=>'Salida'],
        'tipo' => [
            'Movimiento' => 'Venta Tienda',
            'Devolucion' => 'Devolución',
            // 'Venta Cliente' => 'Venta Cliente',
            'Devolucion Fabricante' => 'Venta Container',
            'Traslado' => 'Traslado',
            'Container' => 'Importación',
            'Correccion' => 'Ajuste',
            'Cancelacion' => 'Cancelacion',
            'Borrado' => 'Borrado',
        ],
        'tipo_nota' => [
            'CASH' => 'CASH',
            'NOTA' => 'NOTA',
            'PIÑA' => 'PIÑA',
            'OTRO' => 'OTRO',
        ],

        'dialog_existencia_status' => [
            'Ver tambien' => null,
            'donde' => 'Ver Donde',
            'ceros' => 'Ver Ceros',
            'Filtrar por' => null,
            'negativos' => '<img src="/vitex/img/t.gif" class="filterItStatusImage" alt=" "> Negativos',
            'sin_existencia' => '<img src="/vitex/img/t.gif" class="filterItStatusImage" alt=" "> Existencia Cero',
            'saldo' => '<img src="/vitex/img/S.png" class="filterItStatusImage" alt="S" title="Saldos: ¡precio bajo!"> Saldos',
            'super_saldo' => "<img src='/vitex/img/SS.png' class='filterItStatusImage' alt='S' title='¡Dead Stock!: A Precio muy reducido'> Dead Stock",
            'lento' => "<img src='/vitex/img/L.png' class='filterItStatusImage' alt='L' title='Lento: Vendeme, se vende poco'> Lento",
            'super_lento' => '<img src="/vitex/img/SL.png" class="filterItStatusImage" alt="L" title="Super Lento: Casí no se vende. Es Importante venderlo"> Super Lento',
        ],
        'tipo_inconsistencia' => [
                'Destino Match' => 'Destino Match',

                'clientes' => 'Clientes',
                'ayudantes' => 'Ayudantes',
                'pedido_por' => 'Pedido Por',
                'numero_compra' => 'Número de Compra',

                'Campos Cash' => 'Campos Cash',
                'tipo_nota' => 'Tipo Venta',
                'numero_tipo_nota' => 'Tipo Venta Número',
                'quantity_tipo_nota' => 'Tipo Venta Quantity',
                'tipo_nota_pina' => 'Venta Tipo Piña',

                'chofer_responsable' => 'Chofer Responsable',

                'fecha' => 'Fecha',
                'contra_nota' => 'Contra Nota',
                'average' => 'Average',

        ],
        'inconsistencia_destino_match' => [
            'ayudantes' => 'Ayudantes',
            'clientes' => 'Clientes',
            'numero_compra' => 'Número de Compra',
            'pedido_por' => 'Pedido Por',

        ],
        // valores en null ya sabe llenarlos de la db en $this->readCatalog
        'banco_id' => null,
        'banco_cuenta_id' => null,
        'bodega_id' => null,
        'dialogo_bodega_id' => null,
        'cliente_id' => null,
        'color_id' => null,
        'empresa_id'  => null,
        'origen_bodega_id' => null,
        'origen_id' => null,
        'producto_general_id' => null,
        'producto_id' => null,
        'tienda_id' => null,
        'nick' => null,
        'iac_usr_id' => null,
    ];

    protected array $keyTitle = [
        'saldo' => 'Saldos: ¡precio bajo!',
        'super_saldo' => '¡Dead Stock!: A Precio muy reducido',
        'lento' => 'Lento: Vendeme, se vende poco',
        'super_lento' => 'Super Lento: Casí no se vende. Es Importante venderlo',
    ];

    protected array $keyHeader = [
        'es_algo_id' => 'Es Algo', // Es Algo seria el label del(los) inputs name='es_algo_id[]'
        'fechas' => 'Fecha',
        'dialog_existencia_status' => 'Status',
    ];
    
    protected array $defaults;
    protected array $defaultsConAll;

    /**
     * @param array<string,int|string|array<int,string|array>> $defaults
     * @param array|null $request
     * @param array<string,array<int|string,string>> $keyLabels
     * @param array $keyTitle
     */
    public function __construct(array $defaults, array|null $request, array $keyLabels =[], array $keyTitle = []) {
        $this->fixDates($defaults);
        $this->fixDates($request);
        $this->set_defaults($defaults, $request);
        if(!empty($keyLabels))
            $this->keyLabels = array_merge($keyLabels, $this->keyLabels);
        if(!empty($keyTitle))
            $this->keyHeader = array_merge($keyTitle, $this->keyHeader);
    }

    protected function fixDates(&$defaults) {
        if(!empty($defaults['fecha_min']) && !empty($defaults['fecha_max']) && $defaults['fecha_min'] > $defaults['fecha_max'] ) {
            $min = $defaults['fecha_min'];
            $defaults['fecha_min'] = $defaults['fecha_max'];
            $defaults['fecha_max'] = $min;
        }
    }
    protected function get_AllKey(string $key):string {
        return $key . '_all';
    }

    protected function set_defaults(array $defaults, array|null $request):void {
        if($request === null)
            $request = $_REQUEST ?? [];
        $this->defaults = $defaults;
        $this->defaultsConAll = [];
        foreach($defaults as $key => $_) {
            $keyAll = $this->get_AllKey($key);
            if(!empty($request[$keyAll]))
                $this->defaultsConAll[$keyAll] = $request[$keyAll];
        }
    }

    public function getWhere(array $onlyFor = [], string|array $tablePrefix = '', array $fieldName =[]):string {
        if(empty($onlyFor))
            $onlyFor = array_keys($this->defaults);
        $where = [];
        $builder = new IacSqlBuilder();
        foreach($onlyFor as $campo)
            if(!endsWith($campo, '_all') && !empty($this->defaults[$campo])  ) {
                if(!empty($this->defaultsConAll[$this->get_AllKey($campo)]))
                    continue;
                $prefix = is_array($tablePrefix) ? $tablePrefix[$campo] ?? '' : $tablePrefix;
                if($campo === 'fecha_min') {
                    $field = $fieldName['fecha'] ?? $fieldName['fecha_min'] ?? 'fecha';
                    $where[] = " {$prefix}$field >= " . strit($this->defaults[$campo]);
                } elseif($campo === 'fecha_max') {
                    $field = $fieldName['fecha'] ?? $fieldName['fecha_max'] ?? 'fecha';
                    $where[] = " {$prefix}$field <= " . strit($this->defaults[$campo]);
                } else {
                    $field = $fieldName[$campo] ?? $campo;
                    $where[] = $builder->where([$prefix . $field => $this->defaults[$campo]]);
                }
            }
        return empty($where) ? '' : '(' . implode(" AND ", $where) . ')';
    }

    public function getDescripcion(array $onlyFor = []):array {
        if(empty($onlyFor))
            $onlyFor = array_keys($this->defaults);
        $describe = [];
        foreach($onlyFor as $campo) {
            $campo = 3;
        }
        return $describe;
    }

    public function filterDefault($incluyeColoresEnNo = false):string {
        global $gAppRelate;
        $filtro = [];
        $done = [];

        foreach($this->defaults as $key => $_) {
            switch($key) {
                case 'fecha_min':
                case 'fecha_max':
                    $doneName = 'fechas';
                    if(!array_key_exists($doneName, $done)) {
                       $filtro[] = $this->filterDates($this->keyHeader['fecha'] ?? 'Fecha');
                       $done[$doneName] = true;
                    }
                    break;
                case 'dialog_existencia_status':
                    $filtro[] = $this->filterManyFor($key, false);
                    break;
                case 'producto_general_id':
                case 'color_id':
                    $doneName = 'producto';
                    if(array_key_exists($doneName, $done))
                        break;
                    if(array_key_exists('producto_general_id', $this->defaults))
                        if(array_key_exists('color_id', $this->defaults))
                            $filtro[] = $this->filterProductoColor($this->keyHeader['producto'] ?? 'Productos', $incluyeColoresEnNo);
                        else
                            $filtro[] = $this->filterProducto($this->keyHeader['producto_general_id'] ?? 'Productos');
                    else
                        $filtro[] = $this->filterColor($this->keyHeader['color_id'] ?? 'Colores');
                    $done[$doneName] = true;
                    break;
                case 'articulo':
                    $filtro[] = $this->filterArticuloRegistrado($this->keyHeader['articulo'] ?? 'Artículos');
                    break;

                case 'pedir':
                case 'en_remate':
                case 'es_saldo':
                case 'super_lento':
                case 'lento':
                case 'oculto':
                case 'escondido':
                    $sqlComment = __METHOD__ . " " . $key;
                    if(array_key_exists('producto_bodega_estatus', $done))
                        break;
                    $done['producto_bodega_estatus'] = 'producto_bodega_estatus';
                    $filtro[] =
                        "<fieldset class='filterIt'>" .
                        $this->selectsMany('Status', self::PRODUCTO_BODEGA_ESTATUS,
                        [
                            'oculto' => ['' => 'Ambos', 'Si' => 'Solo ocultos', 'No' => 'Solo Visibles'],
                            'escondido' => ['' => 'Ambos', 'Si' => 'Solo escondidos', 'No' => 'Solo Visibles'],
                            'con_existencia_quantity' => ['' => 'Ambos', 'Hay' => 'Con ∃', 'ne0' => '∃ ≠ Cero', 'lt0' => '∃ Negativa' ],
                        ],
                        [
                            'pedir' => ['No' => 'class="rojo"'],
                            'oculto' => ['Si' => 'class="rojo"'],
                            'escondido' => ['Si' => 'class="rojo"'],
                            'con_existencia_quantity' => ['lt0' => 'class="rojo"'],
                        ],
                        "statusAndOr"
                    ) .
                        $this->selectsMany('∃', [
                            'oculto' => '<span style="color:rgb(255,0,255)">Ocultos</span>',
                            'con_existencia_quantity' => "∃ Quantity",
                            'unidades_id' => "Unidad",
                        ],
                            [
                                'oculto' => ['' => 'Ambos', 'Si' => 'Solo ocultos', 'No' => 'Solo Visibles'],
                                'con_existencia_quantity' => ['' => 'Ambos', 'Hay' => 'Con ∃', 'ne0' => '∃ ≠ Cero', 'lt0' => '∃ Negativa' ],
                                'unidades_id' => [...[''=>''], ...ia_sqlKeyValue("SELECT /*$sqlComment*/ unidad, unidad FROM unidades ORDER BY 2")]
                            ],
                            [
                                'oculto' => ['Si' => 'class="rojo"'],
                                'con_existencia_quantity' => ['lt0' => 'class="rojo"'],
                            ]) .

                    "</fieldset>";
                    break;
                default:
                    if(method_exists($this, $key))
                        $filtro[] = $this->$key();
                     else {
                       $keyLabel = $this->readCatalog($key);
                       if(!empty($keyLabel))
                           $filtro[] = $this->selectMany($keyLabel, $key);
                       elseif(array_key_exists($key, $gAppRelate->enums)) {
                           $filtro[] = $this->selectMany($gAppRelate->enums[$key], $key, true);
                       }
                    }
            }
            $done[$key] = true;
        }
        return implode("\r\n",  $filtro);
    }

    protected function selectsMany($legend, $keyLabel, $keyOptions = [], $keyAttributes = [], $andOrName = ''):string {
        $andOrDone = false;
        $rows = '';
        foreach($keyLabel as $key => $label) {
            if(!isset($keyOptions[$key]))
                $keyOptions[$key] = ['' => '', 'Si' => 'Si', 'No' => 'No'];

            $rows .=
                "<tr><td class='filterItLabel' style='padding-top:0.7em'><label for='filterIt_$key'>$label</label>" .
                "<td class='filterItSelect' style='padding-top:0.7em'><select form='ElFiltro' class='notSelectize' name='$key' id='filterIt_$key'>" .
                $this->options($keyOptions[$key], $this->defaults[$key] ?? '',
                    $keyAttributes[$key] ?? []) .
                "</select>";
        }
        if(!$andOrDone && $andOrName !== '') {
            $andValue = checked('and', $this->defaults[$andOrName] ?? 'or');
            $orValue = checked('or', $this->defaults[$andOrName] ?? 'or');
            $rows .= "<tr><td colspan='2' style='text-align: center;padding-top:1.1em'>
                <label for='filterIt_And_$andOrName'>AND </label><input type='radio' $andValue name='$andOrName' id='filterIt_And_$andOrName' form='ElFiltro'>
                <label for='filterIt_Or_$andOrName'>OR </label><input type='radio' $orValue name='$andOrName' id='filterIt_Or_$andOrName' form='ElFiltro'>
            ";
        }
        return "<fieldset class='filterIt'><legend>$legend</legend><table>$rows</table></fieldset>";
    }

    protected function options(array $OptionsValueLabel, array|string $selectValues, array $keyAttributes = []):string {
            $ret = '';
            foreach($OptionsValueLabel as $value => $label) {
                $selected = (is_string($selectValues) && strcasecmp($value, $selectValues) === 0) ||
                    (is_array($selectValues) && in_iarray($value, $selectValues)) ?
                    ' SELECTED="SELECTED"' : '';
                $ret .= "\r\n<option value='" . htmlentities($value) . "' " . ($keyAttributes[$value] ?? '') . $selected . ">" .
                    htmlentities($label) . "</option>";

            }
            return $ret;
    }


    /** @noinspection PhpUnused */
    public function dialogo_bodega_id($id = 'dialogo_bodega_id'):string {
        $bodegas = $this->selectMany($this->readCatalog('bodega_id'), $id);
        $opt = "";
        $grupos = ia_sqlVector("SELECT DISTINCT grupo FROM bodega WHERE grupo <> '' AND activo = 'Si' ORDER BY 1");
        foreach($grupos as $g) {
            $gh = htmlentities($g);
            $opt .= "<option value='$gh'>$gh</option>";
        }
        return <<< HTML
<div>
    $bodegas<br>
    <label><sup style="font-size:1em">Grupo </sup>
    <select onchange="{$id}_changer(this)" class="notSelectize">
        <option value="all" selected="selected"></option>
        <option value="">(SIN GRUPO)</option>
        $opt
    </select>
    </label>
    <script>
    function {$id}_changer(el) {
         const grupo = el.value.toUpperCase();
         const gp = \$vitex_globales.g_cat_bodega2grupo;
         $('INPUT[name="$id\[]"]', $(el.form)).each(function() {
            this.checked = (gp[this.value] || "").toUpperCase()  === grupo;
         });
    }
</script>
</div>
HTML;
    }

    public function filterManyFor(string $default_id, bool $putAllMark = true):string {
        return
            $this->selectMany($this->readCatalog($default_id), $default_id, $putAllMark);
    }

    public function filterDates($title = 'fechas'):string {
        $title = $this->titleIt($title);
        $d = $this->defaults;
        foreach($d as &$value)
            $value = $this->htmlEntites($value);
        unset($value);
        $minDate = '2012-01-01';
        $maxDate = Date('Y-m-d', strtotime('tomorrow'));
        $varios = self::mesesAnterioresBoton();
        $hoy = Date('Y-m-d');
        $ayer = Date('Y-m-d', strtotime("yesterday"));
        $lunes = Date('D') === 'Mon' ? $hoy : Date('Y-m-d', strtotime("last monday"));
        $lunes2 = Date('D') === 'Mon' ? Date('Y-m-d', strtotime("last monday")) :
            Date('Y-m-d', strtotime("1 mondays ago"));
        $saturday = Date('Y-m-d', strtotime("last sunday"));
        return <<< HTML
        <fieldset class="filterIt"><legend>$title</legend>
            <div class="ventas_flexCol">
                <div class="ventas_flexRow">
                    <div class="filterItCen">
                        <label for="fecha_min_viewdate">Del</label>
                        <input autocomplete="off" type="text" placeholder="Del" name="fecha_min_viewdate" class="datepicker" id="fecha_min_viewdate" max="$maxDate" min="$minDate" value="$d[fecha_min]">
                        <input type="hidden" id="fecha_min" name="fecha_min" value="$d[fecha_min]">
                        <span style="cursor:pointer" onclick="filterUtil.setDate();">✗</span></div>
                    <div class="filterItCen">
                        <label for="fecha_max_viewdate">Al&nbsp;</label>
                        <input autocomplete="off" type="text" placeholder="Al" class="datepicker" id="fecha_max_viewdate" max="$maxDate" min="$minDate" value="$d[fecha_max]" >
                        <input type="hidden" id="fecha_max" name="fecha_max" value="$d[fecha_max]">
                        <span style="cursor:pointer" onclick="filterUtil.setDate();">✗</span></div>
                </div>
                
               <fieldset style="display:flex;justify-content: space-around;padding-right:0.3em;">
                    <button title="Hoy" class="ventas_toolbar_btn" type="button" onclick="filterUtil.setDate('$hoy', '$hoy', '$hoy');">Hoy</button>
                    <button title="Ayer" class="ventas_toolbar_btn" type="button" onclick="filterUtil.setDate('$ayer', '$ayer', '$ayer');">Ayer</button>  
                    <button title="Del lunes a hoy" class="ventas_toolbar_btn" type="button" onclick="filterUtil.setDate('$lunes', '$hoy', '$hoy');">Esta Semana</button>  
                    <button title="Lunes a Domingo" class="ventas_toolbar_btn" type="button" onclick="filterUtil.setDate('$lunes2', '$saturday', '$saturday');">Semana Pasada</button>  
                    
                    <button class="ventas_toolbar_btn" type="button" onclick="filterUtil.setDate('este_ano');">Este año</button>
                </fieldset>
                
                <fieldset style="display:flex;flex-wrap: wrap; justify-content: flex-start;;padding-right:0.3em;margin-top:1em;max-width:30em">
                    <legend style="font-size:1em;font-weight: normal">Por Mes</legend>
                    $varios                   
                </fieldset>

                <fieldset style="display:flex;justify-content: space-around;padding-right:0.3em;">
                <legend style="font-size:1em;font-weight: normal">
                    Últimos Días              
                </legend>
                    <div><button title="Ayer y Hoy" class="ventas_toolbar_btn" type="button" onclick="filterUtil.setDate(-1);">1 </button></div>
                    <div><button title="Antier, ayer y hoy" class="ventas_toolbar_btn" type="button" onclick="filterUtil.setDate(-2);">2 </button></div>
                    <div><button class="ventas_toolbar_btn" type="button" onclick="filterUtil.setDate(-3);">3 </button></div>
                    <div><button class="ventas_toolbar_btn" type="button" onclick="filterUtil.setDate(-4);">4 </button></div>
                    <div><button class="ventas_toolbar_btn" type="button" onclick="filterUtil.setDate(-5);">5 </button></div>
                    <div><button class="ventas_toolbar_btn" type="button" onclick="filterUtil.setDate(-6);">6 </button></div>
                    <div><button class="ventas_toolbar_btn" type="button" onclick="filterUtil.setDate(-7);">7 </button></div>
                    <br>
                    <div><button class="ventas_toolbar_btn" type="button" onclick="filterUtil.setDate(-15);">15 </button></div>
                    <div><button class="ventas_toolbar_btn" type="button" onclick="filterUtil.setDate(-20);">20 </button></div>
                    <div><button class="ventas_toolbar_btn" type="button" onclick="filterUtil.setDate(-30);">30 </button></div>
                    <div><button class="ventas_toolbar_btn" type="button" onclick="filterUtil.setDate(-60);">60 </button></div>
                    <div><button class="ventas_toolbar_btn" type="button" onclick="filterUtil.setDate(-90);">90 </button></div>
                    <div><button class="ventas_toolbar_btn" type="button" onclick="filterUtil.setDate(-120);">120 </button></div>
                    <div><button class="ventas_toolbar_btn" type="button" onclick="filterUtil.setDate(-150);">150 </button></div>
                    <div><button class="ventas_toolbar_btn" type="button" onclick="filterUtil.setDate(-180);">180 </button></div>
                    <div><button class="ventas_toolbar_btn" type="button" onclick="filterUtil.setDate(-365);">365 </button></div>
                    
                </fieldset>
            </div>
        </fieldset>
        HTML;
    }

    public static function mesesAnterioresBoton($numMeses = 13) {
        $botones = [];
        $current = Date('Y-m-01');
        for($i = 1; $i <= $numMeses; ++$i) {
            $min = $current;
            $timestamp = strtotime($current);
            $minLabel = Date('j/M/y D', $timestamp);
            $label = Date('M y', $timestamp);
            $last = Date('Y-m-t', $timestamp);
            $lastLabel = Date('j/M/y D', strtotime($last));

            $botones[] = "<div style='flex: 16.66%;'><button class='ventas_toolbar_btn' title='$minLabel al $lastLabel' type='button' onclick=\"filterUtil.setDate('$min', '$last');\">$label</button></div>";
            $current = Date('Y-m-01', strtotime('last month', $timestamp  ));
        }
        return implode($botones);
    }
    public function filterProducto($title = 'Producto:'):string {
        $productosInit = json_encode($this->defaults['producto_general_id'] ?? '');
        // es por class que se activa
        return <<< HTML
        <div data-soy="buscaProducto" class="flexItem">
            <label for="producto_general_id" class="bold lbl reporte_txtSubTitulos">$title</label>
            <div class="InputAddOn"><!-- class  ignore_hotkey -->
                <select data-init='$productosInit' name="producto_general_id[]" multiple="multiple" class="buscador_productos notSelectize" style="width:24em;" data-placeholder='Seleccione producto(s)'></select>
                <span style="cursor:pointer" title="Limpiar producto" onclick="filterUtil.limpiaSelectize('producto_general_id[]', this.parentElement);" style="visibility: visible; margin-right: 0.3em;color:silver;font-weight:100">✗</span>
            </div>
        </div>
HTML;
}

    public function filterColor($title = 'Color:'):string {
        $colorInit = json_encode($this->defaults['color_id'] ?? '');
        return <<< HTML
        <div  data-soy="buscaColor"  class="flexItem">
            <label for="color_id" class="bold lbl reporte_txtSubTitulos">$title</label>
            <div class="InputAddOn">
                <select data-init='$colorInit'  name="color_id[]" data-placeholder="Seleccione color(es)" multiple="multiple" class="buscador_colores notSelectize" style="width:16em;"></select>
                <span style="cursor:pointer" title="Limpiar color" onclick="filterUtil.limpiaSelectize('color_id[]', this.parentElement);" style="visibility: visible; margin-right: 0.3em;">✗</span>
            </div>
        </div>
HTML;
    }

    /**
     * Selecciona en un select Producto y en otro color
     *
     * @param $title
     * @return string
     */
    public function filterProductoColor($title = 'Productos', $incluyeColoresEnNo = false):string {
        $productosInit = json_encode($this->defaults['producto_general_id'] ?? '');
        $colorInit = json_encode($this->defaults['color_id'] ?? '');
        $dataColoresPosibles = $incluyeColoresEnNo ? 'data-coloresposibles="1"' : '';
        return <<< HTML
        <fieldset class='filterIt' style='width:fit-content;display:flex;flex-direction:column;'><legend>$title  
        <span style="cursor:pointer;color:black" title="Reset, Limpiar producto y color" 
            onclick="filterUtil.limpiaSelectize('producto_general_id[]');filterUtil.limpiaSelectize('color_id[]');" style="visibility: visible; margin-right: 0.3em;font-weight: 100">✗</span>
        </legend>
            <div data-soy="productoColor" class="flexRow">
                <div data-soy="buscaProducto" class="flexItem">
                    <label for="producto_general_id" class="bold lbl reporte_txtSubTitulos">Producto:</label>
                    <div class="InputAddOn">
                        <select data-init='$productosInit' name="producto_general_id[]" multiple="multiple" class="buscador_productos" style="width:24em;" data-placeholder='Seleccione producto(s)'></select>
                        <span style="cursor:pointer" title="Limpiar producto" onclick="filterUtil.limpiaSelectize('producto_general_id[]', this.parentElement);" style="visibility: visible; margin-right: 0.3em;font-weight: 100">✗</span>
                    </div>
                </div>
                <div  data-soy="buscaColor"  class="flexItem">
                    <label for="color_id" class="bold lbl reporte_txtSubTitulos">Color:</label>
                    <div class="InputAddOn">
                        <select $dataColoresPosibles data-init='$colorInit' name="color_id[]" data-placeholder="Seleccione color(es)" multiple="multiple" class="buscador_colores" style="width:16em;"></select>
                        <span style="cursor:pointer" title="Limpiar color" onclick="filterUtil.limpiaSelectize('color_id[]', this.parentElement);" style="visibility: visible; margin-right: 0.3em;">✗</span>
                    </div>
                </div>
            </div>
        </fieldset>
HTML;
    }

    /**
     * Producto-Color en un solo select, registrados
     *
     * @param $title
     * @return string
     */
    public function filterArticuloRegistrado(string $title = 'Artículo'):string {
        $articuloInit = json_encode($this->defaults['articulo'] ?? '');
        return <<< HTML
        <fieldset class='filterIt' style='width:fit-content;display:flex;flex-direction:column;'><legend>$title</legend>
            <div class="flexRow">
                <div class="flexItem">
                    <label for="articulo_full" class="bold lbl reporte_txtSubTitulos">Producto:</label>
                    <div class="InputAddOn">
                        <select data-init='$articuloInit' name="articulo_full[]" multiple="multiple" class="buscador_articulo_full" style="width:48em;" data-placeholder='Seleccione articulo(s)'></select>
                        <span style="cursor:pointer" title="Limpiar producto" onclick="filterUtil.limpiaSelectize('articulo_full[]', this.parent);" style="visibility: visible; margin-right: 0.3em;font-weight: 100">✗</span>
                    </div>
                </div>
            </div>
        </fieldset>
HTML;
    }

    // Despliega Auxiliares

    /**
     * @param string|array|null $d
     * @return string|array
     */
    protected function htmlEntites(string|array|null $d):string|array {
        if(empty($d))
            return '';
        if(is_array($d)) {
            foreach($d as &$v)
                $v = $this->htmlEntites($v);
            return $d;
        }
        return htmlentities($d);
    }

    /**
     * @param string $display_id
     * @return string
     */
    protected function titleIt(string $display_id):string {
        if(array_key_exists($display_id, $this->keyHeader))
            return $this->keyHeader[$display_id];
        return ucwords(str_replace(['_id', '_'], ' ', $display_id));
    }

    /**
     * @param array $keyValue
     * @param string $name
     * @param bool $putAllMark
     * @param string $legend
     * @return string
     */
    protected function selectMany(array $keyValue, string $name, bool $putAllMark = true, string $legend = ''):string {
        return $this->checkBoxEnum($keyValue, $name, $putAllMark, $legend);
    }

    /**
     * @param array $valueLabel
     * @param string $name
     * @param bool $putAllMark
     * @param string $legend
     * @return string
     */
    protected function checkBoxEnum(array $valueLabel, string $name, bool $putAllMark = true, string $legend = ''):string {
        $title = empty($legend) ? $this->titleIt($name) : $legend;
        $checkBoxAllName = $this->get_AllKey($name); // $name . '_all';
        $allChecked = !empty($this->defaults[$checkBoxAllName] ?? '');
        $nameArray = $name . '[]';
        $onClickUnset = " onclick=\"htmlUtil.allUnSet('$nameArray', '$checkBoxAllName')\" ";
        $idI = 0;
        $ret = [];
        foreach($valueLabel as $value => $label) {
            if($label === null) {
                $ret [] = "<dt class='filterItCheckboxSeparator'>$value";
                continue;
            }
            $idI++;
            $id = $name . $idI;
            $checked = checked($value, $allChecked ? $value : $this->defaults[$name] ?? '');
            $ret [] =
                "<dt><input type='checkbox' $checked id='$id' name='$nameArray' $onClickUnset >".
                " <label for='$id'>" . $label . "</label></dt>";
        }
        if($putAllMark) {
            $lastLetter = substr(trim($title), -1);
            $genero = $lastLetter === 'a' ? 'Todas' : 'Todos ';
            //$idI++;
            $id = $checkBoxAllName;
            $checked = checked('all', $this->defaults[$checkBoxAllName] ?? '');
            $all = "<dt class='filterItAll'><input type='checkbox' $checked name='$checkBoxAllName' id='$id'
               class='filterItAll' onclick='htmlUtil.setAll(\"$nameArray\", this.checked)'>
               <label class='filterItAll' for='$id'>$genero</label></dt>";
        } else {
            $all = '';
        }
        return
         "<fieldset class='filterIt' style='width:fit-content'>
            <legend><label for='$checkBoxAllName'>$title</label></legend>
            <dl class='filterIt'>$all ". implode("", $ret) . '</dl>
         </fieldset>';
    }

    /**
     * @param string|array $pk
     * @return array<int|string,string>
     */
    protected function readCatalog(string|array $pk):array {
        $key = is_array($pk) ? implode(', ', $pk) : $pk;
        if(!empty($this->keyLabels[$key]))
            return $this->keyLabels[$key];
        $method = __METHOD__;
        switch(strtolower($key)) {
            case 'banco_id':
                return $this->keyLabels[$key] =
                    $this->getKeyValue("SELECT /*$method*/ banco_id, clave FROM banco ORDER BY 2");
            case 'banco_cuenta_id':
                return $this->keyLabels[$key] =
                    $this->getKeyValue("SELECT /*$method*/ banco_cuenta_id, nombre FROM banco_cuenta
                                         WHERE vale='Active' AND banco_china = 'No' ORDER BY 2");
            case 'bodega_id':
                return $this->keyLabels[$key] =
                    $this->getKeyValue("SELECT /*$method*/ bodega_id, bodega FROM bodega WHERE activo='Si' ORDER BY 2");
            case 'cliente_id':
                return $this->keyLabels[$key] = // duda AND interno = 'No'
                    $this->getKeyValue("SELECT /*$method*/ cliente_id, nombre FROM cliente WHERE cliente AND vale='Active' ORDER BY 2");
            case 'color_id':
                return $this->keyLabels[$key] =
                    $this->getKeyValue("SELECT /*$method*/ color_id, color FROM color WHERE activo='Si' ORDER BY 2");
            case 'cuentat_id':
                return $this->keyLabels[$key] =
                    $this->getKeyValue("SELECT cuentaT_id, usuario FROM cuentat WHERE vale='Active' ORDER BY 2");
            case 'empresa_id':
                return $this->keyLabels[$key] =
                    $this->getKeyValue("SELECT /*$method*/ empresa_id, empresa FROM empresa WHERE vale='Active' ORDER BY 2");
            case 'producto_general_id':
            case 'producto_id':
            return $this->keyLabels['producto_general_id'] = $this->keyLabels['producto_id'] =
                    $this->getKeyValue("SELECT /*$method*/ producto_general_id, producto FROM producto_general WHERE activo='Si' ORDER BY 2");
            case 'origen_bodega_id':
            case 'origen_id':
                $sql = "SELECT /*$method*/ origen_bodega_id, clave FROM origen_bodega
                    WHERE activo='Si' AND es IN('GRUPO BODEGA', 'bodega', 'tienda', 'IMPORTACION', 'correccion') ORDER BY 2";
                return $this->keyLabels['origen_bodega_id'] = $this->keyLabels['origen_id'] = $this->getKeyValue($sql);
            case 'tienda_id':
                return $this->keyLabels[$key] =
                    $this->getKeyValue("SELECT /*$method*/ tienda_id, clave FROM tienda WHERE vale='Active' ORDER BY 2");
            case 'nick':
                return $this->keyLabels[$key] =
                    $this->getKeyValue("SELECT /*$method*/ nick, nick FROM iac_usr WHERE vale='Active' ORDER BY 2");
            case 'iac_usr_id':
                return $this->keyLabels[$key] =
                    $this->getKeyValue("SELECT /*$method*/ iac_usr_id, nick FROM iac_usr WHERE vale='Active' ORDER BY 2");
        }
        return [];
    }

    /**
     * @param string $sql
     * @return array<int|string,string>
     */
    protected function getKeyValue(string $sql):array {
        $ret = ia_sqlKeyValue($sql);
        return $ret === false ? [] : $ret;
    }

}
