<?php /** @noinspection PhpUnused */


class FormatIt {

    public static function numberClean($s) {
        // scientific notation not accepted
        return preg_replace('/[^\d.\-+]/mS', '', strim($s));
    }

    public static function number_format($number, $decimals = 0, $dec_point = '.', $thousand_sep = ',') {
        if(!is_numeric($number)) {
            return $number;
        }
        return number_format($number, $decimals, $decimals == 0 ? '' : $dec_point, $thousand_sep) ;
    }

    /**
     * Format bytes into readable units Kb, Mb,..
     *
     * @param int $bytes
     * @return string
     */
    public static function bytes2units($bytes) {
        if(empty($bytes) || !is_numeric($bytes))
            return $bytes;
        if($bytes < 0) {
            $signo = '-';
            $bytes *= -1;
        } else
            $signo = '';
        if($bytes < 1024) {
            $decs = 0;
            $punto = '';
        } else {
            $decs = 2;
            $punto = '.';
        }
        $unit =['b', 'Kb', 'Mb', 'Gb', 'Tb', 'Pb'];
        return $signo.number_format(
            $bytes/pow(1024, ($i=floor(log($bytes,1024)))),
            $decs,$punto,
            ','
            ).' '.$unit[$i];
    }

    /**
     * Transform units (1K) to bytes 1024
     *
     * @param string $num 1K o 2048
     * @return string number of bytes
     */
    public static function units2bytes($num) {
        if(empty($num)) {
            return 0;
        }
        $units = '';
        $n = str_replace(' ', '', $num); //TODO all spaces ie unicode spaces?
        $len = mb_strlen($n,'UTF-8');
        for($i = 1; $i <= $len; $i++) {
            $u = mb_substr($n, -$i, 1, 'UTF-8');
            if(ctype_digit($u) || $u === '.') {
                break;
            }
            $units = $u.$units;
        }
        $units = mb_convert_case($units, MB_CASE_UPPER);
        $val = str_replace(',', '', mb_substr($num,0,$len-$i+1,'UTF-8'));

        if($units === '' || $units === 'B') {
            return  $val;
        }
        static $byteUnits = array(
            'K'=>1024, 'KB' => 1024,
            'M'=>1048576, 'MB' => 1048576,
            'G'=>1073741824, 'GB' => 1073741824,
            'T'=>1099511627776, 'TB' => 1099511627776
        );

        if(isset($byteUnits[$units]))
            return $val * $byteUnits[$units];
        return false;
    }

    /** @noinspection PhpUnused */
    /**
     * Convert integer to roman number
     *
     * @param int $decimalInteger
     * @return string
     */
    public static function toRomanNumerals($decimalInteger) {
        //http://usefulphp.blogspot.com/2010/04/convert-integers-to-roman-numerals.html
        $n = intval($decimalInteger);
        $res = '';
        $roman_numerals = [
            'M'  => 1000,
            'CM' => 900,
            'D'  => 500,
            'CD' => 400,
            'C'  => 100,
            'XC' => 90,
            'L'  => 50,
            'XL' => 40,
            'X'  => 10,
            'IX' => 9,
            'V'  => 5,
            'IV' => 4,
            'I'  => 1
        ];
        foreach ($roman_numerals as $roman => $numeral)  {
            $matches = intval($n / $numeral);
            $res .= str_repeat($roman, $matches);
            $n = $n % $numeral;
        }
        return $res;
    }

    /**
     * Formats milliseconds strings with time units
     *
     * @param number $t0 the number of milliseconds to format
     * @return string formatted lapsed time in milliseconds
     */
    public static function milliSecondsFormat($t0) {
        if(empty($t0) || !is_numeric($t0)) {
            $t0 = 0;
        }
        if($t0 < 0) {
            $t0 = -1 * $t0;
        }
        if($t0 >= 60*60*24) {
            return ">= 1 day not supported"; //@TODO milliSecondsFormat support 1 day adnd more
        }
        return strim( str_replace(
             array('0 h','00 min','00 sec',' 01',' 02',' 03',' 04',' 05',' 06',' 07',' 08',' 09')
             ,array('','',''               ,' 1',' 2',' 3',' 4',' 5',' 6',' 7',' 8',' 9')
            ,gmDate(' G \h i \m\i\n s \s\e\c '.(round($t0-floor($t0),3)*1000).' \m\s',floor($t0) )
        ));
    }

    public static function roundDownTo($n, $roundTo) {
        if($roundTo >= 1) {
            return  floor($n / $roundTo) * $roundTo;
        }
        $parts = 1 / $roundTo;
        return floor($n * $parts) / $parts;
    }

    public static function roundUpTo($n, $roundTo) {
        if($roundTo >= 1) {
            return ceil($n / $roundTo) * $roundTo;
        }
        $parts = 1/$roundTo;
        return ceil($n * $parts) / $parts;
    }

    public static function roundTo($n, $roundTo, $mode = PHP_ROUND_HALF_UP) {
        if($roundTo >= 1) {
            return round($n/$roundTo, 0, $mode) * $roundTo;
        }
        $parts = 1/$roundTo;
        return round($n * $parts, 0, $mode)/$parts;
    }

    /**
     * @param $num
     * @return false|float|string|null
     * @throws Exception
     */
    public static function scientificNotation2num($num) {
        $posE = strpos($num, 'E');
        if($posE === false) {
            return $num;
        }
        if($posE === 0) {
            $posE = 1;
            $num = "1$num";
        }

        if($posE + 1 >= strlen($num)) {
            return substr($num, 0, -1);
        }
        $pow = substr($num, $posE + 1);
        if(strpos($pow, '.') !== false) {
            throw new Exception('Incorrect scientific notation. Decimals in exponent.');
        }
        $base = substr($num, 0, $posE);
        $decBase = strpos($base, '.');
        if($decBase === false) {
            $scale = 0;
        } else {
            $scale = strlen($base) - $decBase-1;
        }
        switch(bccomp($pow, '0', 0)) {
            case 1:
                if($decBase === false) {
                    return ltrim($base . str_repeat('0',  (int)$pow), '0');
                }
                return bcmul($base, '1' . str_repeat('0', (int)$pow), $scale);
                break;
            case -1:
                return bcdiv($base, '1'.str_repeat('0', -$pow), $scale - $pow);
                break;
            case 0:
                return $base;
                break;
        }
        throw new Exception('Incorrect scientific notation.');
    }
}
