<?php


//@TODO tel coountry code included? 10 chars y luego 1 o 2 para country code (y que tal 3)
//@TODO images, attachments
//@TODO connect dateFormatter
//@TODO tel whats, msg whats https://wa.me/331882000022 https://www.codegrepper.com/code-examples/html/whatsapp+link+in+html https://agvento.by/en/web-development-en/templates-for-links-to-messengers/
//@TODO twit, et al?
//     <a href="callto:skye_account">Link text</a>

define('HTML_PROTECT' , ENT_HTML401 | ENT_QUOTES | ENT_SUBSTITUTE | ENT_DISALLOWED);
class FormatMe {
    const HTML_PROTECT = ENT_HTML401 | ENT_QUOTES | ENT_SUBSTITUTE | ENT_DISALLOWED;
    protected array $fieldDefinition;

    protected $emailLinkPrefix = '';
    protected $emailLinkSufix = '';
    protected $telLinkPrefix = '';
    protected $telLinkSufix = '';
    protected $urlLinkPrefix = '';
    protected $urlLinkSufix = '';

    /**
     * FormatMe constructor.
     * @param $fieldDefinition
     */
    public function __construct(array $fieldDefinition) {
        $this->fieldDefinition = $fieldDefinition;
    }

    public function format($fieldName, $value, $decimals = null, $dateFormat = null) {
        $field = [];
        return ($field['prefix'] ?? '') .
            $this->_format($fieldName, $value, $decimals, $dateFormat, $field) .
            ($field['suffix'] ?? '');
    }

    public function html($fieldName, $value, $decimals = null, $dateFormat = null) {
        $field = [];
        $formatted = $this->_format($fieldName, $value, $decimals, $dateFormat, $field);
        if(empty($field))
            return htmlentities($formatted, HTML_PROTECT);
        if($field['notHtmlProtect'] ?? false) {
            return ($field['prefix'] ?? '') . $formatted . ($field['suffix'] ?? '');
        }
        switch( strtolower($field['type'] ?? '')) {
            case 'email':
            case 'tel':
            case 'url':
            default:
                return ($field['prefix'] ?? '') . htmlentities($formatted, HTML_PROTECT) . ($field['suffix'] ?? '');
        }
    }

    protected function _format($fieldName, $value, $decimals = null, $dateFormat = null, $fieldOutVar = []) {
        if(!array_key_exists($fieldName, $this->fieldDefinition))
            return $this->deduce($value, $decimals, $dateFormat);
        $field = $this->fieldDefinition[$fieldName];
        if(($field['numeric'] ?? false)) {
            return $this->number($value, $field['decimals'] ?? 2);
        } else {
            switch(strtolower($field['type'] ?? '')) {
                case 'datetime':
                case 'timestamp':
                    return $this->dateTime($value, $dateFormat); break;
                case 'date': return $this->date($value, $dateFormat); break;
                case '':  return $this->deduce($value); break;
                default: return "$value"; break;
            }
        }
    }

    public function deduce($value, ?string $decimals = null, $dateFormat = null) {
        if(is_null($value))
            return ($prefix ?? '') . ($suffix ?? '');
        if(is_numeric($value))
            return $this->number($value, $decimals ?? '2');
        if($this->isDateTime($value))
            return $this->dateTime($value, $dateFormat);
        if($this->isDate($value))
            return $this->date($value, $dateFormat);
        return "$value";
    }

    public function htmlDeduce($value, $decimals = null, $dateFormat = null) {
        if(filter_var($value, FILTER_VALIDATE_EMAIL))
            return $this->htmlEmail($value);
        //@TODO es tel?
        if(filter_var($value, FILTER_VALIDATE_URL))
            return $this->htmlUrl($value);
        return htmlentities($this->deduce($value, $decimals, $dateFormat), self::HTML_PROTECT);
    }

    public function number($value, int $decimals = 2) {
        return is_numeric($value) ?
            number_format($value, $decimals, $decimals === 0 ? '' : '.', ',') :
            $value;
    }

    public function date($anyDate, $dateFormat = 'd/M/y') {
        return "date formatted";
    }

    public function dateTime($anyDateTIme, $dateFormat = 'd/M/y G:i') {
        return "dateTime formatted";
    }

    public function htmlTel($tel, $textToShow = null, $prefix = null, $suffix = null) {
        return "<a href='tel:" . $this->toPhone($tel) . "'>" .
            htmlentities($prefix . ($textToShow ?? $tel) . $suffix, self::HTML_PROTECT) . '</a>';
    }

    public function htmlEmail($email, $textToShow = null, $prefix = null, $suffix = null) {
        return "<a href='mailto:" . htmlentities($email, self::HTML_PROTECT) . "'>" . htmlentities($prefix . ($textToShow ?? $email) . $suffix, self::HTML_PROTECT) . '</a>';
    }

    public function htmlUrl($url, $textToShow = null, $prefix = null, $suffix = null) {
        return "<a href='" . htmlentities($url, self::HTML_PROTECT) . "'>" . htmlentities($prefix . ($textToShow ?? $url) . $suffix, self::HTML_PROTECT) . '</a>';
    }

    protected function isDate($value)  {
        if($value instanceof  DateTimeInterface)
            return true;
        if(strlen($value) !== 10)
            return false;
        return $value[4] === '-' && $value[7] === '-';
    }

    protected function isDateTime($value) {
        if($value instanceof  DateTimeInterface)
            return true;
        if(strlen($value) < 19)
            return false;
        if($value[4] !== '-' || $value[7] !== '-')
            return false;
        if($value[10] !== ' ' && $value[10] !== 'T')
            return false;
    }

    protected function toPhone($tel) {
        return preg_replace('/[^0-9.]*/mS', '', $tel);
    }

    protected function isPhoneFromToPhone($tel) {
        return strlen($tel) === 0 && strpos($tel, '.') === false;
    }
}