<?php /** @noinspection PhpUnused */

/**
 *
 *
 * Ejemplo
 * $h = new HistTable('pedido_hist');
 * $h->addIgnoreFields(['rollos_entrada', 'quantity_entrada','nota_bodega']);
 * echo $h->getDiferencesTable($pedido_id);
 *
 *
 */
class HistTable {
    protected string $table_hist;
    /** @var string $pk primary key de la tabla con los datos originales  */
    protected string $pk;
    protected array $ignoreFields = ['alta_db', 'alta_por', 'ultimo_cambio', 'ultimo_cambio_por', 'iac_edits'];
    protected array $childsReKey = [];
    protected array $childsOnly = [];
    protected array $fueErrorFields = [];
    protected array $jsonObjectFields = [];
    protected array $jsonArrayFields = [];
    protected array $productoGeneralUnidades = []; // [producto_general_id=>Kg,..]
    protected int $resaltaHaceSegundos;

    /**
     * @param string $table_hist
     * @param string $pk
     */
    public function __construct( string $table_hist, int $resaltaHaceSegundos = 10*60, string $pk = '') {
        $this->table_hist = $table_hist;
        $this->pk = empty($pk) ? str_replace('_hist', '_id', $table_hist) : $pk;
        $this->ignoreFields[] = $this->pk;
        $this->resaltaHaceSegundos = $resaltaHaceSegundos;
    }
    public function getDiferencesTable(int|string $id):string {
        $table = [];
        $ignore = array_flip($this->ignoreFields);
        $diferencias = array_reverse($this->getDiferences($id));

        foreach($diferencias as $d) {
            $classDate = '';
            $classAction = '';
            $classNick = '';
            $muestra = [];
            foreach($d['delta'] as $fieldName => $diff) {
                if(array_key_exists($fieldName, $ignore))
                    continue;
                if(empty($diff['es']) && empty($diff['era']))
                    continue;

                if(empty($diff['es'])) {
                    $muestra[] = "<td><i>" . $this->toLabel($fieldName) . "</i><td class='diff' colspan='2'><b>BORRO: </b>" .
                        $diff['diff_era'];
                    continue;
                }
                if(empty($diff['era'])) {
                    $muestra[] =  "<td><i>" . $this->toLabel($fieldName) . "</i><td colspan='2'><b>REGISTRO: </b>" .
                        ($diff['diff_es'] ?? "<pre class='code'>" . print_r($diff, true). "</pre>" ) ;
                    continue;
                }
                $muestra[] = "<td><i>" . $this->toLabel($fieldName). "</i>" .
                    "<td class='diff'><b>ERA: </b>" . $diff['diff_era'] .
                    "<td class='diff'><b>A: </b>" . $diff['diff_es'];
            }

            if(empty($muestra) && strcasecmp($d['action'], 'update') )
                $muestra[] = "<td><i>$d[action]<td colspan='2' class='diff'>$d[motive]";
            if(empty($muestra))
                continue;
            $cambios = "<table class='laTabla'><tr>" . implode("<tr>", $muestra) . "</tr></table>";

            $tiempoHace = fechaDiff($d['date_prev'], $d['date']);
            $segundosHace = abs(strtotime($d['date_prev']) - strtotime($d['date']));
            if($segundosHace >= $this->resaltaHaceSegundos)
                $tiempoHace = "<span style='color:red'>$tiempoHace</span>";
            $table[] =
                "<tr>" .
                "<td class='cen'><span$classDate>" . mysqlDateTime2display($d['date']) . "<div$classAction>$d[action]</div>$tiempoHace" . "</td>" .
                "<td class='cen$classNick'>" . ucwords($d['user_nick']) . "</td>" .
                "<td class='diff'>$cambios";
        }
        return
            "<table class='laTabla'><thead><tr><th>Fecha</th><th>Usuario</th><th>Info</th></tr></thead>" .
            "<tbody>" . implode("", $table) . "</tbody>" .
            "</table>";
    }

    public function getDiferences(int|string $id):array {
        return $this->diff( $this->transform($this->read($id)) );
    }

    /**
     * SETTERS para ajustar los campos a ignorar y como mostrarlos
     */

    /**
     * Cambia campos a ignorar por el input
     *
     * @param array $ignoreFields default  ['alta_db', 'alta_por', 'ultimo_cambio', 'ultimo_cambio_por', 'iac_edits', 'nota_bodega']
     * @return HistTable
     */
    public function setIgnoreFields(array $ignoreFields): HistTable {
        $this->ignoreFields = $ignoreFields;
        return $this;
    }

    /**
     * Agrega los campos a ignorar al defaults
     *  ['alta_db', 'alta_por', 'ultimo_cambio', 'ultimo_cambio_por', 'iac_edits', 'nota_bodega']
     *
     * @param array $ignoreFields default
     * @return HistTable
     */
    public function addIgnoreFields(array $ignoreFields): HistTable {
        $this->ignoreFields = [...$ignoreFields, ...$this->ignoreFields];
        return $this;
    }

    /**
     *
     * Set reemplaza todo el array, use add si desea dejar los defaults
     *
     * @param array $childsReKey
     * @return HistTable
     */
    public function setChildsReKey(array $childsReKey): HistTable {
        $this->childsReKey = $childsReKey;
        return $this;
    }

    public function addChildsReKey(array $childsReKey): HistTable {
        $this->childsReKey = [...$childsReKey, ...$this->childsReKey];
        return $this;
    }

    /**
     *
     * Set reemplaza todo el array, use add si desea dejar los defaults
     *
     * @param array $childsOnly
     * @return HistTable
     */
    public function setChildsOnly(array $childsOnly): HistTable {
        $this->childsOnly = $childsOnly;
        return $this;
    }

    public function addChildsOnly(array $childsOnly): HistTable {
        $this->childsOnly = [...$childsOnly, ...$this->childsOnly];
        return $this;
    }

    /**
     * @param array $fueErrorFields
     * @return HistTable
     */
    public function setFueErrorFields(array $fueErrorFields): HistTable {
        $this->fueErrorFields = $fueErrorFields;
        return $this;
    }

    public function addFueErrorFields(array $fueErrorFields): HistTable {
        $this->fueErrorFields = [...$fueErrorFields, ...$this->fueErrorFields];
        return $this;
    }

    /**
     * @param array $jsonObjectFields
     * @return HistTable
     */
    public function setJsonObjectFields(array $jsonObjectFields): HistTable {
        $this->jsonObjectFields = $jsonObjectFields;
        return $this;
    }


    /**
     * @param array $jsonFields
     * @return HistTable
     */
    public function addJsonObjectFields(array $jsonFields): HistTable {
        $this->jsonObjectFields = [...$jsonFields, ...$this->jsonObjectFields];
        return $this;
    }
    /**
     * @param array $jsonFields
     * @return HistTable
     */
    public function addJsonArrayFields(array $jsonArrayFields): HistTable {
        $this->jsonArrayFields = [...$jsonArrayFields, ...$this->jsonArrayFields];
        return $this;
    }

    protected function read(int|string $id):array {
        $method = __METHOD__;
        $read = ia_sqlArray(
            "SELECT /*$method*/ * FROM $this->table_hist WHERE pk=" . strit($id) . " ORDER BY date, history_id",
            'history_id'
        );
        return $read === false ? [] : $read;
    }

    protected function transform(array $log):array {
        foreach($log as &$d) {
            $d['record'] = json_decode($d['record'] ?? [], true);
            $entry = &$d['record']; // jeje es pointer!
            // a los campos tipo fue error obten solo los valores actuales
            foreach($this->fueErrorFields as $fieldName)
                if(array_key_exists($fieldName, $entry))
                    $entry[$fieldName] = getFueErrorNo($entry[$fieldName]);
            foreach($this->jsonObjectFields as $fieldName )
                if(array_key_exists($fieldName, $entry))
                    $entry[$fieldName] = json_decode($entry[$fieldName], true);
            foreach($this->jsonArrayFields as $fieldName )
                if(array_key_exists($fieldName, $entry))
                    $entry[$fieldName] = json_decode($entry[$fieldName], true);

            $childOnlyDone = [];
            // los arrays cambiales el key para que puedan compararse
            foreach($this->childsReKey as $fieldName => $keysFieldNames) {
                if(array_key_exists($fieldName, $entry)) {
                    $children = [];
                    foreach($entry[$fieldName] as $arr) {
                        $key = '';
                        foreach($keysFieldNames as $k)
                            $key .= $arr[$k] ?? '_';
                        if(array_key_exists($fieldName, $this->childsOnly)) {
                            $childOnlyDone[$fieldName] = $fieldName;
                            $children[$key] =  array_intersect_key($arr, array_flip($this->childsOnly[$fieldName]));
                        } else {
                            $children[$key] = $arr;
                        }
                    }
                    $entry[$fieldName] = $children;
                }
            }

            foreach(array_diff_key($this->childsOnly, $childOnlyDone) as $fieldName => $only)
                if( array_key_exists($fieldName, $entry))
                    $entry[$fieldName] = array_intersect_key($entry[$fieldName], array_flip($only) );
        }
        return $log;
    }

    /**
     * Obten diferencias y formatealas
     *
     * @param array $log [history_id=>[record de history id ya transformado o normalizado]]
     * @return array
     */
    protected function diff(array $log):array {
        $diff = [];
        $antes = [];

        foreach($log as $history_id => $ahora) {
            if(empty($prev))
                $prev = $ahora['date'];
            $record = $ahora['record'];

            if(empty($antes)) {
                $diff[$history_id] = [
                    'action' => $ahora['action'],
                    'date' => $ahora['date'],
                    'date_prev' => $ahora['date'],
                    'motive' => $ahora['motive'],
                    'user_nick' => $ahora['user_nick'],
                    'delta' => [],
                    'record' => $record,
                ];
                $antes = $record;
                continue;
            }
            $delta = [];
            $difieren = [
                ...array_udiff_assoc($record, $antes, self::class . "::compare"),
                ...array_diff_key($antes, $record)
            ];
            foreach($difieren as $fieldName => $_) {
                $enRecord = $record[$fieldName] ??  '';
                if(is_array($enRecord)) {
                    if(in_array($fieldName, $this->jsonObjectFields)) {
                        $es_formatted = $this->arrayFormat($fieldName, $enRecord);
                        $era_formatted = $this->arrayFormat($fieldName, $antes[$fieldName] ?? []);
                        $delta[$fieldName] = [
                            'es' => $enRecord,
                            'era' => $antes[$fieldName] ?? [],
                            'es_formatted' => $es_formatted,
                            'era_formatted' => $era_formatted,
                            'diff_es' => $this->diferenceFormatted($es_formatted, $era_formatted, 'i' ),
                            'diff_era' => $this->diferenceFormatted($era_formatted, $es_formatted, 'u' ),
                        ];
                    } else {
                        $delta[$fieldName] = $this->deltaArray($fieldName, $enRecord, $antes[$fieldName] ?? []);
                    }
                } else {
                    $era_formatted = formatMe($fieldName, $antes[$fieldName] ?? '');
                    $es_formatted = formatMe($fieldName, $enRecord ?? '');
                    $delta[$fieldName] = [
                        'era' => $antes[$fieldName] ?? '',
                        'es' => $enRecord ?? '',
                        'era_formatted' => $era_formatted,
                        'es_formatted' => $es_formatted,
                        'diff_era' => $this->diferenceFormatted($era_formatted, $es_formatted, 'u'),
                        'diff_es' => $this->diferenceFormatted($es_formatted, $era_formatted, 'i'),
                    ];
                }
            }


            $diff[$history_id] = [
                'action' => $ahora['action'],
                'date' => $ahora['date'],
                'date_prev' => $prev,
                'motive' => $ahora['motive'],
                'user_nick' => $ahora['user_nick'],
                'delta' => $delta,
                'record' => $record,
            ];
            $antes = $record;
            $prev = $ahora['date'];
        }
        return $diff;
    }

    protected function deltaArray($fieldName, $ahora, $antes) {
        $diff_es = [];
        $diff_era = [];
        foreach($ahora as $k => $d) {
            if( !array_key_exists($k, $antes)) {
                $diff_es[] = "<span style='color:green' title='Registro o Agrego'>⇪</span> " . $this->arrayFormat($fieldName, $d);
                $diff_era[] = '';
                continue;
            }
            if($d !== $antes[$k]) {
                $es_formatted = $this->arrayFormat($fieldName, $d);
                $era_formatted = $this->arrayFormat($fieldName, $antes[$k] ?? []);
                $diff_es[] = $this->diferenceFormatted($es_formatted, $era_formatted, 'i' );
                $diff_era[] = $this->diferenceFormatted($era_formatted, $es_formatted, 'u' );
            }
        }
        foreach($antes as $k => $d) {
            if(!array_key_exists($k, $ahora)) {
                $era_formatted = $this->arrayFormat($fieldName, $d);
                $diff_es[] = "<span style='color:red' title='Quito, borro o elmino'>✗</span> <span style='color:gray;text-decoration: line-through'>$era_formatted</span>";
                $diff_era[] = $era_formatted;
            }
        }
        return [
            'es' => $ahora,
            'era' => $antes,
            'diff_es' => "<ol><li>" . implode(" <li>", $diff_es) . "</li></ol>",
            'diff_era' => "<ol><li>" . implode(" <li>", $diff_era) . "</li></ol>"
        ];
    }

    protected function compare($a, $b):int {
        if(is_array($a) || is_array($b)) {
            if(is_array($a))
                $a = array_diff_key($a,array_flip($this->ignoreFields));
            if(is_array($b))
                $b = array_diff_key($b,array_flip($this->ignoreFields));
            if($a == $b)
                return 0;
            return $a <=> $b;
        }
        return $a <=> $b;
    }


    protected function arrayFormat($fieldName, $array) {
        if(!is_array($array)) {
            return "$fieldName envio $array en vez de array";
        }
        if(!array_key_exists($fieldName, $this->childsOnly))
            return "$fieldName es array y no dice que desplegar use ->addChildsOnly(['$fieldName'=>['label', 'otroDato'])";
        $ret = [];
        $only = $this->childsOnly[$fieldName];

        $wantsUnit = in_array('producto_general_id', $only) &&  in_array('unidades_id', $only);
        foreach($only as $f) {
            if(array_key_exists($f, $array))
                $ret[] = formatMe($f, $array[$f]) . (str_contains($f, 'roll') ? ' Rollos' : '');
            elseif($wantsUnit && $f === 'unidades_id' && !array_key_exists('unidades_id', $array)
            ) {
                if(empty($this->productoGeneralUnidades)) {
                    $method = __METHOD__;
                    $this->productoGeneralUnidades = ia_sqlKeyValue(
                        "SELECT /*$method*/ pg.producto_general_id, u.unidad
                            FROM producto_general pg JOIN unidades u on pg.unidades_id = u.unidades_id"
                    );
                    if($this->productoGeneralUnidades === false)
                        $this->productoGeneralUnidades = [];
                }
                $ret[] = $this->productoGeneralUnidades[$array['producto_general_id'] ?? ''] ?? '';
            }
        }
        if(empty($ret)) return "empty ret fieldName = $fieldName only =" .print_r($only, true) . "<pre> v= " . print_r($array, true);
        return implode(' ', $ret);
    }

    protected function toLabel(string $s):string {
        $upper=['eta'=>true];
        if(array_key_exists(strtolower($s),  $upper))
            return strtoupper($s);
        return ucwords(str_replace(
                ['own_reference', '_', '_id'],
                ['our_reference', ' ',' '],
                $s)
        );
    }

    protected function diferenceFormatted($new, $old, string $tagLetter):string {
        $old = strim($old);
        $new = strim($new);
        if(empty($old) || empty($new) || $new === $old)
            return $new;
        if(
            (str_contains($new, '<') && str_contains($new, '>')) ||
            (str_contains($old, '<') && str_contains($old, '>'))
        ) {
            return $new;
        }
        $result = [];
        $byChar =str_contains($new, '/') ||  str_contains($new, '_') || str_contains($new, '-');
        $o = explode(' ', $old);
        $n = explode(' ', $new);
        foreach($n as $i => $w) {
            $w = trim($w);
            $wo = trim($o[$i] ?? '');
            if($w === $wo) {
                $result[] = $w;
                continue;
            }
            if($byChar || is_numeric(str_replace(',', '', $w)))
                $result[] = "<b class='diff$tagLetter'>". $this->diferenceChars($w, $wo, $tagLetter) . "</b>";
            else
                $result[] = "<b class='diff$tagLetter'>$w</b>";
        }
        return implode(' ', $result);
    }

    protected function diferenceChars($new, $old, $tagLetter):string {
        if(empty($old) || $new === $old)
            return $new;

        $result = [];
        $inHtml = false;
        $marking = false;

        $newLen = strlen($new);
        for($i = 0; $i < $newLen; ++$i) {
            $c = $new[$i];
            if($inHtml) {
                $result[] = $c;
                if($c === '>')
                    $inHtml = false;
                continue;
            }
            if($c === '<') {
                $result[] = '<';
                $inHtml = true;
                continue;
            }
            if($c === ($old[$i] ?? NULL)) {
                if($marking) {
                    $result[] = "</$tagLetter>";
                    $marking = false;
                }
            } elseif(!$marking) {
                $result[] = "<$tagLetter>";
                $marking = true;
            }
            $result[] = $c;
        }
        return implode('', $result) . ($marking ? "</$tagLetter>" : '');
    }

}
