<?php
/**
 * version 1.4
 *
 * Registra, reporta de, actualiza y borra de las tablas: login_log,login_log_raro
 *
 * raro: 1 ip varios usuarios a la vez. 1 usuario varias ip a la vez. de donde se conecto rony
 * function revisar() trae lo que no sea revisado desde hac 3 dias a hoy
 * function logout() manda borrar todo lo anterior a 15 dias
 * function filtraFecha() asume al usuario inactivo si no cambio su session en 240 minutos (4 horas, es cada pocos minutos en casi todas las hojas)
 * assume session_regenerate_id al login/logout
 *
 * version 1.2
 *   Si un usuario tiene 2 logins donde ambos son desde Localhost o ambos desde Red o ambos desde Internet no sale en raro
 *   Varias conecciones de Rony del día, desde la misma ip, aparecen 1 sola vez en raro
 *
 * version 1.3 2019-09-14
 *   Registra como ya revisado cada que rony se conecta, para que no se vea en el recuadro de situaciones raras,
 *      tambien en index se ocultan los checboxes para mostrar o no rony conectado desde localhost,red,...
 *   En index al cambiar de pestaña no se marcan en automatico como revisadas  las situaciones, es necesario click en revisado
 *
 * version 1.4 2021-10-19
 *    localhost se pasa a 127.0.0.1 para getHostByAddr
 */

class Login_log {
    const DESDE_INTENRET = "Internet";
    const DESDE_LOCALHOST = "localhost";
    const DESDE_RED = "Red";
    const DESDE_BAD_IP = "Bad IP";

    protected $hoy;
    protected $usuarioTipoRony=[];
    protected $sinLogout=[];
    protected $revisar=[];
    protected $count=[];
    protected $consideraLogoutMinutos=30;

    protected function getUsuariosTipoRony() {
        if(empty($this->usuarioTipoRony)) {
            $method = __METHOD__;
            $this->usuarioTipoRony = ia_sqlKeyValue(
              "SELECT /*$method*/ nick, usuario_tipo_rony 
                    FROM iac_usr 
                    WHERE usuario_tipo_rony='Si' AND iac_usr_id<>1"); //es sin rony
        }
        return $this->usuarioTipoRony;
    }

// LOGIN/LOGOUT ______________________________________________________
   public  function login() {
        $ip = ip_get(); $full = $this->connected_from($ip);
        if(strcasecmp($ip,'localhost') === 0)
            $ip = '127.0.0.1';
        $computerName = filter_var($ip, FILTER_VALIDATE_IP) ? gethostbyaddr($ip) : '?';
        $data = [
            'usuario_id' => $_SESSION['usuario_id'],
            'usuario' => $_SESSION['usuario'],
            'status' => 'Logged In',
            'login_at' => 'NOW()',
            'browser' => empty($_SERVER['HTTP_USER_AGENT']) ? '?' : ia_htmlentities($_SERVER['HTTP_USER_AGENT']),
            'ip' => ia_htmlentities($ip),
            'computadora' => empty($computerName) ? '?' : $computerName,
            'ip_full' => ia_htmlentities(ip_getFull()),
            'conected_from' => $this->connected_from($ip),
            'session_id' => session_id(),
            'era_tipo_rony' => usuarioTipoRony() && $_SESSION['usuario_id']!='1' ? 'Si' : 'No',
        ];
        ia_query( ia_insert('login_log', $data, [], '', true) );
        $this->loginsNow();
    }

    public  function logout() {
        ia_query("UPDATE login_log SET status='Logged Out', logged_out_at=NOW() WHERE session_id=".strit(session_id()));
        $this->deleteOldRows(35);
        $this->loginsNow();
    }

    public function deleteOldRows($numeroDias) {
        if(!is_numeric($numeroDias) || $numeroDias<1)
            return;
        $deleteBefore = strit( Date('Y-m-d 00:00:00', strtotime($numeroDias.' days ago') ) );
        ia_query("DELETE FROM login_log WHERE login_at < $deleteBefore");
        ia_query("DELETE FROM login_log_raro WHERE fecha < $deleteBefore");
    }

    protected function updatedb() {
        $login_log_raro_version = ia_singleread("SELECT val FROM login_log_configure WHERE nombre='login_log_raro_version'", "0");
        if($login_log_raro_version < "1.0") {
            $alter = "ALTER TABLE login_log_raro ADD COLUMN tipo_rony tinyint NOT NULL DEFAULT '0', ADD COLUMN raro VARCHAR(999) NOT NULL DEFAULT '', ADD COLUMN cual VARCHAR(999) NOT NULL DEFAULT '' ";
            ia_query($alter);
            ia_query("CREATE INDEX revisaInsert ON login_log_raro(fecha,cual,raro)");
            ia_query(ia_insert('login_log_configure',['nombre'=>'login_log_raro_version','val'=>'1.0'], [], '', true));
        }
    }
//
    public function loginsShow() {
        $this->getUsuariosTipoRony();
        $read = ia_sqlArray("SELECT session_id,login_log_id,usuario_id,usuario,login_at,browser,ip,ip_full,conected_from,computadora FROM login_log WHERE status='Logged In'",'session_id');
        $registered = $this->filtraFecha($read); // cambia el key a login_log_id y por seguridad elimina session_id
        uasort($registered,  self::class.'::sortLogins');

        $revisarEnviar = $this->revisar_get();

        $this->count=$this->loginsCount($registered);

        $reportDetails = [];
        foreach($registered as $login_log_id => $info) {
            $ip = $info['ip'];
            $conected_from = $this->connected_from($ip);
            if($conected_from === self::DESDE_LOCALHOST) {
                $ip = self::DESDE_LOCALHOST;
                //$conected_from = self::DESDE_LOCALHOST;
            }

            $info['UsuarioVariasIp']  = (empty($this->count['usuario'][$info['usuario']]) ? '' : (count($this->count['usuario'][$info['usuario']]) > 1 ? 'X' : ''));
            if($ip !== '192.168.1.40' && $ip !== 't550gris') {
                $info['IpVariosUsuarios'] = (empty($this->count['ip'][$ip]) ? '' : (count($this->count['ip'][$ip]) > 1 ? 'X' : ''));
            }

            $info['usuario_display'] = $this->displayUser($info['usuario']);
            $info['kaput'] = "<button type='button' class='kaput' onclick='(new Login_log()).kaput($login_log_id, \"$info[usuario]\")'><span style='color:red'>☠</span> Cerrar Session <span style='color:red'>☠</span> <i>¡En su próximo click!</i></button>";
            $reportDetails[$login_log_id] = $info;
        }
        uasort($reportDetails,  self::class.'::sortLogins');

        $resumen = $this->resumen($registered);

        return [
            'cambiaFiltros' => md5(
                  implode(',', ia_sqlVector("SELECT DISTINCT computadora FROM login_log ORDER BY 1") )
                . implode(',', ia_sqlVector("SELECT DISTINCT usuario FROM login_log ORDER BY 1") )
            ),

            'details'=>$reportDetails,'detailsMD5'=>md5(json_encode($reportDetails)),
            'logged_in_num'=>$resumen['logged_in_num'],
            'resumen'=> $resumen['resumen'], 'resumenMD5'=>md5($resumen['resumen']),
            'resumen_tipo_rony'=>$resumen['resumen_tipo_rony'],'resumen_tipo_ronyMD5'=>md5($resumen['resumen_tipo_rony']),

            'revisar'=>$revisarEnviar, 'revisarMD5' => md5(json_encode($revisarEnviar)),

            'usuarios' => $resumen['usuarios'],
            'usuarios_num'=>count($resumen['usuarios']),
            'usuarios_tipo_rony_num'=> $resumen['tipo_rony_num'],
            'usuarios_rony_num'=> $resumen['rony_num'],
            'registrados_tipo_rony' => count($this->usuarioTipoRony),
            'registrados_tipo_rony_son' => implode(', ', $this->usuarioTipoRony),
            'tabMD5' => md5($resumen['resumen'].$resumen['resumen_tipo_rony'].md5(json_encode($revisarEnviar)) ),

        ];
    }

    public function count() {
        $this->updatedb();
        $this->getUsuariosTipoRony();

        $this->hoy = Date('Y-m-d');
        $this->consideraLogoutMinutos = ia_singleread("SELECT val FROM login_log_configure WHERE nombre='login_log_cada'", $this->consideraLogoutMinutos);

        $read = ia_sqlArray("SELECT session_id,login_log_id,usuario_id,usuario,login_at,browser,ip,ip_full,conected_from,computadora FROM login_log WHERE status='Logged In'",'session_id');
        return count(array_column($this->filtraFecha($read), 'usuario', 'usuario'));
    }

    public function without_me_count() {
        $this->updatedb();
        $this->getUsuariosTipoRony();

        $this->hoy = Date('Y-m-d');
        $this->consideraLogoutMinutos = ia_singleread("SELECT val FROM login_log_configure WHERE nombre='login_log_cada'", $this->consideraLogoutMinutos);

        $user_id_session = $_SESSION['usuario_id'];
        $read = ia_sqlArray("SELECT session_id,login_log_id,usuario_id,usuario,login_at,browser,ip,ip_full,conected_from,computadora FROM login_log WHERE status='Logged In' AND usuario_id <> $user_id_session",'session_id');
        return count(array_column($this->filtraFecha($read), 'usuario', 'usuario'));
    }


    protected function loginsNow() {
        $this->updatedb();
        $this->getUsuariosTipoRony();
        $this->hoy = Date('Y-m-d');
        $this->consideraLogoutMinutos = ia_singleread("SELECT val FROM login_log_configure WHERE nombre='login_log_cada'", $this->consideraLogoutMinutos);

        $read = ia_sqlArray("SELECT session_id,login_log_id,usuario_id,usuario,login_at,browser,ip,ip_full,conected_from,computadora FROM login_log WHERE status='Logged In'",'session_id');
        $registered = $this->filtraFecha($read); // cambia el key a login_log_id y por seguridad elimina session_id
        uasort($registered,  self::class.'::sortLogins');

        $this->count=$this->loginsCount($registered);
        $revisarEnviar=$this->revisar($registered);
        // $revisarEnviar = $this->revisar_get();
        $reportDetails = [];
        foreach($registered as $login_log_id => $info) {

            $ip = $info['ip'];
            $conected_from = $this->connected_from($ip);
            if($conected_from === self::DESDE_LOCALHOST) {
                $ip = self::DESDE_LOCALHOST;
                $conected_from = self::DESDE_LOCALHOST;
            }
            $info['UsuarioVariasIp']  = (empty($this->count['usuario'][$info['usuario']]) ? '' : (count($this->count['usuario'][$info['usuario']]) > 1 ? 'X' : ''));

            $info['IpVariosUsuarios'] = (empty($this->count['ip'][$ip]) ? '' : (count($this->count['ip'][$ip]) > 1 ? 'X' : ''));

            $info['usuario_display'] = $this->displayUser($info['usuario']);

            $reportDetails[$login_log_id] = $info;
        }
        uasort($reportDetails,  self::class.'::sortLogins');

        $resumen = $this->resumen($registered);

        $enviar = [

            'cambiaFiltros' => md5(
                implode(',', ia_sqlVector("SELECT DISTINCT computadora FROM login_log ORDER BY 1") )
                . implode(',', ia_sqlVector("SELECT DISTINCT usuario FROM login_log ORDER BY 1") )
            ),

            'details'=>$reportDetails,'detailsMD5'=>md5(json_encode($reportDetails)),
            'logged_in_num'=>$resumen['logged_in_num'],
            'resumen'=> $resumen['resumen'], 'resumenMD5'=>md5($resumen['resumen']),
            'resumen_tipo_rony'=>$resumen['resumen_tipo_rony'],'resumen_tipo_ronyMD5'=>md5($resumen['resumen_tipo_rony']),

            'revisar'=>$revisarEnviar, 'revisarMD5' => md5(json_encode($revisarEnviar)),

            'usuarios' => $resumen['usuarios'],
            'usuarios_num'=>count($resumen['usuarios']),
            'usuarios_tipo_rony_num'=> $resumen['tipo_rony_num'],
            'usuarios_rony_num'=> $resumen['rony_num'],
            'registrados_tipo_rony' => count($this->usuarioTipoRony),
            'registrados_tipo_rony_son' => implode(', ', $this->usuarioTipoRony),
            'tabMD5' => md5($resumen['resumen'].$resumen['resumen_tipo_rony'].md5(json_encode($revisarEnviar)) ),



        ];

        return $enviar;
    }

    protected function resumen($registered) {
        $this->getUsuariosTipoRony();
        $loggedInNow = [];
        $tipo_rony_count = 0;

        $ConexionesNum = array_count_values( array_column($registered, 'usuario') );
        $loggedIn = array_column($registered, 'usuario', 'usuario');
        foreach($loggedIn as $usuario => $d) {
            $loggedInNow[$usuario] = [
                'usuario' => $usuario,
                'tipo_rony' => array_key_exists($usuario, $this->usuarioTipoRony),
                'ConexionesNum'=>empty($ConexionesNum[$usuario]) ? 0 : $ConexionesNum[$usuario],
                'numeroIp' => '?',
            ];
            if(array_key_exists($usuario, $this->usuarioTipoRony)) {
                $tipo_rony_count++;
            }
        }

        $usersLoggedIn = array_column($registered, 'usuario', 'usuario');
        $logged_in_num = count($usersLoggedIn);

        $usuariosTipoRony = $this->hayTipoRony($usersLoggedIn);
        $resumenTipoRony = empty($usuariosTipoRony) ? '' : $this->comaUsuarios($usuariosTipoRony);
        $loggedIn = '<b>'.$logged_in_num .'</b> logged in users: '.$this->comaUsuarios($usersLoggedIn);

        return [
            'logged_in_num'=>$logged_in_num,
            'resumen'=>'<b>'.$logged_in_num .'</b> logged in users: '.$this->comaUsuarios($usersLoggedIn),
            'rony_num' => empty($ConexionesNum['rony']) ? 0 : $ConexionesNum['rony'],
            'resumen_tipo_rony'=>$resumenTipoRony,
            'tipo_rony_num'=>$tipo_rony_count,
            'usuarios_tipo_rony'=>$usuariosTipoRony,
            'usuarios'=>$loggedInNow,
            'registrados_tipo_rony' => count($this->usuarioTipoRony),
            'registrados_tipo_rony_son' => implode(', ', $this->usuarioTipoRony),
        ];
    }

// Deduce que marcar a revisar revisar
    // 1 ip varios usuarios a la vez. 1 usuario varias ip a la vez. de donde se conecto rony
    protected function revisar($registered) {
        $this->revisar = [];
        $this->revisar_rony_conected_from($registered);
        $this->revisar_usuario_varias_ip();
        $this->revisar_ip_varios_usuarios();
        foreach($this->revisar as $r) {
            $r['fecha'] = $this->hoy;
            $lista = array_column($r['lista'],'usuario_id');
            sort($lista, SORT_NUMERIC);
            $login_at = array_column($r['lista'],'login_at');
            sort($login_at, SORT_STRING);
            $hash = md5( $r['raro'] .$r['cual'] . "|".Date('Y-m-d H')."|" . implode('|', $lista) . '|' . implode('|', $login_at) );
            $r['login_log_raro_id'] =$hash;
            $guardar = [
                'login_log_raro_id'=>$hash,
                'fecha'=>$this->hoy,
                'aviso'=> json_encode($r),
                'tipo_rony' => $r['tipo_rony'] ? 1 : 0,
                'raro' => $r['raro'],
                'cual' => $r['cual'],
                'revisado'=> isset($r['revisado']) ? $r['revisado'] : 'No',
                'orden'=>$r['orden'],
                'alta_db'=>'NOW()'
            ];
            $haceMinutos = strit(Date('Y-m-d H:i:00', strtotime('10 minutes ago')));
            $checkTime = ia_singleread("SELECT 1 from login_log_raro WHERE ".
                "fecha = ".strit($this->hoy)." AND alta_db >= $haceMinutos AND raro=".strit($guardar['raro'])." AND cual=".strit($guardar['cual']));
            if($checkTime != "1") {
                ia_query(ia_insert('login_log_raro', $guardar, [],' ON DUPLICATE KEY UPDATE fecha=VALUES(fecha),aviso=VALUES(aviso)') );
            }
        }
        unset($this->revisar);
        return $this->revisar_get();
    }

    protected function revisar_get() {
        $revisarEnviar=[];
        return $revisarEnviar;
        $traeDesde = strit(Date('Y-m-d', strtotime('3 days ago')));
        $revisar_get = ia_sqlVector("SELECT DISTINCT aviso FROM login_log_raro WHERE revisado='No' AND fecha>=$traeDesde ORDER BY fecha DESC, orden, alta_db DESC");
        if(!empty($revisar_get)){
            foreach($revisar_get as $enviar) {
                $revisarEnviar[] = json_decode($enviar, true);
            }
        }
        return $revisarEnviar;
    }

    protected function revisar_rony_conected_from($registered) {
        foreach($registered as $info) {
            if($info['usuario_id']=="1") {
                $displayIp = $this->displayIP($info);
                $cual = "Conectado desde ".$displayIp;
                $conected_from = $info['conected_from'];
                // if(ia_singleread("SELECT COUNT(*) FROM login_log_raro WHERE fecha=".strit($this->hoy)." AND raro='Rony' AND cual=".strit($cual), 0) == 0) {
                    $this->revisar[] = [
                        'raro' => 'Rony',
                        'cual'=>$cual,

                       'revisado'=>'Si', // version 3 ya no se quiere ver las conecciones de rony
                        'lista'=>[$info],
                        'tipo_rony'=>true,
                        'a_las'=>substr($info['login_at'], 0, -3),
                        'orden'=>1,
                        'frase' => $this->displayUser('rony')."<span data-loginlogdesde='rony$conected_from'>".' conectado desde '.$displayIp."</span>",
                    ];
                // }
            }
        }
    }

    protected function revisar_usuario_varias_ip() {
        $this->getUsuariosTipoRony();
        foreach($this->count['usuario'] as $usuario => $ipList) {
            if(count($ipList)>1) {
                $conected_from_summary = [];
                foreach($ipList as $ip) {
                    $conected_from_summary[$this->connected_from($ip)] = true; //
                }
                if(!array_key_exists(self::DESDE_BAD_IP,$conected_from_summary) && count($conected_from_summary) <= 1 ) { // si esta mal registrada la ip mejor reporta aunque sean repetidos
                    continue;
                }
                if(array_key_exists($usuario, $this->usuarioTipoRony)) {
                    $class = 'blink';
                    $tipoRony = true;
                    $frase = ". Y es tipo rony";
                } else {
                    $class = '';
                    $tipoRony = false;
                    $frase = '';
                }

                $this->revisar[] = [
                    'raro' => 'Usuario en varias IPs',
                    'cual'=>$usuario,
                    'tipo_rony'=>$tipoRony,
                    // 'cuenta'=>count($ipList),
                    'lista'=>$ipList,
                    'orden'=>$tipoRony ? 20 : 21,
                    'a_las' => substr(max( array_column($ipList,'login_at') ), 0, -3),
                    'frase' => '<b>'. $this->displayUser($usuario).'</b> esta en <b>'.count($ipList)." conexiones</b>: ".$this->comaIp($ipList).$frase
                        // .print_r($conected_from_summary, true)
                ];
            }
        }
    }

    protected function revisar_ip_varios_usuarios() {
        foreach($this->count['ip'] as $ip => $usuariosEnIp) {
            if($this->connected_from($ip) == self::DESDE_INTENRET) continue;
            if(count($usuariosEnIp)>1) {
                $conected_from = $this->connected_from($ip);
                $usuariosEstan = array_flip(array_keys($usuariosEnIp));
                $sonTipoRony = $this->hayTipoRony($usuariosEstan);
                $frase = empty($sonTipoRony) ? '' : '. Tipo rony: '.$this->comaUsuarios($sonTipoRony);

                $raro = 'IP con varios usuarios';
                $cual = $ip.' los usuarios: '.implode(',', array_flip( $usuariosEstan) );
                $frase = "La conexión <b>".$this->displayIP(['ip'=>$ip, 'conected_from'=>$conected_from, 'computadora'=>$this->count['dns'][$ip] ]).
                            "</b> tiene ".count($usuariosEnIp)." usuarios: <b>".$this->comaUsuarios(array_keys($usuariosEnIp)).$frase."</b>.";

                if($ip !== '192.168.1.40' && $ip !== 't550gris') {
                    //  if(ia_singleread("SELECT COUNT(*) FROM login_log_raro WHERE fecha=".strit($this->hoy)." AND raro='$raro' AND cual=".strit($cual), 0) == 0) {
                    $this->revisar[] = [
                        'raro' => $raro,
                        'cual' => $cual,
                        'cuenta' => count($usuariosEnIp),
                        'lista' => $usuariosEnIp,
                        'tipo_rony' => $sonTipoRony,
                        'a_las' => substr(max(array_column($usuariosEnIp, 'login_at')), 0, -3),
                        'orden' => empty($sonTipoRony) ? 41 : 40,
                        'frase' => $frase,
                    ];
                }
                //}
            }
        }
    }

//


// HELPERS
    protected function loginsCount($logins) {
        $count = ['usuario' => [], 'ip' => [], 'dns'=>[]];
        foreach($logins as $info) {
            if($info['last_seen'] > $this->hoy) {
                $ip = $info['ip'];
                if($this->connected_from($ip) === self::DESDE_LOCALHOST) {
                    $ip = self::DESDE_LOCALHOST;
                }
                $count['usuario'][$info['usuario']][$ip] = $info;
                $count['ip'][$ip][$info['usuario']] = $info;
                $count['dns'][$ip] = $info['computadora'];
            }
        }
        return $count;
    }

    // Elimina sin logout viejos
    protected function filtraFecha($registered) {
        $this->getUsuariosTipoRony();
        $now = Date('Y-m-d H:i:s');
        $posibleSinLogout = Date('Y-m-d H:i:s', strtotime("$this->consideraLogoutMinutos minutes ago"));
        $this->sinLogout = [];
        $sinSession = [];
        $currentUsers=[];
        $sessionPath = session_save_path();
        $sessionFiles =  $this->listSessionFiles();
        foreach($registered as $session_id => $info) {
            if(array_key_exists($session_id, $sessionFiles) || $sessionFiles===false || $sessionFiles===null) {
                $key = $info['login_log_id'];
                if(empty($sessionFiles))
                    $last_seen = $now;
                else
                    $last_seen = Date('Y-m-d H:i:s', filemtime($sessionFiles[$session_id]) );
                if($last_seen >= $posibleSinLogout) {
                    $currentUsers[$key] = $info;
                    $addData = &$currentUsers[$key];
                    $addData['checar_logout'] = $last_seen < $posibleSinLogout || $last_seen == null;
                    $addData['last_seen'] = $last_seen;
                    $addData['tipo_rony'] = array_key_exists($info['usuario'], $this->usuarioTipoRony); // usuarioTipoRony($info['usuario_id']);
                    $addData['tipo_rony_display'] = $addData['tipo_rony'] ? '<span class="login_log_tipo_rony">&#x26a0;</span>' : '';
                    $addData['conected_from_display'] = $this->displayConectedFrom($addData);

                    unset($addData['session_id']);
                } else {
                    $this->sinLogout[$info['login_log_id']] = $info;
                    // @unlink($sessionFiles[$session_id]); // borra la sesion para invalidar el login
                    // $sinSession[] = $info['login_log_id']; // marca en db ya hizo logout
                }
            } else {
                $sinSession[] = $info['login_log_id']; // marca en db ya hizo logout
            }
        }
        if(!empty($sinSession)) {
            $consideraLogout = Date('Y-m-d H:i:s', strtotime('10 minutes ago'));
            ia_query("UPDATE login_log SET status='Expired', logged_out_at=NOW() WHERE status='Logged In' AND login_log_id IN(" . implode(',', $sinSession).')' );
        }
        return $currentUsers;
    }

    protected function listSessionFiles() {
        $sessionPath = session_save_path(); // ini_get('session.save_path');
        if(empty($sessionPath)) return [];
        $sessionFiles = scandir($sessionPath);
        if(empty($sessionFiles)) {
            return false;
        }
        $sessions = [];
        $this->listSessionFilesRead($sessionPath, $sessions);
        return $sessions;
    }

    protected function listSessionFilesRead($path, &$sessions) {
        $sessionFiles = scandir($path);
        if(empty($sessionFiles)) {
            return false;
        }
        foreach($sessionFiles as $s) {
            if($s !== '.' && $s !== '..')
                if(is_dir($path . DIRECTORY_SEPARATOR . $s))
                    $this->listSessionFilesRead($path . DIRECTORY_SEPARATOR . $s, $sessions);
                else
                    $sessions[substr($s,5)] = $path . DIRECTORY_SEPARATOR . $s;
        }
        return true;
    }
    protected function sortLogins($a, $b) {
        if($a['usuario_id'] === "1" && $b['usuario_id'] !== "1") {
            return -1;
        }
        if($b['usuario_id'] === "1" && $a['usuario_id'] !== "1") {
            return 1;
        }
        if($a['tipo_rony'] && !$b['tipo_rony']) {
            return -1;
        }
        if($b['tipo_rony'] && !$a['tipo_rony']) {
            return 1;
        }
        if($a['usuario_id'] === $b['usuario_id']) {
            return $a['login_at'] <=> $b['login_at'];
        }
        return $a['usuario'] <=> $b['usuario'];
    }

// Format/display

    protected function displayIP($info) {
        return  $info['computadora'] .
            ($info['conected_from'] === self::DESDE_LOCALHOST ? '' :
                " (<span style='font-size:smaller;font-weight:200'>$info[ip]</span>)"
            ) . ", " . $this->displayConectedFrom($info);
    }

    protected function displayConectedFrom($info) {
        $conected_from = $info['conected_from'];
        if($conected_from === self::DESDE_BAD_IP) {
            return "<span class='login_log_alerta'>".self::DESDE_BAD_IP."</span>";
        }
        return $conected_from;
    }

    protected function displayUser($usuario) {
        if(strcasecmp('rony', $usuario) === 0) {
            return '<span class="login_log_rony">Rony</span>';
        }
        $this->getUsuariosTipoRony();
        if(array_key_exists($usuario, $this->usuarioTipoRony)) {
            return '<span class="login_log_tipo_rony">'.ucwords($usuario).'</span>';
        }
        return '<span class="login_log_usuario">'.ucwords($usuario).'</span>';
    }

// AUXILIARES
    protected function connected_from($ip) {
        if(is_array($ip)) {
            if(empty($ip['ip'])) {
                $ip = '?';
            } else {
                $x = $ip['ip'];
                $ip = trim($x);
            }

        } else {
            $ip = trim($ip);
        }

        if(filter_var($ip, FILTER_VALIDATE_IP, FILTER_FLAG_NO_PRIV_RANGE | FILTER_FLAG_NO_RES_RANGE)!==false) {
            return self::DESDE_INTENRET;
        }
        if(array_key_exists($ip,['localhost'=>1,'127.0.0.1'=>1,'::1'=>1])) {
            return self::DESDE_LOCALHOST;
        }
        if(filter_var($ip, FILTER_VALIDATE_IP)!==false) {
            return self::DESDE_RED;
        }
        return $ip . self::DESDE_BAD_IP;
    }

    protected function hayTipoRony($usuarioArray) {
        $this->getUsuariosTipoRony();
        return array_flip( array_intersect_key($usuarioArray, $this->usuarioTipoRony) );
    }

    protected function comaIp($array) {
        if(empty($array)) {
            return '';
        }
        //asort($array);
        $out = [];
        foreach($array as $info) {
            $out[] = $this->displayIP($info);
        }
        if(count($out) === 1) {
            return reset($out);
        }
        $last = array_pop($out);
        return implode(', ', $out)." y $last";
    }

    protected function comaUsuarios($array) {
        if(empty($array)) {
            return '';
        }
        foreach($array as &$user) {
            $user = $this->displayUser($user);
        }
        if(count($array) === 1) {
            return reset($array);
        }
        asort($array);
        $last = array_pop($array);
        return implode(', ', $array)." y $last";
    }

    protected function comaY($array) {
        if(empty($array)) {
            return '';
        }
        if(count($array) === 1) {
            return reset($array);
        }
        asort($array);
        $last = array_pop($array);
        return implode(', ', $array)." y $last";
    }

}
