<?php
/** @noinspection PhpMissingParamTypeInspection */

/**
 * Ejemplo de poner nuevo permiso
 *
 *
 *  Agregar un permiso
 *   1 Si el permiso no esta en iac_usr, plantillas o permiso bodega, es decir es en la tabla permiso_nombre
 *      INSERT INTO permiso_nombre(permiso_nombre, valores) VALUES('puede_consultar_existencia_grid'  , '["Si", "No"]');
 *   2 En protected static array $PERMISOS agregar su array entry, el key es permiso_nombre
        'puede_consultar_existencia_grid' => [
           'permiso'=>'puede_consultar_existencia_grid',
            'tabla'=>'permiso_usuario',
            'label'=>'Puede Consultar la Existencia de Productos en el grid'],

 *    3 en permisador_acciones.php en url2permisos poner cuando recibe que url se usa
 *              case 'backoffice/producto_bodega.php':
                case 'producto_bodega.php':
                return [$permisos['puede_consultar_existencia_grid']];
                // return [$permisos['puede_consultar_existencia_grid'],$permisos['puede_otra_cosa']]; // Salen ambas cajitas en la llavesite
 *
 *    4 En la hoja que se quiera la llavesita, justo arriba de include footer.php
 *      <?php if(Permisador::puede_consultar_permisos() !== 'Nada') echo '<script>jQuery(function($) { permisador.ponPermiso(); });</script>'; ?>
 *
 *    5 Checar el permiso
 *      	require_once('../inc/config.php');
            if(!usuarioTipoRony() && Permisador::puede('cuentat_a_banco_tc_list', 'No') === 'No') {
                include_once('../backoffice/sin_permiso.php');
                die();
            }
            o
            if(usuarioTipoRony() || Permisador::puede('nombre_permiso') === 'R/W') {
                echo "Soy usuario tipo rony o tenglo R/W en nombre_permiso";
            }
 *
 *    6
 *          en index despues del <a href='...'></a><?=$gPermisadorClick?>
 *          o
           <?php echo $gPermisoClick('nota_bodega_busqueda_rapida', 'Búsqueda Rápida en Nota Bodega y Salidas a Tiendas', true); ?>
 */

use Iac\inc\sql\IacSqlBuilder;
use JetBrains\PhpStorm\ExpectedValues;

/**
 * Maneja los permisos (de las tablas: permiso_name, iac_usr) junto con permisador_acciones.php para la llavecita
 */
class Permisador {
    const ayudantes = 'ayudantes';
    const pedido_china = 'pedido_china';
    const pedido_china_fabrica = 'pedido_china_fabrica';
    const nueva_inversion_informativa = 'puede_nueva_inversion_informativa';
    const nueva_inversion_interes = 'puede_nueva_inversion_interes';
    const inversion = 'inversion';
    const productos =    'productos';

    protected array $permisos_definicion;

    protected static array $PERMISOS = [
        'reportes_bodega_ventas_existencia' => [
            'permiso' => 'reportes_bodega_ventas_existencia', 'tabla'=>'permiso_usuario',
            'label' => '<span style="color:red"><i class="fa-duotone fa-skull-crossbones"></i> Existencias y Ventas de Bodegas',
            'resumen' => 'En CIF Cost, Containers, Quantity or Rolls ',
            //'grupo' => 'China',
        ],
        'productos_costos_bodega' => [
            'permiso' => 'productos_costos_bodega', 'tabla'=>'permiso_usuario',
            'label' => '<span style="color:red"><i class="fa-duotone fa-skull-crossbones"></i> CHINA Costos de Bodega: CIF',
            'resumen' => 'Registrar/Consultar Costo REAL/CHINA CIF ',
            'grupo' => 'China',
        ],
      'productos_costs_report' => [
        'permiso' => 'productos_costs_report', 'tabla'=>'permiso_usuario',
        'label' => '<span style="color:red"><i class="fa-duotone fa-skull-crossbones"></i> REPORT Costos de Bodega: CIF',
        'resumen' => 'Registrar/Consultar Costo de REPORTE CIF ',
        'grupo' => 'China',
      ],

        'producto_cantidad_por_container' => [
             'permiso' => 'producto_cantidad_por_container', 'tabla'=>'permiso_usuario',
            'label' => 'Calculadora de Contenedores y Cantidad de Producto por Contenedor',
            'resumen' => 'Puede usar la calculadora de contenedores en R/W y R/O, y en R/W puede registrar cuanto cabe de un producto en un contenedor',
            'grupo' => 'China',
        ],
        'importador' => [
            'permiso'=>'importador', 'tabla'=>'permiso_usuario',
            'label'=>'<span style="color:red"><i class="fa-duotone fa-skull-crossbones"></i> Catálogo de Importadores</span>',
            'grupo' => 'China',
            'resumen' =>
                "R/W: Editar el catálogo de Importadores y usarlo/verlo en Pedido a China.
                 R/O: Ver el catálogo delos Importadores y usarlo/verlo en Pedido a China.<br>
                 Nada: No puede ver los importadores ni en cada pedido de China"
        ],
        'puede_deuda' =>
            ['permiso'=>'puede_deuda', 'tabla'=>'iac_usr', 'label'=>'Permiso Deuda',
                'grupo' => 'Cobranza',
            ],

        'puede_clientes' =>
            ['permiso'=>'puede_clientes', 'tabla'=>'iac_usr', 'label'=>'Permisos Clientes',
                'grupo' => 'Clientes',
            ],
        'puede_clientes_cambiar_tienda' => [
            'permiso'=>'puede_clientes_cambiar_tienda',
            'tabla'=>'permiso_usuario',
            'label'=>'Puede Cambiar Tienda de Cobranza',
            'grupo' => 'Clientes',
        ],
        'clientes_saldos' => [
            'permiso'=>'clientes_saldos',
            'tabla'=>'permiso_usuario',
            'label'=>'Puede Consultar Saldos de Clientes',
            'grupo' => 'Clientes',
        ],

        'links_borrados' => ['permiso'=>'links_borrados','label'=>'<i class="fa-duotone fa-skull-crossbones" style="color:red"></i> Links Borrados', 'tabla'=>'permiso_usuario',
            'grupo' => '<span style="color:red"><i class="fa-duotone fa-skull-crossbones"></i> Peligrosos</span>',
            ],

        'todo_a_banco_list' => ['permiso'=>'todo_a_banco_list','label'=>'Links de Todo a Banco',
            'tabla'=>'permiso_usuario', 'grupo' => 'Bancos',],
        'todo_a_banco_links' => ['permiso'=>'todo_a_banco_links',
            'label'=>'Links de Todo a Banco Sin Afectar Cuenta T y Sin Propias', 'tabla'=>'permiso_usuario','grupo' => 'Bancos', ],
        'cuentat_a_banco_list' => ['permiso'=>'cuentat_a_banco_list','label'=>'Links de Cuenta T a Banco',
            'tabla'=>'permiso_usuario', 'grupo' => 'Bancos',],
        'banco_a_banco_list' => ['permiso'=>'banco_a_banco_list','label'=>'Links entre Cuentas Propias',
            'tabla'=>'permiso_usuario', 'grupo' => 'Bancos',],
        'cuentat_a_banco_tc_list' => ['permiso'=>'cuentat_a_banco_tc_list','label'=>'Links de Cuenta T a Banco Tarjetas de Crédito',
            'tabla'=>'permiso_usuario', 'grupo' => 'Bancos',],
        'puede_revisar_movimientos_banco'=>
            ['permiso'=>'puede_revisar_movimientos_banco', 'tabla'=>'iac_usr', 'label'=>'Puede revisar Gastos del Banco',
                'grupo' => 'Bancos',
                ],

        'puede_revisar_gastos_cuentat' =>
            ['permiso'=>'puede_revisar_gastos_cuentat', 'tabla'=>'iac_usr', 'label'=>'Puede revisar Gastos de Cuenta T', 'grupo' => 'Gastos'],
        'puede_gasto_ctat' =>
            ['permiso'=>'puede_gasto_ctat', 'tabla'=>'iac_usr', 'label'=>'Puede Hacer Gastos de Cuenta T (Efectivo)', 'grupo' => 'Gastos'],
        'puede_gasto'=>
            ['permiso'=>'puede_gasto', 'tabla'=>'iac_usr', 'label'=>'Retiros de Banco', 'grupo' => 'Gastos'],


        'puede_ingreso_directo_a_cuentat'=>
            ['permiso'=>'puede_ingreso_directo_a_cuentat', 'tabla'=>'iac_usr', 'label'=>'<i class="fa-duotone fa-skull-crossbones" style="color:red"></i> Permiso Explicito de Ingreso Directo a Cuenta T',
                'grupo' => '<span style="color:red"><i class="fa-duotone fa-skull-crossbones"></i> Peligrosos</span>',
                ],

        'puede_fiduciario' =>
            ['permiso'=>'puede_fiduciario', 'tabla'=>'iac_usr', 'label'=>'Permiso Importación, Fiduciario',
                'grupo' => 'Importación',],

        'puede_inversion' =>
            ['permiso'=>'puede_inversion', 'tabla'=>'iac_usr', 'label'=>'Permiso Inversión Empresa',
                'grupo' => 'Inversiones',
                ],
        'puede_inversion_privada' =>
            ['permiso'=>'puede_inversion_privada', 'tabla'=>'permiso_usuario', 'label'=>'Permiso Inversión Privada','grupo' => 'Inversiones',],
        'puede_nueva_inversion_informativa' =>
            ['permiso'=>'puede_nueva_inversion_informativa', 'tabla'=>'permiso_usuario', 'label'=>'Permiso Nueva Inversión Informativa','grupo' => 'Inversiones',],
        'puede_nueva_inversion_interes' =>
            ['permiso'=>'puede_nueva_inversion_interes', 'tabla'=>'permiso_usuario', 'label'=>'Permiso Nueva Inversión Interes','grupo' => 'Inversiones',],
        'todo_a_banco_inversiones' => ['permiso'=>'todo_a_banco_inversiones','label'=>'Links Inversiones a Banco', 'tabla'=>'permiso_usuario','grupo' => 'Inversiones', ],

        'lock_por_tiempo' =>
            ['permiso'=>'lock_por_tiempo', 'tabla'=>'permiso_usuario', 'label'=>'Quita Lock Por Tiempo','grupo' => 'Notas de Bodega',],
       // 'traslado_match_lock' => ['permiso'=>'traslado_match_lock', 'tabla'=>'permiso_usuario', 'label'=>'Quita Traslado Match Lock (TRS)','grupo' => 'Notas de Bodega',],

        'puede_warehouse' =>
            ['permiso'=>'warehouse', 'tabla'=>'permiso_usuario', 'label'=>'Puede Crear Notas con destino warehouse', 'grupo' => 'Notas de Bodega',],

        'depositar_en_editar' => ['permiso'=>'puede_depositar_en', 'tabla'=>'iac_usr', 'label'=>'Editar "Depositar En',
            'grupo' => 'Cobranza',
            ],

        'ayudantes' => ['permiso'=>'ayudantes', 'tabla'=>'permiso_usuario', 'label'=>'Ayudantes y "Pedido por"',
            'grupo' => 'Notas de Bodega'
            ],

        'puede_reporte_ventas' =>
            ['permiso'=>'puede_reporte_ventas', 'tabla'=>'permiso_usuario', 'label'=>'Reporte de Ventas',
                'pedido_china'=>true, 'bodega' => true,
            ],


        'nota_bodega_busqueda_rapida' =>
            ['permiso'=>'nota_bodega_busqueda_rapida', 'tabla'=>'permiso_usuario',
                'label'=>'Puede hacer Búsqueda Rápida en Notas de Bodega y Salidas a Tiendas',
                'grupo' => 'Notas de Bodega',
            ],
        'bodega inconsistencias_notas' =>
            ['permiso'=>'puede_hacer_reset_inconsistencias', 'tabla'=>'iac_usr', 'label'=>'Hacer Reset o quitar, Inconsistencias',
                'grupo' => 'Notas de Bodega',
                ],
        'puede_autorizar_notas_ultimo_movimiento' =>
            ['permiso'=>'puede_autorizar_notas_ultimo_movimiento', 'tabla'=>'iac_usr',
                'label'=>'Autorizar Mov. Importante Nota de Bodega',
                'grupo' => 'Notas de Bodega',],
        'puede_bodega_destinos_especiales' =>
            ['permiso'=>'puede_bodega_destinos_especiales', 'tabla'=>'iac_usr',
                'label'=>'Usar Origen/Destino Especiales o Huerfanos',
                'grupo' => 'Notas de Bodega',
                ],

        'puede_editar_campos_cash_nota_bodega' =>
            ['permiso'=>'puede_editar_campos_cash_nota_bodega', 'tabla'=>'iac_usr',
                'label'=>'Puede Editar Campos cash o de la Nota de Venta',
                'grupo' => 'Notas de Bodega',],

        'puede_solo_consultar_bodegas' =>
            ['permiso'=>'puede_solo_consultar_bodegas', 'tabla'=>'iac_usr',
                'label'=>'Puede Consultar las Notas de TODAS las bodegas',
                'grupo' => 'Notas de Bodega',
            ],
        'traslados_match' => ['permiso'=>'puede_ver_traslados_match', 'tabla'=>'iac_usr',  'label'=>'Consultar Traslados Match',
            'grupo' => 'Notas de Bodega'
        ],
        'notas_todas_bodegas' => [
            'permiso'=>'notas_todas_bodegas', 'tabla' => 'manual',
            'label'=>'Permiso de notas en TODAS las bodegas',
            'grupo' => 'Notas de Bodega',
        ],
        'notas_por_bodega' => [
            'permiso'=>'notas_por_bodega', 'tabla' => 'manual',
            'label'=>'Permiso de notas la bodega', 'require' => ['bodega_id'],
            'grupo' => 'Notas de Bodega',
        ],

        'puede_editar_campos_cash' => [
            'permiso'=>'puede_editar_campos_cash',
            'tabla' => 'manual',
            'label' => 'Permiso campos cash en notas de bodega',
            'require' => ['origen_id'],
            'grupo' => 'Notas de Bodega',
        ],

        'puede_todas_campos_cash' => [
            'permiso'=>'puede_todas_campos_cash',
            'tabla' => 'manual',
            'label' => 'Permiso Campos Cash en Todas las Tiendas',
            'grupo' => 'Notas de Bodega',
        ],

        'puede_registrar_todas_bodegas' =>
            ['permiso'=>'puede_registrar_todas_bodegas', 'tabla'=>'iac_usr',
                'label'=>'Puede Editar y Registrar Notas en TODAS las bodegas',
                'grupo' => 'Notas de Bodega',
            ],

        'puede_dar_permiso_notas_bodega_corregir_errores' =>
            ['permiso'=>'puede_dar_permiso_notas_bodega_corregir_errores', 'tabla'=>'permiso_usuario',
                'label'=>'Puede dar permiso para corregir errores en las notas',
                'grupo' => 'Notas de Bodega',
            ],

        'crear_tc_temporal' =>
            ['permiso'=>'crear_tc_temporal', 'tabla'=>'permiso_usuario',
                'label'=>'Puede Crear Tipo de Cambio Temporal',
                'grupo' => 'Tipo de Cambio',
            ],
        'tiene_que_revisar_gastos_cuentat' =>
            ['permiso'=>'tiene_que_revisar_gastos_cuentat', 'tabla'=>'permiso_usuario',
                'label'=>'Tiene que autorizar Gastos de Cuenta T',
                'grupo' => 'Gastos',
            ],

        'entrar_impuestos_contenedor' =>
            ['permiso'=>'entrar_impuestos_contenedor', 'tabla'=>'permiso_usuario',
                'label'=>'Puede Entrar a Impuestos de Contenedor',
                'grupo' => 'Impuestos de Contenedor',
            ],

        'entrar_precios_venta' =>
            ['permiso'=>'entrar_precios_venta', 'tabla'=>'permiso_usuario',
                'label'=>'Puede Entrar a Precios de Venta',
                'grupo' => 'Impuestos de Contenedor',
            ],
        'administrar_catalogos_impuestos_contenedor' =>
            ['permiso'=>'administrar_catalogos_impuestos_contenedor', 'tabla'=>'permiso_usuario',
                'label'=>'Puede Administrar Catalogos para Impuestos de Contenedor',
                'grupo' => 'Impuestos de Contenedor',
            ],


        'movimiento_divisa' =>
            ['permiso'=>'consultar_movimiento_divisa', 'tabla'=>'permiso_usuario',
                'label'=>'Puede Consultar Movimiento Divisa',
                'grupo' => 'Movimiento Divisa',
            ],


        'puede_consultar_existencia' =>
            ['permiso'=>'puede_consultar_existencia', 'tabla'=>'iac_usr',
                'label'=>'Puede Consultar Existencia, en la lupa, de Productos en TODAS las bodegas',
                'grupo' => 'Inventario: Bodega Consultar Existencias',
            ],
        'javascript:dialogConsultarExistencia.show(true);' =>
            ['permiso'=>'puede_consultar_existencia', 'tabla'=>'iac_usr',
                'label'=>'Consultar Existencia de Productos en ¡TODAS las Bodegas! Con la Lupa <img alt="lupa" src="../img/icons/Find.png" style="height:1em;width:auto" title="Lupa">',
                'grupo' => 'Inventario: Bodega Consultar Existencias',
            ],
        'puede_consultar_existencia_grid' =>
            ['permiso'=>'puede_consultar_existencia_grid', 'tabla'=>'permiso_usuario',
                'label'=>'Puede Consultar la Existencia de Productos en el grid',
                'grupo' => 'Inventario: Bodega Consultar Existencias',
            ],



        'pedido_china_fabrica' =>
                ['permiso'=>'pedido_china_fabrica', 'tabla'=>'permiso_usuario',
                    'label'=>'<span style="color:red"><i class="fa-duotone fa-skull-crossbones"></i> Fábricas de China</span>',
                    'grupo' => 'China',
                    ],


        'puede_hacer_ajuste_producto_color'=>
            ['permiso'=>'puede_hacer_ajuste_producto_color', 'tabla'=>'iac_usr', 'label'=>'Ajustes a Inventario de Bodega con Nota',
                'grupo' => 'Inventario: Ajustes y Resets'],
        'bodega reset existencia' =>
            ['permiso'=>'puede_hacer_reset_producto_color', 'tabla'=>'iac_usr',  'label'=>'<i class="fa-duotone fa-skull-crossbones" style="color:red"></i> Reset Inventario, SIN Nota',
                'grupo' => 'Inventario: Ajustes y Resets'],
        'puede_consultar_grid_reset_history' => ['permiso'=>'puede_consultar_grid_reset_history', 'tabla'=>'permiso_usuario',
            'label'=>'Consultar Reset History',
            'grupo' => 'Inventario: Ajustes y Resets'],
        'bodega ajuste inventario' =>
                ['permiso'=>'puede_hacer_ajuste_producto_color', 'tabla'=>'iac_usr', 'label'=>'Ajustar Inventario, con Nota',
                    'grupo' => 'Inventario: Ajustes y Resets'],

        'status_producto_color' =>
            ['permiso'=>'status_producto_color', 'tabla'=>'permiso_usuario', 'label'=>'Status de Producto - Color',
                'grupo' => 'Productos y Colores',
            ],
        'productos' => ['permiso'=>'productos', 'tabla'=>'permiso_usuario', 'label'=>'Productos y Colores','grupo' => 'Productos y Colores',],
        'puede_asignar_colores' => ['permiso'=>'puede_asignar_colores', 'tabla'=>'permiso_usuario', 'label'=>'Puede Asignar Colores',
            'grupo' => 'Productos y Colores',],
        'puede_prohibir_colores' => ['permiso'=>'puede_prohibir_colores', 'tabla'=>'permiso_usuario', 'label'=>'Prohibir Colores',
            'grupo' => 'Productos y Colores',],

        'ver_listas'=>['permiso'=>'ver_listas', 'tabla'=>'permiso_usuario', 'label'=>'Prohibir ver listas de precios',
        'grupo' => 'Listas de precios',],
        

        'puede_consultar_cif'=>['permiso'=>'puede_consultar_cif', 'tabla'=>'permiso_usuario', 'label'=>'Prohibir ver columna CIF',
        'grupo' => 'Listas de precios',],

        'puede_ver_listas_pasadas'=>['permiso'=>'puede_ver_listas_pasadas', 'tabla'=>'permiso_usuario', 'label'=>'Puede ver listas pasadas',
        'grupo' => 'Listas de precios',],

        ];

    public function __construct() {
        $this->permisos_definicion = [
            'users' => [],
            'permisos' => [],
            'definicion' => [],
            'nada' => []
        ];
    }

    // Obten permiso de un usuario
    /**
     * @param string $permiso #[ExpectedValues(valuesFromClass: Permisador::class)]
     * @param string $sinPermiso
     * @param string|int|null $user_id
     * @return string|false
     */
    public static function puede(string $permiso, $sinPermiso='Nada', $user_id = null):string|false {
        if($user_id === null || $user_id === '')
            $user_id = $_SESSION['usuario_id'] ?? '';

        $method = __METHOD__;
        $sql = "SELECT /*$method*/ pu.puede
                FROM permiso_usuario pu 
                    WHERE pu.permiso_nombre=" . strit($permiso) .
            " AND pu.iac_usr_id=" . strit($user_id);
        //echo $sql;
        return ia_singleread($sql,
          $sinPermiso
        );
    }


    /**
     * @param $origen_bodega_id
     * @param $puede
     * @return bool
     */
    public static function puedeCamposChashTienda($origen_bodega_id, $puede = 'R/W')
    {
        if(empty($origen_bodega_id))
            return false;


        $usuario_id = $_SESSION['usuario_id'];
        $query = "SELECT 
                puede_editar_campos_cash 
            FROM permiso_bodega_consulta_salida_tienda 
            WHERE iac_usr_id = $usuario_id
            AND origen_bodega_id = ".strit($origen_bodega_id)."
            AND puede_editar_campos_cash = ". strit($puede);
        return ia_singleread($query) === $puede;
    }


    /**
     * @return array|false
     */
    public static function puedeCamposChashPorTiendas()
    {
        $usuario_id = $_SESSION['usuario_id'];
        $query = "SELECT 
                origen_bodega_id,
                puede_editar_campos_cash 
            FROM permiso_bodega_consulta_salida_tienda 
            WHERE iac_usr_id = $usuario_id 
              AND puede_editar_campos_cash <> 'Nada'";
        return ia_sqlArray($query, 'origen_bodega_id');
    }

    public static function puede_consultar_permisos():string {
        if(usuarioTipoRony())
            return 'R/W';
        $puedenRO = ['129'=>true];
        return array_key_exists($_SESSION['usuario_id'] ?? 'x', $puedenRO) ? 'R/O' : 'Nada';
    }

    /**
     * Obten el array que define los permisos
     *
     * @return array
     */
    public static function getPERMISOS(): array {
        return self::$PERMISOS;
    }


    // get Definición de permisos /////////////////////////////////////////////////////////
    public function getDefinicion(array $permisos, array $extraParam):array {
        foreach($permisos as $per) {
            if(!is_array($per)) {
                $per = ['permiso' => '$per'];
            }
            $p = $per['permiso'];
            $table = $per['tabla'] ?? null;
            $per['label'] = $per['label'] ?? $this->title($p);
            switch($table) {
                case 'iac_usr':
                    $encontreElPermiso = $this->getDefinicion_iac_usr($p, $per);
                    $this->permisos_definicion['users'] = array_values($this->permisos_definicion['users']);
                    break;
                case 'permiso_usuario':
                    $encontreElPermiso = $this->getDefinicion_permisador($p, $per);
                    $this->permisos_definicion['users'] = array_values($this->permisos_definicion['users']);
                    break;
                case 'manual':
                    $encontreElPermiso = $this->getDefinicion_manual($p, $per, $extraParam);
                    break;
                default:
                    $encontreElPermiso = null;
            }
            if(empty($encontreElPermiso)) {
                $this->permisos_definicion['message'][] = "Error al traer $p ($table), no encontre el permiso";
                ia_errores_a_dime(
                    "No encontre el permiso: $table.$p: " . ToCode::variable('per', $per),
                    __FILE__, 'Manual', __LINE__
                );
            }
        }

        $this->permisos_definicion['modo'] = usuarioTipoRony() ? 'R/W' : 'R/O';
        return $this->permisos_definicion;
    }

    /**
     * @param string $nombre_permiso
     * @param array $permiso
     * @return bool
     */
    protected function getDefinicion_permisador($nombre_permiso, $permiso):bool {
        $method = __METHOD__;
        $ret = [];
        $values = ia_singleread(
            "SELECT /*$method*/ valores FROM permiso_nombre WHERE permiso_nombre=" . strit($nombre_permiso)
        );
        if(empty($values))
            return false;
        $v = json_decode($values, true);
        if(empty($v))
            return false;
        $esNada = [];
        foreach($v as $d) {
            $esNada[strtolower($d)] = $d;
            $ret[] = ['label' => $this->label($d), 'clasificaId' => $d, 'title' => $this->title($d)];
        }
        $this->sort($ret);
        if(array_key_exists('no', $esNada))
            $nada = $esNada['no'];
        elseif(array_key_exists('nada', $esNada))
            $nada = $esNada['nada'];
        else
            $nada = reset($esNada);

        $nombre = strit($nombre_permiso);
        $users = ia_sqlSelectMultiKey(
            "SELECT /*$method*/ u.nick, IF(pu.puede IS NULL, '$nada', pu.puede) as permiso, u.iac_usr_id
                     FROM iac_usr u 
                         LEFT OUTER JOIN permiso_usuario pu on u.iac_usr_id = pu.iac_usr_id AND pu.permiso_nombre = $nombre
                     WHERE u.iac_usr_id > 1 AND u.vale = 'Active' AND usuario_tipo_rony='No'",1);


        foreach($users as $nick => $u){
            $this->permisos_definicion['users'][$nick][$nombre_permiso] = $u['permiso'];
            $this->permisos_definicion['users'][$nick]['nick'] = $nick;
            $this->permisos_definicion['users'][$nick]['iac_usr_id'] = $u['iac_usr_id'];
        }
        $this->permisos_definicion['definicion'][$nombre_permiso] = $ret;
        $this->permisos_definicion['permisos'][] = [
            ...['permiso'=>$nombre_permiso, 'tabla'=>'permiso_usuario', 'label' => $permiso['label']], ...$permiso
        ];
        $this->permisos_definicion['nada'][$nombre_permiso] = $nada;

        return true;
    }

    protected function getDefinicion_manual($nombre_permiso, $permiso, array $extraParam):bool {
        $method = __METHOD__;
        global $gStrIt;

        $def = $this->getRet($nombre_permiso);

        switch($nombre_permiso) {
            case 'notas_todas_bodegas':
                $this->permisos_definicion['permisos'][] = ['permiso'=>$nombre_permiso, 'tabla'=>'manual', 'label' => $permiso['label']];
                $this->permisos_definicion['definicion'][$nombre_permiso] = $def['ret'];
                $this->permisos_definicion['nada'][$nombre_permiso] = 'Permiso por Bodega';

                $tiendas = ia_sqlArrayIndx(
                    "SELECT bodega_id 
                    FROM bodega 
                    WHERE activo='Si' 
                    ORDER BY grupo = '', grupo, bodega");

                $_usersAll = ia_sqlArray("SELECT /*$method notas_por_bodega*/ 
                        u.iac_usr_id, 
                        u.nick,
                        IFNULL(pb.puede_movimientos, 'Nada') as notas_todas_bodegas,
                        pb.bodega_id
                    FROM iac_usr u
                        LEFT OUTER JOIN permiso_bodega pb on u.iac_usr_id = pb.iac_usr_id
                    WHERE u.iac_usr_id > 1 AND u.usuario_tipo_rony = 'No' AND u.vale = 'Active'
                    ORDER BY u.nick", 'iac_usr_id'
                );
                $total_tiendas = count($tiendas);
                $users_todas = [];
                foreach($_usersAll as $key => $value){
                    $userRO = ia_sqlArrayIndx( "Select bodega_id from permiso_bodega where puede_movimientos = 'R/O' AND iac_usr_id = ". strit($key));

                    if(count($userRO) === $total_tiendas){
                        if(count($userRO) === $total_tiendas){
                            $users_todas[$key]["iac_usr_id"] = $value['iac_usr_id'];
                            $users_todas[$key]["nick"] = $value['nick'];
                            $users_todas[$key]["notas_todas_bodegas"] = 'R/O';
                            continue;
                        }
                        continue;
                    }

                    $userRW = ia_sqlArrayIndx( "Select bodega_id from permiso_bodega where puede_movimientos = 'R/W' AND iac_usr_id = ". strit($key));
                    if(count($userRW) === $total_tiendas){
                        $users_todas[$key]["iac_usr_id"] = $value['iac_usr_id'];
                        $users_todas[$key]["nick"] = $value['nick'];
                        $users_todas[$key]["notas_todas_bodegas"] = 'R/W';
                        continue;
                    }

                    $userCash = ia_sqlArrayIndx( "Select bodega_id from permiso_bodega where puede_movimientos = 'Cash' AND iac_usr_id = ". strit($key));
                    if(count($userCash) === $total_tiendas){
                        $users_todas[$key]["iac_usr_id"] = $value['iac_usr_id'];
                        $users_todas[$key]["nick"] = $value['nick'];
                        $users_todas[$key]["notas_todas_bodegas"] = 'Cash';
                    }

                }
                $users = array_replace($_usersAll, $users_todas);
                $this->permisos_definicion['users'] = [...$this->permisos_definicion['users'], ...$users];
                return true;
            case 'notas_por_bodega':
                $this->permisos_definicion['permisos'][] = ['permiso'=>$nombre_permiso, 'tabla'=>'manual',
                    'bodega_id' => $extraParam['bodega_id'] ?? '',
                    'label' => "Notas en la Bodega: " . ($extraParam['bodega_label'] ?? 'N/A'),
                    ];
                $this->permisos_definicion['definicion'][$nombre_permiso] = $def['ret'];
                $this->permisos_definicion['nada'][$nombre_permiso] = 'Nada';
                $users = ia_sqlArrayIndx(
                    "SELECT /*$method notas_por_bodega*/ u.iac_usr_id, u.nick,
                        IFNULL(pb.puede_movimientos, 'Nada') as notas_por_bodega
                    FROM iac_usr u
                        LEFT OUTER JOIN permiso_bodega pb on u.iac_usr_id = pb.iac_usr_id AND pb.bodega_id = {$gStrIt($extraParam['bodega_id'] ?? '')}
                    WHERE u.iac_usr_id > 1 AND u.usuario_tipo_rony = 'No' AND u.vale = 'Active'
                    ORDER BY u.nick"
                );
                if (empty($users))
                    $users= ia_sqlArrayIndx(
                        "SELECT /*$method*/ u.iac_usr_id, u.nick, 'Nada' as notas_por_bodega
                        FROM iac_usr u
                        WHERE u.iac_usr_id > 1 AND u.usuario_tipo_rony = 'No' AND u.vale = 'Active'
                        ORDER BY u.nick"
                    );
                $this->permisos_definicion['users'] = [...$this->permisos_definicion['users'], ...$users];

                return true;

            case 'puede_editar_campos_cash':
                $this->permisos_definicion['permisos'][] = [
                    'permiso'=>$nombre_permiso,
                    'tabla'=>'manual',
                    'origen_bodega_id' => $extraParam['origen_bodega_id'] ?? '',
                    'label' => "Notas en Tienda: " . ($extraParam['tienda_label'] ?? 'N/A'),
                ];
                $this->permisos_definicion['definicion'][$nombre_permiso] = $def['ret'];
                $this->permisos_definicion['nada'][$nombre_permiso] = 'Nada';


                $usersAll = "SELECT /*$method*/ iu.iac_usr_id, iu.nick, 'Nada' as puede_editar_campos_cash 
                    FROM iac_usr iu
                        JOIN tienda t LEFT JOIN origen_bodega ob ON t.tienda_id = ob.tienda_id AND ob.es='tienda' AND t.vale = 'Active'
                       -- LEFT OUTER JOIN permiso_bodega_consulta_salida_tienda pt ON iu.iac_usr_id = pt.iac_usr_id AND t.tienda_id = pt.tienda_id
                    WHERE iu.vale = 'Active' AND iu.usuario_tipo_rony = 'No'
                    ORDER BY 1,2;";

                $usersSql = "
                  SELECT /*$method*/ iu.iac_usr_id, iu.nick, IFNULL(pt.puede_editar_campos_cash, 'Nada') as puede_editar_campos_cash
                  FROM iac_usr iu 
                    LEFT OUTER JOIN permiso_bodega_consulta_salida_tienda pt ON iu.iac_usr_id=pt.iac_usr_id
                  WHERE iu.vale = 'Active' AND iu.usuario_tipo_rony = 'No' AND pt.origen_bodega_id = " . strit($extraParam["origen_bodega_id"]);

                $_usersAll = ia_sqlArray($usersAll, 'iac_usr_id');
                $_usersSql = ia_sqlArray($usersSql, 'iac_usr_id');
                $users = array_replace($_usersAll, $_usersSql);


                $this->permisos_definicion['users'] = [...$this->permisos_definicion['users'], ...$users];
                return true;
            case 'puede_todas_campos_cash':
                $tiendas = ia_sqlArrayIndx(
                    "SELECT /*$method*/ ob.origen_bodega_id
                            FROM origen_bodega ob
                            WHERE ob.es='Tienda' AND ob.activo='Si'");

                $this->permisos_definicion['permisos'][] = [
                    'permiso'=>$nombre_permiso,
                    'tabla'=>'manual',
                    'origen_bodega_list' => json_encode($tiendas),
                    'label' => "Campos Cash en Todas las  Tiendas",
                ];
                $this->permisos_definicion['definicion'][$nombre_permiso] = $def['ret'];
                // $this->permisos_definicion['nada'][$nombre_permiso] = 'Nada';

                $usersAll = "SELECT /*$method*/ iu.iac_usr_id, iu.nick, 'Nada' as puede_todas_campos_cash 
                    FROM iac_usr iu
                        JOIN tienda t LEFT JOIN origen_bodega ob ON t.tienda_id = ob.tienda_id AND ob.es='tienda' AND t.vale = 'Active'
                       -- LEFT OUTER JOIN permiso_bodega_consulta_salida_tienda pt ON iu.iac_usr_id = pt.iac_usr_id AND t.tienda_id = pt.tienda_id
                    WHERE iu.vale = 'Active' AND iu.usuario_tipo_rony = 'No'
                    ORDER BY 1,2;";

                $_usersAll = ia_sqlArray($usersAll, 'iac_usr_id');
                $total_tiendas = count($tiendas);
                /**
                 * simulamos el campo puede_todas_campos_cash dependiendo del permiso y
                 * comparando con el total de tiendas si los totales coinciden
                 * asumimos que tiene ese permiso en todas las tiendas
                 */
                $users_todas = [];
                foreach($_usersAll as $key => $value){
                    $userRO = ia_sqlArrayIndx( "Select origen_bodega_id from permiso_bodega_consulta_salida_tienda where puede_editar_campos_cash = 'R/O' AND iac_usr_id = ". strit($key));

                    if(count($userRO) === $total_tiendas){
                        $users_todas[$key]["iac_usr_id"] = $value['iac_usr_id'];
                        $users_todas[$key]["nick"] = $value['nick'];
                        $users_todas[$key]["puede_todas_campos_cash"] = 'R/O';
                        continue;
                    }

                    $userRW = ia_sqlArrayIndx( "Select origen_bodega_id from permiso_bodega_consulta_salida_tienda where puede_editar_campos_cash = 'R/W' AND iac_usr_id = ". strit($key));
                    if(count($userRW) === $total_tiendas){
                        $users_todas[$key]["iac_usr_id"] = $value['iac_usr_id'];
                        $users_todas[$key]["nick"] = $value['nick'];
                        $users_todas[$key]["puede_todas_campos_cash"] = 'R/W';
                    }
                }

                $users = array_replace($_usersAll, $users_todas);
                $this->permisos_definicion['users'] = [...$this->permisos_definicion['users'], ...$users];
                return true;
            default:
                return false;
        }
    }

    protected function getDefinicion_iac_usr($nombre_permiso, $permiso):bool {
        $method = __METHOD__;
        $ret = [];
        $values = ia_singleton(
            "SELECT /*$method*/ COLUMN_TYPE, COLUMN_DEFAULT
             FROM information_schema.COLUMNS
             WHERE TABLE_SCHEMA=DATABASE() AND TABLE_NAME='iac_usr' AND COLUMN_NAME=" .strit($nombre_permiso) .
                " AND DATA_TYPE IN ('enum', 'set')"
        );

        if(empty($values))
            return false;
        $esNada = [];
        $arr = explode(",", substr(strstr($values['COLUMN_TYPE'], '('), 1, -1));
        foreach($arr as $d) {
            $d = substr($d, 1, -1);
            $esNada[strtolower($d)] = $d;
            $this->permisos_definicion['info'][$nombre_permiso][$nombre_permiso."_$d"] = [];
            $ret[] = ['label' => $this->label($d), 'clasificaId' => $d, 'title' => $this->title($d)];
        }
        $this->sort($ret);

        if(array_key_exists('no', $esNada))
            $nada = $esNada['no'];
        elseif(array_key_exists('nada', $esNada))
            $nada = $esNada['nada'];
        else
            $nada = reset($ret)['COLUMN_DEFAULT'] ?? reset($esNada);

        if(strcasecmp($nada, 'Si') === 0)
            $nada = 'No';

        $nombre = fieldit($nombre_permiso);
        $users = ia_sqlArray(
            "SELECT /*$method*/ u.nick, iac_usr_id, $nombre
                     FROM iac_usr u 
                     WHERE u.iac_usr_id > 1 AND u.usuario_tipo_rony = 'No' AND u.vale = 'Active' 
                     ORDER BY u.nick", 'nick'
        );

        foreach($users as $nick => $u) {
            $this->permisos_definicion['users'][] = $u;
            $this->permisos_definicion['info'][$nombre_permiso][$nombre_permiso."_".$u[$nombre_permiso] ][] = $nick;
        }
        foreach($this->permisos_definicion['info'][$nombre_permiso] ?? [] as &$quedan)
                if(is_array($quedan))
                    $quedan = implode(", ", $quedan);


        $this->permisos_definicion['definicion'][$nombre_permiso] = $ret;
        $this->permisos_definicion['permisos'][] = ['permiso'=>$nombre_permiso, 'tabla'=>'iac_usr',
            'label' => $permiso['label'] ?? $this->title( $nombre_permiso)];
        $this->permisos_definicion['nada'][$nombre_permiso] = $nada;
        return true;
    }

    protected function getRet($nombre_permiso) {
        $method = __METHOD__;
        $ret = [];
        $values = ia_singleread(
            "SELECT /*$method*/ valores FROM permiso_nombre WHERE permiso_nombre=" . strit($nombre_permiso)
        );
        if(empty($values))
            return false;
        $v = json_decode($values, true);
        if(empty($v))
            return false;

        $esNada = [];
        foreach($v as $d) {
            $esNada[strtolower($d)] = $d;
            $ret[] = ['label' => $this->label($d), 'clasificaId' => $d, 'title' => $this->title($d)];
        }
        $this->sort($ret);
        if(array_key_exists('no', $esNada))
            $nada = $esNada['no'];
        elseif(array_key_exists('nada', $esNada))
            $nada = $esNada['nada'];
        else
            $nada = reset($esNada);
        $this->sort($ret);

        return [
            'ret' => $ret,
            'nada' => $nada,
        ];
    }

    // Info of pemision-users //////////////////////////////////////////////////////////////////////////////////////
    public function infoPermiso($permisos) {
        $method = __METHOD__;
        $info = [];
        foreach($permisos as $permiso)
            switch($permiso['permiso']) {
                case 'notas_todas_bodegas':
                case 'notas_por_bodega':
                    $info['status_bodega'] = true;
                    $info['table_bodega'] = PermisosBodegaCRUD::tablePermisosBodega();
                    // $info = [...$info, ...$this->infoPermisoPorBodega($permisos)];
                    break;
                case 'notas_todas_bodegas_viejo':
                    $info["$permiso[permiso]_RW"] = implode(", ", ia_sqlVector(
                        "SELECT /*$method*/ nick FROM iac_usr 
                            WHERE puede_registrar_todas_bodegas = 'Si' AND vale='Active' AND usuario_tipo_rony = 'No' AND iac_usr_id>1 "));
                    $info["$permiso[permiso]_RO"] = implode(", ", ia_sqlVector(
                        "SELECT /*$method*/ nick FROM iac_usr 
                            WHERE puede_solo_consultar_bodegas='Si' AND vale='Active' AND usuario_tipo_rony = 'No' AND iac_usr_id>1 "));
                    break;
                case 'puede_todas_campos_cash':
                case 'puede_editar_campos_cash':
                    $info['status'] = true;
                    $info['table'] = PermisosBodegaCRUD::tablePermisosCash();
                    break;
                default:
                    if($permiso['tabla'] === 'iac_usr') {
                         $this->getDefinicion_iac_usr($permiso['permiso'], $permiso);
                         if(array_key_exists($permiso['permiso'],$this->permisos_definicion['info'])) {
                             foreach($this->permisos_definicion['info'] as $a)
                                 foreach($a as $k => $d)
                                     $info[$k] = is_array($d) ? implode(", ", $d) : $d;
                         }
                     }
            }
        return $info;
    }

    protected function infoPermisoPorBodega($permisos) {
        $users = [];
        $ret = [];
        global $gPermisosbodega;
        $permisosBodega = $gPermisosbodega->getPermisosPorBodegasUsuarios();
        foreach($permisosBodega as $bodega_id => $userInfo) {
            $ret["notas_por_bodega_RW_$bodega_id"] = [];
            $ret["notas_por_bodega_RO_$bodega_id"] = [];
            $ret["notas_por_bodega_Nada_$bodega_id"] = [];
            foreach($userInfo as $p) {
                $nick = $p['nick'];
                $permiso = str_replace('/', '', $p['puede_movimientos']);
                $users[$nick]["notas_todas_bodegas_$permiso"][] = 1;
                switch($permiso) {
                    case 'RW':
                        $ret["notas_por_bodega_RW_$bodega_id"][] = $p['nick'];
                        break;
                    case 'RO':
                        $ret["notas_por_bodega_RO_$bodega_id"][] = $p['nick'];
                        break;
                    case 'Nada':
                       // $ret["notas_por_bodega_Nada_$bodega_id"][] = $p['nick'];
                        break;
                }
            }
        }

        $numBodegas = count($permisosBodega);

        $ret['notas_todas_bodegas_RW'] = [];
        $ret['notas_todas_bodegas_RO'] = [];
        foreach($users as $nick => $p)
            foreach($p as $permiso => $n)
                if(count($n) === $numBodegas)
                    $ret[$permiso][] = $nick;
        $return = [];
        foreach($ret as $permiso => $usuarios)
            $return[$permiso] = implode(", ", $usuarios);

        return $return;
    }

    // Set, save permisions ////////////////////////////////////////////////////////////////////////////
    public function setPermiso($permisos, $cambios, $extraParams) {

        if(!usuarioTipoRony())
            return [
                'code' => 200,
                'status' => false,
                'message' => 'Sin Permiso' ,
            ];
        if(empty($permisos) || empty($cambios))
            return [
                'code' => 200,
                'status' => false,
                'message' => 'Error de transmisión. No llegaron los datos: permisos y/o cambios' ,
            ];

        global $gPermisosbodega, $gStrIt;
        $method = __METHOD__;
        $builder = new IacSqlBuilder();

        foreach($permisos as $permiso) {


            $fielded = fieldIt($permiso['permiso']);

            foreach($cambios[$permiso['permiso']] as $valor => $usuarios) {

                switch($permiso['permiso']) {
                    case 'puede_registrar_todas_bodegas':
                        $gPermisosbodega->setRegistraNotasTodasBodegas($valor, $usuarios);
                        die("ELIMINANDO OPCION");
                    case 'puede_solo_consultar_bodegas':
                        $gPermisosbodega->setConsultarNotasTodasBodegas($valor, $usuarios);
                        die("ELIMINANDO OPCION");
                }
                switch($permiso['tabla']) {
                    case 'iac_usr':
                        ia_query("UPDATE /*$method*/ iac_usr SET $fielded = {$gStrIt($valor)} 
                                     WHERE " . $builder->where(['iac_usr_id' => $usuarios])
                        );
                        break;
                    case 'permiso_usuario':
                    case 'permiso_nombre':
                        $insert = [];

                        foreach($usuarios as $iac_usr_id)
                            $insert[] = $builder->insertValues(['permiso_nombre' => $permiso['permiso'], 'puede' => $valor, 'iac_usr_id' => $iac_usr_id ]);

                        $sql = "INSERT INTO permiso_usuario (permiso_nombre, puede, iac_usr_id) VALUES" .
                            implode(",", $insert) . " /*$method*/ ON DUPLICATE KEY UPDATE puede = " . strit($valor);
                        ia_query($sql);

                        break;
                    case 'manual':
                        $this->setPermisoManual($permiso, $usuarios, $valor, $extraParams);
                        break;
                }
            }
        }

        return [
            'code' => 200,
            'status' => true,
            'message' => '' ,
            'info' => $this->infoPermiso($permisos),
            'content_type' => 'json',
        ];
    }

    protected function setPermisoManual(array $permiso, array $usuarios,mixed $valor, $extraParam) {
        if(empty($usuarios))
            return;
        global $gStrIt;
        $method = __METHOD__;
        $builder = new IacSqlBuilder();
        $sql = [];
        switch($permiso['permiso']) {
            case 'notas_todas_bodegas':
                $cambios = $extraParam["cambios"]["notas_todas_bodegas"] ?? [];
                $tiendas_list = ia_sqlArrayIndx("SELECT bodega_id FROM bodega WHERE activo = 'Si' ");

                $ok = false;
                foreach($cambios as $valor => $iac_usr_ids) {
                    if($valor === 'Nada')
                        continue;
                    foreach ($iac_usr_ids as $_id){
                        foreach ($tiendas_list as $id) {
                            $update = [
                                'puede_movimientos' => $valor,
                                "iac_usr_id" => $_id,
                                "bodega_id" => $id['bodega_id']
                            ];
                            $ok |= ia_query(ia_insert("permiso_bodega", $update, [], "", true));
                        }
                    }
                }
                break;
            case 'notas_por_bodega':
                $bodega_id = $permiso['bodega_id'] ?? '';
                if(empty($bodega_id)) {
                    break;
                }

                $sql[] =
                    "INSERT /*$method*/ INTO permiso_bodega(bodega_id, iac_usr_id, puede_movimientos)
                                 SELECT {$gStrIt($bodega_id)}, i.iac_usr_id, {$gStrIt($valor)}
                                 FROM iac_usr i
                                 WHERE i.vale = 'Active' AND " .
                                    $builder->where([ 'i.iac_usr_id' => $usuarios]) . " 
                            ON DUPLICATE KEY UPDATE puede_movimientos = {$gStrIt($valor)}";
                    if($valor <> 'R/W')
                        $sql[] = "UPDATE iac_usr SET puede_registrar_todas_bodegas='No' WHERE " . $builder->where(['iac_usr_id' => $usuarios]);
                    if($valor === 'Nada')
                        $sql[] = "UPDATE iac_usr SET puede_solo_consultar_bodegas='No' WHERE " . $builder->where(['iac_usr_id' => $usuarios]);
                break;
            case 'puede_editar_campos_cash':
                $origen_bodega_id = $permiso['origen_bodega_id'] ?? '';
                if(empty($origen_bodega_id))
                    break;

                $ok = false;
                $cambios = $extraParam["cambios"]["puede_editar_campos_cash"] ?? [];
                foreach($cambios as $valor => $iac_usr_ids) {
                    $tienda_id = ia_singleread("select tienda_id from origen_bodega where origen_bodega_id = ". strit($origen_bodega_id));
                    foreach ($iac_usr_ids as $_id){
                        $update = [
                            'puede_editar_campos_cash' => $valor,
                            "iac_usr_id" => $_id,
                            "origen_bodega_id" => $origen_bodega_id,
                            "tienda_id" => $tienda_id
                        ];
                        $ok |= ia_query(ia_insert("permiso_bodega_consulta_salida_tienda", $update, [], "", true));
                    }
                }
                break;
            case 'puede_todas_campos_cash':
                $cambios = $extraParam["cambios"]["puede_todas_campos_cash"] ?? [];
                $tiendas_list = json_decode($permiso['origen_bodega_list'] ?? '{}', true);
                $ok = false;
                foreach($cambios as $valor => $iac_usr_ids) {
                    if($valor === 'Nada')
                        continue;
                    foreach ($iac_usr_ids as $_id){
                        foreach ($tiendas_list as $id) {
                            $tienda_id = ia_singleread("select tienda_id from origen_bodega where origen_bodega_id = ". strit($id['origen_bodega_id']));
                            $update = [
                                'puede_editar_campos_cash' => $valor,
                                "iac_usr_id" => $_id,
                                "origen_bodega_id" => $id['origen_bodega_id'],
                                "tienda_id" => $tienda_id
                            ];
                            $ok |= ia_query(ia_insert("permiso_bodega_consulta_salida_tienda", $update, [], "", true));
                        }
                    }
                }
                break;
            default:
        }

        ia_transaction($sql);
    }

// Helpers /////////////////////////////////////////////////////////////////////////////////////////////////

    protected function sort(&$array):void {
        uasort($array, function($a, $b) {
            $toNum = array_flip([
                'NO', 'NADA', 'R/O' => 'Solo Ver', 'RO' => 'Solo Ver', 'CON'  => 'Llenar Pólizas de Contabilidad',
                'CONT'  => 'Llenar Pólizas de Contabilidad',
                'R/W', 'RW',
                'SI'

            ]);
            return ($toNum[strtoupper($a['clasificaId'])]  ?? 99) <=> ($toNum[strtoupper($b['clasificaId'])] ?? 99);
        });
    }

    protected function label(string $option):string {return $option;}

    protected function title(string $option):string {
        return match (strtolower($option)) {
            'nada', 'no' => 'Nada: Sin permiso',
            'r/o', 'ro' => 'R/O: Solo Ver',
            'r/w', 'rw' => 'R/W: Editar, registrar',
            'pedir' => 'Programar',
            'cont' => 'Registrar Pólizas de Contabilidad',
            default => $option,
        };
    }

}
