<?php

  use Iac\inc\sql\IacSqlBuilder;

#[AllowDynamicProperties]
  class PermisosBodegaCRUD {

    public function grupoVerificadorBodegas(string|int $bodega_grupo_verificador_id):array {
        $method = __METHOD__;
        return ia_sqlArray(
            "SELECT /*$method*/
                   IF( (SELECT 1 
                        FROM bodega_grupo_verificador_verfica_bodega bgvvb
                        WHERE b.bodega_id = bgvvb.bodega_id AND bgvvb.bodega_grupo_verificador_id=" . strit($bodega_grupo_verificador_id) . "
                        ) = '1', 'No', 'Si') as disponible,
                    b.bodega_id, b.grupo, b.bodega, b.color,
                   (SELECT GROUP_CONCAT(bg.grupo_verficiador ORDER BY bg.grupo_verficiador SEPARATOR ', ')
                    FROM bodega_grupo_verificador bg
                             JOIN bodega_grupo_verificador_verfica_bodega bgb ON bgb.bodega_grupo_verificador_id=bg.bodega_grupo_verificador_id
                             JOIN bodega bb ON bb.bodega_id=bgb.bodega_id
                    WHERE bgb.bodega_id=b.bodega_id
                   ) as ya_verifican
                FROM bodega b
                WHERE b.activo='Si'
                ORDER BY b.grupo, b.bodega",
            'bodega_id'
        );
    }

    public function grupoVerificadorVerificadores(string|int $bodega_grupo_verificador_id):array {
        $method = __METHOD__;
        return ia_sqlArray(
            "SELECT /*$method*/
                   IF( (SELECT 1
                        FROM bodega_grupo_verificador_verifica_usuario iu
                        WHERE u.iac_usr_id = iu.iac_usr_id AND iu.bodega_grupo_verificador_id=" . strit($bodega_grupo_verificador_id) . "
                        ) = '1', 'No', 'Si') as disponible,
                    u.iac_usr_id, u.nick, u.nombre,
       
               ( SELECT GROUP_CONCAT(g.grupo_verficiador ORDER BY g.grupo_verficiador SEPARATOR ', ')
                  FROM bodega_grupo_verificador_verifica_usuario iu
                    JOIN bodega_grupo_verificador g ON g.bodega_grupo_verificador_id = iu.bodega_grupo_verificador_id
                   WHERE u.iac_usr_id=iu.iac_usr_id) as ya_verifican
            FROM iac_usr u
            WHERE u.vale = 'Active' AND u.usuario_tipo_rony='No' 
            ORDER BY u.nick",
            'iac_usr_id'
        );
    }

    public function grupoVerificadorConsulta(string|int $bodega_grupo_verificador_id):array {
        $method = __METHOD__;
        return ia_sqlArray(
            "SELECT /*$method*/
                   IF( (SELECT 1
                        FROM bodega_grupo_verificador_verifica_usuario_consulta iu
                        WHERE u.iac_usr_id = iu.iac_usr_id AND iu.bodega_grupo_verificador_id=" . strit($bodega_grupo_verificador_id) . "
                        ) = '1', 'No', 'Si') as disponible,
                    u.iac_usr_id, u.nick, u.nombre,
       
               ( SELECT GROUP_CONCAT(g.grupo_verficiador ORDER BY g.grupo_verficiador SEPARATOR ', ')
                  FROM bodega_grupo_verificador_verifica_usuario_consulta iu
                    JOIN bodega_grupo_verificador g ON g.bodega_grupo_verificador_id = iu.bodega_grupo_verificador_id
                   WHERE u.iac_usr_id=iu.iac_usr_id) as ya_verifican
            FROM iac_usr u
            WHERE u.vale = 'Active' AND u.usuario_tipo_rony='No' 
            ORDER BY u.nick",
            'iac_usr_id'
        );
    }

    public function grupoVerficadorList(bool $reportOnly = false):string {
        $grupos = [];
        foreach($this->getGruposVerificadores() as $grupo_verificacion) {
            $grupos[] = $this->grupoVerificadorCard($grupo_verificacion, $reportOnly);
        }

        return implode("\r\n", $grupos);
    }

    public function grupoVerificadorCard(array $grupo_verificacion, bool $reportOnly = false):string {
        $bodega_grupo_verificador_id = $grupo_verificacion['bodega_grupo_verificador_id'];

        $concatenate = [];
        foreach($this->grupoVerificadorBodegas($bodega_grupo_verificador_id) as $b)
            if ($b['disponible'] === 'No') {
                $bodega = htmlentities($b['bodega']);
                $concatenate[] = getLabelBodega($b, ['grupo' => true]) . " <sup title='$bodega se verifica en $b[ya_verifican]'>$b[ya_verifican]</sup>";
            }
        $verificaBodegas =  empty($concatenate) ? '' :  "<ol class='pb_items'><li>" . implode("<li>", $concatenate) . "</li></ol>";

        $concatenate = [];
        foreach($this->grupoVerificadorVerificadores($bodega_grupo_verificador_id) as $b)
            if($b['disponible'] === 'No') {
                $nick = htmlentities($b['nick']);
                $redYaVerifican = str_contains($b['ya_verifican'], ",") ? " style='color:darkred' " : '';
                $concatenate[] = $this->userNameLabel($b, " $nick verifica en los grupos: $b[ya_verifican]") . " <sup $redYaVerifican>$b[ya_verifican]</sup>";
            }
        $verificadores =  empty($concatenate) ? '' :  "<ol class='pb_items'><li>" . implode("<li>", $concatenate) . "</li></ol>";

        $concatenate = [];
        foreach($this->grupoVerificadorConsulta($bodega_grupo_verificador_id) as $b)
            if($b['disponible'] === 'No') {
                $nick = htmlentities($b['nick']);
                $concatenate[] = $this->userNameLabel($b, " $nick puede consultar las verificaicones de: $b[ya_verifican]") . " <sup>$b[ya_verifican]</sup>";
            }
        $consultan =  empty($concatenate) ? '' :  "<ol class='pb_items'><li>" . implode("<li>", $concatenate) . "</li></ol>";

        $lugar = htmlentities($grupo_verificacion['grupo_verficiador']);

        if(!$reportOnly && usuarioTipoRony()) {

          $editBodegas = <<<BUTTON_EDIT
            <button data-grupo_verificacion="$bodega_grupo_verificador_id" data-edita="bodegas" onclick=""
                type="button" class="icon_ui_button"><span class="ui-icon ui-icon-pencil"></span></button>
            BUTTON_EDIT;
          $editVerificadores = <<<BUTTON_EDIT
            <button data-grupo_verificacion="$bodega_grupo_verificador_id" data-edita="bodegas" onclick=""
                type="button" class="icon_ui_button"><span class="ui-icon ui-icon-pencil"></span></button>
            BUTTON_EDIT;
          $editConsultan = <<<BUTTON_EDIT
            <button data-grupo_verificacion="$bodega_grupo_verificador_id" data-edita="bodegas" onclick=""
                type="button" class="icon_ui_button"><span class="ui-icon ui-icon-pencil"></span></button>
            BUTTON_EDIT;
        } else {
          $editBodegas = $editVerificadores = $editConsultan = '';
        }

        return <<<ITEMS
<div style="border:1px darkgreen solid;margin:1em;background-color:whitesmoke;width:fit-content">
    <div style="text-align:center;font-size:1.4em">$lugar</div>
    <div style="width:fit-content;display:flex">
        <div style="border:1px darkgreen solid;padding:1em;">
              $editBodegas  
              Bodegas<hr>$verificaBodegas</div>
        <div style="border:1px darkgreen solid;padding:1em;">
            $editVerificadores
            Verifican<hr>$verificadores</div>
        <div style="border:1px darkgreen solid;padding:1em;">
            $editConsultan
            Consultan<hr>$consultan</div>
    </div>
</div>
ITEMS;
    }

    protected function getGruposVerificadores():array {
        if(!empty($this->grupoVerificadorVerificadores))
            return $this->grupoVerificadorVerificadores;
        $method = __METHOD__;
        $select = "SELECT /*$method*/
                    *,
                    (SELECT COUNT(*) FROM bodega_grupo_verificador_verfica_bodega gbvb WHERE gbvb.bodega_grupo_verificador_id = bgv.bodega_grupo_verificador_id) numero_bodegas,
                    (SELECT COUNT(*) FROM bodega_grupo_verificador_verifica_usuario bgvu WHERE bgvu.bodega_grupo_verificador_id = bgv.bodega_grupo_verificador_id) numero_revisores,
                    (SELECT COUNT(*) FROM bodega_grupo_verificador_verifica_usuario_consulta bgvu WHERE bgvu.bodega_grupo_verificador_id = bgv.bodega_grupo_verificador_id) numero_consulta
                    FROM bodega_grupo_verificador bgv ORDER BY grupo_verficiador";
        $this->grupoVerificadorVerificadores = ia_sqlArrayIndx($select);
        return $this->grupoVerificadorVerificadores;
    }

    protected function userNameLabel(array $user, string $extraTitle = ''):string {
        return "<span title='" . htmlentities($user['nombre']) . " $extraTitle'>" . htmlentities($user['nick']) . "</span>";
    }
/////////////////////////
    function bodegas_fragment_links():string {
      $bodegas = ia_sqlArray(
        "SELECT bodega_id, grupo, color, bodega, encargado_id FROM bodega WHERE activo='Si'", "bodega_id"
      );
      $links = [];
      foreach($bodegas as $b) {
        $id = $this->bodega_html_id($b['bodega']);
        $links[] = "<span class='pb_bodega_fragment '><a href='#$id'>" . htmlentities($b['bodega']) . "</a></span>";
      }
      return implode(' ', $links);
    }

    protected function bodega_html_id($bodega_name):string {
      $id = htmlentities( rtrim(strstr($bodega_name, ' ', true) ) );
      return empty($id) ? htmlentities($bodega_name) : $id;
    }

    function repBodega():string {
        $method = __METHOD__;
        $usersInactive = ia_sqlKeyValue("SELECT /*$method*/ iac_usr_id, nick FROM iac_usr  WHERE vale<>'Active'");
        $supervisores = ia_sqlKeyValue(
            "SELECT /*$method*/ iac_usr_id, nick FROM iac_usr 
                        WHERE vale='Active' AND iac_usr_id>1 AND puede_supervisar_bodega='Si'
                        ORDER BY 2"
        );
        $sonSup = 'Supervisores: ' . implode(", ", $supervisores);
        $bodegas = ia_sqlArray("SELECT /*$method*/ bodega_id, bodega, grupo, color, encargado_id FROM bodega WHERE activo='Si' ORDER BY bodega", "bodega_id");
        $lugaresBodegas =
            "SELECT /*$method*/ bg.bodega_id, g.grupo_verficiador, g.bodega_grupo_verificador_id
         FROM bodega_grupo_verificador g 
             JOIN bodega_grupo_verificador_verfica_bodega bg on g.bodega_grupo_verificador_id = bg.bodega_grupo_verificador_id
             ";
        $lugares = ia_sqlSelectMultiKey($lugaresBodegas, 2);
        $sql =
            "SELECT /*$method*/ pb.bodega_id as g1, u.iac_usr_id as g2, pb.*, u.nick
            FROM permiso_bodega pb 
            JOIN iac_usr u ON u.iac_usr_id=pb.iac_usr_id
            WHERE u.vale='Active'
            ORDER BY u.nick";
        $permisos = ia_sqlSelectMultiKey($sql, 2);

        $table = [];
        foreach($bodegas as $bodega_id => $infoBodega) {
            $rw = [];
            $ro = [];
            $verificanRW = [];
            $verificanRO = [];
            foreach ($permisos[$bodega_id] ?? [] as $d) {
                $userNick = $d['nick'];
                $userId = $d['iac_usr_id'];
                if(array_key_exists($userId, $usersInactive))
                    $userNick = "<span title='¡Usuario Inavtivo!' class='user_nick user_inactive' data-userid='$userId' data-usernick='$userNick'>$userNick<sup></sup></span>";
                elseif(array_key_exists($userId, $supervisores))
                    $userNick = "<span title='Supervisor!' class='user_nick user_supervisor' data-userid='$userId' data-user_nick='$userNick'>$userNick<sup>Ⓢ</sup></span>";
                else
                    $userNick = "<span title='' class='user_nick' data-userid='$userId' data-user_nick='$userNick'>$userNick<sup></sup></span>";
                switch ($d['puede_movimientos']) {
                    case 'R/W':
                        $rw[$d['iac_usr_id']] =  $userNick;
                        break;
                    case 'R/O':
                        $ro[$d['iac_usr_id']] = $userNick;
                }
                switch ($d['puede_verificar_movimientos']) {
                    case 'R/W':
                        $verificanRW[$d['iac_usr_id']] = $userNick;
                        break;
                    case 'R/O':
                        $verificanRO[$d['iac_usr_id']] = $userNick;
                }
            }

            foreach(array_intersect_key($rw, $verificanRW) as $usuario_id => $nick) {
                if(array_key_exists($usuario_id, $supervisores))
                    continue;
                $rw[$usuario_id] = "<span title='Tambien verifica notas de la bodega $infoBodega[bodega]' style='color:darkred'>$nick</span>";
                $verificanRW[$usuario_id] = "<span title='Tambien registra notas en la bodega $infoBodega[bodega]' style='color:darkred'>$nick</span>";
            }


            $table[] = "<tr><th id='$infoBodega[bodega]' colspan='6' class=''><h2>" . getLabelBodega($infoBodega) . "</h2>";
            $table[] = "<tr>
               <!-- <th ><span title='O jefe'>Responsable</span>  -->                       
                <th >Registran Notas 
                <th>Ven las Notas 
                <th style='width:10em;text-align: center'>Lugar Verifica:<br>  
                <th>Verificadores:
                <th>Ven verificaciones: ";
            $table[] = "<tr>" .
                "<td id='movRw$bodega_id' class='tablaPBMaxCol' style='white-space: normal'>" . implode(", ", $rw) .
                "<td id='movRo$bodega_id' class='tablaPBMaxCol' style='white-space: normal'>" . implode(", ", $ro) .
                "<td class='tablaPBMaxCol' style='white-space: normal'>" . implode(", ",  array_keys( $lugares[$bodega_id] ?? [])) .
                "<td class='tablaPBMaxCol' style='white-space: normal'>" . implode(", ", $verificanRW) .
                "<td id='verRo$bodega_id' class='tablaPBMaxCol' style='white-space: normal'>" . implode(", ", $verificanRO)
            ;
        }

        return "<table id='pb_permiso_bodega_tabla' class='tablaPB'>" . implode("\r\n\t", $table) . "</table>";
    }

    function reportePorBodega():string { return $this->repBodega();}

///////////////////////

    function reportePorUsuario():string {
        $method = __METHOD__;
        $permisos = [];
        $countBodegas = (int)ia_singleread("SELECT /*$method*/ COUNT(*) FROM bodega WHERE activo='Si'");
        $arr = ia_sqlSelectMultiKey(
            "SELECT /*$method*/ pt.iac_usr_id, ob.clave
                FROM permiso_bodega_consulta_salida_tienda pt
                JOIN origen_bodega ob ON ob.origen_bodega_id = pt.origen_bodega_id
                ",
            2
        );
        $salidaATienda = [];
        foreach($arr as $iac_usr_id => $d)
            $salidaATienda[$iac_usr_id] = "<ol style='text-align:left'><li>" . implode("<li>", array_keys($d)) . "</ol>";
        /*
         * TODAS LAS BODEGAS
         * iu.puede_ver_traslados es traslados a todas las tiendas
         */
        $porUsuarios = ia_sqlArrayIndx("
            SELECT /*$method*/ iu.nick, iu.nombre, iu.iac_usr_id, 
                iu.puede_supervisar_bodega, iu.puede_bodega_destinos_especiales, iu.puede_autorizar_notas_ultimo_movimiento,
                iu.puede_editar_campos_cash_nota_bodega, iu.puede_ver_traslados,  iu.puede_ver_traslados_match,       
                iu.puede_consultar_existencia,iu.puede_hacer_reset_producto_color, iu.puede_hacer_ajuste_producto_color,iu.puede_hacer_reset_inconsistencias,
                iu.notificar_nuevas_cartas_porte,iu.puede_solo_consultar_bodegas,iu.puede_registrar_todas_bodegas,
                b.grupo, b.bodega, b.color,
               (SELECT GROUP_CONCAT(gv.grupo_verficiador ORDER BY gv.grupo_verficiador SEPARATOR ', ') 
               FROM bodega_grupo_verificador gv
               JOIN bodega_grupo_verificador_verifica_usuario bgvvu on gv.bodega_grupo_verificador_id = bgvvu.bodega_grupo_verificador_id
                   WHERE bgvvu.iac_usr_id = iu.iac_usr_id
               ) as grupo_verificador,
               pb.* 
        FROM permiso_bodega pb 
            JOIN iac_usr iu on pb.iac_usr_id = iu.iac_usr_id
            JOIN bodega b on pb.bodega_id = b.bodega_id
        WHERE iu.vale = 'Active' AND iu.iac_usr_id>1 AND b.activo='Si'
        ORDER BY iu.nick, b.grupo, b.bodega");

        //$todasLasBodegas = implode(", ", ia_sqlVector("SELECT /*$method*/ bodega FROM bodega WHERE activo='Si' ORDER BY grupo, bodega"));
        $thNotasRW = "Registra<br>Notas<br>En";
        $thNotasRO = "Consulta<br>Notas<br>De";
        $thEncargado = "Encargado<br>de las<br>Bodegas";
        $thVerificaRW = 'Verfica<br>Notas<br>En';
        $thVerificaRO = 'Consulta<br>Verificación<br>En';
        $titleSupervisor = " title='Por ser supervisor' ";
        $titleTodas = " title='Por tener el permiso en todas las bodegas' ";

        foreach($porUsuarios as $d) {
            $bodega_id = $d['bodega_id'];
            $bodega = $d['bodega'];
            $nick = $d['nick'];
            $esSup = $d['puede_supervisar_bodega'] === 'Si';
            $permisos[$nick]['Nick'] = $nick;
            $permisos[$nick]['<span style="color:darkred">Supervisor</span>'] = $esSup ? "<span style='color:darkred;font-size:1.1em;'>⚡</span>" : '';
            $permisos[$nick]['<span style="color:darkred">Origen Huerfano</span>'] = $esSup || $d['puede_bodega_destinos_especiales'] === 'Si' ? "<span style='color:darkred;font-size:1.1em;'>⚡</span>" : '';
            $permisos[$nick]['<span style="color:darkred">Reset<br>Producto<br>Color</span>'] = $esSup || $d['puede_hacer_reset_producto_color'] === 'Si' ? "<span style='color:darkred;font-size:1.1em;'>⚡</span>" : '';
            $permisos[$nick]['<span style="color:darkred">Ajuste<br>Producto<br>Color</span>'] = $esSup || $d['puede_hacer_ajuste_producto_color'] === 'Si' ? "<span style='color:darkred;font-size:1.1em;'>⚡</span>" : '';
            $permisos[$nick]['<span style="color:darkred">Autoriza<br>Último<br>Movimiento</span>'] = $esSup || $d['puede_autorizar_notas_ultimo_movimiento'] === 'Si' ? "<span style='color:darkred;font-size:1.1em;'>⚡</span>" : '';
            $permisos[$nick]['<span style="color:darkred">Reset<br>Inconsistencias</span>'] = $esSup || $d['puede_hacer_reset_inconsistencias'] === 'Si' ? "<span style='color:darkred;font-size:1.1em;'>⚡</span>" : '';

            $permisos[$nick]['<span style="color:darkred">Traslados Match</span>'] = $esSup || $d['puede_ver_traslados_match'] === 'Si' ? "<span style='color:red;font-size:1.1em;'>⚡</span>" : '';

            if($esSup) {
                $permisos[$nick]['Ven Notas<br>a las<br>Tiendas'] = "<span $titleSupervisor style='color:darkred;font-size:1.1em;'>⚡ Todas</span>";
            }elseif($d['puede_ver_traslados'] === 'Si')
                $permisos[$nick]['Ven Notas<br>a las<br>Tiendas'] = "<span $titleTodas style='color:darkred;font-size:1.1em;'>⚡ Todas</span>";
            else
                $permisos[$nick]['Ven Notas<br>a las<br>Tiendas'] = $salidaATienda[$d['iac_usr_id']] ?? '';

            $permisos[$nick]['Editar Cash'] = $esSup || $d['puede_editar_campos_cash_nota_bodega'] === 'Si' ? "<span style='color:green;font-size:1.1em;'>✔</span>" : '';

            $permisos[$nick]['Consultar<br>Existencia'] = $esSup || $d['puede_consultar_existencia'] === 'Si' ? "<span style='color:green;font-size:1.1em;'>✔</span>" : '';
            $permisos[$nick]['Notifica<br>Carta<br>Porte'] = $d['notificar_nuevas_cartas_porte'] === 'Si' ? "<span style='color:green;font-size:1.1em;'>✔</span>" : '';

            if($d['es_encargado'] === 'Si')
              $permisos[$nick][$thEncargado][$bodega_id] = $bodega;
            elseif(!isset($permisos[$nick][$thEncargado]))
                $permisos[$nick][$thEncargado] = [];


            if(!isset($permisos[$nick][$thNotasRW]))
                $permisos[$nick][$thNotasRW] = [];
            if(!isset($permisos[$nick][$thNotasRO]))
                $permisos[$nick][$thNotasRO] = [];

            if($esSup) {
                $permisos[$nick][$thNotasRW]["todas"] = "<span $titleSupervisor style='color:darkred;font-size:1.1em;'>⚡ Todas</span>";
                $permisos[$nick][$thNotasRO]["todas"] = "<span $titleSupervisor style='color:darkred;font-size:1.1em;'>⚡ Todas</span>";
            } else {
                if($d['puede_registrar_todas_bodegas'] === 'Si')
                    $permisos[$nick][$thNotasRO]["todas"] = "<span title='Por estar en Puede Registrar en todas las Bodegas' style='color:red;font-size:1.1em;'>✓ Todas</span>";
                elseif(count($permisos[$nick][$thNotasRW]) === $countBodegas)
                    $permisos[$nick][$thNotasRW]["todas"] = "<span $titleTodas style='color:darkred;font-size:1.1em;'>⚡ Todas</span>";

                if($d['puede_solo_consultar_bodegas'] === 'Si')
                    $permisos[$nick][$thNotasRO]["todas"] = "<span title='Por estar en Puede Consultar Todas las Bodegas' style='color:red;font-size:1.1em;'>✓ Todas</span>";
                elseif(count($permisos[$nick][$thNotasRO]) === $countBodegas)
                    $permisos[$nick][$thNotasRO]["todas"] = "<span $titleTodas style='color:red;font-size:1.1em;'>✓ Todas</span>";
                switch($d['puede_movimientos']) {
                    case 'R/W':
                        if($d['puede_registrar_todas_bodegas'] !== 'Si')
                            $permisos[$nick][$thNotasRW][$bodega_id] = $bodega;
                        break;
                    case 'R/O':
                        if($d['puede_solo_consultar_bodegas'] !== 'Si')
                            $permisos[$nick][$thNotasRO][$bodega_id] = $bodega;
                        break;
                }
            }

           $permisos[$nick]['En<br>Lugar<br>Verifica'] = $d['grupo_verificador'];

            if(!isset($permisos[$nick][$thVerificaRW]))
                $permisos[$nick][$thVerificaRW] = [];
            if(!isset($permisos[$nick][$thVerificaRO]))
                 $permisos[$nick][$thVerificaRO] = [];
            if($esSup ) {
                $permisos[$nick][$thVerificaRW]["todas"] = "<span $titleSupervisor style='color:green;font-size:1.1em;'>✔ Todas</span>";
                $permisos[$nick][$thVerificaRO]["todas"] = "<span $titleSupervisor style='color:green;font-size:1.1em;'>✔ Todas</span>";
            } else {
                if(count($permisos[$nick][$thVerificaRW]) === $countBodegas)
                    $permisos[$nick][$thVerificaRW]["todas"] = "<span $titleTodas style='color:green;font-size:1.1em;'>✔ Todas</span>";
                if(count($permisos[$nick][$thVerificaRO]) === $countBodegas)
                    $permisos[$nick][$thVerificaRO]["todas"] = "<span $titleTodas style='color:green;font-size:1.1em;'>✔ Todas</span>";
                switch($d['puede_verificar_movimientos']) {
                    case 'R/W':
                        if(count($permisos[$nick][$thVerificaRW]) !== $countBodegas)
                            $permisos[$nick][$thVerificaRW][$bodega_id] = $bodega;
                        break;
                    case 'R/O':
                        if(count($permisos[$nick][$thVerificaRO]) !== $countBodegas)
                            $permisos[$nick][$thVerificaRO][$bodega_id] = $bodega;
                        break;
                }
            }
            // marca los usuarios con permiso delicado
            foreach($permisos[$nick] as $checa) {
                if(empty($checa) || is_array($checa))
                    continue;
                if(str_contains($checa, '⚡')) {
                    $permisos[$nick]['Nick'] = "<span style='color:darkred;font-size:1.05em;'>⚡ $nick</span>";
                    break;
                }
                if(str_contains($checa, '✓')) {
                    $permisos[$nick]['Nick'] = "<span style='color:red;'>✓ $nick</span>";
                    break;
                }
            }
        }
        foreach($permisos as &$todas) {
            if(count($todas[$thEncargado]) === $countBodegas)
                $todas[$thEncargado] = ['todas' => "<span $titleTodas style='color:darkred;font-size:1.1em;'>⚡ Todas</span>"];
        }
        unset($todas);
        $table = [];
        foreach($permisos as $u) {
            $t = [];
            foreach($u as $colHeader => $d) {
                if(empty($d)) {
                    $t[$colHeader] = "<td class='cen'>";
                    continue;
                }
                if(!is_array($d)) {
                    $t[$colHeader] = "<td class='cen'>$d";
                    continue;
                }
                asort($d);
                if($colHeader === 'Registra<br>Notas<br>En' || $colHeader === 'Verfica<br>Notas<br>En') {
                    // marca en rojo las bodegas que esten ambos arrays
                    $registra = array_combine( $u['Registra<br>Notas<br>En'], $u['Registra<br>Notas<br>En']);
                    $verifica = array_combine($u['Verfica<br>Notas<br>En'], $u['Verfica<br>Notas<br>En']);
                    $ambos = array_intersect($registra, $verifica);
                    foreach($ambos as $k) {
                        $registra[$k] = "<span style='color:red'>$k</span>";
                        $verifica[$k] = "<span style='color:red'>$k</span>";
                    }
                    if($colHeader === 'Verfica<br>Notas<br>En')
                        $d = $verifica;
                    else
                        $d = $registra;
                }
                $t[$colHeader] = "<td class='izq'>
                <ol style='margin-top:0;margin-bottom:0;padding-top:0;padding-bottom:0;color:blue;'><li>" .
                    implode("<li>", $d) . "</li></ol>";

            }
            if(!isset($th))
                $th = implode("<th>", array_keys($t));
            $table[] = implode("\r\n\t",$t);
        }
        if(!isset($th))
            $th = '';
        return "<table id='pb_permiso_usuario_tabla' class='tablaPB' style='width:98%'>
            <thead>
                <tr>
                    <th>
                    <th colspan='10' style='border-right:1px black double!important;background-color:mintcream'>
                    
                    <input type='text' value='' placeholder='🔍' style='visibility: hidden' class='noprint' onblur='permisoBodega.usuarioPermisoBusca(this)' name='pbubusca' id='pbubusca'>
                    
                    En Todas las Bodegas</th>
                    <th colspan='6' style='border-left:1px black double!important'>En las bodegas</th>
                <tr><th>$th</thead>
            <tbody><tr>" . implode("<tr>", $table) . "</tbody></table>";

    }

/////
    // function lugaresVerificanNotas(): bool|array {return ia_sqlKeyValue("SELECT bodega_grupo_verificador_id, grupo_verficiador FROM bodega_grupo_verificador ORDER BY 2");}


////
    public static function setSupervisor(int|string|array $user_ids):bool {
        $method = __METHOD__;
        if(empty($user_ids))
            $user_ids = [0];
        $builder = new IacSqlBuilder();
        $in = $builder->arrayToSqlIn(is_array($user_ids) ? $user_ids : [$user_ids]);
        $sql = [
            "UPDATE /*$method*/ iac_usr SET puede_supervisar_bodega='No' WHERE puede_supervisar_bodega='Si'  AND iac_usr_id NOT IN $in",
            "UPDATE /*$method*/ iac_usr SET puede_supervisar_bodega='Si' WHERE iac_usr_id  IN $in",
        ];
        return !ia_transaction($sql);
    }

    public static function set_consultan_verificacion($bodega_id, $user_ids):bool {
        $method = __METHOD__;
        if(empty($user_ids))
            $user_ids = [0];
        $bodega = strit($bodega_id);
        $builder = new IacSqlBuilder();
        $in = $builder->arrayToSqlIn(is_array($user_ids) ? $user_ids : [$user_ids]);
        $sql = [
            "UPDATE /*$method*/ permiso_bodega SET puede_verificar_movimientos='Nada' WHERE puede_verificar_movimientos='R/O' AND bodega_id=$bodega AND iac_usr_id NOT IN $in",
            "UPDATE /*$method*/ permiso_bodega SET puede_verificar_movimientos='R/O' WHERE puede_verificar_movimientos='Nada' AND bodega_id=$bodega AND iac_usr_id  IN $in",
        ];
        return !ia_transaction($sql);
    }

    public static function set_puede_editar_campos_cash_nota_bodega(int|string|array $user_ids):bool {
      $method = __METHOD__;
      if(empty($user_ids))
          $user_ids = [0];
      $builder = new IacSqlBuilder();
      $in = $builder->arrayToSqlIn(is_array($user_ids) ? $user_ids : [$user_ids]);
      $sql = [
          "UPDATE /*$method*/ iac_usr SET puede_editar_campos_cash_nota_bodega = 'No' WHERE iac_usr_id>1",
          "UPDATE /*$method*/ iac_usr SET puede_editar_campos_cash_nota_bodega = 'Si' WHERE iac_usr_id IN $in",
      ];
      return !ia_transaction($sql);
  }

    public static function setOrigenHuerfano(int|string|array $user_ids):bool {
      $method = __METHOD__;
      if(empty($user_ids))
        $user_ids = [0];
      $builder = new IacSqlBuilder();
      $in = $builder->arrayToSqlIn(is_array($user_ids) ? $user_ids : [$user_ids]);
      $sql = [
        "UPDATE /*$method*/ iac_usr SET puede_bodega_destinos_especiales='No' WHERE puede_bodega_destinos_especiales='Si'  AND iac_usr_id NOT IN $in",
        "UPDATE /*$method*/ iac_usr SET puede_bodega_destinos_especiales='Si' WHERE iac_usr_id  IN $in",
      ];

      return !ia_transaction($sql);
    }

    public static function setRegistraTodo(int|string|array $user_ids):bool {
        $method = __METHOD__;
        if(empty($user_ids))
            $user_ids = [0];
        $builder = new IacSqlBuilder();
        $puedenLeer = $builder->arrayToSqlIn(
            ia_sqlKeyValue("SELECT iac_usr_id,iac_usr_id FROM iac_usr WHERE puede_solo_consultar_bodegas='Si' AND iac_usr_id>1 AND puede_supervisar_bodega='No'")
        );


        $eranRegistran = $builder->arrayToSqlIn(ia_sqlKeyValue("SELECT iac_usr_id,iac_usr_id FROM iac_usr WHERE puede_registrar_todas_bodegas='Si' AND iac_usr_id>1 AND puede_supervisar_bodega='No'"));
        $inRegistran = $builder->arrayToSqlIn(is_array($user_ids) ? $user_ids : [$user_ids]);
        $sql = [
            "UPDATE /*$method*/ permiso_bodega SET puede_movimientos=IF(puede_movimientos='R/W', 'Nada',puede_movimientos) WHERE iac_usr_id IN $eranRegistran",
            "UPDATE /*$method*/ permiso_bodega SET puede_movimientos=IF(puede_movimientos='Nada', 'R/O',puede_movimientos) WHERE iac_usr_id IN $puedenLeer",

            "UPDATE /*$method*/ iac_usr SET puede_registrar_todas_bodegas='No' WHERE puede_registrar_todas_bodegas='Si' AND iac_usr_id>1 AND puede_supervisar_bodega='No'  AND iac_usr_id NOT IN $inRegistran",
            "UPDATE /*$method*/ iac_usr SET puede_registrar_todas_bodegas='Si' WHERE iac_usr_id IN $inRegistran OR iac_usr_id=1 OR puede_supervisar_bodega='Si'",

            "INSERT INTO /*$method*/ permiso_bodega(bodega_id,iac_usr_id,puede_movimientos)
          (SELECT b.bodega_id, u.iac_usr_id, 'R/W'
          FROM bodega b JOIN iac_usr u
          WHERE b.activo='Si' AND u.iac_usr_id IN $inRegistran)
          ON DUPLICATE KEY UPDATE puede_movimientos='R/W'
        ",
        ];
        return !ia_transaction($sql);

    }

    public static function setConsultaTodo(int|string|array $user_ids):bool {
      $method = __METHOD__;
      if(empty($user_ids))
        $user_ids = [0];
      $builder = new IacSqlBuilder();
      $eran = $builder->arrayToSqlIn(ia_sqlVector("SELECT iac_usr_id FROM iac_usr WHERE puede_solo_consultar_bodegas='Si' AND iac_usr_id>1 AND puede_supervisar_bodega='No'"));
      $in = $builder->arrayToSqlIn(is_array($user_ids) ? $user_ids : [$user_ids]);
      $sql = [
          "UPDATE /*$method*/ permiso_bodega SET puede_movimientos=IF(puede_movimientos='R/O', 'Nada',puede_movimientos) WHERE iac_usr_id IN $eran",
        "UPDATE /*$method*/ iac_usr SET puede_solo_consultar_bodegas='No' WHERE puede_solo_consultar_bodegas='Si' AND iac_usr_id>1 AND puede_supervisar_bodega='No'  AND iac_usr_id NOT IN $in",
        "UPDATE /*$method*/ iac_usr SET puede_solo_consultar_bodegas='Si' WHERE iac_usr_id IN $in OR iac_usr_id=1 OR puede_supervisar_bodega='Si'",
        "INSERT INTO /*$method*/ permiso_bodega(bodega_id,iac_usr_id,puede_movimientos)
          (SELECT b.bodega_id, u.iac_usr_id, 'R/O'
          FROM bodega b JOIN iac_usr u
          WHERE b.activo='Si' AND u.iac_usr_id IN $in)
          ON DUPLICATE KEY UPDATE puede_movimientos=IF(puede_movimientos='Nada', 'R/O',puede_movimientos)
        ",
      ];
      return !ia_transaction($sql);
    }

    public static function setConsultaExistencia(int|string|array $user_ids):bool {
      $method = __METHOD__;
      if(empty($user_ids))
        $user_ids = [0];
      $builder = new IacSqlBuilder();
      $in = $builder->arrayToSqlIn(is_array($user_ids) ? $user_ids : [$user_ids]);
      $sql = [
        "UPDATE /*$method*/ iac_usr SET puede_consultar_existencia='No' WHERE puede_consultar_existencia='Si'  AND iac_usr_id NOT IN $in",
        "UPDATE /*$method*/ iac_usr SET puede_consultar_existencia='Si' WHERE iac_usr_id  IN $in",
      ];
      return !ia_transaction($sql);
    }

    public static function setConsultaTrasladosMatch(int|string|array $user_ids):bool {
      $method = __METHOD__;
      if(empty($user_ids))
        $user_ids = [0];
      $builder = new IacSqlBuilder();

      $in = $builder->arrayToSqlIn(is_array($user_ids) ? $user_ids : [$user_ids]);
      $sql = [

        "UPDATE /*$method*/ iac_usr SET puede_ver_traslados_match='No' WHERE puede_ver_traslados_match='Si' AND iac_usr_id>1   AND iac_usr_id NOT IN $in",
        "UPDATE /*$method*/ iac_usr SET puede_ver_traslados_match='Si' WHERE iac_usr_id  IN $in",
      ];
      return !ia_transaction($sql);
    }

    public static function setConsultaTodaslasSalidasaTiendas(int|string|array $user_ids):bool {
      $method = __METHOD__;
      if(empty($user_ids))
        $user_ids = [0];
      $builder = new IacSqlBuilder();

      $eran = $builder->arrayToSqlIn(ia_sqlVector("SELECT iac_usr_id FROM iac_usr WHERE puede_ver_traslados ='Si' AND iac_usr_id>1"));
      $in = $builder->arrayToSqlIn(is_array($user_ids) ? $user_ids : [$user_ids]);
      $sql = [

        "UPDATE /*$method*/ iac_usr SET puede_ver_traslados='No' WHERE puede_ver_traslados='Si'  AND iac_usr_id NOT IN $in",
        "UPDATE /*$method*/ iac_usr SET puede_ver_traslados='Si' WHERE iac_usr_id  IN $in",
        "DELETE /*$method*/ FROM permiso_bodega_consulta_salida_tienda WHERE iac_usr_id IN $eran",
        "INSERT /*$method*/ INTO permiso_bodega_consulta_salida_tienda(iac_usr_id,origen_bodega_id,tienda_id)
                (SELECT iac_usr_id, ob.origen_bodega_id, ob.tienda_id
                  FROM tienda t JOIN origen_bodega ob on t.tienda_id = ob.tienda_id  
                  JOIN iac_usr 
                  WHERE t.vale='Active' AND iac_usr_id IN $in AND ob.es='Tienda'
               ) ON DUPLICATE KEY UPDATE tienda_id=VALUES(tienda_id)"
      ];

      return !ia_transaction($sql);
    }

    public static function set_puede_autorizar_notas_ultimo_movimiento(int|string|array $user_ids):bool {
      $method = __METHOD__;
      if(empty($user_ids))
        $user_ids = [0];
      $builder = new IacSqlBuilder();
      $in = $builder->arrayToSqlIn(is_array($user_ids) ? $user_ids : [$user_ids]);
      $sql = [
        "UPDATE /*$method*/ iac_usr SET puede_autorizar_notas_ultimo_movimiento='No' WHERE puede_autorizar_notas_ultimo_movimiento='Si'  AND iac_usr_id NOT IN $in",
        "UPDATE /*$method*/ iac_usr SET puede_autorizar_notas_ultimo_movimiento='Si' WHERE iac_usr_id  IN $in",
      ];
      return !ia_transaction($sql);
    }

    public static function set_puede_hacer_reset_producto_color(int|string|array $user_ids):bool {
      $method = __METHOD__;
      if(empty($user_ids))
        $user_ids = [0];
      $builder = new IacSqlBuilder();
      $in = $builder->arrayToSqlIn(is_array($user_ids) ? $user_ids : [$user_ids]);
      $sql = [
        "UPDATE /*$method*/ iac_usr SET puede_hacer_reset_producto_color='No' WHERE puede_hacer_reset_producto_color='Si'  AND iac_usr_id NOT IN $in",
        "UPDATE /*$method*/ iac_usr SET puede_hacer_reset_producto_color='Si' WHERE iac_usr_id  IN $in",
      ];
      return !ia_transaction($sql);
    }

      public static function set_puede_hacer_ajuste_producto_color(int|string|array $user_ids):bool {
          $method = __METHOD__;
          if(empty($user_ids))
              $user_ids = [0];
          $builder = new IacSqlBuilder();
          $in = $builder->arrayToSqlIn(is_array($user_ids) ? $user_ids : [$user_ids]);
          $sql = [
              "UPDATE /*$method*/ iac_usr SET puede_hacer_ajuste_producto_color='No' WHERE puede_hacer_ajuste_producto_color='Si'  AND iac_usr_id NOT IN $in",
              "UPDATE /*$method*/ iac_usr SET puede_hacer_ajuste_producto_color='Si' WHERE iac_usr_id  IN $in",
          ];
          return !ia_transaction($sql);
      }

    public static function set_puede_hacer_reset_inconsistencias(int|string|array $user_ids):bool {
      $method = __METHOD__;
      if(empty($user_ids))
        $user_ids = [0];
      $builder = new IacSqlBuilder();
      $in = $builder->arrayToSqlIn(is_array($user_ids) ? $user_ids : [$user_ids]);
      $sql = [
        "UPDATE /*$method*/ iac_usr SET puede_hacer_reset_inconsistencias='No' WHERE puede_hacer_reset_inconsistencias='Si'  AND iac_usr_id NOT IN $in",
        "UPDATE /*$method*/ iac_usr SET puede_hacer_reset_inconsistencias='Si' WHERE iac_usr_id  IN $in",
      ];
      return !ia_transaction($sql);
    }

    public static function set_notificar_nuevas_cartas_porte(int|string|array $user_ids):bool {
      $method = __METHOD__;
      if(empty($user_ids))
        $user_ids = [0];
      $builder = new IacSqlBuilder();
      $in = $builder->arrayToSqlIn(is_array($user_ids) ? $user_ids : [$user_ids]);
      $sql = [
        "UPDATE /*$method*/ iac_usr SET notificar_nuevas_cartas_porte='No' WHERE notificar_nuevas_cartas_porte='Si'  AND iac_usr_id NOT IN $in",
        "UPDATE /*$method*/ iac_usr SET notificar_nuevas_cartas_porte='Si' WHERE iac_usr_id  IN $in",
      ];
      return !ia_transaction($sql);
    }

    public static function setEncargado(int|string|array $user_ids, string $bodega_id):bool {
      $method = __METHOD__;
        $builder = new IacSqlBuilder();
        $in = $builder->arrayToSqlIn(is_array($user_ids) ? $user_ids : [$user_ids]);
      $sql = [
          "UPDATE /*$method*/ permiso_bodega SET es_encargado = 'No' WHERE bodega_id=" . strit($bodega_id),
          "INSERT INTO /*$method*/ permiso_bodega(bodega_id,iac_usr_id,es_encargado)
          (SELECT b.bodega_id, u.iac_usr_id, 'Si'
          FROM bodega b JOIN iac_usr u
          WHERE b.activo='Si' AND b.bodega_id=" . strit($bodega_id) . " AND u.iac_usr_id IN $in )
          ON DUPLICATE KEY UPDATE es_encargado='Si'
        ",
      ];

      return !ia_transaction($sql);
    }

    public static function setNotasPueden(int|string|array $user_hacer_ids, int|string|array $user_consultan_ids, string $bodega_id):bool {
      $method = __METHOD__;
      $bodega = strit($bodega_id);
      $builder = new IacSqlBuilder();

      if(!empty($user_consultan_ids))
        $quedan =  is_array($user_consultan_ids) ? $user_consultan_ids : [$user_consultan_ids];
      else
        $quedan = [];
      if(!empty($user_hacer_ids)) {
        $quedan = array_merge($quedan, $user_hacer_ids, is_array($user_hacer_ids) ? $user_hacer_ids : [$user_hacer_ids]);
      }
      if(empty($quedan))
        $sql[] = "UPDATE /*$method*/ permiso_bodega SET puede_movimientos='Nada' WHERE bodega_id=" . strit($bodega_id);
      else {
        $in =  $builder->arrayToSqlIn($quedan);
        $sql[] = "UPDATE /*$method*/ permiso_bodega SET puede_movimientos='Nada' WHERE iac_usr_id NOT IN $in AND bodega_id=" . strit($bodega_id);
      }

      if(!empty($user_consultan_ids)) {
        $ro = $builder->arrayToSqlIn(is_array($user_consultan_ids) ? $user_consultan_ids : [$user_consultan_ids]);
        $sql[] = "INSERT INTO /*$method*/ permiso_bodega(bodega_id,iac_usr_id,puede_movimientos) 
            (SELECT $bodega, iac_usr_id, 'R/O' FROM iac_usr WHERE iac_usr_id IN $ro)
            ON DUPLICATE KEY UPDATE puede_movimientos='R/O' ";
      }
      if(!empty($user_hacer_ids)) {
        $rw = $builder->arrayToSqlIn(is_array($user_hacer_ids) ? $user_hacer_ids : [$user_hacer_ids]);
        $sql[] = "INSERT INTO /*$method*/ permiso_bodega(bodega_id,iac_usr_id,puede_movimientos) 
            (SELECT $bodega, iac_usr_id, 'R/W' FROM iac_usr WHERE iac_usr_id IN $rw)
            ON DUPLICATE KEY UPDATE puede_movimientos='R/W' ";
      }
      $ok = !ia_transaction($sql);
      self::setPuedenConsultarTodas();
      self::setPuedenRegistrarTodas();
      return $ok;
    }

    protected static function setPuedenConsultarTodas() {
        $method = __METHOD__;
        $builder = new IacSqlBuilder();
        $puedenLeerTodasLasNotas = self::puedenConsultarNotasEnTodas();
        $in = $builder->arrayToSqlIn($puedenLeerTodasLasNotas);
        $sql = [
            "UPDATE /*$method*/ iac_usr SET puede_solo_consultar_bodegas='No' WHERE puede_solo_consultar_bodegas='Si' AND iac_usr_id NOT IN $in",
            "UPDATE /*$method*/ iac_usr SET puede_solo_consultar_bodegas='Si' WHERE iac_usr_id  IN $in",
        ];
        ia_transaction($sql);
    }

    public static function puedenConsultarNotasEnTodas():array {
        $method = __METHOD__;
        $todoSql = "SELECT /*$method*/ pb.iac_usr_id, count(*) as num_bodegas
            FROM permiso_bodega pb JOIN bodega b ON b.bodega_id = pb.bodega_id JOIN iac_usr iu ON pb.iac_usr_id = iu.iac_usr_id
            WHERE (pb.puede_movimientos IN ('R/W', 'R/O') OR iu.puede_supervisar_bodega = 'Si' ) AND b.activo='Si' AND pb.iac_usr_id>1
            GROUP BY 1
            HAVING num_bodegas = (select count(*) from bodega WHERE activo='Si')
            ORDER BY 1";
        return array_keys( ia_sqlKeyValue($todoSql));
    }

    protected static function setPuedenRegistrarTodas() {
        $method = __METHOD__;
        $builder = new IacSqlBuilder();
        $puedenRegistrarTodasLasNotas = self::puedenRegistrarNotasEnTodas();
        $in = $builder->arrayToSqlIn($puedenRegistrarTodasLasNotas);
        $sql = [
            "UPDATE /*$method*/ iac_usr SET puede_registrar_todas_bodegas='No' WHERE puede_registrar_todas_bodegas='Si' AND iac_usr_id NOT IN $in",
            "UPDATE /*$method*/ iac_usr SET puede_registrar_todas_bodegas='Si' WHERE iac_usr_id  IN $in",
        ];
        ia_transaction($sql);
    }

    public static function puedenRegistrarNotasEnTodas():array {
        $method = __METHOD__;
        $todoSql = "SELECT /*$method*/ pb.iac_usr_id, count(*) as num_bodegas
            FROM permiso_bodega pb JOIN bodega b ON b.bodega_id = pb.bodega_id JOIN iac_usr iu ON pb.iac_usr_id = iu.iac_usr_id
            WHERE (pb.puede_movimientos='R/W' OR iu.puede_supervisar_bodega = 'Si' ) AND b.activo='Si' AND pb.iac_usr_id>1
            GROUP BY 1
            HAVING num_bodegas = (select count(*) from bodega WHERE activo='Si')
            ORDER BY 1";
        return array_keys( ia_sqlKeyValue($todoSql));
    }

    /**
     * Regresa ['origen_bodega_id',..] para $usuario_id o el usuario actual en null
     *
     * @param int|string|null $usuario_id
     * @return array ['origen_bodega_id',..]
     */
    public static function getConsultaSalidasTienda_origen_id(int|string|null $usuario_id = null):array {
        if(empty($usuario_id))
            $usuario_id = $_SESSION['usuario_id'] ?? '0';
        $method = __METHOD__;
        if(ia_singleread("SELECT /*$method*/ puede_ver_traslados FROM iac_usr WHERE iac_usr_id=".strit($usuario_id)) === 'Si' ) {
            $in = ia_sqlVector("SELECT /*$method*/ origen_bodega_id FROM origen_bodega WHERE es = 'Tienda'");
            return empty($in) ? [] : $in;
        }
        $query = "SELECT /*$method*/ ob.origen_bodega_id
                    FROM permiso_bodega_consulta_salida_tienda pt
                    JOIN origen_bodega ob on pt.origen_bodega_id = ob.origen_bodega_id AND ob.vale_bodega_salida='Si'  AND ob.activo='Si'
                    WHERE pt.puede_editar_campos_cash <> 'Nada' AND iac_usr_id = '$usuario_id'";
        $in = ia_sqlVector($query);
        return empty($in) ? [] : $in;
    }

    /**
     * Regresa IN('origen_bodega_id',..) para $usuario_id o el usuario actual en null
     *
     * @param int|string|null $usuario_id
     * @return string origen_id IN('origen_bodega_id',..)
     */
    public static function getConsultaSalidasTienda_origen_id_In(int|string|null $usuario_id = null):string {
        $in = self::getConsultaSalidasTienda_origen_id($usuario_id);
        if(empty($in))
            return "('\t')";
        return "(" . parseClauseIn($in) . ")";
    }

    public static function setConsultanSalidasTienda(string $origen_bodega_id,string|int $tienda_id, array|string $users):bool {
        if(!is_array($users))
            $users = [$users];
        if(empty($origen_bodega_id) || strlen($origen_bodega_id) !== 32 || empty($tienda_id) || !is_numeric($tienda_id))
            return false;
        $method = __METHOD__;
        $origen_bodega_id = strit($origen_bodega_id);
        $tienda_id = strit($tienda_id);

        $select_favoritos = "SELECT iac_usr_id FROM permiso_bodega_consulta_salida_tienda WHERE mi_favorita = 'Si' AND origen_bodega_id=$origen_bodega_id";
        $favoritos = ia_sqlVector($select_favoritos);

        $sql = [
            "DELETE /*$method*/ FROM permiso_bodega_consulta_salida_tienda WHERE origen_bodega_id=$origen_bodega_id",
        ];
        if(!empty($users)) {
            $in = parseClauseIn($users);
          $sql[] = "INSERT /*$method*/ INTO permiso_bodega_consulta_salida_tienda(iac_usr_id,origen_bodega_id,tienda_id)
                (SELECT iac_usr_id, $origen_bodega_id, $tienda_id FROM iac_usr WHERE iac_usr_id IN ($in))";
        }

        if (!empty($favoritos)) {
            $favoritos = parseClauseIn($favoritos);
            $sql[]="UPDATE /*$method*/ permiso_bodega_consulta_salida_tienda SET mi_favorita='Si' WHERE iac_usr_id IN($favoritos) AND origen_bodega_id=$origen_bodega_id";
        }
        return !ia_transaction($sql);
    }
    public static function setTiendaPreferida(string $origen_bodega_id,string|int $tienda_id, string $user_id, $value = 'Si')
    {
        if(empty($origen_bodega_id) || strlen($origen_bodega_id) !== 32 || empty($tienda_id) || !is_numeric($tienda_id))
            return false;

        $method = __METHOD__;
        $origen_bodega_id = strit($origen_bodega_id);
        $tienda_id = strit($tienda_id);

        $ya_existe = ia_singleread("SELECT 1 FROM permiso_bodega_consulta_salida_tienda WHERE iac_usr_id=$user_id AND origen_bodega_id=$origen_bodega_id AND tienda_id=$tienda_id");

        // $sql = ["UPDATE /*$method*/ permiso_bodega_consulta_salida_tienda SET mi_favorita = 'No' WHERE iac_usr_id=$user_id"];
        $sql = [];

        if (empty($ya_existe))
            $sql[] ="INSERT /*$method*/ INTO permiso_bodega_consulta_salida_tienda(iac_usr_id,origen_bodega_id,tienda_id)
                (SELECT iac_usr_id, $origen_bodega_id, $tienda_id FROM iac_usr WHERE iac_usr_id = $user_id)";

        if ($value === 'Si')
            $sql[] = "UPDATE /*$method*/ permiso_bodega_consulta_salida_tienda SET mi_favorita = '$value' WHERE iac_usr_id=$user_id AND origen_bodega_id=$origen_bodega_id AND tienda_id=$tienda_id";

        return !ia_transaction($sql);
    }

    public static function tablePermisosBodega(){
        global $gPermisoClick;
        $method = __METHOD__;
        $tiendas = ia_sqlArray(
            "SELECT /*$method*/ bodega_id, bodega, grupo, color, CONCAT('<i style=\"font-size:0.9em;font-weight:100\">',grupo,'</i> ', bodega) as label 
                                FROM bodega WHERE activo='Si' ORDER BY grupo = '', grupo, bodega", 'bodega_id');
        $table = [];
        foreach($tiendas as $bodega_id => $bodega)
            $table[$bodega_id]  = [
              'tienda' => $bodega['label'],
              'R/O' => '',
              'R/W' => '',
              'Nada' => '',
              'Cash' => ''
            ];

        $usuarios = ia_sqlArrayIndx("SELECT /*$method notas_por_bodega*/ 
                        u.iac_usr_id, 
                        u.nick,
                        IFNULL(pb.puede_movimientos, 'Nada') as puede_editar_campos_cash,
                        pb.bodega_id
                    FROM iac_usr u
                        LEFT OUTER JOIN permiso_bodega pb on u.iac_usr_id = pb.iac_usr_id
                    WHERE u.iac_usr_id > 1 AND u.usuario_tipo_rony = 'No' AND u.vale = 'Active'
                    ORDER BY u.nick"
        );


        $html = '';
        $not_allowed = ["74867af2fe60a5bf11ec70bd9c7dec0e", "74867af2fe60ad6b11ec6cb499de5099"];
        foreach ($usuarios as $usuario) {
            $tienda_id = $usuario['bodega_id'];
            $permiso = $usuario['puede_editar_campos_cash'];
            $nick = $usuario['nick'];

            if(in_array($tienda_id, $not_allowed))
                continue;
            if(!array_key_exists($tienda_id, $tiendas)) {
                continue;
            }
            if (!isset($table[$tienda_id])) {
                // Si la tienda no existe en la tabla, la agregamos
                $table[$tienda_id] = [
                    'tienda' => $tiendas[$tienda_id]['label'],
                    'R/O' => '',
                    'R/W' => '',
                    'Nada' => '',
                    'Cash' => '',
                ];
            }

            if (isset($table[$tienda_id][$permiso])) {
                $table[$tienda_id][$permiso] .= empty($table[$tienda_id][$permiso]) ? $nick : ", " . $nick;
            }
        }

        /**
         * Si es una tienda sin registros la agregamos
         *
         * */
        foreach($tiendas as $tienda) {
            if (!isset($table[$tienda['bodega_id']])) {
                $table[$tienda_id] = [
                    'tienda' => $tiendas[$tienda_id]['clave'],
                    'R/O' => '',
                    'R/W' => '',
                    'Nada' => '',
                    'CASH' => '',
                ];
            }
        }

        $users_todas = NotaFormHelper::getUsersPuedeTodasBodega();

        $result_RO = '<span class="list-pueden-all">';
        $result_RW = '<span class="list-pueden-all">';
        $result_Cash = '<span class="list-pueden-all">';
        if(isset($users_todas['R/O'])){
            $result_RO .= implode(", ", $users_todas['R/O']);
        }
        if(isset($users_todas['R/W'])) {
            $result_RW .= implode(", ", $users_todas['R/W']);
        }
        if(isset($users_todas['Cash'])) {
            $result_Cash .= implode(", ", $users_todas['Cash']);
        }

        $result_RO .= '</span>';
        $result_RW .= '</span>';
        $result_Cash .= '</span>';

        // Imprimir la tabla
        $html .= '<div class="toolbar_exporter" id="toolBar_exporter">
                   <span title="Imprimir" style="font-size: 1em;" class="ui-icon ui-icon-print-b noprint pointer" onclick="exporter.print(\'#permisos-cashs-bodega\')"></span>
                   <span title="PDF" style="font-size: 1em;" class="ui-icon ui-icon-file-pdf noprint pointer" onclick="exporter.pdf_table(\'#permisos-cashs-bodega\', \'\',\'\')"></span>
                   <span title="Guardar como imagen" style="font-size: 1em;" class="ui-icon ui-icon-file-image noprint pointer" onclick="exporter.imageSave(\'#permisos-cashs-bodega\', \'\');"></span>
               </div>';

        $html .= "<table border='1' id='permisos-cashs-bodega' class='laTabla'>";
        $html .= "<caption class='caption-informativo'> <span style='font-weight:700;font-size:2em'> Permisos de <span class='color-blue'>Notas por Bodega</span></span><br>";
        $html .= "Permisos para registrar, editar campos cash o consultar notas por bodega <br><span class='camption-resalt'>(crear notas, editar campos cash o solo lectura)</span>, <br><span class='color-blue'>Son los principales permisos de bodega</span></caption>";
        $html .= "<thead>
                   <tr>
                       <th>".$gPermisoClick('notas_todas_bodegas', 'Todas las Bodegas', true)."</th>
                       <th style='text-align: center;'>Registrar Notas: <hr> $result_RW</th>
                       <th style='text-align: center;'>Editar Campos Cash<br>en Traslados: <hr> $result_Cash</th>
                       <th style='text-align: center;'>Read Only Notas: <hr> $result_RO </th>
                   </tr>
                 </thead><tbody>";
        foreach ($table as $tienda_id => $data) {
            $html .= "<tr>";
            $html .= "<td>" .  $gPermisoClick('notas_por_bodega' , $data['tienda'], true,
                    json_encode(['bodega_id'=>$tienda_id])) . "</td>";
            $html .= "<td>" . $data['R/W'] . "</td>";
            $html .= "<td>" . $data['Cash'] . "</td>";
            $html .= "<td>" . $data['R/O'] . "</td>";
            $html .= "</tr>";
        }
        $html .= "</tbody></table>";
        return $html;

    }

    public static function tablePermisosCash(){
        global $gPermisoClick;
        $method = __METHOD__;
        $table = [];
        $not_allowed = ['11ec6cb303b9cff4ad6b74867af2fe60'];

        $tiendas = ia_sqlArray(
            "SELECT /*$method*/ ob.origen_bodega_id, ob.clave, ob.tienda_id 
            FROM origen_bodega ob
            WHERE ob.es='Tienda' AND ob.vale_bodega_salida='Si' AND ob.activo='Si'
            ORDER BY 2",
            "origen_bodega_id");
        foreach ($tiendas as $origen_bodega_id => $tienda) {
            if(in_array($origen_bodega_id, $not_allowed))
                continue;
            $table[$origen_bodega_id] = [
              'tienda' => $tienda['clave'],
              'R/O' => '',
              'R/W' => '',
              'Nada' => '',
              'Cash' => '',
            ];
        }
        $select = "SELECT /*$method*/  pt.origen_bodega_id, iu.nick, pt.mi_favorita, pt.iac_usr_id, pt.puede_editar_campos_cash
                    FROM permiso_bodega_consulta_salida_tienda pt
                    JOIN iac_usr iu on pt.iac_usr_id = iu.iac_usr_id";

        $usuarios = ia_sqlArrayIndx($select);


        $html = '';


        foreach ($usuarios as $usuario) {
            $tienda_id = $usuario['origen_bodega_id'];
            $permiso = $usuario['puede_editar_campos_cash'];
            $nick = $usuario['nick'];

            if(in_array($tienda_id, $not_allowed))
                continue;

            if (!isset($table[$tienda_id])) {
                // Si la tienda no existe en la tabla, la agregamos
                $table[$tienda_id] = [
                    'tienda' => $tiendas[$tienda_id]['clave'],
                    'R/O' => '',
                    'R/W' => '',
                    'Nada' => '',
                ];
            }

            if (isset($table[$tienda_id][$permiso])) {
                $table[$tienda_id][$permiso] .= empty($table[$tienda_id][$permiso]) ? $nick : ", " . $nick;
            }
        }

        /**
         * Si es una tienda sin registros la agregamos
         *
         */
        foreach($tiendas as $tienda) {
            if (!isset($table[$tienda['origen_bodega_id']])) {
                $table[$tienda_id] = [
                    'tienda' => $tiendas[$tienda_id]['clave'],
                    'R/O' => '',
                    'R/W' => '',
                    'Nada' => '',
                ];
            }
        }

        $users_todas = NotaFormHelper::getUsersPuedeTodasPermisosCash();


        $result_RO = '<span class="list-pueden-all">';
        $result_RW = '<span class="list-pueden-all">';
        if(isset($users_todas['R/O'])){
            $result_RO .= implode(", ", $users_todas['R/O']);
        }
        if(isset($users_todas['R/W'])) {
            $result_RW .= implode(", ", $users_todas['R/W']);
        }

        $result_RO .= '</span>';
        $result_RW .= '</span>';

        // Imprimir la tabla
        $html .= '<div class="toolbar_exporter" id="toolBar_exporter">
                    <span title="Imprimir" style="font-size: 1em;" class="ui-icon ui-icon-print-b noprint pointer" onclick="exporter.print(\'#permisos-cashs\')"></span>
                    <span title="PDF" style="font-size: 1em;" class="ui-icon ui-icon-file-pdf noprint pointer" onclick="exporter.pdf_table(\'#permisos-cashs\', \'\', \'\')"></span>
                    <span title="Guardar como imagen" style="font-size: 1em;" class="ui-icon ui-icon-file-image noprint pointer" onclick="exporter.imageSave(\'#permisos-cashs\', \'\');"></span>
                </div>';

        $html .= "<table border='1' id='permisos-cashs' class='laTabla'>";
        $html .= "<caption class='caption-informativo'><span style='font-weight:700;font-size:2em'>Consultar o Editar <span class='color-blue'>Campos Cash por Tiendas</span> </span>";
        $html .= "Permisos para consultar o editar por tienda los campos cash <span class='camption-resalt'>(Tipo venta, Numero de tipo venta, Quantity de tipo de Venta, Número de compra, Chofer, Clientes, Ayudantes y Pedido por)</span>, <br><span class='color-blue'>Son secundarios a permiso de registrar por bodega</span></caption>";
        $html .= "<thead>
                    <tr>
                        <th>".$gPermisoClick('puede_todas_campos_cash', 'Puede Editar en Todas Las Tiendas', true)."</th>
                        <th style='text-align: center;'>Consultar en Tienda R/O: <hr>$result_RO </th>
                        <th style='text-align: center;'>Editar en Tienda R/W: <hr> $result_RW</th>
                    </tr>
                  </thead><tbody>";
        foreach ($table as $tienda_id => $data) {
            $html .= "<tr>";
            $html .= "<td>" .  $gPermisoClick('puede_editar_campos_cash' , $data['tienda'], true,
                           json_encode(['origen_bodega_id'=>$tienda_id, 'tienda_label'=>$data['tienda']])) . "</td>";
            $html .= "<td>" . $data['R/O'] . "</td>";
            $html .= "<td>" . $data['R/W'] . "</td>";
            // $html .= "<td>" . $data['Nada'] . "</td>";
            $html .= "</tr>";
        }
        $html .= "</tbody></table>";
        return $html;

    }


    public static function editaConsultaSalidaTiendas(): string
    {
        $method = __METHOD__;
        $tiendas = ia_sqlArray(
            "SELECT /*$method*/ ob.origen_bodega_id, ob.clave, ob.tienda_id 
            FROM origen_bodega ob
            WHERE ob.es='Tienda' AND ob.vale_bodega_salida='Si' AND ob.activo='Si'",
            "origen_bodega_id");
        $usuarios = ia_sqlSelectMultiKey(
            "SELECT /*$method*/ pt.origen_bodega_id, iu.nick
                FROM permiso_bodega_consulta_salida_tienda pt
                    JOIN origen_bodega ob on pt.origen_bodega_id = ob.origen_bodega_id AND ob.vale_bodega_salida='Si' AND ob.activo='Si'
                    JOIN iac_usr iu on pt.iac_usr_id = iu.iac_usr_id
                WHERE iu.vale='Active'",
            2
        );
        $select = "SELECT pt.origen_bodega_id, iu.nick, pt.mi_favorita, pt.iac_usr_id
                    FROM permiso_bodega_consulta_salida_tienda pt
                    JOIN iac_usr iu on pt.iac_usr_id = iu.iac_usr_id
                    ";
        $usuarios_por_tienda = objetivisa_(ia_sqlArrayIndx($select), 'origen_bodega_id');

        $ids = ia_sqlSelectMultiKey(
            "SELECT /*$method*/ pt.origen_bodega_id, pt.iac_usr_id
                FROM permiso_bodega_consulta_salida_tienda pt
                    JOIN origen_bodega ob on pt.origen_bodega_id = ob.origen_bodega_id AND ob.vale_bodega_salida='Si' AND ob.activo='Si'
                    JOIN iac_usr iu on  pt.iac_usr_id = iu.iac_usr_id
                WHERE iu.vale='Active'",
            2
        );
        $return = "<table class='laTabla'>";
        foreach($tiendas as $origen_id => $d) {
            $users_tienda = $usuarios_por_tienda[$origen_id]??[];
            $user_text = [];
            foreach ($users_tienda as $i => $user) {
                if ($user['mi_favorita'] === 'Si')
                    $user_text[]="<i class='txt_USD' data-userprefertienda='$user[iac_usr_id]'>$user[nick]<sup class='text-danger'> ★</sup></i>";
                else
                    $user_text[]="<i data-userprefertienda='$user[iac_usr_id]'>$user[nick]</i>";
            }
            $users = implode(", ", $user_text);
            // $users = implode(", ", array_keys($usuarios[$origen_id] ?? []));
            $id = json_encode( array_keys($ids[$origen_id] ?? []) , JSON_OPTIONS_FOR_MYSQL);
            $return .= <<< PUEDEN
                <tr><td><button type="button" class="icon_ui_button noprint pb_boton" style="margin-right:1em;cursor:pointer"
                data-ids="$id" id="ConsultanSalidasTienda$origen_id"
                onclick="permisosBodega.set_iac_usr_SiNo(
                    'salidasTienda_$d[origen_bodega_id]_$d[tienda_id]', 
                    'salidasTienda_$origen_id',
                    'setConsultanSalidasTienda', 
                    'Puede consultar salidas de la Tienda $d[clave]',
                    '#ConsultanSalidasTienda$origen_id'
                    )"><span class="ui-icon ui-icon-pencil"></span></button>
                     <th>$d[clave]</th><td><span id='salidasTienda_$origen_id'>$users</span>. 
                     
                     
PUEDEN;
        }
        return $return . "</table>";
    }
  }
