<?php
declare(strict_types=1);
/*
 * Esta clase hace las pruebas para notas
 *
 */

use Iac\inc\sql\IacSqlBuilder;

class PruebaFuego
{
    protected IacSqlBuilder $builderSql;

    public function __construct() {
        $this->builderSql = new IacSqlBuilder();
    }

    public static function UI()
    {
        // return include ('../bodega/componentes/prueba_fuego_ui.phtml');
        include ('../bodega/componentes/prueba_fuego_ui.phtml');
    }

    public static function runTest(array $_config=[])
    {
        self::removeAllTest();
        $config = array_merge([
            'numero_notas' => 5,
            'items_por_nota' => 2,
            'entrada_salida' => 'Entrada',
            'hacer_contra_movimiento' => false
            // 'key' => 'valor'
        ], $_config);

        $bodega = self::createBodegaPrueba();
        if ($bodega === false) {
            global $gIAsql;
            return ['code' => 409, 'status' => false, 'message' => 'No se pudo crear la bodega de prueba', 'error' => $gIAsql['error']??$gIAsql['err']];
        }

        $catalogos = self::getCatalogos();
        $productos = $catalogos['productos'] ?? [];
        $colores = $catalogos['colores'] ?? [];
        $origenes = $catalogos['origen_destino'] ?? [];

        unset($origenes[$bodega['origen_bodega_id']]);

        $do_Class = false;
        include_once dirname(__DIR__).'/backoffice/ajax/movimientos_bodega_acciones.php';
        $movimientos = new MovimientosBodega(['accion' => 'nuevaNota', 'execute' => false]);

        $response = [];

        $fail = false;
        $hacer_contra_movimiento = filter_var($config['hacer_contra_movimiento'], FILTER_VALIDATE_BOOLEAN);

        for ($i = 0; $i<$config['numero_notas']; $i++) {
            $entrada_salida = $config['entrada_salida'];
            $origen_destino_id = array_rand($origenes);
            $origen_destino = $origenes[$origen_destino_id];
            $nota = [
                'nota_bodega_id' => ia_guid(),
                'numero' => NotaBodega::getSiguienteNumero($bodega['bodega_id']),
                'bodega_id' => $bodega['bodega_id'],
                'entrada_salida' => $entrada_salida,
                'fecha' => date('Y-m-d'),
                'origen_id' => $origen_destino_id,
                'remarks' => '<b>NOTA DE PRUEBA</b>',
                'producto_general_id' => array_rand($productos),
                'contra_nota_bodega_id' => '0_0',
                'para_quien' => 'pruebas_XXXX'
            ];
            if (strcasecmp($origen_destino['es'], 'TIENDA')===0) {
                $nota['tipo_nota'] = 'PIÑA';
            }
            $items = [];
            for ($j=0;$j<$config['items_por_nota'];$j++) {
                $color = $colores[array_rand($colores)];
                $items[] = [
                    'color_label' => $color['color'],
                    'color_id' => $color['color_id'],
                    'rollos' => random_int(5, 20),
                    'quantity' => number_format((float)rand(5, 20), 2, '.', '')
                ];
            }
            $movimientos->response = [];
            $movimientos->nuevaNota_($nota, $items);
            $response[] = $movimientos->response;
            if ($movimientos->response['status'] === false) {
                $fail = true;
                break;
            }

            $es_entrada = strcasecmp($nota['entrada_salida'], 'Entrada')  === 0;
            if ($hacer_contra_movimiento) {
                $entrada_salida = $es_entrada ? 'Salida': 'Entrada';
                $nota['numero'] = NotaBodega::getSiguienteNumero($bodega['bodega_id']);
                $nota['entrada_salida'] = $entrada_salida;

                $movimientos->response = [];
                $movimientos->nuevaNota_($nota, $items);
                $response[] = $movimientos->response;
                if ($movimientos->response['status'] === false) {
                    $fail = true;
                    break;
                }
            }
        }
        $movimientos->response = [];

        self::registraTest($bodega, !$fail);

        if ($fail) {
            self::removeTest($bodega);
            global $gIAsql;
            $file = str_replace(["C:\wamp\www","\\"],["","/"],__FILE__);
            ia_errores_a_dime($gIAsql['err'], $file, "Sql", __LINE__);
            return ['code' => 409, 'status' => false, 'message' => 'Algo sucedio en la prueba', 'error' => $gIAsql['err'], 'respuestas' => $response];
        }
        return ['code' => 200, 'status' => true, 'message' => '<b>Prueba exitosa!</b><br>Puedes consultar los datos','bodega' => $bodega, 'log' => "<h4>Ejecucion de Prueba</h4>OK!<hr>"];
    }

    public static function registraTest($bodega, $ok = true)
    {
        $builderSql = new IacSqlBuilder();
        $prueba_bodega = [
            'prueba_bodega_id' => ia_guid(),
            'bodega_id' => $bodega['bodega_id']??'',
            'origen_bodega_id' => $bodega['origen_bodega_id']??'',
            'estatus' => $ok ? 'OK':'FAIL',
            'activa' => $ok ? '1' : '0',
            'alta_por' => $_SESSION['usuario']
        ];
        $queries = [
            "CREATE TABLE IF NOT EXISTS prueba_bodega (
                prueba_bodega_id VARCHAR(32) PRIMARY KEY,
                bodega_id VARCHAR(32) NOT NULL,
                origen_bodega_id VARCHAR(32) NOT NULL,
                estatus VARCHAR(32) NOT NULL,
                activa INT NOT NULL DEFAULT 1,
                comentario TEXT,
                alta_db timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
                alta_por varchar(32) NOT NULL DEFAULT 'Sistema'
            )",
            $builderSql->insert("prueba_bodega", $prueba_bodega)
        ];
        ia_transaction($queries);
    }

    public static function createBodegaPrueba(): bool|array
    {
        $bodega = [
            'bodega_id' => ia_guid(),
            'bodega' => 'Prueba Fuego',
            'label' => '__test__',
            'color' => '#CCAC93',
            'empresa_id' => 1,
            'alta_db' => 'NOW()',
            'alta_por' => $_SESSION['usuario'],
            'encargado_id' => $_SESSION['usuario_id']
        ];

        $origen_bodega = [
            'origen_bodega_id' => ia_guid(),
            'clave' => $bodega['bodega'],
            'extra_clave' => $bodega['label'],
            'bodega_id' => $bodega['bodega_id'],
            'empresa_id' => $bodega['empresa_id']
        ];
        $origen_bodega_bodega = [
            'origen_bodega_id' => $origen_bodega['origen_bodega_id'],
            'bodega_id' => $bodega['bodega_id'],
            'vale_bodega_salida' => 'Si',
            'vale_bodega_entrada' => 'Si'
        ];

        $builderSql = new IacSqlBuilder();
        $method = __METHOD__;
        $queries = [
            "DELETE /*$method*/ FROM bodega WHERE label = '$bodega[label]' OR bodega = '$bodega[bodega]'",
            "DELETE /*$method*/ FROM origen_bodega WHERE extra_clave = '$bodega[label]' OR clave = '$bodega[bodega]'",
            $builderSql->insert("bodega", $bodega),
            $builderSql->insert("origen_bodega", $origen_bodega),
            "INSERT INTO /*$method*/ origen_bodega_bodega(origen_bodega_id, bodega_id)
                    SELECT ob.origen_bodega_id, b.bodega_id
                    FROM origen_bodega ob, bodega b
                    WHERE ob.bodega_id IS NULL OR ob.bodega_id <> b.bodega_id
                    ON DUPLICATE KEY UPDATE bodega_id = VALUES(bodega_id)",
        ];
        if (ia_transaction($queries)) {
            global $gIAsql;
            $file = str_replace(["C:\wamp\www","\\"],["","/"],__FILE__);
            ia_errores_a_dime($gIAsql['err'], $file, "Sql", __LINE__);
            return false;
        }

        async_generaCatalogos(['bodega', 'origen_bodega', 'origen_bodega_grupo', 'origen_bodega_grupo_2']);

        $bodega['origen_bodega_id'] = $origen_bodega['origen_bodega_id'];
        return $bodega;
    }

    public static function getCatalogos(): array
    {
        $colores = json_decode(obtenCatalogo('color'), true);
        $colores = array_combine(
            array_column($colores, 'color_id'),
            $colores
        );
        $origenes = json_decode(obtenCatalogo('origen_bodega', true), true);
        $origenes = array_combine(
            array_column($origenes, 'origen_bodega_id'),
            $origenes
        );
        $origenes = array_filter($origenes, function ($origen, $key) {
            return ($origen['es']==='TIENDA'||$origen['es']==='BODEGA') && $key !== '11ec6cb303b9cff4ad6b74867af2fe60';
        }, ARRAY_FILTER_USE_BOTH);

        return [
            'productos' => ProductoGeneral::getAll(),
            'colores' => $colores,
            'origen_destino' => $origenes
        ];
    }

    public static function removeAllTest($solo_activas = false)
    {
        $select = "SELECT * FROM prueba_bodega";
        if ($solo_activas)
            $select.= " WHERE activa = 1";
        
        $pruebas = ia_sqlArrayIndx("SELECT * FROM prueba_bodega");
        foreach ($pruebas as $i => $prueba) {
            self::removeTest(['bodega_id' => $prueba['bodega_id'], 'origen_bodega_id' => $prueba['origen_bodega_id']]);
        }
    }

    /**
     * @param $bodega - Es la bodega de Prueba
     */
    public static function removeTest($bodega): array
    {
        $bodega_id_it = strit($bodega['bodega_id']);
        $origen_bodega_id_it = strit($bodega['origen_bodega_id']);
        $select_nota_bodega_id = "SELECT nota_bodega_id FROM nota_bodega WHERE bodega_id = $bodega_id_it";
        $queries = [
            "DELETE FROM bodega WHERE bodega_id = $bodega_id_it",
            "DELETE FROM origen_bodega WHERE origen_bodega_id = $origen_bodega_id_it",
            "DELETE FROM origen_bodega_bodega WHERE bodega_id = $bodega_id_it",
            "DELETE FROM nota_bodega_items WHERE nota_bodega_id IN ($select_nota_bodega_id)",
            "DELETE FROM inconsistencia_nota_bodega WHERE bodega_id = $bodega_id_it",
            "DELETE FROM nota_bodega_contra_nota_bodega WHERE nota_bodega_id IN ($select_nota_bodega_id) OR contra_nota_bodega_id IN ($select_nota_bodega_id)",
            "DELETE FROM nota_bodega WHERE bodega_id = $bodega_id_it",
            "DELETE FROM producto_bodega WHERE bodega_id = $bodega_id_it",
            "DELETE FROM bodega_existencia_diaria WHERE bodega_id = $bodega_id_it",
            "DELETE FROM nota_bodega_autorizacion WHERE bodega_id = $bodega_id_it",
            "UPDATE prueba_bodega SET activa = 0 WHERE bodega_id = $bodega_id_it"
        ];

        if (ia_transaction($queries)) {
            global $gIAsql;
            $file = str_replace(["C:\wamp\www","\\"],["","/"],__FILE__);
            ia_errores_a_dime($gIAsql['err'], $file, "Sql", __LINE__);
            return ['code' => 409, 'status' => false, 'message' => 'Algo sucedio al eliminar las prueba', 'error' => $gIAsql['err']];
        }
        async_generaCatalogos(['bodega', 'origen_bodega', 'origen_bodega_grupo', 'origen_bodega_grupo_2']);
        return ['code' => 200, 'status' => true, 'message' => '<b>Se elimino la prueba</b><br>Puedes realizar más pruebas'];
    }

    /**
     * @param string $bodega_id Es el id de la bodega de prueba
     * @return array[] con la respuesta de tipo [code=> '', status=> '', message => '']
     */
    public static function cancelaNotas(string $bodega_id, string $cuales = 'todas', $cuantas = 2): array
    {

        $cuales_options = ['entrada', 'salida', 'random', 'todas', 'all'];
        if (!in_array($cuales, $cuales_options))
            return ['code'=> 400, 'status'=> false, 'message' => "La opción '$cuales' no es permitida para este parametro"];

        $bodega = OrigenBodega::_getBy(['bodega_id' => $bodega_id]);
        if ($bodega['extra_clave']!== '__test__')
            return ['code'=> 400, 'status'=> false, 'message' => "La bodega '$bodega[clave]' no es bodega de pruebas"];

        $bodega_id_it = strit($bodega_id);

        $where_s = [];
        $where = "";
        if ($cuales == 'entrada' || $cuales == 'salida') {
            $where_s['entrada_salida'] = ucfirst($cuales);
            $builderSql = new IacSqlBuilder();
            $where = $builderSql->where($where_s);
            if (!empty($where_s))
                $where = "AND $where";
        }

        $select = "SELECT nota_bodega_id, numero, bodega_id, entrada_salida FROM nota_bodega WHERE bodega_id = $bodega_id_it $where";
        $notas_a_cancelar = $notas = ia_sqlArray($select, 'nota_bodega_id');

        if ($cuales == 'random') {
            $id_s = array_rand($notas, $cuantas);
            $notas_a_cancelar = [];
            foreach ($id_s as $nota_bodega_id) {
                $notas_a_cancelar[$nota_bodega_id] = $notas[$nota_bodega_id];
            }
        }

        $do_Class = false;
        include_once dirname(__DIR__).'/backoffice/ajax/movimientos_bodega_acciones.php';
        $movimientosBodegaAcciones = new MovimientosBodega(['accion' => 'cancelarNota', 'execute' => false]);

        $response = [];
        $fail = false;
        $notas_canceladas = [];

        foreach ($notas_a_cancelar as $nota_bodega_id => $nota) {
            $movimientosBodegaAcciones->response = [];
            $movimientosBodegaAcciones->cancelarNota_($nota_bodega_id);
            $response[] = $movimientosBodegaAcciones->response;
            if ($movimientosBodegaAcciones->response['status'] === false) {
                $fail = true;
                break;
            }
            $notas_canceladas[] = $nota['numero'];
        }
        $movimientosBodegaAcciones->response = [];

        if ($fail) {
            global $gIAsql;
            $file = str_replace(["C:\wamp\www","\\"],["","/"],__FILE__);
            ia_errores_a_dime($gIAsql['err'], $file, "Sql", __LINE__);
            return ['code' => 409, 'status' => false, 'message' => "No se pudieron cancelar la notas de $cuales", 'error' => $gIAsql['err'], 'respuestas' => $response];
        }

        $values = [];
        foreach ($response as $i => $res) {
            $nota = $res['nota'];
            $values[] = [
                'Num. nota' => $nota['numero'],
                'Accion' => $nota['tipo'] === 'Cancelacion' ? 'Cancelación de Nota': 'Descancelacion de Nota'
            ];
        }

        $log = "<h4>Cancelacion/Descancelacion de Notas ".strtoupper($cuales)." ***********</h4>".TableHelper::render($values, table_title: 'Cancelacion/Descancelacion de Notas',widthTable: '500px', margin_table: 0). "<hr>";

        
        return ['code' => 200, 'status' => true, 'message' => "<h3>Cancelacion exitosa! <br>Se cancelaron las notas ".(implode(", ", $notas_canceladas))." de la bodega $bodega[clave]</h3>", 'log' => $log];
    }

    /**
     * @param string $bodega_id Es el id de la bodega de prueba
     * @return array[] con la respuesta de tipo [code=> '', status=> '', message => '']
     */
    public static function bloquearNotas(string $bodega_id, string $cuales = 'todas', $cuantas = 2, $valor = 1): array
    {
        $cuales_options = ['entrada', 'salida', 'random', 'todas', 'all'];
        if (!in_array($cuales, $cuales_options))
            return ['code'=> 400, 'status'=> false, 'message' => "La opción '$cuales' no es permitida para este parametro"];

        $bodega = OrigenBodega::_getBy(['bodega_id' => $bodega_id]);
        if ($bodega['extra_clave']!== '__test__')
            return ['code'=> 400, 'status'=> false, 'message' => "La bodega '$bodega[clave]' no es bodega de pruebas"];

        $bodega_id_it = strit($bodega_id);

        $where_s = [];
        $where = "";
        if ($cuales == 'entrada' || $cuales == 'salida') {
            $where_s['entrada_salida'] = ucfirst($cuales);
            $builderSql = new IacSqlBuilder();
            $where = $builderSql->where($where_s);
            if (!empty($where_s))
                $where = "AND $where";
        }

        $select = "SELECT nota_bodega_id, numero, bodega_id, entrada_salida FROM nota_bodega WHERE bodega_id = $bodega_id_it $where";
        $notas_a_bloquear = $notas = ia_sqlArray($select, 'nota_bodega_id');

        if ($cuales == 'random') {
            $id_s = array_rand($notas, $cuantas);
            $notas_a_bloquear = [];
            foreach ($id_s as $nota_bodega_id) {
                $notas_a_bloquear[$nota_bodega_id] = $notas[$nota_bodega_id];
            }
        }

        $do_Class = false;
        include_once dirname(__DIR__).'/backoffice/ajax/movimientos_bodega_acciones.php';
        $movimientosBodegaAcciones = new MovimientosBodega(['accion' => 'cancelarNota', 'execute' => false]);

        $response = [];
        $fail = false;
        $notas_bloqueadas = [];

        $movimientosBodegaAcciones->bloquearNota_(array_keys($notas_a_bloquear), $valor);

        $accion = ($valor == 1) ? 'bloquear': 'desbloquear';
        $label = (($valor == 1) ? 'Bloqueo' : 'Desbloqueo') . ' de Notas';
        $single = ($valor == 1) ? 'bloquearon': 'desbloquearon';

        if ($movimientosBodegaAcciones->response['code'] !== 200) {
            global $gIAsql;
            $file = str_replace(["C:\wamp\www","\\"],["","/"],__FILE__);
            ia_errores_a_dime($gIAsql['err'], $file, "Sql", __LINE__);
            return ['code' => 409, 'status' => false, 'message' => "No se pudieron $accion la notas", 'error' => $gIAsql['err'], 'respuestas' => $response];
        }


        $values = [];
        foreach ($response as $i => $res) {
            $nota = $res['nota'];
            $values[] = [
                'Num. nota' => $nota['numero'],
                'Accion' => $label
            ];
        }

        $log = "<h4>$label ".strtoupper($cuales)." ***********</h4>".TableHelper::render($values, table_title: $label,widthTable: '500px', margin_table: 0). "<hr>";

        
        return ['code' => 200, 'status' => true, 'message' => "<h3>".($valor == 1 ? 'Bloqueo' : 'Desbloqueo')." exitoso! <br>Se $single las notas ".(implode(", ", $notas_bloqueadas))." de la bodega $bodega[clave]</h3>", 'log' => $log];


    }

    /**
     * @param string $bodega_id Es el id de la bodega de prueba
     * @return array[] con la respuesta de tipo [code=> '', status=> '', message => '']
     */
    public static function eliminarNotas(string $bodega_id, string $cuales = 'todas', $cuantas = 2): array
    {
        $cuales_options = ['entrada', 'salida', 'random', 'todas', 'all'];
        if (!in_array($cuales, $cuales_options))
            return ['code'=> 400, 'status'=> false, 'message' => "La opción '$cuales' no es permitida para este parametro"];

        $bodega = OrigenBodega::_getBy(['bodega_id' => $bodega_id]);
        if ($bodega['extra_clave']!== '__test__')
            return ['code'=> 400, 'status'=> false, 'message' => "La bodega '$bodega[clave]' no es bodega de pruebas"];

        $bodega_id_it = strit($bodega_id);

        $where_s = [];
        $where = "";
        if ($cuales == 'entrada' || $cuales == 'salida') {
            $where_s['entrada_salida'] = ucfirst($cuales);
            $builderSql = new IacSqlBuilder();
            $where = $builderSql->where($where_s);
            if (!empty($where_s))
                $where = "AND $where";
        }

        $select = "SELECT nota_bodega_id, numero, bodega_id, entrada_salida FROM nota_bodega WHERE bodega_id = $bodega_id_it $where AND tipo = 'Cancelacion'";
        $notas_a_eliminar = $notas = ia_sqlArray($select, 'nota_bodega_id');

        if (empty($notas_a_eliminar))
            return ['code' => 200, 'status' => false, 'message' => 'Debe cancelar notas para poder eliminar'];


        if ($cuales == 'random') {
            $id_s = array_rand($notas, $cuantas);
            $notas_a_eliminar = [];
            foreach ($id_s as $nota_bodega_id) {
                $notas_a_eliminar[$nota_bodega_id] = $notas[$nota_bodega_id];
            }
        }

        // $do_Class = false;
        // include_once dirname(__DIR__).'/backoffice/ajax/movimientos_bodega_acciones.php';
        // $movimientosBodegaAcciones = new MovimientosBodega(['accion' => 'cancelarNota', 'execute' => false]);

        $response = [];
        $fail = false;
        $notas_eliminadas = [];
        $app = new app_nota_bodega('d');
        foreach ($notas_a_eliminar as $nota_bodega_id => $nota) {
            $app->id = $nota_bodega_id;
            $app->enDB =$app->values = $app->read_sql($app->id, $app->h);

            $eliminada = $app->delete_do(true);
            if (!$eliminada) {
                $response[] = $app->msg_err;
                $fail = true;
                break;
            }
            $response[] = $app->msg_aviso;
            $notas_eliminadas[] = $nota['numero'];
        }

        if ($fail) {
            global $gIAsql;
            $file = str_replace(["C:\wamp\www","\\"],["","/"],__FILE__);
            ia_errores_a_dime($gIAsql['err'], $file, "Sql", __LINE__);
            return ['code' => 409, 'status' => false, 'message' => "No se pudieron cancelar la notas de $cuales", 'error' => $gIAsql['err'], 'respuestas' => $response];
        }

        $values = [];
        foreach ($notas_eliminadas as $i => $num) {
            $values[] = [
                'Num. nota' => $num,
                'Accion' => 'Nota eliminada'
            ];
        }

        $log = "<h4>Eliminacion de Notas ".strtoupper($cuales)." ***********</h4>".TableHelper::render($values, table_title: 'Eliminacion de Notas',widthTable: '500px', margin_table: 0). "<hr>";

        
        return ['code' => 200, 'status' => true, 'message' => "<h3>Eliminacion exitosa! <br>Se eliminaron las notas: ".(implode(", ", $notas_eliminadas))." de la bodega $bodega[clave]</h3>", 'log' => $log];
    }

}