<?php
/**
 * 
 * 
 * 
 */



final class Pwd {
    // es final porque usa self:: en vez de static::
    private static $options = ['cost' => 12];
    private static $algorithm = PASSWORD_DEFAULT;
    
    /**
     * Hash the password
     *
     * @param string $password
     * @return string
     */
    public static function encripta($password) {
        return password_hash($password, self::$algorithm, self::$options);
    }
    
    /**
     * Check password matches hash
     *
     * @param string $password
     * @param string $hash
     * @return bool
     */
    public static function verify($password, $hash) {
        return password_verify($password, $hash);
    }
    
/// Extended Functionalaty //////////////////////////////////////////////////////////////
    /**
     * Rehash the pasword's hash, for example on cost, algorithm change
     *
     * @param string $hash
     * @return string
     */
    public static function needsRehash($hash) {
        return  password_needs_rehash($hash , self::$algorithm, self::$options);
    }
            
}




