<?php

class Totalizador {
    protected /* en 8.1 poner: readonly */ int $agrupaPorLen;
    protected /* en 8.1 poner: readonly */ array $agrupaPor;// ['bodega', 'producto'] o ['bodega'=>['class'=>'']]
    protected /* en 8.1 poner: readonly */ array $agrupaPorNames;
    protected /* en 8.1 poner: readonly */ array $totaliza;// ['bodega', 'producto'] o ['bodega'=>['class'=>'']]
    protected /* en 8.1 poner: readonly */ array $ceros;
    protected array $granTotal;
    protected array $options;
    protected array $totalLevels = [];

    public function getTotalsByLevel():array {
        return $this->totalLevels;
    }

    public function __construct(array $agrupaPor, array $totaliza, array $options = []) {
        $this->options = $options;
        $this->totaliza = array_is_list($totaliza) ?
            array_combine($totaliza, array_fill(1, count($totaliza), '+')) :
            $totaliza;

        $this->agrupaPorLen = count($agrupaPor);
        $this->agrupaPor = array_is_list($agrupaPor) ?
            array_combine($agrupaPor, array_fill(1, $this->agrupaPorLen, [])) :
            $agrupaPor;
        $this->agrupaPorNames = array_keys($this->agrupaPor);

        $this->granTotal = $this->ceros = array_combine(
            array_keys($this->totaliza),
            array_fill(1, count($this->totaliza), 0.00)
        );

    }

    public function agrupa(array $data, bool $removeGroupedColumns = false):array {
        $lastColumn = array_key_last($this->agrupaPor);
        $ret = [];
        foreach($data as $d) {
            $subTotalKey = $d['unidad'] ?? '';
            $arrRef = &$ret;
            foreach($this->agrupaPor as $columnName => $_) {
                $key = $d[$columnName];
                if(!isset($arrRef[$key]))
                    if($lastColumn === $columnName)
                        $arrRef[$key] = [ 'rows' => []];
                    else {
                        $arrRef[$key] = ['rd'=>$d, 'k'=>$key, 'lk' =>$lastColumn, 'totals' => $this->ceros, 'rows' => [], $lastColumn];
                    }
                if(!empty($d['Neg']))
                    $arrRef[$key]['Neg'] = $d['Neg'];
                if($lastColumn !== $columnName) {
                    foreach ($this->totaliza as $totalColumn => $operator) {
                        switch ($operator) {
                            case 'COUNT':
                                $arrRef[$key]['totals'][$totalColumn]++;
                                break;
                            case 'MAX':
                                $currentTotal = $arrRef[$key]['totals'][$totalColumn];
                                if ($currentTotal === null || $d[$totalColumn] > $currentTotal)
                                    $arrRef[$key]['totals'][$totalColumn] = $d[$totalColumn];
                                break;
                            case 'MIN':
                                $currentTotal = $arrRef[$key]['totals'][$totalColumn];
                                if ($currentTotal === null || $d[$totalColumn] < $currentTotal)
                                    $arrRef[$key]['totals'][$totalColumn] = $d[$totalColumn];
                                break;
                            default:
                                $arrRef[$key]['totals'][$totalColumn] += $d[$totalColumn];
                        }
                    }
                } else
                    foreach ($this->totaliza as $totalColumn => $operator)
                        switch ($operator) {
                            case 'COUNT':
                                break;
                            case 'MAX':
                                $currentTotal = $this->granTotal[$totalColumn];
                                if ($currentTotal === null || $d[$totalColumn] > $currentTotal)
                                    $arrRef[$key]['totals'][$totalColumn] = $d[$totalColumn];
                                break;
                            case 'MIN':
                                $currentTotal = $this->granTotal[$totalColumn];
                                if ($currentTotal === null || $d[$totalColumn] < $currentTotal)
                                    $arrRef[$key]['totals'][$totalColumn] = $d[$totalColumn];
                                break;
                            default:
                                $this->granTotal[$totalColumn] += $d[$totalColumn];
                                if( !isset($this->granTotal['units'][$totalColumn][$subTotalKey]))
                                    $this->granTotal['units'][$totalColumn][$subTotalKey] = 0;
                                $this->granTotal['units'][$totalColumn][$subTotalKey] += $d[$totalColumn];

                        }
                $arrRef = &$arrRef[$key]['rows'];
                if($removeGroupedColumns) {
                    $d[$columnName."_grp"] = $d[$columnName];
                    unset($d[$columnName]);
                }
            }
            $arrRef = $d;
        }
        return $ret;
    }

    public function rowsTotalsAbove(array $data, int $level = 1, &$parents=[], &$return_txt=[], &$c_group=""):array {
        $return = [];

        foreach($data as $group => $d) {
            if($level === 1) {
                $parents = [$group];
                $c_group = $group;
                $return_txt[$c_group] = "";

            }
            else
               $parents[] = $group;
            global $gDime;

            if(array_key_exists('totals', $d)) {
                $return[] = $this->rowTotal($group, $level, $d['totals'], $d['rows'], $parents, $d['Neg'] ?? '' );
                $return  = array_merge($return,
                    $this->rowsTotalsAbove($d['rows'], $level +1, $parents, $return_txt, $c_group) );
            } else {
                $return[] = $this->rowData($group, $level, $d['rows'], $parents);
            }
        }
        return $return;
    }

    /**
     * @return array
     */
    public function getGranTotal(): array {
        return $this->granTotal;
    }

    /**
     * Override: Regresa un renglón con el subtotal $group a nivel $level, $totals llenados por $this->agrupa
     * Al extender esta clase hacer @override a este método para diferente comportamineto
     *
     * @param string $group el nombre del subtotal
     * @param int $level el número del sub total, el primero es uno
     * @param array $totals
     * @param array $detailRows
     * @param array $parents
     * @return string HTML para el row de totales
     */
    protected function rowTotal(string $group, int $level, array $totals, array $detailRows = [], array &$parents =[], $mark = ''):string {
        if(array_key_exists($level, $this->totalLevels))
            $this->totalLevels[$level]++;
        else
            $this->totalLevels[$level] = 1;
        $tabs = $level === 1 ? "" : str_repeat("&nbsp;&nbsp;&nbsp;&nbsp&nbsp;&nbsp;&nbsp;&nbsp;", $level-1);
        $clickToExpand = "data-colapsExpand='1' onclick='totalizadorToggleGroup(this, $level)'";
        $cursorClass = 'tP';

        //
        $return = strim( "<tr data-tipo='tsT' data-level='$level' class='tsT tsT$level'>
            <td class='tsT$level $cursorClass' $clickToExpand>$tabs
            <span class='t_oC'>▼</span>$group");
        $red = '';
        foreach($totals as $key => $total) {
            $red = $total < 0 ? ' t_negativo' : '';
            $return .= "<td class='tsTv$red'>";
            $k = strtolower($key);
            if(str_contains($k, 'rollos') || str_contains($k, 'numero')  || str_contains($k, '_n') )
                /** @noinspection PhpRedundantOptionalArgumentInspection */
                $return .= number_format($total, 0, '', ',');
            else
                $return .= number_format($total, 2);
        }
        $return .= "<td class='tsTv$red'>";
        return $return;
    }

    /** Override: Regresa un renglón con el detalle $group a nivel $level, $totals llenados por $this->agrupa
     * Al extender esta clase hacer @override a este método para diferente comportamineto
     *
     * @param string $group
     * @param int $level
     * @param array $row
     * @return string
     */
    protected function rowData(string $group, int $level, array $row):string {
        if(array_key_exists($level, $this->totalLevels))
            $this->totalLevels[$level]++;
        else
            $this->totalLevels[$level] = 1;
        //$colspan = $this->agrupaPorLen;
        $colspan = 1;
        $tabs = $level === 1 ? "" : str_repeat("&nbsp;&nbsp;&nbsp;&nbsp&nbsp;&nbsp;&nbsp;&nbsp;", $level-1);
        $return = strim("<tr data-tipo='datos' data-row='" . json_encode($row) .  "'>
            <td colspan='$colspan' class='dataLabel tsT$level'>$tabs$group");
        foreach($row as $columnName => $value) {
            if(endsWith($columnName, '_id') || array_key_exists($columnName, $this->agrupaPor))
                continue;
            if(is_numeric($value)) {
                $red = $value < 0 ? ' t_negativo' : '';
                $return .= "<td class='t_m$red'>";
                $k = strtolower($columnName);
                if(str_contains($k, 'rollos') || str_contains($k, 'numero') )
                    $return .= number_format($value, 0, '', ',');
                else
                    $return .= number_format((float)$value, 2);
            } else {
                $return .= "<td>$value";
            }
        }
        return $return;
    }

}
