<?php
declare(strict_types=1);

/*
 *
 *
 */

use Iac\inc\sql\IacSqlBuilder;

final class User
{
    // private string $table = 'estado_bodega';
    // private string $pkField = 'estado_bodega_id';

    /**
     * Busca un estado_bodega por el campo estado_bodega_id
     *
     * @param mixed $id id del usuario
     * @return array con los valores del usuario
     */
    public function getByID(mixed $id): array
    {
        if (empty($id) ) return [];

        $method = __METHOD__;
        return ia_singleton("SELECT /*$method*/ * FROM iac_usr WHERE iac_usr_id = $id");
    }

    static function _getByID(mixed $id)
    {
        return (new User())->getByID($id);
    }

    /**
     * @param bool $only_active true solo activos, false ambos active e inactive
     * @return array
     */
    public function getAll(bool $only_active = true): array
    {
        return [];
    }

    static function verifyPassword(string $password):array|bool
    {
        $iac_usr_id = $_SESSION['usuario_id'];
        $user = self::_getByID($iac_usr_id);
        if (empty($user))
            return ['Usuario no existe'];

        $password = strim($password);

        return Pwd::verify($user['iac_usr_id'].$password, $user['pwd']);
    }
}