<?php

class UserMvSessionManager {

    protected string $table;
    private $sessionTimeout = 3600; // Tiempo de espera de la sesión (en segundos), por ejemplo, 1 hora
    protected string $primaryKey;
    protected string $usser_column;
    protected string $passwordColumn = "password";

    public function __construct(string $table = "usuarios_mv", string $primaryKey = "usuarios_mv_id", string $passwordColumn = "password", string $usrcolumn = "username") {
        $this->table = $table;
        $this->primaryKey = $primaryKey;
        $this->passwordColumn = $passwordColumn;
        $this->usser_column = $usrcolumn;
    }

    public function login($username, $password) {
        $sqlComment = "/*" . __METHOD__ . "*/";
        $sql = "SELECT $sqlComment * FROM $this->table WHERE  $this->usser_column = ".strir($username);
        $user = ia_singleton($sql);
        if ($user) {
            if (password_verify($password, $user[$this->passwordColumn])) {
                if ($user['estado'] == 'activo') {
                    // Generar un nuevo token de sesión
                    $sessionToken = bin2hex(random_bytes(32));

                    $this->updateSessionToken($user[$this->passwordColumn], $sessionToken);
                    $this->startSecureSession();

                    $_SESSION['usuarios_mv_id'] = $user[$this->passwordColumn];
                    $_SESSION['username_mv'] = $user[$this->usser_column];
                    $_SESSION['token_sesion'] = $sessionToken;
                    $_SESSION['last_activity'] = time();

                    $this->updateLastAccess($user[$this->passwordColumn]);
                    return true;
                } else {
                    return "La cuenta está inactiva.";
                }
            } else {
                return "Credenciales incorrectas.";
            }
        } else {
            return "Usuario no encontrado.";
        }
    }

    // Función para actualizar el token de sesión
    private function updateSessionToken($userId, $token) {
        $sql = "UPDATE $this->table SET token_sesion = ".strit($token)." WHERE $this->primaryKey = ". strit($userId);
        ia_query($sql);
    }

    // Función para actualizar la última fecha de acceso
    private function updateLastAccess($userId) {
        $sql = "UPDATE $this->table SET ultimo_acceso = NOW() WHERE $this->passwordColumn = ". strit($userId);
        ia_query($sql);
    }

    // Función para verificar si el usuario está autenticado
    public function isAuthenticated() {
        // Verificar si la sesión está iniciada y el token de sesión es válido
        if (isset($_SESSION['user_id'], $_SESSION['token_sesion'])) {
            $userId = $_SESSION['user_id'];
            $sessionToken = $_SESSION['token_sesion'];

            // Verificar si el token almacenado en la base de datos coincide
            $sql = "SELECT token_sesion FROM $this->table WHERE id = :id";
            $user = ia_singleton($sql, ['id' => $userId]);

            // Verificar si el token coincide y si la sesión no ha expirado
            if ($user && $user['token_sesion'] === $sessionToken && time() - $_SESSION['last_activity'] <= $this->sessionTimeout) {
                $_SESSION['last_activity'] = time(); // Actualizar el tiempo de la última actividad
                return true;
            } else {
                $this->logout();
                return false;
            }
        }
        return false;
    }

    // Función para cerrar la sesión
    public function logout() {
        $_SESSION = [];
        session_start();
        session_unset(); // Limpiar las variables de sesión
        session_destroy(); // Destruir la sesión
    }

    // Función para obtener la información del usuario logueado
    public function getUserInfo() {
        if ($this->isAuthenticated()) {
            return [
                'user_id' => $_SESSION['user_id'],
                'username' => $_SESSION['username']
            ];
        }
        return null;
    }

    // Función para verificar si un usuario tiene un permiso específico
    // public function hasPermission($permission) {
    //     // Aquí deberías verificar si el usuario tiene el permiso en la base de datos
    //     // Por ejemplo, podemos agregar una tabla de permisos y hacer una consulta como:
    //     $sql = "SELECT COUNT(*) FROM permisos WHERE user_id = :user_id AND permission = :permission";
    //     $count = ia_singleread($sql, ['user_id' => $_SESSION['user_id'], 'permission' => $permission]);
    //     return $count > 0;
    // }



    private function startSecureSession(): void {
        $lifetime = 60 * 60;
        ini_set('session.gc_maxlifetime', $lifetime + 10);
        $session_options = [
            'cookie_secure' => TRUE, // Send cookie only over HTTPS
            'cookie_httponly' => TRUE, // Prevent JavaScript access to cookie
            'use_strict_mode' => TRUE, // Prevent session fixation
            'cookie_samesite' => 'Strict', // Prevent CSRF attacks
            'cookie_lifetime' => $lifetime,
        ];

        if(version_compare(PHP_VERSION, '8.1.0', '>=')) {
            $session_options['cookie_path'] = '/'; // Explicitly set path to root
            $session_options['sid_length'] = 128; // Increase session ID length
            $session_options['sid_bits_per_character'] = 6; // Use more bits per character in session ID
        }

        session_start($session_options);
    }

    public function isLoggedIn(): bool {
        return isset($_SESSION['loggedin']) && $_SESSION['loggedin'] === TRUE;
    }

    // public function login(string $email): void {
    //     $_SESSION['loggedin'] = TRUE;
    //     $_SESSION['email'] = $email;
    //     session_regenerate_id(TRUE); // Regenerate session ID after login
    // }

    // public function logout(): void {
    //     $_SESSION = [];
    //     session_destroy();
    // }








}