<?php

use JetBrains\PhpStorm\NoReturn;

class VerifiedDocument
{
    /**
     * Updates the verificado_list field in the nota_bodega table based on the checked value.
     *
     * @param array $values The array of values containing iac_usr_id, documento_id, and checked.
     * @return void
     */
    public static function updateNotaList($values){
        //metodo
        $iac_usr_id = $values["iac_usr_id"];
        $documento_id = $values["documento_id"];
        $checked = $values["checked"]; // checked - not_checked
        //$tema = $values["tema"];
        $sql = [];
        $already_hav = ia_singleton("select verificado_list from nota_bodega where nota_bodega_id = ". strit($documento_id));
        $user = ia_singleton("select nick from iac_usr where iac_usr_id =". strit($iac_usr_id));

        if($checked === 'checked'){
            if(empty($already_hav["verificado_list"])){
                $sql[] = "UPDATE `nota_bodega` SET `verificado_list` = ".strit($user["nick"].";") ." WHERE (`nota_bodega_id` = ".strit($documento_id).")";
            }else{
                $users_list = explode(";", $already_hav["verificado_list"]);
                $lista = '';
                foreach($users_list as $nombre){
                    if(empty($nombre) || $nombre === $user["nick"] ) continue;
                    $lista .= $lista . $nombre.";";
                }
                $sql[] = "UPDATE `nota_bodega` SET `verificado_list` = ".strit($lista . $user["nick"].";") ." WHERE (`nota_bodega_id` = ".strit($documento_id).")";
            }
        }else if($checked === 'not_checked'){
            $users_list = explode(";", $already_hav["verificado_list"] ?? '');
            $lista = '';
            foreach ($users_list as $nombre) {
                if (empty($nombre)) continue;
                if ($nombre === $user["nick"]) {
                    $lista = str_replace($nombre . ';', '', $already_hav["verificado_list"]);
                }
            }
            $sql[] = "UPDATE `nota_bodega` SET `verificado_list` = ".strit($lista) ." WHERE (`nota_bodega_id` = ".strit($documento_id).")";
        }

        if(ia_transaction($sql))
        {
            ia_errores_a_dime('','','',true);
        }
    }

    /**
     * Update the verificado_list field of a given $tema and $documento_id based on the $checked value.
     *
     * @param array $values An array of values containing iac_usr_id, documento_id, checked, tema, and pk_field.
     * @return void
     */
    public static function updateBancoMovList(array $values): void
    {
        $iac_usr_id = $values["iac_usr_id"];
        $documento_id = $values["documento_id"];
        $checked = $values["checked"]; // checked - not_checked
        $tema = $values["tema"] ?? "banco_cuenta_mov";
        $pk_field = $values["pk_field"] ?? $tema . "_id";
        $sql = [];
        $already_hav = ia_singleton("select verificado_list from $tema where $pk_field = ". strit($documento_id));
        // $user = ia_singleton("select nombre from iac_usr where iac_usr_id =". strit($iac_usr_id));
        $user = ia_singleton("select nick from iac_usr where iac_usr_id =". strit($iac_usr_id));

        if($checked === 'checked'){
            if(empty($already_hav["verificado_list"])){
                $sql[] = "UPDATE `$tema` SET `verificado_list` = ".strit($user["nick"].";") ." WHERE (`$pk_field` = ".strit($documento_id).")";
            }else{
                $users_list = explode(";", $already_hav["verificado_list"]);
                $lista = '';
                foreach($users_list as $nombre){
                    if(empty($nombre) || $nombre === $user["nick"] ) continue;
                    $lista .= $lista . $nombre.";";
                }
                $sql[] = "UPDATE `$tema` SET `verificado_list` = ".strit($lista . $user["nick"].";") ." WHERE (`$pk_field` = ".strit($documento_id).")";
            }
        }else if($checked === 'not_checked'){
            $users_list = explode(";", $already_hav["verificado_list"]);
            $lista = '';
            foreach ($users_list as $nombre) {
                if (empty($nombre)) continue;
                if ($nombre === $user["nick"]) {
                    $lista = str_replace($nombre . ';', '', $already_hav["verificado_list"]);
                }
            }
            $sql[] = "UPDATE `$tema` SET `verificado_list` = ".strit($lista) ." WHERE (`$pk_field` = ".strit($documento_id).")";
        }

        if(ia_transaction($sql))
        {
            ia_errores_a_dime('','','',true);
        }
    }

    /**
     * Esta función pone el checked
     * @param array $doc - Array de valores para checked_document, debe contener iac_usr_id, tema, documento_id. 'tema' = tabla
     * @param bool $execute
     * @return string|bool
     */
    public static function verifiedDoc(array $doc, bool $execute = true):  string|bool
    {
        $doc['checked'] = 'checked';
        $builder = new \Iac\inc\sql\IacSqlBuilder();
        $query = $builder->insert('checked_document', $doc, onUpdate: "checked = 'checked', ultimo_cambio = NOW()");
        if (!$execute)
            return $query;

        if(ia_query($query))
        {
            ia_errores_a_dime();
            return false;
        }
        return true;
    }
    public static function toggleVerifiedDoc(array $doc, bool $execute = true):  string|bool
    {
        $doc['checked'] = 'checked';
        $builder = new \Iac\inc\sql\IacSqlBuilder();
        $query = $builder->insert('checked_document', $doc, onUpdate: "checked = IF (checked='checked', 'wrong', 'checked'), ultimo_cambio = NOW()");
        if (!$execute)
            return $query;

        if(ia_query($query))
        {
            ia_errores_a_dime();
            return false;
        }
        return true;
    }

    /**
     * Esta función pone el not_checked
     * @param array $doc - Array de valores para checked_document, debe contener iac_usr_id, tema, documento_id. 'tema' = tabla
     * @param bool $execute
     * @return string|bool
     */
    public static function noVerifiedDoc(array $doc, bool $execute = true): string|bool
    {
        $doc['checked'] = 'not_checked';
        $builder = new \Iac\inc\sql\IacSqlBuilder();
        $query = $builder->insert('checked_document', $doc, onUpdate: "checked = 'not_checked', ultimo_cambio = NOW()");
        if (!$execute)
            return $query;

        if(ia_query($query))
        {
            ia_errores_a_dime();
            return false;
        }
        return true;
    }

    public static function toggleNoVerifiedDoc(array $doc, bool $execute = true):  string|bool
    {
        $doc['checked'] = 'not_checked';
        $builder = new \Iac\inc\sql\IacSqlBuilder();
        $query = $builder->insert('checked_document', $doc, onUpdate: "checked = IF (checked='not_checked', 'wrong', 'not_checked'), ultimo_cambio = NOW()");
        if (!$execute)
            return $query;

        if(ia_query($query))
        {
            ia_errores_a_dime();
            return false;
        }
        return true;
    }

    /**
     * Esta función pone checked/not_checked dependiendo el valor previo (switch)
     * @param array $doc - Array de valores para checked_document, debe contener iac_usr_id, tema, documento_id. 'tema' = tabla
     * @param bool $execute - En FALSE regresa el query | TRUE ejecuta la consulta
     * @return string|bool
     */
    public static function toggleVerifiedNoVerified(array $doc, bool $execute = true): string|bool
    {
        $doc['checked'] = 'checked';
        $builder = new \Iac\inc\sql\IacSqlBuilder();
        $query = $builder->insert('checked_document', $doc, onUpdate: "checked = IF (checked='checked', 'not_checked', 'checked'), ultimo_cambio = NOW()");
        if (!$execute)
            return $query;

        if(ia_query($query))
        {
            ia_errores_a_dime();
            return false;
        }
        return true;
    }

    /**
     * Update the verificado_list field of a given $tema and $documento_id based on the $checked value.
     *
     * @param array $document An array of values containing documento_id, tema, and pk_field. 'tema' = tabla
     * @param bool $execute
     * @return string|bool
     */
    public static function updateVerifiedList(array $document, $solo_verificados = true, bool $execute = true): string|bool
    {
        // $iac_usr_id = strit($document["iac_usr_id"]);
        $documento_id = $document["documento_id"];
        $tema = $document["tema"] ?? "banco_cuenta_mov";
        $pk_field = $document["pk_field"] ?? $tema . "_id";

        $sql = "SELECT nick
        FROM checked_document cd
        JOIN iac_usr as u on u.iac_usr_id = cd.iac_usr_id
        WHERE cd.tema = '$tema'
            AND cd.documento_id = '$documento_id'
            AND cd.checked = 'checked'
        ORDER BY cd.ultimo_cambio";

        $users_verified = ia_sqlVector($sql);
        $veried_list='';
        if (!empty($users_verified))
            $veried_list = implode(";", $users_verified).";";


        $data_set = ['verificado_list' => $veried_list];

        if (!$solo_verificados)
        {
            $sql = "SELECT nick
            FROM checked_document cd
            JOIN iac_usr as u on u.iac_usr_id = cd.iac_usr_id
            WHERE cd.tema = '$tema'
                AND cd.documento_id = '$documento_id'
                AND cd.checked = 'not_checked'
            ORDER BY cd.ultimo_cambio";
            $users_no_verified = ia_sqlVector($sql);
            $no_veried_list='';
            if (!empty($users_no_verified))
                $no_veried_list = implode(";", $users_no_verified).";";

            $data_set['rechazado_list'] = $no_veried_list;
        }

        $builder = new \Iac\inc\sql\IacSqlBuilder();
        $query = $builder->update($tema, $data_set, [$pk_field => $documento_id]);
        if (!$execute)
            return $query;

        if(ia_query($query))
        {
            ia_errores_a_dime();
            return false;
        }
        return true;
    }

}