<?php

//
// otro archivo en inc: para que puedan hacer extend no usar private
class Worker_time {
    protected $params;

    /**
     * @param $params
     */
    public function __construct($params) {
        $this->params = $params ?? [];
    }

    public function procesa():array {

        switch ($this->params['type'] ?? ''){
            case 'GET_LAST_MODIFIED':
                return $this->getDateTables();
                break;
            case 'TOTAL_COUNT_BODEGA':
                return $this->getTotalsCountNotaBodega();
                break;
            default:
                return [];
        }


    }
    protected function getDateTables():array {

        $tables = $this->params['tablas_usar'] ?? [];

        if(empty($tables)) {
            return [
                'status' => FALSE,
                'message' => 'No llegaron las tablas'
            ];
        }
        $method = __METHOD__;
        $status = true;
        $times = [];
        foreach($tables as  $table => $value) {
            $da = $times[$table] = ia_singleread("SELECT /*$method*/ MAX(ultimo_cambio) FROM $table");
            if($da === false)
                $status = false;
        }

        return [
            'status' => $status,
            'times' => $times
        ];
    }

    protected function getTotalsCountNotaBodega(){
        $bodega_id = $this->params['bodega_id'];
        $es_verificacion = $this->params['es_verificacion'] ?? false;
        $bodega_verificador_id = $this->params['bodega_verificador_id'] ?? '0';

        if(empty($bodega_id)) {
            return [
                'status' => FALSE,
                'message' => 'No llego la bodega_id'
            ];
        }
        $method = __METHOD__;
        $nota_bodega_tabla = !$es_verificacion ? "nota_bodega" : "nota_bodega_verificacion";
        $where_bodega_verificador = !$es_verificacion ? "" : " AND bodega_verificador_id = " . strit($bodega_verificador_id);
        $count_tota = !$es_verificacion ? "nota_bodega.bodega_id" : "nota_bodega_verificacion.nota_bodega_verificacion_id";

        $numerosMinMaxEntradaSalida = ia_sqlSelectMultiKey(
            "SELECT /*$method numerosMinMaxEntradaSalida*/ entrada_salida as k1, count($count_tota) total FROM $nota_bodega_tabla WHERE bodega_id = " . strit($bodega_id) . $where_bodega_verificador . " AND tipo NOT IN ('Cancelacion', 'Correccion', 'Borrado') GROUP BY entrada_salida", 1);


        $numerosMinMax["nv_entrada"] = ltrim($numerosMinMaxEntradaSalida['Entrada']['total'] ?? "0", 0);
        $numerosMinMax["nv_salida"] = ltrim($numerosMinMaxEntradaSalida['Salida']['total'] ?? "0", 0);

        $numerosTipos = ia_sqlArray(
            "SELECT /*$method numerosPorTipoNota*/ tipo, count($count_tota) total, MAX(numero_real) max_num, MIN(numero_real) min_num FROM $nota_bodega_tabla WHERE bodega_id = " . strit($bodega_id) . $where_bodega_verificador . " GROUP BY tipo", 'tipo');


        $numerosMinMax["nv_movimiento"] = ltrim($numerosTipos["Movimiento"]['total'] ?? "0", 0);
        $numerosMinMax["nv_devolucion"] = ltrim($numerosTipos["Devolucion"]['total'] ?? "0", 0);
        $numerosMinMax["nv_ajuste"] = ltrim($numerosTipos['Correccion']['total'] ?? "0", 0);
        $numerosMinMax["nv_traslado"] = ltrim($numerosTipos["Traslado"]['total'] ?? "0", 0);

        $min_borrado = isset($numerosTipos['Borrado']) ? $numerosTipos['Borrado']['min_num'] : null;
        $min_cancelacion = isset($numerosTipos['Cancelacion']) ? $numerosTipos['Cancelacion']['min_num'] : null;

        /**
         * Todos
         * entradas, salidas, ajuste, cancelada, borrada
         * $total_sum
         */
        // Tipos que queremos sumar
        $tipos_a_sumar = ['Correccion', 'Cancelacion', 'Borrado'];
        $total_sum = 0;

        foreach ($tipos_a_sumar as $tipo) {
            if (isset($numerosTipos[$tipo])) {
                $total_sum += intval($numerosTipos[$tipo]['total']);
            }
        }

        foreach($numerosMinMaxEntradaSalida as $es){
            $total_sum += intval($es["total"]);
        }

        $numerosMinMax["nv_all"] = ltrim($total_sum, '0 ');


        $total = 0;
        if ($min_borrado !== null && $min_cancelacion !== null) {
            $total = (int)$numerosTipos['Borrado']['total'] + (int)$numerosTipos['Cancelacion']['total'];
        } elseif ($min_borrado !== null) {
            $total = (int)$numerosTipos['Borrado']['total'];
        } elseif ($min_cancelacion !== null) {
            $total = (int)$numerosTipos['Cancelacion']['total'];
        }

        $numerosMinMax["nv_cancelacion_borrado"] = ltrim($total, 0);

        $numerosInconsistencias = [];
        if(!$es_verificacion) {
            $numerosInconsistencias = ia_singleton(
                "SELECT /*$method numerosInconsistencias*/ count(DISTINCT nb.nota_bodega_id) total
                    FROM nota_bodega nb
                        JOIN inconsistencia_nota_bodega inb ON nb.nota_bodega_id = inb.nota_bodega_id AND inb.estado = 'Activo'
                    WHERE  nb.bodega_id = " . strit($bodega_id));

        }

        $numerosMinMax["nv_inconsistencia"] = ltrim($numerosInconsistencias['total'] ?? "0", 0);


        $numerosDestinoMatchFail = ia_singleton("select /*$method*/ count(DISTINCT nota_bodega.nota_bodega_id) total from nota_bodega
        JOIN inconsistencia_nota_bodega inb ON inb.nota_bodega_id = nota_bodega.nota_bodega_id
        where nota_bodega.bodega_id = ".strit($bodega_id)." AND inb.tipo_inconsistencia IN ('ayudantes','clientes','pedido_por') AND inb.estado = 'activo'");

        $numerosMinMax["nv_destino_match_fail"] = ltrim($numerosDestinoMatchFail['total'] ?? "0", 0);


        $numerosPina = [];
        if(!$es_verificacion)
            $numerosPina = ia_singleton(
                "SELECT /*$method numerosPina*/ count($count_tota) total FROM nota_bodega WHERE tipo_nota = 'PIÑA' AND bodega_id = " . strit($bodega_id));

        $numerosMinMax["nv_pina"] = ltrim($numerosPina['total'] ?? "0", 0);



        return [
            'status' => TRUE,
            'count' => $numerosMinMax
        ];


    }

}