<?php

namespace ia\Date;


use DateInterval;
use DateTime;
use DateTimeInterface;
use Exception;
use Generator;

class YearMonth {

    /* ///// create a yearMonth ///// */

    public static function yearMonthDeduce($anyDate = 'now') {
        if(empty($anyDate) ||
            (is_string($anyDate) &&
                (strcasecmp($anyDate, 'NOW()') === 0 || strcasecmp($anyDate,'NOW()') === 0 || strcasecmp($anyDate,'today()') === 0)
            )
        ){
            // @codeCoverageIgnoreStart
            return Date('Y-m');
            // @codeCoverageIgnoreEnd
        }
        if($anyDate instanceof DateTimeInterface) {
            return $anyDate->format('Y-m');
        }
        if(is_numeric($anyDate)) {
            return Date('Y-m', $anyDate);
        }
        if(is_string($anyDate) && self::valid($anyDate)) {
            return $anyDate;
        }
        return  Date('Y-m', strtotime($anyDate));
    }


    /* ///// generator ///// */

    /**
     * foreach(yearMonthGenerator('2018-11','2019-04') as $toMonth)
     * $array = iterator_to_array(yearMonthGenerator($from, $to));
     *
     * @param string $from
     * @param string $to
     * @return Generator|void
     * @throws Exception
     */
    public static function yearMonthGenerator(string $from, string $to) {
        $oneMonth = new DateInterval('P1M');
        $current = new DateTime($from.'-01');
        if($from <= $to) {
            while($from <= $to) {
                yield $from;
                $current->add($oneMonth);
                $from = $current->format('Y-m');
            }
            return;
        }
        while($from >= $to) {
            yield $from;
            $current->sub($oneMonth);
            $from = $current->format('Y-m');
        }
    }

    public static function optionsNowTo($yearMonthTo, $yearMonthSelected) {
      $yearMonth = [];
      foreach(self::yearMonthGenerator(Date('Y-m'), $yearMonthTo) as $ym) {
        $yearMonth[$ym] = $ym;
      }
      return optionsKeyValue($yearMonth, $yearMonthSelected);
    }

/* ///// operations, add & substract ///// */

    public static function addYears(string $yearMonth, int $numberOfYears = 1) {
        return  ((int)substr($yearMonth, 0, 4) + $numberOfYears) . substr($yearMonth, 4);
    }

    public static function addMonths(string $yearMonth, int $numberOfMonths = 1) {
        return Date('Y-m',  strtotime( ($numberOfMonths < 0 ? '' : '+') . "$numberOfMonths Month", strtotime("$yearMonth-01")) );
    }


/* ///// validate ///// */

    public static function valid(string $yearMonth, $min = null, $max = null) {
        if(strlen($yearMonth) !== 7) {
            return false;
        }
        $parts = explode('-', $yearMonth);
        if(count($parts) !== 2) {
            return false;
        }
        if(strlen($parts[0]) !== 4 || !is_numeric($parts[0])) {
            return false;
        }
        if(strlen($parts[1]) !== 2 || !is_numeric($parts[1])) {
            return false;
        }
        if($parts[1] < '01' || $parts[1] > '12') {
            return false;
        }
        if(!empty($min)) {
            // todo string, actual, anterior, siguiente, ?
                if($yearMonth < self::yearMonthDeduce($min)) {
                    return false;
                }
        }
        if(!empty($max)) {
                if($yearMonth > self::yearMonthDeduce($max)) {
                    return false;
                }
        }
        return true;
    }

}
