<?php

use Iac\inc\sql\IacSqlBuilder;
use JetBrains\PhpStorm\ExpectedValues;

class aGrupa {
    public readonly string $subGrupoTable;
    public readonly string $elementTable;
    public readonly bool $multipleGroups;
    public readonly string $elementPrimaryKey;
    public readonly string $elementLabel;
    public readonly string $elementSelectFields;
    public readonly string $elementWhere;

    /**
     * @param string $grupo Nombre con que identificar esta agrupación
     */
    public function __construct(public readonly string $grupo) {
        $def = ia_singleton("SELECT * FROM agrupa_def WHERE grupo=" . strit($this->grupo));
        if(empty($def)) {
            throw new Error("Agrupar por $grupo FALTA DEFINIRLO usando aGrupa::define()");
        }
        $this->subGrupoTable = $def['subGrupoTable'];
        $this->elementTable =  $def['elementTable'];
        $this->multipleGroups = !empty($def['multipleGroups']);
        $this->setElement();
    }

    /**
     * @param string $grupo Nombre con que identificar esta agrupación
     * @param string $subGrupoTable Agrupa son valores libres, del contrario sub_grupos son valores de la tabla
     * @param string $elementTable Tabal de Que agrupar: iac_usr, tienda,...
     * @param bool $multipleGroups True un element puede estar en varios grupos, false no puede
     * @return bool
     */
    public static function define(
        string $grupo,
        #[ExpectedValues(['agrupa','bodega','bodega_grupo', 'banco', 'banco_cuenta', 'cuentat', 'empresa','tienda'])]
        string $subGrupoTable = 'agrupa',
        #[ExpectedValues(['bodega', 'banco', 'banco_cuenta', 'cliente', 'cuentat', 'empresa', 'iac_usr','tienda'])]
        string $elementTable = 'iac_usr',
        bool $multipleGroups = false
    ):bool {
        $values = [
          'grupo' => $grupo,
          'subGrupoTable' => $subGrupoTable,
          'elementTable' => $elementTable,
          'multipleGroups' => $multipleGroups
        ];
        $builder = new IacSqlBuilder();
        return ia_query($builder->insert('agrupa_def', $values, true));
    }

    public function get():array {
        $method = __METHOD__;
        $grupo = strit($this->grupo);
        $grouped = ia_sqlSelectMultiKey(
            "SELECT /*$method*/ IF(par.sub_grupo IS NULL, 'Sin', par.sub_grupo) as sub_grupo,
                $this->elementSelectFields, par.alta_db as agrupado_el, par.alta_por as agrupado_por
            FROM $this->elementTable e LEFT OUTER JOIN agrupa par ON e.$this->elementPrimaryKey = par.forId AND par.grupo = $grupo
            WHERE $this->elementWhere
            ORDER BY par.orden, par.grupo,par.sub_grupo,e.$this->elementLabel"
            ,1);
        if(empty($grouped))
            return [];
        $return = $this->subGrupoTable === 'agrupa' ? [] : $this->subGroupValues();
        foreach($grouped as $sub_group => $d)
            $return[$sub_group] = ['id' => $sub_group, 'label' => $sub_group, 'elements' => $d];
        return $return;
    }
    
    public function save($elements):bool {
        $method = __METHOD__;
        $grupo = strit($this->grupo);
        $user = strit($_SESSION['usuario']);
        $orden = 0;
        $sql = [];
        foreach($elements as $v) {
            $values = [];
            $sub_grupo = strit($v['id']);
            $sql[] = "DELETE /*$method*/ FROM agrupa WHERE grupo = $grupo AND sub_grupo = $sub_grupo " .
                " AND forId NOT IN " . $this->buildIn($v['elements'] ?? []);
            if(empty($v['elements']))
                continue;
            foreach($v['elements'] as $forId) {
                $orden++;
                $values[] = "($grupo,NOW(),$user,$sub_grupo,$orden," . strit($forId) . ")";
            }
            $sql[] = "INSERT /*$method*/ INTO agrupa(grupo,alta_db,alta_por,sub_grupo,orden,forId) VALUES" .
                implode(",", $values) . " ON DUPLICATE KEY UPDATE forId=VALUES(forId)";
        }
        return ia_transaction($sql);
    }

    protected function buildIn(array $elements):string {
        $in = [];
        foreach($elements as $e)
            $in[] = strit($e);
        return empty($in) ? "('\t')" : "(" . implode(',', $in) . ")";
    }

    protected function subGroupValues():array {
        $method = __METHOD__;
        switch($this->subGrupoTable) {
            case 'banco':
                $sql = "SELECT /*$method*/ clave FROM banco ORDER BY 1";
                break;
            case 'banco_cuenta':
                $sql = "SELECT /*$method*/ nombre FROM banco_cuenta WHERE vale='Active' ORDER BY 1";
                break;
            case 'bodega':
                $sql = "SELECT /*$method*/ bodega FROM bodega WHERE activo='Si' ORDER BY 1";
                break;
            case 'bodega_grupo':
                $sql = "SELECT /*$method*/ DISTINCT grupo FROM bodega WHERE activo='Si' ORDER BY 1";
                break;
            case 'empresa':
                $sql = "SELECT /*$method*/ empresa FROM empresa WHERE vale='Active' ORDER BY 1";
                break;
            case 'tienda':
                $sql = "SELECT /*$method*/ clave FROM tienda WHERE vale='Active' ORDER BY 1";
                break;
            case 'agrupa';
                $sql = "SELECT /*$method*/ DISTINCT sub_grupo FROM agrupa WHERE grupo=" . strit($this->grupo) . " ORDER BY 1";
                break;
            default:
                return [];
        }
        $return = ia_sqlVector($sql);
        if($return === false)
            return [];
        return array_combine($return, array_fill(0, count($return), []) );
    }

    protected function setElement():void {
        switch($this->elementTable) {
            case 'bodega':
                $this->elementPrimaryKey = 'bodega_id';
                $this->elementLabel = 'bodega';
                $this->elementSelectFields =
                    "e.bodega_id as id, e.bodega as label, e.grupo as title, e.grupo as bodega_grupo, e.empresa_id,
                    (SELECT em.empresa FROM empresa em WHERE e.empresa_id = em.empresa_id) as 'empresa' ";
                $this->elementWhere = "e.activo='Si'";
                break;

            case 'banco':
                $this->elementPrimaryKey = 'banco_id';
                $this->elementLabel = 'clave';
                $this->elementSelectFields =
                    "e.banco_id as id, e.clave as label, e.banco as title";
                $this->elementWhere = "1=1";
                break;

            case 'banco_cuenta':
                $this->elementPrimaryKey = 'banco_cuenta_id';
                $this->elementLabel = 'nombre';
                $this->elementSelectFields =
                    "e.banco_cuenta_id as id, e.nombre as label, 
                     (SELECT mo.moneda FROM moneda mo WHERE e.moneda_id = mo.empresa_id) as title, 
                     e.grupo as bodega_grupo, e.empresa_id,
                    (SELECT em.empresa FROM empresa em WHERE e.empresa_id = em.empresa_id) as 'empresa' ";
                $this->elementWhere = "e.vale='Active'";
                break;

            case 'cliente':
                $this->elementPrimaryKey = 'cliente_id';
                $this->elementLabel = 'nombre';
                $this->elementSelectFields =
                    "e.cliente_id as id, e.nombre as label, e.nombre as title";
                $this->elementWhere = "e.interno='No' AND cliente='1' AND e.vale='Active'";
                break;

            case 'empresa':
                $this->elementPrimaryKey = 'empresa_id';
                $this->elementLabel = 'empresa';
                $this->elementSelectFields =
                    "e.empresa_id as id, e.empresa as label, e.empresa as title";
                $this->elementWhere = "e.vale='Active'";
                break;

            case 'cuentat':
                break;

            case 'iac_usr':
                $this->elementPrimaryKey = 'iac_usr_id';
                $this->elementLabel = 'nick';
                $this->elementSelectFields =
                    "e.iac_usr_id as id, e.nick as label, e.nombre as title, e.usuario_tipo_rony, 
                    IF(e.usuario_tipo_rony = 'Si', 'c_usuarioTipoRony', '') as 'addClass'";
                $this->elementWhere = "e.iac_usr_id > 1 AND e.vale='Active'";
                break;

            case 'tienda':
                $this->elementPrimaryKey = 'tienda_id';
                $this->elementLabel = 'clave';
                $this->elementSelectFields =
                    "e.tienda_id as id, e.clave as label, e.tienda as title, e.empresa_id, 
                    (SELECT em.empresa FROM empresa em WHERE e.empresa_id = em.empresa_id) as 'empresa'";
                $this->elementWhere = "e.vale='Active'";
                break;
        }
    }

}
