<?php
  // https://hash.ai/   Build multi-agent simulations in minutes Free forever. No credit card required.
  // https://www.joelonsoftware.com/2000/05/12/strategy-letter-i-ben-and-jerrys-vs-amazon/

function sortedPathValues($path) {
    $at = [];
    foreach($path as $fieldName => $keyAdd) {
        if(strpos($keyAdd, '_') !== false)
            foreach($at as $keyDone => $_) {
                if(strcasecmp(strstr($keyAdd, '_', true), strstr($keyDone, '_', true)) === 0) {
                    $at[$keyDone][$fieldName] = $keyAdd;
                    continue 2;
                }
            }
        $at[$keyAdd][$fieldName] = $keyAdd;
    }

    $loc =  ponLocal();
    $sorted = [];
    foreach($at as $keys) {
        //asort($keys, SORT_NATURAL | SORT_FLAG_CASE);
        uasort($keys,
            function ($a, $b) {
                return strnatcasecmp($a, $b);
            }
        );
        foreach($keys as $fieldName => $k) {
            $sorted[$fieldName] = $k;
        }
    }
    ponLocal($loc);
    return $sorted;
}

function ponLocal($local = 'ES', $category = LC_COLLATE | LC_CTYPE) {
    if($local === false) return false;
    $loc = setlocale($category, 'es_MX.utf8','es_MX', 'es_LA.utf8','es_LA', 'es_ES.utf8', 'es_ES', 'es.utf8', 'es');
    echo "<li>loc=$loc</li>";
    return $loc;
}

/*

Uso
 1.- code gen
    $coder = new fichaDisplay($keys, ...)
    $coder->jqGridTemplate(displayMode)
    $coder->consultaForm(displayMode)
    $coder->inputForm(displayMode)
  2- live
    $coder = new fichaDisplay($keysPath, ?$keyLabel, $breakRows)
    $coder->jqGridTemplate(displayMode)
    $coder->consultaForm(displayMode, valuesFormatted, data?)
    $coder->inputForm(displayMode, inputHtml, data?)



Variantes
    I.-
        a).- (codeIt) output es <span>$valueFormatted[key]</span> para copy y paste dentro de un echo <<< COSO
        b).- (live) consultas output evalua $valueFormatted[key]

    II.-
        - en data poner o no xyz. o recibir un keyData

    III.-
        - metodo viborita:
            viborita a) solo <div class='flexItem'>..</div>

       - metodo flexCol mezcla con flexRow




 */
/*

0.- falta
  @TODO path separator a variable, default '_'

0.1- checar
  @TODO ajustar cssnewLineTabbed

1.- dudas
  duda #1 funcs sean overridable or callbacks? vs class special extends ficha {}
  duda #2 display funcs con callables o en cada call un switch/case?
  duda #3 simplificar css

2.- definition
  usos: dado un sql table/view/query o un array genera key_path, key_formatted (input)
      a) generar codigo base para modifcar
      b) generar html para formas automaticas

  in
      * key-path  a) [key=>path,..] Tip si tienes [key, key, ...] array_combine($keys, $keys),
        key-label

        key-value_formatted para el input required in b, c.
        key-data
        key-breaks
  out
      a) jqGrid Form template (as code)
      b) algo con <div class='fichaItemValue'>$p[fieldName]</div>  (as code)
      c) despliega realmente los valores actuales

3.- Problems
   pex exceptions
          primary key, hidden
          pwd -
          show:
              image - figure caption
              attachment? - caption
        css
          pex cual item tiene flexrow/flexcol content

   Create -> key/path,keyLabel
      getcss()
      display(input/edit, fieldset/Ul, keyFormattedValue,keyData );

  Helpers Internals?
  key=>forcePath/default,
  MAGIC: controlFileds  => key=>path

  Helpers Externals?
  key=>value, fieldDefinition => formattedValue
  key=>value, fieldDefinition => inputTag
  key=> niceLabel

 */
/*
    <div>
      <div><label for='id' data-for='id' data-got='...'></label></div>
      <div><input id='id'></div>
    </div>
        en radio/check no jqgrid template sera?
          <div>
            <div><input id='id'> <label for='id' data-for='id' data-got='...'></label></div>
          </div>
        en upload no jqgrid template sera?
        en pwd sera?

    vs

      <div>
        <div><span data-for='id' data-got='...'></span></div>
        <div><span></span></div>
      </div>
      en img sera?
      en attachment sera?


 */



  /**
   * Despliega ficha para consultar o editar los key/value con las reglas de format de $fieldDefinition.
   *
   * recomendado mejorar display extender y override
   *     fieldsetStart, fieldsetLabelValueView, fieldsetEnd
   *     ulStart, ulLabelValueView, ulEnd
   *     ulStart, ulLabelValueView, ulEnd
   *
   * Modo online o code generation segun constructor param $insteadDisplayPhpVarName
   */
  class FichaDisplay {
    const DISPLAY_USING_FIELDSET = 'fieldset';
    const DISPLAY_USING_DETAILS = 'details';
    const DISPLAY_USING_UL = 'ul';
    // const DISPLAY_USING_FLEXROW = 'flexRow'; // varias flexRow, como?
    const DISPLAY_USING_VIBORITA = 'viborita'; // flexRow flexItem..... sin anidar

    /** @var array $keyPath = [key1 => path_to_show,] */
    protected $keyPath;

    /** @var array $keyLabel = [key1 => label,] */
    protected $keyLabel;

    /** @var array  $keyValueFormatted [ 'key'=>'1,234.56', 'r'=>'a &gt; b' ] */
    protected $keyValueFormatted;

    /** @var array $breakRowCol */
    protected $breakRowCol;

    /** @var int tabs to indent code */
    protected $tabs = 1;


    public function __construct( array $keyPath, array $keyLabel = [], array $breakRowCol = []) {
      $this->setPath($keyPath);
      $this->setLabel($keyLabel);
      $this->breakRowCol = $breakRowCol;
    }
public function acomoda() { return $this->pathToTree(); }
    /**
     * Template para inline form de jqGrid
     *
     * @param string $nestedType self::DISPLAY_USING_*
     * @return string
     * @see http://www.guriddo.net/documentation/guriddo/javascript/user-guide/editing/#using-templates
     */
    public function jqGridFormTemplate($nestedType = self::DISPLAY_USING_FIELDSET) {
      $formattedValues  = [];
      foreach($this->keyPath as $key => $_) {
        $formattedValues[$key]= '{' . $key . '}';
      }
      return $this->consultas($nestedType, $formattedValues);
    }

    /**
     * Forma de consultas
     *
     * @param string $nestedType self::DISPLAY_USING_*
     * @param array $formattedValues
     * @return string
     */
    public function consultas($nestedType = self::DISPLAY_USING_FIELDSET, $formattedValues = []) {
      $this->keyValueFormatted = $formattedValues;
      $startGroup = null; $labelAndValue = null; $labelAndValue = null;
      $this->displayType($nestedType, true, $startGroup, $labelAndValue, $endGroup);
      return implode("\r\n", $this->fichaDisplay( $this->pathToTree(), $startGroup, $labelAndValue, $labelAndValue ) );
    }

    protected function displayType($nestedType, bool $consultas, &$startGroup, &$labelAndValue, &$endGroup) {
      switch($nestedType) {

        case static::DISPLAY_USING_UL :
          $startGroup = $startGroup ?? [$this, 'ulStart'];
          $labelAndValue = $labelAndValue ?? [$this, 'ulLabelValueView'];
          $endGroup = $endGroup ?? [$this, 'ulEnd'];
          break;
        case self::DISPLAY_USING_DETAILS :
          $startGroup = $startGroup ?? [$this, 'detailsStart'];
          $labelAndValue = $labelAndValue ?? [$this, 'detailsLabelValueView'];
          $endGroup = $endGroup ?? [$this, 'detailsEnd'];
          break;
        case self::DISPLAY_USING_VIBORITA :
          $startGroup = $startGroup ?? [$this, 'viboritaStart'];
          $labelAndValue = $labelAndValue ?? [$this, 'viboritaLabelValueView'];
          $endGroup = $endGroup ?? [$this, 'viboritaEnd'];
          break;
        case self::DISPLAY_USING_FIELDSET :
        default:
          $startGroup = $startGroup ?? [$this, 'fieldsetStart'];
          $labelAndValue = $labelAndValue ?? [$this, 'fieldsetLabelValueView'];
          $endGroup = $endGroup ?? [$this, 'fieldsetEnd'];
      }
    }
////////////////////////////////////////////////////
/// helpers
////////////////////////////////////////////////////
    protected function setPath(array $keyPath) {
      if($this->is_vector($keyPath)) {
        $this->keyPath = array_combine($keyPath, $keyPath);
        return;
      }
      $this->keyPath = [];
      foreach($keyPath as $key => $path) {
        $this->keyPath[$key] = $path ?? $key;
      }
    }

    protected function setLabel(array $keyLabel) {
      $this->keyLabel = [];
      foreach($this->keyPath as $key => $_) {
        $this->keyLabel[$key] = $keyLabel[$key] ?? $this->toLabel($key);
      }
    }

    protected function toLabel(string $key):string {
      if(empty($key)) {
        return $key;
      }
      $key[0] = mb_convert_case($key[0], MB_CASE_LOWER);
      $snakeCase = mb_convert_case(preg_replace("/([A-ZÁÉÍÓÚÑ])/u", "_$1", $key), MB_CASE_LOWER);
      $label = preg_replace('/[\s_]+/uiS', ' ', $snakeCase);
      return ucwords($label);
    }

    /**
     *
     * @param array $array
     * @return bool true array has consecutive integer keys starting at 0, false it is a hashmap
     */
    protected function is_vector(array $array):bool {
      return count($array) === count(array_intersect_key($array, array_keys($array) ) );
    }

    /**
     * Regresa el label de existir en $this->keyLabel o key de no existir, protegido por htmlentities
     *
     * @param string $key
     * @return string
     */
    protected function getLabelHtml(string $key):string {
      return htmlentities( $this->keyLabel[$key] ?? $this->toLabel($key) );
    }

    /**
     *
     * @param string $key
     * @param string $default
     * @return string
     */
    protected function getValueFormated(string $key, $default = '') {return $this->keyValueFormatted[$key] ?? $default;}

    protected function changeBeforeGroup(string $key):string  {
      return empty($this->breakRowCol[$key]) ? '' : '<div class="fichaDisplayFlexRowBreak"></div>';
    }

    protected function newLineTabbed(int $numberOfTabs):string  {
      return "\r\n" . str_repeat("\t", $numberOfTabs >= 0 ? $numberOfTabs : 1);
    }

///////////////////////////////////////////
/// Eliminar a hoja css
///////////////////////////////////////////

    /**
     *
     * @return string <style>block con las classes usadas
     */
    public function getCssStyleTag() {
      return <<< CSS_STYLES
    <style>
        .fichaDisplayFlexRow {
            display: flex; /* or inline-flex */
            display: -webkit-box;   /* OLD - iOS 6-, Safari 3.1-6, BB7 */
            display: -ms-flexbox;  /* TWEENER - IE 10 */
            display: -webkit-flex; /* NEW - Safari 6.1+. iOS 7.1+, BB10 */
            flex-direction: row;flex-wrap:wrap;justify-content: flex-start;align-content: flex-start;align-items: flex-start;        
        }
        .fichaDisplayFlexRowBreak {flex-basis: 100%;height: 0;}

        .fichaDisplayFlexCol {
            display: flex; /* or inline-flex */
            display: -webkit-box;   /* OLD - iOS 6-, Safari 3.1-6, BB7 */
            display: -ms-flexbox;  /* TWEENER - IE 10 */
            display: -webkit-flex; /* NEW - Safari 6.1+. iOS 7.1+, BB10 */
            flex-direction: column;flex-wrap:wrap;justify-content: flex-start;align-content: flex-start;align-items: flex-start;        
        }    
        .fichaDisplayFlexColBreak {flex-basis: 100%;width: 0;}
        
        .fichaDisplayFlexItem {flex: 0 1 auto;padding-left:0.5em;padding-right:0.5em; text-align:left;}
            
        .fichaDisplayLabel {color:blue}
        .fichaDisplayValue {color:black}
                
        .fichaDisplayFieldset {border-color:lightblue; }   
        .fichaDisplayLegend {color:blue;}
        
        .fichaDisplayUlSection {color:darkblue;}
        .fichaDisplayUlChild {color:darkblue;}
        .fichaDisplayLILabelValue {color:blue; list-style-type: "* ";}
        
        .fichaDisplayDetails {margin-left:1em;}
        .fichaDisplaySummary {color:green;}
        .fichaDisplayDiv {margin-left:1.5em}
        .fichaDisplayDetailsItem {padding:0.5em}
    </style>       
CSS_STYLES;
    }

///////////////////////////////////////////
/// Display functions, extend this class and override them
///////////////////////////////////////////

    /** @noinspection PhpUnused */
    protected function inputBlock($key, $label, $inputTag) {
      $tab1 = $this->newLineTabbed($this->tabs + 2);
      return
        $tab1 . "<div data-fichaitem='$key' class='fichaDisplayFlexItem'><div data-fichalabelposition='$key'>" . // class = fichaDisplayFlexCol o fichaDisplayFlexRow
        $tab1 . "\t<div><label for='$key' data-fichafor='$key' class='fichaDisplayLabel'>$label</label></div> " .
        $tab1 . "\t<div data-fichaid='$key' class='fichaDisplayInput'>$inputTag</div>" .
        $tab1 . "</div></div>";
    }

    protected function viewBlock(string $key, string $label, string $formattedValue):string {
      $tab1 = $this->newLineTabbed($this->tabs + 2);
      return
        $tab1 . "<div data-fichaitem='$key' class='fichaDisplayFlexItem'><div data-fichalabelposition='$key'> " . // class = fichaDisplayFlexCol o fichaDisplayFlexRow
        $tab1 . "\t<div><span data-fichafor='$key' class='fichaDisplayLabel'>$label</span></div>" .
        $tab1 . "\t<div data-fichaid='$key' class='fichaDisplayValue'>$formattedValue</div>" .
        $tab1 . "</div></div>";
    }


    //// viborita, todos los campos en el flex row inicial /////////////////////////////////////////////////////////////////////////

      /** @noinspection PhpUnused */
      protected function viboritaStart(string $key, string $shortLabel):string {
        return  $this->newLineTabbed($this->tabs) . $this->changeBeforeGroup($key);
      }

      /** @noinspection PhpUnused */
      protected function viboritaLabelValueView(string $key, string $shortLabelKey):string {
        return $this->viewBlock($key, $this->getLabelHtml($key), $this->getValueFormated($key));
      }

      /** @noinspection PhpUnused */
      protected function viboritaEnd():string {
        return '';
      }

    //// Fieldset /////////////////////////////////////////////////////////////////////////////////////////////////////////////////

      /** @noinspection PhpUnused */
      protected function fieldsetStart(string $key, string $shortLabel):string {
        $this->tabs++;
        return  $this->newLineTabbed($this->tabs) .
                $this->changeBeforeGroup($key) .
                $this->newLineTabbed($this->tabs) . "<fieldset class='fichaDisplayFieldset'>" .
                $this->newLineTabbed($this->tabs + 1) . "<legend  class='fichaDisplayLegend'>" .
                  $this->getLabelHtml($key) . "</legend>" .
                $this->newLineTabbed($this->tabs + 1) ."<div class='fichaDisplayFlexRow'>";
      }

      /** @noinspection PhpUnused */
      protected function fieldsetLabelValueView(string $key, string $shortLabelKey):string {
        return $this->viewBlock($key, $this->getLabelHtml($shortLabelKey), $this->getValueFormated($key));
      }

    /** @noinspection PhpUnused */
    protected function fieldsetLabelInput(string $key, string $shortLabelKey):string {
      return $this->inputBlock($key, $this->getLabelHtml($shortLabelKey), $this->getValueFormated($key));
    }

      /** @noinspection PhpUnused */
      protected function fieldsetEnd():string {
          $this->tabs--;
          return  $this->newLineTabbed($this->tabs + 2) . "</div>" .
            $this->newLineTabbed($this->tabs + 1) . "</fieldset>";
      }

    //// UL //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

      /** @noinspection PhpUnused */
      protected function ulStart(string $key, string $shortLabel):string {
        $this->tabs += 2;
        return $this->newLineTabbed($this->tabs - 1) . "<li class='fichaDisplayUlSection'>" .
          $this->getLabelHtml($key) . $this->newLineTabbed($this->tabs) . "<ul class='fichaDisplayUlChild'>";
      }

      /** @noinspection PhpUnused */
      protected function ulLabelValueView(string $key, string $shortLabelKey ):string {
        return $this->newLineTabbed($this->tabs + 1) . "<li class='fichaDisplayLILabelValue fichaLILabelValue'>" .
          $this->newLineTabbed($this->tabs + 2)  . "<span class='fichaDisplayLabel'>" . $this->getLabelHtml($key) . "</span>: " .
          $this->newLineTabbed($this->tabs + 2)  . "<span class='fichaDisplayValue'>" . $this->getValueFormated($key) . "</span>";
      }

      /** @noinspection PhpUnused */
      protected function ulEnd():string {
        $this->tabs -= 2;
        return  $this->newLineTabbed($this->tabs + 2) . "</ul>";
      }

    //// Details //////////////////////////////////////////////////////////////////////////////////////////////////////////////////

      /** @noinspection PhpUnused */
      protected function detailsStart(string $key, string $shortLabel):string {
        $this->tabs++;
        $breakLine = $this->changeBeforeGroup($key);
        return "$breakLine<details class='fichaDisplayDetails'><summary class='fichaDisplaySummary'>" . $this->getLabelHtml($key) . "</summary><div class='fichaDisplayDiv'>";
      }

      /** @noinspection PhpUnused */
      protected function detailsLabelValueView(string $key, string $shortLabelKey ):string {
        return $this->viewBlock($key, $this->getLabelHtml($shortLabelKey), $this->getValueFormated($key));
      }

      /** @noinspection PhpUnused */
      protected function detailsEnd():string { $this->tabs--; return  "</div></details>"; }

///////////////////////////////////////////
///
///////////////////////////////////////////

    /**
     *
     * @param array $tree
     * @param callable $startGroup callable function to use, null uses internal function
     * @param callable $labelAndValue callable function to use, null uses internal function
     * @param callable $endGroup callable function to use, null uses internal function
     * @return array
     */
    protected function fichaDisplay($tree, $startGroup, $labelAndValue, $endGroup): array
    {
      $html = [];
      foreach($tree as $key => $value) {
        if(!empty($value['_leaf'])) {
          $html[] = call_user_func($labelAndValue, $value['_key'], $value['_path']);
          continue;
        }

        if($key === '') {
          foreach($this->fichaDisplay($value, $startGroup, $labelAndValue, $endGroup) as $tmp)
            $html[] = $tmp;
          continue;
        }

        if(is_array($value)) {
          if(!empty($value['childs'])) {
            $html[] = call_user_func($startGroup, $value['_key'] ?? $key, $key);
            if(array_key_exists('_key', $value) && $value['_key'] === $value['_pathCurrent']) {
              $html[] = call_user_func($labelAndValue, $value['_key'], $key);
            }
            foreach($this->fichaDisplay($value['childs'], $startGroup, $labelAndValue, $endGroup) as $tmp) {
              $html[] = $tmp;
            }
            $html[] = call_user_func($endGroup);
          } elseif(array_key_exists('_key', $value) && array_key_exists($value['_key'], $this->keyValueFormatted)) {
              $html[] = call_user_func($labelAndValue, $value['_key'], $key);
          }
        }
      }
      return $html;
    }


    /**
     *
     * @return array
     */
    public function pathToTree():array {
      $tree = [];
      foreach($this->keyPath as $key => $d) {
        if($d === '' || $d === null) {
          $tree[$key] = $key;
          continue;
        }
        $pointer = &$tree;
        $path = explode('_', $d);
        $len = count($path);
        $iPath = 1;
        $currentPath = '';
        foreach( $path as $p) {
          $currentPath .= ($currentPath === '' ? '' : '_') . $p;
          if(!isset($pointer[$p])) {
            if( $iPath === 1)
                $pointer[$p] = ['_leaf' => true, '_path' => $d, '_key' => $key];
            else
              $pointer[$p] = [];
          } elseif($iPath === 1) {
             $pointer[$p]['_leaf'] = false;
          }
          $pointer[$p]['_pathCurrent'] = $currentPath;

          if($iPath === $len) {
            $pointer[$p]['_key'] = $key;
            continue;
          }
          $iPath++;

          if(!isset($pointer[$p]['childs'])) {
            $pointer[$p]['childs'] = [];
          }
          $pointer = &$pointer[$p]['childs'];
        }
      }
      // echo "<pre>" . print_r($tree, true) . "</pre>";
      return $tree;
    }

  }
