<?php
// CAMBIO: parentesis en groups
// Operator NOT supported

//@TODO match against
//@TODO like protect?
//@TODO: recognize function from queryBuilder
//@TODO: params?
/**
 * jQGrid filter and _searchField to sql where
 *
 * @version 1.0.2
 * @copyright 2017
 */

/** @noinspection PhpUnused */

namespace ia\JqGrid;
use ia\Util\Str;

/**
 * Class Filter2where jQGrid filter and _searchField to sql where
 * @package ia\JqGrid
 */
class Filter2whereStatic {

    /**
     * @var array Translate from gird operators to jqGrid standard operators, serves as valid operator list
     */
    protected static  $opToStandard = [
        'eq' => 'eq',
        'ne' => 'ne',
        'lt' => 'lt',
        'le' => 'le',
        'gt' => 'gt',
        'ge' => 'ge',

        'bw' => 'bw',  // begins with
        'bn' => 'bn',  // not begins with
        'cn' => 'cn',  // contains
        'nc' => 'nc',  // not contains
        'ew' => 'ew',  // ends with
        'en' => 'en',  // not ends

        'in' => 'in',  // is in set
        'ni' => 'ni',  // is not in set
        'not in' => 'ni',  // is not in set

        'nu' => 'nu',  // is null
        'nn' => 'nn',  // not null

        'is null' => 'nu',  // is null
        'is not null' => 'nn',  // not null
    ];

    /**
     * @var array
     */
    protected static  $opOperator = [
        'eq' => '=',
        'ne' => '<>',
        'lt' => '<',
        'le' => '<=',
        'gt' => '>',
        'ge' => '>=',

        '=' => '=',
        '<>' => '<>',
        '<' => '<',
        '<=' => '<=',
        '>' => '>',
        '>=' => '>=',

        'in' => '=',  // fallback por si no mandan array con in clause
        'ni' => '<>', // fallback por si no mandan array con in clause
    ];

    /**
     * iaFilter2where static methods, prohibit constructor.
     */
    private function __construct() {
    }


    /**
     * Converts an array to postData.filter
     *
     * @param array $array ['field1'=>'value1',...]
     * @param string $groupOp AND, OR, ...
     * @param string $op eq, gt, ...
     * @return array ['groupOp'=>$groupOp, 'rules'=>[['field1' => 'field1', 'op' => $op, 'data' => 'value1], ... ]]
     */
    public static function array2Filter($array, $groupOp = 'AND', $op = 'eq') {
        if(empty($array)) {
            return [];
        }
        $rules = [];
        foreach($array as $fieldName => $value) {
            $rules[] = ['field' => $fieldName, 'op' => $op, 'data' => $value];
        }
        return  ['groupOp' => $groupOp, 'rules' => $rules];
    }

    /**
     * Converts a jqGrid postData.filter to an sql where clause
     *
     * @param string|array $filters a json string or array from postData.filter
     * @param string $groupOp AND or OR
     * @param null|callable $filterFieldOverride function($ruleSolved):string
     *      param array ruleSolved ['field'=>'fieldName', 'op'=>'eq', 'data'=>'value', 'clause'=>'(a=3)']
     *      return string sql clause or '' = don't filter
     *      example rule2sql($r, 'overrideClause'); function overrideClause($ruleSolved);
     *      example rule2sql($r, [$reFilter, "overrideClause"]); class reFilter { public function overrideClause($ruleSolved);}
     *      example rule2sql($r, "reFilter::overrideClause"); class reFilter { public static function overrideClause($ruleSolved);}
     * @return string an sql where clause
     */
    public static function filter2where($filters, $groupOp = 'AND', $filterFieldOverride = null) {
        if(empty($filters)) {
            return '';
        }
  //   echo "<pre>filters in=".print_r($filters,true);
        if(is_string($filters)) {
            $filters = json_decode($filters, true);
        }

        $where = '';
     //   echo "<pre>req=".print_r($_REQUEST,true);
     //   echo "<pre>filters qyeda=".print_r($filters,true);
        foreach($filters as $key => $f) {
            if(empty($f)) {
                continue;
            }
            if($key === 'groupOp') {
                $groupOp = Str::strim($f);
            } elseif($key === 'rules') {
                $clause = self::rules($f, $groupOp, $filterFieldOverride);

                if(!empty($clause)) {
                    $where .= empty($where) ? $clause : " $groupOp $clause";
                }
            } elseif($key === 'groups') {
                if(array_key_exists('rules', $f)) {
                    $clause = self::filter2where($f, $groupOp, $filterFieldOverride);
                    if(!empty($clause)) {
                        $where .= empty($where) ? $clause : "$groupOp ( $clause ) ";
                    }
                } else
                    foreach($f as $g) {
                        $clause = self::filter2where($g, $groupOp, $filterFieldOverride);
                        if(!empty($clause)) {
                            $where .= empty($where) ? " $clause" : " $groupOp ( $clause ) ";
                        }
                    }
            }
        }
        if(empty($where))
            return '';
        return strcasecmp('NOT',$groupOp) ? $where : 'NOT ' . $where;
    }

    /**
     * A wrapper function for self::rule2sqlDo so $filterFieldOverride may override the result
     *
     * @param array $r ['field'=>'fieldName', 'op'=>'eq', 'data'=>'value'] standard from jqGrid's postdata.filter.*.rule
     * @param null|callable $filterFieldOverride function($ruleSolved):string
     *      param array ruleSolved ['field'=>'fieldName', 'op'=>'eq', 'data'=>'value', 'clause'=>'(a=3)']
     *      return string sql clause or '' = don't filter
     *      example rule2sql($r, 'overrideClause'); function overrideClause($ruleSolved);
     *      example rule2sql($r, [$reFilter, "overrideClause"]); class reFilter { public function overrideClause($ruleSolved);}
     *      example rule2sql($r, "reFilter::overrideClause"); class reFilter { public static function overrideClause($ruleSolved);}
     * @return string
     */
    public static function rule2sql($r, $filterFieldOverride = null) {
        $clause = self::rule2sqlDo($r);
        if($filterFieldOverride === null || $clause === '') {
            return $clause;
        }

        $r['clause'] = $clause;
        return call_user_func($filterFieldOverride, $r);
    }

    /**
     * Translate from gird operators to jqGrid standard operators, serves as valid operator list
     *
     * @return array ['eq'=>'eq','ne'=>'ne',...]
     */
    public static function getOpToStandard() {
        return self::$opToStandard;
    }

    /**
     * Simple operator substition from gridOperators (eq) to sql operators(=)
     *
     * @return array jaGrid standard operator to sql operator ['eq'=>'=','gt'=>'>=',...]
     */
    public static function getOpOperator() {
        return self::$opOperator;
    }

    protected static function rules(&$rules, $groupOp, $filterFieldOverride) {
        $where = '';
        if(is_array($rules) && !empty($rules))
            foreach($rules as $r) {
                if(array_key_exists('Data',$r) ) {
                    $r['data'] = $r['Data'];
                }
                $clause = self::rule2sql($r, $filterFieldOverride);

                if(!empty($clause)) {
                    $where .= empty($where) ? ' ' . $clause : ' ' . $groupOp . ' ' . $clause;
                }
            }
        return empty($where) ? '' : '('.$where.')';
    }

    /**
     * @param $r ['field'=>'fieldName', 'op'=>'eq', 'data'=>'value'] standard from jqGrid's postdata.filter.*.rule
     * @return string
     */
    protected static function rule2sqlDo($r) {
        if(!array_key_exists('field',$r) || !array_key_exists('op',$r) || !array_key_exists('data',$r) ) {
            // missing a field, malformed filter
            return '';
        }
        $fieldSent = Str::strim($r['field']);
        if(empty($fieldSent)) {
            return '';
        }
        $field = Str::fieldit($fieldSent);

        $op = strtolower(Str::strim($r['op']));
        if(empty($op)) {
            return '';
        }
        if(isset(self::$opToStandard[$op])) {
            $op = self::$opToStandard[$op];
        }

        if(($op === 'in' || $op === 'ni') && !is_array($r['data'])) {
            if(substr($r['data'],0,1) === ',') {
                $r['data'] = substr($r['data'],1);
            }
            $r['data'] = explode(',', $r['data']);
        }
        if(is_array($r['data']) ) {
            $data = '';
            foreach($r['data'] as $d) {
                $data .= ','.Str::strit($d);
            }
            if(empty($data)) {
                return '';
            }
            return $field.($op === 'ni' ? ' NOT IN(' : '  IN(').substr($data,1).')';
        }

        if(array_key_exists($op,self::$opOperator)) {
            /** @noinspection PhpParamsInspection */
            $value = Str::strim($r['data']);
            if(!self::isDate($value)) {
                return $field . ' ' . self::$opOperator[$op] . Str::strit($value);
            }
            return self::fixDate2DateTime($field, self::$opOperator[$op], $value);
        }

        /** @noinspection PhpParamsInspection */
        $value = Str::strlike(Str::strim($r['data']));
        if($op === 'bw') {
            return $field.' LIKE '.Str::strit($value.'%');
        }
        if($op === 'bn') {
            return $field.' NOT LIKE '.Str::strit($value.'%');
        }
        if($op === 'cn') {
            return $field.' LIKE '.Str::strit('%'.$value.'%');
        }
        if($op === 'nc') {
            return $field.' NOT LIKE '.Str::strit('%'.$value.'%');
        }
        if($op === 'ew') {
            return $field.' LIKE '.Str::strit('%'.$value);
        }
        if($op === 'en') {
            return $field.' NOT LIKE '.Str::strit('%'.$value);
        }

        if($op === 'nu') {
            return "$field IS NULL";
        }
        if($op === 'nn') {
            return "$field IS NOT NULL";
        }
        return '';
    }

    protected static function isDate($value) {
        if(strlen($value) !== 10 || strpos($value, '-') === false) {
            return false;
        }
        if($value[4] !== '-' || $value[7] !== '-' ) {
            return false;
        }
        $dateParts = explode('-', $value);
        if(count($dateParts) !== 3) {
            return false;
        }
        return checkdate($dateParts[1], $dateParts[2], $dateParts[0]);
    }

    protected static function fixDate2DateTime($field, $op, $value) {
        switch($op) {
            case '=':
                return " $field BETWEEN ".Str::strit($value). " AND " .Str::strit("$value 23:59:59.99999"). ' ';
                break;
            case '<>':
                return " $field NOT BETWEEN ".Str::strit($value). " AND " .Str::strit("$value 23:59:59.99999"). ' ';
            case '>':
            case '>=':
                return " $field $op ".Str::strit($value);
                break;

            case '<=':
                return " $field $op ".Str::strit("$value 23:59:59.99999");
                break;
            case '<':
            default:
                return " $field $op ".Str::strit($value);
        }
    }

}
