<?php
  /**
   * JqGridRead Helps respond to jqGrid with an array
   * @version 1.0.1
   */

  /**
   * usage:

      try {
          // permisos, seguridad
          // obtener $arrayData
          $totals = ['income' => jqGridArray::TOTALS_SUM | TOTALS_COUNT];       // optional
          $xlsxDataType = ['colName' => [jqGridArray::TYPE_*, headerTitle], ]  // optional
          $grid = new jqGridArray('reportName');
          $grid->processRead($arrayData, $totals, $xlsxDataType); //json response sent or file download done
      } catch(\Throwable $e) {

      }

    usage 2: para hacerlo manual ver $grid->processRead

    usage 3: se pueden usar directo array export to cvs,xlsx,pdf

    usage 4: filter an array
        $grid = new jqGridArray('reportName');
        $filtered = $grid->filter($jqGridFilter, $data);

    usage 5: sort an array
        $grid = new jqGridArray('reportName');
        $grid->sort(&$array, $orderByClause); ie $grid->sort($data, "a,b DESC, c");



    .jqGrid({
        footerrow:true,
        userDataOnFooter:true,
    })
    .jqGrid("navSeparatorAdd")
    .jqGrid("navButtonAdd",{caption:"xlsx", title:"Exporta en excel",
      buttonicon:'fa-file-excel',
      commonIconClass:'far',
      iconsOverText:true,
      onClickButton:function(){
          var $grid = $(this),params = $grid.jqGrid('getGridParam', 'postData');
          params.oper = 'xlsx';
          iac.openWindowWithPost($grid.jqGrid('getGridParam', 'url'), params);
      }
    })
    .jqGrid("navButtonAdd",{caption:"pdf", title:"en PDF",
      buttonicon:'fa-file-pdf',
      commonIconClass:'far',
      iconsOverText:true,
      onClickButton:function(){
          var $grid = $(this),params = $grid.jqGrid('getGridParam', 'postData');
          params.oper = 'pdf';
          iac.openWindowWithPost($grid.jqGrid('getGridParam', 'url'), params);
      }
    })
    .jqGrid("navButtonAdd",{caption:"csv", title:"Exporta separados por comas, lo puede leer excel",
      buttonicon:'fa-file-csv',
      commonIconClass:'fas',
      iconsOverText:true,
      onClickButton:function(){
          var $grid = $(this),params = $grid.jqGrid('getGridParam', 'postData');
          params.oper = 'csv';
          iac.openWindowWithPost($grid.jqGrid('getGridParam', 'url'), params);
      }
    })
    ;


   */


namespace ia\JqGrid;

use ia\Lib\iaTableIt;

//@TODO xlsx deduce column types if not given
//@TODO params _search, search use them if filled

//@TODO pdf footer, header con title, css repeat table headers
class jqGridArray {
    const TOTALS_SUM = 1;
    const TOTALS_COUNT = 2;

    const TYPE_INT = 'integer';
    const TYPE_INT_COMA = '#,##0';
    const TYPE_MONEY = '[$$-1009]#,##0.00;[RED]-[$$-1009]#,##0.00';
    const TYPE_CURRENCY = '[$$-1009]#,##0.00;[RED]-[$$-1009]#,##0.00';
    const TYPE_DECIMAL_2 = '#,##0.00;[RED]-#,##0.00';
    const TYPE_DATE = 'date';
    const TYPE_DATE_TIME = 'date';
    const TYPE_GENERAL = 'string';
    const TYPE_STRING = 'string';

    const ERROR_NOT_IMPLEMENTED = 1;
    const ERROR_DB_ERROR = 2;
    const ERROR_PERMISSION = 3;

    /** @var string */
    protected $downloadFileName;

    /** @var array ['index'=>bool,...] bool is: true=>Ascending, false: descending */
    protected $orderBy;


    protected function stringNormalize($s) {
        if(empty($s))
            return $s;
        return trim(strtolower($s));
    }
    protected function toLabel($s) {
        if(empty($s))
            return $s;
        return trim(strtolower($s));
    }

    /**
     *
     * @param String $downloadFileName, sin extension
     */
    public function __construct($downloadFileName = 'download'){
        $this->downloadFileName = $downloadFileName;
    }

    public function processRead($array, $totals = [], $dataType = [], $columnTitles = []) {
        $params = $this->readParams();
        $filters = $params['filters'];
        if(!empty($filters)) {
            $array = $this->filter(json_decode($filters, true), $array);
        }

        $orderBy = trim("$params[sidx] $params[sord]");
        if(!empty($orderBy) && strcasecmp('asc',  strtolower($orderBy))!==0 &&
          strcasecmp('desc',  strtolower($orderBy))!==0)
        {
          $this->sort($array, $orderBy);
        }
        switch(strtolower($params['oper'])) {
            case '':
            case 'read':
                $this->jqGridSend($array, $totals, $params);
                break;
            case 'csv':
                $this->csvExport($array, $columnTitles, $this->downloadFileName);
                break;
            case 'pdf':
                $this->pdfExport($array, $this->downloadFileName);
                break;
            case 'xlsx':
            case 'xls':
                $this->xlsxExport($array, $dataType, $this->downloadFileName);
                break;
            default:
                $this->sendError(self::ERROR_NOT_IMPLEMENTED,"Operation $params[oper] not implented");
        }
    }

    public function jqGridSend($array, $totals, $params =[]) {
        if(empty($params)) {
            $params = $this->readParams();
        }
        $totalRecords = count($array);
        $rows = (int)$params['rows'];

        if(empty($rows) || !is_numeric($rows) || $rows <=0 || $totalRecords <= $rows  || 0 === $totalRecords) {
            $sendingPageNumber = 1;
            $totalPages = 1;
            $sendRows = $array;
        } else {
            $sendRows = array_slice($array, $this->sliceFrom($params), $rows, false );
            $totalPages = $rows <= 0 ? 1 :  max( ceil((float)$totalRecords/$rows),1);
            $sendingPageNumber = $params['page'] > $totalPages ? $totalPages : $params['page'];
        }
        echo json_encode([
            'rows' => array_values($sendRows),
            'page' => $sendingPageNumber,
            'total' => $totalPages,
            'records' => $totalRecords,
            'userdata' => $this->totals($array, $totals),
        ]);
    }

    public function pdfExport($array, $fileNameNoExtension, $orientation = '') {
        $fechayhora = Date('d/m/Y G:i');
        $footer = '  <!--mpdf
                <htmlpagefooter name="myfooter">
                <div style="border-top: 1px solid #000000; font-size: 10pt; text-align: right; padding-top: 3mm; ">
                    <b>'.$fechayhora.'</b>, pag <b>{PAGENO}</b> de <b>{nb}</b>
				</div>
				</htmlpagefooter>
				<sethtmlpagefooter name="myfooter" value="on" />
                mpdf-->';
        if(empty($orientation)) {
            $firstRow = reset($array);
            $orientation = count($firstRow) > 5 ? 'L' : 'P';
        }

        $pdfOptions = [
    			'mode' => 'UTF-8',
    			'format' => 'LETTER',
    			'default_font_size' => 0,
    			'default_font' => '',
    			'margin_left' => 15,
    			'margin_right' => 15,
    			'margin_top' => 10,
    			'margin_bottom' => 10,
    			'margin_header' => 9,
    			'margin_footer' => 9,
    			'orientation' => $orientation,
                //'default_font' => 'dejavusans',
    		];
    	$mpdf = new \Mpdf\Mpdf($pdfOptions);
    	$mpdf->SetDisplayMode('fullpage');
    	$mpdf->list_indent_first_level = 0;	// 1 or 0 - whether to indent the first level of a list
    	$html = '<!DOCTYPE html><html><head><title></title><style>' . iaTableIt::getCssClases() . '</style></head><body>' .
            iaTableIt::getTableIt($array) . '</body></html>';
    	$mpdf->WriteHTML($html);
    	$mpdf->Output("$fileNameNoExtension.pdf", \Mpdf\Output\Destination::INLINE);
    }

    public function xlsxExport($array, $headers, $fileNameNoExtension) {
        if(empty($headers)) {
            $firstRow = reset($array);
            foreach($firstRow as $columnName => $value) {
                $type = self::TYPE_GENERAL;
                if(is_numeric($value)) {
                  $type = is_float($value) ? self::TYPE_CURRENCY : self::TYPE_INT_COMA;
                }
                $headers[$columnName] = $type; //@TODO deducir tipo de dato
            }
        }
        $writer = new \XLSXWriter();
        $writer->writeSheetHeader('Sheet1', $headers );
        foreach($array as $row) {
	        $writer->writeSheetRow('Sheet1', $row );
         }

        header('Content-Disposition: attachment; filename="'. $fileNameNoExtension .'.xlsx"');
        header("Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");

        header('Content-Transfer-Encoding: binary');
        header('Cache-Control: must-revalidate');
        header('Pragma: public');

        $writer->writeToStdOut();
    }

    public function csvExport($array, $columnTitles, $fileNameNoExtension) {
        header("Content-Type: text/html; charset=utf-8");
        header("Cache-Control: no-store, no-cache");
        header("Content-Disposition: attachment; filename*=UTF-8''".$fileNameNoExtension.".csv");
        //header('Content-disposition: attachment; filename="'. strtolower($fileNameNoExtension) .'.csv"');

        $columnTitles = $this->columnTitles($array, $columnTitles);
        $row = [];
        foreach($columnTitles as $label) {
            $row[] = $this->csvProtect($label);
        }
        echo implode(',', $row)."\r\n";

        if(is_array($array)) {
            foreach($array as $rec) {
                $row = [];
                foreach($rec as $fieldName=>$v) {
                    if( is_bool($v)) {
                        $row[] = $v ? 'true' : 'false';
                    } elseif( is_numeric($v) ) {
                        $row[] = $v;
                    } else {
                        $row[] = $this->csvProtect($v);
                    }
                }
                echo implode(',', $row)."\r\n";
            }
            return true;
        }
        return false;
    }

    protected function csvProtect($s, $escapeChar = "\\") {
        return $s === null ? '""' : '"' . str_replace('"', $escapeChar.'"', $s) . '"';
    }

    public function totals($array, $totals) {
        $totalValues = [];
        foreach($totals as $key => $action) {
            switch($action) {
                case self::TOTALS_SUM:
                  $totalValues[$key] = array_sum(array_column($array, $key));
                    break;
                case self::TOTALS_COUNT:
                  $totalValues[$key] = count($array);
                    break;
                default:
                  $totalValues[$key] = $action;
            }
        }
        return $totalValues;
    }

    public function setOrderBy($orderBy) {
        $this->orderBy = $this->orderByPrepare($orderBy);
    }

    protected function sliceFrom($params) {
        if( empty($params['page']) || !is_numeric($params['page']) || $params['page']<=0) {
            $params['page']=1;
        }
        $start = $params['rows'] * $params['page'] - $params['rows'];
        if($start <0) {
            return $start = 0;
        }
        return $start;
    }

    public function sort(&$array, $orderByClause) {
        if(empty($orderByClause)) {
            return true;
        }
        $this->orderBy = $this->orderByPrepare($orderByClause);
        return uasort($array, [$this, 'sortRow']);
    }


    /**
     * Array callback comparison function
     *
     * @param array $a
     * @param array $b
     * @return int  negative: $a < $b, zero: $a == $b, positive $a > $b
     */
    protected function sortRow($a, $b){
        foreach($this->orderBy as $clause) {
            $fieldName = $clause[0];
            if(!isset($a[$fieldName])) {
              return 0;
            }
            $lhs = $a[$fieldName];
            $rhs = $b[$fieldName];
            if(is_numeric($lhs) && is_numeric($rhs)) {
                if($lhs == $rhs) {
                    continue;
                }
                if($clause[1]) {
                    return $lhs - $rhs;
                }
                return $rhs - $lhs;
            }
            //$lhs = urilfiyt
            //$rhs = urilfiyt
            $da = strcmp($lhs, $rhs);
            if($da === 0) {
                continue;
            }
            if($clause[1]){
                return $da;
            }
            return -1 * $da;
        }
        return 0;
    }


    /**
     *
     * @param string $orderByClause
     * @return array ['index'=>bool,...] bool is: true=>Ascending, false: descending
     */
    protected function orderByPrepare($orderByClause) {
        $orderByClause = trim(str_ireplace('order by', '', $orderByClause));
        $orderBy = [];
        foreach(explode(',', $orderByClause ) as $d) {
            $clause = explode(' ', trim($d));
            switch(count($clause)) {
                case 0: continue 2; break;
                case 2: $orderBy[] = [$clause[0], strcasecmp('DESC', $clause[1]) !== 0 ]; break;
                default: $orderBy[] = [$clause[0], true]; break;
            }
        }
        return $orderBy;
    }

  /**
   * @param $filter
   * @param $array
   * @return array
   */
    protected function filterArray($filter, $array) {
        if(empty($filter)) {
            return $array;
        }
        $groupOp = 'AND';
        $filtered = [];
        foreach($array as $id => $d) {
            foreach($filter as $filterKey => $filterRule){
                if($filterKey === 'groupOp') {
                    $groupOp = $filterRule;
                    continue;
                }
                if($filterKey === 'groups') {
                    //$this->sendError(self::ERROR_NOT_IMPLEMENTED, "filter groups not implemented");
                    continue;
                }
                if($filterKey === 'rules') {
                    if($groupOp === 'AND'){
                        if($this->rulesAndApply($filterRule, $d)) {
                           $filtered[$id] = $d;
                        }
                    } else {
                        if($this->rulesORApply($filterRule, $d)) {
                            $filtered[$id] = $d;
                        }
                    }
               }
            }
        }
        return $filtered;
    }

    /**
        Name="Mark" and Age=25 and (city="NY" or city="FL") and (company="xyz" or company="zyx")
        {
            "groupOp": "AND",
            "rules": [
                { "field": "Name", "op": "eq", "data": "Mark" },
                { "field": "Age",  "op": "eq", "data": "25" }
            ],
            "groups": [
                {
                    "groupOp": "OR",
                    "rules": [
                        { "field": "city", "op": "eq", "data": "NY" },
                        { "field": "city", "op": "eq", "data": "FL" }
                    ],
                    "groups": []
                },
                {
                    "groupOp": "OR",
                    "rules": [
                        { "field": "company", "op": "eq", "data": "xyz" },
                        { "field": "company", "op": "eq", "data": "zyx" }
                    ],
                    "groups": []
                }
            ]
        };

     */
    public function filter($filter, $data) {
        $filtered = [];
        foreach($data as $key => $row) {
            if($this->filterRow($filter, $row)) {
                $filtered[$key] = $row;
            }
        }
        return $filtered;
    }

    protected function filterRow($filter, $row) {
        $result = true;
        $groupOp = isset($filter['groupOp']) ? $filter['groupOp'] : 'AND';
        foreach($filter as $k => $f) {
            if('rules' === $k) {
                if('AND' === $groupOp) {
                    $result = $this->rulesAndApply($f, $row);
                    if(!$result) {
                        return false;
                    }
                } else {
                    $result = $this->rulesOrApply($f, $row);
                    if($result) {
                        return true;
                    }
                }
                continue;
            }
            if('groups' === $k) {
                if(empty($f)) {
                    continue;
                }
                foreach($f as $subClause) {
                    $result = $this->filterRow($subClause, $row);
                    if(!$result && 'AND' === $groupOp) {
                        return false;
                    }
                    if($result && 'OR' === $groupOp) {
                        return true;
                    }
                }
            }
        }
        return $result;
    }

    protected function rulesAndApply($rules, $row) {
        if(count($rules) === 1) {
            $rule = reset($rules);
            if(empty($rule['field'])) {
                return true;
            }
        }
        foreach($rules as $rule) {
            if(empty($rule['field'])) {
                continue;
            }
            if(!$this->operatorApply($row[$rule['field']], $rule['op'], isset($rule['Data']) ? $rule['Data'] : $rule['data'] )) {
                return false;
            }
        }
        return true;
    }

    protected function rulesOrApply($rules, $row) {
        if(count($rules) === 1) {
            $rule = reset($rules);
            if(empty($rule['field'])) {
                return true;
            }
        }
        foreach($rules as $rule) {
            if(empty($rule['field'])) {
                continue;
            }
            if($this->operatorApply($row[$rule['field']], $rule['op'], isset($rule['Data']) ? $rule['Data'] : $rule['data']  )) {
                return true;
            }
        }
        return false;
    }

    protected function operatorApply($a, $operator, $b) {
        if(is_array($b)) {
            return $this->operatorArray($a, $operator, $b);
        }
        if(is_numeric($a) && is_numeric($b)) {
            return $this->operatorNumeric($a, $operator, $b);
        }
        return $this->operatorString($a, $operator, $b);
    }

    protected function operatorArray($a, $operator, $b) {
        $a = $this->stringNormalize($a);
        $in = [];
        foreach($b as $d) {
            $value = $this->stringNormalize($d);
            $in[$value] = true;
        }

        switch($operator) {
            case 'in':
            case 'eq':
                return array_key_exists($a, $in);
            case 'ni':
            case 'ne':
                return !array_key_exists($a, $in);

            case 'nu':
                return $a === null;
            case 'nn':
                return $a !== null;
            default:
                return false;
        }
    }

    protected function operatorString($a, $operator, $b) {
      $a = $this->stringNormalize($a);
      $b = $this->stringNormalize($b);
        switch($operator) {
            case 'cn':
                 return stripos($a, $b) !== false;
            case 'nc':
                return stripos($a, $b) === false;
            case 'bw':
                return substr($a, 0, strlen($b)) === $b;
            case 'bn':
                return substr($a, 0, strlen($b)) !== $b;
            case 'ew':
                return substr_compare($a, $b, -strlen($b)) === 0;
            case 'en':
                return substr_compare($a, $b, -strlen($b)) !== 0;
            case 'in':
            case 'eq':
                return strcmp($a, $b) === 0;
            case 'ni':
            case 'ne':
                return strcmp($a, $b) !== 0;
            case 'le':
                return strcmp($a, $b) <= 0;
            case 'lt':
                return strcmp($a, $b) < 0;
            case 'ge':
                return strcmp($a, $b) >= 0;
            case 'gt':
                return strcmp($a, $b) > 0;

            case 'nu':
                return $a === null;
            case 'nn':
                return $a !== null;
            default:
                return false;
        }
    }

    protected function operatorNumeric($a, $operator, $b) {
        switch($operator) {
            case 'cn':
                 return stripos($a, $b) !== false;
            case 'nc':
                return stripos($a, $b) === false;
            case 'bw':
                return substr($a, 0, strlen($b)) === $b;
            case 'bn':
                return substr($a, 0, strlen($b)) !== $b;
            case 'ew':
                return substr_compare($a, $b, -strlen($b)) === 0;
            case 'en':
                return substr_compare($a, $b, -strlen($b)) !== 0;
            case 'in':
            case 'eq':
                return $a == $b;
            case 'ni':
            case 'ne':
                return $a != $b;
            case 'le':
                return $a <= $b;
            case 'lt':
                return $a < $b;
            case 'ge':
                return $a >= $b;
            case 'gt':
                return $a > $b;

            case 'nu':
                return $a === null;
            case 'nn':
                return $a !== null;
            default:
                return false;
        }
    }

    protected function columnTitles($array, $colTitles) {
        if(!empty($colTitles)) {
            return $colTitles;
        }
        $columnTitles = [];
        foreach(array_keys(reset($array)) as $columnName) {
            $columnTitles[$columnName] =  $this->toLabel($columnName); // ucwords(str_replace('_',' ',$columnName));
        }
        return $columnTitles;
    }

  /**
   * Sends error message to the grid
   *
   * @param null|int $errorNumber null|int null no error int one of self::ERROR_ or 400 - 599 HTTP codes
   * @param string $message on empty sends appropriate message
   * @return void
   */
  public function sendError($errorNumber, $message = '') {
    if($errorNumber === null || $errorNumber === 0) { // no error
      return;
    }
    switch($errorNumber) {
      case self::ERROR_PERMISSION:
        $errorNumber = 401;
        $messageDefault = 'Sin permiso';
        break;
      case self::ERROR_NOT_IMPLEMENTED;
        $errorNumber = 501;
        $messageDefault = 'Operacion no reconocida';
        break;
      case self::ERROR_DB_ERROR;
        $errorNumber = 501;
        $messageDefault = 'Error de la base de datos intente mas tarde';
        break;
      default:
        if($errorNumber < 400 || $errorNumber > 599) {
          $errorNumber = 501;
        }
        $messageDefault = 'Error al leer datos, intente mas tarde';
    }
    $msgSend = empty($message) ? $messageDefault : $message;
    header($_SERVER["SERVER_PROTOCOL"]." $errorNumber $msgSend");
  }

  /**
   * @return array
   */
    public function readParams() {
        $paramsToRead = [
            'oper' => '',
            '_search' => false,     //@TODO
            'searchField' => '',    //@TODO
            'searchOper' => '',     //@TODO
            'searchString' => '',   //@TODO
            'filters' => '',
            'sidx' => '',
            'sord' => '',
            'rows' => null,
            'page' => 1,
            'orientation' => '',
            'title' => ''
        ];
        $params = [];
        foreach($paramsToRead as $key => $default) {
            $params[$key] = isset($_REQUEST[$key]) ? $_REQUEST[$key] : $default;
        }
        return $params;
    }


////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////




}

