<?php
/**
 * jQGrid filter to sql where
 * 
 * @version 1.0.1
 * @copyright 2017
 */




class iaFilter2where {

    protected static  array $opToStandard = [
        'eq' => 'eq',
        'ne' => 'ne',
        'lt' => 'lt',
        'le' => 'le',
        'gt' => 'gt',
        'ge' => 'ge',

        'bw' => 'bw',  // begins with
        'bn' => 'bn',  // not begins with
        'cn' => 'cn',  // containds
        'nc' => 'nc',  // not contains
        'ew' => 'ew',  // ends with
        'en' => 'en',  // not ends

        'in' => 'in',  // is in set
        'ni' => 'ni',  // is not in set

        'nu' => 'nu',  // is null
        'nn' => 'nn',  // not null
    ];

    protected static array $opOperator = [
        'eq' => '=',
        'ne' => '<>',
        'lt' => '<',
        'le' => '<=',
        'gt' => '>',
        'ge' => '>=',

        'in' => '=',  // fallback por si no mandan array con in clause
        'ni' => '<>', // fallback por si no mandan array con in clause
    ];

    /**
     * @param array $array
     * @param string $groupOp
     * @param string $op
     * @return array
     */
    public static function array2Filter($array, $groupOp = 'AND', $op = 'eq'):array { //@DUDA va en otra clase?
        if(empty($array)) {
            return [];
        }
        foreach($array as $fieldName => $value) {
            $rules[] = ['field' => $fieldName, 'op' => $op, 'data' => $value];
        }
        return  ['groupOp' => $groupOp, 'rules' => $rules];
    }
    
    public static function filter2where($filters, $groupOp = 'AND'):string {
        $where = '';

        if(empty($filters))
            return '';
        if(!is_array($filters))
            $filters = json_decode($filters, true);
        if(empty($filters))
            $filters = [];

        foreach($filters as $key => $f) {
            if(empty($f))
                continue;
            if($key === 'groupOp')
                $groupOp = self::strim($f);
            elseif($key === 'rules') {
                $clause = self::rules($f, $groupOp);
                if(!empty($clause)) {
                    $where .= empty($where) ? $clause : " $groupOp $clause";
                }
            } elseif($key === 'groups') {
                if(array_key_exists('rules', $f)) {
                    $clause = self::filter2where($f, $groupOp);
                    if(!empty($clause)) {
                        $where .= empty($where) ? $clause : " $groupOp $clause";
                    }
                } else
                    foreach($f as $g) {
                        $clause = self::filter2where($g, $groupOp);
                        if(!empty($clause)) {
                            $where .= empty($where) ? " $clause" : " $groupOp $clause";
                        }
                    }
            }
        }
        return empty($where) ? '' : '('.$where.')';
    }

    protected static function rules($rules, $groupOp):string {
        $where = '';
        if(is_array($rules) && !empty($rules))
            foreach($rules as $r) {
                $clause = self::rule2sql($r);
                if(!empty($clause)) {
                    $where .= empty($where) ? ' ' . $clause : ' ' . $groupOp . ' ' . $clause;
                }
            }
        return empty($where) ? '' : '('.$where.')';
    }

    public static function rule2sql($r):string {
        if(!array_key_exists('field',$r) || !array_key_exists('op',$r) || !array_key_exists('data',$r) ) {
            return '';
        }
        $fieldSent = self::strim($r['field']);
        if(empty($fieldSent)) {
            return '';
        }
        $field = self::fieldit($fieldSent);

        $op = strtolower(self::strim($r['op']));
        if(empty($op)) {
            return '';
        }
        if(isset(self::$opToStandard[$op])) {
            $op = self::$opToStandard[$op];
        }

        if(is_array($r['data']) && !empty($r['data']) && ($op === 'in' || $op === 'ni' ) ) {
            $data = '';
            foreach($r['data'] as $d) {
                $data .= ','.strit($d);
            }
            if(empty($data)) {
                return '';
            }
            return $field.($op === 'in' ? ' IN(' : ' NOT IN(').substr($data,1).')';
        }

        if(array_key_exists($op,self::$opOperator)) {
            return $field . ' ' . self::$opOperator[$op] . strit(self::strim($r['data']));
        }

        $value = self::strlike(self::strim($r['data']));
        if($op === 'bw') {
            return $field.' LIKE '.strit($value.'%');
        }
        if($op === 'bn') {
            return $field.' NOT LIKE '.strit($value.'%');
        }
        if($op === 'cn') {
            return $field.' LIKE '.strit('%'.$value.'%');
        }
        if($op === 'nc') {
            return $field.' NOT LIKE '.strit('%'.$value.'%');
        }
        if($op === 'ew') {
            return $field.' LIKE '.strit('%'.$value);
        }
        if($op === 'en') {
            return $field.' NOT LIKE '.strit('%'.$value);
        }

        if($op === 'nu') {
            return "$field IS NULL";
        }
        if($op === 'nn') {
            return "$field IS NOT NULL";
        }
        if($op === 'estadosoloand'){
           return $field.' = '.strit($value);
        }

        $estado=0;
        if($field==="`estado_p`" && $value) $estado= self::obteniendoBits($value);
       
        if($op === 'estadonotand'){
            $where = '';
            foreach($estado as $bit){
                $bit = $bit - 1;
                $where .= empty($where) ? ' ' . $field . ' & ' . (1 << $bit) . ' = 0' : ' OR ' . $field . ' & ' . (1 << $bit) . ' = 0';
            }

            return '('.$where.')';
        }
        if($op === 'estadonotor'){
            $where = '';
            foreach($estado as $bit){
                $bit = $bit - 1;
                $where .= empty($where) ? ' ' . $field . ' & ' . (1 << $bit) . ' = 0' : ' AND ' . $field . ' & ' . (1 << $bit) . ' = 0';
            }

            return '('.$where.')';
        }
        if($op === 'estadoor'){

            $where = '';
            foreach($estado as $bit){
                $bit = $bit - 1;
                $where .= empty($where) ? ' ' . $field . ' & ' . (1 << $bit) . ' > 0' : ' OR ' . $field . ' & ' . (1 << $bit) . ' > 0';
            }

            return '('.$where.')';
        }
        
        if($op === 'estadoand'){
            $where = '';
            foreach($estado as $bit){
                $bit = $bit - 1;
                $where .= empty($where) ? ' ' . $field . ' & ' . (1 << $bit) . ' > 0' : ' AND ' . $field . ' & ' . (1 << $bit) . ' > 0';
            }

            return '('.$where.')';
        }
        if($op ==='conalgunestado'){
            return $field . "> 0";
        }
        if($op ==='sinalgunestado'){
            return $field . "= 0";
        }
        
        
        return '';
    }
    protected static function obteniendoBits($value){
        //convitiendo el valor a un array
        $binario = decbin($value);
        $longitud = strlen($binario);

        $bitarray = [];
        for ($i = 0; $i < $longitud; $i++) {
            if ($binario[$i] == '1') {
                $bitarray[] = $longitud - $i ;
            }
        }

        return $bitarray;
    }
    

    protected static function strlike($str):string {return str_replace(array('%', '_'), array("\\%", "\\_"), $str);}
    
    /**
     * superTrim trim (including \s utf spaces), and change multiple spaces to one space
     *
     * @param string $str
     * @return string
     */
    protected static function strim($str):string {
        $s1 = preg_replace('/[\pZ\pC]/muS',' ',$str);
        // @codeCoverageIgnoreStart
        if(preg_last_error()) {
            $s1 = preg_replace('/[\pZ\pC]/muS',' ',  iconv("UTF-8","UTF-8//IGNORE",$str));
            if(preg_last_error())   
                return trim(preg_replace('/ {2,}/mS',' ',$str));
        }
        // @codeCoverageIgnoreEnd
        return trim(preg_replace('/ {2,}/muS',' ',$s1));
    }
    
    /**
     * Protect with ` quotes a: column name to `column name` respecting . table.column to `table`.`column`
     *
     * @param string $fieldName
     * @return string
     */
    protected static function fieldit(string $fieldName):string {
        $protected = [];
        $n = explode('.',$fieldName);
        foreach($n as $field) {
            $protected[]= '`'.str_replace('`', '', self::strim($field) ).'`';
        }
        return implode('.', $protected);
    }
}
