<?php

/*

    cls
        pk
        fieldInfo
        colmodel
        
        validate_add(toValidate, required)
        save_add(toValidate, required)
        
        validate_edit(toValidate, required)
        save_edit(toValidate, required)
        
        validatedel(toValidate)
        del

*/

/*
   Ayda a enviar records a jqGrid
   
a)  Responder con solo el nombre de la tabla,

    $tableName = 'tabla';
    $grid = new iaJqGridRead($gSqlClass); 
    switch($grid->get_oper()) {
        case '':
        case 'read':
            // revisar permisos
            // decidir por numero de rows a enviar si enviarlas o avisar son muchas. regresa false en error
                $numberRowsToSend = $grid->countRowsToSendForTable($tableName);
                if($numberRowsToSEND > JQGRID_MAX_SEND_ROWS && parmas('x',false)) {
                    echo json_encode([...]);
                    break;
                }
            // si es con MYSQLI_NUM indicar el numero de columnas extras 
                $grid->extraSelectColumns(0); 
            if(!$grid->readForTable($tableName, $numberRowsToSend , MYSQLI_NUM)) { // $numberRowsToSend puede ponerse null de no calcularse antes 
                // errors ocurred header 501 sent
            }
            break;  
        case 'csv':
        case 'xlsx':
        
        case 'pdf':
        
        case 'add':
        case 'edit':
        case 'del':
        
        default:
            header($_SERVER["SERVER_PROTOCOL"].'  501 ' . $grid->get_oper() . ' not implemented');
            break;                  
    }
    // log action and errors

c) Hace el read con los selects manuales, manda el json, supone el usuario tiene permiso read
    $grid = new iaJqGridRead($gSqlClass);
    $where = $grid->get_whereClause();
    if(!empty($where)) {
        $where = " WHERE $where ";
    }
    
    if(!$grid->read(
        "SELECT * FROM table $where ",
        "SELECT COUNT(*) FROM table $where "
        
    )) { 
        // errors ocurred header 501 sent
    } 
    // log action and errors    


d) Regresa el response del read para no env�a el json, 
    supone el usuario tiene permiso read
    
    $grid = new iaJqGridRead($gSqlClass);
    $where = $grid->get_whereClause();
    if(!empty($where)) {
        $where = " WHERE $where ";
    }
    $sql_count = "SELECT COUNT(*) FROM table $where ";
    $sql = "SELECT $sql_comment * FROM table $where ".$grid->orderBy().' '.$grid->limit();



x) Hace
    $grid = new iaJqGridRead($gSqlClass);
    // la accion ejectuda es $this->get_oper()
    $result = $grid->respondForTable($tableName); // hace read, add, edit, del y envia el json
    if($result === false) {
        // errors ocurred header 501 sent
    } else {
        $result trae true except en add con autoincrement el id del record added
        // log action 
    }
    //log errors
*/
require_once(__DIR__ . '/iaFilter2where.php');

class iaJqGridRead {
    protected $db;
    protected array $params;
    protected string $selectExtraColumns = '';
    protected $whereClause;
    protected array $response = [];
    protected bool $debug = true;

    public function __construct($db, $debug = false){
        $this->db = $db;
        $this->debug = $debug;
        $this->read_params();
        $this->whereClause = $this->set_whereClause();
        if($this->debug) {
            $this->response['debug_request'] = $_REQUEST;
            $this->response['debug_read_params'] = $this->params;
            $this->response['debug_where'] = $this->whereClause;
        }
    }

    public function get_oper():string {
        return $this->params['oper'] ?? '';
    }
    
    public function selectRecords2Count($selectRecords):string {
        return "with `a u t o-c o u n t` as ($selectRecords) select count(*) from `a u t o-c o u n t`";
    }
    
    public function countRowsToSendForTable($tableName) {
        $where = empty($this->whereClause) ? '' : " WHERE ".$this->whereClause;
        return $this->countRowsToSend("SELECT COUNT(*) FROM ".$this->fieldit($tableName).$where);
    }

    public function countRowsToSend($selectTotalRecords) {        
        if(is_numeric($selectTotalRecords)) {
            $totalRecords = $selectTotalRecords;
        } else {
            $totalRecords = $this->db->single_read( $selectTotalRecords, 0);    
            if($totalRecords === false) {
                return false;
            }
        }                
        $limit = $this->limit(); // get and fix $this->params['rows']
        if($this->params['rows'] === '') {
            return $totalRecords;
        }
        return max($totalRecords, $this->params['rows']);
    }

    public function respondForTable($tableName, $assocMethod = MYSQLI_NUM) {
        switch($this->get_oper()) {
            case '':
                return $this->readForTable($tableName, $assocMethod);
                break;
                
            case 'add':
                header($_SERVER["SERVER_PROTOCOL"]." 501 add not implemented");
                return false;
                break;

            case 'edit':
                header($_SERVER["SERVER_PROTOCOL"]." 501 edit not implemented");
                return false;
                break;
                                                
            case 'del':
                header($_SERVER["SERVER_PROTOCOL"]." 501 del not implemented");
                return false;
                break;
                            
            case 'pdf':
                header($_SERVER["SERVER_PROTOCOL"]." 501 pdf not implemented");
                return false;
                break;
                   
            case 'xls':                            
            case 'xlsx':
                header($_SERVER["SERVER_PROTOCOL"]." 501 xlsx not implemented");
                return false;
                break;
            
            case 'csv':
                return $this->csvExport(
                    'SELECT * FROM '.self::fieldIt($tableName).empty($this->whereClause) ? '' : " WHERE $this->whereClause ".$this->orderBy(),
                    "$tableName.csv"
                );
                break;
            default:
                return $this->readForTable($tableName, $assocMethod);
                break;                            
        }
        header($_SERVER["SERVER_PROTOCOL"]." 501 operation not implemented");
        return false;        
    }
    
////////////////////////////////////////
    public function readForTable($tableName, $assocMethod = MYSQLI_NUM) {
        $table = self::fieldIt($tableName);
        $where = empty($this->whereClause) ? '' : "WHERE ".$this->whereClause;
        return $this->read(
            "SELECT /*". __METHOD__ ."*/ ".$this->selectExtraColumns." * FROM $table $where ",
            "SELECT /*". __METHOD__ ."*/ COUNT(*) FROM $table $where ",
            $assocMethod
        );
    }
    
    public function read($selectRecords, $selectTotalRecords, $assocMethod = MYSQLI_NUM) {
        $this->response['params'] = $this->params;

        if($selectTotalRecords === '') {
            $selectTotalRecords = "with `a u t o-c o u n t` as ($selectRecords) select count(*) from `a u t o-c o u n t`";
        }
        if($this->readManual(
            $selectRecords.' '.$this->orderBy().' '.$this->limit(), 
            $selectTotalRecords, 
            $assocMethod
        )) {
            echo json_encode($this->response);
            return true;    
        }
        return false;
    }
    
    public function readManual($selectRecords, $selectTotalRecords, $assocMethod = MYSQLI_NUM) {
        if($this->debug) {
            $this->response['debug_select_records'] = $selectRecords;
            $this->response['debug_total_rows'] = $selectTotalRecords;
        }
        if(is_numeric($selectTotalRecords)) {
            $totalRecords = $selectTotalRecords;
        } else {
            $totalRecords = $this->db->single_read( $selectTotalRecords, 0);    
        }        
        if($totalRecords === false) {
            header($_SERVER["SERVER_PROTOCOL"]." 501 al contar registros");
            return false;            
        }
        //@TODO muchos records ajax dialog send, muchos en class variable, property
        $this->set_totalRecordsPages($totalRecords);
                
        $this->response['rows'] = $this->db->selectArrayIndex($selectRecords, [], $assocMethod);
        
        if($this->response['rows'] === false) {
            header($_SERVER["SERVER_PROTOCOL"]." 501 al leer registros");
            return false;
        }        
        return true;        
    }

    
    public function where() {
        return $this->whereClause;
    }
    
    public function orderBy() {

        $orderBy = [];
        foreach(explode(',',  $this->params['sidx'].' '.$this->params['sord']) as $clause) {
            $part = [];
            foreach(explode(' ', $clause) as $d) {
                $q0 = self::strim($d);
                if(empty($q0)) {
                    continue;
                }
                if(strcasecmp('ASC',$q0) === 0 || strcasecmp('DESC',$q0) === 0 || strcasecmp('RAND()',$q0) === 0 ) {
                    $part[] = $q0;
                    continue;
                }
                $part[] = is_numeric($q0) ? $q0 : self::fieldit($q0);
            }
            if(!empty($part))
                $orderBy[] = implode(' ', $part);

        }

        return ' ORDER BY ' . ( empty($orderBy) ? '1' : implode(', ', $orderBy)) . ' ';
    }

    public function limit() {
        if(empty($this->params['rows']) || !is_numeric($this->params['rows']) )
            return '';
        if($this->params['rows']<=0)
            $this->params['rows']=10;
        if( empty($this->params['page']) || !is_numeric($this->params['page']) || $this->params['page']<=0 )
            $this->params['page']=1;
        $start = $this->params['rows'] * $this->params['page'] - $this->params['rows'];
        if($start <0) {
            $start = 0;
        }
        return " LIMIT $start,".$this->params['rows'];
    }
        

////////////////////////////////////////
    public function set_totalRecordsPages($totalRecords) {
        $this->response['records'] = $totalRecords;
        $this->response['page'] = $this->params['page'];
        if(empty($this->params['rows']) || !is_numeric($this->params['rows']) || $this->params['rows'] <= 0 ) {
            $this->response['total'] = 1;
            $this->response['page'] = 1;
            return;
        }
        $this->response['total'] = $this->response['records'] <= 0 ? 0 :
            $this->response['total'] = max( ceil($this->response['records']/$this->params['rows']),1);
        if ($this->params['page'] > $this->response['total']) {
            $this->response['page'] = $this->response['total'];
        }
    }

    public function get_response() {
        return $this->response;
    }

////////////////////////////////////////
    protected function read_params() {
        $paramsToRead = [
            'oper' => '',
            '_search' => false,
            'searchField' => '',
            'searchOper' => '',
            'searchString' => '',
            'filters' => '',
            'sidx' => '',
            'sord' => '',
            'iacwhere' => '',
            'rows' => null,
            'page' => 1,
        ];
        foreach($paramsToRead as $key => $default) {
            $this->params[$key] = isset($_REQUEST[$key]) ? $_REQUEST[$key] : $default;
        }
    }

////////////////////////////////////////
    protected function set_whereClause() {
        //Aqui va la magia de Mariana
//        iacwhere

        $whereClause = [];
        $extra_where = urldecode(param('iacwhere'));
        if(!empty($extra_where))
            $whereClause[] = $extra_where;

        if(!empty($this->params['searchField']) && !empty($this->params['searchOper']) && !empty($this->params['searchString'])) {
            $where = iaFilter2where::rule2sql(['field'=>$this->params['searchField'], 'op'=>$this->params['searchOper'], 'data'=>$this->params['searchString']]);
            if(!empty($where)) {
                $whereClause[] = "($where)";
            }
        }
        if(!empty($this->params['filters'])) {
            $where = iaFilter2where::filter2where($this->params['filters']);
            if(!empty($where)) {
                $whereClause[] = $where;
            }
        }
        if(!empty($this->params['_search'])) {
            
        }
        return implode(' AND ', $whereClause);
    }

////////////////////////////////////////
    public function csvExport($selectRecords, $fileName, $conPK = false, $pk_field='') {
        header("Content-Type: text/html; charset=utf-8");
        header("Cache-Control: no-store, no-cache");
        header("Content-Disposition: attachment; filename*=UTF-8''".$fileName.".csv");
        echo "\xEF\xBB\xBF";
        $exporta=ia_sqlArrayIndx($selectRecords);
        if($exporta) {
            // header row
            foreach($exporta as $rec) {
                $row = [];
                foreach($rec as $fieldName=>$v) { 
                    if($conPK || (!$conPK && $fieldName !== $pk_field)) {
                        $row[] = comillea(to_label($fieldName));
                    }
                }
                echo implode(',', $row)."\r\n";
                break;
            }
            // data rows
            foreach($exporta as $rec) {
                $row = [];
                foreach($rec as $fieldName=>$v) if($conPK || (!$conPK && $fieldName!=$pk_field)) {
                    if( is_bool($v)) {
                        $row[] = $v ? 'true' : 'false';
                    } elseif( is_numeric($v) ) {
                        $row[] = $v;
                    } else {
                        $row[] = comillea($v);
                    }
                }
                echo implode(',', $row)."\r\n";
            }
            return true;
        }
        return false;
    }

    /**
     * superTrim trim (including \s utf spaces), and change multiple spaces to one space
     *
     * @param string $str
     * @return string
     */
    public static function strim(string $str):string { return strim($str);}
    
    /**
     * Protect with ` quotes a: column name to `column name` respecting . table.column to `table`.`column`
     *
     * @param string $fieldName
     * @return string
     */
    public static function fieldit(string $fieldName):string {
        $protected = [];
        $n = explode('.',$fieldName);
        foreach($n as $field) {
            $protected[]= '`'.str_replace('`', '', self::strim($field) ).'`';
        }
        return implode('.', $protected);
    }    

    public function extraSelectColumns(string $extraColumns):string {
        if(empty($extraColumns)) {
            $this->selectExtraColumns = '';
            return '';
        }
        if(is_numeric($extraColumns)) {
            $this->selectExtraColumns = str_repeat("'',", $extraColumns);
            return $this->selectExtraColumns;    
        }
        if(is_array($extraColumns)) {
            $this->selectExtraColumns = implode(',', $extraColumns ).',';
            return $this->selectExtraColumns;
        }
        $this->selectExtraColumns = $extraColumns;
        return $extraColumns;
    }

}
