<?php
/**
 * iaTableIt
 *
 * Simple echo Array to table, keys are column headers
 *
 * @copyright 2014
 * @version 1.0.1
 */
class iaTableIt {

    public static function getCssClases() {
        return <<< CSSTEXT
        .laTabla div{overflow-x:auto;border:4px darkblue double;display:inline-block;padding:1em}
        .laTabla {border-collapse:collapse;border: 1px darkblue solid;border-spacing:0;margin:auto;overflow-x:hidden;empty-cells:show;
            box-shadow:darkblue 4px 4px 0 0;
        }
        .laTabla CAPTION {
            font-weight:bold;font-size:larger;color:blue; background-color:white;padding:0.3em;border:1px solid darkblue;
            box-shadow:darkblue 4px 0 0 0;
        }
        .laTabla THEAD {position: sticky; top: 0;margin-top:0;margin-bottom:0;background-color:white;opacity:1}
        .laTabla TH {padding:4px;color:darkblue;opacity:1;border: 1px darkblue solid}
        .laTabla TD {padding:4px;vertical-align:top;border: 1px solid silver}
        .laTabla TR:hover {background-color: #f5f5f5}
        .laTabla TR:nth-child(even) {background-color: #f2f2f2}
        
        .laTabla .lft {text-align:left}
        .laTabla .cen {text-align:center}
        .laTabla .rgt {text-align:right}
        
        .laTabla .date {text-align:center;white-space:pre-line}
        .laTabla .red {color:red}
        .laTabla .green{color:darkgreen}
        .laTabla .blue{color:blue}
        .laTabla .remark{background-color:yellow}
CSSTEXT;

    }

    /**
     * Array to table, keys are column headers, returns html table string
     *
     * @param array $arr Data for table [ ['key1'=>1,'key2'=>'name'], ...]
     * @param string $caption
     * @param array $headerIn [ 'key'=>['label'=>'', 'class'=>'', 'dec'=>4, 'prefix'=>'$', 'suffix'=>'MN', 'valueClass'=>['Si'=>'red', 'SI'=>'red'] ], ]
     * @param boolean $niceHeaders true label($key), false use keys. default true
     * @param string $idPrefix sets id for html tags: table id='tableit$idPrefix', tr id='tr$idPrefix$id' default tblIt
     * @param string $tableClass sets contining div to class='$tableClassdiv' and table's class='$tableClass'. Default laTabla
     * @return string
     */
    public static function getTableIt($arr,$caption='', $idPrefix='tblIt',
                                      $headerIn=array(),
                                      $niceHeaders=true,
                                      $tableClass='laTabla',
        $colGroup = '', $doHeaders =true, $deduceTotals = false
    ) {
        $ret = [];
        $ret[] = "<table id='$idPrefix' class='$tableClass tablesorter tablesorter-default'>$colGroup";
        if(empty($arr)) {
            $ret[] =  "</table>";
            return implode("\r\n", $ret);
        }

        if(!empty($caption)) {
            $ret[] =  "<caption>$caption</caption>";
        }
        $header = self::headerDeduce($arr, $headerIn, $niceHeaders);
        if($doHeaders) {
            $ret[] = "<thead><tr class='tablesorter-headerRow'>";


            foreach ($header as $key => $h) {
                $ret[] = "<th  class='tablesorter-header tablesorter-headerUnSorted'>" . (isset($h['label']) ? $h['label'] : htmlentities($key ?? '', ENT_NOQUOTES, 'UTF-8'));
            }
            $ret[] = "</thead>";
        }

        $ret[] =  "<tbody>";
        $prev = "";
        foreach($arr as $id => $row) {
            $trKey = count($ret);
            $ret[] =  "$prev<tr id='tr$idPrefix$id' class=''>";
            $prev = "";
            foreach($header as $key => $h) {
                if($row[$key] === null) {
                    $ret[$trKey] = "<tr id='tr$idPrefix$id' class='total'>";
                    $prev = "<tr><td></td>";
                }
                if(empty($h['class'])) $h['class'] = '';
                if(!isset($row[$key]))
                    $ret[] =  "<td class='$h[class]'>";
                else {
                    $color = self::valueClass($row[$key], $h);
                    if(isset($h['dec']) && self::isNumber($row[$key]) ) {
                        $ret[] =  "<td class='$h[class]".($row[$key] < 0 ? ' red' : '')." $color'>";
                        if(!empty($h['prefix']))
                            $ret[] = $h['prefix'];
                        $ret[] =  is_numeric($row[$key]) ?
                            number_format($row[$key], $h['dec'], $h['dec'] > 0 ? '.' : '' , $h['thousands'] ?? ',') :
                            $row[$key] ?? '';
                    } else {
                        $ret[] =  "<td class='$h[class] $color'>";
                        if(!empty($h['prefix']))
                            $ret[] =  $h['prefix'];
                        if(!empty($h['html']))
                            $ret[] =  $row[$key];
                        else
                            $ret[] =  $row[$key] ?? '';
                    }
                    if(!empty($h['suffix'])) {
                        $ret[] =  $h['suffix'];
                    }
                }
            }
        }
        $ret[] = "</tbody></table>
            <script>
                if(typeof $ === 'function' && typeof $.fn.tablesorter === 'function')
                    $('#$idPrefix').tablesorter({
                        theme:'basic',
                        ignoreCase: true,
                        sortLocaleCompare:true,
                        cancelSelection: false,
                    });
            </script>";
        return implode("\r\n", $ret);
    }

   /**
    * Put css for tableIt inside style tags
    *
    * @return void
    */
   public static function tableIt_css() {
        echo static::getCssClases();
    }

    /**
     * Simple echo Array to table, keys are column headers
     *
     * @param array $arr Data for table [ ['key1'=>1,'key2'=>'name'], ...]
     * @param string $caption
     * @param array $headerIn [ 'key'=>['label'=>'', 'class'=>'', 'dec'=>4, 'prefix'=>'$', 'suffix'=>'MN', 'valueClass'=>['Si'=>'red', 'SI'=>'red'] ], ]
     * @param boolean $niceHeaders true label($key), false use keys. default true
     * @param string $idPrefix sets id for html tags: table id='tableit$idPrefix', tr id='tr$idPrefix$id' default tblIt
     * @param string $tableClass sets contining div to class='$tableClassdiv' and table's class='$tableClass'. Default laTabla
     * @return void
     */
    public static function tableIt($arr,  $caption='',$headerIn=array(), $niceHeaders=true,$idPrefix='tblIt',$tableClass='laTabla', $deduceTotals = false) {

        //echo "<div class='$tableClass"."div'>";
        echo "<table id='tableit$idPrefix' class='$tableClass tablesorter'>";
        if(empty($arr)) {
            echo "</table></div>";
            return;
        }

        if(!empty($caption)) {
            echo "<caption>$caption</caption>";
        }

        echo "<thead><tr>";
        $header = self::headerDeduce($arr, $headerIn, $niceHeaders);

        foreach($header as $key => $h) {
            echo "<th>".(isset($h['label']) ? $h['label'] : htmlentities($key ?? '',ENT_NOQUOTES,'UTF-8'));
        }
        echo "</thead>";

        echo "<tbody>";

        foreach($arr as $id => $row) {
            $class = '';
            if($deduceTotals)
                foreach($header as $key => $h)
                    if(!isset($row[$key])) {
                        $class = ' class="total"';
                        break;
                    }
            echo "<tr id='tr$idPrefix$id'$class>";
            foreach($header as $key => $h) {
                if(empty($h['class']))
                    $h['class'] = '';
               if($key[0] === '_')
                   continue;
                if(!isset($row[$key]))
                    echo "<td>";
                else {
                    $color = self::valueClass($row[$key], $h);
                    if(isset($h['dec']) && self::isNumber($row[$key]) ) {
                        echo "<td class='$h[class]".($row[$key] < 0 ? ' red' : '')." $color'>";
                        if(!empty($h['prefix']))
                            echo $h['prefix'];
                        echo is_numeric($row[$key]) ?
                            number_format($row[$key], $h['dec'], $h['dec'] > 0 ? '.' : '' , $h['thousands']) :
                            $row[$key] ?? '';
                    } else {
                        echo "<td class='$h[class] $color'>";
                        if(!empty($h['prefix']))
                            echo $h['prefix'];
                        if(!empty($h['html']))
                            echo $row[$key];
                        else
                            echo $row[$key];
                    }
                    if(!empty($h['suffix'])) {
                        echo $h['suffix'];
                    }
                }
            }
        }

        echo "</tbody></table>";
       // echo "</div>";
    }

  public static function pdfExport($array, $fileNameNoExtension, $orientation = '', $caption ="", $caption2="", $array2 = null, $caption3="", $array3 = null, $embeded = false) {
    $fechayhora = Date('d/m/Y G:i');
    $footer = '  <!--mpdf
                <htmlpagefooter name="myfooter">
                <div style="border-top: 1px solid #000000; font-size: 10pt; text-align: right; padding-top: 3mm; ">
                    <b>'.$fechayhora.'</b>, pag <b>{PAGENO}</b> de <b>{nb}</b>
				</div>
				</htmlpagefooter>
				<sethtmlpagefooter name="myfooter" value="on" />
                mpdf-->';
    if(empty($orientation)) {
      $firstRow = reset($array);
      $orientation = count($firstRow) > 5 ? 'L' : 'P';
    }

    $pdfOptions = [
      'mode' => 'UTF-8',
      'format' => 'LETTER',
      'default_font_size' => 0,
      'default_font' => '',
      'margin_left' => 15,
      'margin_right' => 15,
      'margin_top' => 10,
      'margin_bottom' => 10,
      'margin_header' => 9,
      'margin_footer' => 9,
      'orientation' => $orientation,
      //'default_font' => 'dejavusans',
    ];
    $mpdf = new \Mpdf\Mpdf($pdfOptions);
    $mpdf->SetDisplayMode('fullpage');
    $mpdf->list_indent_first_level = 0;	// 1 or 0 - whether to indent the first level of a list

    $html = '<!DOCTYPE html><html><head><title></title><style>' . static::getCssClases() . '</style></head><body>' .
      static::getTableIt($array, $caption);


      if($array2 !== null  )
        $html .= "<div style='page-break-after: always;'></div>" . static::getTableIt($array2, $caption2);
    if($array3 !== null  )
        $html .= "<div style='page-break-after: always;'></div>" . static::getTableIt($array3, $caption3);
    $html .= '</body></html>';
    $mpdf->WriteHTML($html);
    if($embeded) {
        $base64pdf = base64_encode($mpdf->Output('', 'S'));
        return '<object style="width:90%;height:80%" data="data:application/pdf;base64,' . $base64pdf . '" type="application/pdf">';
    }
    $mpdf->Output("$fileNameNoExtension.pdf", \Mpdf\Output\Destination::INLINE);
  }

    /**
     * Add class if value matches $columnHeader['valueClass']
     *
     * @param mixed $value value for the cell
     * @param array $columnHeader for column
     * @return string class to add according to $columnHeader['valueClass'] or ''
     */
    protected static function valueClass($value, $columnHeader) {
        if(empty($columnHeader['valueClass'])) {
            return '';
        }
        foreach($columnHeader['valueClass'] as $find => $class) {
            if($value == $find) {
                return $class;
            }
        }
        return '';
    }

    /**
     * Deduce column definition respecting defaults in $headerIn
     *
     * @param array $arr Data for table
     * @param array $headerIn default column definition
     * @param bool $niceHeaders true = process key for nice header (accent,...). flase=just use keys for headers
     * @return array complete and deduce headers
     */
    protected static function headerDeduce($arr, $headerIn, $niceHeaders=true) {

        $header = [];
        $row1 = reset($arr);
        foreach($row1 as $key => $ignore) {
            if(!isset($key[0]) || $key[0] === '_')
                continue;
            $header[$key] = empty($headerIn[$key]) ? [] : $headerIn[$key];
        }

        $irow=0;
        foreach($arr as $row) {
             if($irow++ > 10) {
                break;
            }
            if($irow===1) {
                foreach($row as $key=>$data) {
                    if(!isset($key[0]) || $key[0] === '_')
                        continue;
                    if(!array_key_exists('label', $header[$key])) {
                        $header[$key]['label'] = self::labelIt($key, $niceHeaders);
                    }

                    $class = null;

                    if(!isset($header[$key]['dec'])) {
                        $header[$key]['dec'] = strpos($data ?? '','.') === false ? 0 : 2;
                    }
                    if(!isset($header[$key]['thousands'])) {
                        $header[$key]['thousands']=',';
                    }
                    if(strcasecmp($key, 'id') === 0 || strcasecmp(substr($key,-3),'_id') === 0) {
                        $header[$key]['thousands']='';
                    }
                    if(self::isNumber($data) ) {
                        $class = 'rgt';
                    } elseif(($len=strlen($data ?? ''))<=4) {
                        $class = 'cen';
                    } elseif($len === 10) {
                        $class = 'date';
                    } else {
                        $class = 'lft';
                    }
                    if($class !== null && empty($header[$key]['class'])) {
                        $header[$key]['class'] = $class;
                    }
                } // foreach($row as $key=>$Data)
            } else {
                foreach($row as $key=>$data) {
                    $head = &$header[$key];
                    if(self::isNumber($data)) {
                        if(empty($head['class'])) {
                            $head['class'] = 'rgt';
                        }
                        if(empty($head['dec']) && strpos($data,'.')) {
                            $head['dec'] = 2;
                        }
                    }
                } // foreach($row as $key=>$Data)
            }
        } // foreach($arr as $row)
        return $header;
    }


    /**
     * On $niceHeaders=true make nice words for header from s
     *
     * @param string $s
     * @param boolean $niceHeaders
     * @return string
     */
    protected static function labelIt($s, $niceHeaders) {
        return ucwords( str_replace('_', ' ', $s) );
    }

    /**
     * Determine if string $s is a number
     *
     * @param mixed $s item to check if it is a number
     * @return bool true $s is a number
     */
    protected static function isNumber($s) {
        return is_numeric(str_replace([',','$',' '], '', $s ?? ''));
    }

}
