<?php
/** @noinspection PhpRedundantOptionalArgumentInspection */
/** @noinspection PhpMissingReturnTypeInspection */
/** @noinspection PhpMissingParamTypeInspection */
/** @noinspection RegExpRedundantEscape */

/** 2021-12-21 Todo verde */

/**
 * ia_util.php
 * Utilerias
 * @version 2.1.2012.09.23
 * @package utilerias
 * pre-requisites: include config.php para array $gIAsql y $gIaTimeStart value,
 *
 */

use JetBrains\PhpStorm\ExpectedValues;
use JetBrains\PhpStorm\NoReturn;
use JetBrains\PhpStorm\Pure;

// ////////////////////// SQL  //////////////////////
global $gIAsql;
    if(!array_key_exists('set_autocommit',$gIAsql)) $gIAsql['set_autocommit']=null;
    if(!array_key_exists('pconnect',$gIAsql)) $gIAsql['pconnect']=false;
    if(!array_key_exists('trace',$gIAsql)) $gIAsql['trace']=false;
    if(!array_key_exists('sql_trace',$gIAsql)) $gIAsql['sql_trace']=array();
    if(!array_key_exists('link',$gIAsql)) $gIAsql['link']=null;
    if(!array_key_exists('err',$gIAsql)) $gIAsql['err']='';
    $gIAsql['affected_rows']=$gIAsql['begins']=$gIAsql['selected_rows']=0;

$gIAsql['dont_quote']=array('NULL','CURDATE()','CURRENT_DATE()','CURRENT_DATE','CURRENT_DATETIME','CURRENT_TIME()','CURRENT_TIME','CURTIME()'
    ,'CURRENT_TIMESTAMP()','CURRENT_TIMESTAMP','NOW()','LOCALTIMESTAMP','LOCALTIMESTAMP()','SYSDATE()','UNIX_TIMESTAMP()'
    ,'UTC_DATE()','UTC_TIME()','UTC_TIMESTAMP()');

include_once(__DIR__.'/sqlConverter.php');
/**
 * ia_sqlErrors()
 *
 * @return string html <ul> con los errores
 */
function ia_sqlErrors():string {
global $gIAsql;
    return $gIAsql['err'] === '' ? '' : "<ul>$gIAsql[err]</ul>";
}

/**
 * ia_update()
 * regresa un update $table set $key='$values[$key]',... WHERE  $pkey='$primaryKey[$pkey]' AND
 * @param string $table nombre de la tabla
 * @param array $values 'campo'=>value, rutina protege apostrofes
 * @param string|array $where en array hace 'campo'=value  con AND, en string lo pone
 * @param array $excludeQuote
 * @param string $after_clause despues del where.
 * @param string $before_clause entre update y table.
 * @param boolean $inteligent_quotes en true no quotea lo que este en $gIAsql['dont_quote']
 * @param boolean $dontQuote en true no pone quotes alrededor de los valores, default false no pone quotes
 * @return string
 */
function ia_update($table, $values = [], $where = [],
                   $excludeQuote=[], $after_clause='', $before_clause='',
                   $inteligent_quotes = true, $dontQuote = false):string {
global $gIAsql;
    $upd='';
    foreach($values as $fieldName=>$v) {
        if( is_null($v) )
            $upd.=", $fieldName=NULL";
        elseif( $dontQuote || ($inteligent_quotes && in_array(strtoupper(trim($v)),$gIAsql['dont_quote'])) || in_array($fieldName,$excludeQuote) || ia_dontQuote($v) )
            $upd.=", $fieldName=$v";
        else
            $upd.=", $fieldName=".strit($v);
    }
    if(is_array($where)) {
        $w='';
        foreach($where as $fieldName=>$v)
            if( is_null($v) )
                $w.=" AND $fieldName IS NULL";
            elseif( $dontQuote || ($inteligent_quotes && in_array(strtoupper(trim($v)),$gIAsql['dont_quote'])) )
                $w.=" AND $fieldName = $v";
            else
                $w.=" AND $fieldName = ".strit($v);
        $w=substr($w,5);
    } else
        $w=$where;

    $comment = "/** ACTUALIZA $table **/";
    return "UPDATE $comment $before_clause $table SET ".substr($upd,1)." WHERE $w ".$after_clause;
}


function ia_dontQuote( $v):bool {
    $paren = strpos($v,'(');

    if($paren === FALSE)
        return false;
    $close = strpos($v,')',$paren);

    if($close === FALSE  || $close < $paren)
        return false;
    $blank = strpos($v,' ');
    if($blank === FALSE || $paren < $blank && substr($v,-1==')') && substr_count ($v,'(') == substr_count ($v,')')  ) {
        $functions = array('DATE_ADD(','DATE_SUB(');
        foreach($functions as $f)
            if(stripos($v,$f) === 0)
                return true;
    }
    return false;
}

/**
 * ia_insert()
 * regresa un insert $before_clause into $table($keys) values($vals) $after_clause;
 * @param string $table nombre de la tabla
 * @param array $values 'campo'=>value
 * @param boolean $autoOnUpdate en true hace ON DUPLICATE UPDATE de no venir en after_clause
 * @param string $after_clause poner despues de values: on duplicate key...
 * @param string $before_clause entre insert y (campos)
 * @param boolean $inteligent_quotes en true no quotea lo que este en $gIAsql['dont_quote']
 * @param boolean $dontQuote en true no pone quotes alrededor de los valores, default false no pone quotes
 * @return string
 * VCA 29-07-2021 hice una actualizacion a ON DUPLICATE KEY UPDATE
 */
function ia_insert($table = '', $values = [], $excludeQuote = [], $after_clause='',
       $autoOnUpdate=false, $before_clause='', $inteligent_quotes=true, $dontQuote=false, $comment = ''): string
{
global $gIAsql;
    $ins='';
    $val='';
    $upd='';

    if(empty($table))
        return "";

    $TB = strtoupper($table);
    if (empty($comment))
        $comment = "/** INSERTA $TB **/";

    $alias = $table."_alias";

    foreach($values as $fieldName=>$v) {
        $ins.=",$fieldName";
        if( is_null($v) )
            $val.=",NULL";
        elseif(is_array($v)) {
            $val.=','.strit( implode(',',$v));
        } elseif( $dontQuote || ($inteligent_quotes && in_array(strtoupper(trim($v)),$gIAsql['dont_quote'])) || in_array($fieldName,$excludeQuote) || ia_dontQuote($v) )
            $val.=",$v";
        else
            $val.=','.strit($v);
        $upd.=",$fieldName=$alias.$fieldName";
    }
    if($autoOnUpdate)
        $after_clause=" AS $alias ON DUPLICATE KEY UPDATE ".substr($upd,1);
    return "INSERT $comment $before_clause INTO $table(".substr($ins,1).") VALUES(".substr($val,1).") $after_clause";

}

/**
* ia_nameFile($Path, $elName)
*
* Path: para ubicaicón del archivo
* elName: Nombre original del archivo
*
*/
function valExisteFile($Path, $elName, $laextension, $cntInicial):string {
    if(file_exists($Path."/".$elName.".".$laextension)){
        if(!str_contains($elName, "--_")){
            return valExisteFile($Path, $elName."--_".$cntInicial, $laextension, ++$cntInicial);
        }
        $nombreAnt = explode("--_",$elName);
        return valExisteFile($Path, $nombreAnt[0]."--_".$cntInicial, $laextension, ++$cntInicial);
    }
    return $elName.".".$laextension;
}

function ia_fileName($Path, $elName, $gWebDir):string {
    $elName   = sanitizeFileName($elName);
    $fpp      = pathinfo($elName);
    $elName   = array_key_exists('filename',$fpp) ? strtolower($fpp['filename']):'';
    $elName   = substr($elName,0,50);
    $laextension = array_key_exists('extension',$fpp) ? strtolower($fpp['extension']):'';

    $newName   = valExisteFile($Path, $elName, $laextension, 1);
    valida_carpetas($Path,$gWebDir);

    return $newName;
}

/**
 * ia_guid()
* returns universal uuid de mysql: sin - en base 36 (29 caracteres maximo) reversed para menos carga a indices.

* @param string $cmnt
* @return string uuid
 */
function ia_guid($cmnt='guid'):string {
    $a=explode('-',ia_singleread("SELECT SQL_NO_CACHE /* $cmnt */ UUID()",'',false));
    return $a[4].$a[3].$a[2].$a[1].$a[0];
    // aaaaaaaa-bbbb-cccc-dddd-eeeeeeeeeeee
}

/**
 * ia_SqlOptionsSetDataData()
 *
 * @param array $arr
 * @param string|array $selected
 * @param array $extra
 * @param string $optionTag
 * @return string
 */
function ia_OptionsSetData($arr, $selected='', $extra = [], $optionTag=''):string {

    $ret='';
    if($extra) foreach($extra as $k=>$v)
		if(is_array($selected)) {
			$ret.= PHP_EOL."<option value='$k' ".(array_key_exists($k,$selected) ? " SELECTED='selected' " : " ")." $optionTag >".ia_htmlentities($v)."</option>";
		} else {
			$ret.= PHP_EOL."<option value='$k' ".(strcmp($selected,$k) ? " " : " SELECTED='selected' ")." $optionTag >".ia_htmlentities($v)."</option>";
		}
    foreach($arr as $k=>$v) {
        $optionTag_ = $optionTag;
        if ($k == '' || $k == '-') {
            $optionTag_ = '';
        }
        if(is_array($selected))
            $ret.= PHP_EOL."<option value='$k'".(array_key_exists($k,$selected) ? " SELECTED='selected' " : "");
        else
            $ret.= PHP_EOL."<option data-data='$k' value='$k'".(strcmp($selected,$k) ? "" : " SELECTED='selected' ");
        $i=0; $label='';
        if(is_array($v))
            foreach($v as $attr=>$val) {
                if($i === 1)
                    $label=$val;
                if( $i > 1 )
                    $ret.=" data-$attr='$val'";
                $i++;
            }
        else
            $label=$v;

        $ret.=" $optionTag_ >".ia_htmlentities($label)."</option>";
    }
	return $ret;
}

///////////////////////
/**
 * ia_Options_array()
 * pone options de un <select>
 *
 * @param array $array [value]=display o value=array(value,display,'html-tag'=>tag_value,,'html-tag'=>tag_value,...)
 * @param string $selected seleccionado actualmente
 * @param string $optionAttr opcional, atriubtos a agreagar a cada option
 * @param string $setColor true agrega style="color:color" de existir color en el $array
 * @param null $value
 * @param null $label
 * @return string
 */
function ia_Options_array($array, $selected = '', $optionAttr = '', $setColor = '', $value = null, $label = null):string {
    $pon=array('class','style','title');
    $ret='';
    $colorStyle = '';
	if( !empty( $array) ) foreach($array as $key =>$d) {
        $opts='';
        $id='';
        $text='';

        if(is_array($d) || is_object($d)) {
            $i=0;
            if($setColor !== '' )
                $colorStyle = array_key_exists($setColor, $d) ?
                    ' style="color:' .
                    ia_htmlentities($d[$setColor] === '#FFFFFF' ? 'black' : $d[$setColor]) . '" ' :
                    '';
            foreach($d as $k => $v) {
                // dd_('jaja', $d);
                $i++;
                if($i===1)
                    $id=$v;
                elseif($i===2)
                    $text=$v;
                elseif($i>2) {
                    if(in_array($k,$pon))
                        $opts.=" $k='".ia_htmlentities($v)."'";
                    else
                        $opts.=" data-$k='".ia_htmlentities($v)."'";
                }

                if (!empty($value)) {
                    $id = $d[$value];
                }
                if (!empty($label)) {
                    $text = $d[$label];
                }
            }
        } else {
            $text = $d;
            $id = $key;
        }

        if(is_array($selected)) {
			$ret.="\r\n<option $colorStyle value='$id' ".(in_array($id,$selected) ? " SELECTED='selected' " : "")." $optionAttr$opts>".ia_htmlentities($text)."</option>";
		} else {
			$ret.="\r\n<option $colorStyle value='$id' ".(strcmp($selected ?? '',$id) ? "" : " SELECTED='selected' ")." $optionAttr$opts>".ia_htmlentities($text)."</option>";
		}
	}
    return $ret;
}

/**
 * ia_Options_KeyDisplay()
 * pone options de un <select>
 *
 * @param array $array            [value]=display
 * @param array|string|null $selected         value seleccionado actualmente
 * @param string $optionAttr        opcional, atriubtos a agreagar a cada option
 * @return string
 */
function ia_Options_KeyDisplay($array, $selected='', $optionAttr=''):string {
    $ret='';
	if( !empty( $array) ) foreach($array as $k=>$d) {
		if(is_array($selected)) {
			$ret.="\r\n<option value='$k' ".(in_array($k,$selected) ? " SELECTED='selected' " : "")."$optionAttr>".ia_htmlentities($d)."</option>";
		} else {
			$ret.="\r\n<option value='$k' ".(strcmp($selected,$k) ? "" : " SELECTED='selected' ")."$optionAttr>".ia_htmlentities($d)."</option>";
		}
	}
    return $ret;
}

/**
* Portege un string o fecha de caracteres extra para el sql query
* @param string|int|float|null $s el string a proteger
* @return string el string $s protegido
*/
function strit($s):string  {
    if($s === null)
        $s = '';
    if(is_array($s)) return "''"; return "'".str_replace ("\\", "\\\\",str_replace("'","''", $s))."'"; }

/**
 * Protege los valores del array con strit
 *
 * @param array $array
 * @return array
 */
function strit_array($array):array {
    foreach($array as &$d)
        $d = strit($d);
    return $array;
}

/**
 * Protect with ` an sql name
 * Quotes a: column/table/db name to `column name` respecting . table.column to `table`.`column`
 *
 * @param string $fieldName
 * @return string
 */
function fieldit($fieldName):string {
    if($fieldName === '' || $fieldName[0] === '(')
        return $fieldName;

    $protected = [];
    $n = explode('.',$fieldName);
    foreach($n as $field) {
        $protected[]= '`'.str_replace(['`',"\r","\n","\t","\0"], '', strim($field) ).'`';
    }
    return implode('.', $protected);
}

    function strim($str):string|array {
        if($str === null)
            return '';
        if(is_array($str)) {
            foreach($str as &$d)
                $d = strim($d);
            return $str;
        }
        $s1 = preg_replace('/[\pZ\pC]/muS',' ',$str);
        if(preg_last_error()) {
            $s1 = preg_replace('/[\pZ\pC]/muS',' ',  iconv("UTF-8","UTF-8//IGNORE",$str));
            if(preg_last_error())
                return trim(preg_replace('/ {2,}/mS',' ',$str));
        }
        return trim(preg_replace('/ {2,}/muS',' ',$s1));
    }


/**
* Portege un string o fecha de caracteres extra para el sql query
* @param string|int|float|null $s el string a proteger
* @return string el string $s protegido terminado con una coma
*/
function stritc($s):string {
    if($s === null)
        $s = '';
    return "'".str_replace ("\\", "\\\\",str_replace("'","''", $s))."',"; }

/**
 * comillea()
 *
 * @param string|int|float|null $s
 * @return string
 */
function comillea($s):string  { if($s===null) return '"null"';  return '"'.str_replace('"',"'", $s).'"'; }
/**
 * jsit()
 *
 * @param string|int|float|null $s
 * @return string
 */
function jsit($s):string {
    if($s === null)
        return 'null';
    return '"'.str_replace( array("\\","\"","\'"),array("\\\\","\\\"","\\\'"),$s).'"';
}

/**
* Portege un string de javascript entre $entre apostrofes ' o comillas
* @param string|int|float|null $s el string a proteger
* @param string $entre ' o " El string sera puesto entre ' o "
* @return string el string $s protegido
*/
function javait($s, $entre="'"):string  {
    if($s === null)
        return "null";
    return $entre.str_replace ($entre, "\\'",str_replace("\\", "\\\\", $s)).$entre;
}

/////////////////////////////////// params ////////////////////////////////////////////////////

/**
* regresa el parametro llamado trimmed $name de $_REQUEST, si no existe busca en get, de no estar regresa $dflt
* @param string $name nombre del parametro a regresar
* @param mixed $dflt='' el valor a regresar de no existir el parametro. default ''
* @return mixed el parametro llamado $name en post o get array si es array, de no estar regresa $dflt
*/
function param($name, $dflt='', $trim=true):mixed {
    if(str_contains($name, "remark")) {
        return $_REQUEST[$name] ?? $dflt;
    }
    if(str_contains($name, "coment")) {
        return $_REQUEST[$name] ?? $dflt;
    }
    return $trim ? strim($_REQUEST[$name] ?? $dflt) :  $_REQUEST[$name] ?? $dflt;
}


/**
* regresa el parametro llamado $name en get en string o array, de no estar regresa $dflt
* @param string $name nombre del parametro a regresar
* @param mixed $dflt='' el valor a regresar de no existir el parametro. default ''
* @return mixed el parametro llamado $name en get, de no estar regresa $dflt
*/
#[Pure] function param_get($name, $dflt=''):mixed {
    return _keyTrimmed($_GET, $name, $dflt);
}

/**
* regresa el parametro trimmed llamado $name en post en string o array, de no estar regresa $dflt
 *
* @param string $name nombre del parametro a regresar
* @param mixed $dflt='' el valor a regresar de no existir el parametro. default ''
* @return mixed el parametro llamado $name en post, de no estar regresa $dflt
*/
#[Pure] function param_post($name, $dflt=''):mixed {
   return _keyTrimmed($_POST, $name, $dflt);
}

/**
 * regresa el parametro trimmed llamado $name del array $from en string o array, de no estar regresa $dflt.
 *
 * @param array $from
 * @param string $name nombre del parametro a regresar
 * @param mixed $dflt='' el valor a regresar de no existir el parametro. default ''
 * @return mixed el parametro llamado $name en post, de no estar regresa $dflt
 */
 function _keyTrimmed($from,string $name, $dflt):mixed {
    if( !array_key_exists($name,$from))
        return $dflt;
    if(is_array($from[$name])) {
        $arr = [];
        foreach($from[$name] as $k => $s) {
            $arr[$k] = is_array($s) ? $s : strim($s);
        }
        return $arr;
    }
    return strim($from[$name]);
}

/**
 * @param string|null $type null, post or get
 * @return array null: $_REQUEST, post:$_POST, get:$_GET
 */
function getParams($type = null):array
{
    if($type === null)
        return $_REQUEST ?? [];
    return $type === 'post' ? $_POST ?? [] : $_GET ?? [];
}

/**
 * Obtiene la diferencia entre 2 arrays. Ejemplo tests/ejemplo_arrayDiff.php
 *
 * @param array $a
 * @param array $b
 * @param float $delta para floats la diferencia debe ser mayor que
 * @return array [$keyConValorDiferente_1=>[$a[$k1], $b[$k1]], ...]
 *
 * @example tests/ejemplos/arrayDiff.php
 */
function arrayDiff(array $a, array $b, float $delta = 0.01):array {
    $diff = [];
    /*if(array_is_list($a) && array_is_list($b)) {
        return array_list_diff($a, $b, $delta);
    }*/
    foreach($a as $k => $d) {
        if(!array_key_exists($k, $b)) {
            $diff[$k] = [$d, null];
            continue;
        }
        $v = $b[$k];
        if($d === $v)
            continue;
        if(is_array($d)) {
            if(is_array($v)) {
                if($d == $v)
                    continue;
                $subArrayDiff = arrayDiff($d, $v, $delta);
                if(!empty($subArrayDiff))
                    $diff[$k] = $subArrayDiff;
                continue;
            }
            $diff[$k] = [$d, $v];
            continue;
        }
        if(is_array($v) || is_null($d) || is_null($v)) {
            $diff[$k] = [$d, $v];
            continue;
        }
        if((is_float($d) && is_float($v)) ||
            (is_numeric($d) && is_numeric($v))
        ) {
            // dd_($d,$v, abs($d), abs($v), bccomp($d, $v, 2));
            // if(abs($d - $v) > $delta )
//            if (bccomp($d, $v, 2)!=0)
            if(abs($d - $v) >= $delta )
                $diff[$k] = [$d, $v];
            continue;
        }
        if((is_string($d) || $d instanceof Stringable) &&
            (is_string($v) || $v instanceof Stringable)
        ) {
            if(strcasecmp($d, $v))
                $diff[$k] = [$d, $v];
            continue;
        }
        if($d != $v)
            $diff[$k] = [$d, $v];
    }
    foreach( array_diff_key($b, array_intersect_key($b, $a)) as $k => $soloEnB)
        $diff[$k] = [null, $soloEnB];
    return $diff;
}

if (!function_exists('array_is_list')) {
    function array_is_list(array $a) {
        return $a === [] || (array_keys($a) === range(0, count($a) - 1));
    }
}

function array_list_diff(array $a, array $b, float $delta = 0.01):array {
    if(!array_is_list($a) || !array_is_list($b))
        return arrayDiff($a, $b, $delta);
    $diff = [];
    $bLen = count($b);
    foreach($a as $k => $aValue) {
        if($k > $bLen - 1) {
            $diff[$k] = [$aValue, null];
            continue;
        }
        $bValue = $b[$k];
        if($aValue === $bValue)
            continue;
        if(is_array($aValue)) {
            if(is_array($bValue)) {
                $d = array_list_diff($aValue, $bValue, $delta);
                if(!empty($d))
                    $diff[$k] = $d;
                continue;
            }
            $diff[$k] = [$aValue, $bValue];
            continue;
        }
        if(is_array($bValue)) {
            $diff[$k] = [$aValue, $bValue];
            continue;
        }
        if(in_array($aValue, $b)) {
           continue;
        }
        $diff[$k] = [$aValue, $bValue];
    }
    return $diff;
}

function file_upload_error($err):string {
    if( $err==0)
	   return '';
   elseif( $err==1)
	      return 'El archivo es demasiado grande';
   elseif( $err==2)
	      return 'El archivo es demasiado grande';
   elseif($err==3)
	      return 'Solo subio parte del archivo';
   elseif( $err==4)
	      return 'No subio el archivo';
   elseif( $err==6)
	      return 'No subio el archivo a tmp';
   elseif( $err==7)
	      return 'Error al escribir el archivo';
   elseif( $err==8)
	      return 'Tipo de archivo invalido';
   else
    return 'Error al subir el archivo';
}

/**
 * uploadErrorStr()
 *
 * @param string|int $indx
 * @return string
 */
function uploadErrorStr($indx):string {
    if( $_FILES[$indx]['error']==0)
	   return '';
   elseif( $_FILES[$indx]['error']==1)
	      return 'El archivo es demasiado grande';
   elseif( $_FILES[$indx]['error']==2)
	      return 'El archivo es demasiado grande';
   elseif( $_FILES[$indx]['error']==3)
	      return 'Solo subio parte del archivo';
   elseif( $_FILES[$indx]['error']==4)
	      return 'No subio el archivo';
   elseif( $_FILES[$indx]['error']==6)
	      return 'No subio el archivo a tmp';
   elseif( $_FILES[$indx]['error']==7)
	      return 'Error al escribir el archivo';
   elseif( $_FILES[$indx]['error']==8)
	      return 'Tipo de archivo invalido';
   else
    return 'Error al subir el archivo';
}

/////////////////////////////////////// ip //////////////////////////////////////////
/**
 * ip_extract()
 *
 * @param string $ip
 * @return array
 */
function ip_extract($ip): array
{
    if (filter_var($ip, FILTER_VALIDATE_IP))
        return [$ip];
    $array = [];
	if (@preg_match("/(\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3})/", $ip, $array))
		return $array;
    $regexIPV6 = '/((([0-9a-fA-F]){1,4})\\:){7}([0-9a-fA-F]){1,4}/i';
    $array = [];
    if (@preg_match($regexIPV6, $ip, $array))
        return $array;
    if(str_contains(strtolower($ip), 'localhost'))
        return ['localhost'];
    return [];
}
/**
 * ip_server_set()
 *
 * @param string $cual
 * @return bool
 */
function ip_server_set($cual):bool {
  if(  !array_key_exists($cual,$_SERVER) )
     return false;
  return   strcasecmp($_SERVER[$cual],'unknown') !== 0 && $_SERVER[$cual] !== '';
}
/**
 * ip_get()
 *
 * @return string
 */
function ip_get():string {
    $keys = ['HTTP_X_FORWARDED_FOR', 'HTTP_X_FORWARDED','HTTP_FORWARDED_FOR','HTTP_FORWARDED',
        'HTTP_CLIENT_IP','HTTP_VIA','HTTP_COMING_FROM','HTTP_X_COMING_FROM',
        'REMOTE_HOST','REMOTE_ADDR'
    ];
    foreach($keys as $key)
        if(array_key_exists($key, $_SERVER)) {
            $ip = ip_extract($_SERVER[$key]);
            if(count($ip) >= 1)
                return $ip[0];
        }
    return '';
}
/**
 * ip_getFull()
 *
 * @return string
 */
#[Pure] function ip_getFull():string {
    $keys = ['HTTP_X_FORWARDED_FOR', 'HTTP_X_FORWARDED','HTTP_FORWARDED_FOR','HTTP_FORWARDED',
        'HTTP_CLIENT_IP','HTTP_VIA','HTTP_COMING_FROM','HTTP_X_COMING_FROM',
        'REMOTE_HOST','REMOTE_ADDR'
    ];
    $fullIp = [];
    foreach($keys as $key)
        if(array_key_exists($key, $_SERVER))
            $fullIp[] = "$key: " . $_SERVER[$key];
    return implode(', ', $fullIp);
}

////////////////////// HTML //////////////////////////////////////////////////////////////////////////

  /**
   * redirect()
   *
   * @param string $url
   * @return void
   */
  function redirect($url) {
   $requestProtocol = array_key_exists('SERVER_PROTOCOL',$_SERVER)  ? $_SERVER["SERVER_PROTOCOL"] : 'HTTP/1.0';
   $protocolArr = explode("/",$requestProtocol);
   $protocolName = isset($protocolArr[1]) ? trim($protocolArr[0]) : 'HTTP/1.0';
   $protocolVersion = isset($protocolArr[1]) ? trim($protocolArr[1]): '';
   if (stristr($protocolName,"HTTP") && strtolower($protocolVersion) > "1.0" ) {
     $httpStatusCode = 307;
   } else {
      $httpStatusCode = 302;
   }
   $httpStatusLine = "$requestProtocol $httpStatusCode Temporary Redirect";
   @header($httpStatusLine, TRUE, $httpStatusCode);
   @header("Location: $url");
  }

/**
 * @return string root del site https://dominio/vitex  sin la diagonal final
 */
  function siteRootUrl():string {
      global $gWebDir;
      return
        (empty($_SERVER['HTTPS']) ? "http://$_SERVER[SERVER_NAME]" : "https://$_SERVER[SERVER_NAME]") .
          ":$_SERVER[SERVER_PORT]/$gWebDir";
  }

/**
 * ia_convertBytes()
 *
 * @param string|int|float $bytes
 * @return string
 */
function ia_convertBytes($bytes):string {
    if(empty($bytes) || !is_numeric($bytes))
        return $bytes;
    if($bytes<0) {
        $signo = '-';
        $bytes *= -1;
    } else
        $signo='';
    if($bytes<=1024) {
        $decs=0;
        $punto='';
    } else {
        $decs=2;
        $punto='.';
    }
    $unit=array('b','Kb','Mb','Gb','Tb','Pb');

    /** @noinspection PhpRedundantOptionalArgumentInspection */
    return $signo.@number_format($bytes/@pow(1024,
                ($i=floor(log($bytes,1024)))),
            $decs,$punto,',').' '.$unit[$i];
}


/**
 * ia_errores_a_dime()
 *
 * @param string $message
 * @param string $file
 * @param string $error_type
 * @param int|string $line
 * @param string $md5
 * @param bool $showSqlTrace
 * @return void
 * @noinspection PhpUnusedParameterInspection
 */
function ia_errores_a_dime($message = '', $file = '', $error_type = 'Manual', $line = 0,
                          $md5 = '', $showSqlTrace = false):void {
global $gSqlClass, $gNewDime;
    require_once(__DIR__ . '/ErrorReporter/iaErrorReporter.php');
    $gNewDime = new iaErrorReporter($gSqlClass); // ia\Log\
    if(!empty($message)) {
        $gNewDime->errorManual($message, $file, $error_type, $line, $md5);
    }
    $gNewDime->process();
}



/**
 *
 *
 * @param bool $scriptTime
 * @param bool $rusage
 * @param bool $ram
 * @param bool $sqlErrors
 * @param bool $sqlTrace
 * @param bool $phpErr
 * @return string
 * @noinspection PhpUnusedParameterInspection
 */
function ia_report_status_collapsable(
    $scriptTime=true, $rusage=true, $ram=true, $sqlErrors=true, $sqlTrace=true, $phpErr=true):string {
    global $gNewDime, $gSqlClass, $gDebugging;
    if(empty($gNewDime))
        $gNewDime = new iaErrorReporter($gSqlClass);
    if($gNewDime->displayErrors())
        echo "<script>gDisplayErrorInPage = true; jQuery(function(){  _displayErrorInPage(); }); </script>";
    else
        echo "<script>gDisplayErrorInPage = false;</script>";
    if($gDebugging)
        file_debug_reporte();
    return '';
}


// files
/**
 * file_size_formatted()
 *
 * @param string|int|float $size
 * @return string
 */
function file_size_formatted($size):string {
    $size = (float)$size;
    if($size<1024)
        return $size.'b';
    if($size<1024*1024)
        return round($size/1024.00).'Kb';
    if($size<1024*1024*1024)
        return round($size/(1024.00*1024.00),1).'Mb';
    return round($size/(1024.00*1024.00*1024.00),1).'Gb';
}

/**
 * file_is_image()
 *
 * @param string $fileName
 * @return bool
 */
function file_is_image($fileName):bool {
    $dot=strrpos($fileName,'.');
    if($dot===FALSE)
        return false;
    $ext=substr($fileName,$dot+1);
    return (strcasecmp($ext,'jpg') === 0 || strcasecmp($ext,'jpeg') === 0 ||
        strcasecmp($ext,'gif') === 0 || strcasecmp($ext,'png') === 0 );
}

/**
 * file_icon()
 *
 * @param string $fileName
 * @return string
 */
function file_icon($fileName):string {
global $gIApath;

    $dot=strrpos($fileName,'.');
    if($dot === FALSE)
        return '';
    $ext=substr($fileName,$dot+1);
    if(strcasecmp($ext,'jpg')===0 || strcasecmp($ext,'jpeg')===0 ||
        strcasecmp($ext,'gif')===0 || strcasecmp($ext,'png')===0 ||
        strcasecmp($ext,'bmp')===0 || strcasecmp($ext,'ico')===0 )
        return "$gIApath[WebPath]img/ext/jpg.gif";
    if(strcasecmp($ext,'avi')===0 || strcasecmp($ext,'mpeg')===0 ||
        strcasecmp($ext,'rm')===0 || strcasecmp($ext,'wmp')===0 )
        return "$gIApath[WebPath]img/ext/video.gif";
    $gifs=array('csv','doc','docx','gif','htm','html','jpeg','jpg','pdf','png','pps','ppsx','ppt','pptx','video','wav','xls','xlsx');
    if(in_array($ext,$gifs))
        return "$gIApath[WebPath]img/ext/$ext.gif";
    return "$gIApath[WebPath]img/ext/clip.gif";
}

// IMAGES
/**
 * ia_image_tag_size()
 *
 * @param mixed $imageFile
 * @return string
 */
function ia_image_tag_size(mixed $imageFile):string {
try {
    if(!file_exists($imageFile) )
        return '';
    $size = filesize($imageFile);
    if($size === FALSE)
        $size = '';
    else
        $size = file_size_formatted($size);
    if(file_is_image($imageFile)) {
        $arr = @getimagesize($imageFile); // 0=width, 1=height, 3=height, width tag
        if($arr === FALSE || !is_array($arr) || sizeof($arr) < 4)
            return $size;
        return "w: $arr[0]px h:$arr[1]px $size";
    }
    return $size;
} catch(Exception) { return ''; }
}

/**
 * @param int|float|string $w
 * @param int|float|string $h
 * @param bool $cssFormat
 * @return string
 */
function ia_img_format($w, $h, $cssFormat):string { if($cssFormat) return "width: $w"."px; height: $h".'px'; return "width='$w' height='$h'"; }

/**
 * ia_image_tagsize_fitmax()
 * ajusta imagen al tamaño
 * @param mixed $imageFile path fisico a imagen o array(0=>w,1=>h)
 * @param string|int $max_width maximo width deseado, 0 cualsea
 * @param string|int $max_height maximo height deseado, 0 cualsea
 * @param bool $cssFormat true regresa css flase
 * @param bool $enLarge
 * @return string en $cssFormat true width:npx; height:xpx en false width='xpx' height='ypx'
 */
function ia_image_tagsize_fitmax( $imageFile, $max_width, $max_height,
                                 $cssFormat=true, $enLarge=false):string {
try {
    if(is_array($imageFile))
        $arr=$imageFile;
    else {
        if (!file_exists($imageFile))
            return '';
        $arr=@getimagesize($imageFile); // 0=width, 1=height, 3=height, width tag
        if($arr===FALSE || !is_array($arr) || sizeof($arr)<4) return '';
    }
    $w=$arr[0];
    $h=$arr[1];

    if(!empty($max_width) && !empty($max_height) ) {

        if($w==$max_width && $h==$max_height)
            return ia_img_format($w,$h,$cssFormat);
        if(!$enLarge && $w<=$max_width && $h<=$max_height)
            return ia_img_format($w,$h,$cssFormat);
        if($w==0 || $h==0)
           return ia_img_format($max_width,$max_height,$cssFormat);
        if($enLarge && $w <= $max_width && $h <= $max_height) {
            if($w>$h)
                return ia_img_format($max_width,round($max_width*$h/$w),$cssFormat);
            else
                return ia_img_format(round($max_height*$w/$h),$max_height,$cssFormat);
        }
        if( $w>$max_width && $h<=$max_height)
            return ia_img_format($max_width,round($max_width*$h/$w),$cssFormat);
        if( $w<=$max_width && $h>$max_height)
            return ia_img_format(round($max_height*$w/$h),$max_height,$cssFormat);
        // ambas mayores
        if($w>=$h)
            return ia_img_format($max_width,round($max_width*$h/$w),$cssFormat);
        else
            return ia_img_format(round($max_height*$w/$h),$max_height,$cssFormat);
    }
    if(empty($max_height)) {

        if($w==$max_width)
            return ia_img_format($w,$h,$cssFormat);
        if( $w <= $max_width) {
            if( $enLarge )
                return ia_img_format($max_width,round($max_width*$h/$w),$cssFormat);
            else
                return ia_img_format($w,$h,$cssFormat);
        }
        return ia_img_format($max_width,round($max_width*$h/$w),$cssFormat);
    }
    if(empty($max_width)) {

        if($h == $max_height)
            return ia_img_format($w,$h,$cssFormat);
        if($h <= $max_height) {
            if( $enLarge ) {
                return ia_img_format(round($max_height*$w/$h),$max_height, $cssFormat);
            } else {
                return ia_img_format($w,$h,$cssFormat);
            }
        }
        return ia_img_format(round($max_height*$w/$h),$max_height,$cssFormat);
    }
    return ia_img_format($w,$h,$cssFormat );
} catch(Exception) { return ''; }
}

/**
 * removeAccents()
 *
 * @param string $str
 * @return string
 */
function removeAccents($str):string {
    //return URLify::filter($str); Ademas quita los caracteres raros https://github.com/jbroadway/urlify
    return URLify::downcode($str);
    //return strtr(utf8_decode($str), utf8_decode('àáâãäçèéêëìíîïñòóôõöùúûüýÿÀÁÂÃÄÇÈÉÊËÌÍÎÏÑÒÓÔÕÖÙÚÛÜÝ'), 'aaaaaceeeeiiiinooooouuuuyyAAAAACEEEEIIIINOOOOOUUUUY');
}

/**
 * filename_safe()
 *
 * @param string $fileName
 * @return string
 */
function filename_safe($fileName):string {
    if(str_starts_with($fileName, '.'))
        $fileName='_'.substr($fileName,1);
    return str_replace(array('|','>', '<', '&', ' ','(',')','-','*','?','!','|','`'.'Ã‚Â´','"',"'".'..'.DIRECTORY_SEPARATOR,DIRECTORY_SEPARATOR,"\\","/",'[',']','{','}')
        ,'_',removeAccents($fileName));
}

/**
 * filename_extension()
 *
 * @param mixed $fileName
 * @return string
 */
function filename_extension($fileName):string  {
    $pos=strrchr($fileName,'.');
    if($pos===FALSE || $pos==$fileName)
        return '';
    return substr($pos,1);
}

/**
 * error_last()
 *
 * @return string
 */
function error_last():string  {
    if ( !function_exists('error_get_last'))
        return '';
    $tmp=error_get_last();
    if($tmp)
        return "Error($tmp[type]): $tmp[message] at $tmp[file] line $tmp[line]";
    else
        return '';
}


/// ia_case specific
    global $gAppRelate;
    /**
     * gAppRelate_set()
     *
     * @return void
     */
    function gAppRelate_set() {
    global $gAppRelate;
        if(  empty($gAppRelate) )
            $gAppRelate=new appRelate();
    }

     /* @noinspection PhpUnused */
   // function vale_where() {}

    /**
     * array_val()
     * Regresa el valor de key en el array o default de no existir
     * @param string $key
     * @param array $array
     * @param mixed $default
     * @return mixed valor de $key en el array o $default de no existir
     */
    function array_val($key, $array, $default = false): mixed
    {
        if(array_key_exists($key,$array))
            return $array[$key];
        return $default;
    }

    function _numOr0($n):string|int|float {
        return is_numeric($n) ? $n : 0;
    }

    /**
     * date_limit()
     *
     * @param int|float|string|null $lim
     * @param string|null $base_date
     * @param bool $incluye_dom
     * @param bool $incluye_sab
     * @param bool $forzaInicioAno
     * @return string
     */
    function date_limit($lim, $base_date = null,
                        $incluye_dom = true, $incluye_sab = true, $forzaInicioAno = false):string {
        if(empty($lim)) {
            return '';
        }
        if( preg_match('/^\d{4}-(0[1-9]|1[0-2])-(0[1-9]|[1-2]\d|3[0-1])$/', $lim)  ) {
            return $lim;
        }
        if( is_numeric($lim)) {
            if(strlen($lim ) === 4) {
                return "$lim-01-01";
            }
            if(strlen($lim ) > 6) {
                return Date('Y-m-d', $lim );
            }
        }

        if(empty($base_date)) {
            $base_date = Date('Y-m-d');
        }
        $baseTimeStamp = strtotime($base_date);
        $base_year = _numOr0(substr($base_date,0,4) );


        $anos = $meses = $semanas = $dias = 0;
        $tmp=explode(' ',$lim);
        if($tmp) {
            foreach ($tmp as $d) {
                $d = trim($d);
                if (stripos($d, 'y') !== false) {
                    $anos += _numOr0(str_ireplace('y', '', $d));
                } elseif (stripos($d, 'm') !== false)
                    $meses += _numOr0(str_ireplace('m', '', $d));
                elseif (stripos($d, 'w') !== false) {
                    $semanas += _numOr0(str_ireplace('w', '', $d));
                }
                elseif (stripos($d, 'd') !== false) {
                    $dias += _numOr0(str_ireplace('d', '', $d));
                }
                else {
                    $dias += _numOr0($d);
                }
            }
        }

        $fecha = mktime(0,0,0,
            (int)Date('n',$baseTimeStamp) + $meses,
            (int)Date('j',$baseTimeStamp) + $dias + ($semanas * 7),
            $base_year + $anos);

        $notSab = !$incluye_sab;
        $notDom = !$incluye_dom;
        if($notDom || $notSab) {
            $diffDias = abs(round(($fecha - $baseTimeStamp) / 86400) + 1);
            $masDias = floor($diffDias / 7) * ($notDom && $notSab ? 2 : 1);
            $diasem = (int)date("w", $fecha);
            if($diasem === 6 && $notSab) {
                $masDias++;
            }
            if($diasem === 0 && $notDom) {
                $masDias++;
            }
            $diasem = (int)date("w", $baseTimeStamp);
            if($diasem === 6 && $notSab) {
                $masDias++;
            }
            if($diasem === 0 && $notDom) {
                $masDias++;
            }
            $fecha=mktime(0,0,0,
                (int)Date('n', $fecha),
                (int)Date('j', $fecha) + $masDias,
                (int)Date('Y', $fecha)
            );
        }

        return $forzaInicioAno ? Date('Y-01-01', $fecha) : Date('Y-m-d',$fecha);
    }

    /**
     * to_plural()
     *
     * @param string $word
     * @param bool $esMasculino
     * @return string
     */
    function to_plural($word, $esMasculino = true):string {
        $w=substr($word,-1);

        if(strcasecmp('.',$w)==0) //VCA
            return $word;

        if(    strcasecmp('a',$w)==0 || strcasecmp('e',$w)==0  || strcasecmp('i',$w)==0  || strcasecmp('o',$w)==0  || strcasecmp('u',$w)==0
            || strcasecmp('á',$w)==0 || strcasecmp('é',$w)==0  || strcasecmp('í',$w)==0  || strcasecmp('ó',$w)==0  || strcasecmp('Ú',$w)==0
            || strcasecmp('y',$w)==0 || strcasecmp('w',$w)==0 )
            return $word.'s';
        if(strcasecmp('z',$w)==0)
            return substr($word,0,-1).'ces';
        $w2=substr($word,-2,1);
        if(strcasecmp('s',$w)==0 && ( strcasecmp('e',$w2)==0 || strcasecmp('u',$w2) ))
            return $word;
        if($esMasculino)
            return $word.'es';
        else
            return $word.'as';
    }

	/**
	 * to_label()
	 *
	 * @param string $fieldName
	 * @param bool $capWords
	 * @param bool $htmlentities
	 * @return string
	 */
	function to_label($fieldName, $capWords = true, $htmlentities = false ):string {
        $ret=preg_replace(
            array('/\baccion\b/i','/\baleman\b/i','/\balmacen\b/i','/\bano\b/i','/\banos\b/i','/\barea\b/i','/\bareas\b/i','/\barticulo\b/i','/\barticulos\b/i'
                    ,'/\bbitacora\b/i','/\bbitacoras\b/i'
                    ,'/\bcalculo\b/i','/\bcaracter\b/i','/\bcatalogo\b/i','/\bcatalogos\b/i','/\bcodigo\b/i','/\bcomentario\b/i','/\bcompania\b/i','/\bcompanias\b/i','/\bcp\b/i'
                    ,'/\bdepostio\b/i','/\bdepostios\b/i','/\bdia\b/i','/\bdias\b/i','/\bdigito\b/i','/\bdigitos\b/i','/\bdolar\b/i','/\bdolares\b/i'
                    ,'/\beconomia\b/i','/\belectronica\b/i','/\belectronico\b/i','/\belectronicos\b/i','/\bespanol\b/i'
                    ,'/\binteres\b/i','/\bimagenes\b/i','/\bindice\b/i','/\bindices\b/i','/\bingles\b/i'
                    ,'/\bfabrica\b/i','/\bfrances\b/i','/\bfotografica\b/i'
                    ,'/\bgrafica\b/i'
                    ,'/\bhuesped\b/i'
                    ,'/\blimite\b/i'
                    ,'/\bmaquina\b/i','/\bmaquinas\b/i','/\bmaximo\b/i','/\bmaximos\b/i','/\bmecancia\b/i','/\bmedico\b/i','/\bmexico\b/i','/\bmiercoles\b/i','/\bminimo\b/i','/\bminimos\b/i','/\bmusica\b/i'
                    ,'/\bnumero\b/i','/\bnumeros\b/i'
                    ,'/\bpagina\b/i','/\bpaginas\b/i','/\bpais\b/i','/\bpaises\b/i','/\bparticula\b/i','/\bpelicula\b/i','/\bpie\b/i','/\bpolitica\b/i','/\bportuges\b/i','/\bpublico\b/i'
                    ,'/\brazon\b/i','/\bresumen\b/i'
                    ,'/\bsabado\b/i'
                    ,'/\btecnica\b/i','/\btelefono\b/i','/\btelefonos\b/i','/\btio\b/i','/\btitulo\b/i','/\btitulos\b/i','/\btunel\b/i'
                    ,'/\bunica\b/i','/\bunico\b/i','/\bultimo\b/i','/\bultimos\b/i','/\bultima\b/i','/\bultimas\b/i'
                    ,'/\busuario\b/i'
                    ,'/ion\b/i'
                   )
            ,array('acción','alemán','almacén','año','años','área','áreas','artículo','artículos'
                ,'bitácora','bitácoras'
                ,'cálculo','caractér','catálogo','catálogos','código','comentario','compañía','compañias','C.P.'
                ,'depósito','depósitos','día','días','dígito','dígitos','dólar','dólares'
                ,'economía','electrónica','electrónico','electrónicos','español'
                ,'interés','imágenes','índice','índices','inglés'
                ,'fábrica','fránces','fotográfica'
                ,'gráfica'
                ,'huésped'
                ,'límite'
                ,'máquina','máquinas','máximo','máximos','mecánica','médico','México','miércoles','mínimo','mínimos','música'
                ,'número','números'
               ,'página','páginas','país','paises','partícula','película','pié','política','portugués','público'
               ,'razon','resumen'
               ,'sábado'
               ,'tecnica','teléfono','teléfonos','tio','título','títulos','túnel'
               ,'Única','Único','Último','Últimos','Última','Últimas'
               ,'usuario'
               ,'ión'
            )
            ,preg_replace(
                array('/^idioma_/','/^kv_/','/^iac_/','/_id$/','/_/')
                ,array('','','','',' ')
                ,$fieldName ?? ''
            )
        );
        if($ret === 'rfc' || $ret === 'curp' || $ret === 'imss' || $ret === 'cp')
            return strtoupper($ret);
        if($capWords)
            $ret=ucwords($ret ?? '');
        if($htmlentities)
            return ia_htmlentities( str_replace( array(' De ',' A ',' Del ',' Al ',' El ',' La ',' Las ',' Los '), array(' de ',' a ',' del ', ' al ', ' el ',' la ',' las ',' los '),$ret ) );
        else
            return str_replace( array(' De ',' A ',' Del ',' Al ',' El ',' La ',' Las ',' Los '), array(' de ',' a ',' del ', ' al ', ' el ',' la ',' las ',' los '),$ret );
}



/**
 * @param int|string $month
 * @param int|string $day
 * @param int|string $year
 * @return false|int
 */
    function ia_mktime_day($month, $day, $year):false|int {
        return mktime(0,0,0,$month,$day,$year);
    }

function array2Select(
    $datos, $key, $valor, $set_val = null, $identifier = 'select', $label = 'Seleccione',
    $onlyOptions = false, $addNull = true, $extra_data = [], $extra_html = ['html'=> '', 'keys' => []], $height_personal = null,
    $isSelectize = true, $group= null, $width = ""
): string
{
    $class = (!$isSelectize) ? 'notSelectize' : 'selectize';
    $style = empty($width) ? "" : " style='width: $width;' ";
    $select = $onlyOptions ? "" : "<select class='$class' name='$identifier' id='$identifier' $style>";
    if($addNull) {
        $select .= "<option value=''>$label</option>";
    }
    $keysReplace = $extra_html['keys'] ?? [];//'color_valor';

    if (!empty($group)){
        $datos = objetivisa_($datos, $group);
        foreach ($datos as $array_key => $items) {
            // dd_("ITEMS", $items);
            $options = "";
            foreach ($items as  $item) {
                $extraData = "";
                foreach ($extra_data as $label_extra => $key_extra) {
                    $dataLabel = (is_numeric($label_extra)) ? $key_extra: $label_extra;
                    $extraData .= " data-$dataLabel='$item[$key_extra]' ";
                }
                $item = (array) $item;

                $data_extra_html = $extra_html['html'] ?? '';
                foreach ($keysReplace as $keyReplace) {
                    $strReplace = "{@$keyReplace}";
                    $data_extra_html = str_replace($strReplace, $item[$keyReplace], $data_extra_html);
                }
                if (!empty($data_extra_html)) {
                    $data_extra_html = " data-extra_html='$data_extra_html' ";
                }
                $data_height_personal = '';
                if (!empty($height_personal)) {
                    $data_height_personal = " data-height_personal='$height_personal' ";
                }
                $selected = "";
                if (is_array($set_val)) {
                    if (in_array($item[$key], $set_val)) {
                        $selected = "selected='selected'";
                    }
                } else {
                    $selected = (string)$item[$key] === (string)$set_val ? "selected='selected'" : "";
                }
                $options .= "<option value='".ia_htmlentities($item[$key])."' $selected $extraData $data_extra_html $data_height_personal>".ia_htmlentities($item[$valor])."</option>";
            }
            $label = strtoupper($array_key);
            $select .= "<optgroup label='$label'>$options</optgroup>";
        }
    }
    else {
        foreach ($datos as  $item) {
            $extraData = "";
            foreach ($extra_data as $label_extra => $key_extra) {
                $dataLabel = (is_numeric($label_extra)) ? $key_extra: $label_extra;
                $extraData .= " data-$dataLabel='$item[$key_extra]' ";
            }
            $item = (array) $item;

            $data_extra_html = $extra_html['html'] ?? '';
            foreach ($keysReplace as $keyReplace) {
                $strReplace = "{@$keyReplace}";
                $data_extra_html = str_replace($strReplace, $item[$keyReplace], $data_extra_html);
            }
            if (!empty($data_extra_html)) {
                $data_extra_html = " data-extra_html='$data_extra_html' ";
            }
            $data_height_personal = '';
            if (!empty($height_personal)) {
                $data_height_personal = " data-height_personal='$height_personal' ";
            }
            $selected = "";
            if (is_array($set_val)) {
                if (in_array($item[$key], $set_val)) {
                    $selected = "selected='selected'";
                }
            } else {
                $selected = (string)$item[$key] === (string)$set_val ? "selected='selected'" : "";
            }

            $select .= "<option value='".ia_htmlentities($item[$key])."' $selected $extraData $data_extra_html $data_height_personal >" . ia_htmlentities($item[$valor])." </option>";
        }
    }
    return $onlyOptions ? $select : "$select</select>";

}

function colores($lang = 'es'):array
{
    $colores = [
        'blue' =>	'azul',
        'green' =>	'verde',
        'red' =>	'rojo',
        'orange' =>	'naranja',
        'yellow' =>	'amarillo',
        'pink' =>	'rosa',
        'purple' =>  'morado',
        'black' =>	'negro',
        'white' =>	'blanco',
        'grey' =>   'gris',
        'gray' => 	'gris',
        'brown' =>	'marrón',
        'violet' =>	'violeta',
    ];
    if ($lang === 'es') {
        $colores = array_flip($colores);
    }
    return $colores;
}

#[NoReturn]
function die_Script()
{
    echo "<script>$(document).ready( function() { setTimeout(function() { $('#loadingMask').fadeOut(0); }, 10); });</script>";
    ia_errores_a_dime();
    die();
}

function json_encode_ex($array, $flags = JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE):string {
    $var = json_encode($array, $flags);
    preg_match_all('/(\"function.*?\")|(\"on_.*?\")|(\"\$d.*?\")|(\"colFmt.*?\")|(\"ia.*?\")/', $var, $matches);
    foreach ($matches[0] as  $value) {
        $newval = str_replace(array('\n', '\t','\/'), array(PHP_EOL,"\t",'/'), trim($value, '"'));
        $var = str_replace($value, $newval, $var);
    }
    return $var;
}

/**
 * @param object|null $app
 * @param string $default
 * @param array $groupingOrder En que orden y que agrupaciones poner
 * @param string $labelPara
 * @param string $prefijo
 * @noinspection PhpUnusedParameterInspection
 */
function table_jqgrid_existencias(object|null $app = null, string $default = 'group_ProductoColorBodega', array $groupingOrder = [],
                                  string $labelPara = '', string $prefijo = '')
{

    $existencias = new Existencias($app, $default,
        empty($groupingOrder) ? [$default] : $groupingOrder);
    $existencia = $existencias->getThisExistenciaList();

    if(!empty($groupingOrder))
        $existencia['groups'] = array_intersect_key($existencia['groups'], array_flip($groupingOrder));
    $selectGroups =
        "<label for='groups_existencias'>con: </label>
        <select id='groups_existencias' class='notSelectize' style='cursor:pointer' onchange='setNewGrouping(this.value)'>".
            array2Select(datos: $existencia['groups'], key: 'value_group', valor: 'label', set_val: $default, onlyOptions: true, addNull: false)
        ."</select>
        <img style='cursor:pointer; margin-left: 2em;height:24px;width: 24px;border:0 silver solid;' src='../img/expandOne.png' alt='Expand one' title='Expand one' onclick='iaJqGridGrouping.expandOne(gridhandlerExistencia)' id='expand_one_existencias'>
        <img style='cursor:pointer; margin-left: 2em;height:32px; width:32px;border:0 silver solid;' src='../img/collapseAll.png' alt='Collapse all' title='Collapse all' onclick='iaJqGridGrouping.collapseAll(gridhandlerExistencia)' id='collapse_all_existencias'> 
        <img style='cursor:pointer; margin-left: 2em;height:32px; width:32px ;border:0 silver solid;' src='../img/expandAll.png' alt='Expand all' title='Expand all' onclick='iaJqGridGrouping.expandAll(gridhandlerExistencia)' id='expand_all_existencias'> 
        <style>
        img:hover{
            opacity: .5;
            overflow:visible;
            border:0 solid rgba(0,0,0,0.7);
            box-sizing:border-box;
            transition: all 0.4s ease-in-out; }
        </style>";

    echo "<fieldset class='lblgrp'><legend style='vertical-align: top;'>&nbsp;Existencia $labelPara $selectGroups</legend>";
    include_once (dirname(__DIR__).'/bodega/componentes/jqgrid_existencias_list.php');
    echo "</fieldset>";
}


/** @noinspection PhpUnusedParameterInspection */
function table_productos_remate($params = [])
{
    /*$queryProductos = "SELECT
                    producto_general_id, producto, en_remate, es_saldo, min_price,
                    producto value, producto label, producto_general_id real_value
                   FROM producto_general WHERE activo = 'Si' ORDER BY producto";
    $productos = ia_sqlArray($queryProductos, 'producto_general_id');
    $queryColores = "SELECT
                    pc.producto_general_id pg_id, pc.producto_color_id, pc.producto_general_id, pc.color_id, c.color, c.color_valor,
                    pc.en_remate, pc.es_saldo
                FROM producto_color pc
                JOIN color c USING(color_id) ORDER BY c.orden, c.color";
    $colores = ia_sqlSelectMultiKey($queryColores, 2);*/
    return include_once (dirname(__DIR__).'/bodega/componentes/table_productos_remate_list.php');
}

/**
 * Cambia keys de $array ['producto_id'=>3, 'color'=>4], $newKeys=['color'=>'color.color'] regresa ['producto_id'=>3, 'color.color'=>4]
 *
 * @param array $array ie ['producto_id'=>3, 'color'=>4]
 * @param array $newKeys ie ['color'=>'color.color']
 * @return array ie ['producto_id'=>3, 'color.color'=>4]
 */
function keyRemap(array $array, array $newKeys):array {
    $reMapped = [];
    foreach($array as $k => $v)
        $reMapped[ $newKeys[$k] ?? $k] = $v;
    return $reMapped;
}

/**
 * Regresa el label para bodegas.
 * @param array $bodega - [bodega => 'verde', label_bodega|label=> 'Clavel', bodega_id=> 'abcd1278y', color|bodega_color=> '##008000'].
 * @param array $extraSettings - [returnColor=> true|false, returnNane=> true|false, returnLabel=> true|false, isAnchor=> true|false, urlAnchor: '../../../', titleAnchor: 'titulo de ancla'].
 *      - returnColor: Para regresar indicador de color.
 *      - returnNane: Para regresar el nombre de la bodega.
 *      - returnLabel: Para regresar la clave de la bodega.
 *      - isAnchor: Para indicar que es un anchor (<a href=link a la bodega></a>).
 *      - urlAnchor: Para indicar la url del anchor.
 */
function getLabelBodega(array $bodega = [], array $extraSettings = []): string
{
    if (!is_array($bodega) || count(array_keys($bodega)) == 0) return '';

    $settings = array_merge(
        ['returnColor' => true, 'returnNane' => true, 'returnLabel' => true, 'isAnchor' => false, 'urlAnchor' => null, 'titleAnchor' => null, 'IsHtml' => true,
        'classes' => ''
        ],
        $extraSettings)
    ;

    $color = $bodega['bodega_color'] ?? $bodega['color'] ?? '#FFF';
    $sectionColor = $settings['returnColor'] ? "<i style='background-color:$color; width: 1em; height: 1em; display: inline-block;margin-right: 5px; border: 1px solid black;'></i>":'';
    $sectionName = $settings['returnNane'] ? $bodega['bodega'] ?? '': '';
    $label = $bodega['label_bodega'] ?? $bodega['label'] ?? '';
    if($label !== '.' && $label !== '')
        $sectionLabel = $settings['returnLabel'] ? "<i style='font-weight:100;font-size:smaller'>($label)</i>": '';
    else
        $sectionLabel = '';

    if(empty($settings['grupo']))
        $grupo = '';
    else
        $grupo = empty($bodega['grupo']) ? '' : ' <i style="font-size:0.7em;font-weight: 100">' . ia_htmlentities($bodega['grupo']) . '</i> ';

    if (!$settings['IsHtml']) {
        return "$sectionName ($label)";
    }

    $clases = '';
    if (!empty($settings['classes']))
        $clases = $settings['classes'];

    if (!$settings['isAnchor'])
        return "<span class='$clases'>$sectionColor $sectionName $sectionLabel$grupo</span>";

    if (empty($settings['urlAnchor']))
        $settings['urlAnchor'] = getUrlBase()."backoffice/bodega.php?id=$bodega[bodega_id]&iagridvar=iajqgridbodega_var&iah=e";

    $titleAnchor = '';
    if (!empty($settings['titleAnchor']))
        $titleAnchor = "title='" . ia_htmlentities($settings['titleAnchor']) . "'";


    return "<a href='$settings[urlAnchor]' $titleAnchor><span class='$clases'>$sectionColor $sectionName $sectionLabel</span></a>$grupo";
}

function getUrlBase(): string
{
    if (isset($_SERVER["HTTPS"]))
        $url_base = $_SERVER["HTTPS"] === 'on' ? 'https': 'http';
    else
        $url_base = 'http';

    $url_base .= "://";
    if ($_SERVER["SERVER_PORT"] != "80") {
        $url_base .= $_SERVER["SERVER_NAME"].":".$_SERVER["SERVER_PORT"]."/".explode("/", $_SERVER["REQUEST_URI"])[1];
    } else {
        $url_base .= $_SERVER["SERVER_NAME"]."/".explode("/", $_SERVER["REQUEST_URI"])[1];
    }
    return $url_base . "/";
}
function getUrlTo($location = '')
{
    return getUrlBase() . $location;
}

function prepareUrl($url='', $params=[])
{
    if (empty($url))
        $url = getUrlTo();

    return $url."?".http_build_query($params);
}
/**
 * Elimina los items de un array
 * @param array $array
 * @param string|array $value
 * @return array
 */
function unsetItem(array $array, string|array $value): array
{
    if (is_array($value)) {
        foreach ($value as $v) {
            if (isset($array[$v]))
                unset($array[$v]);
        }
    } else {
        unset($array[$value]);
    }
    return $array;
}

/**
 * @param array $array
 * @param string $on
 * @param int $order
 * @return array
 */
function array_sort(array $array, string $on, $order=SORT_ASC): array
{
    $new_array = array();
    $sortable_array = array();

    if (count($array) > 0) {
        foreach ($array as $k => $v) {
            if (is_array($v)) {
                foreach ($v as $k2 => $v2) {
                    if ($k2 == $on) {
                        $sortable_array[$k] = $v2;
                    }
                }
            } else {
                $sortable_array[$k] = $v;
            }
        }

        switch ($order) {
            case SORT_ASC:
                asort($sortable_array);
                break;
            case SORT_DESC:
                arsort($sortable_array);
                break;
        }

        foreach ($sortable_array as $k => $v) {
            $new_array[$k] = $array[$k];
        }
    }

    return $new_array;
}

function getEnums(string $table, string $field)
{
    $method = __FUNCTION__;
    /** @noinspection SqlResolve */
    $enum_value =
        ia_singleread("SELECT /*$method*/ REPLACE(REPLACE(SUBSTRING(COLUMN_TYPE,7), \"'\", ''), ')', '') values_ FROM information_schema.COLUMNS WHERE TABLE_NAME=".strit($table)." AND COLUMN_NAME=".strit($field));

    if (empty($enum_value))
        return [];

    $enums = explode(",", $enum_value);
    return array_combine($enums, $enums);
}

function createGradient($hex) {

    $colorsDefault = [
        'blue' => "#0000FF",
        'azul' => "#0000FF",
        'green' => '#008000',
        'verde' => '#008000',
        'red' => '#FF0000',
        'rojo' => '#FF0000',
        'orange' => '#FFA500',
        'naranja' => '#FFA500',
        'yellow' => '#FFFF00',
        'amarillo' => '#FFFF00',
        'pink' => '#FFC0CB',
        'rosa' => '#FFC0CB',
        'purple' => '#800080',
        'morado' => '#800080',
        'black' => '#000000',
        'negro' => '#000000',
        'white' => '#FFFFFF',
        'blanco' => '#FFFFFF',
        'gray' => '#808080',
        'grey' => '#808080',
        'gris' => '#808080',
        'brown' => '#A52A2A',
        'cafe' => '#A52A2A',
        'maroon' => '#800000',
        'marrón' => '#800000',
        'violet' => '#EE82EE',
        'violeta' => '#EE82EE',
    ];

    $hex = strtolower($hex);

    $hex = $colorsDefault[$hex] ?? $hex;

    // Normalize into a six character long hex string
    $hex = str_replace('#', '', $hex);
    if (strlen($hex) == 3) {
        $hex = str_repeat(substr($hex, 0, 1), 2) . str_repeat(substr($hex, 1, 1), 2) . str_repeat(substr($hex, 2, 1), 2);
    }

    // Define the steps for the gradient
    $steps = [-40, -20, 0, 20, 40]; // Gradual changes in brightness
    $gradientColors = [];

    foreach ($steps as $step) {
        $color_parts = str_split($hex, 2);
        $adjustedColor = '#';

        foreach ($color_parts as $color) {
            $color = hexdec($color); // Convert to decimal
            $color = max(0, min(255, $color + $step)); // Adjust color
            $adjustedColor .= str_pad(dechex($color), 2, '0', STR_PAD_LEFT); // Make two char hex code
        }

        $gradientColors[] = $adjustedColor;
    }

    // Create the gradient string
    $gradient = "linear-gradient(" . implode(', ', array_map(function($color, $index) {
            $percentage = ($index * 20) . "%";
            return "$color $percentage";
        }, $gradientColors, array_keys($gradientColors))) . ")";

    return $gradient;
}
function adjustBrightness($hex, $steps) {

    $colorsDefault = [
        'blue' => "#0000FF",
        'azul' => "#0000FF",
        'green' => '#008000',
        'verde' => '#008000',
        'red' => '#FF0000',
        'rojo' => '#FF0000',
        'orange' => '#FFA500',
        'naranja' => '#FFA500',
        'yellow' => '#FFFF00',
        'amarillo' => '#FFFF00',
        'pink' => '#FFC0CB',
        'rosa' => '#FFC0CB',
        'purple' => '#800080',
        'morado' => '#800080',
        'black' => '#000000',
        'negro' => '#000000',
        'white' => '#FFFFFF',
        'blanco' => '#FFFFFF',
        'gray' => '#808080',
        'grey' => '#808080',
        'gris' => '#808080',
        'brown' => '#A52A2A',
        'cafe' => '#A52A2A',
        'maroon' => '#800000',
        'marrón' => '#800000',
        'violet' => '#EE82EE',
        'violeta' => '#EE82EE',
    ];

    $hex = strtolower($hex);

    $hex = $colorsDefault[$hex] ?? $hex;

    // Steps should be between -255 and 255. Negative = darker, positive = lighter
    $steps = max(-255, min(255, $steps));

    // Normalize into a six character long hex string
    $hex = str_replace('#', '', $hex);
    if (strlen($hex) == 3) {
        $hex = str_repeat(substr($hex,0,1), 2).str_repeat(substr($hex,1,1), 2).str_repeat(substr($hex,2,1), 2);
    }

    // Split into three parts: R, G and B
    $color_parts = str_split($hex, 2);
    $return = '#';

    foreach ($color_parts as $color) {
        $color   = hexdec($color); // Convert to decimal
        $color   = max(0,min(255,$color + $steps)); // Adjust color
        $return .= str_pad(dechex($color), 2, '0', STR_PAD_LEFT); // Make two char hex code
    }

    return $return;
}

function limpiaDatos(array $datos):array {
    // dd_($movimiento);
    // $exclude_case_upper = ['cp_cliente_direccion_id_destino', 'cliente'];
    foreach ($datos as $key => &$value) {
        $partes = explode("_", $key);
        if ($partes[count($partes)-1] == 'id')
            continue;

        if(array_key_exists($key,['quantity'=>'', 'rollos'=>''] )) {
            $value = str_replace(',', '', strim($value));
            continue;
        }
        if(!is_array($value)) {
            $value = strim($value);
            // $value = mb_convert_case(strim($value), MB_CASE_UPPER);
        }
    }
    return $datos;
}


function searchValueInArrayByColumn($value, $array, $column)
{
    $index = array_search($value, array_column($array, $column));

    if ($index !== false)
        return $array[$index];

    return [];

}

function get_url_origin($s = null, $use_forwarded_host=false) {
    $s = ($s == null) ? $_SERVER: $s;
    $ssl = ( ! empty($s['HTTPS']) && $s['HTTPS'] == 'on' ) ? true:false;
    $sp = strtolower( $s['SERVER_PROTOCOL'] );
    $protocol = substr( $sp, 0, strpos( $sp, '/'  )) . ( ( $ssl ) ? 's' : '' );

    $port = $s['SERVER_PORT'];
    $port = ( ( ! $ssl && $port == '80' ) || ( $ssl && $port=='443' ) ) ? '' : ':' . $port;

    $host = ( $use_forwarded_host && isset( $s['HTTP_X_FORWARDED_HOST'] ) ) ? $s['HTTP_X_FORWARDED_HOST'] : ( isset( $s['HTTP_HOST'] ) ? $s['HTTP_HOST'] : null );
    $host = isset( $host ) ? $host : $s['SERVER_NAME'] . $port;

    return $protocol . '://' . $host;

}

function get_full_url( $s = null, $use_forwarded_host=false ) {
    $s = ($s == null) ? $_SERVER: $s;
    return get_url_origin( $s, $use_forwarded_host ) . $s['REQUEST_URI'];
}

function get_url_out_params($url = '')
{
    $url = empty($url) ? get_full_url(): $url;

    $parts = explode("?",$url);
    return $parts[0] ;
}


function notasFaltantes ($bodega_id)
{

}


/** @noinspection PhpRedundantOptionalArgumentInspection */
function bodegasResumenNumeroNotas(array $bodegas, array $bodegasHacerMovimientos, int &$totalFaltan, $con_label = true):string {
    $ret = ''; $minNumNota = 0; $totalFaltan = 0;
    foreach($bodegas as $bodega_id => $b) {
        if( ($b['activo'] ?? 'Si') === 'No' )
            continue;

        $gaps = NotaBodega::numerosDeNotasFaltantes($bodega_id, $minNumNota, false, false);
        $maxNumber = ia_singleread("SELECT MAX(numero_as_num) FROM nota_bodega WHERE bodega_id=" . strit($bodega_id));
        $maxNumber == '' ? 1 : (int)$maxNumber + 1;
        if($maxNumber == '')
            $maxNumber = 1;

        $lastNoteFormatted = number_format($maxNumber, 0, '', ',');
        //$newNumberFormatted = number_format($newNumber, 0, '', ',');
        $numFaltan = count($gaps);
        if($numFaltan === 0) {
            $missingCount = ' Faltan: 0  # de notas';
            //$displayGaps = '';
        } else {
            $totalFaltan += $numFaltan;
            if($numFaltan > 30) {
                $gaps = NotaBodega::numerosDeNotasFaltantes($bodega_id, $minNumNota, true, false);
                //$len = count($gaps) - 1;
                //echo "<li>len=$len gaps=" . print_r($gaps, true);
                //$gaps[$len] = $gaps[$len] -2;
                array_walk($gaps ,
                    function(&$n){
                        $n = number_format($n, 0, '', ',');
                    }
                );
                $displayGaps = implode(" al ", $gaps );

            } else {
                array_walk($gaps ,
                    function(&$n){
                        $n = number_format($n, 0, '', ',');
                    }
                );
                $displayGaps = implode("; ", $gaps);
            }
            if($numFaltan === 1) {
                $laS = $laN = '';
            } else {
                $laS = 's'; $laN = 'n';
            }
            $missingCount =
                "<span class='bodega_boxResumenShadow' style='color:red;font-weight: 800'>Falta$laN " . number_format($numFaltan, 0, '', ',') . " nota$laS: " .
                " <span style='color:red;font-weight: 800;font-size:2em;float:right'>&cross;</span>" .
                "<p style='clear:both;padding-left:2em;text-overflow: ellipsis; overflow: hidden;max-width:500px;max-height:4em;color:red;font-weight: 800'>$displayGaps</span>" .
                "</span>";
        }

        $label = "<span style='cursor:pointer;' title='Ver última nota' onclick='dialogConsultarExistencia.consulta_ultima_nota(\"$bodega_id\")'>" . getLabelBodega($b) . "</span> ";
        if(array_key_exists($bodega_id, $bodegasHacerMovimientos)) {
            $link = "<a style='background:none!important;text-decoration:underline;color:blue;font-weight:bold;' href='../bodega/alta_movimiento.php?bodega_id=$b[bodega_id]&movimientode";
            $label .=  "$link=entrada'>Entrada</a> $link=salida'>Salida</a>";
        }

        $ret .=
            "<li><div style='white-space: pre;width:fit-content'>" . $label . "</div>" .
            " <span class='bodega_boxResumenShadow'  style='color:black'>Last Note: $lastNoteFormatted  $missingCount</span>";
    }
    return $ret;
}

function miniLog(array $values):string {
    $m='';
    if(array_key_exists('iac_edits',$values) ) {
        $m.="<b>Cambios:</b> <i>".number_format($values['iac_edits'], 0, '', ',')."</i>";
    }
    if( array_key_exists('ultimo_cambio',$values) || array_key_exists('ultimo_cambio_por',$values)
    ) {
        if($m!='')
            $m.='. ';
        $m.="<b>Último cambio</b>";
        if(array_key_exists('ultimo_cambio',$values) )
            $m.=" el: <i>".mysqlDate2display($values['ultimo_cambio']) . " (" . fechaDiff(Date('Y-m-d H:i:s'), $values['ultimo_cambio']) . ")</i>";
        if(array_key_exists('ultimo_cambio_por',$values) )
            $m.=' por: <i>'.$values['ultimo_cambio_por']."</i>";


        if(!empty($values['modificacion_importante_el']) && $values['modificacion_importante_el'] !== '0000-00-00 00:00:00')
            $m.=" <span style='color:red'>Mod Imp el: <i>".mysqlDate2display($values['modificacion_importante_el']) . " (" . fechaDiff(Date('Y-m-d H:i:s'), $values['modificacion_importante_el']) . ")</i></span>";
        if(!empty($values['modificacion_importante_por']) )
            $m.=' por: <i>'.$values['modificacion_importante_por']."</i>";

        if(array_key_exists('iac_last_edit_ip',$values) )
            $m.=' IP: <i>'.$values['iac_last_edit_ip']."</i>";
    }
    if(array_key_exists('alta_db',$values) || array_key_exists('alta_por',$values) ) {
        if($m!='')
            $m.='. | ';
        $m.=" <b>Alta</b>";
        if(array_key_exists('alta_db',$values) )
            $m.=" el: <i>".mysqlDate2display($values['alta_db']) . " (" . fechaDiff(Date('Y-m-d H:i:s'), $values['alta_db']) . ")</i>";
        if(array_key_exists('alta_por',$values) )
            $m.=' por <i>'.$values['alta_por']."</i>";
    }
    return $m;
}

/**
 * Redondea y pone comas a un numero en string, number_format para strings
 *
 * @param string|int|float|null|bool $num
 * @param int $decimals
 * @return string el $num con comas y redondeado al $decimals decimales
 */
function bcformat(string|int|float|null|bool $num, int $decimals=2):string {
    $num = trim($num ?? "");
    if($num === null || $num === '')
            return '';
    if(!is_numeric($num))
        return $num;

    $num = bcadd("0", numeric2string($num), $decimals);
    $int = strstr($num, '.', true);
    if($int === false) {
        $int = $num;
        $frac = '';
    } else {
        $frac = strstr($num, '.');
    }
    return preg_replace('/(\d)(?=(\d{3})+(?!\d))/mS', '$1,', $int) . $frac;
}

function numeric2string($number) {
    if(is_array($number)) {
        foreach($number as &$n)
            $n = numeric2string($n);
        return $number;
    }
    if(empty($number))
        return "0";
    if(strpos($number, 'E'))
        return (string)round($number, 2);

    if($number === true)
        return "1";
    return "$number";
}

/**
 * Abs para bc math
 *
 * @param string $num
 * @param int $decimals
 * @return string
 */
function bcabs($num, $decimals):string {
    return bccomp("0", $num, $decimals) >= 0 ?
        bcmul("-1", $num, $decimals) :
        $num;
}

/**
 * Pasa la existencia de un producto-color de una bodega a cero, revisando permisos.
 *
 * @param string $producto_bodega_id
 * @return string|array empty ok producto fue reseted
 */
function producto_color_reset($producto_bodega_id, $execute = true, $solo_qty = false, &$existencia_return = []):string|array {
    // Valida Permisos del usuario
    if(!usuarioTipoRony() && !usuarioSupervisaBodega() && !puedePermisoUsuario(nombrePermiso: 'puede_hacer_reset_producto_color')) {
        return "SIN PERMISO";
    }
    // Obtén bodega-producto-color a pasar a ceros
    $method = __FUNCTION__;
    $sql = "SELECT /*$method*/ pb.producto_bodega_id, pb.bodega_id, pb.producto_general_id, pb.color_id, 
            pb.existencia_rollos, pb.existencia_quantity,
            pb.existencia_rollos as rollos, pb.existencia_quantity as quantity,
           pc.en_remate, pc.es_saldo, pc.lento, pc.super_lento,
           IF(existencia_rollos < 0 || existencia_quantity < 0, 'Entrada', 'Salida') as entrada_salida,
            (SELECT origen_bodega_id FROM origen_bodega WHERE bodega_id = pb.bodega_id) AS origen_id,
           -- '' as origen_id,
           'Correccion' as es, 'Correccion' as tipo
            FROM producto_bodega pb 
                LEFT OUTER JOIN producto_color pc on 
                    pb.producto_general_id = pc.producto_general_id AND pb.color_id=pc.color_id
            WHERE pb.producto_bodega_id = " .strit($producto_bodega_id);

    $existencia = ia_singleton($sql);
    if(empty($existencia)) {
        return "NOT FOUND";
    }
    if(empty($existencia['en_remate']))
        $existencia['en_remate'] = $existencia['es_saldo'] = $existencia['lento'] = $existencia['super_lento'] = 'No';
    $existencia_return['existencia_quantity'] = $existencia['existencia_quantity'];
    $existencia_return['existencia_rollos'] = $existencia['existencia_rollos'];

    global $gIAParametros;
    $maxResetRollos = $gIAParametros['reset_max_rollos'] ?? "1";
    $maxResetQuantity = $gIAParametros['reset_max_quantity'] ?? "5.00";

    if(!usuarioTipoRony()) {
        // Si la existencia de rollos es mayor a $maxResetRollos
        if(bccomp(bcabs($existencia['rollos'], 0), $maxResetRollos, 0) > 0)
            return "INVALID ROLLS";
        // Si la existencia de quantity es mayor a $maxResetQuantity
        if(bccomp(bcabs($existencia['quantity'], 2), $maxResetQuantity, 2) > 0)
            return "INVALID QUANTITY";
    }

    $rollosHistory = $solo_qty ? "0" : $existencia['rollos'];
    $query[] = "INSERT /*$method*/ INTO reset_history(bodega_id,producto_general_id,color_id,rollos,quantity,alta_por)
                    VALUES ('{$existencia['bodega_id']}','{$existencia['producto_general_id']}','{$existencia['color_id']}',
                            '$rollosHistory','{$existencia['quantity']}','{$_SESSION['usuario']}')";

    // Pasa existencia en bodega del producto-color a ceros
    $set_campos = ["existencia_quantity" => '0.00', 'existencia_rollos' => '0.00'];
    if ($solo_qty)
        $set_campos = ["existencia_quantity" => '0.00'];

    $set_campos['ultimo_cambio'] = "NOW()";
    $set_campos['ultimo_cambio_por'] = $_SESSION['usuario'];
    $sqlBuilder = new Iac\inc\sql\IacSqlBuilder();
    $query[] = $sqlBuilder->update('producto_bodega', $set_campos, ['producto_bodega_id' => $producto_bodega_id], comment:$method);

    $existencia['rollos'] = $solo_qty ? "0" : bcmul($existencia['rollos'], "-1", 0);
    $existencia['quantity'] = bcmul($existencia['quantity'], "-1", 2);
    $existencia['fecha'] = Date('Y-m-d');
    $existencia['entrada_salida'] = 'Entrada';
    $existencia['tipo'] = 'Entrada';
    $existencia['origen_id'] = AJUSTE_ORIGEN_ID;

    $bodegaExistenciaDiaria = new BodegaExistenciaDiaria(false);
    $resetItems = $bodegaExistenciaDiaria->sqlResetItem($existencia);
    if(is_array($resetItems))
        $query = [...$query,  ...$resetItems];

    if (!$execute)
        return $query;
    return ia_transaction($query) ? "DB ERROR" : "";
}

function me_pregunto_notas_bodega() {
    $method = __FUNCTION__;
    $return = [];
    $dias = 7;
    $devolucionesSql =
        "select /*$method*/ tipo, count(*) as 'num', count(*) * 100.0 / sum(count(*))  over() as 'avg'
    from nota_bodega
    WHERE tipo IN ('movimiento', 'devolucion', 'VENTA CLIENTE') AND fecha >= DATE_SUB(CURDATE(), INTERVAL $dias DAY)
    GROUP BY 1";
    $devoluciones = ia_sqlArray($devolucionesSql, 'tipo');
    if(!empty($devoluciones)) {
        if(array_key_exists('Devolucion', $devoluciones)) {
            if($devoluciones['Devolucion']['avg'] >= 0.5)
                $return[] = "<b class='bb'>" . $devoluciones['Devolucion']['num'] . " devoluciones</b> en los últimos $dias días, creo <b class='bb'>¿son muchas?</b>";
        } else {
            $return[] = "¿<b class='bb'>Sin devoluciones</b> en los últimos $dias días?";
        }
    }

    $productosVendidosSql =
        "SELECT /*$method*/ count(DISTINCT producto_general_id) 
         FROM nota_bodega 
         WHERE tipo IN ('movimiento', 'VENTA CLIENTE') AND fecha >= DATE_SUB(CURDATE(), INTERVAL $dias DAY)";
    $productosVendidos = ia_singleread($productosVendidosSql, 0);
    if($productosVendidos !== false && $productosVendidos < 35)
        $return[] = "<b class='bb'>$productosVendidos productos vendidos</b> en los últimos $dias días, <b class='bb'>¿son pocos. no?</b>";
    $edicionesImportantesSql =
        "SELECT /*$method*/ b.bodega, COUNT(*)
    from nota_bodega_autorizacion nba LEFT OUTER JOIN bodega b ON b.bodega_id=nba.bodega_id
    WHERE nba.ultimo_movimiento='modificacion'AND nba.ultimo_cambio  > DATE_SUB(CURDATE(), INTERVAL $dias DAY) 
    GROUP BY 1
    HAVING COUNT(*)>5";
    $edicionesImportantes = ia_sqlKeyValue($edicionesImportantesSql);
    if(!empty($edicionesImportantes))
        foreach($edicionesImportantes as $bodega => $count)
            $return[] = "En la bodega <b class='bb'>$bodega</b> se realizaron <b class='bb'>$count modificaciones importantes</b> en los últimos $dias días, <b class='bb'>¿No son muchas?</b>";


    return empty($return) ? "" :
        "<style>.light{font-weight: 100;}.bb{font-weight:800}</style><div class='light' style='color:red;font-family: Arial, sans-serif'><span style='color:red;'>Hmmm de las <b>notas de bodega</b>, me pregunto:</span><dl><dt>" .  implode("<dt>", $return) . "</dl></div>"
        ."(solo en desarrollo existo)";
}

function ia_htmlentities($s="",$forza=false,$hardblank=false) {
    if($hardblank && empty($s) ) return '&nbsp;';
    if(is_array($s)) {
        echo "<div style='clear:both'><hr />ia_htmlentites got array=<pre>".print_r($s,true)."<p>trace<p>";
        debug_print_backtrace();

        echo "</pre><hr></div>";
    }
    if($s === null)
        $s = '';
    return htmlentities($s,ENT_QUOTES | ENT_HTML401 | ENT_SUBSTITUTE | ENT_DISALLOWED,IACHARSET);
}

function mysqlDate2display($date, $full_time=false) {
    global $gIAData;
    if(empty($date) || $date === '0000-00-00')
        return '';
    if(strlen($date) === 19)
        return mysqlDateTime2display($date, $full_time);

    //VCA
    $tmp=explode('-',$date);
    if(sizeof($tmp) !==3 ) return '';
    if($tmp[2] > 35)
        $date = "$tmp[2]-$tmp[1]-$tmp[0]";
    if(!checkdate((int)$tmp[1],(int)$tmp[2],(int)$tmp[0]))
        $date = date('Y-m-d');

    try {
        return substr($date,8,2).'/'.$gIAData['monthShrot'][substr($date,5,2)+0].'/'.substr($date,2,2);
    } catch(Exception) { return $date; }
}

function mysqlDateTime2display($date, $full_time=false) {
    global $gIAData;
    if(empty($date))
        return '';
    if(strlen($date) === 19)
        try {
            $mes = (int)substr($date,5,2)+0;
            $mes  = min($mes, 12);
            $mes_txt = $gIAData['monthShrot'][$mes] ?? "Ene";
            return substr($date,8,2).'/'
                .$mes_txt
                .'/'.substr($date,2,2).' '
                .($full_time?substr($date,10):substr($date,10,6));
        } catch(Exception) { return $date; }
    return $date;
}

function mysqlTimestamp2display($timestamp, $full_time=false) { return mysqlDateTime2display($timestamp, $full_time); }

/**
 * Regresa el nombre del color_id (color), blanco en not found
 */
function color_id_nombre(string $color_id):string {
    static $coloresCache;
    if(empty($coloresCache)) {
        $function = __FUNCTION__;
        $coloresCache = ia_sqlKeyValue("SELECT /*$function*/ color_id, color FROM color");
    }
    return $coloresCache[$color_id] ?? '';
}
/**
 * Regresa true si esta activo el color, false inactivo o not found
 */
function color_id_activo(string $color_id):bool {
    static $coloresCache;
    if(empty($coloresCache)) {
        $function = __FUNCTION__;
        $coloresCache = ia_sqlKeyValue("SELECT /*$function*/ color_id, activo FROM color");
    }
    return $coloresCache[$color_id] ?? '' === 'Si';
}
/**
 * Regresa el nombre del producto_general_id (producto), blanco en not found
 */
function producto_general_id_nombre($producto_general_id):string {
    static $productosCache;
    if(empty($productosCache)) {
        $function = __FUNCTION__;
        $productosCache = ia_sqlKeyValue("SELECT /*$function*/ producto_general_id, producto FROM producto_general");
    }
    return $productosCache[$producto_general_id] ?? '';
}
/**
 * Regresa true si esta activo el producto, false inactivo o not found
 */
function producto_general_id_activo($producto_general_id):bool {
    static $productosCache;
    if(empty($productosCache)) {
        $function = __FUNCTION__;
        $productosCache = ia_sqlKeyValue("SELECT /*$function*/ producto_general_id, activo FROM producto_general");
    }
    return $productosCache[$producto_general_id] ?? '' === 'Si';
}


function checked($value, $checkedValues):string {
    $val = $value instanceof Stringable ? (string)$value : $value;
    $valueTag = " value='" . htmlentities($val) . "' ";
    if(is_array($checkedValues))
        return $valueTag . (in_array($val, $checkedValues, false) ? "checked='checked' " : " ");
    if($checkedValues instanceof Stringable)
        return $valueTag . ((string)$checkedValues === $val ? "checked='checked' " : " ");
    return $valueTag . ($checkedValues == $value ? "checked='checked' " : " ");
}

/**
 * Returns htmlentity protected value tag, and selectedTag if $value in $selectedValues
 *
 * @param string|Stringable|int|float|bool|null $value
 * @param string|Stringable|array<int|string, string|int|float|bool|null> $selectedValues
 * @return string " value='$value' " or " value='$value' selected='selected' "
 */
function selected($value, $selectedValues):string {
    $val = $value instanceof Stringable ? (string)$value : $value;
    $valueTag = " value='" . htmlentities((string)$val) . "' ";
    if(is_array($selectedValues))
        return $valueTag . (in_array($value, $selectedValues, false) ? " selected='selected' " : " ");
    if($selectedValues instanceof Stringable)
        return $valueTag . ((string)$selectedValues == $val ? " selected='selected' " : " ");
    return $valueTag . ($selectedValues == $value ? " selected='selected' " : " ");
}



/**
 * Para buscar por regExp, lento, en un campo json o text que guarda json con like en un $property del json el text $busca
 *
 * @param string $fieldName
 * @param string $property
 * @param string $busca
 * @return string
 */
function jsonRegExp($fieldName, $property, $busca):string {
    $fieldName = fieldit(trim($fieldName ?? ''));
    $property = substr(strit(trim($property ?? '')), 1, -1);
    $busca = substr(strit(strim($busca)), 1, -1);
    return /** @lang SQL */
        "REGEXP_LIKE($fieldName, '.*\"$property\" *: *\"[a-z\\\\s,\\\\.\\\\d\\\\&]*{$busca}[a-z\\\s,\\\.\\\d\\\\&]*\"', 'i')";
}

function jsonLike(string $tableName, string $fieldName, string $property, string $busca, string $op = 'cn'):string {
    switch($op) {
        case 'ew':
            $start = '%';
            $end = '';
            break;
        case 'bw':
            $start = '';
            $end = '%';
            break;
        default:
            $start = '%';
            $end = '%';
    }

    $fieldName = fieldit(trim($fieldName ?? ''));
    $property = substr(strit(trim($property ?? '')), 1, -1);
    $busca = substr(strit(strim($busca)), 1, -1);

    return /** lang SQL */
        "EXISTS(
              SELECT 1
              FROM nota_bodega nbj
                JOIN JSON_TABLE(nbj.$fieldName, '\$[*]' COLUMNS (
                    fue_error VARCHAR(2) PATH '\$.fue_error',
                    lbl TEXT PATH '\$.$property'
                )) AS j
              WHERE nota_bodega.nota_bodega_id=nbj.nota_bodega_id AND j.fue_error='No' AND j.lbl LIKE '$start{$busca}$end'
          )";
}

function strlike($str):string {
 return str_replace(array('%', '_'), array("\\%", "\\_"), $str ?? '');
}


/**
 * si $tableName.$fieldName se guarda como json da el property que desplegar/buscar. blanco no es json
 * Para usarse por ejemplo con jsonLike
 *
 * @param $tableName
 * @param $fieldName
 * @return string vacia si $tableName.$fieldName no se guarda como json, el property que desplegar/buscar si si
 */
function fixJsonBuscaEnProperty($tableName, &$fieldName, $data, &$value_txt = ""):string {
    if(strlen($data) === 32 && preg_match_all('/[0-9a-f]/miS', $data, $matches, PREG_SET_ORDER, 0)) {
        $iactblConJsonFields = [
            'nota_bodega' => [4,
                'ayudantes_json' => 'id',
                'chofer_responsable' => 'figuratransporte_id',
                'cliente' => 'cliente_id',
                'numero_compra' => 'numero_compra_id',
                'pedido_por' => 'id',

                'tipo_nota_json' => 'tipo_nota',
                'numero_tipo_nota_json' => 'numero_tipo_nota',
                'quantity_tipo_nota_json' => 'quantity_tipo_nota',
            ],
        ];
    } else {
        $iactblConJsonFields = [
            'nota_bodega' => [4,
                'ayudantes_json' => 'lbl',
                'chofer_responsable' => 'nombre',
                'cliente' => 'nombre',
                'numero_compra' => 'numero_compra',
                'pedido_por' => 'lbl',

                'tipo_nota_json' => 'tipo_nota',
                'numero_tipo_nota_json' => 'numero_tipo_nota',
                'quantity_tipo_nota_json' => 'quantity_tipo_nota',
            ],
        ];
    }

    $iactblConJsonFieldsIdx = [
        'nota_bodega' => [
            'cliente' => ['alt' =>'cliente_actual'],
            'numero_compra' => ['alt' =>'numero_compra_actual', 'val_txt' => " = ".strit($data)],
        ],
    ];
    $tableName = trim(strtolower($tableName ?? ''));
    $fieldName = trim(strtolower($fieldName ?? ''));

    if($iactblConJsonFieldsIdx[$tableName][$fieldName]['alt'] ?? false) {
        $value_txt = $iactblConJsonFieldsIdx[$tableName][$fieldName]['val_txt'] ?? "";
        $fieldName = $iactblConJsonFieldsIdx[$tableName][$fieldName]['alt'] ?? $fieldName;
//        $fi = $iactblConJsonFieldsIdx[$tableName][$fieldName]['fi'] ?? $fi;
    }
    return $iactblConJsonFields[$tableName][$fieldName] ?? '';
}

/**
 * Regresa un array donde fue_error === 'No'. Limpia y muestra solo los activos
 *
 * @param string|array|null $json
 * @return array
 */
function getFueErrorNo($json):array {
    if(empty($json)) {
        return [];
    }
    if(is_string($json)) {
        $json = json_decode($json, true);
    }
    if(empty($json)) {
        return [];
    }
    return array_values(array_filter(
        $json,
        function($item) {return strcasecmp('No', $item['fue_error'] ?? 'No')  === 0 ;}
    ));
}

/**
 *
 *
 * @param string|array|null $antes
 * @param string|array|null $despues = 'lbl'
 * @param string $display
 * @return bool true son Iguales, false hay diferencia
 */
function fueErrorIguales($antes, $despues, $display):bool {
    $eran = array_column(getFueErrorNo($antes), $display);
    $son = array_column(getFueErrorNo($despues), $display);
    $intersection = array_uintersect($eran, $son, 'compareCaseInsensitive');
    return empty([
        ...array_udiff($eran, $intersection, 'compareCaseInsensitive'),
        ...array_udiff($son, $intersection, 'compareCaseInsensitive')
    ]);
}

/**
 *
 *
 * @param string|array|null $antes
 * @param string|array|null $despues
 * @param string $display = 'lbl'
 * @param string $confirma = 'confirma'
 * @return bool true son Iguales, false hay diferencia
 */
function fueErrorConfirmaIguales($antes, $despues, $display, $confirma):bool {
    $eran = [];
    foreach(getFueErrorNo($antes) as $d)
        $eran[] = ($d[$display] ?? '¿?').($d[$confirma] ?? '¿?');
    $son = [];
    foreach(getFueErrorNo($despues) as $d)
        $son[] = ($d[$display] ?? '¿?').($d[$confirma] ?? '¿?');
    $intersection = array_uintersect($eran, $son, 'compareCaseInsensitive');
    return empty([
        ...array_udiff($eran, $intersection, 'compareCaseInsensitive'),
        ...array_udiff($son, $intersection, 'compareCaseInsensitive')
    ]);
}

function itemsIguales($antes, $despues):bool   {
    if($antes === false || $despues === false)
        return true;
    $eran = [];
    foreach($antes as $a)
        $eran[] = bcadd($a['rollos'] ?? '0', '0', 0) . '|' . bcadd($a['quantity'] ?? '0', '0.00', 2) . '|' .
            substr($a['producto_bodega_id'], -32);
    $son = [];
    foreach($despues as $a)
        $son[] = bcadd($a['rollos'] ?? '0', '0', 0) . '|' . bcadd($a['quantity'] ?? '0', '0.00', 2) . '|' .
            substr($a['producto_bodega_id'], -32);
    $intersection = array_uintersect($eran, $son, 'compareCaseInsensitive');
    return empty([
        ...array_udiff($eran, $intersection, 'compareCaseInsensitive'),
        ...array_udiff($son, $intersection, 'compareCaseInsensitive')
    ]);
}

function campoAtipo($campo) {
    $modificacionImportante =
        ['producto_general_id'=>1, 'items'=>1, 'fecha'=>1, 'entrada_salida'=>1, 'origen_id'=>1,'tipo'=>1,
            'total_rolls'=>1, 'total_quantity'=>1, 'paid'=>1, 'contenedor'=>1, 'numero'=>1,
        ];
    if(array_key_exists($campo, $modificacionImportante))
        return 'Modificación Importante';
    $destinoMatch = ['ayudantes'=>1, 'ayudantes_json'=>1, 'pedido_por'=>1, 'cliente'=>1, 'numero_compra'=>1];
    if(array_key_exists($campo, $destinoMatch))
        return 'Destino Match';
    $camposCash = ['tipo_nota'=>1, 'tipo_nota_json'=>1, 'pedido_por'=>1, 'numero_tipo_nota'=>1, 'numero_tipo_nota_json'=>1,
        'quantity_tipo_nota'=>1, 'quantity_tipo_nota_json'=>1];
    if(array_key_exists($campo, $camposCash))
        return 'Campos Cash';
    $recibido = ['recibido'=>1, 'recibido_el'=>1, 'recibido_por'=>1];
    if(array_key_exists($campo, $recibido))
        return 'Recibido';
    return $campo;
}

/** @noinspection PhpUnused */
function compareCaseInsensitive($a, $b):int {
    if(is_array($a) || is_array($b)) {
        return $a <=> $b;
    }
    if($a instanceof \Stringable || $a === null) {
        $a = (string)$a;
    }
    if($b instanceof \Stringable || $b === null) {
        $b = (string)$b;
    }
    if(is_string($a) || is_string($b)) {
        return strcasecmp((string)$a, (string)$b);
    }
    return $a <=> $b;
}

/**
 * @param $fecha_min
 * @param $fecha_max
 * @return string
 */
function diasEntreFechas($fecha_min, $fecha_max):string {
    if(empty($fecha_min)) {
        return '';
    }
    try {
        if(empty($fecha_max)) {
            $today = new DateTimeImmutable();
            $interval = $today->diff(new DateTimeImmutable($fecha_min), true);
        } else {
            $minDate = new DateTimeImmutable($fecha_min);
            $interval = $minDate->diff(new DateTimeImmutable($fecha_max), true);
        }
        return " (" .
            number_format((int)$interval->format("%a"), 0, '', ',') .
            " días)";
    } catch(Throwable) {}
    return '';
}

/**
 * Regresa la diferencia en frase bonita de las 2 fechas
 *
 * @param string|int $dateTime1 mysqlDate o mysqlDateTime o timestamp
 * @param string|int $dateTime2 mysqlDate o mysqlDateTime o timestamp
 * @param int $maxParts
 * @return string
 */
function fechaDiff($dateTime1, $dateTime2, $maxParts = 2):string {
    $to = [
        'año' => 60*60*24*365,
        'mes' => 60*60*24*30,
        'día' => 60*60*24,
        'hr' => 60*60,
        'min' => 60,
        'seg' => 1,
    ];
    $plural = [
        'año' => 'años',
        'mes' => 'meses',
        'día' => 'dias',
        'hr' => 'hrs',
        'min' => 'min',
        'seg' => 'seg',
    ];
    $last = 'seg';
    $format = [];
    if($dateTime1 instanceof Stringable) {
        $dateTime1 = (string)$dateTime1;
    }
    if(!is_numeric($dateTime1)) {
        $dateTime1 = strtotime($dateTime1);
    }
    if($dateTime2 instanceof Stringable) {
        $dateTime2 = (string)$dateTime2;
    }
    if(!is_numeric($dateTime2)) {
        $dateTime2 = strtotime($dateTime2);
    }
    $diff = abs( (float)$dateTime1 - (float)$dateTime2);
    $breakNow = 0;
    foreach($to as $label => $u) {
        if($breakNow >= $maxParts || ($breakNow > 0 && $label === $last)) {
            break;
        }
        $period = floor($diff/$u);
        if( $period >= 1 ) {
            $diff -= $period * $u;
            $format[] =  $period . ' ' . ($period === 1.00 ? $label : $plural[$label]);
            $breakNow++;
        } elseif($breakNow === 1) {
            $breakNow++;
        }
    }
    return implode(", ", $format);
}

/**
 * Regresa $data ordenada por los keys de $keyOrder, de existir, en ese orden y luego el resto de keys de $data
 *
 * @param array<string, mixed> $data
 * @param array<int|string, int|string> $keyOrder
 * @return array<int|string, mixed>
 *
 * @example
 *      keyOrder(['a' => 'la A', 'b' => 'la b', 'm' => 'la m', 'l'=>'la l', 'k'=>'la k'], ['k', 'm', 'l']);
 *          ['k'=>'la k', 'm' => 'la m', 'l'=>'la l','a' => 'la A', 'b' => 'la b']
 */
function keyOrder(array $data, array $keyOrder):array {
    $order = [];
    foreach($keyOrder as $key)
        if(array_key_exists($key, $data))
            $order[$key] = $data[$key];
    foreach($data as $key => $v)
        if(!array_key_exists($key,$order))
            $order[$key] = $v;
    return $order;
}

/**
 * Regresa $data ordenada stable por los keys que no están en $keyOrder y luego los keys de $keyOrder, de existir, en ese orden
 *
 * @param array<int|string, mixed> $data
 * @param array<int|string, int|string> $keyOrder
 * @return array<int|string, mixed>
 * @example
 *      keyOrderEnd(['a' => 'la A', 'b' => 'la b', 'm' => 'la m', 'l'=>'la l', 'k'=>'la k'], ['k', 'm', 'l']);
 *          ['a' => 'la A', 'b' => 'la b', 'k'=>'la k', 'm' => 'la m', 'l'=>'la l']
 */
function keyOrderEnd(array $data, array $keyOrder):array {
    $order = [];
    $by = array_flip($keyOrder);
    foreach($data as $key => $v)
        if(!array_key_exists($key,$by))
            $order[$key] = $v;
    foreach($keyOrder as $key)
        if(array_key_exists($key, $data))
            $order[$key] = $data[$key];
    return $order;
}

function getCurrentValueJson($json):array
{
    if (empty($json))
        return [];
    $items_ok = getFueErrorNo($json);

    usort($items_ok, function($a, $b) {
        return new DateTime($b['alta_db']) <=> new DateTime($a['alta_db']);
    });
    /*usort($items_ok, function ($a, $b) {
        return strtotime($b['alta_db']) - strtotime($a['alta_db']);
    });*/
    return $items_ok[0]??[];
}

function displayColumn($campo, $valor):string|bool|int|float
{
    $method = __FUNCTION__;
    static $keyValue = [];
    if($campo === 'origen_bodega_id')
        $campo = 'origen_id';
    if($valor === null)
        return '';
    if(endsWith($campo, '_id')) {
        if(array_key_exists($campo, $keyValue))
            return $keyValue[$campo][$valor] ?? $valor;
        switch ($campo) {
            case 'bodega_id':
                $keyValue[$campo] = ia_sqlKeyValue("SELECT /*$method*/ bodega_id, bodega FROM bodega");
                break;
            case 'cliente_id':
                $keyValue[$campo] = ia_sqlKeyValue("SELECT /*$method*/  cliente_id, nombre FROM cliente");
                break;
            case 'color_id':
                $keyValue[$campo] = ia_sqlKeyValue("SELECT  /*$method*/ color_id, color FROM color");
                break;
            case 'contra_nota_bodega_id':
                return str_replace(';', ', ', $valor);
            case 'empresa_id':
                $keyValue[$campo] = ia_sqlKeyValue("SELECT /*$method*/  empresa_id, empresa FROM empresa");
                break;
            case 'nota_bodega_id':
                return ia_singleread("SELECT /*$method*/  label FROM nota_bodega WHERE nota_bodega_id=" . strit($valor));
            case 'nota_bodega_items_id':
            case 'nota_bodega_item_id':
                return ia_singleread("SELECT  /*$method*/ 
                       CONCAT(pg.producto, ' ', c.color, ' ', FORMAT(nbi.rollos, 0), ' rollos, ', FORMAT(nbi.quantity,2), u.unidad )
                        FROM nota_bodega_items nbi
                            JOIN producto_general pg ON pg.producto_general_id = MID(nbi.producto_bodega_id, 34, 32)
                            JOIN unidades u on pg.unidades_id = u.unidades_id
                            JOIN color c ON c.color_id = nbi.color_id
                        WHERE nota_bodega_item_id=" . strit($valor));
            case 'origen_id':
                $keyValue[$campo] = ia_sqlKeyValue("SELECT /*$method*/  origen_bodega_id, clave FROM origen_bodega");
                break;
            case 'producto_general_id':
                $keyValue[$campo] = ia_sqlKeyValue("SELECT /*$method*/  producto_general_id, producto FROM producto_general");
                break;
            case 'tienda_id':
                $keyValue[$campo] = ia_sqlKeyValue("SELECT  /*$method*/ tienda_id, clave FROM tienda");
                break;
            case 'unidades_id':
                $keyValue[$campo] = ia_sqlKeyValue("SELECT /*$method*/  unidades_id, unidad FROM unidades");
                break;
        }
        return $keyValue[$campo][$valor] ?? $valor . '?' . $campo;
    }

    $camposJsonFueError = [
        'ayudantes_json' => ['lbl' => 'lbl'],
        'chofer_responsable' => ['lbl' =>'nombre'],
        'cliente' => ['lbl' =>'nombre'],
        'numero_compra' => ['lbl' =>'numero_compra'],
        'pedido_por' => ['lbl' => 'lbl'],

        'tipo_nota_json' => ['lbl' =>'tipo_nota'],
        'numero_tipo_nota_json' => ['lbl' =>'numero_tipo_nota'],
        'quantity_tipo_nota_json' => ['lbl' =>'quantity_tipo_nota'],
    ];
    if(array_key_exists($campo, $camposJsonFueError)) {
        $lbl = $camposJsonFueError[$campo]['lbl'] ?? 'lbl';
        //$confirma = $camposJsonFueError[$campo]['confirma'] ?? null;
        //if($confirma === null)
        return  implode(", ", array_column(getFueErrorNo($valor), $lbl));
    }

    if(str_contains($campo, 'numero') || str_contains($campo, 'number'))
        return $valor;
    if(is_numeric($valor)) {
        if(str_contains($campo, 'rollos') || str_contains($campo, 'rolls'))
            return bcformat((string)$valor, 0);
        return bcformat((string)$valor, 2);
    }

    if('items' === $campo) {
        $items = [];
        foreach($valor as $i) {
            $rollos = bcformat($i['rollos'],0);
            $quantity = bcformat($i['quantity'],2);
            $producto = displayColumn('producto_general_id', substr($i['producto_bodega_id'],  33, 32) );
            $color = displayColumn('color_id', substr($i['producto_bodega_id'],   -32) );
            $items[] = "$producto $color $rollos rollos, $quantity";
        }
        return "<ol><li>" . implode("<li>", $items) . "</li></ol>";
    }
    return is_array($valor) ? print_r($valor, true) : $valor;
}

/**
 * echo viewJsCode("functionName", $label = 'Show Function'); // pone un div con boton para ver codigo de function
 * echo viewJsCode("#id", $label = 'Ver div o javascript o ... con id="id"'); // pone un div con boton para ver codigo del element
 * $gDebugging debe ser True!.
 *
 *
 * @param string $show nombre de una funcion de js o un selector #id
 * @param string $label Letrero del boton
 * @return string
 */
function viewJsCode($show, $label = '') {
    global $gDebugging;
    if(!$gDebugging)
        return '';
    if(empty($label))
        $label =  "Show Me: $show";
    if($show[0] === '#' || $show[0] === '.') {
        $do = "showBySelector(\"$show\", this)";
    } else {
        $do = "showFunction($show, this)";
    }
    return <<< JS
    <script>
        function showFunction(functionToShow, container) {
            $(container).parent().html($("<pre>").css({margin:"2em", padding:"1em", border:"1px solid blue"}).
                text(functionToShow.toString()));
        }
        function showBySelector(idToShow, container) {
            let pon = $("<pre>").css({margin:"2em", padding:"1em", border:"1px solid blue"}).html( 
                $(idToShow)[0].outerHTML.replaceAll('<', "&lt;").replaceAll('\>', "&gt;<br>") );
            $(container).parent().html(pon);
        }
    </script>
    <div style="margin:1em"><button  type='button' onclick='$do'>$label</button></div>
JS;
}

/**
 * usage: global $gFn; echo <<<HEREDOC Hello, {$gFn(ucfirst($variableNombre))} HEREDOC;
 */
global $gFn; $gFn = function ($callable) {return $callable;};

/**
 * " AND color <> {$gStrIt($last_color)}" en vez de " AND color <> " . strit($last_color);
 */
global $gStrIt; $gStrIt  = function($s) {return strit($s); };
global $gPermisoClick;
/**
 * echo $gPermisoClick('nombrePermiso') o en <<< HTML .. {$permsioClick('puede_autorizar_notas_ultimo_movimiento')}
 *
 * @param string $permiso
 * @return string
 */
$gPermisoClick = function($permiso, $msg = '', $alwaysVisible = false, $extraParam = '{}') {
    if($alwaysVisible) {
        $display = 'inline-block';
        $cssSuffix = '1';
    } else {
        $display = 'none';
        $cssSuffix = '';
    }
    $onclick = "onclick='permisador.ponPermisoThis(this, $extraParam);'";
    $title = '<div class="ui_tooltip_grid_notas_modificacion_importante_si bold txt_1_1em">Permiso: ' . ucwords(str_replace(['puede_', 'may_', '_'], ' ', $permiso)) . '</div>';

    return Permisador::puede_consultar_permisos() !== 'Nada' ?
        "<span class='ui-icon ui-icon-key ClickPermiso$cssSuffix pointer tooltip_toolbar' $onclick title='$title' style='display:$display' data-permiso='$permiso' data-extraParam='$extraParam'></span>" .
        ($msg === '' ? '' : "<span class='ClickPermiso$cssSuffix pointer' $onclick data-permiso='$permiso' data-extraParam='$extraParam' style='background-color:white;color:blue;display:$display;font-size:14px'>$msg</span>")
        : '';
};

function is_container_number($container_number) {
    $container_number = strtoupper( trim($container_number) );
    if(!preg_match('/[A-Z]{4}[0-9]{7}/i', $container_number))
        return false;
    $code = [
        0 => 0, 1 => 1, 2 => 2, 3 => 3, 4 => 4, 5 => 5, 6 => 6, 7 => 7, 8 => 8, 9 => 9,
        'A' => 10, 'B' => 12, 'C' => 13, 'D' => 14, 'E' => 15, 'F' => 16, 'G' => 17, 'H' => 18, 'I' => 19, 'J' => 20,
        'K' => 21, 'L' => 23, 'M' => 24, 'N' => 25, 'O' => 26, 'P' => 27, 'Q' => 28, 'R' => 29, 'S' => 30, 'T' => 31,
        'U' => 32, 'V' => 34, 'W' => 35, 'X' => 36, 'Y' => 37, 'Z' => 38
    ];
    $sum = 0; $m = 1; $len = strlen($container_number) - 1;
    for($i=0; $i < $len; ++$i) {
        $sum += $code[$container_number[$i]] * $m;
        $m = $m << 1;
    }
    $checkDigit = $sum - floor($sum/11) * 11;

    return $checkDigit == 10 ? $container_number[$len] == '0' : $checkDigit == $container_number[$len];
    // http://www.gvct.co.uk/2011/09/how-is-the-check-digit-of-a-container-calculated/
/*
$ok = 'Ok'; $mal = "<span style='color:red'>X</span>";
$cn = 'ymlu8744830'; echo "<li>$cn = " . (is_container_number($cn) ? $ok : $mal);
$cn = 'YMLU8744830'; echo "<li>$cn = " . (is_container_number($cn) ? $ok : $mal);
$cn = 'TCNU1945814'; echo "<li>$cn = " . (is_container_number($cn) ? $ok : $mal);
$cn =  'SEGU5392270'; echo "<li>$cn = " . (is_container_number($cn) ? $ok : $mal);
$cn = 'TGBU8864437'; echo "<li>$cn = " . (is_container_number($cn) ? $ok : $mal);

$cn = 'GVTU300038'; echo "<li>$cn = " . (is_container_number($cn) ? $ok : $mal);
$cn = 'GVTU3000380'; echo "<li>$cn erroneo da erroneo: " . (is_container_number($cn) ? $mal : $ok);

$cn = "SEGU5329271"; echo "<li>$cn erroneo da erroneo: " . (is_container_number($cn) ? $mal : $ok);

$cn = 'SEGU5329210'; echo "<li>$cn erroneo da erroneo: " . (is_container_number($cn) ? $mal : $ok);

$cn = 'VTU3000389'; echo "<li>$cn erroneo da erroneo: " . (is_container_number($cn) ? $mal : $ok);
$cn = 'V U3000389'; echo "<li>$cn erroneo da erroneo: " . (is_container_number($cn) ? $mal : $ok);
$cn = '1VTU3000389'; echo "<li>$cn erroneo da erroneo: " . (is_container_number($cn) ? $mal : $ok);
$cn = 'G1TU3000389'; echo "<li>$cn erroneo da erroneo: " . (is_container_number($cn) ? $mal : $ok);
$cn = 'GV1U3000389'; echo "<li>$cn erroneo da erroneo: " . (is_container_number($cn) ? $mal : $ok);
$cn = 'GVT13000389'; echo "<li>$cn erroneo da erroneo: " . (is_container_number($cn) ? $mal : $ok);
$cn = 'GVTUa000389'; echo "<li>$cn erroneo da erroneo: " . (is_container_number($cn) ? $mal : $ok);
$cn = 'GVTU3a00389'; echo "<li>$cn erroneo da erroneo: " . (is_container_number($cn) ? $mal : $ok);
$cn = 'GVTU30a0389'; echo "<li>$cn erroneo da erroneo: " . (is_container_number($cn) ? $mal : $ok);
$cn = 'GVTU300a389'; echo "<li>$cn erroneo da erroneo: " . (is_container_number($cn) ? $mal : $ok);
$cn = 'GVTU3000a89'; echo "<li>$cn erroneo da erroneo: " . (is_container_number($cn) ? $mal : $ok);
$cn = 'GVTU30003a9'; echo "<li>$cn erroneo da erroneo: " . (is_container_number($cn) ? $mal : $ok);
$cn = 'GVTU3000380'; echo "<li>$cn erroneo da erroneo: " . (is_container_number($cn) ? $mal : $ok);
$cn = 'VTU3000389'; echo "<li>$cn = " . (is_container_number($cn) ? $ok : $mal);
$cn = 'GVTU300038'; echo "<li>$cn = " . (is_container_number($cn) ? $ok : $mal);


 */
}

/**
 * @param string $fieldName
 * @param int|float|bool|string|array|null $value
 * @param string $default
 * @return string
 */
function formatMe(string $fieldName, $value, string $default = ''):string {
    if($value instanceof stdClass)
        $value = json_decode(json_encode($value, JSON_OPTIONS_FOR_MYSQL),true);
    if($value === null)
        return '';
    if($value === true)
        return "true";
    if($value === false)
        return "false";
    if(is_array($value))
        return formatMeArray($value);

    $fieldName = strtolower($fieldName);

    if(str_ends_with($fieldName, '_id'))
        return formatMeId($fieldName, $value, $default);
    $intFlags = [
        'atrasado'=>1,
        'paid'=>1,
        'super_atrasado'=>1,
        'pending'=>1,
        'modificado'=>1,
        'cobrado'=>1,
        'delivered_directo'=>1,
    ];
    if(is_numeric($value) && !str_contains($fieldName, 'num') && !str_contains($fieldName, 'consecutivo')) {
        if(str_contains($fieldName, 'lock') || array_key_exists($fieldName, $intFlags))
            return (int)$value ? 'Si' : 'No';
        if(str_contains($fieldName, 'roll') || str_contains($fieldName, 'verificaciones_') || $fieldName === 'iac_edits')
            $decimals = 0;
        elseif($fieldName === 'tc' || $fieldName === 'tipo_cambio')
            $decimals = 4;
        elseif(str_starts_with($fieldName, 'puntos'))
            $decimals = 4;
        else
            $decimals = 2;
        return bcformat($value, $decimals);
    }


    switch($fieldName) {
        case 'alta_db':
        case 'ultimo_cambio':
            return mysqlDateTime2display($value);
        case 'fecha':
            return mysqlDate2display($value);
    }
    if(str_contains($value, '-')) {
        $len = strlen($value);
        if($len === 10)
            if(count(explode('-', $value)) === 3)
                return mysqlDate2display($value);
        if($len === 19)
            return mysqlDate2display($value);
    }
    return (string)$value;
}
function formatMeArray(array $array, array|null $fieldNameOrder = null):string {
    $ret = [" <ol>"]; // espacio inicial importante
    if($fieldNameOrder === null)
        $fieldNameOrder = ['bodega_id', 'producto_general_id', 'color_id', 'quantity', 'unidades_id', 'rollos'];
    foreach($array as $k => $data) {
        if(is_array($data)) {
            $item = [];
            foreach($fieldNameOrder as $fieldName)
                if(array_key_exists($fieldName, $data))
                    $item[] = formatMe($fieldName, $data[$fieldName]);
            $ret[] =  implode(" ", $item);
        } else
            $ret[] = formatMe($k, $data);
    }
    return implode(" <li>", $ret) . " </ol>"; // espacio inicial de <li> y </ol> son importantes
}

function formatMeId(string $fieldName, int|string $id, int|string|null $default = ''):string {
    if($default === null)
        $default = $id;
    $fieldName = strtolower($fieldName);
    static $labels;
    if(!isset($labels)) {
        $method = __METHOD__;
        /** @var  $labels
         *  Si es un array [fieldname=>[id=>label,...],.. ]
         *  String inicia con SELECT y tiene '%id%' sustituye el '%id%' con $id y regresa el label (primera columna)
         *  String inicia con SELECT se corre y arma el para la proxima vez fieldname=>[id=>label,...]
         *  String no inicia con SELECT hace json_decode(obtenCatalogo(string), true) para llenar el array fieldname=>[id=>label,...]
         */
        $labels = [
            'banco_id' => "SELECT /*$method*/ banco_id, banco FROM banco ORDER BY 2",
            'banco_cuenta_id' => "SELECT /*$method*/ banco_cuenta_id, nombre FROM banco_cuenta ORDER BY 2",
            'bodega_id' => "bodega_keyValue_all",
            'categoria_id' => "categoria",
            'cuentat_mov_id' => [],
            'cliente_id' => "SELECT /*$method*/ cliente_id, nombre FROM cliente ORDER BY 2",
            'color_id' => 'color_keyValue_all',
            'cp_autotransporte' =>
                "SELECT /*$method*/ cp.autotransporte_id,IF(e.empresa IS NULL,cp.PlacaVM, CONCAT_WS(' ',e.empresa, cp.PlacaVM) ) 
                     FROM cp_autotransporte cp LEFT OUTER JOIN empresa e on cp.empresa_id = e.empresa_id 
                     ORDER BY 2",

            'cp_cliente_id' => "SELECT /*$method*/ cp_cliente_id, razon_social FROM cp_cliente ORDER BY 2",

            'cp_figuratransporte_id' => "SELECT /*$method*/ cp.figuratransporte_id,
                    IF(e.empresa IS NULL,cp.NombreFigura, CONCAT_WS(' ',e.empresa, cp.NombreFigura) ) 
                     FROM cp_figuratransporte cp LEFT OUTER JOIN empresa e on cp.empresa_id = e.empresa_id 
                     ORDER BY 2",
            'cp_tipofiguratransporte_id' => "SELECT /*$method*/ cp_tipofiguratransporte_id, ClaveFiguraTransporte FROM cp_tipofiguratransporte ORDER BY 2",

            'cp_cliente_direccion_id' => "SELECT /*$method*/ CONCAT_WS(' ', calle, numero_exterior, numero_interior, colonia, municipio)  FROM cp_cliente_direccion WHERE cp_cliente_direccion_id='%id%'",

            'cuentat_id' => "SELECT /*$method*/ cuentat_id, usuario FROM cuentat ORDER BY 2",
            'empresa_id' => "SELECT /*$method*/ empresa_id, empresa FROM empresa ORDER BY 2",
            'fabrica_id' => usuarioTipoRony() || Permisador::puede("pedido_china_fabrica", 'Nada') !== 'Nada' ?
                "SELECT /*$method*/ fabrica_id, fabrica FROM fabricas ORDER BY 2" : [],
            'iac_usr_id' => "SELECT /*$method*/ iac_usr_id, nick FROM iac_usr ORDER BY 2",
            'origen_bodega_id' => "SELECT /*$method*/ origen_bodega_id, clave FROM origen_bodega ORDER BY 2",
            'producto_bodega_id' =>
                "SELECT /*$method*/ producto_bodega_id, 
                     CONCAT(b.bodega, ': ', IF(pg.producto IS NULL OR c.color IS NULL, pc.producto, CONCAT_WS(' ', pg.producto, c.color))) 
                     FROM producto_bodega pc 
                     JOIN bodega b on pc.bodega_id = b.bodega_id    
                     LEFT OUTER JOIN producto_general pg on pc.producto_general_id = pg.producto_general_id
                     LEFT OUTER JOIN color c on pc.color_id = c.color_id
                     ORDER BY 2",
            'producto_color_id' =>
                    "SELECT /*$method*/ producto_color_id, IF(pg.producto IS NULL OR c.color IS NULL, pc.producto, 
                        CONCAT_WS(' ', pg.producto, c.color)) 
                     FROM producto_color pc 
                     LEFT OUTER JOIN producto_general pg on pc.producto_general_id = pg.producto_general_id
                     LEFT OUTER JOIN color c on pc.color_id = c.color_id
                     ORDER BY 2",
            'producto_general_id' => "producto_general_keyValue_all",
            'tienda_id' => "SELECT /*$method*/ tienda_id, clave FROM tienda ORDER BY 2",
            'unidades_id' => "SELECT /*$method*/ unidades_id, unidad FROM unidades ORDER BY 2",
             'pagare_id' =>
                 "SELECT /*$method*/  
                    CONCAT(IF(c.nombre IS NULL, '', c.nombre),  ' #', d.numero, 
                        ' por $', d.quantity, ' debe $', d.saldo ' ', m.moneda,  
                        IF(d.paid = 0, CONCAT(' ', DATE_FORMAT(d.original_date, '%e/%b/%y')), ' PAID'), ' ', c2.categoria
                    )
                    FROM pagare d
                        JOIN moneda m on d.moneda_id = m.moneda_id
                        LEFT OUTER JOIN cliente c on d.cliente_id = c.cliente_id 
                        LEFT OUTER JOIN categoria c2 on d.categoria_id = c2.categoria_id
                    WHERE d.pagare_id='%id%'",

            'nota_bodega_id' =>
                "SELECT /*$method*/ CONCAT_WS(' ',
                            DATE_FORMAT(fecha, '%e/%b/%y'),
                            nb.numero, b.bodega, nb.entrada_salida, 
                            IF(nb.tipo='Movimiento', 'Venta Tienda', nb.tipo), 
                            IF(ob.clave IS NULL OR nb.tipo='Cancelacion' OR nb.tipo='Borrado' OR nb.tipo='Correccion' OR nb.tipo='Container', 
                                '', ob.clave)
                        )
                        FROM nota_bodega nb JOIN bodega b on nb.bodega_id = b.bodega_id 
                        LEFT OUTER JOIN origen_bodega ob on nb.origen_id = ob.origen_bodega_id
                        WHERE nb.nota_bodega_id='%id%'",
            'aduana_id' => "SELECT /*$method*/ aduana_id, nombre FROM aduana ORDER BY 2",
            'shipping_line_id' => "SELECT /*$method*/ shipping_line_id, nombre FROM shipping_line ORDER BY 2",
            'agente_aduanal_id' => "SELECT /*$method*/ agente_aduanal_id, nombre FROM agente_aduanal ORDER BY 2",
        ];
        // sinonimos
        $labels['origen_id'] = $labels['origen_bodega_id'];
        $labels['producto_id'] = $labels['producto_general_id'];
        $labels['origen_cuentat_id'] = $labels['cuentat_transferto_id'] = $labels['cuentat_deliveredto_id'] =
            $labels['cuentat_id'];
        $labels['proveedor_id'] = $labels['fabrica_id'];

    }
    if(!array_key_exists($fieldName, $labels))
        return $default;
    $item = $labels[$fieldName];
    if(is_string($item)) {
        if(str_contains($item, '%id%'))
            return (string)ia_singleread(str_replace("'%id%'" , strit($id), $item), 'N/A', 'SQL ERROR');
        if(str_starts_with($item, "SELECT "))
            $item = ia_sqlKeyValue($item);
        else
            $item = json_decode(obtenCatalogo($item), true);
    }
    if(is_array($item))
        return $item[$id] ?? $default;
    return $default;
}


function the_error_handler($errno, $errstr, $errfile, $errline) {
    static $errYa;
    if (!(error_reporting() & $errno))
        return false;
    $ya = $errYa[$errfile][$errline] ?? null;
    if($ya !== null)
        return false;
    $errYa[$errfile][$errline] = "$errno: " . htmlentities($errstr);
    ia_errores_a_dime("$errno: " .htmlentities($errstr) , $errfile, 'php', $errline,
    $errno.$errfile.$errline);
    return false;
}
function the_exception_handler($exception) {
    static $errYa;
    $ya = $errYa[$exception->getFile()][$exception->getLine()] ?? null;
    if($ya !== null)
        return;
    $errYa[$exception->getFile()][$exception->getLine()] = htmlentities($exception->getMessage());
    ia_errores_a_dime(htmlentities($exception->getMessage(). " FIN DE SCRIPT") , $exception->getFile(), 'php', $exception->getLine(),
        $exception->getFile().$exception->getLine());
}
set_error_handler('the_error_handler');
set_exception_handler('the_exception_handler');

function recomiendanOlla($ver = 'All') {
    $method = __METHOD__;
    $puede = Permisador::puede('puede_reporte_ventas');
    if(!usuarioTipoRony() && $puede === 'Nada')
        return [];

    $programar = [];
    if(!usuarioTipoRony() && $puede == 'R/O') {
        $programarHeader = 'Pedir';
    } else {
        $programarHeader = "Programa<br>" . ucwords($_SESSION['usuario'] ?? 'N/A');
        if($ver !== 'Olla') {
            $sql = "SELECT /*$method*/ CONCAT(pg.producto, '_', c.color) as id,  pg.producto, 
                 CONCAT(c.color, ' ', digo) as color, IFNULL(pri.quantity, 0.00) quantity
        FROM pedido_recomienda_items pri
            JOIN pedido_recomienda pr on pri.pedido_recomienda_id = pr.pedido_recomienda_id
            JOIN iac_usr iu on pr.iac_usr_id = iu.iac_usr_id
            JOIN producto_general pg on pri.producto_general_id = pg.producto_general_id
            JOIN color c on pri.color_id = c.color_id
        WHERE pr.activo = 'Si' AND pr.tipo = 'Programacion' AND pri.digo <> '' AND pr.iac_usr_id=" . strit($_SESSION['usuario_id']) .
            " ORDER BY 2, 3";
            $programar = ia_sqlArray($sql, 'id');
            foreach($programar as &$p) {
                if(!str_contains($p['color'], ","))
                    continue;
                $p['color'] = str_replace(['Complemento', ','], ['Relleno', ', '], $p['color']);
            }
            unset($p);
        }
    }
    if($ver === 'Programacion' || $ver === 'Programa')
        $olla = [];
    else {
        $sql = "SELECT /*$method*/ pg.producto, CONCAT(c.color, ' ', digo) as color, iu.nick, 
             IF(digo = 'No Pedir', 'No Pedir', 
                 IF(digo = 'Complemento', CONCAT('Complemento ', IF(pri.quantity IS NULL OR pri.quantity=0, ' ', pri.quantity )  )   
                     ,pri.quantity) ) as quantity
        FROM pedido_recomienda_items pri
            JOIN pedido_recomienda pr on pri.pedido_recomienda_id = pr.pedido_recomienda_id
            JOIN iac_usr iu on pr.iac_usr_id = iu.iac_usr_id
            JOIN producto_general pg on pri.producto_general_id = pg.producto_general_id
            JOIN color c on pri.color_id = c.color_id
        WHERE pr.activo = 'Si' AND pr.tipo = 'Olla' AND pri.digo <> ''
        ORDER BY 1, 2, 3";
        $olla = ia_sqlSelectMultiKey($sql, 3);
    }
    $users = [];
    foreach($olla as $colores)
        foreach($colores as $usuarios)
            foreach($usuarios as $nick => $_)
                $users[$nick] = '';

    $rec = [];
    foreach($olla as $producto => $colores) {
        foreach($colores as $color => $usuarios) {
            $key = $producto.'_'.$color;
            $rec[$key] =[
                ...['producto' => $producto, 'color' => $color, $programarHeader => $programar[$key]['quantity'] ?? ''],
                ...$users
            ];
            $in = &$rec[$key];
            foreach($usuarios as $nick => $r) {
                $in[$nick] = $r['quantity'];
            }
        }
    }

    foreach(array_diff_key($programar, $rec) as $key => $c)
        $rec[$key] = ['producto' => $c['producto'], 'color' => $c['color'], $programarHeader => $c['quantity']];
    return $rec;
}
function recomiendanOllaTable($ver = 'All') {
    $date = mysqlDateTime2display(Date('Y-m-d H:i:s'));
    $data = recomiendanOlla($ver);
    uasort($data, function($a, $b){
        $da = strtoupper($a['producto']) <=> strtoupper($b['producto']);
        return $da ? $da : strtoupper($a['color']) <=> strtoupper($b['color']);
    });
    return
        '<script>
    function tablaDaVer() {
        let numCols =  $("#tablaDa tr").first().children().length;
        switch($("input[name=\'tablaDaColsVer\']:checked").val()) {
        case "Olla":
            $("td:nth-child(3)", "#tablaDa").hide();
            $("th:nth-child(3)", "#tablaDa").hide();
            for(let i = 4; i <= numCols; ++i) {
                $(`td:nth-child(${i})`, "#tablaDa").show();
                $(`th:nth-child(${i})`, "#tablaDa").show();
            }
            break;
        case "Programa":
        case "Programacion":
            $("td:nth-child(3)", "#tablaDa").show();
            $("th:nth-child(3)", "#tablaDa").show();
            for(let i = 4; i <= numCols; ++i) {
                $(`td:nth-child(${i})`, "#tablaDa").hide();
                $(`th:nth-child(${i})`, "#tablaDa").hide();
            }
            break;
        default:
            for(let i = 3; i <= numCols; ++i) {
                $(`td:nth-child(${i})`, "#tablaDa").show();
                $(`th:nth-child(${i})`, "#tablaDa").show();
            }
        }
    }
    function tablaDaExcel() { 
        let ver = $("input[name=\'tablaDaColsVer\']:checked").val();
        window.open("../bodega/olla2excel.php?ver=" + ver, "_blank");
       setTimeout(function(){ $("#tablaDaExcel").off("click", tablaDaExcel).one("click", tablaDaExcel);}, 700);
    }
    jQuery(function(){
        $("#recomiendaExport").append(exporter.toolBar("#tablaDa",{excel_table:false, fileName:"programar.csv"} ) );
        $("#tablaDaExcel").off("click", tablaDaExcel).one("click", tablaDaExcel);
    });
        </script><style>#tablaDa CAPTION{text-align:left}</style><div style="text-align: left;width:fit-content;">' .
        iaTableIt::getTableIt(
            $data,
            "<div id='recomiendaExport' style='white-space: nowrap;padding:0.5em 0.3em'>Recomendaciones para Programar <i style='font-weight: 100'>" . ucwords($_SESSION['usuario'] ?? 'N/A') . " $date</i><p style='padding-top:0.5em'>" .
                " <input onchange='tablaDaVer()' type='radio' name='tablaDaColsVer' id='tablaDaAll' value='All'><label for='tablaDaAll'> All</label> " .
                " <input onchange='tablaDaVer()' type='radio' name='tablaDaColsVer' id='tablaDaOlla' value='Olla'><label for='tablaDaOlla'> Olla</label> " .
                " <input onchange='tablaDaVer()' type='radio' name='tablaDaColsVer' id='tablaDaPrograma' value='Programa' checked><label for='tablaDaPrograma'> Programa</label> " .
                " <span id='tablaDaExcel' class='pointer' style='margin-left:1em;color:darkgreen;font-size:1.2em;font-weight: bold' title='Exportar a Excel'>🅇</span>" .
                "</div>",
            "tablaDa"
        ) . '</div>';
}

/**
 * @param string $producto_general_id
 * @param string $color_id
 * @param string|int|float|null $quantity
 * @param string $digo '' borrado ya no esta capturado
 * @param string $remarks
 * @param string $tipo Olla o Programacion
 * @param bool $execute
 * @return bool|string
 * @throws Exception
 */
function recomiendaSave(
    string $producto_general_id, string $color_id,
    string|int|float|null  $quantity,
    #[ExpectedValues(['Pedir', 'Falta', 'Complemento', 'No', 'No Pedir', 'Importante', ''])]
    string $digo,
    string $remarks = '',
    #[ExpectedValues(['Olla', 'Programacion'])]
    string $tipo = 'Olla',
    bool $execute = true
):bool|string {
    if(strcasecmp($tipo, 'Olla') && strcasecmp($tipo, 'Programacion'))
        return false;
    $function = __FUNCTION__;
    $builder = new \Iac\inc\sql\IacSqlBuilder();
    $digo = ucwords(strtolower($digo ?? ''));
    $pedido_recomienda_id = getRecomiendaPedido(strcasecmp($tipo, 'Olla') === 0);

    if(($digo === 'Pedir' && empty($quantity)) || $digo === '') {
        $where = $builder->where([
            'producto_general_id' => $producto_general_id,
            'color_id' => $color_id,
            'pedido_recomienda_id' => $pedido_recomienda_id,
        ]);
        $sqlDelete[] = "DELETE /*$function*/ FROM pedido_recomienda_items WHERE $where";
        if (!$execute)
            return $sqlDelete[0];
        $sqlDelete[] = "DELETE /*$function*/ FROM pedir_producto WHERE " .
            $builder->where(['iac_usr_id' => $_SESSION['usuario_id'], 'producto_general_id' => $producto_general_id, 'color_id' => $color_id]);
        return !ia_transaction($sqlDelete);
    }
    # revisa datos
    if(!empty($quantity) && (!is_numeric($quantity) || ((float)$quantity < 0) ))
        return false;

    if(!array_key_exists($digo, ['Pedir'=>1, 'Falta'=>1, 'Complemento'=>1, 'Importante'=>1, 'No'=>1, 'No Pedir'=>1, ''=>1, 'Ya Pedido' => 1] ) )
        return false;

    if($digo === 'No Pedir')
        $quantity = 0;
    elseif($quantity == '0' && $digo !== 'Complemento' && $digo !== 'Importante')
        $digo = 'No Pedir';
    if($quantity === '') {
        $quantity = null;
        if($digo !== 'Complemento' && $digo !== 'No Pedir' && $digo !== 'Importante' && $digo !== 'Ya Pedido')
            $digo = '';
    }
    $era = json_encode([ ['digo' => $digo, 'quantity' => $quantity] ], JSON_OPTIONS_FOR_MYSQL);
    $pedido_recomienda_id = getRecomiendaPedido(strcasecmp($tipo, 'Olla') === 0);
    $data = [
        'pedido_recomienda_id' => strit($pedido_recomienda_id),
        'producto_general_id' => strit($producto_general_id),
        'color_id' => strit($color_id),
        'quantity' => $quantity === null ? 'NULL' : strit($quantity),
        'digo' => strit($digo),
        'era' => strit($era),
    ];
    $insert = "INSERT /*$function()*/ INTO pedido_recomienda_items(" . implode(',', array_keys($data)) . ") " .
        "VALUES (" . implode(',', $data) . ") ON DUPLICATE KEY UPDATE ";
    foreach($data as $fieldName => $value)
        if($fieldName === 'era')
            $insert .= " era = $value, ";
        else
            $insert .= " $fieldName = $value,";
    $insert .= "ultimo_cambio = NOW()";

    if (!$execute)
        return $insert;
    $sql = [$insert];

    if($digo === '')
        $sql[] = "DELETE /*$function*/ FROM pedir_producto WHERE " .
            $builder->where(['iac_usr_id' => $_SESSION['usuario_id'], 'producto_general_id' => $producto_general_id, 'color_id' => $color_id]);
    else {
        $pedir_producto = [
            'producto_general_id' => $producto_general_id,
            'color_id' => $color_id,
            'iac_usr_id' => $_SESSION['usuario_id'],
            'quantity' => $quantity ?? '',
            'comentario' => '',
            'pedido_recomienda_items_id' => '',
            'digo' => $digo,
        ];
        $sql[] = $builder->insert('pedir_producto', $pedir_producto, true, '', ['comentario']);
    }

    return !ia_transaction($sql);
}

function topVentasBodega($top = 10) {
    $header = [];
    $ret = [];
    $lastYear = (int)Date('Y') - 1;
    $fechas = [
        'Todo' => ['2019-01-01', Date('Y-m-d')],
        'Este Mes' => [Date('Y-m-01'), Date('Y-m-d')],
        '1 Mes' => [Date('Y-m-d', strtotime('1 month ago')), Date('Y-m-d')],
        '2 Meses' => [Date('Y-m-d', strtotime('2 month ago')), Date('Y-m-d')],
        '3 Meses' => [Date('Y-m-d', strtotime('3 month ago')), Date('Y-m-d')],
        '4 Meses' => [Date('Y-m-d', strtotime('4 month ago')), Date('Y-m-d')],
        '6 Meses' => [Date('Y-m-d', strtotime('6 month ago')), Date('Y-m-d')],
        '12 Meses' => [Date('Y-m-d', strtotime('1 year ago')), Date('Y-m-d')],

        'Este Año' => [Date('Y-01-01'), Date('Y-m-d')],
        'El Pasado' => [Date('$lastYear-01-01'), Date('$lastYear-m-d')],
        'El Año Anterior' => [Date('$lastYear-01-01'), Date('$lastYear-12-31')],
    ];
    $sql = "SELECT CONCAT(pg.producto,' ', c.color) as producto,
                SUM(bed.salida_venta_quantity - bed.entrada_devolucion_quantity) as quantity,
                u.unidad,
                SUM(bed.salida_venta_rollos - bed.entrada_devolucion_rollos) as rollos 
                FROM bodega_existencia_diaria bed 
                    JOIN producto_general pg ON bed.producto_general_id=pg.producto_general_id
                    JOIN unidades u on pg.unidades_id = u.unidades_id
                    JOIN color c ON bed.color_id=c.color_id
                WHERE fecha >= ? AND fecha <= ?
                GROUP BY producto, u.unidad ORDER BY 2 DESC LIMIT $top";

    global $gSqlClass;
    $query = $gSqlClass->mysqli->prepare($sql);

    foreach($fechas as $label => $f) {
        $rows = [];
        $n = 0;
        $header = "<th class='cen' colspan='4'>$label<div class='vdet'>" . mysqlDate2display($f[0]) . ' - ' . mysqlDate2display($f[1]) . "</div>";
        $query->bind_param('ss', $f[0], $f[1]);
        foreach(ia_sqlArrayIndx($query) as $p) {
            $n++;
            $rows[] = "<td class='der'>$n<td>$p[producto]<td class='der'>" .
                bcformat($p['quantity'], 2) . "<td class='cen'>$p[unidad]";
        }
        if(!empty($rows))
            $ret[] = "<table class='laTabla'><thead><tr>$header</thead><tbody><tr>" .
                implode("<tr>", $rows) . "</tbody></table>";

    }

    return "<div style='display:flex;flex-wrap: wrap'>" . implode("", $ret) . "</div>";
}

/**
 * @param $url
 * @param $iac_usr_id
 * @return array ['nombre'=>'valor',...] para los defaults de iac_usr_id en la hoja $url
 */
function usuario_defaults_get(string $url='', string|int|float $iac_usr_id=''):array {
    global $gWebDir;
    if(empty($iac_usr_id))
        $iac_usr_id = $_SESSION['usuario_id'];
    if(empty($url))
        $url = str_replace("$_SERVER[CONTEXT_DOCUMENT_ROOT]/$gWebDir", "", $_SERVER['SCRIPT_FILENAME']);
    $method = __FUNCTION__;
    $defautls = ia_sqlKeyValue(
        "SELECT /*$method*/ nombre, valor 
            FROM usuario_defaults 
            WHERE url=" . strit($url) . " AND iac_usr_id=" . strit($iac_usr_id));
    if(empty($defautls) )
        return [];
    foreach($defautls as &$d)
        $d = json_decode($d, true);
    return $defautls;
}

function usuario_defaults_set(array $keyValue, string $url='', string|int|float $iac_usr_id='') {
    global $gWebDir;
    if(empty($iac_usr_id))
        $iac_usr_id = $_SESSION['usuario_id'];
    if(empty($url))
        $url = str_replace("$_SERVER[CONTEXT_DOCUMENT_ROOT]/$gWebDir", "", $_SERVER['SCRIPT_FILENAME']);
    $builder = new \Iac\inc\sql\IacSqlBuilder();
    foreach($keyValue as $nombre => $valor) {
        ia_query($builder->insert(
            'usuario_defaults',
            ['url' => $url, 'iac_usr_id' => $iac_usr_id, 'nombre' => $nombre,
                'valor' => json_encode($valor, JSON_OPTIONS_FOR_MYSQL)],
            true)
        );
    }
}

/**
 * Tablita con los archivos y su last modified time relacionados. Hmm Deducidos, agregar $extraFiles as needed
 *
 * @param array $extraFiles
 * @return string
 */
function usedFilesTimes(array $extraFiles = []):string {
    global $gDefaultClasses, $gIApath, $gIaHeader, $gVersionesExtraFiles;
    $docRoot = substr( $gIApath['DOCUMENT_ROOT'], 0 ,-1);
    $baseName = basename($_SERVER['SCRIPT_FILENAME']);
    $currentPath = str_replace($baseName, '', $_SERVER['SCRIPT_FILENAME']);
    $filePath = $gIApath['FilePath'];
    $used = [];

    $dime = getMTime($baseName);
    $used[$dime['file']] = $dime['mtime'];
    $dime = getMTime($baseName . '_acciones');
    if(trim($dime['mtime']) !== 'N/A')
        $used[$dime['file']] = $dime['mtime'];
    $forceFiles = [
      "backoffice/view/component/commons/dialog_consulta_existenciaColapsable.php",
      "backoffice/view/component/commons/dialogoExistencias.js",
      "backoffice/view/component/commons/dialogoReporteVentas.js",
      ""
    ];
    foreach($forceFiles as $file) {
        $file = $filePath . $file;
        if(file_exists($file))
            $used[$file] = Date('Y-m-d H:i', filemtime($file));
        else
            $used[$file] = " N/A";
    }
    foreach($gVersionesExtraFiles as $file) {
        switch($file[0]) {
            case '.': $file = $currentPath . $file; break;
            case '/': break;
            default: $file = $filePath . $file;
        }
        if(file_exists($file))
            $used[$file] = Date('Y-m-d H:i', filemtime($file));
        else
            $used[$file] = " N/A";
    }

    $code = file_get_contents($_SERVER['SCRIPT_FILENAME']);
    if(empty($code))
        $code = '';
    $code .= $gIaHeader->html_head_get();

    preg_match_all('/(include|require)(_once){0,1}\s*\(\s*["\'](.*)["\']\)/mUS',
        $code, $matches, PREG_SET_ORDER, 0);
    if(!empty($matches))
        foreach($matches as $m) {
            $dime = getMTime(basename($m[3]));
            if(trim($dime['mtime']) !== 'N/A') {
                $used[$dime['file']] = $dime['mtime'];
                continue;
            }
            $file = $currentPath . $m[3];
            if(file_exists($file))
                $used[$file] = Date('Y-m-d H:i' ,filemtime($file));
            else
                $used[$file] = ' N/A';
        }
    unset($matches);

    preg_match_all('/<script\s*src\s*=\s*[\'"](.*)[\'"]/mUS',
        $code, $matches, PREG_SET_ORDER, 0);
    if(!empty($matches))
        foreach($matches as $m) {
            $file =$m[1];
            $iPos = strpos($file, '?');
            if($iPos)
                $file = substr($file, 0, $iPos);
            if($file[0] === '.')
                $file = $currentPath . $file;
            elseif($file[0] === '/')
                $file = $docRoot . $file;
            if(file_exists($file))
                $used[$file] = Date('Y-m-d H:i' ,filemtime($file));
            else
                $used[$file] = ' N/A' . "de SCRIPT" ;
        }
    unset($matches);

    preg_match_all('/<link\s*href\s*=\s*[\'"](.*)[\'"]/mUS',
        $code, $matches, PREG_SET_ORDER, 0);
    if(!empty($matches))
        foreach($matches as $m) {
            $file =$m[1];
            $iPos = strpos($file, '?');
            if($iPos)
                $file = substr($file, 0, $iPos);
            if($file[0] === '.')
                $file = $currentPath . $file;
            elseif($file[0] === '/')
                $file = $docRoot . $file;
            if(file_exists($file))
                $used[$file] = Date('Y-m-d H:i' ,filemtime($file));
            else
                $used[$file] = ' N/A' . "de LINK";
        }
    unset($matches);

    preg_match_all('/url\s*:\s*[\'"](.*)[\'"]/mUS',
        $code, $matches, PREG_SET_ORDER, 0);
    if(!empty($matches))
        foreach($matches as $m) {
            $file =$m[1];
            $iPos = strpos($file, '?');
            if($iPos)
                $file = substr($file, 0, $iPos);
            if($file[0] === '.')
                $file = $currentPath . $file;
            elseif($file[0] === '/')
                $file = $docRoot . $file;
            if(file_exists($file))
                $used[$file] = Date('Y-m-d H:i' ,filemtime($file));
            else
                $used[$file] = ' N/A' . "de LINK";
        }
    unset($matches);


    $inc = ['config.php', 'ia_utilerias.php', 'helpers.php', 'vitex.php'];
    foreach($inc as $file) {
        $dime = getMTime($file);
        $used[$dime['file']] = $dime['mtime'];
    }
    foreach($extraFiles as $file) {
        $dime = getMTime($file);
        $used[$dime['file']] = $dime['mtime'];
    }

    foreach(get_declared_classes() as $class) {
        switch($class) {
            case 'ProcessLock': $class = 'vitex_process_lock'; break;
            case 'sqlMysqli': $class = 'sqlConverter'; break;
            case 'StringCompareJaroWinkler': $class = 'vitex_experimental'; break;
            case 'XLSXWriter': $class = 'xlsxwriter.class'; break;
            case 'XLSXWriter_BuffererWriter': $class = 'xlsxwriter.class'; break;
            case 'BancoCuentaMov': $class = 'tipos'; break;
            case 'Iac\inc\sql\IacSqlException': continue 2;
        }

        if( !array_key_exists($class, $gDefaultClasses) ) {
            $classFileName = basename($class) . ".php";
            $dime = getMTime($classFileName);
            $used[$dime['file']] = $dime['mtime'];
        }
    }

    arsort($used);

    $count = count($used);
    $first = reset($used);
    $caption = "Versiones: " . basename($_SERVER['SCRIPT_FILENAME']) . " uses $count files. Último Cambio el $first";
    $ret[] = "<table id='versionesFilesMTime' class='laTabla'><caption>$caption</caption><thead><tr><th>File</th><th>Last Modified</th></tr></thead><tbody>";
    foreach($used as $class => $t)
        $ret[] = "<tr><td>$class<td>$t";
    $ret[] = "</tbody></table>";
    return "<details class='default' style='margin:1em;'><summary>$caption</summary><div>" . implode("", $ret) . "</div></details>";
}

/**
 * Ayudante de usedFilesTimes
 *
 * @param string $file
 * @return array|string[]
 */
function getMTime($file):array {
    global $gIApath;
    static $path;
    if(empty($path)) {
        $path = explode(";", ini_get('include_path'));
        $path[] = "$gIApath[FilePath]backoffice";
        $path[] = "$gIApath[FilePath]backoffice/ajax";
        $path[] = "$gIApath[FilePath]bodega";
        $path[] = "$gIApath[FilePath]cobranza";
        $path[] = "$gIApath[FilePath]pedido";
        $path[] = "$gIApath[FilePath]css2";
        $path[] = "$gIApath[FilePath]js2";
    }
    foreach($path as $p)
        if(file_exists("$p/$file"))
            return ['file' => "$p/$file", 'mtime' => Date('Y-m-d H:i', filemtime("$p/$file") )];
    $p = "$gIApath[FilePath]inc";
    foreach(['ErrorReporter', 'sql', 'Excel', 'iaJqGrid'] as $subDir)
        if(file_exists("$p/$subDir/$file"))
            return ['file' => "$p/$subDir/$file", 'mtime' => Date('Y-m-d H:i', filemtime("$p/$subDir/$file") )];
    return ['file' => "$file", 'mtime' => ' N/A'];
}

function getLastNModifiedFiles($n = 25) {

    $file = fopen("C:\\wamp\\www\\vitex\\uploads\\fragmentLastModified.html","r");
    while ($line = fgets($file, 4 * 4096)) {
        echo mb_convert_encoding($line, "UTF-8", "UTF-16");
    }
    return true;
/*
    $cmd = "C:\\Windows\\System32\\WindowsPowerShell\\v1.0\\powershell.exe \"dir c:\\wamp\\www\\vitex\\ -r | where { \$_.fullname -notmatch 'txt|uploads|testie|idea|vscode|fontawesome-pro-6.4.0-web|vendor|json'} | Sort-Object LastWriteTime -Descending | Select-Object -first $n | select lastwritetime,hack,fullname\"";
    $output = shell_exec($cmd);

    preg_match('/^(\d.*)\s{3,}.*$/mS', $output, $matches);
    return "<details class='default'><summary>Last $matches[1]</summary><div>Last $n modified<pre class='code'>$output</pre></div></details>";*/
}

/**
 * @return void
 * @noinspection PhpUnused
 */
function file_debug_reporte($fileNameAppend = ''):void {
    global $gSqlClass, $gIApath, $gDime;
    $gSqlClass->traceOn = false;
    $date = Date('d/M/y H:i');
    $fileName = basename($_SERVER['REQUEST_URI']);
    if(str_contains($fileName, '?'))
        $fileName = strstr(basename($fileName), '?', true);
    if(str_contains($fileName, '&'))
        $fileName = strstr(basename($fileName), '&', true);
    if(str_contains($fileName, '#'))
        $fileName = strstr(basename($fileName), '#', true);
    $fileName .= $fileNameAppend;
    $css = iaTimer::cssClases() . iaTableIt::getCssClases();
    $fontFamily = 'font-family: "Source Code Pro", "SFMono-Regular", Menlo, Monaco, Consolas, "Liberation Mono", "Courier New", monospace';
    $sqlTrace = $gSqlClass->trace_get();
    $explain = [];
    foreach($sqlTrace as $id => $sql) {
        $sqlShow = str_ireplace(
          [",`", "\r", " FROM ", " WHERE ", " ORDER BY ", " GROUP BY ", " LIMIT "],
          [", `", "<br>", "<br>FROM ", "<br>WHERE ", "<br>ORDER BY ", "<br>GROUP BY ", "<br>LIMIT "],
          $sql);
        $s =  ltrim(strtolower($sql));
        if(
            !str_starts_with($s, 'show') && !str_starts_with($s, 'create') &&
            !str_starts_with($s, 'alter') && !str_starts_with($s, 'drop') &&
            !str_starts_with($s, 'explain') &&
            !str_starts_with($s, 'truncate') &&
            !str_starts_with($s, 'set') && !str_starts_with($s, 'call') &&
            !str_starts_with($s, 'commit') && !str_starts_with($s, 'rollback') &&
            !str_contains($s, 'FROM aa_tmp')
        )
            $explain[$id] = "<li><pre>$sqlShow</pre><pre>" . iaTableIt::getTableIt(ia_sqlArrayIndx("EXPLAIN $sql")) . "</pre>";
        else
            $explain[$id] = "<li><pre>$sqlShow</pre>";
    }
    $gSqlClass->traceOn = true;
    $iah = param('iah', param('h'));
    if(!empty($iah))
        $fileName .= "_iah_$iah";

    $fileName = str_replace('?', '', $fileName);
//    $start = microtime(true);
//    $fileName = $start."_".$fileName;
    //PH. So no existe la ruta para los archivos debug, la creamos.
    //02 Mayo 2025
    $path_file_debug_reporte = "$gIApath[FilePath]backoffice/txt";
    if (!is_dir($path_file_debug_reporte)) {
        mkdir($path_file_debug_reporte);
    }

    file_put_contents("$path_file_debug_reporte/quePex_$fileName.html",
        "<!DOCTYPE html><html lang='es-MX'><head><meta charset='utf-8'><title>q!Pex: $fileName</title><style>
            BODY{margin:1em;padding:1em;$fontFamily;max-width:98%;} 
            PRE {margin:1em;padding:1em;border:1px blue solid;$fontFamily;width:fit-content;max-width:1240px;white-space:pre-wrap;}
            $css FIELDSET {width:fit-content}        
            TABLE {white-space: normal}  
        </style></head><body><h1>q!Pex: $fileName</h1><br>$date $_SESSION[usuario] url:$_SERVER[REQUEST_URI]<pre><fieldset>" .
        "<fieldset><legend>Request</legend>" .
            ToCode::variable('Request',  $_REQUEST) . "\r\n" .
        "</fieldset>" .
        "<fieldset><legend>\$gDime</legend>" .
            ToCode::variable('gDime',  empty($gDime) ? [] : $gDime) . "\r\n" .
        "</fieldset>" .
        "<fieldset><legend>Detected Errors</legend>" .
            ToCode::variable('PHP Last Error',  error_get_last()) . "\r\n" .
            ToCode::variable('PHP Last JsonError',  json_last_error_msg()) . "\r\n" .
            ToCode::variable('PHP Last RegExpError',  preg_last_error_msg()) . "\r\n" .
            ToCode::variable('Sql_Errors', $gSqlClass->errorLog_get()) . "\r\n" .
        "</fieldset>" .
          "<fieldset><legend>Queries</legend>\r\n\r\n<ol>" . implode("\r\n\r\n", $explain)  . "\r\n\r\n</ol>\r\n\r\n</fieldset>" . "\r\n" .
        "</fieldset>" .
        "<fieldset><legend>Timing</legend>" .
        iaTimer::table(null, true, true, true) .
        "</fieldset>" .
        "</pre>" .
        "</body></html>"
    );
    $gSqlClass->traceOn = true;
}

function keys2Tiny(array $data, $rowKeysToCompress = []) {
    if(empty($data))
        return ['data'=>[], 'keyMap' => []];

    $colN = 0;
    $keyMap = [];
    foreach(array_keys(reset($data)) as $key)
        $keyMap[$key] = num2Key($colN++);
    $rowKeys = array_flip($rowKeysToCompress);
    $reKeyed = [];
    foreach($data as $k => $d) {
        $row = [];
        foreach($d as $key => $value)
            if(array_key_exists($key, $rowKeys)) {
                if(!array_key_exists($value, $keyMap)) {
                    $keyMap[$value] = num2Key(++$colN);
                }
                $row[$keyMap[$key]] = $keyMap[$value];
            } else
                $row[$keyMap[$key]] = $value;
        $reKeyed[$k] = $row;
    }
    return [
         'data' => $reKeyed,
        'keyMap' => $keyMap, 'rowKeyMap' => $rowKeys];
}

/**
 * De número (0=A) a columna de excel
 *
 * @param int $colNum
 * @return string
 */
function num2Key(int $colNum):string {
    if($colNum < 0)
        return 'A';
    if($colNum < 26) {
        return chr($colNum + 65);
    }
    if($colNum < 702) {
        return chr(64 + (int)($colNum / 26)) . chr(65 + $colNum % 26);
    }
    return chr(64 + (int)(($colNum - 26) / 676)) . chr(65 + (int)((($colNum - 26) % 676) / 26)) . chr(65 + $colNum % 26);
}

function getDeviceInfo():array {
    $device['ua'] = strtolower($_SERVER["HTTP_USER_AGENT"] ?? '');
    $device['isMobile'] = str_contains($device['ua'], 'mobile') || str_contains($device['ua'], 'phone');
    $device['isTablet'] = str_contains($device['ua'], "ipad") || str_contains($device['ua'], "tablet");
    $device['isIpad'] = str_contains($device['ua'], "ipad");
    return $device;
}

/**
 * Regresa html de un select box con las posiciones de columnas a usar de default, al seleccionar va a la hoja
 *
 * @param string $url pagina a que dirigirse ie
 * @param string $col_def_key ie posiciones de la hoja
 * @return string
 */
function jqgridcolssorter_SelectLinkTo(string $url, string $col_def_key):string {
    static $colTemplates;
    if(!is_array($colTemplates)) {
        $function = __FUNCTION__;
        $usuario = strit($_SESSION['usuario_id']);
        $colTemplates =  ia_sqlSelectMultiKey(
            "SELECT /*$function*/ col_def_key, jqgridcolssorter_id, label, para_todos
        FROM jqgridcolssorter
        WHERE iac_usr_id = $usuario OR para_todos = 'Si' OR jqgridcolssorter_id <= 0
        ORDER BY myDefault, label",2);
    }
    if(!array_key_exists($col_def_key, $colTemplates))
        return '';
    if(str_contains($url, '?'))
        $url .= '&';
    else
        $url .= '?';
    $options = "<option></option>";
    foreach($colTemplates[$col_def_key] as $id => $d) {
        if($id <= 0)
            $class = 'colSortDefault';
        elseif($d['para_todos'] === 'No')
            $class = 'colSortUsuario';
        else
            $class = 'colSortParaTodos';
        $options .= "<option value='{$url}jqgridcolssorter_id=$id' class='$class'>" . htmlentities($d['label']) . "</option>";
    }
    //return "<select class='colSortSelect' onchange='window.open(this.value)'>$options</select>";
    return "<select autocomplete='off' class='colSortSelect' onchange='window.location.href=this.value'>$options</select>";
}

function jqgridcolssorter_GetDefs(string $col_def_key):array {
    $function = __FUNCTION__;
    $col_def = strit($col_def_key);
    $iac_usr_id = strit($_SESSION['usuario_id']);
    $colDef = ia_sqlArrayIndx(
        "SELECT /*$function*/ jqgridcolssorter_id as value, label, def, para_todos, myDefault, ocultar_ribbon
                FROM jqgridcolssorter
                WHERE col_def_key = $col_def AND (para_todos = 'Si' OR iac_usr_id = $iac_usr_id)
                ORDER BY myDefault, para_todos DESC, jqgridcolssorter.label"
    );
    if(is_array($colDef) && !empty($colDef)){
        foreach($colDef as &$c)
            $c['def'] = json_decode($c['def']);
    }
    return $colDef;
}

/**
 * Regresa values de string para edit y search options uso:
 *  editoptions: {value: "<?php echo units2grid(); ?>"},
 *  searchoptions: {value: ":;<?php echo units2grid(); ?>",
 *
 * @return string
 */
function units2grid():string {
    static $uCache;
    if(!empty($uCache))
        return $uCache;
    $u = ia_sqlVector("SELECT /*units2grid*/ CONCAT(unidad, ':', unidad) FROM unidades WHERE vale='Active' ORDER BY unidades_id");
    if($u === false) {
        $uCache = "Kg:Kg;Mts:Mts;Pza:Pza;n/a:n/a";
        return $uCache;
    }
    $u[] = 'n/a:n/a';
    $uCache = implode(";", $u);
    return $uCache;
}

function jsCodeColChooser(string $gridId, string $appendTo = '', string $colDefKey = ''):string {
    $savedCode = json_encode(jqgridcolssorter_GetDefs($gridId . '_') );
    $appendTo = empty($appendTo) ? '$("#iactoolbartable").find("TR").first().append("<TD id=\'putColsChooser\'>");' : $appendTo;

    return <<< JS_CODE
    {$gridId}_cols = new jqgridcolssorter(
        $("#{$gridId}"), "{$gridId}_", "{$gridId}_cols", [],
        $savedCode   
    );
    {$gridId}_cols.putGetParam();
    {$appendTo}
    $("#putColsChooser").append({$gridId}_cols.controles());
JS_CODE;
}

function bodega_x_dia_cache($from = null):void {
    if(empty($from)) {
        $from = min(
            Date('Y-m-d', strtotime('4 days ago')),
            ia_singleread("SELECT MAX(fecha) FROM bodega_x_dia", "2022-09-01")
        );
        if(empty($from))
            $from = "2022-09-01";
    }

    $method = __FUNCTION__;
    $sql = "
    INSERT INTO bodega_x_dia(fecha, bodega, Existencia_Rollos, Existencia_Quantity_Kg, Existencia_Quantity_Mts,Existencia_Kg,  Existencia_Containers,Existencia_CIF_Today,Existencia_CIF_Report_Today)
    (WITH /* $method */ dia as (SELECT MAX(fecha) as fecha, bodega_id, producto_general_id, color_id
        FROM bodega_existencia_diaria
        WHERE fecha <= ?
        GROUP BY bodega_id, producto_general_id, color_id
        HAVING MAX(fecha))
     SELECT ?, bed.Bodega,
        SUM(bed.existencia_rollos) as Existencia_Rolls,
        SUM(IF(u.unidad = 'Kg', bed.existencia_quantity, 0)) as Existencia_Quantity_Kg,
        SUM(IF(u.unidad = 'Kg',0, bed.existencia_quantity)) as Existencia_Quantity_Mts,
        SUM(IF(u.unidad = 'Kg',bed.existencia_quantity, bed.existencia_quantity * pg.weight_per_m )) as Existencia_Kg,
      --  SUM(IF(pg.container_quantity = 0, 0, ROUND( bed.existencia_quantity / pg.container_quantity,2))) as Existencia_Containers,
        SUM(IF(pg.container_quantity = 0, 0,  bed.existencia_quantity / pg.container_quantity)) as Existencia_Containers,
        SUM( 
            IF(pg.cost_variant = 'Diferentes' AND bed.color_id = '54bf6469e2cc850b11ec1c8e8e9a60a2',
                IFNULL(pcb.cost_cif_blanco * bed.existencia_quantity, 0),
                IFNULL(pcb.cost_cif * bed.existencia_quantity, 0)
            )
        ) as 'Existencia_CIF_Today',
        SUM(IFNULL(pcrb.cost_cif * bed.existencia_quantity, 0)) as 'Existencia_CIF_Report_Today'
     FROM bodega_existencia_diaria bed
              JOIN dia ON bed.fecha = dia.fecha AND bed.bodega_id = dia.bodega_id
                    AND bed.producto_general_id = dia.producto_general_id
                    AND bed.color_id = dia.color_id
      JOIN producto_general pg ON pg.producto_general_id = dia.producto_general_id
      LEFT OUTER JOIN unidades u ON u.unidades_id = pg.unidades_id   
      LEFT OUTER JOIN producto_costs_bodega pcb ON pcb.producto_general_id = bed.producto_general_id AND pcb.fecha_fin IS NULL
      LEFT OUTER JOIN producto_costs_bodega_report pcrb ON pcrb.producto_general_id = bed.producto_general_id AND pcrb.fecha_fin IS NULL
     GROUP BY 1, 2) ON DUPLICATE KEY UPDATE 
        Existencia_Rollos = VALUES(Existencia_Rollos),
        Existencia_Quantity_Kg = VALUES(Existencia_Quantity_Kg),
        Existencia_Quantity_Mts = VALUES(Existencia_Quantity_Mts),
        Existencia_Kg = VALUES(Existencia_Kg),
        Existencia_Containers = VALUES(Existencia_Containers), 
        Existencia_CIF_Today = VALUES(Existencia_CIF_Today),
        Existencia_CIF_Report_Today = VALUES(Existencia_CIF_Report_Today) 
";

    global $gSqlClass;
    $query = $gSqlClass->mysqli->prepare($sql);
    $period = new DatePeriod(
        DateTimeImmutable::createFromFormat('Y-m-d', $from),
        new DateInterval("P1D"),
        new DateTimeImmutable("now"),
      DatePeriod::INCLUDE_END_DATE
    );
    foreach ($period as $date) {
        $d2 = $d1 = $date->format('Y-m-d');
        $query->bind_param('ss', $d1, $d2);
        $query->execute();
    }
}
function bodega_x_dia_ExistenciaMaximaTable($class = 'tblIt'):string {
    bodega_x_dia_cache();
    $show = "WITH mx AS
    (SELECT bodega, MAX(Existencia_Containers) as Existencia_Containers
    FROM bodega_x_dia
    GROUP BY bodega
    )
SELECT bd.Bodega, bd.Existencia_Containers as Containers, bd.Existencia_Rollos as Rollos, 
    bd.Existencia_Quantity_Kg as Qty_Kg, bd.Existencia_Quantity_Mts Qty_Mts, bd.Fecha
 FROM bodega_x_dia bd JOIN mx ON
     bd.bodega = mx.bodega AND bd.Existencia_Containers = mx.Existencia_Containers
ORDER BY bd.bodega, bd.fecha";
    $maxBodega = ia_sqlArray($show, 'Bodega');
    return iaTableIt::getTableIt($maxBodega,
        "Containers Máximo por Bodega " .
        '<i onclick="toExcel(\'tblIt\', \'Existencia_maxima_por_bodega\')" style="color:green;cursor:pointer" class="fa-duotone fa-file-excel"></i>',
        tableClass: $class);
}

function bodega_x_dia_recalc() {
    $method = __FUNCTION__;
    $last = ia_singleread("SELECT /*$method*/ updated FROM bodega_x_dia_last");
    if($last === false || Date('Y-m-d H:i', strtotime("2 minutes ago")) < $last )
        return;
    ia_query("UPDATE /*$method*/ bodega_x_dia_last SET updated=NOW()");
    bodega_x_dia_cache('2022-09-01');
}

function producto_oculta_where($prefix = "pg", $startAnd = "AND", $id=null) :string {
    if(usuarioTipoRony($id))
        return "";

    if(empty($id)) $id = $_SESSION['usuario_id'];
    if(ia_singleread("SELECT COUNT(*) FROM producto_usuario WHERE puede_verlo = 'No' AND iac_usr_id=" .strit($id), "0") === "0")
        return "";
    return  " $startAnd NOT EXISTS(
                SELECT 1 
                FROM producto_usuario pu 
                WHERE pu.producto_general_id=$prefix.producto_general_id AND pu.puede_verlo='No' 
                    AND pu.iac_usr_id=" . strit($id). ") "
    ;
}

function ats_corro_registra_true($ats_id, $cada_minutos):bool {
    $function = __FUNCTION__;
    $ats = ia_singleread("SELECT /*$function*/ * FROM ats WHERE ats_id=" . strit($ats_id));
    if(empty($ats))
        return false;


    return true;
}

function obten_listado_pueden_capturar_banco($banco_cuenta_id)
{
    $bc_id_it = strit($banco_cuenta_id);
    $select = "SELECT
                    iac_usr_id, nick
                FROM iac_usr
                WHERE
                    vale='Active'
                    AND plantilla_id IN (SELECT plantilla_id FROM banco_cuenta_mov_plantilla WHERE banco_cuenta_id = $bc_id_it AND puede = 'R/W')
                ORDER BY nick ";
    $users_pueden_capturar = ia_sqlKeyValue($select);
    $usuarios_pueden_capturar = '';
    if (!empty($users_pueden_capturar))
    {
        $usuarios_pueden_capturar = "<br><li>".implode("<li>", array_values($users_pueden_capturar));
    }
    return $usuarios_pueden_capturar;
}

/**
 * Funcion para obtener todos los archivos de un directorio
 *      NOTA: los ocultos no los regresa
 * @param $dir
 * @return array
 */
function getFilesFromDir($dir, $exclude = [])
{
    if (empty($dir))
        return[];
    if (!is_dir($dir))
        return [];
    
    $files_scan = scandir($dir);
    $files = [];
    if ($files_scan) {
        $exclude_files = array_merge([".", "..", ".svn", ".htaccess"], $exclude);
        foreach ($files_scan as $file_name)
        {
            if (in_array($file_name, $exclude_files)) continue;

            $files[] = $file_name;
        }
    }
    return $files;
}

/**
 * Adds a specified number of minutes to a given date.
 *
 * @param DateTime|String $date The date to add minutes to.
 * @param int $minutes The number of minutes to add.
 *
 * @return string The resulting date after adding minutes.
 * @throws Exception
 */
function addMinutes($date, $minutes) {
    $date = new DateTime($date);
    $interval = new DateInterval('PT' . $minutes . 'M');
    return $date->add($interval)->format('Y-m-d H:i:s');
}

function addSeconds($date, $seconds) {

    $date = new DateTime($date);
    $interval = new DateInterval('PT' . abs($seconds) . 'S');
    $result = ($seconds>=0) ? $date->add($interval): $date->modify($seconds." second");
    return $result->format('Y-m-d H:i:s');
}

function addDays($date, $days) {
    $date = new Datetime($date);
    $date->add(DateInterval::createFromDateString($days.' day'));
    return $date->format("Y-m-d H:i:s");
}

/**
 * Calculates the difference between two dates and returns the result in days, hours, minutes, and seconds.
 *
 * @param DateTime|String $start_time The start date.
 * @param DateTime|String $end_time The end date.
 *
 * @return array An array containing the difference in days, hours, minutes, and seconds, as well as a formatted label.
 * @throws Exception
 */
function diffTime($start_time, $end_time) {
    $start_time = new DateTime($start_time);
    $end_time = new DateTime($end_time);
    $interval = $start_time->diff($end_time);

    $remaining_days = $interval->days;
    $remaining_hours = $interval->h;
    $remaining_minutes = $interval->i;
    $remaining_seconds = $interval->s;

    $label = '';
    if ($remaining_days > 0) {
        $label .= $remaining_days . " día" . ($remaining_days > 1 ? 's' : '') . ", ";
    }
    if ($remaining_hours > 0) {
        $label .= $remaining_hours . " hora" . ($remaining_hours > 1 ? 's' : '') . ", ";
    }
    if ($remaining_minutes > 0) {
        $label .= $remaining_minutes . " minuto" . ($remaining_minutes > 1 ? 's' : '') . ", ";
    }
    if ($remaining_seconds > 0) {
        $label .= $remaining_seconds . " segundo" . ($remaining_seconds > 1 ? 's' : '') . ".";
    }

    $label_negativo = '';
    if ($interval->invert) {
        $label = '';
        $remaining_days= $remaining_days*(-1);
        $remaining_hours= $remaining_hours*(-1);
        $remaining_minutes= $remaining_minutes*(-1);
        $remaining_seconds= $remaining_seconds*(-1);

        $label_negativo ="Ha expirado hace ";
        if ($remaining_days<0)
            $label_negativo.=abs($remaining_days-1)." día".($remaining_days < -1 ? 's':'').".";
        else if ($remaining_hours<0)
            $label_negativo.=abs($remaining_hours)." hora".($remaining_hours < -1 ? 's':'').".";
        else if ($remaining_minutes<0)
            $label_negativo.=abs($remaining_minutes)." minuto".($remaining_minutes < -1 ? 's':'').".";
        else if ($remaining_seconds<0)
            $label_negativo.=abs($remaining_seconds)." segundo".($remaining_seconds < -1 ? 's':'').".";
    }
    return [
        'dias' => $remaining_days,
        'horas' => $remaining_hours,
        'minutos' => $remaining_minutes,
        'segundos' => $remaining_seconds,
        'label' => trim($label, ', '), // Remove trailing comma and space
        'negativo' => $interval->invert,
        'label_negativo' => trim($label_negativo, ', ')
    ];
}

if (!function_exists('easter_date')) {
    function easter_date($year) {
        // Implementation of the Gauss algorithm
        $G = $year % 19;
        $C = (int)($year / 100);
        $H = (int)($C - (int)($C / 4) - (int)((8*$C+13) / 25) + 19*$G + 15) % 30;
        $I = (int)$H - (int)($H / 28)*(1 - (int)($H / 28)*(int)(29 / ($H + 1))*((int)(21 - $G) / 11));
        $J = ($year + (int)($year/4) + $I + 2 - $C + (int)($C/4)) % 7;
        $L = $I - $J;
        $m = 3 + (int)(($L + 40) / 44);
        $d = $L + 28 - 31 * ((int)($m / 4));
        $y = $year;
        $E = mktime(0,0,0, $m, $d, $y);
        return $E;
    }
}