<?php

class iacClasif {
    public $msgError='';

    protected $table;
    protected $fieldId;
    protected $fieldLabel;
    protected $fieldParentId;
    protected $fieldLevel;
    protected $fieldOrder;
    protected $fieldActive;
    protected $leafLevel;
    protected $additionalFields='';
    protected $uniqueBy; //  'nivel' or 'parent';

    protected $classOptGroup = 'optgroup';
    protected $classOption = 'option';
    protected $classOptionPleaseSelect = '';
    protected $labelOptionPleaseSelect = 'Seleccione ...';

    function __construct($table, $leafLevel=-1, $uniqueBy='parent') {
        $this->table = $table;
        $this->fieldId = $table.'_id';
        $this->fieldLabel = 'nombre';
        $this->fieldParentId = $table.'_parent_id';
        $this->fieldLevel = 'nivel';
        $this->fieldOrder = 'orden';
        $this->fieldActive = null;
        $this->leafLevel = $leafLevel;
        $this->uniqueBy = $uniqueBy;
    }

/////////////////////
// READ CLASIFICATION
/////////////////////
    public function read($where='') {
        $activeField = $this->fieldActive ? ','.$this->fieldActive : '';
        return ia_sqlArray("SELECT $this->fieldId as id, $this->fieldLabel as nombre, $this->fieldParentId as parentId, $this->fieldLevel as nivel $this->additionalFields
        FROM $this->table $where
        ORDER BY $this->fieldLevel,$this->fieldOrder,$this->fieldLabel",'id');
    }

    public function read_with_childs($in=null, $topLevel=1, $where='') {
        $cat = array();
        if($in === null)
            $in = $this->read($where);
        foreach($in as $id => $g) {
            $parent = $g['parentId'];
            if( $g['nivel'] == $topLevel &&  empty($parent) ) {
                if(!isset($cat[$id]))
                    $cat[$id] = array_merge($g, array('_path'=>array($g['nombre']),'_parents'=>array(),  'childs'=>array()) );
                else {
                    $cat[$id]['nombre'] = $g['nombre'];
                    $cat[$id]['nivel'] = $g['nivel'];
                    $cat[$id]['_path'] = array($g['nombre']);
                    $cat[$id]['_parents']=array();
                }
                continue;
            }

            $tmp = &$cat;
            $path = array();
            $h = array();
            $this->heirarchy($id, $in, $h);
            $h = array_reverse($h);
            foreach($h as $parentIs) {
                $tmp = &$tmp[$parentIs]['childs'];
                $path[] = $in[$parentIs]['nombre'];
            }
            $path[] = $g['nombre'];
            $tmp[$id] = array_merge($g, array('_path'=>$path, '_parents'=>$h, 'childs'=>array()) );
        }
        return $cat;
    }

    public function read_inorder($in=null, $topLevel=1, $where='') {
        $cat = array();
        $in = $this->read_with_childs($in,$topLevel,$where);
        foreach($in as $id=>$g) {
            $cat[$id]  = $g;
            $cat[$id]['leaf'] = empty($g['childs']);
            unset($cat[$id]['childs']);
            if(!empty($g['childs'])) {
                $this->inorder_add($cat,$g['childs']);
            }
        }
        return $cat;
    }

    protected function inorder_add(&$cat,$childs) {
        foreach($childs as $id=>$g) {
            $cat[$id]  = $g;
            $cat[$id]['leaf'] = empty($g['childs']);
            unset($cat[$id]['childs']);
            if(!empty($g['childs'])) {
               $this->inorder_add($cat,$g['childs']);
            }
        }
    }

    public function options_optiongroup($selectedId=null, $in=null, $topLevel=1, $where='', $selectLevel='', $valueIsId=true) {
        $opt = '';
        if(empty($in))
            $in = $this->read_with_childs($in, $topLevel, $where);

        foreach($in as $id => $g) {
            $opt .= $this->options_optiongroup_option($id, $g, $selectedId, $selectLevel,$valueIsId);
        }
        return "<option value='' class='".trim($this->classOption.' '.$this->classOptionPleaseSelect)."'>".htmlentities($this->labelOptionPleaseSelect ?? '')."</option>".$opt;
    }

    protected function options_optiongroup_option($id, $g, $selectedId, $selectLevel='',$valueIsId=true) {
        if( isset($g['childs']) && !empty($g['childs']) ) {
            $opt = '';
            foreach($g['childs'] as $id=>$child)
                $opt .= $this->options_optiongroup_option($id,$child, $selectedId, $selectLevel,$valueIsId);
            return "\r\n<optgroup style='border-top:1px silver solid;' label='".(array_key_exists('nombre', $g) ? ia_htmlentities($g['nombre']) : '')."' class='$this->classOptGroup'>" . $opt . "\r\n</optgroup>";
        }
        if($this->leafLevel == $g['nivel'] || $this->leafLevel == -1 || $g['nivel']==$selectLevel) {
            $spcd = str_repeat('&nbsp;',$g['nivel']+1);
            $val = $valueIsId ? $id : $g['nombre'];
            return  "\r\n\t\t<option value='".ia_htmlentities($val)."' ".($val==$selectedId ? ' SELECTED=SELECTED' : '')." class='$this->classOption'>".$spcd.htmlentities($g['nombre'])."</option>";
        }
        return '';
    }

    public function options_all($selectedId=null, $in=null, $topLevel=1,$extraOptions='', $where='', $valueIsId=true) {
        $opt = '';
        if(empty($in))
            $in = $this->read_inorder($in, $topLevel, $where);
        foreach($in as $id => $g) if(isset($g['nivel'])){
            $addClass = $g['nivel'] < $this->leafLevel ? "optgroup".$g['nivel'] : $this->classOption;

            $spcd = str_repeat('&nbsp;&nbsp;',$g['nivel']);
            $val = $valueIsId ? $id : $g['nombre'];
            $opt .= "\r\n\t\t<option value='".ia_htmlentities($val)."' ".($val==$selectedId ? ' SELECTED=SELECTED' : '')." class='$addClass'>".$spcd.htmlentities($g['nombre'])."</option>";
        }
        return "<option value='' class='".trim($this->classOption.' '.$this->classOptionPleaseSelect)."'>".htmlentities($this->labelOptionPleaseSelect)."</option>".$extraOptions.$opt;
    }

    public function filterWithChilds($id,$fieldName='categoria_gasto_id', $table='', $relateTable = '') {
        if($id=='notset') {
            return " ($table$fieldName IS NULL OR $table$fieldName='' OR $table$fieldName='0') ";
        }
        if($this->leafLevel>0) {

        }
        $sid = strit($id);
        if(!empty($relateTable))
            $relateTable = "$relateTable.";
        return "$relateTable$table$fieldName IN (SELECT a.$this->fieldId FROM $this->table a LEFT OUTER JOIN $this->table p1 ON p1.$this->fieldId = a.$this->fieldParentId WHERE a.$this->fieldParentId = $sid OR p1.$this->fieldParentId = $sid OR a.$this->fieldId = $sid) ";

    }
/////////////////////
// INFO READS
/////////////////////
    public function parent_grandparent($id) {
        $sid = strit($id);

        return ia_singleton("SELECT a.$this->fieldId as id, a.$this->fieldLabel as label,a.$this->fieldLevel as nivel,
            p.$this->fieldId as parentId,p.$this->fieldLabel as parent, p.$this->fieldLevel as parentLevel,
            g.$this->fieldId as grandparentId, g.$this->fieldLabel as grandparent, g.$this->fieldLevel as grandparentLevel
    FROM $this->table a
        LEFT OUTER JOIN $this->table p ON p.$this->fieldId = a.$this->fieldParentId
        LEFT OUTER JOIN $this->table g ON g.$this->fieldId = p.$this->fieldParentId
    WHERE a.$this->fieldId = $sid;");
    }
/////////////////////
// ACTIONS
/////////////////////
    public function delete($id) {
        if($id == '') {
            $this->msgError = 'Error de transmision en los datos.<p>No se guardan los cambios, intente mas tarde';
            return false;
        }
        // id must not be parent in clasification
        if(ia_singleread("SELECT 1 FROM DUAL WHERE EXISTS (SELECT 1 FROM $this->table WHERE $this->fieldParentId=".strit($id).")" ) == "1" ) {
            $this->msgError = "Can't delete has subitems";
            return false;
        }
        if(ia_query("DELETE FROM $this->table WHERE $this->fieldId=".strit($id), false, false)." LIMIT 1") {
            $this->msgError = "SQL error";
            return false;
        }
        //TODO audit log
        return true;
    }

    public function add_valid($label, $parentId, $newId=null) {
        // valid parent
        // valid label

    }

    public function add($label, $parentId, $newId=null) {
        //newId=null implies autoincrement
        //return newId on add
    }

    public function edit_valid($id, $label) {
        // valid label

        // NEED extra fields?
        // EXISTS ultimocambio por/date?
    }

//auto edit/add check alta ctrl / lastchanged ctrl ?
//get audit log for $id alta/lastchanged queda en
    public function move($id, $parentId, $orderIN) {
        if($id===''  || $parentId=='') {
            $this->msgError = 'Error de transmision en los datos.<p>No se guardan los cambios, intente mas tarde';
            return false;
        }

        if($uniqueBy === "parent") {
            $current_parent = ia_singleread("SELECT $this->fieldParentId FROM $this->table WHERE $this->fieldId=".strit($id) );
            if($current_parent != $parentId) {
                $existingNames = ia_sqlKeyValue("SELECT $this->fieldId,LOWER(nombre) FROM $this->table WHERE $this->fieldParentId=".strit($parentId) );
                $movingNames =   ia_sqlKeyValue("SELECT $this->fieldId,LOWER(nombre) FROM $this->table WHERE $this->fieldId=".strit($id) );
                $conflict = array_intersect($existingNames,$movingNames);
                if(!empty($conflict)) {
                    $this->msgError = 'Los siguientes items entran en conflicto para hacer el cambio.<ul>'.implode('<li>',$conflict).'</ul>';
                    return false;
                }
           }
       }

        $sql = array();
        $sql[] = "UPDATE $this->table SET $this->fieldParentId=".strit($parentId)." WHERE $this->fieldId=".strit($id);

        if(!empty($orderIN)) {
            $iorden = 1;
            $o = explode(",",$orderIN);
            foreach($o as $order) {
                $sql[] = "UPDATE $this->table SET $this->fieldOrder=".strit($iorden)." WHERE $this->fieldId=".strit($order);
                $iorden++;
            }
        }

        if(ia_transaction($sql)) {
           $this->msgError = 'Error inesperado.<p>No se guardan los cambios, intente mas tarde';
           return false;
        }
        //TODO log
        return true;
    }

    function validLabel($id,$label,$nivel, $parentId) {
        if(empty($label))
            return_error_die('Nombre es un dato requerido');
        if($this->uniqueBy === 'nivel')
            $sql = "SELECT COUNT(*) FROM $this->table WHERE $this->fieldId<>".strit($id)." AND $this->fieldLevel=".strit($nivel)." AND $this->fieldLabel=".strit($label);
        else
            $sql = "SELECT COUNT(*) FROM $this->table WHERE $this->fieldParentId=".strit($parentId)." AND $this->fieldId<>".strit($id)." AND $this->fieldLabel=".strit($label);

        if(ia_singleread($sql)>0) {
            return_error_die('El nombre ya esta en uso, ponga un sinonimo<p>'.htmlentities($label));
        }
        return true;
    }

/////////////////////
// HELPER FUNCTIONS
/////////////////////

    protected function heirarchy($id, $in, &$h) {
        if(!isset($in[$id]))
            return $h;
        if(!isset($in[$id]['parentId']) || empty($in[$id]['parentId']))
            return $h;
        $h[] = $in[$id]['parentId'];
        return $this->heirarchy($in[$id]['parentId'], $in, $h);
    }

/////////////////////
// SETTERS
/////////////////////

    public function table($tableName) { $this->table = $tableName; return $this; }
    public function fieldId($idField) { $this->fieldId = $idField; return $this; }
    public function fieldLabel($nameField) { $this->fieldLabel = $nameField; return $this; }
    public function fieldParentId($parentIdField) { $this->fieldParentId = $parentIdField; return $this; }
    public function fieldLevel($levelField) { $this->fieldLevel = $levelField; return $this; }
    public function fieldOrden($orderField) { $this->orderField = $fieldOrden; return $this; }
    public function fieldActive($activeField) { $this->fieldActive = $activeField; return $this; }
    public function fieldsAditional($additionalFields) { $this->additionalFields = $additionalFields; return $this; }

    public function leafLevel($leafLevel) { $this->leafLevel = $leafLevel; return $this; }

    public function classOptGroup($classOptGroup) { $this->classOptGroup = $classOptGroup; return $this; }
    public function classOption($classOption) { $this->classOption = $classOption; return $this; }
    public function classOptionPleaseSelect($classOptionPleaseSelect) { $this->classOptionPleaseSelect = $classOptionPleaseSelect; return $this; }
    public function optionLabelPleaseSelect($label) { $this->labelOptionPleaseSelect = $label; return $this; }


}


?>