<?php
/**
 * @author Informática Asocaida SA de CV
 * @version 1.0.0
 * @copyright 2016
 */



class iacFileUploader {
// AddType image/svg+xml .svg .svgz
//AddHandler cgi-script .php .pl .jsp .asp .sh .cgi //falta python ruby
//Options -ExecCGI
//if (extension_loaded('finfo'))
//mime faltante ver http://stackoverflow.com/questions/19681453/correct-way-to-detect-mime-type-in-php

    protected $mimeTypes = array(
        'image'=>array('gif'=>'image/gif','jpg'=>'image/jpeg','jpeg'=>'image/jpeg','jpe'=>'image/jpeg', 'png'=>'image/png',
                'svg'=>'image/svg+xml', 'svgz'=>'image/svg+xml', // array por si son
            ),
        'document'=>array('xlsx'=>'application/zip')
    );

    protected $extensions = array(
        'image'=>array('gif','jpg','jpeg','jpe','png'), //svg, svgz
        'document'=>array('pdf','xls','xlsx','csv','doc','docx','ppt','ppts','pptx','pptsx'),
        'anudoc'=>array('merge doc and image and xml?'),
        'xml'=>array('xml'),
        'zip'=>array('zip')
    );

    protected $docRoot;
    protected $webRoot;

    public function __construct($webRoot=null,$docRoot=null) {
        $this->document_root_set($docRoot);
        $this->web_root_set($webRoot);
    }

    public function document_root_set($docRoot=null) {
        if(empty($docRoot))
            $docRoot = str_replace('\\', '/', $_SERVER['DOCUMENT_ROOT']);
        else
            $docRoot = str_replace('\\', '/', $docRoot);
        if(substr($docRoot, 0, -1) !== '/')
            $docRoot .= '/';

        $this->docRoot = str_replace('//', '/', $docRoot);
    }

    public function web_root_set($webRoot=null) {
        if(empty($webRoot)) {
            $pwd = str_replace('\\', '/', __DIR__);
            if(substr($pwd, 0, -1) !== '/')
                $pwd .= '/';
            $webRoot = str_replace('/inc/', '', str_replace($this->docRoot,'',$pwd) );
            if(substr($webRoot,0,1) !== '/')
                $webRoot = '/'.$webRoot;
        } else
            $webRoot = str_replace('\\', '/', $webRoot);
        if(substr($webRoot, 0, -1) !== '/')
            $webRoot .= '/';

        $this->webRoot = str_replace('//', '/', $webRoot);
    }

    function uploadImage($key,$uploadDir,$fileName,$index=0) {
        return $this->upload($key,$uploadDir,$fileName,$index,$this->extensions['image'],$this->mimeTypes['image']);
    }

    function upload($key,$uploadDir,$fileName,$index=0,$extension=null,$mime_type=null,$maxSize=null) {
        $ret = $this->valid($key,$index,$extension,$mime_type,$maxSize);
        if(!$ret['ok']) {
            return $ret;
        }
        //TODO fileName es 1) uniqly generated, 2) same name sanitized, 3) received name, que con replace/dontreplace?
        if($fileName === true )
            $fileName = uniqid().'.'.$ret['ext'];
        elseif(empty($fileName))
            $fileName = $ret['f']['name'];
        else
            $fileName .= '.'.$ret['ext'];
        $ret['name'] = $fileName;

        $uploadDir = str_replace('\\', '/', trim($uploadDir));
        //TODO uploaddir starts with . or ~
        if(substr($uploadDir, 0, -1) !== '/')
            $uploadDir .= '/';
        if(stripos($uploadDir,$this->docRoot) === false) { // upload dir has NO document root
            if(substr($uploadDir,0,1) != '/')
                $ret['web_dir'] = str_replace('//', '/', $this->webRoot . $uploadDir);
            else
                $ret['web_dir'] = str_replace('//', '/', $uploadDir);
            $ret['fs_dir']  = str_replace('//', '/', $this->docRoot . $ret['web_dir']);
        } else { // upload dir has document root
            $ret['fs_dir']  = str_replace('//', '/', $uploadDir);
            $webDir = str_ireplace($this->docRoot, '', $uploadDir);
            if(substr($webDir,0,1) !== '')
                $webDir = '/' . $webDir;
            if(substr($webDir,0,-1) !== '')
                $webDir .= '/';
            $ret['web_dir'] = str_replace('//', '/', $webDir);
        }
        $ret['web_name'] = $ret['web_dir'] . $ret['name'];
        $ret['fs_name'] = $ret['fs_dir'] . $ret['name'];

        //TODO sera mejor copy? por los permisos!
        //TODO realpath?
        if(!move_uploaded_file($ret['f']['tmp_name'], $ret['fs_name'])) {
            $ret['ok'] = false;
            $ret['error'] = 120;
            $ret['error_msg'] = 'No file';
            return $ret;
        }
        @chmod($ret['fs_name'], 0664); // o 0644 o 640 o 660 //TODO setting in class
        return $ret;
    }

    function valid($key, $index=0, $extensions=array(), $mime=array(), $maxSize=null){
        if(!isset($_FILES[$key]))
             return array('ok'=>false,'error'=>UPLOAD_ERR_NO_FILE,'error_msg'=>'No file','k'=>$key,'f'=>array());
        if(is_array($_FILES[$key]['error']))
            $f = $this->normalizeFilesArray($key, $index);
        else
            $f = $_FILES[$key];

        $error = $f['error'];
        if(!isset($error) || is_array($error))
            return array('ok'=>null,'error'=>UPLOAD_ERR_NO_FILE,'error_msg'=>'No file','k'=>$key,'f'=>$f);
        $ret = array('ok'=>false,'error'=>$error,'error_msg'=>'','k'=>$key,'f'=>$f);
        switch ($error) {
            case UPLOAD_ERR_OK:
                break;
            case UPLOAD_ERR_NO_FILE:
                $ret['error_msg']='No file';
                return $ret;
            case UPLOAD_ERR_INI_SIZE:
            case UPLOAD_ERR_FORM_SIZE:
                $ret['error_msg']='Exceeded filesize limit.';
                return $ret;
            default:
                $ret['error_msg'] = 'Unknown errors';
                return $ret;
        }
        $tmp_name = $f['tmp_name'];
        $name = trim($f['name']);
        if(empty($name) || is_array($name) || empty($tmp_name) || is_array($tmp_name)){
            $ret['error_msg']='No file';
            return $ret;
        }
        $nameLen = mb_strlen($name,'UTF-8');
        $ret['ext'] = $extension = mb_substr(mb_strrchr($name, '.',false,'UTF-8'), 1, $nameLen,'UTF-8');

        if(preg_match('/[\/\\|\<\>\~\p{Cc}]/mU',$name) || substr($name,0,1)==='.') {
            $ret['error']=100;
            $ret['error_msg']='Invalid file name, special characters';
            return $ret;
        }

        if($nameLen >= 255) {
            $ret['error']=100;
            $ret['error_msg']='Invalid file name, to long';
            return $ret;
        }

        // check extension
        $ext = mb_strtolower($extension);
        if(empty($extension) || !array_key_exists($ext,array_flip($extensions))) {
            $ret['error']=101;
            $ret['error_msg']='Invalid file type';
            return $ret;
        }

        if(!is_uploaded_file($tmp_name) || !is_uploaded_file(realpath($tmp_name))) {
            $ret['error']=101;
            $ret['error_msg']='Invalid file';
            return $ret;
        }

        $size = $f['size'];
        if(!empty($size) && $size > $this->get_maxFileSize()) {
            $ret['error_msg']='Exceeded filesize limit.';
            return $ret;
        }

        // check mime_type


        $ret['ok'] = true;
        return $ret;
    }

    private function normalizeFilesArray($key, $index) {
        return array(
            'name' => isset($_FILES[$key]['name'][$index]) ? $_FILES[$key]['name'][$index] : null,
            'tmp_name' => isset($_FILES[$key]['tmp_name'][$index]) ? $_FILES[$key]['tmp_name'][$index] : null,
            'type' => isset($_FILES[$key]['type'][$index]) ? $_FILES[$key]['type'][$index] : null,
            'error_msg' => isset($_FILES[$key]['error_msg'][$index] )? $_FILES[$key]['error_msg'][$index] : UPLOAD_ERR_NO_FILE,
            'size' => isset($_FILES[$key]['size'][$index]) ? $_FILES[$key]['size'][$index] : 0,
        );
    }

    private function get_maxFileSize() {
        $upload_max_filesize = $this->units2bytes(ini_get('upload_max_filesize'));
        $maxSize = isset($_POST['MAX_FILE_SIZE']) ? $this->units2bytes($_POST['MAX_FILE_SIZE']) : $upload_max_filesize;
        if(empty($maxSize) || !is_numeric($maxSize) || $maxSize<1024)
            $maxSize = $upload_max_filesize;
        return max($maxSize,$upload_max_filesize);
    }

    private function units_remove($num) {
        $units = '';
        $n = str_replace(' ', '', $num); //TODO all spaces ie unicode spaces
        $len = mb_strlen($n,'UTF-8');
        for($i=1; $i<=$len; $i++) {
            $u = mb_substr($n,-$i,1,'UTF-8');
            if(ctype_digit($u) || $u==='.')
                break;
            $units=$u.$units;
        }
        return array('n'=>mb_substr($n,0,$len-$i+1,'UTF-8'), 'u'=>$units );
    }

    private function units2bytes($num) {
        static $byteUnits=array(
            'K'=>1024,'KB'=>1024,
            'M'=>1048576,'MB'=>1048576,
            'G'=>1073741824,'GB'=>1073741824,
            'T'=>1099511627776,'TB'=>1099511627776
        );
        $units = '';
        $n = str_replace(' ', '', $num); //TODO all spaces ie unicode spaces
        $len = mb_strlen($n,'UTF-8');
        for($i=1; $i<=$len; $i++) {
            $u = mb_substr($n,-$i,1,'UTF-8');
            if(ctype_digit($u) || $u==='.')
                break;
            $units=$u.$units;
        }
        if($units==='' || $units==='B')
            return $n;
        if(isset($byteUnits[$units]))
            return mb_substr($num,0,$len-$i+1,'UTF-8') * $byteUnits[$units]; //TODO bc_math?
        //TODO Bits?
        return false;
    }

}