<?php


/*

    $feriados = new iacWorkday();
    $feriados->workday_set(0,false)->workday_set(6,false);    // domingo y sabado
    $feriados->mexico_oficial_holidays()->mexico_custom_holidays(); // dias oficiales y jueves/viernes santo

    $feriados->nextWorkday('2016-01-09'); // regresa 1 dia habil despues de la fecha
    $feriados->prevWorkday('2016-01-09'); // regresa 1 dia habil antes de la fecha
*/
class iacWorkday {
    const TYPE_WEEK_1 = 1;
    const TYPE_WEEK_2 = 2;
    const TYPE_WEEK_3 = 3;
    const TYPE_WEEK_4 = 4;
    const TYPE_WEEK_LAST = 6;

    const TYPE_EXACT_DATE = 10;
    const TYPE_EACH_YEAR = 11;
    const TYPE_EASTER_WEEK = 12;
    const TYPE_SEXENIO_MEXICO = 20;

    protected $holidays_defined = array();
    protected $holidays = array();
    protected $workday = array(0=>false,1=>true,2=>true,3=>true,4=>true,5=>true,6=>false);

    public $workdya = array();

    public function isWorkday($date) {
         if(!$this->workday[(int)Date('w',$this->toTimestamp($date))]) {
            return false;
         }
         return !array_key_exists($this->toYmd($date), $this->holidays);
    }

    public function holidayTypeCombo($value) {
        $types = array(
            self::TYPE_WEEK_1=>'Primera semana',
            self::TYPE_WEEK_2=>'Segunda semana',
            self::TYPE_WEEK_3=>'Tercera semana',
            self::TYPE_WEEK_4=>'Cuarta semana',
            self::TYPE_WEEK_LAST=>'Ultima semana',
            self::TYPE_EXACT_DATE => 'Fecha exacta',
            self::TYPE_EACH_YEAR => 'Cada año',
            self::TYPE_EASTER_WEEK => 'En semana santa',
            self::TYPE_SEXENIO_MEXICO => 'Cada sexenio',
        );
        $ret = '';
        foreach($types as $key=>$label) {
            $showYear = $key==self::TYPE_EXACT_DATE ? 'data-year="1" ' : 'data-year="0" ';
            $showMonth = $key==self::TYPE_EASTER_WEEK ? 'data-month="0" ' : 'data-month="1" ';

            $sel = $value == $key ? ' SELECTED="SELECTED" ' : '';
            $ret .= "<option value='$key'$sel$showMonth$showYear>$label</option>";
        }
        return $ret;
    }

    public function nextWorkday($date,$days=1) {
        $timestamp = $this->toTimestamp($date);
        $i=1;
        while($i <= $days) {
            $timestamp += 86400;
            if($this->isWorkday($timestamp)) {
                $i++;
            }
        }
        if(is_numeric($date)) {
            return $timestamp;
        }
        if($date instanceof DateTime) {
            return new DateTime($timestamp);
        }
        return date('Y-m-d',$timestamp);
    }

    public function prevWorkday($date,$days=1) {
        $timestamp = $this->toTimestamp($date);
        $i=1;
        while($i <= $days) {
            $timestamp -= 86400;
            if($this->isWorkday($timestamp)) {
                $i++;
            }
        }
        if(is_numeric($date)) {
            return $timestamp;
        }
        if($date instanceof DateTime) {
            return new DateTime($timestamp);
        }
        return date('Y-m-d',$timestamp);
    }

	public function workday_set($weekday,$work) {
	   $this->workdya[$weekday] =  $work;
       return $this;
    }

	public function workday_get($weekday) {
	   return $this->workday[$weekday];
    }

    public function workdays() {
	   return $this->workday;
    }

    public function holidays_get() {
        return $this->holidays;
    }

    public function holiday_define($year,$month,$day,$type,$weekday=0,$title='') {
        $this->holidays_defined["$year.$month.$day.$type.$weekday"] = array('y'=>$year,'m'=>$month,'d'=>$day,'t'=>$type,'weekday'=>$weekday,'title'=>$title);
        $year = (int)Date('Y');
        $this->holiday_set($year,$month,$day,$type,$weekday,$title,$year - 1);
        $this->holiday_set($year,$month,$day,$type,$weekday,$title,$year);
        $this->holiday_set($year,$month,$day,$type,$weekday,$title,$year + 1);
        return $this;
    }

    public function mexico_oficial_holidays() {
        /* LFT ley federal de trabajo
        Artículo 74. Son días de descanso obligatorio: I.
        I.- El 1o. de enero;
        II. El primer lunes de febrero en conmemoración del 5 de febrero;
        III. El tercer lunes de marzo en conmemoración del 21 de marzo;
        IV. El 1o. de mayo; V. El 16 de septiembre;
        VI. El tercer lunes de noviembre en conmemoración del 20 de noviembre;
        VII. El 1o. de diciembre de cada seis años, cuando corresponda a la transmisión del Poder Ejecutivo Federal;
        VIII. El 25 de diciembre, y
        IX. El que determinen las leyes federales y locales electorales, en el caso de elecciones ordinarias, para efectuar la jornada electoral.
        */
        $this->holiday_define(0, 1, 1, self::TYPE_EACH_YEAR, 0, 'Año Nuevo');
        $this->holiday_define(0, 2, 5, self::TYPE_WEEK_1, 1, '5 de febrero');
        $this->holiday_define(0, 3, 21, self::TYPE_WEEK_3, 1, 'Natalicio Benito Juarez');
        $this->holiday_define(0, 5, 1, self::TYPE_EACH_YEAR, 0, 'Día del trabajo');
        $this->holiday_define(0, 9, 16, self::TYPE_EACH_YEAR, 0, 'Dia de la Independencia');
        $this->holiday_define(0, 11, 2, self::TYPE_EACH_YEAR, 0, 'Día de Muertos');
        $this->holiday_define(0, 11, 20, self::TYPE_WEEK_3, 1, 'Día de la Revolución');
        $this->holiday_define(0, 12, 1, self::TYPE_SEXENIO_MEXICO, 0, 'Transmisión del Poder Ejecutivo Federal');
        $this->holiday_define(0, 12, 25, self::TYPE_EACH_YEAR, 0, 'Navidad');
        return $this;
    }

    public function mexico_custom_holidays() {
        $this->holiday_define(0, 3, 30, self::TYPE_EASTER_WEEK, 4, 'Jueves Santo');
        $this->holiday_define(0, 3, 30, self::TYPE_EASTER_WEEK, 5, 'Viernes Santo');
        $this->holiday_define(0, 12, 12, self::TYPE_EACH_YEAR, 0, 'Virgen de Guadalupe');
        return $this;
    }

    public function calculate_holidays($fromYear,$toYear) {
        if($toYear < $fromYear) {
            $tmp = $fromYear;
            $fromYear = $toYear;
            $toYear = $tmp;
        }
        $fromYear--;
        $toYear++;
        for($year = $fromYear; $year <= $toYear; $year++) {
            foreach($this->holidays_defined as $h) {
                $this->holiday_set($h['y'],$h['m'],$h['d'],$h['t'],$h['weekday'],$h['title'],$year);
            }
        }
        return $this;
    }

    protected function holiday_set($year,$month,$day,$type,$weekday=0,$title='',$forYear=null) {
        if($forYear === null)
            $forYear = int(Date('Y'));

        $details = array('y'=>$year,'m'=>$month,'d'=>$day,'t'=>$type,'weekday'=>$weekday,'title'=>$title, 'forYear'=>$forYear);

        if($type == self::TYPE_EACH_YEAR) {
            $this->holidays[$forYear.'-'.str_pad($month,2,'0',STR_PAD_LEFT).'-'.str_pad($day,2,'0',STR_PAD_LEFT)] = $details;
            return $this;
        }

        if($type == self::TYPE_EXACT_DATE) {
            $this->holidays[$year.'-'.str_pad($month,2,'0',STR_PAD_LEFT).'-'.str_pad($day,2,'0',STR_PAD_LEFT)] = $details;
            return $this;
        }

        if($type >= self::TYPE_WEEK_1 && $type<=self::TYPE_WEEK_4) {
            $iWeek=1;
            $timestamp = mktime(0,0,0,$month,1,$forYear);
            $wd = Date('w',$timestamp);
            while($wd != $weekday || $iWeek!=$type) {
                if($wd == $weekday) {
                    $iWeek++;
                }
                $timestamp += 86400;
                $wd = Date('w',$timestamp);
            }
            $this->holidays[Date('Y-m-d', $timestamp )] = $details;
            return $this;
        }

        if($type == self::TYPE_WEEK_LAST) {
            $timestamp = $this->toTimestamp(Date('Y-m-t', mktime(0,0,0,$month,1,$forYear)) );
            while(Date('w',$timestamp) != $weekday ) {
                $timestamp -= 86400;
            }
            $this->holidays[Date('Y-m-d', $timestamp )] = $details;
            return $this;
        }

        if($type == self::TYPE_EASTER_WEEK) {
            $this->holidays[Date('Y-m-d', $this->easter($forYear,$weekday) )] = $details;
            return $this;
        }

        if($type == self::TYPE_SEXENIO_MEXICO) {
            $sexenios = array();
            if($forYear>1934)
                $to = $forYear + 1;
            else
                $to = 2024;
            for($i=1934;$i<=$to;$i = $i +6) {
                $sexenios[$i] = $i;
            }
            if(array_key_exists($forYear, $sexenios)) {
                $this->holidays[$forYear.'-'.str_pad($month,2,'0',STR_PAD_LEFT).'-'.str_pad($day,2,'0',STR_PAD_LEFT)] = $details;
            }
            return $this;
        }
        return $this;
    }

    public function easter($year,$weekday) {
        return easter_date($year) - 86400*(7-$weekday);
    }

    protected function toYmd($date) {
        if(is_numeric($date)) {
            return Date('Y-m-d',$date);
        }
        if($date instanceof DateTime) {
            return $dateTime->format('Y-m-d');
        }
        if(strlen($date) === 10) {
            return $date;
        }
        return substr($date,0,10);
    }

    protected function toTimestamp($date) {
        if(is_numeric($date)) {
            return $date;
        }
        if($date instanceof DateTime) {
            return strtotime($dateTime->format('Y-m-d'));
        }
        if(strlen($date) === 10) {
            return strtotime($date);
        }
        return strtotime(substr($date,0,10));
    }

}
