<?php
define('JSON_OPTIONS_FOR_MYSQL', JSON_UNESCAPED_UNICODE |JSON_INVALID_UTF8_IGNORE |JSON_INVALID_UTF8_SUBSTITUTE);
/**
 * Fecha mínima para eliminar vale pago
 * Esto para la validación de borrar pago en la conversión de vale a vale_pago
 * Format yyyy-mm-dd
 */

define('dateMinDeleteValePago', '2021-06-28');
/**
 * Id de cliente conocido para las notas de bodega
 */
define('CLIENTE_CONOCIDO_ID', '54bf6469e2cc81a311ec8f650620b538');
/**
 * Id de cliente 'BODEGAS PROPIAS' PARA TRASLADOS ENTRE BODEGAS
 */
define('BODEGAS_PROPIAS_ID', '11eca7b75d17fc8d81a354bf6469e2cc');
/**
 * Id de cliente 'PIÑA' PARA DESTINO TIENDA
 */
define('CLIENTE_PINA_ID', '11ecab0a89afaa8b81a354bf6469e2cc');
/**
 * Id de de ayudante SIN_AYUDANTES
 */
define('SIN_AYUDANTES_ID', '484d7ee23af386f611ed1fe0112d5cb0');
/**
 * Id de de ayudante AYUDANTE_ES_EL_CLIENTE
 */
define('AYUDANTE_ES_EL_CLIENTE_ID', '66ab9d2516bc0111ef19ce610a002703');
/**
 * Id de de ayudante AYUDANTE_LO_LLENA_EL_DESTINO
 */
define('AYUDANTE_LO_LLENA_EL_DESTINO_ID', '66ab9d2516bc0111ef19ce610a002702');
/**
 * Id de de ayudante ENTREGA_DIRECTA_DE_BODEGA
 */
define('ENTREGA_DIRECTA_DE_BODEGA_ID', '66ab9d2516bc0111ef19ce610a002701');
/**
 * Id de origen_bodega_id para Ajuste/Correccion
 */
define('AJUSTE_ORIGEN_ID', '11ece02e763d0484ac7454bf6469e2cc');
/**
 * Id de cliente 'AJUSTE'
 */
define('CLIENTE_AJUSTE_ID', '11ed3acb3267a181a38e54bf6469e2cc');
/**
 * Id de cliente 'CONTAINER'
 */
define('CLIENTE_CONTAINER_ID', '11ed3acb32679f19a38e54bf6469e2cc');
/**
 * Id de cliente para surtir
 */
define('CLIENTE_SURTIR_ID', '74867af2fe60bd2811ed3e9cad2b3f3f');
/**
 * Id de cliente de paso
 */
define('CLIENTE_DE_PASO_ID', '11ed5489bfcae9188bdc54bf6469e2cc');

/**
 * particion actual de nota_bodega
 */

$this_year = '2023';
define('Nota_Bodega_Current_Partition', ''); //"PARTITION (part_$this_year)");

/**
 * particion actual de nota_bodega
 */
define('Nota_Bodega_2022_Partition', ''); // 'PARTITION (part_2023, part_2022)');

/**
 * particion consulta de nota_bodega
 */
define('Nota_Bodega_Consulta_Partition', ''); // 'PARTITION (part_2023, part_2022)');

const Nota_Bodega_Partitions = [
    '2022' => 'part_2022',
    '2023' => 'part_2023',
    '2024' => 'part_2023',
    'all' => 'part_2022, part_2023',
];


/**
 * PARA LAS NUEVAS VARIABLES
 * SER CREAN EN UNA CONSTANTE VARS_DEFAULT, DONDE TENEMOS ACCESO A TODAS LAS QUE SE DEFINAN EN EL ARRAY
 */
return [
    'nota_bodega' => [
        'campos_correcion' => ["clientes", "ayudantes", "pedido_por", "numero_compra"]
    ],
    'tipo_cambio' => [
        'version_revisa_tc' => 'v2', // Para regresar con la versión anterior dejar vacio el valor

        'estado_tasa' => [
            'OK' => [
                'key' => 'OK',
                'descripcion' => 'La tasa está dentro de los límites',
                'label' => 'Tipo de Cambio Actual',
                'short_label' => 'T.C Actual',
                'message' => ''
            ],
            'WU' => [
                'key' => 'WU',
                'descripcion' => 'Advertencia de que la tasa está por encima del límite de advertencia',
                'label' => 'Tipo de Cambio Warning Superior',
                'short_label' => 'T.C Warning Superior',
                'message' => 'Tipo de Cambio Con Warning Superior'
            ],
            'WUA' => [
                'key' => 'WUA',
                'descripcion' => 'Advertencia de que la tasa está por encima del límite de advertencia y esta permitido',
                'label' => 'Tipo de Cambio Warning Superior Permitido',
                'short_label' => 'T.C Warning Superior Permitido',
                'message' => 'Tipo de Cambio Con Warning Superior Permitido'
            ],
            'LU' => [
                'key' => 'LU',
                'descripcion' => 'La tasa está por encima del umbral límite',
                'label' => 'Límite Superior',
                'short_label' => 'Límite Superior',
                'message' => 'Tipo de Cambio por arriba del limite superior permitido'
            ],
            'LUA' => [
                'key' => 'LUA',
                'descripcion' => 'La tasa está por encima del umbral límite y esta permitida',
                'label' => 'Límite Superior Permitido',
                'short_label' => 'Límite Superior Permitido',
                'message' => 'Tipo de Cambio por arriba del limite superior y esta permitido'
            ],
            'WD' => [
                'key' => 'WD',
                'descripcion' => 'Advertencia de que la tasa está por debajo del límite de advertencia',
                'label' => 'Tipo de Cambio Warning Inferior',
                'short_label' => 'T.C Warning Inferior',
                'message' => 'Tipo de Cambio Con Warning Inferior'
            ],
            'WDA' => [
                'key' => 'WDA',
                'descripcion' => 'Advertencia de que la tasa está por debajo del límite de advertencia y esta permitido',
                'label' => 'Tipo de Cambio Warning Inferior Permitido',
                'short_label' => 'T.C Warning Inferior Permitido',
                'message' => 'Tipo de Cambio Con Warning Inferior Permitido'
            ],
            'LD' => [
                'key' => 'LD',
                'descripcion' => 'La tasa está por debajo del umbral límite',
                'label' => 'Límite Inferior',
                'short_label' => 'Límite Inferior',
                'message' => 'Tipo de Cambio por abajo del limite inferior permitido'
            ],
            'LDA' => [
                'key' => 'LDA',
                'descripcion' => 'La tasa está por debajo del umbral límite',
                'label' => 'Límite Inferior Permitido',
                'short_label' => 'Límite Inferior Permitido',
                'message' => 'Tipo de Cambio por abajo del limite inferior y esta permitido'
            ],
            'L' => [
                'key' => 'L',
                'descripcion' => 'La tasa está por debajo o por encima del umbral límite',
                'label' => 'Tipo de Cambio Limite',
                'short_label' => 'T.C Limite',
                'message' => 'Tipo de Cambio fuera del rango permitido'
            ],
            'W' => [
                'key' => 'W',
                'descripcion' => 'La tasa está por debajo o por encima del umbral warning',
                'label' => 'Tipo de Cambio Warning',
                'short_label' => 'T.C Warning',
                'message' => 'Tipo de Cambio Con Advertencia'
            ],
            'OK_LINK_AUTOMATICO' => [
                'key' => 'OK_LINK_AUTOMATICO',
                'descripcion' => 'La tasa es aceptada por link automatico',
                'label' => 'Tipo de Cambio Por Link Automatico',
                'short_label' => 'T.C Valido: LINK AUTOMATICO',
                'message' => ''
            ],
            'OK_TC_PACTADO' => [
                'key' => 'OK_TC_PACTADO',
                'descripcion' => 'La tasa es aceptada por tipo de cambio pactado',
                'label' => 'Tipo de Cambio Pactado',
                'short_label' => 'T.C Valido: PACTADO',
                'message' => ''
            ],
            'OK_TCTEMP' => [
                'key' => 'OK_TCTEMP',
                'descripcion' => 'La tasa es aceptada por tipo de cambio TEMPORAL',
                'label' => 'Tipo de Cambio Temporal',
                'short_label' => 'T.C Valido: TEMPORAL',
                'message' => ''
            ],
        ],
        'response' => [
            'ok' => ['OK', 'WUA', 'WDA', 'LUA', 'LDA'],
            'warns' => ['W', 'WU', 'WD'],
            'limits' => ['L', 'LU', 'LD']
        ]
    ]
];