<?php

/** @noinspection PhpMissingReturnTypeInspection */
/** @noinspection PhpMissingParamTypeInspection */


/**
 * 2021-12-18 todo verde
 */

/**
 * Funciones para accesar los metodos de la clase IacMysqli
 *
 * @version 2021-12-02
 */


use Iac\inc\sql\IacMysqli;
use Iac\inc\sql\IacSqlException;

if(!defined('MYSQL_ASSOC'))
        define('MYSQL_ASSOC', MYSQLI_ASSOC);
    if(!defined('MYSQL_NUM'))
        define('MYSQL_NUM', MYSQLI_NUM);
    if(!defined('MYSQL_BOTH'))
        define('MYSQL_BOTH', MYSQLI_BOTH);
require_once(__DIR__.'/sql/IacMysqli.php');
require_once(__DIR__.'/sql/IacSqlInfo.php');
require_once(__DIR__.'/sql/IacSQLMultipleInsert.php');
require_once(__DIR__.'/sql/IacSqlBuilder.php');

    class sqlMysqli extends IacMysqli {

        public function __construct($host=null, $username=null, $passwd=null, $dbname='', $port=null, $socket=null) {
        global $gIAsql;
            if(isset($gIAsql['trace']))
                $this->traceOn = true;
            @parent::__construct($host,$username,$passwd,$dbname,$port,$socket);
            if(isset($gIAsql['trace']))
                $this->traceOn = true;

        }

        /**
         * IacMysqli::log_sql_error()
         * Stores an error for later processing
         *
         * @param string $sql sql command that caused the error
         * @param int $retries number of times this command has been re-sent to the server
         * @param bool $putMysqliError true include the error from mysqli, false the error is included in $sql
         * @return void
         * @see IacMysqli::$errorLog IacMysqli::$errorLog
         * @access public
         */
        public function log_sql_error($sql, $retries=0, $putMysqliError=true) {
            /** @noinspection DuplicatedCode */ global
            $gIAsql;
            // if($this->mysqli->errno == "1213" && $retries < 2) return; // ignora deadlock pero no otros errores de sql

            $retry = $retries === 0 ? '' : " -- retries: $retries";
            if($putMysqliError === false) {
                $gIAsql['err'].='<li>'.$sql.$retry;
            } else {
                $gIAsql['err'].='<li>'.$this->mysqli->errno.' '.$this->mysqli->error.'<br />'.$sql.$retry;
                $gIAsql['errno'] = $this->mysqli->errno;
                $gIAsql['error'] = $this->mysqli->error;
                $gIAsql['sql_error'] = $sql;
            }
            parent::log_sql_error($sql, $retries, $putMysqliError);
        }

        public function log_trace($sql, $retries=0) {
            if(!$this->traceOn || strpos($sql,'brain_store'))
                return;
            if($retries === 0)
                $this->trace[] = $sql;
            else
                $this->trace[] = $sql." -- retry $retries";
        }
    }

    global $gSqlClass,$gIAsql;
    try {
        $gSqlClass = new sqlMysqli($gIAsql['host'],$gIAsql['user'],$gIAsql['pwd'],$gIAsql['dbname'],$gIAsql['port'],$gIAsql['socket']);
        $gSqlClass->connect();
    } catch(Throwable $e) {
        header('DB error al conectarme', true, 501);
       echo "\r\n\r\n<pre style='color:red'> Error al conectarme a la base de datos: " . $e->getMessage() ."</pre>";
       die();
    }


// select into array
    /**
     * select colRegresaDePrimerRow, otraCol FROM
    *  regresa la primera columna del primer row
    * 
    * 
    * @param string $sql el sql string a ejecutar
    * @param mixed $dflt='' resultado a regresar si el sql da not found. DEFAULT ''
    * @param mixed $errResult=FALSE' resultado a regresar si el sql da error. DEFAULT FALSE
    * @return mixed $errResult normalmente false on error, el resultado del query.
     */
    function ia_singleread($sql,$dflt='',$errResult=FALSE) { //,$getNumRows=true,$showError=true
    global $gIAsql,$gSqlClass;
        try { $ret = $gSqlClass->single_read($sql,$dflt); }
        catch(IacSqlException) {
            return $errResult;
        }
        $gIAsql['selected_rows'] = $gSqlClass->num_rows;
        if($ret === false)
            return $errResult;
        return $ret;
    }


    /**
    * Regresa el primer row en un array
    *
    * @param string $sql el sql string a ejecutar
    * @param int $assoc=MYSQL_ASSOC como asociar el array MYSQLI_ASSOC,MYSQL_NUM,MYSQL_BOTH Default MYSQL_ASSOC
    * @return bool|array FALSE on error, el resultado del query en un array o null array en not found.
     */
    function ia_singleton($sql, $assoc = MYSQLI_ASSOC) { /* returns select fields in array (first row) */
    global $gIAsql,$gSqlClass;
        try {
            $ret = $gSqlClass->singleton($sql,array(), assoc_mysql2mysqli($assoc));
        } catch(IacSqlException) { return false; }
        $gIAsql['selected_rows'] = $gSqlClass->num_rows;
        return $ret;
    }

    /**
    *  Regresa todas las columnas seleccionadas del primer row SELECT col1,col2 da: [col1 => v1,col2 => v2]
     * De no existir regresa [col1 => $enNull, cold2 => $enNull]
     * 
    * @param string $sql el sql string a ejecutar
    * @param mixed $enNull='' que poner si el campo es null. Defaullt '-'
    * @return bool|array FALSE on error, el resultado del query en un array o null array en not found.
     */
    function ia_singletonFull($sql,$enNull='') { //,$assoc=MYSQL_ASSOC
    global $gIAsql,$gSqlClass;
        try {
            $ret = $gSqlClass->singleton_full($sql, $enNull);
        } catch(IacSqlException) { return false; }
        $gIAsql['selected_rows'] = $gSqlClass->num_rows;
        return $ret;
    }

    /**
     * [ 'byValor1'=>[col1=>v1,col2=>v2, $by=>byValor1], ... ]
    * returns 2 dim array con key $by del $sql con MYSQL_ASSOC.
    *
    * @param string $sql el sql string a ejecutar
     * @param string $by
     * @param mixed $assoc
     * @return array|false false on error, el 2 dim array con key $by del query $sql. null array en not found
     */
    function ia_sqlArray($sql,$by='id',$assoc=MYSQL_ASSOC) { // ,$showErrors=true,&$fieldInfo=null
    global $gIAsql,$gSqlClass;
        try {
            $ret = $gSqlClass->selectArrayKey($sql,$by,array(),assoc_mysql2mysqli($assoc));
        } catch(IacSqlException) { return false; }
        $gIAsql['selected_rows'] = $gSqlClass->num_rows;
        return $ret;
    }

    /**
     * ia_sqlArrayIndx()
     *
     * @param string $sql el sql string a ejecutar
     * @param mixed $assoc
     * @return array|false FALSE on error, el 2 dim array con key num row del query $sql. null array en not found
     */
    function ia_sqlArrayIndx($sql,$assoc=MYSQL_ASSOC) { // ,$showError=true
        global $gIAsql,$gSqlClass;
        try {
            $ret = $gSqlClass->selectArrayIndex($sql,array(), assoc_mysql2mysqli($assoc));
        } catch(IacSqlException) { return false; }
        $gIAsql['selected_rows'] = $gSqlClass->num_rows;
        return $ret;
    }

    /**
     *  SELECT col1, col2 FROM da ['valor De Col1 Row#1', 'valor De Col1 Row#2', ]
     *
     * @param string $sql
     * @return array|false
     */
    function ia_sqlVector($sql) {
    global $gIAsql,$gSqlClass;
        try {
            $ret = $gSqlClass->selectVector($sql);
        } catch(IacSqlException) { return false; }
        $gIAsql['selected_rows'] = $gSqlClass->num_rows;
        return $ret;
    }

    /**
     * select key, value from da [key1 => val1, key2 => val2, ..]
     * 
     * @param string $sql el sql string a ejecutar
     * @return array|boolean FALSE on error, el 2 dim array con key $by del query $sql. null array en not found
     */
    function ia_sqlKeyValue($sql) {
    global $gIAsql,$gSqlClass;
        try {
            $ret = $gSqlClass->selectKeyValue($sql);
        } catch(IacSqlException) { return false; }
        $gIAsql['selected_rows'] = $gSqlClass->num_rows;
        return $ret;
    }

    function ia_sqlSelectMultiKey($sql, $numKeys, $resultType = MYSQLI_ASSOC, $autoPrefix = false) {
        global $gIAsql,$gSqlClass;
        try {
            $ret = $gSqlClass->selectArrayMultiKey($sql,$numKeys, $resultType, $autoPrefix);
        } catch(Exception) { return []; }
        $gIAsql['selected_rows'] = $gSqlClass->num_rows;
        return $ret;
    }

// Transacciones
    /**
     * Ejecuta todos los comandos en $arr en una transacción
     *
     * @param array $arr
     * @param string $cmnt
     * @param bool $findID
     * @return bool TRUE en error con rollback realiazado, FALSE all ok
     * @noinspection PhpUnusedParameterInspection
     */
    function ia_transaction($arr,$cmnt='trsct',$findID=true) {
        global $gIAsql,$gSqlClass;
        try {
            $ret = $gSqlClass->transaction($arr,$findID,'<<_','_>>','<_','_>','id');
        } catch(IacSqlException) {
            ia_rollback();
            ia_errores_a_dime("Transaction Failed! $cmnt " . ToCode::variable('transaction', $arr) , file: __FILE__, error_type: "Sql", line: __LINE__);
            return true;
        }
        if($ret === false) {
            ia_rollback();
            ia_errores_a_dime("Transaction Failed! $cmnt " . ToCode::variable('transaction', $arr) , file: __FILE__, error_type: "Sql", line: __LINE__);
        }
        $gIAsql['affected_rows'] = $gSqlClass->affected_rows;
        return !$ret;
    }

    /**
    * Inicia una transaccion.
     *
    * @return bool TRUE on error, FALSE on ok transaction started.
     * @noinspection PhpUnusedParameterInspection
     */
    function ia_begin($cmnt='strt') { // ,$setAutoCommit=TRUE
    global $gSqlClass;
        try {
            return !$gSqlClass->begin();
        } catch(IacSqlException) { return true; }
    }

    /**
     * ia_commit()
    * Hace commit de una transaccion.
    * - Decrementando $gIAsql['begins'] en 1.
     * @param string $cmnt
     * @return bool true on error, false all ok
     * @noinspection PhpUnusedParameterInspection
     */
    function ia_commit($cmnt='cmit') { //,$autocommit=TRUE
    global $gSqlClass;
        try {
            return !$gSqlClass->commit();
        } catch(IacSqlException) {return true;}
    }

    /**
     * ia_rollback()
    * Hace rollback de una transaccion
    * - Decrementando $gIAsql['begins'] en 1.
     * @param string $cmnt
     * @return bool TRUE on error, FALSE all ok rollback done.
     * @noinspection PhpUnusedParameterInspection
     */
    function ia_rollback($cmnt='rllbck') { // ,$autocommit=TRUE
    global $gSqlClass;
        try {
            return !$gSqlClass->rollback();
        } catch(IacSqlException) { return true; }
    }

// queries cambian datos o db_schema

    /**
    * Ejecuta comando de sql, query (DML, DDL) que no regresa datos
    * ie alter,delete,insert,update,replace,...
    *
    * @param string $sql el sql string a ejecutar
    * @return bool TRUE on error, FALSE on ok.
     * @noinspection PhpUnusedParameterInspection
     */
    function ia_query($sql, $doAffectedRows=TRUE, $doRetry=true) {
        global $gIAsql,$gSqlClass;
        $gIAsql['id_registro'] = '';
        try {
             $ret = !$gSqlClass->query($sql);
        } catch(IacSqlException) {return true;}
            $gIAsql['affected_rows'] = $gSqlClass->affected_rows;
            $gIAsql['id_registro'] = last_inserted_id();
        return $ret;
    }
/*
function ia_queryOri($sql,$doAffectedRows=TRUE,$doRetry=true) {
    global $gIAsql,$gSqlClass;
    if(!$doRetry) {
        $prev = $gSqlClass->retries;
        $gSqlClass->retries = 0;
    }
    try { $ret = $gSqlClass->query($sql); }
    catch(IacSqlException) {$ret = false;}
    if($doAffectedRows) {
        if($ret)
            $gIAsql['affected_rows'] = $gSqlClass->affected_rows;
        else
            $gIAsql['affected_rows'] = 0;
    }
    if(!$doRetry) {
        $gSqlClass->retries = $prev;
    }
    return !$ret;
}
*/
    /**
     * Ejecuta todos los comandos en $arr (sin transacción)
     *
     * @param array $arr
     * @param bool $findID
     * @return bool TRUE error, FALSE all ok
     */
    function ia_nontransaction($arr,$findID=true) {
        global $gIAsql,$gSqlClass;
        try {
            $ret = $gSqlClass->queryArray($arr,$findID,'<_','_>','<_','_>','id');
        } catch(IacSqlException) { $ret = true; }
        $gIAsql['affected_rows'] = $gSqlClass->affected_rows;
        return !$ret;
    }

    /**
     * Ejecuta insert regresando el auto_increment id creado.
     *
     * @param string $sql el sql string a ejecutar
     * @return int|string|false  false on error, auto_increment id on Active.
     */
    function ia_insertIded($sql) {
        global $gSqlClass;
        try {
            return $gSqlClass->insertAndGetId($sql);
        } catch(IacSqlException) { return false;}
    }


// Meta data e informativas

    function trace_sql($bool) {
        global $gSqlClass;
        $gSqlClass->traceOn = $bool;
    }

    function sql_trace_get() {
        global $gSqlClass;
        return $gSqlClass->trace_get();
    }

    function last_inserted_id() {
    global $gSqlClass;
        return $gSqlClass->mysqli->insert_id;
    }

    function affected_rows() {
    global  $gIAsql;
        return $gIAsql['affected_rows'];
    }

    function getMetaData($sql) {
        global $gSqlClass;
        try {
            $prev = $gSqlClass->metaDataOn;
            $gSqlClass->metaDataOn = true;
            $gSqlClass->singleton($sql);
            $gSqlClass->metaDataOn = $prev;
            return $gSqlClass->metaData_get();
        } catch(IacSqlException) { return false; }
    }

    function metaDataOnSet($bool) {
        global $gSqlClass;
        $prev = $gSqlClass->metaDataOn;
        $gSqlClass->metaDataOn = $bool;
        return $prev;
    }


// utiles
    function assoc_mysql2mysqli($assoc) {
    return match ($assoc) {
        MYSQLI_NUM, MYSQL_NUM => MYSQLI_NUM,
        MYSQLI_BOTH,  MYSQL_BOTH =>  MYSQLI_BOTH,
        default => MYSQLI_ASSOC,
    };
}

/**
 * ia_SqlOptions()
 *
 * @param string $sql
 * @param string|array $selected
 * @param mixed $extra
 * @param string $optionTag
 * @return string|false
 */
function ia_SqlOptions($sql,$selected='',$extra=array(),$optionTag='',$rn="\r\n") {

    $ret='';
    if($extra) foreach($extra as $k=>$v)
		if(is_array($selected)) {
			$ret.= "$rn<option value='$k'".(array_key_exists($k,$selected) ? " SELECTED='selected' " : "")."$optionTag>".ia_htmlentities($v)."</option>";
		} else {
			$ret.= "$rn<option value='$k'".(strcmp($selected,$k) ? "" : " SELECTED='selected' ")."$optionTag>".ia_htmlentities($v)."</option>";
		}
    $arr = ia_sqlArrayIndx($sql,MYSQLI_NUM);
    if($arr === false) return false;
    foreach($arr as $d) {
		if(is_array($selected)) {
			$ret.= "$rn<option value='$d[0]'".(array_key_exists($d[0],$selected) ? " SELECTED='selected' " : "")."$optionTag>".ia_htmlentities($d[1])."</option>";
		} else {
			$ret.= "$rn<option value='$d[0]'".(strcmp($selected,$d[0]) ? "" : " SELECTED='selected' ")."$optionTag>".ia_htmlentities($d[1])."</option>";
		}
	}
	return $ret;
}

/**
 * ia_echoSqlOptions()
 * Hace un echo de options de un select donde col 1 es el value, col 2 el texto del sql, selected trae el value (col 1) se marca como selected
 * 
 * falta quote protect $d[0]
 * @param string $sql el sql string a ejecutar col 1 es el value del option, col 2 se el texto entre options
 * @param string|array $selected
 * @param string $optionTag
 * @return bool FALSE on error, TRUE ok
 *
 * @codeCoverageIgnore
 */
function ia_echoSqlOptions($sql,$selected='',$optionTag='') {
    $arr = ia_sqlArrayIndx($sql,MYSQLI_NUM);
    foreach($arr as $d) {
		if(is_array($selected)) {
			echo "\r\n<option value='$d[0]'".(array_key_exists($d[0],$selected) ? " SELECTED='selected' " : "")."$optionTag>".ia_htmlentities($d[1])."</option>";
		} else {
			echo "\r\n<option value='$d[0]'".(strcmp($selected,$d[0]) ? "" : " SELECTED='selected' ")."$optionTag>".ia_htmlentities($d[1])."</option>";
		}
    }
    return TRUE;
}


/**
 * ia_SqlOptionsSetDataData()
 *
 * @param string $sql
 * @param string|array $selected
 * @param mixed $extra
 * @param string $optionTag
 * @return

function ia_SqlOptionsSetDataData($sql,$selected='',$extra=array(),$optionTag='') {
global $gIAsql;
    $ret = '';
    if($extra) foreach($extra as $k=>$v)
		if(is_array($selected)) {
			$ret.= "\r\n<option value='$k'" . (array_key_exists($k,$selected) ? " SELECTED='selected' " : "")."$optionTag>".ia_htmlentities($v)."</option>";
		} else {
			$ret.= "\r\n<option value='$k'" . (strcmp($selected,$k) ? "" : " SELECTED='selected' ")."$optionTag>".ia_htmlentities($v)."</option>";
		}
    $arr = ia_sqlArrayIndx($sql,MYSQLI_NUM);
    foreach($arr as $d) {
		if(is_array($selected)) {
			$ret.= "\r\n<option data-data='$d[2]' value='$d[0]'".(array_key_exists($d[0],$selected) ? " SELECTED='selected' " : "")."$optionTag>".ia_htmlentities($d[1])."</option>";
		} else {
			$ret.= "\r\n<option data-data='$d[2]' value='$d[0]'".(strcmp($selected,$d[0]) ? "" : " SELECTED='selected' ")."$optionTag>".ia_htmlentities($d[1])."</option>";
		}
    }
    return true;
}
 */