<?php
namespace Vitex\Tester;

/*
 Regresa casos de notas a bodega para probar
 */

use Exception;
use JetBrains\PhpStorm\ArrayShape;

class BodegaCasosNotas {
    const ARRAY_SHAPE_NOTA_BODEGA = ['descripcion'=>'string',
        'bodega_id'=>'int', 'producto_general_id'=>'string', 'color_id'=>'string',
        'bodega'=>'string', 'producto'=>'string',  'color'=>'string'];
    const ARRAY_SHAPE_NOTA_CON_ITEMS = ['descripcion'=>'string','error_contains'=>'string',
        'fecha' => 'string',
        'bodega_id'=>'int', 'producto_general_id'=>'string',
        'bodega'=>'string', 'producto'=>'string',
        'items'=>[]
    ];

    protected array $reporta = [];
    protected array $productosActivos = [];
    protected array $coloresActivos = [];
    protected array $bodegasActivas = [];
    protected array $origenEntrada = [];
    protected array $origenSalida = [];

    public function __construct() {
        $method = __METHOD__;
        $this->productosActivos = ia_sqlArrayIndx("SELECT /*$method*/ producto_general_id, producto FROM producto_general WHERE activo='Si'");
        $this->coloresActivos = ia_sqlArrayIndx("SELECT /*$method*/ color_id, color FROM color WHERE activo='Si'");
        $this->bodegasActivas = ia_sqlArrayIndx("SELECT /*$method*/ bodega_id, bodega FROM bodega WHERE activo='Si' AND grupo NOT IN ('china', 'pedido') LIMIT 1");
        $this->origenEntrada = ia_sqlArrayIndx("SELECT /*$method*/ origen_bodega_id, clave, es FROM origen_bodega WHERE vale_bodega_entrada='Si'");
        $this->origenSalida = ia_sqlArrayIndx("SELECT /*$method*/ origen_bodega_id, clave, es FROM origen_bodega WHERE vale_bodega_salida='Si'");
    }


    public function reporta():array {
        return $this->reporta;
    }
    /**
     * articulo, bodega: no existe en producto_color, producto_bodega ni bodega_existencia_diaria
     * Revisar exista correctamente en producto_color, producto_bodega, bodega_existencia_diaria despues de crear su nota.
     *
     * @param int $numberOfRows
     * @return array
     * @throws Exception
     */
    #[ArrayShape(BodegaCasosNotas::ARRAY_SHAPE_NOTA_BODEGA)]
    public function articulo_primera_vez(int $numberOfRows = 10):array {
        $method = __METHOD__;
        $sql = "
        SELECT /*$method*/ 'NUEVO en producto_color NUEVO en producto_bodega y bodega_existencia_diaria' as descripcion, 
                         b.bodega, pg.producto, c.color, b.bodega_id, pg.producto_general_id, c.color_id
            FROM producto_general pg
            JOIN color c
            JOIN (SELECT bod.bodega_id,bod.bodega FROM bodega bod WHERE bod.activo='Si' AND bod.bodega_id>1 LIMIT 1) as b
            WHERE pg.activo = 'Si' AND pg.para_bodega='En Bodega' AND c.activo='Si' AND c.color_id IS NOT NULL AND
            NOT EXISTS (SELECT 1 FROM producto_color pc WHERE pg.producto_general_id = pc.producto_general_id AND pc.color_id=c.color_id) AND 
            NOT EXISTS (SELECT 1 FROM producto_bodega pc WHERE pc.bodega_id=b.bodega_id AND pg.producto_general_id = pc.producto_general_id AND pc.color_id=c.color_id) AND
            NOT EXISTS (SELECT 1 FROM bodega_existencia_diaria pc WHERE pc.bodega_id=b.bodega_id AND pg.producto_general_id = pc.producto_general_id AND pc.color_id=c.color_id)
        ORDER BY 2,3,4 LIMIT $numberOfRows";
        $return = ia_sqlArrayIndx($sql);
        if($return === false)
            throw new Exception("Sql error en " . __METHOD__);
        if(empty($return))
            throw new Exception("No encontre articulos se usaran por primera vez");
        return $return;
    }

    /**
     * articulo, bodega: si existe en producto_color, no en producto_bodega
     * Revisar exista correctamente en producto_bodega, bodega_existencia_diaria despues de crear su nota y no cambie producto_color
     *
     * @param int $numberOfRows
     * @return array
     * @throws Exception
     */
    #[ArrayShape(BodegaCasosNotas::ARRAY_SHAPE_NOTA_BODEGA)]
    public function articulo_en_producto_color_sin_producto_bodega(int $numberOfRows = 10):array {
        $method = __METHOD__;
        $sql =
            "SELECT /*$method*/ 'YA en producto_color NUEVO en producto_bodega y bodega_existencia_diaria' as descripcion, b.bodega, pg.producto, c.color, b.bodega_id, pc.producto_general_id, pc.color_id
            FROM producto_color pc
                     JOIN producto_general pg on pc.producto_general_id = pg.producto_general_id
                     JOIN color c on pc.color_id = c.color_id
                     JOIN bodega b
            WHERE pg.activo = 'Si' AND pg.para_bodega='En Bodega' AND c.activo = 'Si' AND b.activo='Si' AND
                NOT EXISTS (SELECT 1 FROM producto_bodega pb WHERE pb.producto_general_id = pc.producto_general_id AND pb.color_id=pc.color_id AND pb.bodega_id = b.bodega_id)
            ORDER BY 2, 3, 4  LIMIT $numberOfRows";
        $return = ia_sqlArrayIndx($sql);
        if($return === false)
            throw new Exception("Sql error en " . __METHOD__);
        if(empty($return))
            $this->reporta[] = "No encontre articulos " . __METHOD__;
        return $return;
    }

    /**
     *
     * Revisar de error: ni alta, ni update, ni cambios
     *
     * @return array
     * @throws Exception
     */
    #[ArrayShape(BodegaCasosNotas::ARRAY_SHAPE_NOTA_CON_ITEMS)]
    public function datosInvalidos():array {
        $hoy = Date('Y-m-d');
        $method = __METHOD__;
        $bodega = $this->bodegasActivas[rand(0, count($this->bodegasActivas)-1)];
        $color = $this->coloresActivos[rand(0, count($this->coloresActivos)-1)];
        $producto_general = $this->productosActivos[rand(0, count($this->productosActivos) -1)];

        // con id no exista
        $invalid = str_repeat("1", 32);
        //$last = \NotaBodega::getLastNumero($bodega['bodega_id']);
        //$numeroDeNotaOk = (int)$last['numero']+1;
        $numeroDeNotaOk = (int)\NotaBodega::getlastNumber($bodega['bodega_id']) + 1;
        $return = [
            ['descripcion'=>'Sin items', 'error_contains' => 'no tiene productos',
                'numero' => $numeroDeNotaOk,
                'fecha'=>$hoy,
                'bodega_id'=>$bodega['bodega_id'],
                'bodega'=>$bodega['bodega_id'],
                'producto_general_id'=>$producto_general['producto_general_id'],
                'producto'=>$producto_general['producto'],
                'items' =>[]
            ],
            ['descripcion'=>'Falta el  numero de nota', 'error_contains' => '<b>Numero</b> es requerido',
                'bodega_id'=>$bodega['bodega_id'],
                'fecha'=>$hoy,
                'numero' => '',
                'bodega'=>$bodega['bodega_id'],
                'producto_general_id'=>$producto_general['producto_general_id'],
                'producto'=>$producto_general['producto'],
                'items' =>[
                    [
                        '_id_'=>$color['color_id'],
                        'color_id'=>$color['color_id'],
                        'color_label'=>$color['color'],
                        'rollos' => "2",
                        'quantity' => "44.00",
                    ],
                ],
            ],
            ['descripcion'=>'Número de nota no es numerico', 'error_contains' => 'Numero',
                'bodega_id'=>$bodega['bodega_id'],
                'fecha'=>$hoy,
                'numero' => 'asdf',
                'bodega'=>$bodega['bodega_id'],
                'producto_general_id'=>$producto_general['producto_general_id'],
                'producto'=>$producto_general['producto'],
                'items' =>[
                    [
                        '_id_'=>$color['color_id'],
                        'color_id'=>$color['color_id'],
                        'color_label'=>$color['color'],
                        'rollos' => "2",
                        'quantity' => "44.00",
                    ],
                ],
            ],
            ['descripcion'=>'Rollos falta', 'error_contains' => 'rollos',
                'numero' => $numeroDeNotaOk,
                'bodega_id'=>$bodega['bodega_id'],
                'fecha'=>$hoy,
                'bodega'=>$bodega['bodega_id'],
                'producto_general_id'=>$producto_general['producto_general_id'],
                'producto'=>$producto_general['producto'],
                'items' =>[
                    [
                        '_id_'=>$color['color_id'],
                        'color_id'=>$color['color_id'],
                        'color_label'=>$color['color'],
                        'rollos' => "",
                        'quantity' => "44.00",
                    ],
                ],
            ],
            ['descripcion'=>'Rollos con decimales', 'error_contains' => 'rollos',
                'numero' => $numeroDeNotaOk,
                'bodega_id'=>$bodega['bodega_id'],
                'fecha'=>$hoy,
                'bodega'=>$bodega['bodega_id'],
                'producto_general_id'=>$producto_general['producto_general_id'],
                'producto'=>$producto_general['producto'],
                'items' =>[
                    [
                        '_id_'=>$color['color_id'],
                        'color_id'=>$color['color_id'],
                        'color_label'=>$color['color'],
                        'rollos' => "1.944",
                        'quantity' => "44.00",
                    ],
                ],
            ],

            ['descripcion'=>'Rollos negativos', 'error_contains' => 'rollos',
                'numero' => $numeroDeNotaOk,
                'bodega_id'=>$bodega['bodega_id'],
                'fecha'=>$hoy,
                'bodega'=>$bodega['bodega'],
                'producto_general_id'=>$producto_general['producto_general_id'],
                'producto'=>$producto_general['producto'],
                'items' =>[
                    [
                        '_id_'=>$color['color_id'],
                        'color_id'=>$color['color_id'],
                        'color_label'=>$color['color'],
                        'rollos' => "-2",
                        'quantity' => "44.00",
                    ],
                ],
            ],


            ['descripcion'=>'Quantity falta', 'error_contains' => 'quantity',
                'numero' => $numeroDeNotaOk,
                'bodega_id'=>$bodega['bodega_id'],
                'fecha'=>$hoy,
                'bodega'=>$bodega['bodega_id'],
                'producto_general_id'=>$producto_general['producto_general_id'],
                'producto'=>$producto_general['producto'],
                'items' =>[
                    [
                        '_id_'=>$color['color_id'],
                        'color_id'=>$color['color_id'],
                        'color_label'=>$color['color'],
                        'rollos' => "1",
                        'quantity' => "",
                    ],
                ],
            ],

            ['descripcion'=>'Quantity negativos', 'error_contains' => 'quantity',
                'numero' => $numeroDeNotaOk,
                'bodega_id'=>$bodega['bodega_id'],
                'bodega'=>$bodega['bodega_id'],
                'fecha'=>$hoy,
                'producto_general_id'=>$producto_general['producto_general_id'],
                'producto'=>$producto_general['producto'],
                'items' =>[
                    [
                        '_id_'=>$color['color_id'],
                        'color_id'=>$color['color_id'],
                        'color_label'=>$color['color'],
                        'rollos' => "2",
                        'quantity' => "-44.00",
                    ],
                ],
            ],
            ['descripcion'=>'Quantity cero', 'error_contains' => 'quantity',
                'numero' => $numeroDeNotaOk,
                'bodega_id'=>$bodega['bodega_id'],
                'bodega'=>$bodega['bodega_id'],
                'fecha'=>$hoy,
                'producto_general_id'=>$producto_general['producto_general_id'],
                'producto'=>$producto_general['producto'],
                'items' =>[
                    [
                        '_id_'=>$color['color_id'],
                        'color_id'=>$color['color_id'],
                        'color_label'=>$color['color'],
                        'rollos' => "0",
                        'quantity' => "0.00",
                    ],
                ],
            ],
            ['descripcion'=>'Rollos y quantity cero', 'error_contains' => 'Quantity menor a lo esperado',
                'numero' => $numeroDeNotaOk,
                'bodega_id'=>$bodega['bodega_id'],
                'bodega'=>$bodega['bodega_id'],
                'fecha'=>$hoy,
                'producto_general_id'=>$producto_general['producto_general_id'],
                'producto'=>$producto_general['producto'],
                'items' =>[
                    [
                        '_id_'=>$color['color_id'],
                        'color_id'=>$color['color_id'],
                        'color_label'=>$color['color'],
                        'rollos' => "0",
                        'quantity' => "0.00",
                    ],
                ],
            ],
           ['descripcion'=>'Color duplicado','error_contains' => 'color',
               'numero' => $numeroDeNotaOk,
                'bodega_id'=>$bodega['bodega_id'],
                'bodega' => $bodega['bodega'],
               'fecha'=>$hoy,
                'producto_general_id'=>$producto_general['producto_general_id'],
                'producto'=>$producto_general['producto'],
                'items' =>[
                    [
                        '_id_'=>$color['color_id'],
                        'color_id'=>$color['color_id'],
                        'color_label'=>$color['color'],
                        'rollos' => "2",
                        'quantity' => "44.00",
                    ],
                    [
                        '_id_'=>$color['color_id'],
                        'color_id'=>$color['color_id'],
                        'color_label'=>$color['color'],
                        'rollos' => "3",
                        'quantity' => "66.00",
                    ],
                ]
            ],
            ['descripcion'=>'Nota en el futuro ' .Date('Y-m-d', strtotime('tomorrow')),
                'numero' => $numeroDeNotaOk,
                'error_contains' => 'fecha',
                'fecha'=>Date('Y-m-d', strtotime('tomorrow')),
                'bodega_id'=>$bodega['bodega_id'],
                'bodega'=>$bodega['bodega_id'],
                'producto_general_id'=>$producto_general['producto_general_id'],
                'producto'=>$producto_general['producto'],
                'items' =>[
                    [
                        '_id_'=>$color['color_id'],
                        'color_id'=>$color['color_id'],
                        'color_label'=>$color['color'],
                        'rollos' => "2",
                        'quantity' => "44.00",
                    ],
                ],
            ],
            /* @TODO Duda Nota del pasado solo genera inconsistencia
            ['descripcion'=>'Nota del mes pasado ' .
                Date('Y-m-d', strtotime('1 month ago')),
                'error_contains' => 'fecha',
                'fecha'=>Date('Y-m-d', strtotime('1 month ago')),
                'bodega_id'=>$bodega['bodega_id'],
                'bodega'=>$bodega['bodega_id'],
                'producto_general_id'=>$producto_general['producto_general_id'],
                'producto'=>$producto_general['producto'],
                'items' =>[
                    [
                        '_id_'=>$color['color_id'],
                        'color_id'=>$color['color_id'],
                        'color_label'=>$color['color'],
                        'rollos' => "2",
                        'quantity' => "44.00",
                    ],
                ],
            ],
            */
            ['descripcion'=>'bodega_id no Existe',
                'numero' => $numeroDeNotaOk,
                'error_contains' => 'sin permiso',
                'bodega_id'=>$invalid,
                'bodega'=>'bodega_id NO EXISTE',
                'fecha'=>$hoy,
                'producto_general_id'=>$producto_general['producto_general_id'],
                'producto'=>$producto_general['producto'],
                'items' =>[
                    [
                        '_id_'=>$color['color_id'],
                        'color_id'=>$color['color_id'],
                        'color_label'=>$color['color'],
                        'rollosNegativo' => '1',
                        'quantityNegativo' => '1',
                        'averageMal' => '1',
                        'rollos' => "2",
                        'quantity' => "44.00",
                    ],
                ]
            ],
            ['descripcion'=>'producto_general_id no Existe',
                'numero' => $numeroDeNotaOk,
                'error_contains' => 'Producto General',
                'bodega_id'=>$bodega['bodega_id'],
                'bodega' => $bodega['bodega'],
                'fecha'=>$hoy,
                'producto_general_id'=>$invalid,
                'producto'=>'producto_general_id NO EXISTE',
                'items' =>[
                    [
                        '_id_'=>$color['color_id'],
                        'color_id'=>$color['color_id'],
                        'color_label'=>$color['color'],
                        'rollosNegativo' => '1',
                        'quantityNegativo' => '1',
                        'averageMal' => '1',
                        'rollos' => "2",
                        'quantity' => "44.00",
                    ],
                ]
            ],

            ['descripcion'=>'color_id no Existe',
                'numero' => $numeroDeNotaOk,
                'error_contains' => 'color',
                'bodega_id'=>$bodega['bodega_id'],
                'bodega' => $bodega['bodega'],
                'fecha'=>$hoy,
                'producto_general_id'=>$producto_general['producto_general_id'],
                'producto'=>$producto_general['producto'],
                'items' =>[
                    $invalid => [
                        '_id_'=>$invalid,
                        'color_id'=>$invalid,
                        'color_label'=>$invalid,
                        'rollosNegativo' => '1',
                        'quantityNegativo' => '1',
                        'averageMal' => '1',
                        'rollos' => "2",
                        'quantity' => "44.00",
                    ],
                ]
            ],
        ];
        // pon id que esten inactive
        $bodegaInactive = ia_singleton("SELECT /*$method*/ bodega_id, bodega FROM bodega WHERE activo='No' LIMIT 1");
        if(!empty($bodegaInactive))
            $return[] =['descripcion'=>'bodega_id Inactive','error_contains' => 'sin permiso',
                'numero' => $numeroDeNotaOk,
                'bodega_id'=>$bodegaInactive['bodega_id'],
                'bodega'=>$bodegaInactive['bodega'],
                'fecha'=>$hoy,
                'producto_general_id'=>$producto_general['producto_general_id'],
                'producto'=>$producto_general['producto'],
                'items' =>[
                     [
                         '_id_'=>$color['color_id'],
                         'color_id'=>$color['color_id'],
                         'color_label'=>$color['color'],
                         'rollosNegativo' => '1',
                         'quantityNegativo' => '1',
                         'averageMal' => '1',
                         'rollos' => "2",
                         'quantity' => "44.00",
                    ],
                ]
            ];
        else
            $this->reporta[] = "No encontre bodega_id Inactive";

        $productoInactive = ia_singleton("SELECT /*$method*/ producto_general_id, producto FROM producto_general WHERE activo='No' LIMIT 1");
        if(!empty($productoInactive))
            $return[] = ['descripcion'=>'producto_general_id Inactive','error_contains' => 'Sin permiso',
                'numero' => $numeroDeNotaOk,
                'bodega_id'=>(int)$bodega['bodega_id'],
                'bodega' => $bodega['bodega'],
                'fecha'=>$hoy,
                'producto_general_id'=>$productoInactive['producto_general_id'],
                'producto'=>$productoInactive['producto'],
                'items' =>[
                     [
                         '_id_'=>$color['color_id'],
                         'color_id'=>$color['color_id'],
                         'color_label'=>$color['color'],
                         'rollos' => "2",
                         'quantity' => "44.00",
                    ],
                ]
            ];
        else
            $this->reporta[] = "No encontre producto_general_id Inactive";

        $colorInactive = ia_singleton("SELECT /*$method*/ color_id, color FROM color WHERE activo='No'");
        if(!empty($colorInactive))
            $return[] = ['descripcion'=>'color_id Inactive','error_contains' => 'Sin permiso',
                'numero' => $numeroDeNotaOk,
                'bodega_id'=>$bodega['bodega_id'],
                'bodega' => $bodega['bodega'],
                'fecha'=>$hoy,
                'producto_general_id'=>$producto_general['producto_general_id'],
                'producto'=>$producto_general['producto'],
                'items' =>[
                     [
                         '_id_'=>$color['color_id'],
                         'color_id'=>$color['color_id'],
                         'color_label'=>$color['color'],
                         'rollos' => "2",
                         'quantity' => "44.00",
                    ],
                ]
            ];
        else
            $this->reporta[] = "No encontre color_id Inactive";
        return $return;
    }

    #[ArrayShape(BodegaCasosNotas::ARRAY_SHAPE_NOTA_CON_ITEMS)]
    public function productoBodegaRandom(int $numberOfRows = 10):array {
        $hoy = Date('Y-m-d');
        $ayer = Date('Y-m-d', strtotime('yesterday'));
        /** @var array  #[ArrayShape(BodegaCasosNotas::ARRAY_SHAPE_NOTA_BODEGA)] $return*/
        $return = [];
        for($i=1; $i<=$numberOfRows; ++$i) {
            shuffle($this->productosActivos);
            shuffle($this->bodegasActivas);
            shuffle($this->coloresActivos);

            $items = [];
            for($iColor = 1, $len = rand(1,30); $iColor <= $len; ++$iColor) {
                if(empty($this->coloresActivos[$iColor]))
                    continue;
                $color_id = $this->coloresActivos[$iColor]['color_id'];
                if(array_key_exists($color_id, $items))
                    continue;
                $items[] = [
                    'color_id' => $color_id,
                    'color_label'=>$this->coloresActivos[$iColor]['color'] ?? 'color',
                    'rollos'=>rand(1,15), 'quantity' => rand(23, 15*23)
                ];
            }
            if(rand(1,10)%2) {
                $entrada_salida = 'Entrada';
                $origen_id = $this->origenEntrada[rand(0, count($this->origenEntrada)-1)]['origen_bodega_id'];
            } else {
                $entrada_salida = 'Salida';
                $origen_id = $this->origenSalida[rand(0, count($this->origenSalida)-1)]['origen_bodega_id'];
            }

            $return[] = [
                'descripcion'=>'Nota de Bodega Random y Ok',
                'fecha' => rand(1,10)%2 ? $hoy : $ayer,

                'bodega_id'=>$this->bodegasActivas[0]['bodega_id'],
                'bodega'=>$this->bodegasActivas[0]['bodega'],
                'producto_general_id'=>$this->productosActivos[0]['producto_general_id'],
                'producto'=>$this->productosActivos[0]['producto'],
                'items' => $items,
                'entrada_salida' => $entrada_salida,
                'origen_id' => $origen_id,
            ];
        }
        return $return;
    }

}
