<?php
/** @noinspection PhpUnused */

namespace Vitex\Tester;
/*

;
    * cache producto_bodega.producto no se actualiza al cambiar producto_general y capaz color
    *

REVISAR O ARREGLAR, ASEGUN

    A.- Incidencias agrupar en
        TIENDA_PUEDE_EDITAR num_compra, tipo nota, numero nota, quantity nota
        ? chofer/ayudantes
        BODEGA: contra_nota, average, negativo?

    B.- bodega_existencia_diaria
    Al cambiar algo de la fecha antes de hoy, cambiar
        UPDATE inciales +/- cambio
        WHERE bodega= AND producto= AND color= AND fecha>fecha_cambiada

    C.- Al borrar nota borrar de la tabla nota_bodega_contra_nota_bodega

    D.- Editar nota bodega
        D.1 Alta y luego Editar color y poner valores mal con agrega color
        D.2 Alta y luego Editar color y poner valores mal con save NOTA

    G.- unset o eleminar el nuevo campo registran_todas_bodegas en iac_usr?

    H.- index.php->tab Sistema-> Limpiar Bodegas (realmente borra) https://localhost/vitex/backoffice/limpiar_bodega.php

    I.- nota_server.php borrarla?
        MovBodegaDo::revisaInconsistencias paraece solo la usa nota_server
        Pero revisaInconsistencias seria muy bueno para no duplicar codigo en alta y edita

    J.- getOrigenBodegaEntrada $where_ajuste_inventario para verificacion

 */

use Iac\inc\sql\IacSqlBuilder;
use iaTableIt;

/**
 Corre revisiones y regresa un array con las situaciones encontradas, imprimir como tabla (tableHelper o TableIt)
 */
class BodegaRevisa {
    protected string $whereBodega='';

    /**
     * Limita los mas queries a una(s) bodega
     *
     * @param string|array|null $bodega_ids string "bodega_id", array [bodegaId1,bodegaId2,...]
     */
    public function __construct(string|array|null $bodega_ids = '') {
        if(!empty($bodega_ids)) {
            $builder = new IacSqlBuilder();
            $this->whereBodega = " AND (b.bodega_id IS NULL OR " . $builder->where(['b.bodega_id' => $bodega_ids]) . ")";
        } else
            $this->whereBodega = '';
    }

    public function reporta(array $methods = []):void {
        $ok = '<span style="color:green">✔</span>';
        $mal = '<span style="color:red">X</span>';
        if(empty($methods))
            $methods = [
                'nota_bodega_links' => ['d'=>'Revisa link _id, validos y activos, de nota_bodega'],
                'nota_items_links' => ['d'=>'Trata de checar los campos _id, validos y activos, de nota_bodega_items'],
                'nota_bodega_vs_items' => ['d'=>'Trata de checar nota vs sus items (nota_bodega vs nota_bodega_items)'],
                'nota_bodega_tipo' => ['d'=>'Trata de checar el tipo de nota vs el origen (note_bodega vs origen_bodega)'],
                'inconsistencia_vs_nota_bodega' => ['d'=>'Trata de checar inconsistencias vs notas de bodega'],

                //'nota_bodega_quantityRolloAverage' => ['d'=>'Trata de checar la diferencia en average tenga inconsistencia o autorizacion'],

                'contra_notas_tabla' => ['d'=>'Trata de checar notas vs sus contra notas y viceversa en nota_bodega_contra_nota_bodega'],
                'contra_notas_contra_numero' => ['d'=>'El numero de la nota contra_nota_bodega_id no coincide su nota_bodega'],
                'contra_nota_tabla_vs_contra_nota_bodega_id' => ['d'=>'nota_bodega_contra_nota_bodega.numero_nota vs nota_bodega.contra_nota_bodega_id'],
                'contra_nota_no_quito_contra_tabla' => ['d'=>''],
                'contra_nota_no_limpio_contra_nota_id' => ['d'=>''],

                'producto_color' => ['d'=>'Trata de checar los links entre producto_bodega vs producto_color vs producto_general_id vs producto_color vs bodega_existencia_diaria'],
                'bodega_existencia_diaria_calculated_fields' => [],
            ];

        echo "<fieldset style='width:fit-content'><legend>Revisa DB Bodega v0.0</legend><ol class='resultados'>";
        foreach($methods as $method => $m) {
            $d = $m['d'] ?? '';
            $ret = $this->$method();
            if(empty($ret)) {
                echo "<li style='color:green'>$ok $method. <i>$d</i></li>";
            } else  {
                echo "<li style='color:red'><details class='default'><summary class='default'><b class='mal'>$mal $method</b>. <i>$d</i></summary><div class='details'>";
                $this->tabler($ret, "$mal $method");
                echo "</div></details>";
            }
        }
        echo "</ol></fieldset>";
    }

    public function tabler($ret, $caption):void {
        $required = ['bodega_id', 'nota_bodega_id', 'producto', 'producto_general_id', 'color_id', 'color'];
        foreach($ret as $k => &$n) {
            if(!empty($n['nota_bodega_id']))
                $n['nota_bodega_id'] = "<a href='/vitex/bodega/edita_movimiento.php?nota_bodega_id=$n[nota_bodega_id]&iah=e' target=_blank>$n[nota_bodega_id]</a>";
            if(!empty($n['contra_nota_bodega_id']))
                $n['contra_nota_bodega_id'] = "<a href='/vitex/bodega/edita_movimiento.php?nota_bodega_id=$n[contra_nota_bodega_id]&iah=e' target=_blank>$n[contra_nota_bodega_id]</a>";
            foreach($required as $r)
                if(empty($n[$r]) && array_key_exists($r, $n) )
                    $n = "<span style='color:red'>❌</span>";
            if(!is_array($n))
                $n = [$n];
            foreach($n as $k => &$v)
                if(strcasecmp($v ?? 'No', 'No') === 0 && (str_ends_with($k, 'activo') || str_ends_with($k, 'activa')))
                    $v = "<span style='color:red'>$v</span>";
        }
        iaTableIt::tableIt($ret, $caption);
    }

    public function inconsistencia_vs_nota_bodega():array {
        $method = __METHOD__;
        $sql =
            "SELECT /*$method*/ 'inconsistencia sin nota bodega o número de nota mal o cancelado' as Es, 
               i.inconsistencia_nota_bodega_id, i.nota_bodega_id, i.numero 'Num nota en inc.', nb.tipo, nb.numero as 'numero en nota_bodega'
            FROM inconsistencia_nota_bodega i
                LEFT OUTER JOIN bodega b ON b.bodega_id = i.bodega_id
                LEFT OUTER JOIN nota_bodega nb on i.nota_bodega_id = nb.nota_bodega_id
            WHERE i.nota_bodega_id <> '' AND ( 
                nb.nota_bodega_id IS NULL OR i.numero <> nb.numero OR nb.tipo='Cancelacion'
            )" . $this->whereBodega;
        $return = ia_sqlArrayIndx($sql);
        if($return === false)
            return ['En'=>__METHOD__, 'Hubo' => 'Sql Error'];
        return $return;
    }

    public function nota_bodega_links():array {
        $method = __METHOD__;
        $sql =
            "SELECT /*$method*/ 'Revisa links/values en Nota Bodega', 
                 nb.nota_bodega_id, nb.fecha, nb.tipo, nb.numero, 
                 b.bodega, b.activo as bodega_activa, 
                 pg.producto, pg.activo as producto_activo, 
                 ob.clave as 'Origen/Destino', ob.activo as origen_activo, nb.entrada_salida,
                 ob.vale_bodega_entrada, ob.vale_bodega_salida
            FROM nota_bodega nb
            LEFT OUTER JOIN bodega b on nb.bodega_id = b.bodega_id
            LEFT OUTER JOIN producto_general pg on nb.producto_general_id = pg.producto_general_id
            LEFT OUTER JOIN origen_bodega ob on nb.origen_id = ob.origen_bodega_id
            LEFT OUTER JOIN cliente cte ON cte.cliente_id = nb.cliente_id OR cte.cliente_id = MID(nb.cliente_id, 2) 
            WHERE b.bodega_id IS NULL OR pg.producto_general_id IS NULL OR ob.origen_bodega_id IS NULL OR
                b.activo = 'No' OR pg.activo = 'No' OR ob.activo='No' OR 
                (nb.entrada_salida = 'Entrada' AND ob.vale_bodega_entrada ='No') OR
                (nb.entrada_salida = 'Salida' AND ob.vale_bodega_salida ='No') 
                $this->whereBodega
            ";
        $return = ia_sqlArrayIndx($sql);
        if($return === false)
            return ['En'=>__METHOD__, 'Hubo' => 'Sql Error'];
        return $return;
    }

    public function nota_bodega_vs_items():array {
        $method = __METHOD__;
        $sql =
            "SELECT /*$method*/ 'La nota no coincide con sus items', nb.nota_bodega_id, nb.numero 
                FROM nota_bodega nb
                    LEFT OUTER JOIN bodega b on nb.bodega_id = b.bodega_id
                WHERE nb.tipo <> 'Cancelacion' AND (
                    total_rolls <> (SELECT SUM(rollos) FROM nota_bodega_items nbi WHERE nbi.nota_bodega_id=nb.nota_bodega_id ) OR
                    total_quantity <> (SELECT SUM(quantity) FROM nota_bodega_items nbi WHERE nbi.nota_bodega_id=nb.nota_bodega_id ) OR
                    num_colores <> (SELECT COUNT(*) FROM nota_bodega_items nbi WHERE nbi.nota_bodega_id=nb.nota_bodega_id ) OR
                    num_colores <> (SELECT COUNT(DISTINCT nbi.color_id) FROM nota_bodega_items nbi WHERE nbi.nota_bodega_id=nb.nota_bodega_id ) OR
                    num_colores = 0
                ) $this->whereBodega
            ";
        $return = ia_sqlArrayIndx($sql);
        if($return === false)
            return ['En'=>__METHOD__, 'Hubo' => 'Sql Error'];
        return $return;
    }

    public function nota_items_links():array {
        $method = __METHOD__;
        $sql =
            "SELECT /*$method*/ 'Revisa links/values',
                 nb.nota_bodega_id, 
                 b.bodega, b.activo as bodega_activa, 
                 pg.producto, pg.activo as producto_activo, 
                 c.color, c.activo as color_activo,
                 pb.producto as producto_bodega_llamado,CONCAT_WS(' ', pg.producto, c.color)
            FROM nota_bodega_items nbi
            LEFT OUTER JOIN nota_bodega nb on nbi.nota_bodega_id = nb.nota_bodega_id
            LEFT OUTER JOIN bodega b on nbi.bodega_id = b.bodega_id
            LEFT OUTER JOIN producto_general pg on MID(nbi.producto_bodega_id, 34, 32) = pg.producto_general_id
            LEFT OUTER JOIN color c on nbi.color_id = c.color_id
            LEFT OUTER JOIN producto_bodega pb on nbi.producto_bodega_id = pb.producto_bodega_id
            WHERE (b.bodega_id IS NULL OR pg.producto_general_id IS NULL OR c.color_id IS NULL OR
                b.activo = 'No' OR pg.activo = 'No' OR c.activo='No') $this->whereBodega
               -- OR pb.producto <> CONCAT_WS(' ', pg.producto, c.color)
            ";
        $return = ia_sqlArrayIndx($sql);
        if($return === false)
            return ['En'=>__METHOD__, 'Hubo' => 'Sql Error'];
        return $return;
    }

    public function nota_bodega_tipo():array {
        $method = __METHOD__;
        $sql = "
            SELECT /*$method*/ 'Tipo en nota bodega' as Es, 
               nb.nota_bodega_id, nb.fecha, b.bodega, nb.numero, nb.entrada_salida, nb.tipo, ob.clave as 'origen/destino', ob.es,
                nb.cliente, nb.remarks
            FROM nota_bodega nb
                LEFT OUTER JOIN origen_bodega ob on nb.origen_id = ob.origen_bodega_id
                LEFT OUTER JOIN bodega b on nb.bodega_id = b.bodega_id
            WHERE nb.tipo <> 'Cancelacion' AND
                (
                    (ob.es = 'CORRECCION' AND nb.tipo <> 'Correccion') OR
                    (ob.es <> 'CORRECCION' AND nb.tipo = 'Correccion') OR
                    (ob.es = 'Tienda' AND nb.tipo NOT IN ('Movimiento', 'Devolucion')) OR
                    ((ob.es = 'Bodega' OR ob.es = 'GRUPO BODEGA' ) AND nb.tipo <> 'traslado') OR
                    (ob.es = 'IMPORTACION' AND nb.tipo NOT IN('Devolucion Fabricante','Container') ) OR 
                    (nb.tipo <> 'traslado' AND nb.cliente LIKE  '%".BODEGAS_PROPIAS_ID."%') OR
                  --   (nb.tipo = 'traslado' AND nb.cliente NOT LIKE  '%".BODEGAS_PROPIAS_ID."%') OR 
                    nb.tipo IS NULL
                )  $this->whereBodega
            ORDER BY 1 DESC, 2, 3";
        $return = ia_sqlArrayIndx($sql);
        if($return === false)
            return ['En'=>__METHOD__, 'Hubo' => 'Sql Error'];
        return $return;
    }

    public function contra_notas_contra_numero(): array {
        $method = __METHOD__;
        $sql = "
        SELECT  /*$method*/ 'El numero de la nota contra_nota_bodega_id no coincide su nota_bodega' as es, 
                contra.contra_nota_bodega_id, contra.numero_nota, nb.numero         
        FROM nota_bodega_contra_nota_bodega contra
        JOIN nota_bodega nb ON nb.nota_bodega_id=contra.contra_nota_bodega_id
        WHERE nb.numero <> contra.numero_nota
        ORDER BY nb.fecha DESC";
        $return = ia_sqlArrayIndx($sql);
        if($return === false)
            return ['En'=>__METHOD__, 'Hubo' => 'Sql Error'];
        return $return;
    }

    public function contra_nota_tabla_vs_contra_nota_bodega_id():array {
        $method = __METHOD__;
        $sql =
            "select /*$method*/ 'contra nota numero_nota vs nota_bodega.contra_nota_bodega_id es num1;num2' as es,nb.fecha,
                contra.nota_bodega_id, contra.numero_nota, nb.contra_nota_bodega_id
            from nota_bodega_contra_nota_bodega contra
            JOIN nota_bodega nb ON nb.nota_bodega_id=contra.nota_bodega_id
            WHERE NOT (
                nb.contra_nota_bodega_id = contra.numero_nota OR
                nb.contra_nota_bodega_id LIKE CONCAT(contra.numero_nota, ';%') OR
                nb.contra_nota_bodega_id LIKE CONCAT('%;', contra.numero_nota, ';%') OR
                nb.contra_nota_bodega_id LIKE CONCAT('%;', contra.numero_nota)
            )
            ORDER BY nb.fecha DESC";
        $return = ia_sqlArrayIndx($sql);
        if($return === false)
            return ['En'=>__METHOD__, 'Hubo' => 'Sql Error'];
        return $return;
    }

    public function contra_notas_tabla(): array {
        $method = __METHOD__;
        $sql = "
        SELECT /*$method*/ 'La nota es su propia contra nota' as 'es', nota_bodega_id, contra_nota_bodega_id, numero_nota
        FROM nota_bodega_contra_nota_bodega
        WHERE nota_bodega_id = contra_nota_bodega_id 
    UNION
        SELECT 'Ambas notas en blanco!' as 'es', nota_bodega_id, contra_nota_bodega_id, numero_nota
        FROM nota_bodega_contra_nota_bodega
        WHERE nota_bodega_id = '' AND contra_nota_bodega_id='' 
    UNION
        SELECT 'NOTA_BODEGA_ID NO existe en nota_bodega' as es, contra.nota_bodega_id, contra.contra_nota_bodega_id, contra.numero_nota
        FROM nota_bodega_contra_nota_bodega contra
        WHERE contra.nota_bodega_id<>'' AND NOT EXISTS
        (   SELECT 1 
            FROM nota_bodega nb
             WHERE nb.nota_bodega_id = contra.nota_bodega_id 
        )
    UNION
        SELECT 'CONTRA_NOTA_BODEGA_ID NO existe en nota_bodega' as es, contra.nota_bodega_id, contra.contra_nota_bodega_id, contra.numero_nota 
        FROM nota_bodega_contra_nota_bodega contra
        WHERE contra.contra_nota_bodega_id <> '' AND NOT EXISTS
        (   SELECT 1 
            FROM nota_bodega nb
             WHERE nb.nota_bodega_id = contra.contra_nota_bodega_id
        )
        ORDER BY 1";
        $return = ia_sqlArrayIndx($sql);
        if($return === false)
            return ['En'=>__METHOD__, 'Hubo' => 'Sql Error'];
        return $return;
    }

    public function contra_nota_no_limpio_contra_nota_id():array {
        $method = __METHOD__;
        $sql =
            "SELECT /*$method*/ 'La nota trasaldo y tiene datos en contra_nota_bodega_id' as es, nb.fecha, nb.nota_bodega_id, nb.numero, nb.tipo, nb.contra_nota_bodega_id
            FROM nota_bodega nb
                LEFT OUTER JOIN bodega b on nb.bodega_id = b.bodega_id
            WHERE nb.tipo <> 'traslado' AND nb.contra_nota_bodega_id<>''  $this->whereBodega
            ORDER BY nb.fecha DESC";
        $return = ia_sqlArrayIndx($sql);
        if($return === false)
            return ['En'=>__METHOD__, 'Hubo' => 'Sql Error'];
        return $return;
    }

    public function contra_nota_no_quito_contra_tabla():array {
        $method = __METHOD__;
        $sql =
            "SELECT /*$method*/ 'No es trasaldo y tiene entrada en nota_bodega_contra_nota_bodega' as es, nb.fecha, nb.nota_bodega_id, nb.numero, nb.tipo,
       contra.numero_nota as 'contra.numero_nota',
       contra.nota_bodega_id as 'contra.nota_bodega_id',
       contra.contra_nota_bodega_id
FROM nota_bodega nb
JOIN nota_bodega_contra_nota_bodega contra on
    nb.nota_bodega_id = contra.contra_nota_bodega_id OR
    nb.nota_bodega_id = contra.nota_bodega_id
WHERE nb.tipo <> 'traslado'
ORDER BY nb.fecha DESC";
        $return = ia_sqlArrayIndx($sql);
        if($return === false)
            return ['En'=>__METHOD__, 'Hubo' => 'Sql Error'];
        return $return;
    }

    public function nota_bodega_quantityRolloAverage():array {
        $method = __METHOD__;
        $sql = <<< SQL
            SELECT /*$method*/ 'Average Qty/rolls' as Es, b.bodega, nb.numero, nb.entrada_salida, nb.tipo, 
                             pg.producto, c.color,pg.min_por_rollo, 
                nbi.quantity/nbi.rollos as 'Avg', pg.max_por_rollo ,nbi.rollos, nbi.quantity
            FROM nota_bodega nb
                JOIN producto_general pg on nb.producto_general_id = pg.producto_general_id
                JOIN nota_bodega_items nbi ON nb.nota_bodega_id = nbi.nota_bodega_id
                JOIN color c on nbi.color_id = c.color_id
                JOIN bodega b on nb.bodega_id = b.bodega_id
            WHERE nb.tipo<>'Cancelacion' AND nbi.quantity>0 AND nbi.rollos >0
                  AND pg.min_por_rollo>0 AND pg.min_por_rollo IS NOT NULL
                  AND pg.max_por_rollo>0 AND pg.max_por_rollo IS NOT NULL
                  AND pg.max_por_rollo >= pg.min_por_rollo
                    AND nbi.quantity/nbi.rollos NOT BETWEEN pg.min_por_rollo AND pg.max_por_rollo            
           ORDER BY 2,3,4 
        
SQL;
        $return = ia_sqlArrayIndx($sql);
        if($return === false)
            return ['En'=>__METHOD__, 'Hubo' => 'Sql Error'];
        return $return;
    }

    public function producto_bodega_quantityRolloAverage():array {
        $method = __METHOD__;
        $sql = <<< SQL
            select /*$method*/ 'Average Qty/rolls' as Es, b.bodega, pg.producto, c.color,pg.min_por_rollo, pb.existencia_quantity/pb.existencia_rollos as 'Avg', pg.max_por_rollo
            ,pb.existencia_rollos as rollos, pb.existencia_quantity as quantity
                from producto_bodega pb
                    JOIN producto_general pg on pb.producto_general_id = pg.producto_general_id
                    JOIN color c on pb.color_id = c.color_id
                    JOIN bodega b on pb.bodega_id = b.bodega_id
                WHERE pb.existencia_quantity>0 AND pb.existencia_rollos >0
                  AND pg.min_por_rollo>0 AND pg.min_por_rollo IS NOT NULL
                  AND pg.max_por_rollo>0 AND pg.max_por_rollo IS NOT NULL
                  AND pg.max_por_rollo >= pg.min_por_rollo
                    AND pb.existencia_quantity/pb.existencia_rollos NOT BETWEEN pg.min_por_rollo AND pg.max_por_rollo
            ORDER BY 2,3,4
SQL;
        $return = ia_sqlArrayIndx($sql);
        if($return === false)
            return ['En'=>__METHOD__, 'Hubo' => 'Sql Error'];
        return $return;
    }

    public function producto_color():array {
        $method = __METHOD__;
        $sql = <<< SQL
            SELECT /*$method*/ 'Error: en producto_bodega pero no en producto_color' as Es, pg.producto, c.color, pg.producto_general_id, c.color_id
            FROM producto_bodega pb
                LEFT OUTER JOIN color c ON c.color_id=pb.color_id
                LEFT OUTER JOIN producto_general pg ON pg.producto_general_id=pb.producto_general_id
            WHERE NOT EXISTS (SELECT 1 FROM producto_color pc WHERE pc.activo='Si' AND pb.producto_general_id = pc.producto_general_id AND pb.color_id=pc.color_id)
        UNION
            SELECT 'Error: en producto_bodega pero no en producto_general' as es, pb.producto as producto , '' as color, pb.producto_general_id, pb.color_id
            FROM producto_bodega pb
            WHERE NOT EXISTS (SELECT 1 FROM producto_general pg WHERE pb.producto_general_id = pg.producto_general_id)
        UNION
            SELECT 'Error: en producto_bodega pero no encolor' as es,  pb.producto as producto , '' as color, pb.producto_general_id, pb.color_id
            FROM producto_bodega pb
            WHERE NOT EXISTS (SELECT 1 FROM color c WHERE pb.color_id = c.color_id)
        UNION
            SELECT 'Error: en producto_color pero no en producto_general' as es,  pb.producto as producto , '' as color, pb.producto_general_id, pb.color_id
            FROM producto_color pb
            WHERE NOT EXISTS (SELECT 1 FROM producto_general pg WHERE pb.producto_general_id = pg.producto_general_id)
        UNION
            SELECT 'Error: en producto_color pero no en color' as es,  '' as producto, '' as color, pb.producto_general_id, pb.color_id
            FROM producto_color pb
            WHERE NOT EXISTS (SELECT 1 FROM color c WHERE pb.color_id = c.color_id)
        UNION
            SELECT 'Error: en producto_bodega pero no  en existencia diaria' as es,  pb.producto as producto, '' as color, pb.producto_general_id, pb.color_id
            FROM producto_bodega pb
            WHERE NOT EXISTS (
                SELECT 1 
                FROM bodega_existencia_diaria bed 
                WHERE bed.bodega_id=pb.bodega_id AND bed.producto_general_id=pb.producto_general_id AND bed.color_id=pb.color_id
                )
/*            
        UNION
            SELECT 'Revisar: Producto activo y para_bodega='En Bodega' pero no hay en bodegas' as es, pg.producto, '' as color, pg.producto_general_id, '' as color_id
            FROM producto_general pg
            WHERE pg.activo='Si' AND pg.para_bodega='En Bodega' AND
                  NOT EXISTS (SELECT 1 FROM producto_bodega pb WHERE pb.producto_general_id=pg.producto_general_id)
*/            
        ORDER BY 1, 2, 3
SQL;

        $return = ia_sqlArrayIndx($sql);
        if($return === false)
            return ['En'=>__METHOD__, 'Hubo' => 'Sql Error'];
        return $return;
    }

    public function bodega_existencia_diaria_calculated_fields():array {
        $method = __METHOD__;
        $sql =
            "SELECT /*$method*/ 'incial +/- movimientos registrados rollos/quantity no da final' as Es, bed.fecha, b.bodega, pg.producto, c.color, bed.bodega_existencia_diaria_id
                FROM bodega_existencia_diaria bed
                     JOIN bodega b ON bed.bodega_id=b.bodega_id
                    JOIN producto_general pg on bed.producto_general_id = pg.producto_general_id
                    JOIN color c on bed.color_id = c.color_id
            WHERE
               ( bed.existencia_rollos <> existencia_rollos_inicial + bed.entrada_rollos - bed.salida_rollos OR
                bed.existencia_quantity <> existencia_quantity_inicial + bed.entrada_quantity - bed.salida_quantity)
               $this->whereBodega
        UNION
            SELECT 'Suma Salidas Quantity/Rollos Mal' as Es, bed.fecha, b.bodega, pg.producto, c.color, bed.bodega_existencia_diaria_id
            FROM bodega_existencia_diaria bed
                     JOIN bodega b ON bed.bodega_id=b.bodega_id
                     JOIN producto_general pg on bed.producto_general_id = pg.producto_general_id
                     JOIN color c on bed.color_id = c.color_id
            WHERE (salida_quantity<>
                  salida_venta_quantity +
                  salida_correccion_quantity +
                  salida_rechazado_quantity +
                  salida_traslado_quantity +
                  salida_traspaso_quantity
            OR
                    salida_rollos <>
                    salida_venta_rollos +
                    salida_correccion_rollos +
                    salida_rechazado_rollos +
                    salida_traslado_rollos +
                    salida_traspaso_rollos) $this->whereBodega
        UNION
            SELECT 'Suma Entradas Quantity/Rollos Mal' as Es, bed.fecha, b.bodega, pg.producto, c.color, bed.bodega_existencia_diaria_id
            FROM bodega_existencia_diaria bed
                     JOIN bodega b ON bed.bodega_id=b.bodega_id
                     JOIN producto_general pg on bed.producto_general_id = pg.producto_general_id
                     JOIN color c on bed.color_id = c.color_id
            WHERE (entrada_quantity <>
                  entrada_devolucion_quantity +
                  entrada_correccion_quantity +
                  bed.entrada_compra_quantity +
                  entrada_traslado_quantity +
                  entrada_traspaso_quantity
                OR  entrada_rollos <>
                    entrada_devolucion_rollos +
                    entrada_correccion_rollos +
                    entrada_compra_rollos +
                    entrada_traslado_rollos +
                    entrada_traspaso_rollos) $this->whereBodega
       ";
        $return = ia_sqlArrayIndx($sql);
        if($return === false)
            return ['En'=>__METHOD__, 'Hubo' => 'Sql Error'];
        return $return;
    }

}
