<?php

namespace Vitex\Tester;


use Error;
use ReflectionClass;
use ReflectionException;
use ReflectionFunction;
use ReflectionMethod;

class Finder {
    const EXTENDS_AJAX_HELPER = '/class\s+([a-z0-9\_]+)\s+extends\s+AjaxHelper/miUS';

    /**
     * @param string $sourcePath
     * @param string $testPath
     * @param string $processIfRegExpMatches
     * @return int
     * @throws ReflectionException
     */
    public function makeTests(string $sourcePath, string $testPath, string $processIfRegExpMatches = ''):int {
        if(!file_exists($sourcePath))
            throw new Error("$sourcePath NOT FOUND");
        if(!is_readable($sourcePath))
            throw new Error("$sourcePath NOT READABLE");
        if(!is_dir($sourcePath))
            return str_ends_with($sourcePath, '.php') ? 
                $this->processFile($sourcePath, $processIfRegExpMatches) : 
                0;
        $ok = 0;
        $files = 0; 
        foreach(scandir($sourcePath) as $fileName) {
            if(!str_ends_with($fileName, '.php'))
                continue;
            $files++;
            if($this->processFile($sourcePath.$fileName, $processIfRegExpMatches))
                $ok++;
        }
        return $ok;
    }

    /**
     * @throws ReflectionException
     */
    protected function processFile(string $filePath, string $processIfRegExpMatches):int {
        $testPath = '';
        if(
            file_exists("$testPath" . "Test.php")  ||
            file_exists("$testPath" ."Tempale.php")
        )
            return 0;

        $sourceArray = file($filePath);
        if(empty($sourceArray))
            return 0;
        $sourceString = implode("", $sourceArray);
        if(!empty($processIfRegExpMatches) &&
            preg_match($processIfRegExpMatches, $sourceString, $matches,PREG_SET_ORDER) === 0
        )
            return 0;
        $testCode = [];
        $matches = [];
        if(preg_match($processIfRegExpMatches, $sourceString, $matches,PREG_SET_ORDER)) {
            foreach($matches as $m) {
                $className = $m[1];
                $class = new ReflectionClass($className);
                foreach($class->getMethods() as $method) {
                    if($method->class !== $className || !$method->isPublic() ||
                        $method->isConstructor() || $method->isDestructor()

                    )
                        continue;
                   $testCode[] = $this->processFunction($className, $method, $sourceArray);
                }
            }
        }
        // find functions not inside class and same setting

        return 1;
    }

    protected function processFunction(string $className, ReflectionMethod|ReflectionFunction $func, array $sourceArray):string {
        $code = implode("",
            array_slice(
                $sourceArray,
                $func->getStartLine() - 1,
                $func->getEndLine() - $func->getStartLine() +1
            )
        );
        $params = [];
        foreach($func->getParameters() as $p) {
            $params["\$$p->name"] =
                ($p->hasType() ? $p->getType()->getName() : ' mixed ') .
                "\$$p->name " .
                ($p->isDefaultValueAvailable() ? " (" . $p->getDefaultValue() .')' : '');
        }
        $arguments = array_combine(array_keys($params), array_keys($params));
        $superGlobalsSet = "";
        $superGlobalUsage = $this->superGlobalUsage($code);
        foreach($superGlobalUsage as $super) {
            $arguments[$super[1]] = " string \$$super[1] de $super[0]";
            $superGlobalsSet = "\r\n\t\t\t\$$super[1] = $super[0] ?? '';";
        }
        // falta param(/helper
        $paramNames = implode(", ", array_keys($arguments));



        $returnType = $func->hasReturnType() ? $func->getReturnType()->getName() : '';
        if($returnType === 'void')
            $returnType = '';
        $prepare = '';
        if(empty($className))
            $call = $func->getName()."($paramNames)";
        else {
            if($func->isStatic())
                $call = "$className::" . $func->getName()."($paramNames)";
            else {
                $prepare = "\$className = new $className();";
                $call = "\$className->" . $func->getName()."($paramNames)";
            }
        }
        switch($returnType) {
            case 'bool':
            case 'true': $assert = "assertTrue($call);";
            case 'false' : $assert = "assertFalse($call);";
            default: $assert = "assertEquals($call);";
        }
        if(empty($arguments)) {
            $provider = $paramsComent = $testFunctionArguments = '';
        } else {
            $provider = "@dataProvider provider_$func->name()";
            $paramsComent = "@param \$expected\r\n\t\t* @param " . implode("\r\n\t\t* @param ", $params);
            $testFunctionArguments = "$returnType \$expected, $paramNames";
        }

        $testFunction = <<< TESTERCODE
        /**
         * @covers $className::$func->name
         *
         *
         * $provider;
         *
         * $paramsComent
         */
        public function test_$func->name($testFunctionArguments) {
$superGlobalsSet
            $prepare
            $assert
        }
TESTERCODE;

        if(!empty($arguments)) {
            $template = str_repeat(",''", count($arguments));
            $dataProviderFunciton =
            "public function provider_$func->name():array {
                // $returnType \$expected, $paramNames
                return [
                   'TestName' => ['expected' $template],
                ];
             }       
            ";
        } else
            $dataProviderFunciton = '';

        return "\r\n$testFunction\r\n\r\n$dataProviderFunciton\r\n";
    }

    /**
     * Get usages of $_REQUEST, $_POST, $_GET, $_SESSION, $_SERVER
     *
     * @param string $code
     * @return array  [ [ $_REQUEST['gato'], 'REQUEST', 'gato'], ...]
     */
    protected function superGlobalUsage(string $code) {
        $regExp = '/\$_(POST|REQUEST|GET|SESSION|SERVER)\s*\[\s*[\'"](.*)[\'"]\s*]\s*[,;)]/miUS';
        preg_match_all($regExp, $code, $matches, PREG_SET_ORDER, 0);
        return $matches;
    }

}