<?php


class xlsxStyle {
    // defaults
    protected $fontName;
    protected $fontSize;
    protected $fontFamily;
    protected $fontScheme;
    protected $vAlignment;
    protected $wrapText;
    // cosntants
    protected $indexId = "_\tindxId"; //

    // internal data
    protected $numFmts = array();
    protected $color = array();
    protected $font = array();
    protected $fill = array();
    protected $border = array();
    public $cellXf = array();
    protected $cellStyle = array(''=>array('xfId' => "0", 'builtinId' => "0", 'name'=>"Normal", "_\tindxId"=>0));
    protected $css = array();

    protected $namedColors = array(
    //special cases revert to white
    'inherit'=>'FFFFFF',
    'unset'=>'FFFFFF',
    'revert'=>'FFFFFF',
    'initial'=>'FFFFFF',
    'current'=>'FFFFFF',

        'aliceblue' => 'F0F8FF',
        'antiquewhite' => 'FAEBD7',
        'aqua' => '00FFFF',
        'aquamarine' => '7FFFD4',
        'azure' => 'F0FFFF',
        'beige' => 'F5F5DC',
        'bisque' => 'FFE4C4',
        'black' => '000000',
        'blanchedalmond' => 'FFEBCD',
        'blue' => '0000FF',
        'blueviolet' => '8A2BE2',
        'brown' => 'A52A2A',
        'burlywood' => 'DEB887',
        'cadetblue' => '5F9EA0',
        'chartreuse' => '7FFF00',
        'chocolate' => 'D2691E',
        'coral' => 'FF7F50',
        'cornflowerblue' => '6495ED',
        'cornsilk' => 'FFF8DC',
        'crimson' => 'DC143C',
        'cyan' => '00FFFF',
        'darkblue' => '00008B',
        'darkcyan' => '008B8B',
        'darkgoldenrod' => 'B8860B',
        'darkgray' => 'A9A9A9',
        'darkgrey' => 'A9A9A9',
        'darkgreen' => '006400',
        'darkkhaki' => 'BDB76B',
        'darkmagenta' => '8B008B',
        'darkolivegreen' => '556B2F',
        'darkorange' => 'FF8C00',
        'darkorchid' => '9932CC',
        'darkred' => '8B0000',
        'darksalmon' => 'E9967A',
        'darkseagreen' => '8FBC8F',
        'darkslateblue' => '483D8B',
        'darkslategray' => '2F4F4F',
        'darkslategrey' => '2F4F4F',
        'darkturquoise' => '00CED1',
        'darkviolet' => '9400D3',
        'deeppink' => 'FF1493',
        'deepskyblue' => '00BFFF',
        'dimgray' => '696969',
        'dimgrey' => '696969',
        'dodgerblue' => '1E90FF',
        'firebrick' => 'B22222',
        'floralwhite' => 'FFFAF0',
        'forestgreen' => '228B22',
        'fuchsia' => 'FF00FF',
        'gainsboro' => 'DCDCDC',
        'ghostwhite' => 'F8F8FF',
        'gold' => 'FFD700',
        'goldenrod' => 'DAA520',
        'gray' => '808080',
        'grey' => '808080',
        'green' => '008000',
        'greenyellow' => 'ADFF2F',
        'honeydew' => 'F0FFF0',
        'hotpink' => 'FF69B4',
        'indianred ' => 'CD5C5C',
        'indigo ' => '4B0082',
        'ivory' => 'FFFFF0',
        'khaki' => 'F0E68C',
        'lavender' => 'E6E6FA',
        'lavenderblush' => 'FFF0F5',
        'lawngreen' => '7CFC00',
        'lemonchiffon' => 'FFFACD',
        'lightblue' => 'ADD8E6',
        'lightcoral' => 'F08080',
        'lightcyan' => 'E0FFFF',
        'lightgoldenrodyellow' => 'FAFAD2',
        'lightgray' => 'D3D3D3',
        'lightgrey' => 'D3D3D3',
        'lightgreen' => '90EE90',
        'lightpink' => 'FFB6C1',
        'lightsalmon' => 'FFA07A',
        'lightseagreen' => '20B2AA',
        'lightskyblue' => '87CEFA',
        'lightslategray' => '778899',
        'lightslategrey' => '778899',
        'lightsteelblue' => 'B0C4DE',
        'lightyellow' => 'FFFFE0',
        'lime' => '00FF00',
        'limegreen' => '32CD32',
        'linen' => 'FAF0E6',
        'magenta' => 'FF00FF',
        'maroon' => '800000',
        'mediumaquamarine' => '66CDAA',
        'mediumblue' => '0000CD',
        'mediumorchid' => 'BA55D3',
        'mediumpurple' => '9370D8',
        'mediumseagreen' => '3CB371',
        'mediumslateblue' => '7B68EE',
        'mediumspringgreen' => '00FA9A',
        'mediumturquoise' => '48D1CC',
        'mediumvioletred' => 'C71585',
        'midnightblue' => '191970',
        'mintcream' => 'F5FFFA',
        'mistyrose' => 'FFE4E1',
        'moccasin' => 'FFE4B5',
        'navajowhite' => 'FFDEAD',
        'navy' => '000080',
        'oldlace' => 'FDF5E6',
        'olive' => '808000',
        'olivedrab' => '6B8E23',
        'orange' => 'FFA500',
        'orangered' => 'FF4500',
        'orchid' => 'DA70D6',
        'palegoldenrod' => 'EEE8AA',
        'palegreen' => '98FB98',
        'paleturquoise' => 'AFEEEE',
        'palevioletred' => 'D87093',
        'papayawhip' => 'FFEFD5',
        'peachpuff' => 'FFDAB9',
        'peru' => 'CD853F',
        'pink' => 'FFC0CB',
        'plum' => 'DDA0DD',
        'powderblue' => 'B0E0E6',
        'purple' => '800080',
        'red' => 'FF0000',
        'rosybrown' => 'BC8F8F',
        'royalblue' => '4169E1',
        'saddlebrown' => '8B4513',
        'salmon' => 'FA8072',
        'sandybrown' => 'F4A460',
        'seagreen' => '2E8B57',
        'seashell' => 'FFF5EE',
        'sienna' => 'A0522D',
        'silver' => 'C0C0C0',
        'skyblue' => '87CEEB',
        'slateblue' => '6A5ACD',
        'slategray' => '708090',
        'slategrey' => '708090',
        'snow' => 'FFFAFA',
        'springgreen' => '00FF7F',
        'steelblue' => '4682B4',
        'tan' => 'D2B48C',
        'teal' => '008080',
        'thistle' => 'D8BFD8',
        'tomato' => 'FF6347',
        'turquoise' => '40E0D0',
        'violet' => 'EE82EE',
        'wheat' => 'F5DEB3',
        'white' => 'FFFFFF',
        'whitesmoke' => 'F5F5F5',
        'yellow' => 'FFFF00',
        'yellowgreen' => '9ACD32',

    );

    public function __construct($fontName='Calibri', $fontSize=11, $fontFamily=2, $fontScheme='minor', $vAlignment='center') {
//        $this->numberFormatAdd('currency', '$$#,##0.00;[Red]$$-#,##0.00;');
//        $this->numberFormatAdd('currency', '$$#,##0.00;[Red]$$-#,##0.00;$$0.00');
//
//        $this->numberFormatAdd('num2 0blank', '#,##0.00;[Red]-#,##0.00;');
//        $this->numberFormatAdd('num2 nored', '#,##0.00;-#,##0.00;0.00');
//        $this->numberFormatAdd('num2 nored 0blank', '#,##0.00;-#,##0.00;');
//
//        $this->numberFormatAdd('num6', '#,##0.000000;[Red]-#,##0.000000;0.000000');
//        $this->numberFormatAdd('num8', '#,##0.00000000;[Red]-#,##0.00000000;0.00000000');
//
//        $this->numberFormatAdd('int', '#,##0;[Red]-#,##0;0');
//        $this->numberFormatAdd('int 0blank', '#,##0;[Red]-#,##0;');
//        $this->numberFormatAdd('int nored', '#,##0;-#,##0;0');
//        $this->numberFormatAdd('int nored 0blank', '#,##0;-#,##0;');
//
//
//        $this->numberFormatAdd('dmy', 'dd/mmm/yy;@');
//        $this->numberFormatAdd('dmy hm', 'dd/mmm/yy; h:mm;@');
//        $this->numberFormatAdd('dmy hms', 'dd/mmm/yy; h:mm:ss;@');
//
//        $this->numberFormatAdd('ymd', 'yyyy-mm-dd;@');
//        $this->numberFormatAdd('ymd hm', 'yyyy-mm-dd h:mm;@'); // dd/mmm/yy h:mm;@
//        $this->numberFormatAdd('ymd hms', 'yyyy-mm-dd h:mm:ss;@');


        $this->fontName = $fontName;
        $this->fontSize = $fontSize;
        $this->fontFamily = $fontFamily;
        $this->fontScheme = $fontScheme;
        $this->fontAdd(null,$fontName,$fontSize);
//        $this->fontAdd('larger',$fontName,$fontSize+2);
//        $this->fontAdd('smaller',$fontName,$fontSize-1);
//        $this->fontAdd('header',$fontName,$fontSize+2,true);
//        $this->fontAdd('bold',$fontName,$fontSize,true);
//        $this->fontAdd('italic',$fontName,$fontSize,false,true);
//        $this->fontAdd('bold italic',$fontName,$fontSize,true,true);

        
        $this->vAlignment = $vAlignment; // top center

        $this->fillAdd('none','none');
        $this->fillAdd('gray125','gray125');
//        $this->fillAdd('red','solid',"FF0000");

        $this->borderAdd('default',array());
//        $this->borderAdd('top double', array('top'=>array('style'=>'double',  'color'=>array('auto'=>1) ) ) );



        $this->cellXfAdd('normal','0','0','0','0',null, $vAlignment, 0, true);
//       $this->cellXfAdd('normal1');
//       $this->setStyle("#,##0");
//       $this->cellXfAdd('vcentered',0,0,0,0,null,'center');   
//       $this->cellXfAdd('centered',0,0,0,0,'center','center');
        foreach($this->numFmts as $k=>$v)
           $this->setStyle($k);


//       $this->setStyle('int',18,'FF9192',true,null,null,null,'F98F98','F2F2F2','solid',null,null,'center');
//       $this->setStyle('int',18,'FF9192',true,true,null,null,'#F9A','#EA',     'solid',null,null,'center');
    }

///////////////////////
/// set css to xlsx style
//////////////////////
    public function cssAddString($css) {
        $this->breakCSS($css);
    }

    public function cssAddCssFile($fileName) {
        $this->breakCSS(file_get_contents($fileName));
    }

    public function css_get() {
        return $this->css;
    }

    public function css_clear() {
        $this->css = array();
    }

    protected function breakCSS($css) {
        $css = str_replace(array("\r","\n","!important"),array(" "," ",""),$css);
        $css = preg_replace("/\s+/muU", " ", $css);
        $css = preg_replace("~/\*[\s\S]*\*/~muU", "", $css);
        preg_match_all('/([^\{\}]+)\s*\{\s*([^}]+)\s*}/muU', $css, $matches);
        foreach($matches[0] AS $i=>$original) {
            $classes = explode(",", $matches[1][$i]);
            foreach($classes as $c) {
                $class = trim($c);
                foreach(explode(';', $matches[2][$i]) AS $attr)
                    if(strlen(trim($attr)) > 0 && stripos($attr,":")!==FALSE) {
                        list($name, $value) = explode(':', $attr);
                        $this->css[$class][trim(strtolower($name))] = trim($value);
                    }
            }
        }
    }

    public function classToStyle($classes,$numberFormat=0, $forceFontSize = null) {
        if(isset($this->cellXf["$classes.$numberFormat"]) && $forceFontSize === null)
            return $this->cellXf["$classes.$numberFormat"][$this->indexId];

        if(is_numeric($numberFormat))
            $numFmt = $numberFormat;
        elseif(isset($this->numFmts[$numberFormat]))
            $numFmt = $this->numFmts[$numberFormat][$this->indexId];
        else
            $numFmt = $this->numberFormatAdd($numberFormat,$numberFormat);

        if(isset($this->css[$classes]))
            $class = $this->css[$classes];
        elseif(isset($this->css[".".$classes]))
            $class = $this->css[".".$classes];
        else {
            $class = array();
            $classArray = explode(' ',$classes);
            foreach($classArray as $c) {
                if(isset($this->css[$c]))
                    $class = array_merge($class, $this->css[$c]);
                elseif(isset($this->css[".".$c]))
                    $class = array_merge($class, $this->css[".".$c]);
            }

        }
        $fillId = null;
        if(isset($class['background-color'])) {
            $fillId = $this->fillAdd($class['background-color'].'solid', 'solid', $class['background-color'],64);
        } elseif(isset($class['background'])) {
            $tmp = explode(" ",trim($class['background']));
            if(!empty($tmp[0])) {
                $fillId = $this->fillAdd($tmp[0].'solid', 'solid', $tmp[0],64);
            }
        }

        $fgColor = isset($class['color']) ? $class['color'] : null;

        $bold = false;
        if(isset($class['font-weight'])) {
            $fontWeight = trim(strtolower($class['font-weight']));
            if($fontWeight === 'bold' || $fontWeight === 'bolder' || (is_number($fontWeight) && $fontWeight >= 400 ))
                $bold = true;
        }

        $italic = false;
        if(isset($class['font-style'])) {
            $fontStyle = trim(strtolower($class['font-style']));
            if($fontStyle === 'italic' || $fontStyle === 'oblique' )
                $italic = true;
        }

        $underline = 0;
        $strike = false;
        if(isset($class['text-decoration'])) {
            $textDecoration = trim(strtolower($class['text-decoration']));
            if( strpos($textDecoration,'line-through') !== false)
                $strike = true;
            if( strpos($textDecoration,'underline') !== false)
                $underline = 1;
            if( strpos($textDecoration,'double') !== false)
                $underline = 2;
        }

        $fontSize = null;
        if($forceFontSize !== null) {
            $fontSize = $forceFontSize;
        } elseif(isset($class['font-size'])) {
            $size = trim(strtolower($class['font-size']));
            if(strpos($size,'px')) {
                $fontSize = str_replace('px','',$size);
            } elseif(strpos($size,'em')) {
               $fontSize = str_replace('em','',$size) * $this->cssBaseFontSize();
            } elseif(strpos($size,'%')) {
                $fontSize = str_replace('%','',$size)/100.00 * $this->cssBaseFontSize();
            } elseif($size==='smaller') {
                $fontSize = $this->cssBaseFontSize() - 2;
            } elseif($size==='small') {
                $fontSize = $this->cssBaseFontSize() - 1;
            } elseif($size==='x-small') {
                $fontSize = $this->cssBaseFontSize() - 3;
            } elseif($size==='xx-small') {
                $fontSize = $this->cssBaseFontSize() - 4;
            } elseif($size==='larger') {
                $fontSize = $this->cssBaseFontSize() + 2;
            } elseif($size==='large') {
                $fontSize = $this->cssBaseFontSize() + 1;
            } elseif($size==='x-large') {
                $fontSize = $this->cssBaseFontSize() + 3;
            } elseif($size==='xx-large') {
                $fontSize = $this->cssBaseFontSize() + 4;
            }
            if(!is_numeric($fontSize))
                $fontSize = null;
            elseif($fontSize < 4)
                $fontSize = 4;
        }

        $fontName = null;
        if(isset($class['font-family'])) {
            $font = str_getcsv($class['font-family'],',','"');
            if(count($font)>0)
                $fontName = $font[0];
        }
        if($fontName!==null || $fontSize!==null || $fgColor!==null || $bold!==false || $italic!==false || $underline!==0 || $strike!==false) {
            $fontId = $this->fontAdd(null,$fontName,$fontSize,$bold,$italic,$underline,$strike,$fgColor);
        } else
            $fontId = null;

       if(isset($class['text-align'])) {
            $hAligment = $class['text-align'];
            if($hAligment!=='left' && $hAligment!=='center' && $hAligment!=='right' )
                $hAligment = null;
       } else
            $hAligment = null;
       if($forceFontSize === null)
            return $this->cellXfAdd("$classes.$numberFormat", $numFmt, 0, $fillId, $fontId, $hAligment);
       else
            return $this->cellXfAdd("$classes.$numberFormat.$fontSize", $numFmt, 0, $fillId, $fontId, $hAligment);
    }

    protected function cssBaseFontSize() {
        foreach(array('body','BODY','html','HTML') as $e)
            if(isset($this->css[$e]) && isset($this->css[$e]['font-size']) && strpos($this->css[$e]['font-size'],'px')  ) {
                $base = str_replace('px','',$this->css[$e]['font-size']);
                if(is_numeric($base))
                    return $base;
            }
        return $this->fontSize;
    }

///////////////////////
/// set xlsx style
//////////////////////
    public function setStyle($numberFormat,
        $fontSize=null, $fgColor=null, $bold=null, $italic=null, $underline=null, $strike=null,
        $fillFgColor=null, $fillBgColor=null, $patternType=null,
        $borderNick=null,
        $hAlignment='center', $vAlignment='top', $wrapText=true
        )
    {
        if(empty($hAlignment)) $hAlignment = 'center';
        if(empty($vAlignment)) $vAlignment = 'center';
        
        if(!empty($numberFormat)) {
            if(isset($this->numFmts[$numberFormat]))
                $numFmtId = $this->numFmts[$numberFormat]['numFmtId'];
            elseif(is_numeric($numberFormat) && $numberFormat>=0 && $this->numberFormatBynumFmtId($numberFormat)) {
                $numFmtId = $numberFormat;
            } else {
                $numFmtId = $this->numberFormatAdd($numberFormat,$numberFormat);
            }
        } else
            $numFmtId = 0;

        $fontId = 0;
        if($fontSize!==null || $fgColor!==null || $bold!==null || $italic!==null || $underline!==null || $strike!==null) {
            $fontId = $this->fontAdd(null,null,$fontSize,$bold,$italic,$underline,$strike,$fgColor);
        }

        $fillId = 0;
        if($fillFgColor!==null || $fillBgColor!==null || $patternType!==null) {
            $nick = ($fillFgColor ? $fillFgColor : '') . '-' . ($fillBgColor ? $fillBgColor : '') . '-' . ($patternType ? $patternType : '');
            $fillId = $this->fillAdd($nick, $patternType, $fillFgColor, $fillBgColor);
        }

        $borderId = 0;
        if(!empty($borderNick)) {
            $borderId = $this->borderToIndex($borderNick);
            if($borderId===0 && is_numeric($borderNick) && $borderNick!=0 && $borderNick < count($this->border) )
                $borderId = $borderNick;
        }
        $nick = "numFmt:$numFmtId-fontId:$fontId-fillId:$fillId-borderId:$borderId-hAlign:".($hAlignment ? $hAlignment : '').'-vAlign:'.($vAlignment ? $vAlignment : '');
        return $this->cellXfAdd($nick, $numFmtId, $borderId, $fillId, $fontId, $hAlignment, $vAlignment, '0', $wrapText);
    }


///////////////////////
/// cellXfs
//////////////////////
    protected function cellXfAdd($nick, $numFmtId=0, $borderId=0, $fillId=0, $fontId=0, $hAlignment='center', $vAlignment='center', $xfId=0, $wrapText=false ) {
        if(isset($this->cellXf[$nick]))
            return $this->cellXf[$nick][$this->indexId];

        if(empty($numFmtId))
            $numFmtId = 0;
        elseif(!is_numeric($numFmtId))
            $numFmtId = $this->numberFormatToIndex($numFmtId);

        if(empty($borderId))
            $borderId = 0;
        elseif(!is_numeric($borderId))
            $borderId = $this->borderToIndex($borderId);

        if(empty($fillId))
            $fillId = 0;
        elseif(!is_numeric($fillId))
            $fillId =  $this->fillToIndex($fillId);

        if(empty($fontId))
            $fontId = 0;
        elseif(!is_numeric($fontId))
            $fontId =  $this->fillToIndex($fontId);

        $id = count($this->cellXf);
        $cellXf = array('numFmtId'=>$numFmtId, 'borderId'=>$borderId, 'fillId'=>$fillId, 'fontId'=>$fontId, 'xfId'=>$xfId);

        if(empty($hAlignment)) $hAlignment = 'center';
        if(empty($vAlignment)) $vAlignment = 'center';

        if(!empty($hAlignment) || !empty($vAlignment)) {
            $cellXf['applyAlignment'] = 1;
            $cellXf['alignment'] = array();
            if(!empty($hAlignment))
                $cellXf['alignment']['horizontal'] = $hAlignment;
            if(!empty($vAlignment))
                $cellXf['alignment']['vertical'] = $vAlignment;
            if($wrapText)
                $cellXf['alignment']['wrapText'] = 'true';
        }

        if($numFmtId>0)
            $cellXf['applyNumberFormat']=1;

        if($borderId>0)
            $cellXf['applyBorder']=1;
        if($fillId>0)
            $cellXf['applyFill']=1;
        if($fontId>0)
            $cellXf['applyFont']=1;

        $cellXf[$this->indexId] = count($this->cellXf);
        $this->cellXf[$nick] = $cellXf;
        return $cellXf[$this->indexId];
    }

///////////////////////
/// Number Formats
//////////////////////
    public function numberFormatAdd($nick, $numberFormat) {
        if(!isset($this->numFmts[$nick])) {
            $id = count($this->numFmts) + 164;
            $this->numFmts[$nick] = array('formatCode'=>$numberFormat,$this->indexId=>$id, 'numFmtId'=>$id );
            return $id;
        }
        $this->numFmts[$nick]['formatCode'] = $numberFormat;
        return $this->numFmts[$nick][$this->indexId];
    }

    public function numberFormatToIndex($nick) {
        if(isset($this->numFmts[$nick]))
            return $this->numFmts[$nick][$this->indexId];
        return 0;
    }

    protected function numberFormatBynumFmtId($numFmtId) {
        foreach($this->numFmts as $nick => $f)
            if($f['numFmtId']===$numFmtId)
                return true;
        return false;
    }

///////////////////////
/// fonts
//////////////////////
    /**
     * xlsxStyle::fontAdd()
     *
     * @param string $nick
     * @param string $fontName defaults to contstructor's font name
     * @param string $fontSize defaults to contstructor's font size
     * @param bool $bold
     * @param bool $italic
     * @param int $underline false, true or 1: single underline, 'double'
     * @param string $color
     * @param bool $strike
     * @param int $family
     * @param string $scheme
     * @return
     */
    public function fontAdd($nick, $fontName=null, $fontSize=null, $bold=false, $italic=false, $underline=0, $strike=false, $color=null, $family=null, $scheme=null) {
        if(empty($fontName))
            $fontName = $this->fontName;
        if(empty($fontSize))
            $fontSize = $this->fontSize;
        if($family===null)
            $family = $this->fontFamily;
        if($scheme===null)
            $scheme = $this->fontScheme;

        if(empty($nick))
            $nick = "fn=$fontName-fs=$fontSize-b=$bold-i=$italic-u=$underline-s=$strike-c=$color-ff=".(empty($family) ? '' : $family)."-s=".(empty($scheme) ? '' : $scheme);

        if(isset($this->font[$nick]))
            return $this->font[$nick][$this->indexId];

        $font = array();

        if($bold)
            $font['b']=array();
        if($italic)
            $font['i']=array();

        if($underline===true || $underline==1)
            $font['u']=array();
        elseif($underline)
            $font['u']=array('val'=>'double');
        if($strike)
            $font['strike']=array();
        $font['sz'] = array('val'=> $fontSize);

        if(empty($color))
            $font['color'] = array('theme'=>1);
        else
            $font['color'] = $this->color2Array($color);

        $font['name'] = array('val'=> $fontName);

        if(!empty($family))
            $font['family'] = array('val'=> $family);
        if(!empty($scheme))
            $font['scheme'] = array('val'=> $scheme);

        $font[$this->indexId] = count($this->font);
        $this->font[$nick] = $font;
        return $font[$this->indexId];
    }

    public function fontToIndex($nick) {
        if(isset($this->font[$nick]))
            return $this->font[$nick][$this->indexId];
        return 0;
    }

///////////////////////
/// Fill
//////////////////////
    public function fillAdd($nick, $patternType="solid", $fgColor=null, $bgColor=null) {

        if(isset($this->fill[$nick]))
            return $this->fill[$nick][$this->indexId];

        if(empty($patternType))
            $patternType = "solid";

        $patternFill = array('patternType'=>$patternType);
        if(!empty($fgColor)) {
            $patternFill['fgColor'] = $this->color2Array($fgColor);
        }
        if(!empty($bgColor)) {
$x = $this->color2Array($bgColor);
//echo "<li>fillAdd for $bgColor get: "          . print_r($x,true)."</li>";
            $patternFill['bgColor'] = $this->color2Array($bgColor);
        }

        $indexId = count($this->fill);
        $this->fill[$nick] =array( 'patternFill' => $patternFill, $this->indexId=>$indexId );
        return $indexId;
    }

    public function fillToIndex($nick) {
        if(isset($this->fill[$nick]))
            return $this->fill[$nick][$this->indexId];
        return 0;
    }

///////////////////////
/// Borders
//////////////////////
    public function borderAdd($nick, $array) {
        if(isset($this->border[$nick]))
            $array[$this->indexId] = $this->border[$nick][$this->indexId];
        else
            $array[$this->indexId] = count($this->border);
        $this->border[$nick] = $array;
        return $array[$this->indexId];
    }

    public function borderToIndex($nick) {
        if(isset($this->border[$nick]))
            return $this->border[$nick][$this->indexId];
        return 0;
    }

    protected function borderToxml() {
        $set = array('left','right','top','bottom','diagonal');
        $ret = '';
        foreach($this->border as $k=>$b) {
            $ret.="\r\n\t<border>";
            foreach($set as $s)
                if(isset($b[$s])) {
                    $ret .= "\r\n\t\t".$this->toXml($s,$b[$s]);
                } else
                    $ret .= "\r\n\t\t"."<$s/>";
            $ret.="\r\n\t</border>";
        }
        return '<borders count="'.count($this->border).'">'.$ret."\r\n".'</borders>';
    }

///////////////////////
/// Colors
//////////////////////
    protected function color2Array($color) {
//echo "<li>c2A: $color";
        if(substr($color,0,1) === '#') {
            $color = substr($color,1);
            $len = strlen($color);
            if($len === 2) {
                $color = $color . $color . $color;
                $len = strlen($color);
            } elseif($len === 3) {
                $color = $color . $color;
                $len = strlen($color);
            }
        } elseif(isset($this->namedColors[strtolower(trim($color))])) {
            $c = $this->namedColors[strtolower(trim($color))];
//echo "<li>c2A: color=$color= c=$c=</li>";
            $this->colorAdd('FF'.$c);
            return array('rgb' => 'FF'.$c);
        } else
            $len = strlen($color);

        if($len === 6) {
            $this->colorAdd('FF'.$color);
            return array('rgb' => 'FF'.$color);
        }
        if($len === 8) {
            $this->colorAdd($color);
            return array('rgb' => $color);
        }
        return array('indexed' => $color);
    }

    protected function colorAdd($color) {

        if(strlen($color)<4)
            return;
        if(isset($this->color[$color]))
            return;
        $this->color[$color] = array('rgb'=> $color);
    }

///////////////////////
/// Helpers
//////////////////////
    protected function quote($value) {
        return  '"'.str_replace(array("\\", '/','"','-'), array('\\\\','\\/','\\"','\\-'), $value).'"';
    }

    protected function toXml($key, $arr, $level=0) {
        $indent = str_repeat("\t",$level+2);
        $tag = "<$key"; // (".print_r($arr,true).")";
        $body = "";
        foreach($arr as $attr=>$v)
            if($attr !== $this->indexId) {
                if(!is_array($v)) {
                    if($attr === 'rgb')
                        $this->colorAdd($v);
                    $tag .= " $attr=".$this->quote($v);
                } else {
                    $body .= "\r\n$indent".$this->toXml($attr,$v,$level+1);
                }
            }
        if(empty($body))
            return $tag."/>";
        if($level>0)
            return "$tag>$body\r\n".str_repeat("\t",$level+1)."</$key>";

        return "$tag>".$body."\r\n".str_repeat("\t",$level+1)."</$key>";
    }

    protected function toXmlTagged($tag, $array) {
        $ret = '';
        foreach($array as $a)
            $ret .= "\r\n\t".$this->toXml($tag,$a);
        return $ret;
    }

    protected function displayXmlArray($tag, $array,$subTag=null) {
        if(empty($array) )
            return '';
        if($subTag === null)
            $subTag = $tag;
        $ret = '';
        foreach($array as $d) {
            $ret .= "\r\n\t" . $this->toXml($subTag,$d);
        }
        $tags = $tag.'s';
        return "\r\n<$tags count=\"".count($array)."\">".$ret."\r\n</$tags>";
    }

    public function stylesXml() {
        $ret = '<?xml version="1.0" encoding="UTF-8" standalone="yes"?>';
        //$ret .= "\n".'<styleSheet xmlns:x14ac="http://schemas.microsoft.com/office/spreadsheetml/2009/9/ac" mc:Ignorable="x14ac" xmlns:mc="http://schemas.openxmlformats.org/markup-compatibility/2006" xmlns="http://schemas.openxmlformats.org/spreadsheetml/2006/main">';
        $ret .= "\n" . '<styleSheet xmlns="http://schemas.openxmlformats.org/spreadsheetml/2006/main">';
        $ret .= $this->displayXmlArray('numFmt', $this->numFmts);
        $ret .= $this->displayXmlArray('font', $this->font);
        $ret .= $this->displayXmlArray('fill', $this->fill);
        $ret .= "\n".$this->borderToxml();
$ret .= '
<cellStyleXfs count="1">
<xf numFmtId="0" borderId="0" fillId="0" fontId="0"/>
<xf> <alignment wrapText="true" /> </xf>
</cellStyleXfs>
';
        $ret .= $this->displayXmlArray('cellXf', $this->cellXf,'xf');
        //$ret .= $this->displayXmlArray('cellStyleXf', ?,'xf');
       // $ret .= $this->displayXmlArray('cellStyle', $this->cellStyle);
       // $ret .= "\n<colors>\n\t<mruColors>\n\t".$this->toXmlTagged('color',$this->color)."\n\t</mruColors>\n</colors>";

        $ret .='
    <dxfs count="0"/>
    <tableStyles count="0" defaultPivotStyle="PivotStyleLight16" defaultTableStyle="TableStyleMedium9"/>
</styleSheet>';
        return $ret;
    }

}



?>