let ListasPast = {};

ListasPast.atributos = {
    clave: '',
    fecha: '',
    lista: '',
    permisos: [],
    usuario: null,
};

ListasPast.funciones = {
    init: async ()=>{
        let stopProcess= ListasPast.funciones.removerDialogo($('#dialogoHistorial'));
        if(stopProcess) return;

       await ListasPast.funciones.obteniendoPermisos();

       let permisos= ListasPast.atributos.permisos;
       if(!permisos.length){
        $('.ui-button-icon.ui-icon.ui-icon-closethick').trigger('click');
            ListasPast.funciones.modalAlert('No tienes permisos para ver el historial DE NINGUNA TIENDA', 'Error', 'error');
            return;
       }
       //construendo el dialogo
         let dialogo= $('<div></div>', {title: 'Historial de cambios', id: 'dialogoHistorial'});
            let body_dialogo= $('<div></div>', {class: 'p-3'});
            let div_info= 
                $('<div></div>', 
                    {
                        class: 'flex justify-content-center align-items-center font-bold',
                        id: 'div_info',
                        text: 'Ver historial de cambios'

                    }
                );
            let lbl_fechaInicio= $('<label></label>', {for: 'fecha_inicio', text: 'Fecha inicio', class: 'mt-2 d-block w-100'});
            let input_fechaInicio= $('<input>', {type: 'text', id: 'fecha_inicio', class: 'form-control input-custum mt-4 mb-3 w-80'});

            let container_inicio= $('<div></div>', {class: 'flex flex-col justify-content-center align-items-center gap-2'});
            container_inicio.append(lbl_fechaInicio, input_fechaInicio);

            let lbl_fechaFin= $('<label></label>', {for: 'fecha_fin', text: 'Fecha fin', class: 'mt-2 d-block w-100'});
            let input_fechaFin= $('<input>', {type: 'text', id: 'fecha_fin', class: 'form-control input-custum mt-4 mb-3 w-80'});

            let container_fin= $('<div></div>', {class: 'flex flex-col justify-content-center align-items-center gap-2'});
            container_fin.append(lbl_fechaFin, input_fechaFin);

            let div_fechas= $('<div></div>', {class: 'flex justify-content-center align-items-center'});
            div_fechas.append(container_inicio, container_fin);

            let select_permisos= $('<select></select>', {id: 'select_permisos', class: 'form-select mt-2 mb-2 w-100', multiple:'true'});
            let label_permisos= $('<label></label>', {for: 'select_permisos', text: 'Selecciona una tienda', class: 'mt-2 d-block w-100'});

            let icon_clear= 
            $('<i></i>', {class: 'fa-solid fa-broom-wide mt-2 cursor-pointer', title: 'Limpiar selección', id: 'clear_select'})
            .on('click', ()=>select_permisos[0].selectize.clear());

            let div_infolbl= $('<div></div>', {class: 'flex justify-content-center align-items-center'});
            div_infolbl.append(label_permisos, icon_clear);

            let lbl_info= $('<label></label>', {text: 'Ver nombre de las listas', class: 'd-block text-center', for: 'info_listas'});
            let chack_info= $('<input>', {type: 'checkbox', id: 'info_listas', class: 'form-check-input mb-2', checked: true});

            let container_info= $('<div></div>', {class: 'flex justify-content-center align-items-center'});
            container_info.append(lbl_info, chack_info);

            permisos.forEach(permiso => {
                let option= $('<option></option>', {value: permiso.tienda_id, text: permiso.clave, selected: true});
                select_permisos.append(option);
            });

            let container_permisos= $('<div></div>', {class: 'flex flex-col justify-content-center align-items-center'});
            container_permisos.append(div_infolbl, select_permisos, div_fechas, container_info);

            const tipoRony= $vitex_globales.tipo_rony;
            
            let divUsuario= $('<div></div>', {class: 'flex justify-content-center align-items-center mt-2'});
            let lbluser= $('<label></label>', {text: 'Ver como usuario', class: 'd-block text-center', for: 'info_user'});
            let select_user= $('<select></select>', {id: 'info_user', class: 'form-select mb-2 w-100'});

            let option_user= $('<option></option>', {value: '', text: 'Esta como tipo rony', selected: true});
            select_user.append(option_user);
            select_user.on('change', ListasPast.funciones.comprobandoPermisos);

            await ListasPast.funciones.obteniendoUsuarios(select_user);
            divUsuario.append(lbluser, select_user);

            body_dialogo.append(div_info, container_permisos);

            if(tipoRony) body_dialogo.append(divUsuario);

            let objBtns= [
                {
                    text: 'Buscar',
                    icon: 'ui-icon-search',
                    id: "botonBuscar",
                    click: function () {
                        ListasPast.funciones.buscarHistorial($(this));
                    },
                }
            ];

            let hoy= luxon.DateTime.now().setZone('America/Mexico_City');
            //formateando la fecha de ayer
            hoy= hoy.toFormat('dd/LL/yyyy', { zone: 'America/Mexico_City' });


            ListasPast.funciones.creandoDatePicker(input_fechaInicio, {maxDate: hoy});
            ListasPast.funciones.creandoDatePicker(input_fechaFin, {maxDate: hoy});

            select_permisos.selectize({
                plugins: ["remove_button"],
                delimiter: ",",
                onInitialize : function() {
                    let wrapper= this.$wrapper[0];
                    let container= $(wrapper).parent();

                    $wrapper= $(wrapper);

                    $wrapper
                        .css(
                            {
                                'width': '70%',
                                'height': '70px',
                            }
                        );
                    $wrapper
                        .find('.selectize-input')
                        .css({
                            'height': '70px',
                            'max-height': '70px',
                        });

                },
            });

            dialogo.append(body_dialogo);

            ListasPast.funciones.creandoDialogo(dialogo, null, { width:500 }, objBtns);
    },
    comprobandoPermisos: async function (e) {
        let usuario= $(e.target).val();
        await ListasPast.funciones.obteniendoPermisos(usuario);
        let permisos= ListasPast.atributos.permisos;

        let select_permisos= $('#select_permisos');
        select_permisos[0].selectize.clear();
        //inhabilitando todas las opciones
        let selectize=select_permisos[0].selectize;

        //quitando las opciones
        selectize.clearOptions();

        if(!permisos.length) return ListasPast.funciones.footAlert('El usuario no tiene permisos', 'danger');
        //agregando las opciones
        permisos.forEach(permiso => {
            selectize.addOption({value: permiso.tienda_id, text: permiso.clave});

            //añaadiendo las opciones
           selectize.addItem(permiso.tienda_id);
        });

       
    },
    obteniendoUsuarios: async (select_user)=>{
        let usuarios= [];
        await $.ajax({
            url: "../backoffice/ajax/crudList.php",
            type: 'POST',
            dataType: 'JSON',
            data: {accion:'getAllUsers'},

            success: function (response) {
                if(!response.status){
                    ListasPast.funciones.modalAlert(response.message, 'Error', 'error');
                    return;
                }
                usuarios= response.data;

                usuarios.forEach(usuario => {
                    let { iac_usr_id, userPermiso} = usuario;
                    let option= $('<option></option>', {value: iac_usr_id, text: userPermiso});
                    select_user.append(option);
                });

            },
            error: function (xhr) {
                $('.ui-button-icon.ui-icon.ui-icon-closethick').trigger('click');
                ListasPast.funciones.modalAlert('Error al buscar las tiendas', 'Error', 'error');
                console.log(xhr);
            }
        });
    },
    obteniendoPermisos: async (id=null)=>{
        let permisos= [];
        await $.ajax({
            url: "../backoffice/ajax/crudList.php",
            type: 'POST',
            dataType: 'JSON',
            data: {accion:'obteniendoPermisos', id},

            success: function (response) {
                if(!response.status){
                    ListasPast.funciones.modalAlert(response.message, 'Error', 'error');
                    return;
                }
                permisos= response.data;


            },
            error: function (xhr) {
                $('.ui-button-icon.ui-icon.ui-icon-closethick').trigger('click');
                ListasPast.funciones.modalAlert('Error al buscar las tiendas', 'Error', 'error');
                console.log(xhr);
            }
        });

        ListasPast.atributos.permisos= permisos;
    },
    removerDialogo: function (dialogo) {
        $('.ui-button-icon.ui-icon.ui-icon-closethick').trigger('click');
        if(dialogo.length>0){
            console.log('removiendo dialogo');
            dialogo.remove();
            return true;
        }
        return false;
    },
    modalAlert: function (message, title, type, confirm=false, time=2000) {
        let objSwal= {
            icon: type,
            title: title,
            text: message,
            showConfirmButton: confirm,
          };
          if(time!==-1) objSwal['timer']= time;

        Swal.fire(objSwal);
    },
    buscarHistorial: async (dialogo)=>{

        //validando que las fechas sean correctas
        let fecha_inicio= $('#fecha_inicio').val();
        let fecha_fin= $('#fecha_fin').val();

        if(fecha_inicio==='')
            fecha_inicio= '01/01/2010'
        

        if(fecha_fin==='')
            fecha_fin= luxon.DateTime.now().setZone('America/Mexico_City').toFormat('dd/LL/yyyy', { zone: 'America/Mexico_City' });
        

        //buscando que la fecha de inicio sea menor a la fecha de fin
        let fecha_inicio_format= luxon.DateTime.fromFormat(fecha_inicio, 'dd/LL/yyyy', { zone: 'America/Mexico_City' });
        let fecha_fin_format= luxon.DateTime.fromFormat(fecha_fin, 'dd/LL/yyyy', { zone: 'America/Mexico_City' });

        if(fecha_inicio_format>fecha_fin_format){
            ListasPast.funciones.footAlert('La fecha de inicio no puede ser mayor a la fecha de fin', 'danger');
            return;
        }

        //buscando que sea una fecha valida
        if(!fecha_inicio_format.isValid){
            ListasPast.funciones.footAlert('La fecha de inicio no es válida', 'danger');
            return;
        }

        if(!fecha_fin_format.isValid){
            ListasPast.funciones.footAlert('La fecha de fin no es válida', 'danger');
            return;
        }

        //buscando la tienda seleccionada
        let tienda= $('#select_permisos').val();

        //buscando que no este vacia la tienda
        if(!tienda.length){
            ListasPast.funciones.footAlert('Debes seleccionar una tienda', 'danger');
            return;
        }

        let check_info= $('#info_listas').is(':checked') ? true : false;

        let user=$('#info_user').length ? $('#info_user').val() : false;

        if(user!==false) ListasPast.atributos.usuario= $('#info_user option:selected').text().trim();
        else ListasPast.atributos.usuario= null;

        
        //formateando la fecha de inicio
        fecha_inicio= fecha_inicio_format.toFormat('yyyy-LL-dd', { zone: 'America/Mexico_City' });
        fecha_fin= fecha_fin_format.toFormat('yyyy-LL-dd', { zone: 'America/Mexico_City' });
        dialogo.remove();

        //conviriendo la tienda en string
        tienda= tienda.join(',');

        //buscando el historial
        ListasPast.funciones.buscandoHistorial({tienda, fecha_inicio, fecha_fin, check_info, user});
    },
    creandoDatePicker: function (input, objConf={}) {

        if(Object.keys(objConf).length===0){
            //obteniendo la fecha actual
          let hoy= ListasPast.funciones.fecha_hoy();

          objConf= {minDate: hoy};

        }
        input.datepicker({
            dateFormat: 'dd/mm/yy',
            changeMonth: true,
            changeYear: true,
            yearRange: '2020:2025',
            ...objConf
        });

    },
    creandoDialogo: function (dialogo, callback, objConf={}, objBtns={}) {

        //si no se mandan botones se crean los botones por defecto
        if(Object.keys(objBtns).length===0){
            objBtns= {
                Aceptar: function () {
                    callback($(this));
                },
                Cancelar: function () {
                    $(this).remove();
                }

            };
        }

        dialogo.dialog({
            modal: false,
            ...objConf,
            buttons: objBtns,
            close: function () {
                $(this).remove();
            }
        });

    },
    footAlert: function (message, type, time=5000) {
        $div_dialogo= $('div.ui-dialog-buttonpane').css('position', 'relative');

        let div_alert= $('<div></div>', {class: `alert alert-${type}`, text: message});

        $div_dialogo.append(div_alert);

        setTimeout(() => {
            div_alert.remove();
        }, time);

    },
    buscandoHistorial: async (obj)=>{
        let historial= [];
        await $.ajax({
            url: "../backoffice/ajax/crudList.php",
            type: 'POST',
            dataType: 'JSON',
            data: {accion:'buscandoHistorial', ...obj},

            success: function (response) {
                if(!response.status){
                    ListasPast.funciones.modalAlert(response.message, 'Error', 'error', true, -1);
                    return;
                }
                historial= response;
                ListasPast.funciones.creandoHistorialCompleto(historial, obj);

            },
            error: function (xhr) {
                $('.ui-button-icon.ui-icon.ui-icon-closethick').trigger('click');
                ListasPast.funciones.modalAlert('Error al buscar las tiendas', 'Error', 'error', true, -1);
                console.log(xhr);
            }
        });
        
    },

    creandoHistorialCompleto: (historial, parametros)=>{

        let {data, productos, listas, tienda}= historial;
        let {check_info }= parametros;

    
        let stopProcess= ListasPast.funciones.removerDialogo($('#dialogoHistorialCompleto'));
        if(stopProcess) return;
        //creando el dialogo
        let dialogo= $('<div></div>', {title: 'Historial de cambios', id: 'dialogoHistorialCompleto'});
        let body_dialogo= $('<div></div>', {class: 'p-3'});

        ListasPast.funciones.setToolExporter({body_dialogo, table:'table_historial', tienda, listas: listas.length});

        let table_container= $('<div></div>', {class: 'h-78vh mxw-90 m-auto overflow-scroll', id: 'table_container_hist'});

        let table= $('<table></table>', {class: 'table table-bordered table-striped table-hover table-sm m-auto border-separate relative', id: 'table_historial'});
        let caption= 
            $('<caption></caption>', 
                {text: 'Historial de cambios'})
                .css('height', '50px');

        //creando cabecera de la tabla
        ListasPast.funciones.creandoCabeceraHistorial(caption, parametros, tienda);
        let thead= $('<thead></thead>');

        //creando el thead
        ListasPast.funciones.creandoTheadHistorial(thead, listas, check_info);

        let tbody= $('<tbody></tbody>');
        ListasPast.funciones.creandoBodyHistorial(tbody, {productos, listas, data});

        table.addClass('table table-bordered table-striped table-hover table-sm');
        table.css('width', 'auto');
        table.append(caption, thead, tbody);
        table_container.append(table);
        body_dialogo.append(table_container);
        dialogo.append(body_dialogo);

        let objBtns= [
            {
                text: 'Cerrar',
                icon: 'ui-icon-close',
                click: function () {
                    $(this).remove();
                },
            }
        ];

        ListasPast.funciones.creandoDialogo(dialogo, null, {width:'90%'}, objBtns);
    
    },
    creandoCabeceraHistorial: (caption, parametros, clave)=>{
        let {fecha_inicio, fecha_fin}= parametros;

        //formateando la fecha de inicio
        fecha_inicio= luxon.DateTime.fromFormat(fecha_inicio, 'yyyy-LL-dd', { zone: 'America/Mexico_City' });
        fecha_inicio= fecha_inicio.toFormat('dd/LL/yyyy', { zone: 'America/Mexico_City' });
        let rest_cap=`desde el <span class="font-bold">"${fecha_inicio}"</span>`;
        if(fecha_inicio==='01/01/2010') rest_cap=``

        //formateando la fecha de fin
        fecha_fin= luxon.DateTime.fromFormat(fecha_fin, 'yyyy-LL-dd', { zone: 'America/Mexico_City' });
        fecha_fin= fecha_fin.toFormat('dd/LL/yyyy', { zone: 'America/Mexico_City' });

        let userP='';

        if($vitex_globales.tipo_rony && ListasPast.atributos.usuario) userP= `<p class='m-0'> Ver como usuario: <span class="font-bold">${ListasPast.atributos.usuario}</span></p>`;
        
        let txt_caption=
        $( `<p class='m-0'> de la tienda<span class="font-bold">"${clave}"</span> ${rest_cap}<span class="font-bold">hasta "${fecha_fin}"</span></p> ${userP} `);
        caption.append(txt_caption);

        caption.addClass('sticky bg-gradient-blue top-0 zindex-2');

        
        
    },
    setToolExporter: (objExporter)=>{
        let {body_dialogo, tienda, table, listas }= objExporter;

        widthCols= ListasPast.funciones.medidasListas(listas);
        
        let toolbar=`
                <div class="toolbar_exporter tableLiPrecios" style="position: absolute; top: 0;">
                    <div title="Imprimir" style="font-size: 1em;" class="ui-icon ui-icon-print-b noprint pointer" onclick="exporter.print('#${table}', 'Historial de cambios ${tienda}', true)"></div>
                    <div title="PDF" style="font-size: 1em;" class="ui-icon ui-icon-file-pdf noprint pointer" onclick="ListasPast.funciones.pdf_table('#${table}', 'Historial de cambios ${tienda}', 'Historial de cambios ${tienda}')"></div>
                    <div title="Copiar texto al clipboard" style="font-size: 1em;" class="ui-icon ui-icon-copy pointer copyClipBloard noprint" data-clipboard-target="#${table}"></div>
                    <div title="Guardar como imagen" style="font-size: 1em;" class="ui-icon ui-icon-file-image noprint pointer" onclick="ListasPast.funciones.imageSave('#${table}', '${tienda}');"></div>
                    <div title="Excel" style="font-size: 1em;padding-left: 5px;color: #2f73d7;" class="fa-solid fa-file-excel noprint pointer" onclick="toExcelLista('#${table}', 'Historial de cambios ${tienda}', {colsW:['180','180', ${widthCols}], rowsW:['20', '30', '30','50']})"></div>
                </div>
        `;
        body_dialogo.append(toolbar);

        let copyClipBloard= 
                $('<div></div>', 
                    {
                        id: 'copyImageClick', 
                        title: 'Copiar imagen al clipboard', 
                        class: 'fa-regular fa-file-jpg pointer copyClipBloard noprint'
                    }).css({
                        'font-size': '1em',
                        'padding-left': '5px',
                        'color': '#2f73d7',
                        'cursor': 'pointer'
                    })
        
        if(typeof(ClipboardItem) !== 'undefined'){
            copyClipBloard.on('click',() =>ListasPast.funciones.copyImage());
            let tBar= body_dialogo.find('.toolbar_exporter');
            tBar.append(copyClipBloard);
        }
    },
    pdf_table: async function (table, title, subtitle, height) {
        await exporter.pdf_table(table, title, subtitle, height);
        $('.none').hide();
    },
    medidasListas: (listas)=>{
        let medidas= [];
        for(let i=0; i<listas; i++){
            medidas= [...medidas, "'150'"];
        }

        return medidas.join(',');

       
    },
    imageSave: async function (table, title) {
        await exporter.imageSave(table, title);
        $('.none').hide();
    },
    canvas2Clipboard(canvas) {
        try {
            queueMicrotask(() => {
            canvas.toBlob(async (blob) => {
                await navigator.clipboard.write([
                    new ClipboardItem({[blob.type]: blob})
                ]);

                $("#copyImageClick").notify("¡Imagen Copiada!", {
                    position: 'left',
                    globalPosition: 'bottom left',
                    style: 'copiado',
                    className: 'supercopiado',
                    autoHideDelay: 2000
                });
            });
            });
        } catch(e) {
            ia.alertError("Haga click en Guardar como imagen y copiela", "Sin permiso de copiar una imagen directamente");
        }
    },

    copyImage: function() {
            
        html2canvas(document.querySelector('#table_historial')).then(function (canvas) {
            // $("BODY").append('canvas');
            canvas2Clipboard(canvas);
        });
    
        ListasPast.funciones.footAlert('Imagen copiada al clipboard', 'success');
    },
    creandoTheadHistorial: (thead, listas, viasible)=>{

        thead.addClass('sticky zindex-2 shadow-md border-gray-c5 py-1 fs-075 top-50');
        let tr= $('<tr></tr>');
        let tr_claves= $('<tr></tr>');
        let tr_precios= $('<tr></tr>');
        let th_producto= $('<th></th>', {text: 'Producto', class: 'mnw-200', rowspan:'4'} ).css('width', '200px');
        tr.append(th_producto);
        let th_unidad= $('<th></th>', {text: 'Unidad', rowspan:'4', class:'mnw-160'});
        tr.append(th_unidad);

        //tr del la info de la lista
        let class_none= viasible ? '' : 'none noprint';

        let tr_info= $('<tr></tr>');
        // let th_prod= $('<th></th>', {class: class_none});
        // let th_uni= $('<th></th>', {class: class_none});
        


       // tr_info.append(th_prod, th_uni);

        listas.forEach(lista => {
            let { fecha_inicio, fecha_fin, clave_busqueda,claves, nombre }= lista;
            

            //formateando la fecha de inicio
            fecha_inicio= luxon.DateTime.fromFormat(fecha_inicio, 'yyyy-LL-dd', { zone: 'America/Mexico_City' });
            fecha_inicio= fecha_inicio.toFormat('dd/LL/yyyy', { zone: 'America/Mexico_City' });
            let txt_fin=''
            if(fecha_fin){
                fecha_fin= luxon.DateTime.fromFormat(fecha_fin, 'yyyy-LL-dd', { zone: 'America/Mexico_City' });
                //restar un dia a la fecha de fin
                fecha_fin= fecha_fin.minus({days: 1});
                fecha_fin= fecha_fin.toFormat('dd/LL/yyyy', { zone: 'America/Mexico_City' });
                 txt_fin=`<br> AL: ${fecha_fin}`;
            }

            let th_precios= $('<th></th>', {class: 'p-1 mnw-140'});
            th_precios.html(`DE: ${fecha_inicio} ${txt_fin}`)
            tr_precios.append(th_precios);

            let th_fecha= $('<th></th>', {text: `Precios`, class:'p-1'});
            
            let th_clave= $('<th></th>', {text: `EN: ${clave_busqueda}`, class: 'p-1'});
            let th_list= $('<th></th>', {class: `${class_none} p-1`});
            let p_list= $('<p></p>', {text: nombre, class: 'm-0'});
            // let p_tiendas= $('<p></p>', {class: 'm-0'});
            // ListasPast.funciones.creandoClaves(claves,clave_busqueda, p_tiendas);

            th_list.append(p_list);

            
            tr.append(th_fecha);
            tr_claves.append(th_clave);
            tr_info.append(th_list);
        });

        thead.append(tr,tr_precios, tr_info, tr_claves);
    },
    creandoClaves: (claves, clave_busqueda, p)=>{
        let claves_list= claves.split(',');
        let array_busqueda= clave_busqueda.split(',');
        claves_list.forEach((busqueda, key) => {
            let index= array_busqueda.indexOf(busqueda);
            let clase_attencion= index===-1 ? 'font-normal txt-gray-500' : 'txt-blue-500 font-bold';
            
            let coma= key===0 ? '' : ',';
            let span= $('<span></span>', {text: `${coma}${busqueda.trim()}`, class: `fs-065 ${clase_attencion }`});
        
            p.append(span);
        });
        
    },
    creandoBodyHistorial: (tbody, info)=>{
        let {productos, listas, data}= info;

        for(let index in productos){
           if(!productos[index]) continue;

           //buscando el producto
            let producto_general= productos[index];

            //creando el tr
            let tr= $('<tr></tr>');
            let { producto, unidad }= producto_general;

            //creando el td del nombre
            let td_nombre= $('<td></td>', {text: producto, class: 'fs-075'});
            tr.append(td_nombre);

            //creando el td de la unidad
            let td_unidad= $('<td></td>', {text: unidad, class: 'fs-075'});
            tr.append(td_unidad);

           let precios= data[index];

           listas.forEach(lista => {
             let prices =precios[lista.fecha_lista];
             if(!prices)    return
             let { precio_pesos } = prices.precio
        

                let td_precio= $('<td></td>', {text: `$${precio_pesos}`, class: 'fs-075 der'});
                tr.append(td_precio);
           });
            tbody.append(tr);
        }
    }
}