
// noinspection JSJQueryEfficiency
// noinspection ES6ConvertVarToLetConst

class ProductoGeneralUtil {
    #productoColores = {}
    #colorKeyValue = {}
    #colorKeyValue_All = {}
    #productoKeyValue = {}
    #productoKeyValue_All = {}
    #productoGralId=''
    #productoActivo=''
    #asignaColores= false;
    promise = null;
    productoColores = {}
    colores_olla= {};
    colores_programa= {};
    selecciones= {}
    // elements_group= {}
    colores_china= {}

    constructor(producto_general_id, gridhandler=null, bandera=true) {
        this.readData(producto_general_id, gridhandler, bandera);
        this.get_colores_permisos();
    }

 async readData(producto_general_id, gridhandler, bandera) {
        let me = this;
        let datos;
        try {
        await Promise.all([
            me.get_colores_permisos(),
            me.get_Color_inactivo_Olla(producto_general_id),
            me.getPedidoChina( producto_general_id),
            me.getPrograma(producto_general_id)]
        );
        } catch (error) {
            console.log(error);
        }

    // await me.get_colores_permisos();
    // await me.get_Color_inactivo_Olla(producto_general_id);
    $.ajax({
            url: '../backoffice/ajax/ProductoGeneralUtil_acciones.php',
            method: 'POST',
            cache: false,
            data: {accion:'initialData', producto_general_id},
            dataType: 'json',
        })
        .done(function(data) {
            if(!data.status) {
                ia.alertError(data.message || "Error inesperado, intente más tarde.", "Error");
                console.log("ajax failed url:", this.url);
                return;
            }
            me.#productoActivo=data.producto_activo.activo;
            me.#productoColores = data.productoColores;
            me.#colorKeyValue = data.colorKeyValue;
            me.#colorKeyValue_All = data.colorKeyValue_All;
            me.#productoKeyValue = data.productoKeyValue;
            me.#productoKeyValue_All = data.productoKeyValue_All;
            me.#productoGralId=producto_general_id;

            if(bandera)
                me.promise= me.asignaColoresDialog(producto_general_id,me, gridhandler);

        })
        .fail(function(jqXHR, textStatus, errorThrown) {
            ia.alertError(`Problemas al comunicarme con el server: <ul><lI>${errorThrown}<li>${textStatus}</ul>`, "Error", true);
            console.log('ajax failed: ' + this.url, arguments);
        });

    return datos;
    }

    asignaColoresDialog(producto_general_id=null, instance=null, gridhandler) {
        let producto = this.#productoKeyValue_All[producto_general_id] || "¿?";
        let opciones = [];


        for(let color_id in this.#colorKeyValue){
            if( this.#productoColores[color_id] === undefined ){
                opciones.push( {activo:"No", color_id:color_id, color:`${this.#colorKeyValue[color_id]} <span class="huerfano_producto" title="Este color nunca ha tenido existencia para este producto">(H)</span>`, notificado: 'No'});
            }
            else{
                opciones.push(this.#productoColores[color_id]);
            }
        }

        //console.log(this);
           
            opciones.forEach(opcion => {
                opcion.china=0;
                opcion.existencia=0;
                opcion.programa=0;
                if(opcion.activo==='Si' && opcion.notificado === 'No'){
                    opcion.bandera=1;
                    let opcion_temporal=opcion;
                    opciones.splice(opciones.indexOf(opcion),1);
                    opciones.unshift(opcion_temporal);

                    if(this.colores_china[`${opcion.color_id}`]!==undefined && opcion.activo==='Si'){
                        opcion.color= opcion.color + `<p style="display:none">China</p> <i title="Este elemento tiene un pedido en china, (para filtrarlo poner el el buscador 'China')" class="fa-duotone fa-ferry" style="--fa-primary-color: #735d0c; --fa-secondary-color: #8c6f08;"></i>`;
                        opcion.china=1;
                    }


                }else{
                    
                    if(opcion.color.includes('(Con ∃)')){
                        if(opcion.activo==='No')
                            this.forzarActivo(opcion.color_id, this.#productoGralId);
                        opcion.activo="Si"
                        opcion.existencia=1;
                    }
                    if(this.colores_china[`${opcion.color_id}`]!==undefined && opcion.activo==='Si'){
                        opcion.color= opcion.color + `<p style="display:none">China</p> <i title="Este elemento tiene un pedido en china, (para filtrarlo poner el el buscador 'China')" class="fa-duotone fa-ferry" style="--fa-primary-color: #735d0c; --fa-secondary-color: #8c6f08;"></i>`;
                        opcion.china=1;
                    }
                    else if(this.colores_programa[`${opcion.color_id}`]!==undefined && this.colores_china[`${opcion.color_id}`]===undefined && opcion.activo==='Si'){
                        opcion.color= opcion.color + `<p style="display:none">Programa</p> <i title="Este elemento esta en el programa, (para filtrarlo poner el el buscador 'Programa')" class="fa-duotone fa-cart-flatbed" style="--fa-primary-color: #6b4f00; --fa-secondary-color: #6b510a;"></i>`;
                        opcion.programa=1;
                        }

                    opcion.bandera=0;
                }
            });


        $('.ui-dialog-titlebar-close:visible').trigger('click');
       // let instance = new ProductoGeneralUtil()
        $("#asignaColores_dialogo").remove();
        $("BODY").append(
            `<div id='asignaColores_dialogo' class='jqgridcolssorter_dialog'>
                <div>
                    <div id='id_agrupador'></div>
                    <div id='asignaColores_clasificame'></div>
                </div>
            </div>`
        );
       let div_group=  $(` <div style="display: flex;justify-content: space-evenly;align-items: center;flex-wrap: wrap; gap: 10px;">
        <div style="display: flex;justify-content: space-evenly;align-items: center;flex-wrap: wrap;gap: 10px;">
            <label for="select_colores">Elige un grupo</label>
            <select id="select_colores">
                <option value="" disabled selected>Seleccione un grupo</option>
            </select>
            <p id="colores_informacion" title="informacion"><i class="fa-solid fa-circle-info"></i></p>
        </div>

        <div id="nombre_grupo">
            <label for="opciones_drag">Elige a donde se va a mandar</label>
            <select id="opciones_drag" disabled>
            </select>
        </div>
    </div>
    <div id="setAlerta">

    </div>`)
    
        if(this.#asignaColores)
        $('#id_agrupador').append(div_group);
        let $select_colores = $("#select_colores");
        if ($select_colores.length > 0) {
            instance.getGruposColores('colores', $("#select_colores"));
        }
        let color_options = [];
        $select_colores.on('change',async function (e) {
            color_options=await instance.get_color_by_grupo(e, 'colores')
        });

        $('#colores_informacion').tooltip();
        $('.huerfano_producto').tooltip();

        let clasificame = $(`#asignaColores_clasificame`).clasificame_by_color({
            'clasificacion': [
                {clasificaId:'Si', label:'Si', title:'Colores de ' + producto,},
                {clasificaId:'No', label:'No', title: producto + ' No Tiene'},
                {clasificaId:'Prohibido', label:'Prohibido', title: producto + 'Colores Prohibidos'},
            ],
            valueId: 'color_id',
            valueDisplay: 'color',
            valueColumnKey: 'activo',
            values: opciones,
            title: `Colores de ${producto}`,
            label_sort:'Colores',
            editable:this.#asignaColores || $vitex_globales.es_Rony,
            producto_id:producto_general_id,

        });

        $(".clasificaStage").on('click', function (e) {
            instance.setNotificado(e,instance)
        });
        $("#opciones_drag").on('change',function (e) {
            instance.sendToColors(e, clasificame, color_options)
        });
        var defer = $.Deferred();
        let me = this;
        $("#asignaColores_dialogo").dialog({
            title:  "Colores para " + producto,
            closeOnEscape: true,
            width: 'auto',
            buttons: [
                {
                    text: 'Guardar',
                    icon: 'ui-icon-disk',
                    class: 'none',
                    id: "botonGuardarColor",
                    click: function() {
                        console.log("boton dentro de dialogo");
                    }
                },
                {
                    text: 'Cancelar',
                    icon: 'ui-icon-cancel',
                    click: function() {
                        $(this).dialog('close');
                    }
                },
            ],
            close: function() {
                if(!defer.isResolved && !defer.isRejected)
                    defer.reject();
                $("#asignaColores_clasificame").remove();
            },
        });
        let boton=$(`<button type="button" id="btnColoresGuardar" class="ui-button ui-corner-all ui-widget ${this.#productoActivo==='No' ? 'ui-button-disabled ui-state-disabled' : ''} " ${this.#productoActivo==='No' ? 'disabled' : ''}><span class="ui-button-icon ui-icon ui-icon-disk"></span><span class="ui-button-icon-space"> </span>Guardar</button>`).insertAfter("#botonGuardarColor")

        boton.on('click',function () {

            if(me.#productoActivo==='No'){
                ia.alertError("El producto esta inactivo", "Error")
                return;
            }


            let mal = [];
            let seleccion = clasificame.clasificame_by_color("value");
            // let hay = me.#productoColores[producto_general_id] || [];
            // let hayLen = hay.length;

            opciones.forEach(opcion => {
                for(let Prohibido of seleccion.Prohibido) {
                    if(opcion.color_id == Prohibido) {
                        if (opcion.color.includes('(Con ∃)')) {
                            mal.push(opcion.color);
                        }
                    }
                }
                for(let No of seleccion.No) {
                    if(opcion.color_id == No) {
                        if (opcion.color.includes('(Con ∃)')) {
                            mal.push(opcion.color);
                        }
                    }
                }
            });
            if(mal.length) {
                ia.alertError("Tienen Existencia los Colores:<ul><li>" + mal.join("<li>") + "</ul>",
                    'Con ∃ deben ser Activos', true
                );
                return;
            }
            $.ajax({
                url: '../backoffice/ajax/ProductoGeneralUtil_acciones.php',
                method: 'POST',
                cache:false,
                dataType:'json',
                data: {accion: 'setColores', producto_general_id:producto_general_id, seleccion: seleccion, activo:me.#productoActivo},
            })
            .done(function(data) {

                if(!data.status || data.alerta) {
                    ia.alertError(data.message || "Error inesperado, intente más tarde.", "Error");
                    console.log("ajax status wrong " + this.url, data);
                    return;
                }
                //ia.alertInfo("Colores asignados correctamente", "Colores Asignados");
                me.#productoColores = data.productoColores;
                data.dialogo_selecciono = seleccion;
                if(gridhandler){
                    gridhandler.jqGrid('setRowData', data.producto_general_id, data.row[producto_general_id]);
                }
                if(!defer.isResolved && !defer.isRejected)
                    defer.resolve(data);
                let $uiBottonPane = $('.ui-dialog-buttonpane.ui-widget-content.ui-helper-clearfix');
                $uiBottonPane.css('position','relative');
               let div_alerta= me.setAlerta('Colores asignados correctamente','success')
               div_alerta.css({
                    "width": "30%",
                    "position": "absolute",
                    "top": "0",
                    "opacity": "0.8",
               });
                $uiBottonPane.append(div_alerta);
               setTimeout(() => div_alerta.remove(), 3000);
               let revisar=$('.bg-warning-updt').length;
               let tr_prod= $(`tr[id="${me.#productoGralId}"]`);
               // noinspection JSUnresolvedReference
                if(revisar===0){
                tr_prod.find('.btn_alerta').css({
                    border: "1px solid black",
                    background: '#f0f0f0',
                    borderRadius: "2px",
                }).prop('title','Poner y quitar colores a los productos')
                tr_prod.find('.btn_alerta i').css('color','darkmagenta');
                tr_prod.find('.pendiente_rev').remove();

    
               
                }
                //VCA 28-09-2024 para poder actualizar cuántos colores tiene asignado un producto_general
                try {
                    if (typeof after_asigna_colores === 'function')
                        after_asigna_colores(data);
                }catch (e) {
                    console.log("after_asigna_colores", e);
                }
            })
            .fail(function(jqXHR, textStatus, errorThrown) {
                ia.alertError(`Problemas al comunicarme con el server: <ul><lI>${errorThrown}<li>${textStatus}</ul>`, "Error", true);
                console.log('ajax failed: ' + this.url, arguments);
            });
        });
        return defer;
        /*
        function esOculto(color_id, colores) {
            for(let c of colores)
                if(color_id === c.color_id)
                    return false;
            return true;
        }
         */
    }

   async getPedidoChina(producto_general_id){
    let me=this;
      await $.ajax({
            url: '../backoffice/ajax/ProductoGeneralUtil_acciones.php',
            method: 'POST',
            cache: false,
            data: {accion:'getDataChina', producto_general_id},
            dataType: 'json',
        })
        .done(function(data) {
            if(!data.status) {
                ia.alertError(data.message || "Error inesperado, intente más tarde.", "Error");
                console.log("ajax failed url:", this.url);
                return;
            }
             me.colores_china=data.status;
        })
        .fail(function(jqXHR, textStatus, errorThrown) {
            ia.alertError(`Problemas al comunicarme con el server: <ul><lI>${errorThrown}<li>${textStatus}</ul>`, "Error", true);
            console.log('ajax failed: ' + this.url, arguments);
        });
    }
   async getPrograma(producto_general_id){
    let me=this;
      await $.ajax({
            url: '../backoffice/ajax/ProductoGeneralUtil_acciones.php',
            method: 'POST',
            cache: false,
            data: {accion:'getDataPrograma', producto_general_id},
            dataType: 'json',
        })
        .done(function(data) {
            if(!data.status) {
                ia.alertError(data.message || "Error inesperado, intente más tarde.", "Error");
                console.log("ajax failed url:", this.url);
                return;
            }
             me.colores_programa=data.status;
        })
        .fail(function(jqXHR, textStatus, errorThrown) {
            ia.alertError(`Problemas al comunicarme con el server: <ul><lI>${errorThrown}<li>${textStatus}</ul>`, "Error", true);
            console.log('ajax failed: ' + this.url, arguments);
        });
    }

    forzarActivo(color_id, producto_general_id){
        $.ajax({
            url: '../backoffice/ajax/ProductoGeneralUtil_acciones.php',
            method: 'POST',
            cache: false,
            data: {accion:'setForzarActivo',color_id, producto_general_id},
            dataType: 'json',
        })
        .done(function(data) {
            if(!data.status) {
                ia.alertError(data.message || "Error inesperado, intente más tarde.", "Error");
                console.log("ajax failed url:", this.url);
            }
        })
        .fail(function(jqXHR, textStatus, errorThrown) {
            ia.alertError(`Problemas al comunicarme con el server: <ul><lI>${errorThrown}<li>${textStatus}</ul>`, "Error", true);
            console.log('ajax failed: ' + this.url, arguments);
        });
    }
    setNotificado(e, instance) {
       let id_color=$(e.target).closest('li').data('clasificaid');
       let id_producto= instance.#productoGralId
       let li_selected=$("li[data-clasificaid=" + id_color + "]");


        $.ajax({
            url: '../backoffice/ajax/ProductoGeneralUtil_acciones.php',
            method: 'POST',
            cache: false,
            data: {accion:'setNotificado',id_color, id_producto},
            dataType: 'json',
        })
        .done(function(data) {
            
            if(!data.status) {
                ia.alertError(data.message || "Error inesperado, intente más tarde.", "Error");
                console.log("ajax failed url:", this.url);
                return;
            }

            li_selected.removeClass("bg-warning-updt con_existe");
            
            li_selected.find('.clasificameLabel').text().includes('(Con ∃)') || li_selected.find('.fa-ferry').length ? li_selected.addClass('con_existe') : li_selected.removeClass('con_existe');
            li_selected.parent().append(li_selected);
            let parent_ = $(e.target).parent().parent().parent();
            if (parent_.tooltip("instance"))
                parent_.tooltip('destroy');
            li_selected.find('.clasificaStage').remove();

            let title= '';
            
            if(li_selected.find('.clasificameLabel').text().includes('(Con ∃)')) title+= ` Este color tiene existencia en el inventario`;
            if(li_selected.find('.fa-ferry').length) title ? title+= ', tiene pedido en china' : title+= 'Este color tiene un pedido en china';
            if(li_selected.find('.fa-cart-flatbed').length) title ? title+= ', esta en el programa' : title+= 'Este color esta en el programa';
            
            li_selected.attr('title',title);
            li_selected.tooltip();
            



            
           
        })
        .fail(function(jqXHR, textStatus, errorThrown) {
            ia.alertError(`Problemas al comunicarme con el server: <ul><lI>${errorThrown}<li>${textStatus}</ul>`, "Error", true);
            console.log('ajax failed: ' + this.url, arguments);
        });
    }
    setPantallaCarga(){
       let contenedor= $('#contenedor_clasificame')

       let spinner= $('<div></div>', {class: 'sk-cube-grid'});
       let body_spinner=
        $(`<div class="sk-cube-grid">
        <div class="sk-cube sk-cube1"></div>
        <div class="sk-cube sk-cube2"></div>
        <div class="sk-cube sk-cube3"></div>
        <div class="sk-cube sk-cube4"></div>
        <div class="sk-cube sk-cube5"></div>
        <div class="sk-cube sk-cube6"></div>
        <div class="sk-cube sk-cube7"></div>
        <div class="sk-cube sk-cube8"></div>
        <div class="sk-cube sk-cube9"></div>
        </div>`)

        spinner.append(body_spinner);

        let container_spinner= $('<div></div>', {class: 'absolute flex justify-content-center align-items-center container_spinner'}).css('position','absolute');
        container_spinner.append(spinner);

        contenedor.append(container_spinner);
    }

    removePantallaCarga(){
        $('#contenedor_clasificame').find('.container_spinner').remove();
    }
    setColoresGrupos(tipo="colores"){
        let $alert = new ProductoGeneralUtil(null, null, false)
        $("#asignaColores_dialogo").dialog('close');
        $('.ui-dialog-titlebar-close:visible').trigger('click');
        $("BODY").append(
            `<div id='agrupaColores_dialogo' class='jqgridcolssorter_dialog'>
                <div id="producto_acciones" style="display: flex;justify-content: space-evenly;align-items: center;flex-wrap: wrap; gap: 10px;">
                    <div>Elige un grupo</div>
                    <select id="grupo_colores">
                        <option value="" disabled selected>Seleccione un grupo</option>
                    </select>
                    <div id="nombre_grupo">
                    <label for="nombre_grupo" style="margin: 0.5rem">Elija un nombre para su grupo</label>
                        <input type="text" id="titulo_grupo" style="background: white; border: 1px solid #d0d0d0;padding: 0.3rem;" />
                    </div>
                </div>

            <div id="contenedor_clasificame" style="position:relative"><div id='agrupaColores_clasificame' ></div></div></div>`
        );

        $alert.getGruposColores(tipo,$("#grupo_colores"));
        $alert.selecciones = $alert.reiniciandoClasificame(tipo);
        let me= this;
        $('#grupo_colores').on('change',async function (e) {
            me.setPantallaCarga();
            $alert.selecciones = await $alert.setGrupoValores(e,tipo, me);
        })
        $('#grupo_colores').on('click',$alert.verficandoExt)


        $("#agrupaColores_dialogo").dialog({
            title:  `Crea un grupo de ${tipo}`,
            closeOnEscape: true,
            width: 'auto',
            buttons: [
                {
                    text: 'Guardar',
                    icon: 'ui-icon-disk',
                    id: "botonGuardarGrupo",
                    class:"none",
                    click: function() {

                    }
                },{
                    text: 'Nuevo',
                    icon: 'ui-icon-plus',
                    id: "botonNuevo",
                    click: function() {
                            $alert.selecciones = $alert.reiniciandoClasificame(tipo);
                            $('#titulo_grupo').val('');
                            $('#grupo_colores').val('');
                            $('#agrupaColores_clasificame').clasificame("allTo", "No");

                            let count=$('.clasificaTitle').find('.clasificame_count');
                            $('.clasificaTitle').text(`Crea Grupo de colores`).append(count);
                    }
                },{
                    text: 'Borrar',
                    icon: 'ui-icon-trash',
                    class: 'boton-borrar',
                    click: function(evt) {
                        let target= $(evt.target);
                        //bloquear el boton de borrar
                        target
                            .addClass("ui-button-disabled ui-state-disabled")
                            .prop("disabled", true);

                        let nombre_del_grupo= $('#titulo_grupo').val();
                        if (nombre_del_grupo==='') {
                            $alert.setAlerta('Debes seleccionar un grupo', 'error');
                            return;
                        }

                        $.ajax({
                            url: '../backoffice/ajax/agrupadorColores.php',
                            method: 'POST',
                            cache: false,
                            data: {accion:'deleteGroup',nombre_del_grupo, tipo},
                            dataType: 'json',
                        })
                        .done(function(data) {
                            if(!data.status) {
                                ia.alertError(data.message || "Error inesperado, intente más tarde.", "Error");
                                console.log("ajax failed url:", this.url);
                                return;
                            }
                             
                            let clasificame= $("#agrupaColores_clasificame");
                            clasificame.clasificame("allTo", "No");
                            $('#titulo_grupo').val('');
                            $('#grupo_colores').val('');
                            let count=$('.clasificaTitle').find('.clasificame_count');
                            $('.clasificaTitle').text(`Crea Grupo de colores`).append(count);
                            $('#botonNuevo')
                                .removeClass("ui-button-disabled ui-state-disabled")
                                .prop("disabled", false);
                             $alert.getGruposColores(tipo,$("#grupo_colores"));
                             let alerta=  $('<div id="alerta" class="alert alert-danger" role="alert">Se ha elminado un grupo</div>').appendTo('.ui-dialog-buttonpane.ui-widget-content.ui-helper-clearfix').css({
                                background: '#fffbda',
                                color: '#a59300',
                                padding: '0.55rem 1.25rem',
                                marginBottom: '1rem',
                                width: '40%',
                                borderLeft: '5px solid #a59300',
                                opacity: 0,
                            });

                            alerta.animate({opacity: 1});
                            setTimeout(() => {
                                alerta.remove();
                            }, 5000);

                        })
                        .fail(function(jqXHR, textStatus, errorThrown) {
                            ia.alertError(`Problemas al comunicarme con el server: <ul><lI>${errorThrown}<li>${textStatus}</ul>`, "Error", true);
                            console.log('ajax failed: ' + this.url, arguments);
                        });
                    },
                    disabled: true,

                },
                {
                    text: 'Cancelar',
                    icon: 'ui-icon-cancel',
                    click: function() {
                        $(this).dialog('close');
                    }
                },
                
                
            ],

            close: function() {
                $("#agrupaColores_dialogo").remove();
            },
        });

        $("#botonGuardar").hide();
        let boton_guardar_grupos= $(`<button type="button" id="botongroup" class="ui-button ui-corner-all ui-widget"><span class="ui-button-icon ui-icon ui-icon-disk"></span><span class="ui-button-icon-space"> </span>Guardar</button>`)
        .insertAfter("#botonGuardarGrupo");
        boton_guardar_grupos.on('click', function () {
            let seleccion = $alert.selecciones.clasificame("value");
            const nombre_del_grupo= $('#titulo_grupo').val();
            if ($('#titulo_grupo').val()==='') {
              let alert=  $('<div id="alerta" class="alert alert-danger" role="alert">Debes seleccionar un grupo</div>').appendTo('.ui-dialog-buttonpane.ui-widget-content.ui-helper-clearfix').css({
                    background: '#f8d7da',
                    color: '#721c24',
                    border: '1px solid #f5c6cb',
                    padding: '0.55rem 1.25rem',
                    marginBottom: '1rem',
                    width: '40%',
                    borderLeft: '5px solid #721c24',
                    opacity: 0,
                });

                alert.animate({opacity: 1});
                setTimeout(() => {
                    alert.remove();
                }, 5000);
                return;
            }
            // const tipo_metodo = tipo.charAt(0).toUpperCase() + tipo.slice(1);

            $.ajax({
                url: '../backoffice/ajax/agrupadorColores.php',
                method: 'POST',
                cache: false,
                data: {accion:`agrupandoColores`, seleccion, nombre_del_grupo, tipo},
                dataType: 'json',
            })
            .done(function(data) {
                if(!data.status) {
                    ia.alertError(data.message || "Error inesperado, intente más tarde.", "Error");
                    console.log("ajax failed url:", this.url);
                    return;
                }
                $alert.selecciones =$alert.reiniciandoClasificame(tipo);
                $alert.getGruposColores(tipo,$("#grupo_colores"));
                let alerta=  $('<div id="alerta" class="alert alert-danger" role="alert"> Se han guardado los cambios exitosamente</div>').appendTo('.ui-dialog-buttonpane.ui-widget-content.ui-helper-clearfix').css({
                    background: '#d3ffd1',
                    color: '#057300',
                    padding: '0.55rem 1.25rem',
                    marginBottom: '1rem',
                    width: '40%',
                    borderLeft: '5px solid #057300',
                    opacity: 0,
                });
                alerta.animate({opacity: 1});
                setTimeout(() => {
                    alerta.remove();
                }, 5000);
            })
            .fail(function(jqXHR, textStatus, errorThrown) {
                ia.alertError(`Problemas al comunicarme con el server: <ul><lI>${errorThrown}<li>${textStatus}</ul>`, "Error", true);
                console.log('ajax failed: ' + this.url, arguments);
            });
        });

    }
    setAlerta (msj, tipo) {
        const div= $(`<div>${msj}</div>`);

        let bg_color= tipo==='error' ? 'rgb(255 223 223)' : (tipo==="warning" ? '#fff9cf' : 'rgb(224 255 223)');
        let color= tipo==='error' ? '#c70000' : (tipo==="warning" ? '#ddb000' : 'rgb(34 167 0)');
        div.css({
            'background-color': bg_color,
            'padding': '0.3rem',
            'margin':' 0.8rem 0.3rem',
            'border-left': `5px ${color} solid`,
            'color': color,
            'font-size': '0.7rem',
            'font-weight': 'bold',
            'opacity': '0',
            'width': '100%'
        });
        return div;
    }
    verficandoExt(e){
        let existeOpc= $(e.target).find('option');
        if(existeOpc.length<=1)
        {
            $('.alert').remove();
            let alerta=  $('<div id="alerta" class="alert alert-danger" role="alert">No hay grupos disponibles</div>').appendTo('.ui-dialog-buttonpane.ui-widget-content.ui-helper-clearfix').css({
                background: '#fff7cd',
                color: '#b19500',
                padding: '0.55rem 1.25rem',
                marginBottom: '1rem',
                width: '40%',
                borderLeft: '5px solid #b19500',
                opacity: 0,
            });

            alerta.animate({opacity: 1});
            setTimeout(() => {
                alerta.remove();
            }, 5000);
        }
    }
    getGruposColores(tipo, input){
        $.ajax({
            url: '../backoffice/ajax/agrupadorColores.php',
            method: 'GET',
            cache: false,
            data: {accion:'getGruposColores', tipo},
            dataType: 'json',
        })
        .done(function(data) {
            if(!data.status) {
                ia.alertError(data.message || "Error inesperado, intente más tarde.", "Error");
                console.log("ajax failed url:", this.url);
                return;
            }


            input.empty();
            input.append(`<option value="" disabled selected>Seleccione un grupo</option>`);
            input.append(data.opciones);

        })
        .fail(function(jqXHR, textStatus, errorThrown) {
            ia.alertError(`Problemas al comunicarme con el server: <ul><lI>${errorThrown}<li>${textStatus}</ul>`, "Error", true);
            console.log('ajax failed: ' + this.url, arguments);
        });
    }
    async setGrupoValores(e, tipo, me){
        let id_grupo= e.target.value;
        let agrupa;
        await $.ajax({
            url: '../backoffice/ajax/agrupadorColores.php',
            method: 'POST',
            cache: false,
            data: {accion:`${tipo}Agrupados`, id_grupo, tipo},
            dataType: 'json',
        })
        .done(function(data) {
            if(!data.status) {
                ia.alertError(data.message || "Error inesperado, intente más tarde.", "Error");
                console.log("ajax failed url:", this.url);
                return;
            }
            const nombre_grupo= $('#grupo_colores option:selected').text();

            $('#titulo_grupo').val(nombre_grupo);
            let div_clasificacion=$('<div id="agrupaColores_clasificame"></div>');
            $('#contenedor_clasificame').append(div_clasificacion);
            $(".boton-borrar").removeClass("ui-button-disabled ui-state-disabled")
                .prop("disabled", false);
             agrupa= $(`#agrupaColores_clasificame`);
            console.log('data prod',data);
             let {colores}= data;
            colores.forEach(color => {
                if(color.color_id){
                    let {color_id, activo}= color;
                    agrupa.clasificame("moveTo", color_id, activo);
                }else{
                    let {value, activo}= color;
                    agrupa.clasificame("moveTo", value, activo);
                }
            });
               
            let cuenta= $(".clasificame_count")
            $('.clasificaTitle').text(`Grupo: ${nombre_grupo}`).append(cuenta);

            me.removePantallaCarga();
        })
        .fail(function(jqXHR, textStatus, errorThrown) {
            ia.alertError(`Problemas al comunicarme con el server: <ul><lI>${errorThrown}<li>${textStatus}</ul>`, "Error", true);
            console.log('ajax failed: ' + this.url, arguments);
        });
    return agrupa;
    }
    reiniciandoClasificame(tipo){
        let values_clasificame= tipo==='colores' ? $vitex_globales.g_cat_color : $vitex_globales.g_cat_producto_general;
        let id_busqueda= tipo==='colores' ? 'color_id' : 'real_data';
        let id_display= tipo==='colores' ? 'color' : 'value';
        $('#titulo_grupo').val('');
        $('#agrupaColores_clasificame').remove();
        let div_clasificacion=$('<div id="agrupaColores_clasificame"></div>');
        $('#contenedor_clasificame').append(div_clasificacion);
        let agrupa= $(`#agrupaColores_clasificame`).clasificame({
            'clasificacion': [
                {clasificaId:'Si', label:'Si', title:'Agregar a Grupo'},
                {clasificaId:'No', label:'No', title: 'Descartar'},
            ],

            valueId: id_busqueda,
            valueDisplay: id_display,
            valueColumnKey: 'activo',
            values: values_clasificame,
            title: `Crea Grupo de ${tipo}`,
            label_sort:tipo,
            editable:true,
            modalGroup: true,

        });
        $(".boton-borrar").addClass("ui-button-disabled ui-state-disabled");
        $(".boton-borrar").prop("disabled", true);
    return agrupa;
    }
    async get_color_by_grupo(e, tipo='colores'){
        let nombre_grupo= e.target.value;
        let clase_find= tipo==='colores' ? 'Color' : 'Productos';
        let opciones=[];
      await  $.ajax({
            url: '../backoffice/ajax/agrupadorColores.php',
            method: 'GET',
            cache: false,
            data: {accion:`get${clase_find}ByGrupo`, nombre_grupo, tipo:clase_find.toLocaleLowerCase()==='color' ? 'colores' : 'productos'},
            dataType: 'json',
        })
        .done(function(data) {
            if(!data.status) {
                ia.alertError(data.message || "Error inesperado, intente más tarde.", "Error");
                console.log("ajax failed url:", this.url);
                return;
            }
            $('#listado_colores').empty().css({
                "text-align": "center",
                "padding": "0.5rem",
                "background": "#ffe7ba",
                "border-radius": "0.5rem",
                "font-size": "0.8rem",
                "margin": "10px auto",
                "width": "50%"
            });
            $('<p>Listado Colores</p>').css({
                "font-weight": "bold",
            })
            .appendTo('#listado_colores');
            $("#colores_informacion").prop('title', data.colores.join(', '));
            $('<div></div>').text(data.colores.join(', ')).appendTo('#listado_colores');
            const opciones_container = $(`<option value="" disabled selected>Seleccione una opción</option>
            <option value="Si">Si</option>
            <option value="No">No</option> `);
            let $opciones_drag = $('#opciones_drag');
            $opciones_drag.empty().append(opciones_container);
            if($vitex_globales.puede_prohibir_colores){
                const opcion_prohibida=$(`<option value="Prohibido">Prohibido</option>`);
                $('#opciones_drag').append(opcion_prohibida);
            }
            $opciones_drag.prop('disabled', false);
            opciones=data.opciones;
            $('.bg-selected').removeClass('bg-selected');
            opciones.forEach(opcion => {
                //buscando el elemento en el clasificame
                let element= $(`li[data-clasificaid=${opcion}]`);
                if(element.hasClass('bg-warning-updt'))return;
                element.addClass('bg-selected');
                element.attr('title', `El color ${element.find('.clasificameLabel').text()} esta en el grupo ${nombre_grupo}`);
            });
        })
        .fail(function(jqXHR, textStatus, errorThrown) {
            ia.alertError(`Problemas al comunicarme con el server: <ul><lI>${errorThrown}<li>${textStatus}</ul>`, "Error", true);
            console.log('ajax failed: ' + this.url, arguments);
        });

     return opciones;
    }
    sendToColors(e, clasificame, colors_id){
       moveTo= e.target.value;
       colors_id.forEach(color => {
        $(`li[data-clasificaid=${color}]`).removeClass('bg-selected');
        clasificame.clasificame_by_color("moveTo", color, moveTo);
       });

       $('#select_colores').val('');
         $('#opciones_drag').empty().prop('disabled', true);
         $('#colores_informacion').prop('title', 'informacion');

    }
    async get_Color_inactivo_Olla(producto_gral){
        let me= this;
       await $.ajax({
            url: '../backoffice/ajax/get_color_olla.php',
            method: 'POST',
            cache: false,
            data: {accion:'getIncOlla',producto_gral},
            dataType: 'json',
        })
        .done(function(data) {
            if(!data.status) {
                ia.alertError(data.message || "Error inesperado, intente más tarde.", "Error");
                console.log("ajax failed url:", this.url);
                return;
            }
            me.colores_olla=data.coloresOlla;
        })
        .fail(function(jqXHR, textStatus, errorThrown) {
            ia.alertError(`Problemas al comunicarme con el server: <ul><lI>${errorThrown}<li>${textStatus}</ul>`, "Error", true);
            console.log('ajax failed: ' + this.url, arguments);
        });
    };

   async get_colores_permisos(){
        let me = this;
        $.ajax({
            url: '../backoffice/ajax/get_permisos_asigna_colores.php',
            method: 'GET',
            cache: false,
            data: {accion:'getPermiso'},
            dataType: 'json',
        })
        .done(function(data) {
            if(!data.status) {
                ia.alertError(data.message || "Error inesperado, intente más tarde.", "Error");
                console.log("ajax failed url:", this.url);
                return;
            }
            me.#asignaColores = data.permiso;
        })
        .fail(function(jqXHR, textStatus, errorThrown) {
            ia.alertError(`Problemas al comunicarme con el server: <ul><lI>${errorThrown}<li>${textStatus}</ul>`, "Error", true);
            console.log('ajax failed: ' + this.url, arguments);
        });
        return '';
    }
}
