class UserGeneralUtil{ 
    #usuarios = {};
    clasificame = null;

    constructor(){
        this.getusuarios();
    }
    async getusuarios(){
        let me = this;
        await $.ajax({
            url: '/vitex/backoffice/ajax/get_usuares_activos.php',
            method: 'POST',
            cache: false,
            data: {accion:'getUsersActive'},
            dataType: 'json',
        })
        .done(function(data, textStatus, jqXHR) {
            if(!data.status) {
                ia.alertError(data.message || "Error inesperado, intente más tarde.", "Error");
                console.log("ajax failed url:", this.url);
                return;
            }
            me.#usuarios = data.usuarios;
            me.dialogoUsuario();

        })
        .fail(function(jqXHR, textStatus, errorThrown) {
            ia.alertError(`Problemas al comunicarme con el server: <ul><lI>${errorThrown}<li>${textStatus}</ul>`, "Error", true);
            console.log('ajax failed: ' + this.url, arguments);
        });
    }
    dialogoUsuario(){
        console.log($vitex_globales);
        if (!$vitex_globales.tipo_rony) return;
        let me = this;
        $('.ui-dialog-titlebar-close:visible').trigger('click');
        $("#asigna_usuariosDialog").remove();
        $("BODY").append(
            `<div id='asigna_usuariosDialog' class='jqgridcolssorter_dialog'>
            <div id="producto_acciones"style="display: flex;justify-content: space-evenly;align-items: center;flex-wrap: wrap; gap: 10px;">
                <div>Elige un grupo</div>
                <select id="grupo_usuario">
                    <option value=""  >Seleccione un grupo</option>
                </select>
                <div id="nombre_grupo">
                <label for="nombre_grupo" style="margin: 0.5rem">Elija un nombre para su grupo</label>
                    <input type="text" id="titulo_grupo" style="background: white; border: 1px solid #d0d0d0;padding: 0.3rem;" />
                </div>
            </div>

        <div id="contenedor_clasificame"><div id='asignaUser_clasificame'></div></div></div>`
        );
        if ($("#grupo_usuario").length > 0) {
            me.getGrupos('usuarios', $("#grupo_usuario"));

            $('#grupo_usuario').on('change',async function (e) {
                
                me.setGrupoValores(e,'usuarios');
            })
        }

        me.clasificame = $(`#asignaUser_clasificame`).clasificame({
            'clasificacion': [
                {clasificaId:'Si', label:'Si', title:'Agrega a Grupo'},
                {clasificaId:'No', label:'No', title: 'Descartar'},
            ],
            valueId: 'iac_usr_id',
            valueDisplay: 'nick',
            valueColumnKey: 'active',
            values: me.#usuarios,
            title: "Crea Grupo de Usuarios",
            label_sort:'usuarios',
            editable:true,
            modalGroup: true
            
        });

        $("#asigna_usuariosDialog").dialog({
            title:  "Crea Grupo de Usuarios",
            closeOnEscape: true,
            width: 'auto',
            buttons: [
                {
                    text: 'Guardar',
                    icon: 'ui-icon-disk',
                    class: 'none',
                    id: "botonGuardar",
                    click: function() {
                        console.log("boton dentro de dialogo");
                    }
                },
               {
                    text: 'Nuevo',
                    icon: 'ui-icon-plus',
                    click: function() {
                        //obtener valores seleccionados
                        let seleccion= me.clasificame.clasificame("value");
                        //obteniendo los valores seleccionados en si
                        seleccion.Si.forEach(user => {
                            me.clasificame.clasificame("moveTo", user, 'No');
                        });

                        //limpiando el input de nombre de grupo
                        $('#titulo_grupo').val('');

                        //limpiando el select de grupos
                        $("#grupo_usuario").val('');

                        //inhaibilitando el boton de borrar
                        $(".boton-borrar").addClass("ui-button-disabled ui-state-disabled");
                        $(".boton-borrar").prop("disabled", true);

                    }
                },
                {
                    text: 'Borrar',
                    icon: 'ui-icon-trash',
                    class: 'boton-borrar',
                    click: function() {
                        let nombre_del_grupo= $('#titulo_grupo').val();
                        if (nombre_del_grupo==='') {
                            me.putAlerta("Debes seleccionar un grupo", 'error', me);
                            return;
                        }
    
                        $.ajax({
                            url: '/vitex/backoffice/ajax/agrupadorColores.php',
                            method: 'POST',
                            cache: false,
                            data: {accion:'deleteGroup',nombre_del_grupo, tipo:'usuarios'},
                            dataType: 'json',
                        })
                        .done(function(data, textStatus, jqXHR) {
                            if(!data.status) {
                                ia.alertError(data.message || "Error inesperado, intente más tarde.", "Error");
                                console.log("ajax failed url:", this.url);
                                return;
                            }
                            let values= me.clasificame.clasificame("value");
                            $("#titulo_grupo").val("");
                            values.Si.forEach(user => {
                                me.clasificame.clasificame("moveTo", user, 'No');
                            });

                            me.getGrupos('usuarios', $("#grupo_usuario"));
                            me.putAlerta("Se ha eliminado un grupo", 'warning', me);

                            let cuenta= $(".clasificame_count")
                            $('.clasificaTitle').text('Crea un grupo de usuarios');
                            $('.clasificaTitle').append(cuenta);
                        })
                        .fail(function(jqXHR, textStatus, errorThrown) {
                            ia.alertError(`Problemas al comunicarme con el server: <ul><lI>${errorThrown}<li>${textStatus}</ul>`, "Error", true);
                            console.log('ajax failed: ' + this.url, arguments);
                        });
                    },
                    disabled: true,
                    
                },
                {
                    text: 'Cancelar',
                    icon: 'ui-icon-cancel',
                    click: function() {
                        $(this).dialog('close');
                    }
                },
            ],
            
            close: function() {
                $("#asigna_usuariosDialog").remove();
                console.log("cerrando dialogo");
            },
        });
        let boton_guardar_grupos= $(`<button type="button" id="btnUsersGuardar" class="ui-button ui-corner-all ui-widget"><span class="ui-button-icon ui-icon ui-icon-disk"></span><span class="ui-button-icon-space"> </span>Guardar</button>`).insertAfter("#botonGuardar");
        boton_guardar_grupos.on('click', function () {
            let seleccion= me.clasificame.clasificame("value");
            const nombre_del_grupo= $('#titulo_grupo').val();
            if (nombre_del_grupo==='') {
                
                $('#titulo_grupo').css('border', '2px solid #ffbebe');
                me.putAlerta('Debe ingresar un nombre para el grupo', 'error', me);
                return;
            }
            $.ajax({
                url: '/vitex/backoffice/ajax/agrupadorColores.php',
                method: 'POST',
                cache: false,
                data: {accion:`agrupandoColores`, seleccion, nombre_del_grupo, tipo:'usuarios'},
                dataType: 'json',
            })
            .done(function(data, textStatus, jqXHR) {
                if(!data.status) {
                    ia.alertError(data.message || "Error inesperado, intente más tarde.", "Error");
                    console.log("ajax failed url:", this.url);
                    return;
                }
                seleccion.Si.forEach(si => {
                    me.clasificame.clasificame("moveTo", si, 'No');
                });
                me.getGrupos('usuarios', $("#grupo_usuario"));
                $('#titulo_grupo').val('');
                me.putAlerta('Se han guardado los cambios exitosamente', 'success', me);

                let cuenta= $(".clasificame_count")
                $('.clasificaTitle').text('Crea un grupo de usuarios');
                $('.clasificaTitle').append(cuenta);
            })
            .fail(function(jqXHR, textStatus, errorThrown) {
                ia.alertError(`Problemas al comunicarme con el server: <ul><lI>${errorThrown}<li>${textStatus}</ul>`, "Error", true);
                console.log('ajax failed: ' + this.url, arguments);
            });
        });
    };
    setAlerta (msj, tipo) {
        const div= $(`<div>${msj}</div>`);

        let bg_color= tipo==='error' ? 'rgb(255 223 223)' : (tipo==="warning" ? '#fff9cf' : 'rgb(224 255 223)');
        let color= tipo==='error' ? '#c70000' : (tipo==="warning" ? '#ddb000' : 'rgb(34 167 0)');
        div.css({
            'background-color': bg_color,
            'padding': '0.3rem',
            'margin':' 0.8rem 0.3rem',
            'border-left': `5px ${color} solid`,
            'color': color,
            'font-size': '0.7rem',
            'font-weight': 'bold',
            'opacity': '0',
            'width': '100%'
        });
        return div;
    }
    putAlerta (msj, tipo, me) {
        $('.ui-dialog-buttonpane.ui-widget-content.ui-helper-clearfix').css('position','relative');
        let div_alerta= me.setAlerta(msj, tipo);
        div_alerta.css({
            "width": "30%",
            "position": "absolute",
            "top": "0",
           }).animate({opacity: 1});
        setTimeout(function() {
            $('#titulo_grupo').css('border', '1px solid #f4f4f4');
            div_alerta.remove();
        }, 5000)
        $('.ui-dialog-buttonpane.ui-widget-content.ui-helper-clearfix').append(div_alerta)
    }
    getGrupos(tipo, input){
        let me = this;
        $.ajax({
            url: '/vitex/backoffice/ajax/agrupadorColores.php',
            method: 'POST',
            cache: false,
            data: {accion:`getGruposColores`, tipo},
            dataType: 'json',
        })
        .done(function(data, textStatus, jqXHR) {
            if(!data.status) {
                ia.alertError(data.message || "Error inesperado, intente más tarde.", "Error");
                console.log("ajax failed url:", this.url);
                return;
            }
            input.empty();
            input.append(`<option value=""  selected>Seleccione un grupo</option>`);
            input.append(data.opciones);

            
        })
        .fail(function(jqXHR, textStatus, errorThrown) {
            ia.alertError(`Problemas al comunicarme con el server: <ul><lI>${errorThrown}<li>${textStatus}</ul>`, "Error", true);
            console.log('ajax failed: ' + this.url, arguments);
        });
    }
    async setGrupoValores(e, tipo){
        let me = this;
        let id_grupo= e.target.value;
        let values =me.clasificame.clasificame("value");
        values.Si.forEach(user => {
            me.clasificame.clasificame("moveTo", user, 'No');
        });

        if(id_grupo===''){ 
            let cuenta= $(".clasificame_count").clone();
            let resumen= $('.clasificaResumen').clone();
            $('.clasificaTitle')
                .text(`Crea Grupo de Usuarios`)
                .append(cuenta)
                .append(resumen);
            $("#titulo_grupo").val('');
            return;
        }

        await $.ajax({
            url: '/vitex/backoffice/ajax/agrupadorColores.php',
            method: 'POST',
            cache: false,
            data: {accion:`${tipo}Agrupados`, id_grupo, tipo},
            dataType: 'json',
        })
        .done(function(data, textStatus, jqXHR) {
            if(!data.status) {
                ia.alertError(data.message || "Error inesperado, intente más tarde.", "Error");
                console.log("ajax failed url:", this.url);
                return;
            }
            const nombre_grupo= $("#grupo_usuario option:selected").text();

            
            $(".boton-borrar").removeClass("ui-button-disabled ui-state-disabled");
            $(".boton-borrar").prop("disabled", false);
            data.colores.forEach(user => {
                me.clasificame.clasificame("moveTo", user.iac_usr_id, 'Si');
            });
            $('#titulo_grupo').val(nombre_grupo);
            let cuenta= $(".clasificame_count")
            $('.clasificaTitle').text(`Grupo: ${nombre_grupo}`);
            $('.clasificaTitle').append(cuenta);


        })


        .fail(function(jqXHR, textStatus, errorThrown) {
            ia.alertError(`Problemas al comunicarme con el server: <ul><lI>${errorThrown}<li>${textStatus}</ul>`, "Error", true);
            console.log('ajax failed: ' + this.url, arguments);
        });
   
    }
}