var calculaPorcentaje = {};
calculaPorcentaje.vars= {
    numero:null,
    tasa: null,
    resultado: null,
    totalGral: 0,
    history: []
};

calculaPorcentaje.metodos = {

    init: function () {
        calcMethods.events();
    },
    events: function () {
       $('#calcPorcentaje').on('click', calcMethods.creandoDialogo);
    },

    creandoDialogo: function(){
        let dialogo =
            $('<div></div>',
                {
                    title: 'Calculadora de porcentajes',
                    id:'dialogoCalculadora'
                }
            );

        let  bodyDialogo = $('<div></div>', {class:'p-4 w-full'});

        let title = $('<h3></h3>',{text:'Calculadora de Markdown, comisiones', class:'text-center font-bold'});
        let divNumero = $('<div></div>',{class:'form-group flex flex-col items-center text-center mb-3'});

        let labelNumero = $('<label></label>',{text:'Digite la cantidad bruta', for:'Calcnumero', class:'mb-2'});
        let inputNumero = $('<input>',{type:'text', class:'form-control w-80 border-gray-400', id:'Calcnumero', name:'Calcnumero'})
        .on('focus', calcMethods.getDato)
        .on('blur', calcMethods.setDatos)
        .on('change', calcMethods.leerDatos);
        inputNumero.autoNumeric('init', {aSep: ',', aDec: '.', mDec: '2', vMin:'-999999999.99', vMax:'999999999.99'});
        divNumero.append(labelNumero, inputNumero);

        let divTasa = $('<div></div>',{class:'form-group flex flex-col items-center text-center mb-3'});
        let labelTasa = $('<label></label>',{text:'Digite el porcentaje', for:'Calctasa', class:'mb-2'});
        let inputTasa = $('<input>',{type:'text', class:'form-control w-80 border-gray-400', id:'Calctasa', name:'Calctasa'})
            .on('focus', calcMethods.getDato)
            .on('blur', calcMethods.setDatos)
            .on('change', calcMethods.leerDatos);
        inputTasa.autoNumeric('init', {aSep: ',', aDec: '.', mDec: '8', vMin:'-999999999.99', vMax:'999999999.99', pSign: 's', aSign:'%'});
        divTasa.append(labelTasa, inputTasa);

        let divResultado = $('<div></div>',{class:'form-group text-center flex flex-col items-center mb-3'});
        let labelResultado = $('<label></label>',{text:'Comisión', for:'Calcresultado', class:'mb-2'});
        let inputResultado = $('<input>',{type:'text', class:'form-control w-80 border-gray-400', id:'Calcresultado', name:'Calcresultado'})
            .on('focus', calcMethods.getDato)
            .on('blur', calcMethods.setDatos)
            .on('change', calcMethods.leerDatos);
        inputResultado.autoNumeric('init', {aSep: ',', aDec: '.', mDec: '2', vMin:'-999999999.99', vMax:'999999999.99'});

        let total = $('<div></div>',{class:'form-group text-center flex flex-col items-center mb-3'});
        let labelTotal = $('<label></label>',{text:'Total', class:'font-bold'});
        let inputTotal = $('<input>',{type:'text', class:'form-control w-60 border-gray-400', id:'CalcTotal', name:'CalcTotal'})
            .on('focus', calcMethods.getDato)
            .on('blur', calcMethods.setDatos)
            .on('change', calcMethods.leerDatos);
        inputTotal.autoNumeric('init', {aSep: ',', aDec: '.', mDec: '2', vMin:'-999999999.99', vMax:'999999999.99'});
        total.append(labelTotal, inputTotal);

        divResultado.append(labelResultado, inputResultado);
        let divHistorial = $('<div></div>',{class:'form-group text-center flex flex-col items-center mb-3', id:'CalcHistorial'});
        let pHisstorial = $('<p></p>',{text:'Historial', class:'mb-2'})
        let contHistorial = $('<div></div>',{class:'overflow-y-auto h-120 w-80 border-gray-400 bg-gray-600', text:'Aun no hay historial', id:'contHistorial'});
        divHistorial.append(pHisstorial, contHistorial);

        bodyDialogo.append(title, divNumero, divTasa, divResultado,total, divHistorial);
        dialogo.append(bodyDialogo);
        let callback= calcMethods.leerDatos;

        let objBtns= {
            Calcular: function(){
                callback();
            },
            Limpiar: function(){
                $('#Calcnumero').val('');
                $('#CalcTotal').val('');
                $('#Calctasa').val('');
                $('#Calcresultado').val('');
            },
            Cerrar: function(){
                $(this).remove();
            }
        };
        calcMethods.calcDialogo(dialogo, callback, {width: 600}, objBtns);
    },
    leerDatos: function(e){
        let numero = $('#Calcnumero').autoNumeric('get');
        let total = $('#CalcTotal').autoNumeric('get');
        let tasa = $('#Calctasa').autoNumeric('get');
        let resultado = $('#Calcresultado').autoNumeric('get');

        /*
        let valores= [numero, tasa, resultado, total];
       //contando vacios
         let vacios= valores.filter(valor=> valor==='').length;
         if(vacios===3){
            calcMethods.footAlert('Debe ingresar al menos 2 valores', 'warning');
             return;
         }
         if(!vacios)return calcMethods.footAlert('Ya esta hecho el calculo', 'warning');
         */
         if(numero !== '') {
             numero = parseFloat(numero);
             if(tasa !== '') {
                 tasa = parseFloat(tasa);
                 resultado = numero * tasa/100.00;
                 total = numero - resultado;
             }
             else if(resultado !== '') {
                 resultado = parseFloat(resultado);
                 tasa = resultado/numero * 100.00;
                 total = numero - resultado;
             }
             else if(total !== '') {
                 total = parseFloat(total);
                 resultado = numero - total;
                 tasa = resultado/numero * 100.00;
             } else {
                 calcMethods.footAlert('Debe ingresar al menos 2 valores', 'warning');
                 return;
             }
         } else if(tasa !== '') {
             tasa = parseFloat(tasa);
             if(resultado !== '') {
                 resultado = parseFloat(resultado);
                 numero = tasa / resultado * 100.00 * 100.00;
                 total = numero - resultado;
             } else if(total !== '') {
                 total = parseFloat(total);
                 numero = total / (1 - tasa / 100.00);
                 resultado = numero - total;
             } else {
                 calcMethods.footAlert('Debe ingresar al menos 2 valores', 'warning');
                 return;
             }
         } else if(resultado !== '') {
             resultado = parseFloat(resultado);
             if(total !== '') {
                 console.log("con resultado y total");
                 total = parseFloat(total);
                 numero = parseFloat(total) + resultado;
                 tasa =  resultado/numero*100.00;
             } else {
                 calcMethods.footAlert('Debe ingresar al menos 2 valores', 'warning');
                 return;
             }
         } else {
             calcMethods.footAlert('Debe ingresar al menos 2 valores', 'warning');
             return;
         }

        $('#Calcnumero').autoNumeric('set', numero);
        $('#Calcresultado').autoNumeric('set', resultado);
        $('#Calctasa').autoNumeric('set', tasa);
        $('#CalcTotal').autoNumeric('set', total);

        /*
        numero= calcMethods.verificandoDecimales(numero);
        tasa= calcMethods.verificandoDecimales(tasa);
        resultado= calcMethods.verificandoDecimales(resultado);
        total= calcMethods.verificandoDecimales(total);
        */
         //construir el historial
         let objHistorial = {
             numero:$('#Calcnumero').val(),
             tasa:$('#Calctasa').val(),
             resultado:$('#Calcresultado').val(),
             total:$('#CalcTotal').val(),
         };

        calcVars.history= [...calcVars.history, objHistorial];

        calcMethods.actualizarHistorial(objHistorial);

    },

    verificandoDecimales: function(numero){
        if(numero.toString().indexOf('.')===-1){
            return  parseFloat(numero).toFixed(2);
        }

        //veridficando la extensión de los decimales
        let decimales= numero.toString().split('.')[1];
        if(decimales.length>8){
            numero= numero.toFixed(8);
        }

        return numero;
    },

    getDato: function(e){
        let name= e.target.name;
        calcVars[name]= e.target.value;
        if($(e.target).val()!==''){
            $(e.target).select();
        }
    },
    setDatos: function(e){

        let name= e.target.name;
        if(!name) return;
        let valor= e.target.value;
        //quitando los caracteres de formato
        valor= valor.replace(/,/g,'');
        valor= parseFloat(valor);

        if(isNaN(valor)) valor='';

        $(`#${name}`).autoNumeric('set',valor);
        
    },

    actualizarHistorial(historial){

        let containerHist= $('#contHistorial');
        if(containerHist.hasClass('bg-gray-600')){
            containerHist.removeClass('bg-gray-600');
            containerHist.empty();
        }

        let {numero, tasa, resultado,total}= historial;
        

        $('.bg-primary-500').removeClass('bg-primary-500');

        let divHistorial = 
            $('<div></div>',
                {
                    class:'flex  justify-between items-center bg-primary-500',
                    "data-numero": numero,
                    "data-tasa": tasa,
                    "data-resultado": resultado,
                    "data-total": total

                })
            .on('click', calcMethods.setDatosHistorial);
/*
        //formateando los numeros
        numero= Intl.NumberFormat('en-US', 
            {style:'currency', currency:'USD'}).format(numero);
        resultado= Intl.NumberFormat('en-US', 
            {style:'currency', currency:'USD'}).format(resultado);
*/


        let pNumero = $('<p></p>',{text:'Numero: ',class:'font-bold m-0 p-2 border-b-gray-400'});
        let spanNumero = $('<span></span>',{text:numero, class:'font-normal'});

        pNumero.append(spanNumero);

        let pTasa = $('<p></p>',{text:'Tasa: ', class:'font-bold m-0 p-2 border-b-gray-400'});
        let spanTasa = $('<span></span>',{text:tasa, class:'font-normal'});
        pTasa.append(spanTasa);

        let pResultado = $('<p></p>',{text:'Comisión: ', class:'font-bold m-0 p-2 border-b-gray-400'});
        let spanResultado = $('<span></span>',{text:resultado, class:'font-normal'});

        pResultado.append(spanResultado);

        let pTotal = $('<p></p>',{text:'Total: ', class:'font-bold m-0 p-2 border-b-gray-400'});
        let spanTotal = $('<span></span>',{text:total, class:'font-normal'});

        pTotal.append(spanTotal);

        divHistorial.append(pNumero, pTasa, pResultado, pTotal);

        containerHist.prepend(divHistorial);
        
    },

    setDatosHistorial: function(e){
        let div= $(e.target);
        if(div.is('p')){
            div= div.closest('div');
        }

        //buscando los data 
        let numero= div.data('numero');
        let tasa= div.data('tasa');
        let resultado= div.data('resultado');
        let total= div.data('total');

        $('#Calcnumero').val(numero);
        $('#Calctasa').val(tasa);
        $('#Calcresultado').val(resultado);
        $('#CalcTotal').val(total);
    },

    footAlert: function (message, type, time=3000) {
        $div_dialogo= $('div.ui-dialog-buttonpane').css('position', 'relative');

        let div_alert= $('<div></div>', {class: `alert alert-${type}`, text: message});

        $div_dialogo.append(div_alert);

        setTimeout(() => {
            div_alert.remove();
        }, time);
 
    },


    calcDialogo: function (dialogo, callback, objConf={}, objBtns={}) {


        //si no se mandan botones se crean los botones por defecto
        if(Object.keys(objBtns).length===0){
            objBtns= {
                Aceptar: function () {
                    callback($(this));
                },
                Cancelar: function () {
                    $(this).remove();
                }

            };
        }

        dialogo.dialog({
            modal: false,
            ...objConf,
            buttons: objBtns,
            close: function () {
                $(this).remove();
            }
        });

    },
    footAlert: function (message, type, time=3000) {
        $div_dialogo= $('div.ui-dialog-buttonpane').css('position', 'relative');

        let div_alert= $('<div></div>', {class: `alert alert-note-${type}`, text: message});

        $div_dialogo.append(div_alert);

        setTimeout(() => {
            div_alert.remove();
        }, time);

    },
};

var calcMethods= calculaPorcentaje.metodos;
var calcVars= calculaPorcentaje.vars;

$(function () {
    calcMethods.init();
});