/**
  $("<DIV id='gato' style='clear:both'>").appendTo("BODY");
  $("#gato").aGrupa({
      editable:true,
      grupo:'Areas',
      grupoLabel:'Areas',
      subGrupoTable:'otra',
      sub_grupo:[

          {id:'id',label:'Bodegas', elements:[{id:'69',label:'Ale', title:'Alejandra',addClass:''}]},
          {id:'id2',label:'Tiendas', elements:[{id:'129',label:'php', title:'',addClass:''}]},
           {id:'Sin',label:'Sin', },
          {id:'id3',label:'Supervision', elements:[{id:'id3',label:'Victor', title:'Victor Cazares',addClass:'c_usuarioTipoRony'}]},
      ],
  });
  console.log("gato getValues", $("#gato").aGrupa("getValues"));


 elements:[{id:'69',label:'Ale', title:'Alejandra',addClass:''}]
 */

$.widget( "vitex.aGrupa", {
    version: function () {
        return "1.0.0 2022-12-19";
    },

    options: {
        grupo:'',
        grupoLabel:'',
        sub_grupo:[], // [{id:'id',label:'Grupo Tal', elements:{id:'id',label:'label', title:'',addClass:'classNames'}}, ]
        subGrupoTable:'agrupa',
        elementTable:'iac_usr',
        multipleGroups:false,

        editable:true,
        grupoNadaId:'Sin',

        urlRead:'',
        urlEdit:'',

        draggable:{
            scroll: true,
            cancel: ".noDrag", // clicking div toolbar no inicia drag
            revert: "invalid", // when not dropped, the item will be returned to its initial position
            containment: "document",
            helper: "clone",
            cursor: "grabbing",
            start: function( event, ui ) {ui.helper.css({cursor:"grabbing"});},
            end: function( event, ui ) {ui.helper.css({cursor:""});},
            //@see https://api.jqueryui.com/draggable/
        },
        dropabble: {
            classes: {"ui-droppable-active": "custom-state-active"},
            out: function( event, ui ) {
                ui.helper.css({cursor:'grabbing'})
            },
            //@see https://api.jqueryui.com/droppable/
        },
        sortable: {},
        cssClassFieldset:'gpFieldset',
    },

    _create: function() {
        let id = this.options.id = this.element.attr('id');
        if(this.options.grupoLabel === '')
            this.options.grupoLabel = this.options.grupo;
        let addNewSubGroup = this.options.editable && this.options.subGrupoTable === 'agrupa' ?
            `&nbsp;&nbsp;<span id="_a${id}" class="ui-icon ui-icon-plus click"></span>&nbsp;&nbsp;` : '';
        this.element.append(
            $(`<fieldset style="display:flex;" class="${this.options.cssClassFieldset}">
             <legend>${this.options.grupoLabel} ${addNewSubGroup}</legend>
            </fieldset>`)
        );
        let addSin = true;
        for(let g in this.options.sub_grupo)
            if(this.options.sub_grupo.hasOwnProperty(g) &&
                this.options.grupoNadaId === this.options.sub_grupo[g].id) {
                    addSin = false;
                    break;
                }
        if(addSin)
            this._addGrupo('Sin', 'Sin');

        for(let g in this.options.sub_grupo)
            if(this.options.sub_grupo.hasOwnProperty(g)) {
                let sub_grupo = this.options.sub_grupo[g];
                this._addGrupo(sub_grupo.id, sub_grupo.label || sub_grupo.id);
                if(typeof sub_grupo.elements === 'undefined')
                    continue;
                for(let it in sub_grupo.elements)
                    if(sub_grupo.elements.hasOwnProperty(it)) {
                        let item = sub_grupo.elements[it];
                        $(`#u${sub_grupo.id}`, this.element).append(
                            $(`<dt data-id='${item.id}'>`)
                                .attr("title", item.title || '' )
                                .addClass(item.addClass || '').html(item.label || item.id)
                        );
                    }
            }

        if(this.options.editable) {
            let element = this.element;
            $(`#_a${id}`, this.element).on('click', function () {
                element.aGrupa('addGrupo');
            });
        }
        this._dragDropInit();
    },

    addGrupo: function() {
        if(!this.options.editable)
            return;
        let me = this;
        ia.form(`Nombre: <input class="catInput" required="required" name='usrCatalogName' type='text' value=''>
                <input type="hidden" name="usrCatalogId" value='33'>"`,
            `Nueva ${this.options.grupoLabel}`
        ).done(function(values) {
            me._addGrupo(values.usrCatalogId, values.usrCatalogName);
            me._dragDropInit();
        });
    },

    _addGrupo: function(id, label) {
        let readonly='';
        let trash = this.options.grupoNadaId === id ? '' : `<span class="ui-icon ui-icon-trash click" id="t${id}"></span>`;
        if(!this.options.editable || this.options.subGrupoTable !== 'agrupa') {
            trash = '';
            readonly="READONLY='READONLY'";
        }
        let $div = $(
        `<div data-id="${id}" class="catTitle"><span>
            <input ${readonly} class="catInput" required="required" type="text" style="width:10em" value="${label}" data-id="${id}" id="i${id}"> ${trash}
            </span><dl id="u${id}" class="catItemList"></dl>
        </div>`);
        let element = this.element;
        if(id === this.options.grupoNadaId)
            element.children("FIELDSET").first().prepend($div);
        else
            element.children("FIELDSET").first().append($div);
        $(`#t${id}`, element).on('click', function(){
            element.aGrupa("remove", id);
        });
    },

    _dragDropInit:function() {
        if(!this.options.editable)
            return;
        let optionsDropabble = this.options.droppable;
        let optionsDraggable = this.options.draggable;
        let optionsSortable = this.options.sortable;
        let limitTo = this.element.attr('id');
        this.element.children("FIELDSET").first().children("DIV").children("DL").each(function(){
            let $dl = $(this);
            $( "dt", $dl).sortable(optionsSortable);
            $dl.droppable(
                $.extend(
                    {
                        accept: `#${limitTo} FIELDSET DIV dl dt`,
                        drop: function( event, ui ) {
                            $(event.target).append(ui.draggable);
                        },
                        connectToSortable: $dl.attr('id')
                    },
                    optionsDropabble
                ));

            $( "dt", $dl).draggable(optionsDraggable);
        });
    },

    remove: function(id) {
        if(!this.options.editable)
            return;
        let element = this.element;
        let label = $(`#i${id}`).val().trim();
        ia.confirmDelete(`¿Elimino ${this.options.grupoLabel}: ${label}?`).done(function(){
            $(`#u${id}`).children().each(function(){
                $(this).appendTo(`#u${element.aGrupa("option", "grupoNadaId")}, element`);
            });
            $(`DIV[data-id='${id}']`, element).remove();
        });
    },

    getValues: function() {
        let values = [];
        this.element.children("FIELDSET").first().children("DIV").each(function (){
            let $this = $(this), id = $this.data('id'), elements = [];
            $this.children("DL").first().children().each(function(){
                elements.push($(this).data("id"));
            });
            values.push({id:id, label:$(`INPUT[data-id='${id}']`, $this).val().trim(), elements:elements });
        });
        return {
            grupo:this.options.grupo,
            elements:values
        };
    },

    _destroy: function() {
        this.element.html("");
    },

});


