// noinspection JSPotentiallyInvalidUsageOfThis
// ⬐ ↴ ⤵ ↕

/**
 *
 * Permite mostrar items (id, label, clasificación) en su columna de clasificación, cambiarlos de columna y obtener
 * en que columna quedaron con $("#id").clasificame("value")
 *
 * $("#id").claseificame({
 *             'clasificacion': [
 *             {clasificaId:'Nada', label:'X', title:'Sin Permiso', userSortable:false,},
 *             {clasificaId:'RO', label:'RO', title:'Sólo Lectura', userSortable:true,},
 *             {clasificaId:'RW', label:'RW', title:'Editar', userSortable:function(a,b){return $(b).text().toUpperCase() < $(a).text().toUpperCase() ? 1 : -1},}
 *         ],
 *         liButtons:true, // botones en cada li para brincar de una a otra sin drag
 *         valueId:'user_id', // ie iac_user_id
 *         valueDisplay:'nick', // ie nick
 *         valueColumnKey:'permiso', // puede_editar has values: Nada, RO o RW
 *         'values': [],
 *              // [  {user_id:1, name:'Mary',permiso:'Nada',},],
 *              // o  {1:{name:'Mary',permiso:'RO',},],
 *              // o  {uniqueValue:{user_id:1,name:'Mary',permiso:'Nada',},],
 *              // o {11:"Mary", 12:"Joe",}
 * }); // ver options
 * $("#id").clasificame("value"); => {Nada:[id1, id2,], RO:[], ...}
 *
 * ver ejemplo_clasificame.html en esta carpeta
 *
 * public: method:function
 * privates: _method:function
 */
$.widget( "vitex.clasificame", {
    version:function() {return "2.0.3 2024-08-16";},
    Iam:this, 
    options: {
        clasificacion: [
            {clasificaId:'Nada', label:'X', title:'Sin Permiso', userSortable:false,},
            {clasificaId:'RO', label:'RO', title:'Sólo Lectura', userSortable:false,},
            {clasificaId:'RW', label:'RW', title:'Editar', userSortable:false,}
        ],
        valueId:'user_id', // ie iac_user_id
        valueDisplay:'nick', // ie nick
        valueColumnKey:'permiso', // puede_editar has values: Nada, RO o RW
        nada:'No',
        liButtons:true,
        title:null,
        label_sort:'registros',
        permiso_prohibido: $vitex_globales.puede_prohibir_colores  || false,
        values: [],
        sortGroup: [],
        modalGroup: false,
        resumen: '',
        // [  {user_id:1, name:'Mary',permiso:'Nada',},],
        // o  {1:{name:'Mary',permiso:'RO',},],
        // o  {uniqueValue:{user_id:1,name:'Mary',permiso:'Nada',},],
        // o {11:"Mary", 12:"Joe",}
        editable:true,
        sortable: {
            connectWith: ".clasificaItemList",
            helper: "clone",
            placeholder: "plaz",
            forcePlaceholderSize:true,
            containment: "document",
            dropOnEmpty: true,
            scroll:true,
            over: function( event, ui ) {
                if(ui.helper !== null)
                    ui.helper.css({cursor:'grabbing'});
            },
            out: function( event, ui ) {
                if(ui.helper !== null)
                    ui.helper.css({cursor:'no-drop'});

            },
            stop: function(event, ui) {
                let $element =$(event.target);
                let sortType = $element.data('clasificame')['userSortable'];
                if(sortType === true)
                    return;
                if(typeof sortType !== 'function')
                    sortType = function(a, b) {
                        return $(b).text().toUpperCase() < $(a).text().toUpperCase() ? 1 : -1;
                    };
                $("li", $element).sort(sortType).appendTo($element);
            }
        },

        grupoMandaA: 'label', // En el select Grupo Manda A poner clasificaId, label (el botón), title (título cajita)
        groups: {
            url: '/vitex/backoffice/ajax/agrupadorColores.php',
            itemType: 'usuarios',
            getGroups: 'getGruposColores',
            getItemsByGroup: 'getUserByGrupo',
        },
        getGrupos: {
            url: '/vitex/backoffice/ajax/agrupadorColores.php',
            accion: 'getGruposColores',
            tipo: "usuarios",
        },
        getGruposItems: {
            url: '/vitex/backoffice/ajax/agrupadorColores.php',
            accion: 'getUserByGrupo',
            tipo: "usuarios",
        },
    },
    _selector: ".clasificaItemList",

    _create: function() {
        this.valueId = this.options.valueId;
        this.valueDisplay = this.options.valueDisplay;
        this.valueColumnKey = this.options.valueColumnKey;
        let me = this;
        // create html
        this.element.html(this._html());

        for(const ba in this.options.clasificacion)
            if(this.options.clasificacion.hasOwnProperty(ba)) {
                $(`UL[data-clasificame='${ba}']`).data('clasificame', this.options.clasificacion[ba])
            }
        $(".clasificaAllTo", this.element).on('click',e=>this._allTo(e));
        $(".clasificaFind", this.element).on('keyup',function(event){
            me._find(event, me.element);
        });
        me._llenandoGroup($("#select_grupos", this.element));
        let select_group=$("#select_grupos", this.element);
        let select_opc=$("#opciones_drag", this.element);
        $("#select_grupos", this.element).on('change',()=>select_opc.prop('disabled',false));
        select_group.on('change',e=>me._llenandoItems(e));
        select_opc.on('change',e=>me._llenandoUsers(e));
        $(".clasificaFindClear", this.element).on('click',this._findClear);

        $('i').tooltip();

        if(typeof this.options.values !== 'undefined')
            this._addValuesDo(this.options.values);

        let _selector = this._selector;
        let optionsSortable = this.options.sortable;
        let limitTo = this.element.attr('id');
        // activate html
        $(this._selector, this.element).each(function(){
            const $this  = $(this);
            $this.sortable(
                $.extend(
                    {},optionsSortable,
                {
                    connectWith: ".clasificaItemList",
                    helper: "clone",
                    placeholder: "plaz",
                    forcePlaceholderSize:true,
                    containment: "document",
                    dropOnEmpty: true,
                    scroll:true,
                    cancel:'.con_existe',
                    over: function(event, ui ) {
                        const spanText = $(ui.item).find('.clasificameLabel').text();
                        const palabraFind = 'Con ∃';
                        // if(spanText.includes(palabraFind))
                        if(ui.helper !== null)
                            ui.helper.css({cursor:'grabbing'});
                            
                    },
                    out: function( event, ui ) {
                        let permiso= $vitex_globales.puede_prohibir_colores || false;
                        if(ui.item.parent().data("clasificakey")==='Prohibido' && !permiso) {
                            event.preventDefault()
                            return ;
                        }
                        if(ui.helper !== null)
                            ui.helper.css({cursor:'no-drop'});
                            let item_actual=ui.item;
                            let id_key_data=$(this).attr('data-clasificakey');

                            item_actual.find('.noDrag span').removeClass('pressed');
                            item_actual.find('.noDrag').find(`[data-clasificato="${id_key_data}"]`).addClass('pressed');

                    },
                    stop: function(event, ui) {
                        let permiso= $vitex_globales.puede_prohibir_colores || false;
                        if(ui.item.parent().data("clasificakey")==='Prohibido' && !permiso) {
                            event.preventDefault()
                            return ;
                        }
                        let $element =$(event.target);
                        let data = $element.data('clasificame');
                        let sortType = typeof data.userSortable !== 'undefined' ? data.userSortable: true;
                        if(sortType === true)
                            return;
                        if(typeof sortType !== 'function')
                            sortType = function(a, b) {
                                return $(b).text().toUpperCase() < $(a).text().toUpperCase() ? 1 : -1;
                            };
                       $("li", $element).sort(sortType).appendTo($element);
                    },
                    receive: function(event, ui) {
                        let permiso= $vitex_globales.puede_prohibir_colores || false;
                        if(ui.item.parent().data("clasificakey")==='Prohibido' && !permiso) {
                            console.log(ui.item.find('span.pressed'));
                            event.preventDefault();
                            return ;
                        }
                        const registros=$('.numero_registros');
                         let nombre_label_registro= registros.data('label-registro');
                         let set_name_label= nombre_label_registro.replace('_',' ');
                         registros.remove();
                         const $list= $('.clasificaFlexItem ul',this.element);
                             $list.each(function () {
                                 const numero_hijos=$(this).find('li').filter(':visible').length ;
                                const div_conteo=$(`<div class="numero_registros" data-label-registro="${nombre_label_registro}"><p>Mostrando:</p> <span>${numero_hijos}  ${set_name_label}</span></div>`);
                                div_conteo.insertAfter($(this));
                             })
                    }

                }
                )

            ).disableSelection();
        });
        if(!this.options.editable)
            this.readonly();
        this._addGlobalSearch();
    },

    _destroy: function() {
        this.element.html("");
    },

    /**
     * Get or Set an option.
     *
     * @param {string} name
     * @param {string|undefined} value
     * @returns {vitex.clasificame|{valueColumnKey: string, valueDisplay: string, liButtons: boolean, valueId: string, nada: string, editable: boolean,label_sort: string, values: [], clasificacion: [{label: string, title: string, clasificaId: string, userSortable: boolean},{label: string, title: string, clasificaId: string, userSortable: boolean},{label: string, title: string, clasificaId: string, userSortable: boolean}], sortable: {containment: string, receive: function(*, *): void, connectWith: string, helper: string, dropOnEmpty: boolean, scroll: boolean}, title: null}|*|null}
     */
    option:function(name, value) {
        if(typeof value === "undefined") {
            if(name === 'options' || name === 'option')
                return this.options;
            if(this.options.hasOwnProperty(name))
                return this.options[name];
            return null;
        }
        let ro = {valueId:true,valueDisplay:true, valueColumnKey:true,values:true};
        if(ro.hasOwnProperty(name))
            throw 'Attempt to change Read Only Option: ' + name;
        this.options[name] = value;
        if(name === 'editable')
            if(value) {
                let $elem = $(this.element);
                $elem.find(".clasificaToolBar").each(function(){$(this).show();});
                $elem.find(".clasificaAllTo").each(function(){$(this).show();});
                $elem.find(".clasificaItemDontMove").removeClass("clasificaItemDontMove").
                    addClass("clasificaItemMove");
                this.refresh();
            }
            else
                this.readonly();
        return this;
    },

    addValues:function(values) {

        this._addValuesDo(values, false);
        this.refresh();
    },

    /**
     * convert to readonly
     */
    readonly:function() {
        this.options.editable = false;
        $(this._selector, this.element).each(function(){
            $(this).sortable("option", "disabled", true).sortable("destroy");
        });
        let $elem = $(this.element);
        $elem.find(".clasificaToolBar").each(function(){$(this).hide();});
        $elem.find(".clasificaAllTo").each(function(){$(this).css('visibility','hidden');});
        $elem.find(".clasificaItemMove").removeClass("clasificaItemMove").addClass("clasificaItemDontMove");
    },

    refresh:function() {
        if(!this.options.editable)
            return;
        var me = this;
        $(this._selector, this.element).each(function(){
            const $this  = $(this);
        });
    },


    allTo: function(toClasificaId) {
        console.log("Clasificame: allTo", toClasificaId);
        if(!this.options.editable) {
            console.log("Error Clasificame: Can't do: editable = false");
            return;
        }
        if(typeof toClasificaId === 'undefined') {
            console.log("Error Clasificame: this.allTo()", "Missing parameter toClasificaId");
            return;
        }

        let $to =  $(`.clasificaItemList[data-clasificakey='${toClasificaId}']`, this.element);
        if($to.length === 0) {
            console.log("Error Clasificame: this.allTo()", "Invalid clasificaId ", toClasificaId);
            return;
        }

        let me = this;
        $(this._selector, this.element).each(function() {
            let $this = $(this);
            if($this.data('clasificakey') !== toClasificaId) {
                $this.find("LI").each(function (){
                    let $li = $(this);
                    if ($li.hasClass('con_existe')) return;
                   
                    me._toolbarUnpress($li);
                    $li.find(`SPAN[data-clasificato='${toClasificaId}']`).addClass('pressed');
                    
                    if($li.is(":visible")) {
                        $to.append($li);
                        $li.hide().toggle("up");
                    }
                });
            }
        });
        this._sortMe($to);
    },

    fromTo: function(fromClasificaId, toClasificaId) {
        if(!this.options.editable) {
            console.log("Error Clasificame: Can't do: editable = false");
            return;
        }
        if(typeof fromClasificaId === 'undefined' || typeof toClasificaId === 'undefined') {
            console.log("Error Clasificame: this.fromTo(fromClasificaId, toClasificaId)", "Need 2 parameters fromClasificaId, toClasificaId");
            return;
        }
        let $from =  $(`.clasificaItemList[data-clasificakey='${fromClasificaId}']`, this.element);
        if($from.length === 0) {
            console.log("Error Clasificame: this.fromTo(fromClasificaId, toClasificaId)", "Invalid fromClasificaId: ", fromClasificaId);
            return;
        }
        let $to =  $(`.clasificaItemList[data-clasificakey='${toClasificaId}']`, this.element);
        if($to.length === 0) {
            console.log("Error Clasificame: this.fromTo(fromClasificaId, toClasificaId)", "Invalid toClasificaId ", toClasificaId);
            return;
        }

        let me = this;
        $from.find("LI").each(function(){
            let $this = $(this);
            me._toolbarUnpress($this);
            $this.find(`SPAN[data-clasificato='${toClasificaId}']`).addClass('pressed');
            $to.append($(this));
        });
        me._setConteo(null, me);
    },

    value:function() {
        let ret = {};
        $(this._selector, this.element).each(function() {
            let $this = $(this);
            let clasif = $this.data("clasificakey");
            ret[clasif] = [];
            $this.find("LI").each(function (){
                let id = $(this).data("clasificaid");
                if(typeof id !== 'undefined')
                    ret[clasif].push(id);
            });
        });
        return ret;
    },

    clear:function() {
        $(this._selector, this.element).each(function() {
            let $this = $(this);
            $this.find("LI").each(function (){ $(this).remove(); });
        });
    },

    _allTo: function(event, me=this) {
        let elementId = $(event.target).data('clasificaelementid');
        $(`#${elementId}`).clasificame("allTo", $(event.target).data('clasificakey'));
        const registros=$('.numero_registros', me.element);
        let nombre_label_registro= registros.data('label-registro');
        let set_name_label= nombre_label_registro.replace('_',' ');
        registros.remove();
        const $list= $('.clasificaFlexItem ul',this.element);
            $list.each(function () {
                const numero_hijos=$(this).find('li').filter(':visible').length ;
               const div_conteo=$(`<div class="numero_registros" data-label-registro="${nombre_label_registro}"><p>Mostrando:</p> <span>${numero_hijos}  ${set_name_label}</span></div>`);
               div_conteo.insertAfter($(this));
            });
    },

    _addValuesDo:function(values, agrega_flechas = true) {
        let me = this;
        let en = {};
        let nada = this.options.nada;
        let editable = this.options.editable;
        const resumen= this.options.resumen;
        let style = this.options.editable ? " style='cursor:grab'" : "";
        const labelMostrando= this.options.label_sort;
        const data_mostrando= labelMostrando.replace(' ','_');
        let total_registros = Array.isArray(values) ? values.length : 0;
        let total_registros_add = !Array.isArray(values);
        //poner permiso
        let permiso_colores= $vitex_globales.puede_prohibir_colores || false;
        $('.numero_registros',this.element).remove();
        $('.clasificame_count',this.element).remove();
        for (let v in values)
            if (values.hasOwnProperty(v)) {
                let id, label, clasificaId;
                let cssClass = '';
                let title = '';
                if (typeof values[v] === 'object') {
                    let item = values[v];
                    id = typeof item[this.valueId] === 'undefined' ? v : item[this.valueId];
                    label = typeof item[this.valueDisplay] === 'undefined' ? id : item[this.valueDisplay];
                    clasificaId = typeof item[this.valueColumnKey ] === 'undefined' ? nada : item[this.valueColumnKey];
                    if((item['usuario_tipo_rony'] || '') === 'Si')
                        cssClass = 'c_usuarioTipoRony';
                    title = item['title'] || ''
                } else {
                    id = v;
                    label = values[v];
                    clasificaId = nada;
                }

                let $to = $(`.clasificaItemList[data-clasificakey='${clasificaId}']`, this.element);
                // si no viene ponlo en el default, que es this.options.nada
                if($to.length === 0) {
                    clasificaId = nada;
                    $to = $(`.clasificaItemList[data-clasificakey='${clasificaId}']`, this.element);
                }
                if($to.length) {
                    en[$to.attr("id")]=$to;
                    let elementId = this.element.attr('id');
                    let $li = $(`<li title="${title}" class="${cssClass}" ${style} data-container='${clasificaId}' data-clasificaconteiner="${elementId}" data-clasificaid="${id}"><span class="clasificameLabel">${label}</span></li>`);
                    $('.con_existe').tooltip();
                    if($li.text().includes('(Con ∃)') && $to.parent().data('clasificacontainer')==='Si'){
                         $li.addClass('con_existe');
                         $li.attr('title', 'Este elemento no puede ser movido');
                        }
                    if($li.data("container")==='Prohibido' && !permiso_colores)$li.addClass('con_existe');
                    if($li.data("container")!=='Prohibido' || permiso_colores){
                        let toolbar = this._toolbar(clasificaId);
                        if(toolbar.length)
                            $li.append($(toolbar).on('click',this._clickTo));
                    }
                    $to.append($li.on('click', this._clickTo));
                    if(total_registros_add)
                        ++total_registros;
                }
            }
            const $list= $('.clasificaFlexItem ul',this.element);
            const first_element=$('.clasificaFlexItem ul',this.element).first().data('clasificakey');
            const last_element=$('.clasificaFlexItem ul',this.element).last().data('clasificakey');

            $list.each(function () {
                let data_ant= $(this).parent().prev().data('clasificacontainer');
                let data_next= $(this).parent().next().data('clasificacontainer');
               let anterior_elemento=data_ant ?? last_element;
               let siguiente_elemento=data_next ?? first_element;

               const numero_hijos=$(this).children().length ;


               const div_conteo=$(`<div class="numero_registros" data-label-registro="${labelMostrando.replace(' ','_')}"><p>Mostrando:</p> <span>${numero_hijos}  ${labelMostrando}</span></div>`);

               const div_flecha=$(`<div><i title="Pasar a ${anterior_elemento}" class="fa-solid fa-circle-arrow-left fa-lg previous" style="color: #ad7600; cursor: pointer;"></i><i title="Pasar a ${siguiente_elemento}" class="fa-solid fa-circle-arrow-right fa-lg next" style="color: #ad7600; cursor: pointer;"></i></div>`)
               .css({
                "display": "flex",
                "justify-content": "space-between",
                "margin-top": "10px",
               });
               if(editable && agrega_flechas)
                    div_flecha.insertAfter($(this));
               div_conteo.insertAfter($(this));
            })
            $('.fa-solid').tooltip();
            const listTemplate= $('.clasificaTitle',this.element).first();

            let $div_total=$(`<p class="clasificame_count">Total: <span>${total_registros} ${data_mostrando}</span></p>`)
            let $resumen_columna=$(`<div class="clasificaResumen">${resumen}</div>`);
            

            listTemplate.append($div_total);
            listTemplate.append($resumen_columna);
        this._allToPrev(this)
        this._allToNext(this)
        for(let e in en)
            if(en.hasOwnProperty(e))
                this._sortMe(en[e]);
    },
    _allToPrev: function(event) {
        let btnPrev= $('.previous', event.element);

        btnPrev.on('click',function (e) {
            let element_actual=$(e.target).parent().parent().find('.clasificaItemList').data('self');
            let prev_element=element_actual-1===-1 ? btnPrev.length-1 : element_actual-1;
            let lista_anterior=$(`.clasificaItemList[data-self='${prev_element}']`, event.element).data('clasificakey');
            //console.log(lista_anterior);
            let lista= $(e.target).parent().parent().find('.clasificaItemList').find('li').not('.con_existe').filter(':visible');

            lista.each(function () {
                let id = $(this).data("clasificaid");
               event.moveToDivs(id,lista_anterior, event);
               event._setConteo(event);
            });

        })
    },
    _allToNext: function(event) {
        let btnPrev= $('.next', event.element);
        btnPrev.on('click',function (e) {
            let element_actual=$(e.target).parent().parent().find('.clasificaItemList').data('self');
            let next_element=element_actual+1>btnPrev.length-1 ? 0 : element_actual+1;

            let lista_siguiente=$(`.clasificaItemList[data-self='${next_element}']`, event.element).data('clasificakey');
            //console.log(lista_siguiente);
            let lista= $(e.target).parent().parent().find('.clasificaItemList').find('li').not('.con_existe').filter(':visible');
            lista.each(function () {
                let id = $(this).data("clasificaid");
                if (lista_siguiente==='Prohibido' && !($vitex_globales.puede_prohibir_colores  || false)) return;
                event.moveToDivs(id,lista_siguiente, event);
               event._setConteo(event);
            });

        })
    },
    
    _setConteo:function (event=null,me=this) {
        let registros;
        if(event!==null) 
            registros=$('.numero_registros', event.element);
        else
            registros=$('.numero_registros', me.element);
        let nombre_label_registro= registros.data('label-registro');
        let set_name_label= nombre_label_registro.replace('_',' ');
        registros.remove();
        const $list= $('.clasificaFlexItem ul',this.element);
            $list.each(function () {
                const numero_hijos=$(this).find('li').length ;
               const div_conteo=$(`<div class="numero_registros" data-label-registro="${nombre_label_registro}"><p>Mostrando:</p> <span>${numero_hijos}  ${set_name_label}</span></div>`);
               div_conteo.insertAfter($(this));
            })
    },
    moveToDivs: function(clasificaid, sendTo, event) {
        let target = $(`LI[data-clasificaid="${clasificaid}"]`, event.element).first();

        if (target.parent().data('clasificakey')==='Si' && target.hasClass('con_existe')) 
            return;
        if (target.parent().data('clasificakey')==='Prohibido' && target.hasClass('con_existe')) 
            return;
        if(target.length === 0 || typeof sendTo !== 'string' || sendTo.length === 0)
            return;
        let liElement = target[0];

        if(typeof liElement === 'undefined' || liElement == null)
            return;
       // console.log("liElement", liElement);
        if(liElement.tagName !== 'LI')
            return;
        liElement = $(liElement);
        liElement.find(".clasificaToolBar").children("SPAN").each(function(){$(this).removeClass('pressed');});
        liElement.find("span[data-clasificato='" + sendTo + "']").addClass('pressed');
        target.addClass('pressed');
        let $el = $(`.clasificaItemList[data-clasificakey='${sendTo}']`, $("#" + liElement.data('clasificaconteiner') ));
        $el.append(liElement);
        liElement.hide().toggle("right");
        let sortType = $el.data('clasificame')['userSortable'];
        if(sortType === true )
            return;
        if(typeof sortType !== 'function')
            sortType = function(a, b) {
                return $(b).text().toUpperCase() < $(a).text().toUpperCase() ? 1 : -1;
            };
        $("li", $el).sort(sortType).appendTo($el);

    },
    _toolbar: function(clasificaId) {
        if(!this.options.liButtons)
            return '';
        if(typeof clasificaId === 'undefined')
            clasificaId = this.options.clasificacion[0].clasificaId;
        let buttons = [];
        for(const option in this.options.clasificacion)
          if(this.options.clasificacion.hasOwnProperty(option))  {
            const b = this.options.clasificacion[option];
            const classPressed = clasificaId === b.clasificaId ? "class='pressed'" : "";
            const label = typeof b.label === 'undefined' ? b.clasificaId.replaceAll('_', ' ') : b.label;
            const title = typeof b.title === 'undefined' ? b.label : b.title;
            buttons.push(`<span ${classPressed} data-clasificaTo="${b.clasificaId}">${label}</span>`);
        }
        return `<div class="clasificaToolBar noDrag">` + buttons.join("\r\n\t") + `</div>`;
    },

    _toolbarUnpress:function(el) {
        el.find(".clasificaToolBar").children("SPAN").each(function(){$(this).removeClass('pressed');});
    },

    _html: function() {
        let me = this;
        let grupos_options = [];
        let columns = [];
        for(const ba in this.options.clasificacion)
          if(this.options.clasificacion.hasOwnProperty(ba)) {
            
            const b = this.options.clasificacion[ba];
            const label = typeof b.label === 'undefined' ? b.clasificaId.replaceAll('_', ' ') : b.label;
            const titler = typeof b.title === 'undefined' ? label : b.title;
            const resumen = typeof this.options.resumen === 'undefined' ? '' : `<div class="clasificaResumenColumna">${this.options.resumen}</div>`;
            let indicaUserSortable = b.userSortable === true ? '<span title="Se pueden reordenar con drag & drop">↕</span>' : '';
            let opc_busqueda;
            if(b.clasificaId==='Prohibido' && !this.options.permiso_prohibido) {
                 opc_busqueda='';
            }
            else
                grupos_options.push(`<option value="${b.clasificaId}">${b[me.options.grupoMandaA]}</option>`);
            opc_busqueda=`<div>
                            ${indicaUserSortable}
                            <input type="text" value="" placeholder="🔎" class="clasificaFind"
                                data-clasificakey="${b.clasificaId}" 
                            ><span class="clasificaFindClear" 
                                data-clasificakey="${b.clasificaId}">x</span>   
                            <span title="Pasar todos, los visibles, a ${titler}" 
                                data-clasificaelementid="${this.element.attr('id')}"
                                data-clasificakey="${b.clasificaId}"
                                class="clasificaAllTo" >↴</span>
                        </div> `;
            columns.push(`
                    <div class="clasificaFlexItem" data-clasificaContainer="${b.clasificaId}">
                            <div class="clasificaItemTitle clasificaFlexRow" data-clasificaTitle="${b.clasificaId}">
                                <h3>${titler}</h3>
                                 ${opc_busqueda}
                            </div>
                            <ul class="clasificaItemList" data-clasificame="${ba}" data-self="${ba}" data-clasificakey="${b.clasificaId}"">
                            </ul>
                    </div>`
            );
        }
        let div_groups='';
        if (!me.options.modalGroup) {
            div_groups=`<div style="display: flex;justify-content: space-evenly;align-items: center;flex-wrap: wrap; gap: 10px;padding: 20px 10px;">
            <div style="display: flex;justify-content: space-evenly;align-items: center;flex-wrap: wrap;gap: 10px;">
                <label for="select_grupos">Elige un grupo</label>
                <select id="select_grupos">
                    <option value="" selected>Seleccione un grupo</option>
                </select>
                <p id="grupos_informacion" title="informacion"><i class="fa-solid fa-circle-info"></i></p>
            </div>
            
            <div id="nombre_grupo">
                <label for="opciones_drag">Elige a donde se va a mandar</label>
                <select id="opciones_drag" disabled>
                    <option value="" disabled selected>Seleccione un campo</option>
                    ${grupos_options.join("\r\n")}
                </select>
            </div>
        </div>`;
        }

        const title = this.options.title === null ?
            this.options.valueColumnKey.replaceAll('_', ' ') :
            this.options.title;

        return `<div style="padding:0.75em 0.5em"><div class="clasificaTitle">${title}</div>${div_groups}<div class="clasificaFlexRow">`+ columns.join("\r\n") + `\r\n</div></div>`;
    },

    _llenandoGroup:async function(input,me=this){
        await $.ajax({
            url: me.options.getGrupos.url,
            method: 'GET',
            cache: false,
            data: {accion:me.options.getGrupos.accion, tipo:me.options.getGrupos.tipo},
            dataType: 'json',
        })
        .done(function(data, textStatus, jqXHR) {
            if(!data.status) {
                ia.alertError(data.message || "Error inesperado, intente más tarde.", "Error");
                console.log("ajax failed url:", this.url);
                return;
            }
            input.empty();
            input.append(`<option value="" selected>Seleccione un grupo</option>`);
            input.append(data.opciones);
        })
        .fail(function(jqXHR, textStatus, errorThrown) {
            //ia.alertError(`Problemas al comunicarme con el server: <ul><lI>${errorThrown}<li>${textStatus}</ul>`, "Error", true);
            console.log('ajax failed: ' + this.url, arguments);
        });
    },
     _llenandoUsers:function(e, me=this){
        let nombre_grupo=$('#select_grupos', me.element).val();
        if (!nombre_grupo || me.options.sortGroup===[]) {
            let alert=  $('<div id="alerta" class="alert alert-danger" role="alert">Debes seleccionar un grupo</div>').appendTo('.ui-dialog-buttonpane.ui-widget-content.ui-helper-clearfix').css({
                background: '#f8d7da',
                color: '#721c24',
                border: '1px solid #f5c6cb',
                padding: '0.55rem 1.25rem',
                marginBottom: '1rem',
                width: '40%',
                borderLeft: '5px solid #721c24',
                opacity: 0,
            });

            alert.animate({opacity: 1});
            setTimeout(() => {
                alert.remove();
            }, 5000);
            return;
        }
       
        me.options.sortGroup.forEach(user => {
            me.moveTo(user, e.target.value)
        });
       let opc=[];
       opc.push(`<option value="" selected disabled>Selecciona una opción</option>`)
       $(".clasificaFlexItem", me.element).each(function(){
              opc.push(`<option value="${$(this).data('clasificacontainer')}">${$(this).data('clasificacontainer')}</option>`);
       });
        $(e.target).prop('disabled', true);
        $(e.target).empty();
        $(e.target).append(opc.join("\r\n"));
        me._llenandoGroup($('#select_grupos', me.element))
        $('#grupos_informacion', me.element).prop('title','información');
        $('.bg-selected',me.element).removeClass('bg-selected').removeAttr('title');
    },
    _llenandoItems:function(e, me=this){
        let nombre_grupo=$('#select_grupos', me.element).val();
        let informacion=$('#grupos_informacion', me.element)
        if(!nombre_grupo) {
            $('#opciones_drag', me.element)
                .prop('disabled',true)
                .val('');
            $('.bg-selected',me.element).removeClass('bg-selected').removeAttr('title');
            return;
        }
       $.ajax({
            url:  me.options.getGruposItems.url,
            method: 'GET',
            cache: false,
            data: {accion: me.options.getGruposItems.accion, nombre_grupo, tipo: me.options.getGruposItems.tipo},
            dataType: 'json',
        })
        .done(function(data, textStatus, jqXHR) {
            if(!data.status) {
                ia.alertError(data.message || "Error inesperado, intente más tarde.", "Error");
                console.log("ajax failed url:", this.url);
                return;
            }
            informacion.prop('title',data.usuarios.join(' ,'));
            me.options.sortGroup=data.opciones
            $('i').tooltip();


            let divContainer= e.target.closest('div.container_clasificame');
            $('.bg-selected',divContainer).removeClass('bg-selected').removeAttr('title');
            data.opciones.forEach(user => {
                //buscando el usuario
               let user_find=$(divContainer).find(`li[data-clasificaid='${user}']`)
               if(user_find.length===0) user_find= $(`li[data-clasificaid='${user}']`);

                user_find
                    .addClass('bg-selected')
                    .attr('title','Usuario seleccionado')
                    .tooltip();
            });

        })
        .fail(function(jqXHR, textStatus, errorThrown) {
            ia.alertError(`Problemas al comunicarme con el server: <ul><lI>${errorThrown}<li>${textStatus}</ul>`, "Error", true);
            console.log('ajax failed: ' + this.url, arguments);
        });
    },
    _findClear:function(event) {
        $('.clasifica-globalSearchInput', this.element).val('');
        let $element = $(event.target);
        let clasificakey = $element.data('clasificakey');
        $(`INPUT[data-clasificakey='${clasificakey}']`).val('');
        $(`UL[data-clasificakey='${clasificakey}']`).children("li").show();

        const registros=$('.numero_registros');
        let nombre_label_registro= registros.data('label-registro');
        let set_name_label= nombre_label_registro.replace('_',' ');
        registros.remove();
        const $list= $('.clasificaFlexItem ul',this.element);
            $list.each(function () {
                const numero_hijos=$(this).find('li').filter(':visible').length ;
               const div_conteo=$(`<div class="numero_registros" data-label-registro="${nombre_label_registro}"><p>Mostrando:</p> <span>${numero_hijos}  ${set_name_label}</span></div>`);
               div_conteo.insertAfter($(this));
            });
    },

    _find: function(event, reference) {
        $('.clasifica-globalSearchInput', this.element).val('');
        let $element = $(event.target);
        let clasificakey = $element.data('clasificakey');
        let $li = $(`UL[data-clasificakey='${clasificakey}']`, reference).children("li");
        if($li.length === 0) {
            return;
        }
        let searchFor = $element.val().trim().replace(/\s+/gm, ' ')
            .normalize('NFD').replace(/[\u0300-\u036f]/g, '').toLowerCase();
        if(searchFor.length === 0) {
            $li.children("li").show();
            return;
        }

        $li.each(function(){
          let $el = $(this);
          if($el.children().first().text().normalize('NFD')
              .replace(/[\u0300-\u036f]/g, '').toLowerCase().search(searchFor)>=0)
              $el.show();
          else
              $el.hide();
        });

        const registros=$('.numero_registros');
        let nombre_label_registro= registros.data('label-registro');
        let set_name_label= nombre_label_registro.replace('_',' ');
        registros.remove();
        const $list= $('.clasificaFlexItem ul',this.element);
            $list.each(function () {
                const numero_hijos=$(this).find('li').filter(':visible').length ;
               const div_conteo=$(`<div class="numero_registros" data-label-registro="${nombre_label_registro}"><p>Mostrando:</p> <span>${numero_hijos}  ${set_name_label}</span></div>`);
               div_conteo.insertAfter($(this));
            })

    },

    _addGlobalSearch: function() {
        let me = this;
        let $globalSearch = $(`
      <div class="clasifica-globalSearch" style="margin: 10px 0; display: flex; align-items: center; width: 100%; justify-content: center;">
        <input type="text" placeholder="🔎 Busca" class="clasifica-globalSearchInput" style="padding: 5px; width: 300px; margin-right: 5px;">
        <span class="clasifica-globalSearchClear" style="cursor: pointer; color: silver;">✕</span>
      </div>
    `);
        $(this.element).find('.clasificaFlexRow').first().before($globalSearch);
        $('.clasifica-globalSearchInput', this.element).on('keyup', function() {
            $('.clasificaFind', me.element).val('');
            me._globalFind($(this).val().trim());
        });
        $('.clasifica-globalSearchClear', this.element).on('click', function() {
            $('.clasifica-globalSearchInput', me.element).val('');
            me._globalFind(''); // Clear all filters
        });
    },

    _globalFind: function(searchText) {
        let me = this;

        if (searchText.length === 0) {
            $(this._selector, this.element).each(function() {
                $(this).find('LI').show();
            });
        } else {
            let normalizedSearch = searchText.toLowerCase()
                .normalize('NFD').replace(/[\u0300-\u036f]/g, '');
            $(this._selector, this.element).each(function() {
                let $list = $(this);

                $list.find('LI').each(function() {
                    let $item = $(this);
                    let itemText = $item.children().first().text()
                        .toLowerCase()
                        .normalize('NFD')
                        .replace(/[\u0300-\u036f]/g, '');

                    if (itemText.includes(normalizedSearch)) {
                        $item.show();
                    } else {
                        $item.hide();
                    }
                });
            });
        }
        this._updateCounters();
    },

    _updateCounters: function() {
        const registros = $('.numero_registros', this.element);
        if (registros.length === 0) return;

        let nombre_label_registro = registros.data('label-registro');
        let set_name_label = nombre_label_registro.replace('_', ' ');
        registros.remove();

        const $list = $('.clasificaFlexItem ul', this.element);
        $list.each(function() {
            const numero_hijos = $(this).find('li').filter(':visible').length;
            const div_conteo = $(`<div class="numero_registros" data-label-registro="${nombre_label_registro}"><p>Mostrando:</p> <span>${numero_hijos} ${set_name_label}</span></div>`);
            div_conteo.insertAfter($(this));
        });
    },

    
    moveTo: function(clasificaid, sendTo, me=this) {
        let target = $(`LI[data-clasificaid="${clasificaid}"]`, me.element);
        if (target.parent().data('clasificakey')==='Si' && target.hasClass('con_existe')) 
            return;
        if (target.parent().data('clasificakey')==='Prohibido' && target.hasClass('con_existe')) 
            return;
        if(target.length === 0 || typeof sendTo !== 'string' || sendTo.length === 0)
            return;
        let liElement = target[0];

        if(typeof liElement === 'undefined' || liElement == null)
            return;
       // console.log("liElement", liElement);
        if(liElement.tagName !== 'LI')
            return;
        liElement = $(liElement);
        liElement.find(".clasificaToolBar").children("SPAN").each(function(){$(this).removeClass('pressed');});
        liElement.find("span[data-clasificato='" + sendTo + "']").addClass('pressed');
        target.addClass('pressed');
        let $el = $(`.clasificaItemList[data-clasificakey='${sendTo}']`, me.element );
        $el.append(liElement);
        liElement.hide().toggle("right");

        let sortType = $el.data('clasificame')['userSortable'];
        if(sortType === true )
            return;
        if(typeof sortType !== 'function')
            sortType = function(a, b) {
                return $(b).text().toUpperCase() < $(a).text().toUpperCase() ? 1 : -1;
            };
        $("li", $el).sort(sortType).appendTo($el);
        me._setConteo();

    },

    _clickTo:function(event) {
        event.stopImmediatePropagation();
        event.stopPropagation();
        let target = $(event.target);
        if($(event.target).hasClass('pressed')) return;
        const sendTo = target.data('clasificato');
        if(sendTo === 'Prohibido' && !($vitex_globales.puede_prohibir_colores || false)) return;
        if(typeof sendTo !== 'string' || sendTo.length === 0)
            return;
        let liElement = $(this).parent();
        //Put permisos
        if (liElement.hasClass('con_existe') && liElement.parent().data('clasificakey')==='Si') return
        if(typeof liElement === 'undefined' || liElement == null)
            return;
        if(liElement[0].tagName !== 'LI')
            return;
        liElement.find(".clasificaToolBar").children("SPAN").each(function(){$(this).removeClass('pressed');});
        target.addClass('pressed');
        let $el = $(`.clasificaItemList[data-clasificakey='${sendTo}']`, $("#" + liElement.data('clasificaconteiner') ));
        let sortType = $el.data('clasificame')['userSortable'] || true;
        $el.append(liElement);
        liElement.hide().toggle("right");


        if(sortType !== true) {
            if(typeof sortType !== 'function')
                sortType = function(a, b) {
                    return $(b).text().toUpperCase() < $(a).text().toUpperCase() ? 1 : -1;
                };
            $("li", $el).sort(sortType).appendTo($el);
        }

        //muestra el numero de registros
        const registros=$('.numero_registros');
        let nombre_label_registro= registros.data('label-registro');
        let set_name_label= nombre_label_registro.replace('_',' ');
        registros.remove();
        const $list= $('.clasificaFlexItem ul',this.element);
            $list.each(function () {
                const numero_hijos=$(this).find('li').filter(':visible').length ;
               const div_conteo=$(`<div class="numero_registros" data-label-registro="${nombre_label_registro}"><p>Mostrando:</p> <span>${numero_hijos}  ${set_name_label}</span></div>`);
               div_conteo.insertAfter($(this));
            })
    },

    _sortMe: function(element) {
        let sortType = $(element).data('clasificame')['userSortable'];
        if(sortType === true)
            return;
        if(typeof sortType !== 'function')
            sortType = function(a, b) {
                return $(b).text().toUpperCase() < $(a).text().toUpperCase() ? 1 : -1;
            };
        $("li", element).sort(sortType).appendTo(element);
    },

    setValues: function (new_values = []) {
        this.clear();
        this.addValues(new_values);
        this.options['values'] = new_values;
        this.refresh();
    },

    restore: function () {
        this.setValues(this.options['values']);
    }

});
